/*
 * Decompiled with CFR 0.152.
 */
package de.mud.ssh;

import de.mud.jta.Wrapper;
import de.mud.ssh.SshIO;
import java.awt.Dimension;
import java.io.IOException;

public class SshWrapper
extends Wrapper {
    protected SshIO handler = new SshIO(){

        public String getTerminalType() {
            return "vt320";
        }

        public Dimension getWindowSize() {
            return new Dimension(80, 25);
        }

        public void setLocalEcho(boolean echo) {
        }

        public void write(byte[] b) throws IOException {
            SshWrapper.this.out.write(b);
        }
    };
    private static final int debug = 0;
    private byte[] buffer;
    private int pos;

    public String send(String cmd) throws IOException {
        byte[] arr = (cmd + "\n").getBytes();
        for (int i = 0; i < arr.length; ++i) {
            switch (arr[i]) {
                case 10: {
                    arr[i] = 13;
                }
            }
        }
        this.handler.sendData(new String(arr));
        if (this.getPrompt() != null) {
            return this.waitfor(this.getPrompt());
        }
        return null;
    }

    public int read(byte[] b) throws IOException {
        if (this.buffer != null) {
            int amount = this.buffer.length - this.pos <= b.length ? this.buffer.length - this.pos : b.length;
            System.arraycopy(this.buffer, this.pos, b, 0, amount);
            if (this.pos + amount < this.buffer.length) {
                this.pos += amount;
            } else {
                this.buffer = null;
            }
            return amount;
        }
        int n = this.in.read(b);
        if (n > 0) {
            byte[] tmp = new byte[n];
            System.arraycopy(b, 0, tmp, 0, n);
            this.pos = 0;
            this.buffer = this.handler.handleSSH(tmp);
            if (this.buffer != null && this.buffer.length > 0) {
                int amount = this.buffer.length <= b.length ? this.buffer.length : b.length;
                System.arraycopy(this.buffer, 0, b, 0, amount);
                this.pos = n = amount;
                if (amount == this.buffer.length) {
                    this.buffer = null;
                    this.pos = 0;
                }
            } else {
                return 0;
            }
        }
        return n;
    }
}

