/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.alias;

import java.util.Map;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesAction;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.action.support.master.AcknowledgedRequestBuilder;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.metadata.AliasAction;
import org.elasticsearch.index.query.QueryBuilder;

public class IndicesAliasesRequestBuilder
extends AcknowledgedRequestBuilder<IndicesAliasesRequest, IndicesAliasesResponse, IndicesAliasesRequestBuilder> {
    public IndicesAliasesRequestBuilder(ElasticsearchClient client, IndicesAliasesAction action) {
        super(client, action, new IndicesAliasesRequest());
    }

    public IndicesAliasesRequestBuilder addAlias(String index, String alias) {
        ((IndicesAliasesRequest)this.request).addAlias(alias, index);
        return this;
    }

    public IndicesAliasesRequestBuilder addAlias(String[] indices, String alias) {
        ((IndicesAliasesRequest)this.request).addAlias(alias, indices);
        return this;
    }

    public IndicesAliasesRequestBuilder addAlias(String index, String alias, String filter) {
        IndicesAliasesRequest.AliasActions action = new IndicesAliasesRequest.AliasActions(AliasAction.Type.ADD, index, alias).filter(filter);
        ((IndicesAliasesRequest)this.request).addAliasAction(action);
        return this;
    }

    public IndicesAliasesRequestBuilder addAlias(String[] indices, String alias, String filter) {
        IndicesAliasesRequest.AliasActions action = new IndicesAliasesRequest.AliasActions(AliasAction.Type.ADD, indices, alias).filter(filter);
        ((IndicesAliasesRequest)this.request).addAliasAction(action);
        return this;
    }

    public IndicesAliasesRequestBuilder addAlias(String[] indices, String alias, Map<String, Object> filter) {
        ((IndicesAliasesRequest)this.request).addAlias(alias, filter, indices);
        return this;
    }

    public IndicesAliasesRequestBuilder addAlias(String index, String alias, Map<String, Object> filter) {
        ((IndicesAliasesRequest)this.request).addAlias(alias, filter, index);
        return this;
    }

    public IndicesAliasesRequestBuilder addAlias(String[] indices, String alias, QueryBuilder filterBuilder) {
        ((IndicesAliasesRequest)this.request).addAlias(alias, filterBuilder, indices);
        return this;
    }

    public IndicesAliasesRequestBuilder addAlias(String index, String alias, QueryBuilder filterBuilder) {
        ((IndicesAliasesRequest)this.request).addAlias(alias, filterBuilder, index);
        return this;
    }

    public IndicesAliasesRequestBuilder removeAlias(String index, String alias) {
        ((IndicesAliasesRequest)this.request).removeAlias(index, alias);
        return this;
    }

    public IndicesAliasesRequestBuilder removeAlias(String[] indices, String ... aliases) {
        ((IndicesAliasesRequest)this.request).removeAlias(indices, aliases);
        return this;
    }

    public IndicesAliasesRequestBuilder removeAlias(String index, String[] aliases) {
        ((IndicesAliasesRequest)this.request).removeAlias(index, aliases);
        return this;
    }

    public IndicesAliasesRequestBuilder addAliasAction(AliasAction aliasAction) {
        ((IndicesAliasesRequest)this.request).addAliasAction(aliasAction);
        return this;
    }

    public IndicesAliasesRequestBuilder addAliasAction(IndicesAliasesRequest.AliasActions action) {
        ((IndicesAliasesRequest)this.request).addAliasAction(action);
        return this;
    }
}

