/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.layer;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.dialogs.IEnabledStateUpdating;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public final class DeleteLayerAction
extends AbstractAction
implements IEnabledStateUpdating,
Layer.LayerAction {
    private final LayerListDialog.LayerListModel model;

    public DeleteLayerAction(LayerListDialog.LayerListModel layerListModel) {
        this.model = layerListModel;
        new ImageProvider("dialogs", "delete").getResource().attachImageIcon(this, true);
        this.putValue("ShortDescription", I18n.tr("Delete the selected layers.", new Object[0]));
        this.putValue("Name", I18n.tr("Delete", new Object[0]));
        this.putValue("help", HelpUtil.ht("/Dialog/LayerList#DeleteLayer"));
        this.updateEnabledState();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        List<Layer> list = this.model.getSelectedLayers();
        if (list.isEmpty()) {
            return;
        }
        if (!Main.saveUnsavedModifications(list, false)) {
            return;
        }
        for (Layer layer : list) {
            Main.getLayerManager().removeLayer(layer);
        }
    }

    @Override
    public void updateEnabledState() {
        this.setEnabled(!this.model.getSelectedLayers().isEmpty());
    }

    @Override
    public Component createMenuComponent() {
        return new JMenuItem(this);
    }

    @Override
    public boolean supportLayers(List<Layer> list) {
        return true;
    }

    public boolean equals(Object object) {
        return object instanceof DeleteLayerAction;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

