/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.StatefullComponent;
import org.jfree.layouting.input.style.PseudoPage;
import org.jfree.layouting.layouter.context.LayoutStyle;
import org.jfree.layouting.layouter.context.PageContext;
import org.jfree.layouting.normalizer.content.NormalizationException;
import org.jfree.layouting.output.OutputProcessor;
import org.jfree.layouting.renderer.AbstractRenderer;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.process.CleanStreamedBoxesStep;
import org.jfree.layouting.renderer.process.ComputeBreakabilityStep;
import org.jfree.layouting.renderer.process.ComputeICMMetricsStep;
import org.jfree.layouting.renderer.process.ComputeMarginsStep;
import org.jfree.layouting.renderer.process.ComputeStaticPropertiesStep;
import org.jfree.layouting.renderer.process.ComputeTableICMMetricsStep;
import org.jfree.layouting.renderer.process.InfiniteMajorAxisLayoutStep;
import org.jfree.layouting.renderer.process.InfiniteMinorAxisLayoutStep;
import org.jfree.layouting.renderer.process.ParagraphLineBreakStep;
import org.jfree.layouting.renderer.process.SimplePaginationStep;
import org.jfree.layouting.renderer.process.TableRowHeightStep;
import org.jfree.layouting.renderer.process.TableValidationStep;
import org.jfree.layouting.renderer.process.UpdateTokensStep;
import org.jfree.layouting.renderer.process.ValidateModelStep;

public class StreamingRenderer
extends AbstractRenderer {
    private ValidateModelStep validateModelStep;
    private TableValidationStep tableValidationStep;
    private ComputeStaticPropertiesStep staticPropertiesStep;
    private ComputeMarginsStep marginsStep;
    private ComputeICMMetricsStep icmMetricsStep;
    private ComputeTableICMMetricsStep tableICMMetricsStep;
    private ParagraphLineBreakStep paragraphLinebreakStep;
    private InfiniteMinorAxisLayoutStep minorAxisLayoutStep;
    private InfiniteMajorAxisLayoutStep majorAxisLayoutStep;
    private TableRowHeightStep tableRowHeightStep;
    private ComputeBreakabilityStep breakabilityStep;
    private SimplePaginationStep paginationStep;
    private CleanStreamedBoxesStep cleanBoxesStep;
    private UpdateTokensStep updateTokensStep;

    protected StreamingRenderer(LayoutProcess layoutProcess, boolean bl) {
        super(layoutProcess, bl);
        if (bl) {
            this.validateModelStep = new ValidateModelStep();
            this.staticPropertiesStep = new ComputeStaticPropertiesStep();
            this.tableValidationStep = new TableValidationStep();
            this.marginsStep = new ComputeMarginsStep();
            this.paragraphLinebreakStep = new ParagraphLineBreakStep();
            this.icmMetricsStep = new ComputeICMMetricsStep();
            this.tableICMMetricsStep = new ComputeTableICMMetricsStep();
            this.minorAxisLayoutStep = new InfiniteMinorAxisLayoutStep();
            this.majorAxisLayoutStep = new InfiniteMajorAxisLayoutStep();
            this.tableRowHeightStep = new TableRowHeightStep();
            this.breakabilityStep = new ComputeBreakabilityStep();
            this.paginationStep = new SimplePaginationStep();
            this.cleanBoxesStep = new CleanStreamedBoxesStep();
            this.updateTokensStep = new UpdateTokensStep();
        }
    }

    public StreamingRenderer(LayoutProcess layoutProcess) {
        this(layoutProcess, true);
    }

    protected void validateOutput() throws NormalizationException {
        OutputProcessor outputProcessor = this.getLayoutProcess().getOutputProcessor();
        LogicalPageBox logicalPageBox = this.getLogicalPageBox();
        if (!outputProcessor.getMetaData().isIterative() && logicalPageBox.isOpen()) {
            return;
        }
        if (!this.validateModelStep.isLayoutable(logicalPageBox)) {
            return;
        }
        this.tableValidationStep.validate(logicalPageBox);
        this.updateTokensStep.compute(logicalPageBox, this.getLayoutProcess(), this.getPageContext());
        this.staticPropertiesStep.compute(logicalPageBox);
        this.marginsStep.compute(logicalPageBox);
        this.paragraphLinebreakStep.compute(logicalPageBox);
        this.icmMetricsStep.compute(logicalPageBox);
        this.tableICMMetricsStep.compute(logicalPageBox);
        this.minorAxisLayoutStep.compute(logicalPageBox);
        this.majorAxisLayoutStep.compute(logicalPageBox);
        this.tableRowHeightStep.compute(logicalPageBox);
        this.breakabilityStep.compute(logicalPageBox);
        this.paginationStep.performPagebreak(logicalPageBox);
        outputProcessor.processContent(logicalPageBox);
        if (logicalPageBox.isOpen()) {
            this.firePagebreak();
            this.cleanBoxesStep.compute(logicalPageBox);
        } else {
            outputProcessor.processingFinished();
        }
    }

    protected void firePagebreak() throws NormalizationException {
        PageContext pageContext = this.getRenderPageContext().getPageContext();
        LayoutStyle layoutStyle = pageContext.getStyle();
        this.getLayoutProcess().pageBreakEncountered(null, new PseudoPage[0]);
    }

    public State saveState() throws StateException {
        return new DefaultFlowRendererState(this);
    }

    protected static class DefaultFlowRendererState
    extends AbstractRenderer.RendererState {
        private ValidateModelStep validateModelStep;
        private TableValidationStep tableValidationStep;
        private ComputeStaticPropertiesStep staticPropertiesStep;
        private ComputeMarginsStep marginsStep;
        private ComputeICMMetricsStep icmMetricsStep;
        private ComputeTableICMMetricsStep tableICMMetricsStep;
        private ParagraphLineBreakStep paragraphLinebreakStep;
        private InfiniteMinorAxisLayoutStep minorAxisLayoutStep;
        private InfiniteMajorAxisLayoutStep majorAxisLayoutStep;
        private TableRowHeightStep tableRowHeightStep;
        private ComputeBreakabilityStep breakabilityStep;
        private SimplePaginationStep paginationStep;
        private CleanStreamedBoxesStep cleanBoxesStep;
        private UpdateTokensStep updateTokensStep;

        protected DefaultFlowRendererState(StreamingRenderer streamingRenderer) throws StateException {
            super(streamingRenderer);
            this.validateModelStep = streamingRenderer.validateModelStep;
            this.tableValidationStep = streamingRenderer.tableValidationStep;
            this.staticPropertiesStep = streamingRenderer.staticPropertiesStep;
            this.marginsStep = streamingRenderer.marginsStep;
            this.icmMetricsStep = streamingRenderer.icmMetricsStep;
            this.tableICMMetricsStep = streamingRenderer.tableICMMetricsStep;
            this.paragraphLinebreakStep = streamingRenderer.paragraphLinebreakStep;
            this.minorAxisLayoutStep = streamingRenderer.minorAxisLayoutStep;
            this.majorAxisLayoutStep = streamingRenderer.majorAxisLayoutStep;
            this.tableRowHeightStep = streamingRenderer.tableRowHeightStep;
            this.breakabilityStep = streamingRenderer.breakabilityStep;
            this.paginationStep = streamingRenderer.paginationStep;
            this.cleanBoxesStep = streamingRenderer.cleanBoxesStep;
            this.updateTokensStep = streamingRenderer.updateTokensStep;
        }

        public StatefullComponent restore(LayoutProcess layoutProcess) throws StateException {
            StreamingRenderer streamingRenderer = new StreamingRenderer(layoutProcess, false);
            this.fill(streamingRenderer, layoutProcess);
            streamingRenderer.validateModelStep = this.validateModelStep;
            streamingRenderer.tableValidationStep = this.tableValidationStep;
            streamingRenderer.staticPropertiesStep = this.staticPropertiesStep;
            streamingRenderer.marginsStep = this.marginsStep;
            streamingRenderer.icmMetricsStep = this.icmMetricsStep;
            streamingRenderer.tableICMMetricsStep = this.tableICMMetricsStep;
            streamingRenderer.paragraphLinebreakStep = this.paragraphLinebreakStep;
            streamingRenderer.minorAxisLayoutStep = this.minorAxisLayoutStep;
            streamingRenderer.majorAxisLayoutStep = this.majorAxisLayoutStep;
            streamingRenderer.tableRowHeightStep = this.tableRowHeightStep;
            streamingRenderer.paginationStep = this.paginationStep;
            streamingRenderer.cleanBoxesStep = this.cleanBoxesStep;
            streamingRenderer.breakabilityStep = this.breakabilityStep;
            streamingRenderer.updateTokensStep = this.updateTokensStep;
            return streamingRenderer;
        }
    }
}

