/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.scripted;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.scripted.InternalScriptedMetric;
import org.elasticsearch.search.aggregations.metrics.scripted.ScriptedMetricParser;

public class ScriptedMetricBuilder
extends MetricsAggregationBuilder<ScriptedMetricBuilder> {
    private Script initScript = null;
    private Script mapScript = null;
    private Script combineScript = null;
    private Script reduceScript = null;
    private Map<String, Object> params = null;

    public ScriptedMetricBuilder(String name) {
        super(name, InternalScriptedMetric.TYPE.name());
    }

    public ScriptedMetricBuilder initScript(Script initScript) {
        this.initScript = initScript;
        return this;
    }

    public ScriptedMetricBuilder mapScript(Script mapScript) {
        this.mapScript = mapScript;
        return this;
    }

    public ScriptedMetricBuilder combineScript(Script combineScript) {
        this.combineScript = combineScript;
        return this;
    }

    public ScriptedMetricBuilder reduceScript(Script reduceScript) {
        this.reduceScript = reduceScript;
        return this;
    }

    public ScriptedMetricBuilder params(Map<String, Object> params) {
        this.params = params;
        return this;
    }

    @Override
    protected void internalXContent(XContentBuilder builder, ToXContent.Params builderParams) throws IOException {
        if (this.initScript != null) {
            builder.field(ScriptedMetricParser.INIT_SCRIPT_FIELD.getPreferredName(), this.initScript);
        }
        if (this.mapScript != null) {
            builder.field(ScriptedMetricParser.MAP_SCRIPT_FIELD.getPreferredName(), this.mapScript);
        }
        if (this.combineScript != null) {
            builder.field(ScriptedMetricParser.COMBINE_SCRIPT_FIELD.getPreferredName(), this.combineScript);
        }
        if (this.reduceScript != null) {
            builder.field(ScriptedMetricParser.REDUCE_SCRIPT_FIELD.getPreferredName(), this.reduceScript);
        }
        if (this.params != null) {
            builder.field(ScriptedMetricParser.PARAMS_FIELD.getPreferredName());
            builder.map(this.params);
        }
    }
}

