#
# Author:: Celso Fernandes (<fernandes@zertico.com>)
# © Copyright IBM Corporation 2014.
#
# LICENSE: MIT (http://opensource.org/licenses/MIT)
#
module Fog
  module Softlayer
    class Product

      class Mock
        def get_package_items(package_id)
          response = Excon::Response.new
          response.body = fixtures_package_items(package_id)
          response.status = 200
          return response
        end

      end

      class Real
        def get_package_items(package_id)
          request(:product_package, package_id.to_s + '/getItems', query: 'queryEngineVersion=2&objectMask=id;capacity;description;itemTaxCategoryId;keyName;softwareDescriptionId;units;upgradeItemId')
        end
      end
    end
  end
end

module Fog
  module Softlayer
    class Product
      class Mock
        def fixtures_package_items(id)
          fixture_package_items = Array.new
          fixture_package_items[0] = [{"capacity"=>"10", "description"=>"10Mbps Hardware Firewall", "id"=>299, "itemTaxCategoryId"=>166, "keyName"=>"10MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"20", "description"=>"20 GB NAS", "id"=>40, "itemTaxCategoryId"=>166, "keyName"=>"NAS_20_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>41}, {"capacity"=>"100", "description"=>"100 GB iSCSI SAN Storage", "id"=>551, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_100_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>575}, {"capacity"=>"40", "description"=>"40GB EVault Disk to Disk Enterprise Backup", "id"=>559, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_40_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>3784}, {"capacity"=>"1000", "description"=>"1000GB EVault Disk to Disk Enterprise Backup", "id"=>563, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_1000_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4185}, {"capacity"=>"200", "description"=>"Load Balancer 200 connections", "id"=>568, "itemTaxCategoryId"=>166, "keyName"=>"LOAD_BALANCER_200_CONNECTIONS", "softwareDescriptionId"=>nil, "units"=>"Connections/Second", "upgradeItemId"=>569}, {"capacity"=>"430", "description"=>"430 GB iSCSI SAN Storage", "id"=>623, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_430_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>624}, {"capacity"=>"350", "description"=>"350 GB iSCSI SAN Snapshot Space", "id"=>703, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_SNAPSHOT_350_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>704}, {"capacity"=>"20", "description"=>"20 GB iSCSI SAN Replication", "id"=>711, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_REPLICATION_20_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"CDN 2000 GB Bandwidth", "id"=>895, "itemTaxCategoryId"=>166, "keyName"=>"CDN_2000_GB_BANDWIDTH", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2000GB EVault Disk to Disk Enterprise Backup", "id"=>955, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_2000_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"IPSEC - Standard", "id"=>1092, "itemTaxCategoryId"=>166, "keyName"=>"IPSEC_STANDARD", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"2", "description"=>"QuickSSL Premium - 2 year", "id"=>1294, "itemTaxCategoryId"=>166, "keyName"=>"SSL_CERTIFICATE_QUICKSSL_PREMIUM_2_YEAR", "softwareDescriptionId"=>nil, "units"=>"DV", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Dedicated Rack (Half)", "id"=>1302, "itemTaxCategoryId"=>166, "keyName"=>"DEDICATED_RACK_HALF", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Dedicated Rack (Full)", "id"=>1303, "itemTaxCategoryId"=>166, "keyName"=>"DEDICATED_RACK_FULL", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"1 Static Public IP Address", "id"=>3937, "itemTaxCategoryId"=>166, "keyName"=>"1_STATIC_PUBLIC_IP_ADDRESS", "softwareDescriptionId"=>nil, "units"=>"IPs", "upgradeItemId"=>nil}, {"capacity"=>"32", "description"=>"32 Portable Private IP Addresses", "id"=>3949, "itemTaxCategoryId"=>166, "keyName"=>"32_PORTABLE_PRIVATE_IP_ADDRESSES", "softwareDescriptionId"=>nil, "units"=>"IPs", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>".com - 1 year", "id"=>4036, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_COM_1_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"9", "description"=>".com - 9 year", "id"=>4028, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_COM_9_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"2", "description"=>".net - 2 year", "id"=>4001, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_NET_2_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>".net - 5 year", "id"=>4030, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_NET_5_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"9", "description"=>".net - 9 year", "id"=>4019, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_NET_9_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>".org - 1 year", "id"=>4038, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_ORG_1_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"8", "description"=>".biz - 8 year", "id"=>4022, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_BIZ_8_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"7", "description"=>".info - 7 year", "id"=>4052, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_INFO_7_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Reseller Domain Credit", "id"=>4065, "itemTaxCategoryId"=>162, "keyName"=>"RESELLER_DOMAIN_CREDIT", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"350", "description"=>"350GB EVault Disk to Disk Enterprise Backup", "id"=>4183, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_350_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>562}, {"capacity"=>"750", "description"=>"750GB EVault Disk to Disk Enterprise Backup", "id"=>4184, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_750_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>563}, {"capacity"=>"0", "description"=>"Global IPv4", "id"=>4186, "itemTaxCategoryId"=>166, "keyName"=>"GLOBAL_IPV4", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"100000", "description"=>"Message Queue Pay as You Go", "id"=>4210, "itemTaxCategoryId"=>166, "keyName"=>"MESSAGE_QUEUE_PAY_AS_YOU_GO", "softwareDescriptionId"=>nil, "units"=>"COUNT", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix CRVL", "id"=>4078, "itemTaxCategoryId"=>166, "keyName"=>"CITRIX_CRVL", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"Citrix NetScaler VPX 10.1 10Mbps Standard", "id"=>4425, "itemTaxCategoryId"=>166, "keyName"=>"CITRIX_NETSCALER_VPX_10_1_10MBPS_STANDARD", "softwareDescriptionId"=>1182, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"200", "description"=>"Citrix NetScaler VPX 10.1 200Mbps Platinum", "id"=>4426, "itemTaxCategoryId"=>166, "keyName"=>"CITRIX_NETSCALER_VPX_10_1_200MBPS_PLATINUM", "softwareDescriptionId"=>1183, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"1500", "description"=>"1500 GB iSCSI SAN Replication", "id"=>4576, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_REPLICATION_1500_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"Citrix NetScaler VPX 10.5 1000Mbps Standard", "id"=>5910, "itemTaxCategoryId"=>166, "keyName"=>"CITRIX_NETSCALER_VPX_10_5_1000MBPS_STANDARD", "softwareDescriptionId"=>1380, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"200", "description"=>"Citrix NetScaler VPX 10.5 200Mbps Standard", "id"=>5918, "itemTaxCategoryId"=>166, "keyName"=>"CITRIX_NETSCALER_VPX_10_5_200MBPS_STANDARD", "softwareDescriptionId"=>1376, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"80", "description"=>"80 GB NAS", "id"=>42, "itemTaxCategoryId"=>166, "keyName"=>"NAS_80_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>43}, {"capacity"=>"250", "description"=>"250 GB NAS", "id"=>44, "itemTaxCategoryId"=>166, "keyName"=>"NAS_250_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>411}, {"capacity"=>"80", "description"=>"80 GB iSCSI SAN Storage", "id"=>550, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_80_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>551}, {"capacity"=>"250", "description"=>"250GB EVault Disk to Disk Enterprise Backup", "id"=>561, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_250_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4183}, {"description"=>"EVault Plugin - Oracle", "id"=>610, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_PLUGIN_ORACLE", "softwareDescriptionId"=>177, "upgradeItemId"=>nil}, {"capacity"=>"200", "description"=>"CDN Account with 200 GB Bandwidth", "id"=>647, "itemTaxCategoryId"=>166, "keyName"=>"CDN_ACCOUNT_WITH_200_GB_BANDWIDTH", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"60", "description"=>"60 GB iSCSI SAN Snapshot Space", "id"=>696, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_SNAPSHOT_60_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>697}, {"capacity"=>"500", "description"=>"500 GB iSCSI SAN Snapshot Space", "id"=>706, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_SNAPSHOT_500_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>707}, {"capacity"=>"600", "description"=>"600 GB iSCSI SAN Snapshot Space", "id"=>707, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_SNAPSHOT_600_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>708}, {"capacity"=>"2000", "description"=>"2000 GB iSCSI SAN Replication", "id"=>727, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_REPLICATION_2000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"30", "description"=>"30GB EVault Disk to Disk Enterprise Backup", "id"=>739, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_30_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>559}, {"capacity"=>"50", "description"=>"CDN 50 GB Storage", "id"=>897, "itemTaxCategoryId"=>166, "keyName"=>"CDN_50_GB_STORAGE", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Symantec Secure Site with EV - 1 year", "id"=>968, "itemTaxCategoryId"=>166, "keyName"=>"SSL_CERTIFICATE_SYMANTEC_SECURE_SITE_WITH_EV_1_YEAR", "softwareDescriptionId"=>nil, "units"=>"EV", "upgradeItemId"=>nil}, {"capacity"=>"3000", "description"=>"3000 GB iSCSI SAN Storage", "id"=>1176, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_3000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"3", "description"=>"Monitoring Package - Premium Application", "id"=>1250, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_PREMIUM_APPLICATION", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"capacity"=>"8", "description"=>".net - 8 year", "id"=>4031, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_NET_8_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>".net - 10 year", "id"=>4032, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_NET_10_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>".biz - 1 year", "id"=>4005, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_BIZ_1_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"2", "description"=>".info - 2 year", "id"=>4009, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_INFO_2_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>".us - 1 year", "id"=>4025, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_US_1_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>".us - 10 year", "id"=>4027, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_US_10_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"Citrix NetScaler VPX 10.1 10Mbps Platinum", "id"=>4424, "itemTaxCategoryId"=>166, "keyName"=>"CITRIX_NETSCALER_VPX_10_1_10MBPS_PLATINUM", "softwareDescriptionId"=>1181, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"65000", "description"=>"Dedicated Load Balancer with High Availability and SSL - 15,000 Connections", "id"=>4512, "itemTaxCategoryId"=>166, "keyName"=>"DEDICATED_LOAD_BALANCER_WITH_HIGH_AVAILABILITY_AND_SSL_15000_CONNECTIONS", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"20", "description"=>"20 GB iSCSI SAN Storage", "id"=>548, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_20_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>549}, {"capacity"=>"40", "description"=>"40 GB iSCSI SAN Storage", "id"=>549, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_40_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>598}, {"capacity"=>"100", "description"=>"Load Balancer 100 connections", "id"=>567, "itemTaxCategoryId"=>166, "keyName"=>"LOAD_BALANCER_100_CONNECTIONS", "softwareDescriptionId"=>nil, "units"=>"Connections/Second", "upgradeItemId"=>568}, {"capacity"=>"16", "description"=>"16 Static Public IP Addresses", "id"=>584, "itemTaxCategoryId"=>166, "keyName"=>"16_STATIC_PUBLIC_IP_ADDRESSES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"EVault Plugin - MSSQL", "id"=>607, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_PLUGIN_MSSQL", "softwareDescriptionId"=>173, "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2000 GB iSCSI SAN Storage", "id"=>626, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_2000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>1176}, {"capacity"=>"1000", "description"=>"1000 GB NAS", "id"=>635, "itemTaxCategoryId"=>166, "keyName"=>"NAS_1000_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>689}, {"capacity"=>"100", "description"=>"100 GB iSCSI SAN Snapshot Space", "id"=>698, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_SNAPSHOT_100_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>699}, {"capacity"=>"430", "description"=>"430 GB iSCSI SAN Snapshot Space", "id"=>704, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_SNAPSHOT_430_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>705}, {"capacity"=>"1000", "description"=>"1000 GB iSCSI SAN Snapshot Space", "id"=>709, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_SNAPSHOT_1000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>710}, {"capacity"=>"200", "description"=>"200 GB iSCSI SAN Replication", "id"=>717, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_REPLICATION_200_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"500", "description"=>"500 GB iSCSI SAN Replication", "id"=>723, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_REPLICATION_500_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"700", "description"=>"700 GB iSCSI SAN Replication", "id"=>725, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_REPLICATION_700_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows 2008 Datacenter w/ Unlimited Virtuals (1 Proc License)", "id"=>790, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUAL_OS_WINDOWS_2008_DATACENTER_W_UNLIMITED_VIRTUALS_1_PROC_LICENSE", "softwareDescriptionId"=>723, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"CDN 1000 GB Bandwidth", "id"=>894, "itemTaxCategoryId"=>166, "keyName"=>"CDN_1000_GB_BANDWIDTH", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Symantec Secure Site - 1 year", "id"=>972, "itemTaxCategoryId"=>166, "keyName"=>"SSL_CERTIFICATE_SYMANTEC_SECURE_SITE_1_YEAR", "softwareDescriptionId"=>nil, "units"=>"OV", "upgradeItemId"=>nil}, {"capacity"=>"50000", "description"=>"Basic Package", "id"=>3858, "itemTaxCategoryId"=>166, "keyName"=>"NETWORK_MESSAGE_DELIVERY_BASIC_PACKAGE", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"25000", "description"=>"Free Package", "id"=>3877, "itemTaxCategoryId"=>162, "keyName"=>"NETWORK_MESSAGE_DELIVERY_FREE_PACKAGE", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"8", "description"=>"8 Portable Private IP Addresses", "id"=>3903, "itemTaxCategoryId"=>166, "keyName"=>"8_PORTABLE_PRIVATE_IP_ADDRESSES", "softwareDescriptionId"=>nil, "units"=>"IPs", "upgradeItemId"=>nil}, {"capacity"=>"32", "description"=>"32 Portable Public IP Addresses", "id"=>3970, "itemTaxCategoryId"=>166, "keyName"=>"32_PORTABLE_PUBLIC_IP_ADDRESSES", "softwareDescriptionId"=>nil, "units"=>"IPs", "upgradeItemId"=>nil}, {"capacity"=>"7", "description"=>".net - 7 year", "id"=>4018, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_NET_7_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"3", "description"=>".org - 3 year", "id"=>4002, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_ORG_3_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"7", "description"=>".org - 7 year", "id"=>4046, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_ORG_7_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>".biz - 5 year", "id"=>4047, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_BIZ_5_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"175", "description"=>"175GB EVault Disk to Disk Enterprise Backup", "id"=>4182, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_175_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>561}, {"capacity"=>"0", "description"=>"CloudPlatform Zone", "id"=>4188, "itemTaxCategoryId"=>166, "keyName"=>"CLOUDPLATFORM_ZONE", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Phone-based authentication", "id"=>4267, "itemTaxCategoryId"=>98, "keyName"=>"PHONEBASED_AUTHENTICATION", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"35000", "description"=>"CDN 35000 GB Bandwidth", "id"=>4600, "itemTaxCategoryId"=>166, "keyName"=>"CDN_35000_GB_BANDWIDTH", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"15000", "description"=>"15000 GB iSCSI SAN Replication", "id"=>4622, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_REPLICATION_15000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"Citrix NetScaler VPX 10.5 1000Mbps Platinum", "id"=>5908, "itemTaxCategoryId"=>166, "keyName"=>"CITRIX_NETSCALER_VPX_10_5_1000MBPS_PLATINUM", "softwareDescriptionId"=>1382, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"200", "description"=>"Citrix NetScaler VPX 10.5 200Mbps Platinum", "id"=>5916, "itemTaxCategoryId"=>166, "keyName"=>"CITRIX_NETSCALER_VPX_10_5_200MBPS_PLATINUM", "softwareDescriptionId"=>1378, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100Mbps Hardware Firewall", "id"=>298, "itemTaxCategoryId"=>166, "keyName"=>"100MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"250", "description"=>"250 GB iSCSI SAN Storage", "id"=>552, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_250_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>612}, {"capacity"=>"20", "description"=>"20GB EVault Disk to Disk Enterprise Backup", "id"=>558, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_20_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>739}, {"description"=>"EVault Plugin - Sharepoint", "id"=>606, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_PLUGIN_SHAREPOINT", "softwareDescriptionId"=>175, "upgradeItemId"=>nil}, {"capacity"=>"500", "description"=>"500 GB NAS", "id"=>611, "itemTaxCategoryId"=>166, "keyName"=>"NAS_500_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>605}, {"description"=>"Load Balancer 2,500 connections", "id"=>618, "itemTaxCategoryId"=>166, "keyName"=>"LOAD_BALANCER_2500_CONNECTIONS", "softwareDescriptionId"=>nil, "upgradeItemId"=>619}, {"capacity"=>"200", "description"=>"200 GB iSCSI SAN Storage", "id"=>622, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_200_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>552}, {"capacity"=>"120", "description"=>"120 GB iSCSI SAN Replication", "id"=>716, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_REPLICATION_120_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"300", "description"=>"300 GB iSCSI SAN Replication", "id"=>719, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_REPLICATION_300_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"350", "description"=>"350 GB iSCSI SAN Replication", "id"=>720, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_REPLICATION_350_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1000 GB iSCSI SAN Replication", "id"=>726, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_REPLICATION_1000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CDN Account - Pay as You Grow", "id"=>761, "itemTaxCategoryId"=>166, "keyName"=>"CDN_ACCOUNT_PAY_AS_YOU_GROW", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"25", "description"=>"CDN 25 GB Storage", "id"=>896, "itemTaxCategoryId"=>166, "keyName"=>"CDN_25_GB_STORAGE", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CDN No storage (origin pull)", "id"=>900, "itemTaxCategoryId"=>166, "keyName"=>"CDN_NO_STORAGE_ORIGIN_PULL", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"GeoTrust True BusinessID with EV - 1 year", "id"=>966, "itemTaxCategoryId"=>166, "keyName"=>"SSL_CERTIFICATE_GEOTRUST_TRUE_BUSINESSID_WITH_EV_1_YEAR", "softwareDescriptionId"=>nil, "units"=>"EV", "upgradeItemId"=>nil}, {"capacity"=>"2", "description"=>"Symantec Secure Site - 2 year", "id"=>973, "itemTaxCategoryId"=>166, "keyName"=>"SSL_CERTIFICATE_SYMANTEC_SECURE_SITE_2_YEAR", "softwareDescriptionId"=>nil, "units"=>"OV", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"Load Balancer 1,000 VIP Connections", "id"=>1104, "itemTaxCategoryId"=>166, "keyName"=>"LOAD_BALANCER_1000_VIP_CONNECTIONS", "softwareDescriptionId"=>nil, "units"=>"Connections/Second", "upgradeItemId"=>1103}, {"capacity"=>"2", "description"=>".com - 2 year", "id"=>4013, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_COM_2_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>".com - 5 year", "id"=>4015, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_COM_5_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"9", "description"=>".org - 9 year", "id"=>4004, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_ORG_9_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"2", "description"=>".biz - 2 year", "id"=>4040, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_BIZ_2_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"6", "description"=>".biz - 6 year", "id"=>4033, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_BIZ_6_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"7", "description"=>".biz - 7 year", "id"=>4048, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_BIZ_7_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>".biz - 10 year", "id"=>4050, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_BIZ_10_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"8", "description"=>".info - 8 year", "id"=>3996, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_INFO_8_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"6", "description"=>".info - 6 year", "id"=>4010, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_INFO_6_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"2", "description"=>".us - 2 year", "id"=>4034, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_US_2_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"4", "description"=>".us - 4 year", "id"=>4026, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_US_4_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Object Storage - Pay as you go", "id"=>4069, "itemTaxCategoryId"=>166, "keyName"=>"OBJECT_STORAGE_PAY_AS_YOU_GO", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>nil}, {"capacity"=>"1500", "description"=>"1500GB EVault Disk to Disk Enterprise Backup", "id"=>4185, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_1500_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>955}, {"capacity"=>"0", "description"=>"FortiGate Security Appliance", "id"=>4337, "itemTaxCategoryId"=>166, "keyName"=>"FORTIGATE_SECURITY_APPLIANCE", "softwareDescriptionId"=>nil, "units"=>"dedicated", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"Citrix NetScaler VPX 10.1 1000Mbps Platinum", "id"=>4422, "itemTaxCategoryId"=>166, "keyName"=>"CITRIX_NETSCALER_VPX_10_1_1000MBPS_PLATINUM", "softwareDescriptionId"=>1179, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"Citrix NetScaler VPX 10.1 1000Mbps Standard", "id"=>4423, "itemTaxCategoryId"=>166, "keyName"=>"CITRIX_NETSCALER_VPX_10_1_1000MBPS_STANDARD", "softwareDescriptionId"=>1180, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CDN Global Small Object", "id"=>4499, "itemTaxCategoryId"=>166, "keyName"=>"CDN_GLOBAL_SMALL_OBJECT", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"Citrix NetScaler VPX 10.5 10Mbps Platinum", "id"=>5912, "itemTaxCategoryId"=>166, "keyName"=>"CITRIX_NETSCALER_VPX_10_5_10MBPS_PLATINUM", "softwareDescriptionId"=>1374, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1000 GB iSCSI SAN Storage", "id"=>554, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_1000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>783}, {"capacity"=>"1000", "description"=>"Load Balancer 1,000 connections", "id"=>566, "itemTaxCategoryId"=>166, "keyName"=>"LOAD_BALANCER_1000_CONNECTIONS", "softwareDescriptionId"=>nil, "units"=>"Connections/Second", "upgradeItemId"=>571}, {"capacity"=>"1500", "description"=>"Load Balancer 1,500 connections", "id"=>616, "itemTaxCategoryId"=>166, "keyName"=>"LOAD_BALANCER_1500_CONNECTIONS", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"120", "description"=>"120 GB iSCSI SAN Snapshot Space", "id"=>699, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_SNAPSHOT_120_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>700}, {"capacity"=>"200", "description"=>"200 GB iSCSI SAN Snapshot Space", "id"=>700, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_SNAPSHOT_200_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>701}, {"capacity"=>"450", "description"=>"450 GB iSCSI SAN Snapshot Space", "id"=>705, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_SNAPSHOT_450_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>706}, {"capacity"=>"80", "description"=>"80 GB iSCSI SAN Replication", "id"=>714, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_REPLICATION_80_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB iSCSI SAN Replication", "id"=>715, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_REPLICATION_100_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"1500", "description"=>"1500 GB iSCSI SAN Storage", "id"=>783, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_1500_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>626}, {"capacity"=>"500", "description"=>"CDN 500 GB Bandwidth", "id"=>893, "itemTaxCategoryId"=>166, "keyName"=>"CDN_500_GB_BANDWIDTH", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"2", "description"=>"GeoTrust True BusinessID with EV - 2 year", "id"=>967, "itemTaxCategoryId"=>166, "keyName"=>"SSL_CERTIFICATE_GEOTRUST_TRUE_BUSINESSID_WITH_EV_2_YEAR", "softwareDescriptionId"=>nil, "units"=>"EV", "upgradeItemId"=>nil}, {"capacity"=>"250", "description"=>"Load Balancer 250 VIP Connections", "id"=>1106, "itemTaxCategoryId"=>166, "keyName"=>"LOAD_BALANCER_250_VIP_CONNECTIONS", "softwareDescriptionId"=>nil, "units"=>"Connections/Second", "upgradeItemId"=>1105}, {"capacity"=>"4", "description"=>"4 Portable Public IP Addresses", "id"=>3930, "itemTaxCategoryId"=>166, "keyName"=>"4_PORTABLE_PUBLIC_IP_ADDRESSES", "softwareDescriptionId"=>nil, "units"=>"IPs", "upgradeItemId"=>nil}, {"capacity"=>"6", "description"=>".org - 6 year", "id"=>4003, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_ORG_6_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"3", "description"=>".biz - 3 year", "id"=>3995, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_BIZ_3_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>".info - 5 year", "id"=>4023, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_INFO_5_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"4", "description"=>".info - 4 year", "id"=>4007, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_INFO_4_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"3", "description"=>".info - 3 year", "id"=>4051, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_INFO_3_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"130000", "description"=>"Dedicated Load Balancer with High Availability and SSL - 150,000 Connections", "id"=>4513, "itemTaxCategoryId"=>166, "keyName"=>"DEDICATED_LOAD_BALANCER_WITH_HIGH_AVAILABILITY_AND_SSL_150000_CONNECTIONS", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"20", "description"=>"20Mbps Hardware Firewall", "id"=>4550, "itemTaxCategoryId"=>166, "keyName"=>"20MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"6500", "description"=>"6500 GB iSCSI SAN Replication", "id"=>4612, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_REPLICATION_6500_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1000Mbps Hardware Firewall", "id"=>297, "itemTaxCategoryId"=>166, "keyName"=>"1000MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"500", "description"=>"Load Balancer 500 connections", "id"=>569, "itemTaxCategoryId"=>166, "keyName"=>"LOAD_BALANCER_500_CONNECTIONS", "softwareDescriptionId"=>nil, "units"=>"Connections/Second", "upgradeItemId"=>566}, {"capacity"=>"4", "description"=>"4 Static Public IP Addresses", "id"=>577, "itemTaxCategoryId"=>166, "keyName"=>"4_STATIC_PUBLIC_IP_ADDRESSES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"350", "description"=>"350 GB iSCSI SAN Storage", "id"=>625, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_350_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>623}, {"capacity"=>"250", "description"=>"250 GB iSCSI SAN Snapshot Space", "id"=>701, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_SNAPSHOT_250_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>702}, {"capacity"=>"2000", "description"=>"2000 GB iSCSI SAN Snapshot Space", "id"=>710, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_SNAPSHOT_2000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"430", "description"=>"430 GB iSCSI SAN Replication", "id"=>721, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_REPLICATION_430_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"450", "description"=>"450 GB iSCSI SAN Replication", "id"=>722, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_REPLICATION_450_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"64", "description"=>"/64 Block Portable Public IPv6 Addresses", "id"=>785, "itemTaxCategoryId"=>166, "keyName"=>"64_BLOCK_PORTABLE_PUBLIC_IPV6_ADDRESSES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows 2008 Datacenter w/ Unlimited Virtuals (4 Proc License)", "id"=>792, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUAL_OS_WINDOWS_2008_DATACENTER_W_UNLIMITED_VIRTUALS_4_PROC_LICENSE", "softwareDescriptionId"=>723, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CDN Pay as You Go Bandwidth", "id"=>891, "itemTaxCategoryId"=>166, "keyName"=>"CDN_PAY_AS_YOU_GO_BANDWIDTH", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"250", "description"=>"CDN 250 GB Bandwidth", "id"=>892, "itemTaxCategoryId"=>166, "keyName"=>"CDN_250_GB_BANDWIDTH", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"250", "description"=>"CDN 250 GB Storage", "id"=>899, "itemTaxCategoryId"=>166, "keyName"=>"CDN_250_GB_STORAGE", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"RapidSSL - 1 year", "id"=>964, "itemTaxCategoryId"=>166, "keyName"=>"SSL_CERTIFICATE_RAPIDSSL_1_YEAR", "softwareDescriptionId"=>nil, "units"=>"DV", "upgradeItemId"=>nil}, {"capacity"=>"5000", "description"=>"CDN 5000 GB Bandwidth", "id"=>1001, "itemTaxCategoryId"=>166, "keyName"=>"CDN_5000_GB_BANDWIDTH", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Public Network Vlan", "id"=>1071, "itemTaxCategoryId"=>166, "keyName"=>"PUBLIC_NETWORK_VLAN", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"60", "description"=>"60GB EVault Disk to Disk Enterprise Backup", "id"=>1076, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_60_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>560}, {"capacity"=>"0", "description"=>"EVault Plugin - VMWare ESX", "id"=>1087, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_PLUGIN_VMWARE_ESX", "softwareDescriptionId"=>635, "upgradeItemId"=>nil}, {"capacity"=>"2500", "description"=>"Load Balancer 2,500 VIP Connections", "id"=>1103, "itemTaxCategoryId"=>166, "keyName"=>"LOAD_BALANCER_2500_VIP_CONNECTIONS", "softwareDescriptionId"=>nil, "units"=>"Connections/Second", "upgradeItemId"=>1102}, {"capacity"=>"0", "description"=>"Citrix VDC", "id"=>1148, "itemTaxCategoryId"=>166, "keyName"=>"CITRIX_VDC", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"2", "description"=>"Monitoring Package - Advanced", "id"=>1249, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_ADVANCED", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"QuickSSL Premium - 1 year", "id"=>1293, "itemTaxCategoryId"=>166, "keyName"=>"SSL_CERTIFICATE_QUICKSSL_PREMIUM_1_YEAR", "softwareDescriptionId"=>nil, "units"=>"DV", "upgradeItemId"=>nil}, {"capacity"=>"50", "description"=>"50GB EVault Disk to Disk Enterprise Backup", "id"=>3784, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_50_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>1076}, {"capacity"=>"2", "description"=>"Hardware Firewall (High Availability)", "id"=>3896, "itemTaxCategoryId"=>166, "keyName"=>"HARDWARE_FIREWALL_HIGH_AVAILABILITY", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"16", "description"=>"16 Portable Public IP Addresses", "id"=>3931, "itemTaxCategoryId"=>166, "keyName"=>"16_PORTABLE_PUBLIC_IP_ADDRESSES", "softwareDescriptionId"=>nil, "units"=>"IPs", "upgradeItemId"=>nil}, {"capacity"=>"16", "description"=>"16 Portable Private IP Addresses", "id"=>3936, "itemTaxCategoryId"=>166, "keyName"=>"16_PORTABLE_PRIVATE_IP_ADDRESSES", "softwareDescriptionId"=>nil, "units"=>"IPs", "upgradeItemId"=>nil}, {"capacity"=>"2", "description"=>"2 Static Public IP Addresses", "id"=>3938, "itemTaxCategoryId"=>166, "keyName"=>"2_STATIC_PUBLIC_IP_ADDRESSES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"64", "description"=>"64 Portable Private IP Addresses", "id"=>3971, "itemTaxCategoryId"=>166, "keyName"=>"64_PORTABLE_PRIVATE_IP_ADDRESSES", "softwareDescriptionId"=>nil, "units"=>"IPs", "upgradeItemId"=>nil}, {"capacity"=>"3", "description"=>".com - 3 year", "id"=>4041, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_COM_3_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"4", "description"=>".com - 4 year", "id"=>4014, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_COM_4_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"4", "description"=>".org - 4 year", "id"=>4020, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_ORG_4_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>".org - 5 year", "id"=>4045, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_ORG_5_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"8", "description"=>".org - 8 year", "id"=>4039, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_ORG_8_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"6", "description"=>".us - 6 year", "id"=>3998, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_US_6_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"7", "description"=>".us - 7 year", "id"=>3999, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_US_7_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"65000", "description"=>"Load Balancer (Dedicated, with SSL offload) - 15,000 Connections", "id"=>4136, "itemTaxCategoryId"=>166, "keyName"=>"LOAD_BALANCER_DEDICATED_WITH_SSL_OFFLOAD_15000_CONNECTIONS", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Global IPv6", "id"=>4187, "itemTaxCategoryId"=>166, "keyName"=>"GLOBAL_IPV6", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"SSL CDN bandwidth", "id"=>4232, "itemTaxCategoryId"=>166, "keyName"=>"SSL_CDN_BANDWIDTH", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB NAS", "id"=>43, "itemTaxCategoryId"=>166, "keyName"=>"NAS_100_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>44}, {"capacity"=>"100", "description"=>"100GB EVault Disk to Disk Enterprise Backup", "id"=>560, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_100_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4182}, {"capacity"=>"8", "description"=>"8 Static Public IP Addresses", "id"=>583, "itemTaxCategoryId"=>166, "keyName"=>"8_STATIC_PUBLIC_IP_ADDRESSES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"Load Balancer 2,000 connections", "id"=>617, "itemTaxCategoryId"=>166, "keyName"=>"LOAD_BALANCER_2000_CONNECTIONS", "softwareDescriptionId"=>nil, "units"=>"Connections/Second", "upgradeItemId"=>618}, {"capacity"=>"700", "description"=>"700 GB iSCSI SAN Storage", "id"=>621, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_700_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>554}, {"capacity"=>"450", "description"=>"450 GB iSCSI SAN Storage", "id"=>624, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_450_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>553}, {"capacity"=>"2000", "description"=>"2000 GB NAS", "id"=>689, "itemTaxCategoryId"=>166, "keyName"=>"NAS_2000_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>3787}, {"capacity"=>"20", "description"=>"20 GB iSCSI SAN Snapshot Space", "id"=>694, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_SNAPSHOT_20_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>695}, {"capacity"=>"300", "description"=>"300 GB iSCSI SAN Snapshot Space", "id"=>702, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_SNAPSHOT_300_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>703}, {"capacity"=>"64", "description"=>"/64 Block Static Public IPv6 Addresses", "id"=>784, "itemTaxCategoryId"=>166, "keyName"=>"64_BLOCK_STATIC_PUBLIC_IPV6_ADDRESSES", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows 2008 Datacenter w/ Unlimited Virtuals (2 Proc License)", "id"=>791, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUAL_OS_WINDOWS_2008_DATACENTER_W_UNLIMITED_VIRTUALS_2_PROC_LICENSE", "softwareDescriptionId"=>723, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"CDN 100 GB Storage", "id"=>898, "itemTaxCategoryId"=>166, "keyName"=>"CDN_100_GB_STORAGE", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"EVault Plugin - BMR (Bare Metal Restore)", "id"=>961, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_PLUGIN_BMR_BARE_METAL_RESTORE", "softwareDescriptionId"=>467, "upgradeItemId"=>nil}, {"capacity"=>"2", "description"=>"RapidSSL - 2 year", "id"=>965, "itemTaxCategoryId"=>166, "keyName"=>"SSL_CERTIFICATE_RAPIDSSL_2_YEAR", "softwareDescriptionId"=>nil, "units"=>"DV", "upgradeItemId"=>nil}, {"capacity"=>"2", "description"=>"Symantec Secure Site with EV - 2 year", "id"=>969, "itemTaxCategoryId"=>166, "keyName"=>"SSL_CERTIFICATE_SYMANTEC_SECURE_SITE_WITH_EV_2_YEAR", "softwareDescriptionId"=>nil, "units"=>"EV", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"GeoTrust True BusinessID - 1 year", "id"=>970, "itemTaxCategoryId"=>166, "keyName"=>"SSL_CERTIFICATE_GEOTRUST_TRUE_BUSINESSID_1_YEAR", "softwareDescriptionId"=>nil, "units"=>"OV", "upgradeItemId"=>nil}, {"capacity"=>"2", "description"=>"GeoTrust True BusinessID - 2 year", "id"=>971, "itemTaxCategoryId"=>166, "keyName"=>"SSL_CERTIFICATE_GEOTRUST_TRUE_BUSINESSID_2_YEAR", "softwareDescriptionId"=>nil, "units"=>"OV", "upgradeItemId"=>nil}, {"capacity"=>"500", "description"=>"Load Balancer 500 VIP Connections", "id"=>1105, "itemTaxCategoryId"=>166, "keyName"=>"LOAD_BALANCER_500_VIP_CONNECTIONS", "softwareDescriptionId"=>nil, "units"=>"Connections/Second", "upgradeItemId"=>1104}, {"capacity"=>"1", "description"=>"Monitoring Package - Basic", "id"=>1248, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_BASIC", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2000Mbps Hardware Firewall", "id"=>1296, "itemTaxCategoryId"=>166, "keyName"=>"2000MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"Hardware Firewall (Dedicated)", "id"=>1329, "itemTaxCategoryId"=>166, "keyName"=>"HARDWARE_FIREWALL_DEDICATED", "softwareDescriptionId"=>nil, "units"=>"dedicated", "upgradeItemId"=>nil}, {"capacity"=>"250000", "description"=>"Enterprise Package", "id"=>3860, "itemTaxCategoryId"=>166, "keyName"=>"NETWORK_MESSAGE_DELIVERY_ENTERPRISE_PACKAGE", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"8", "description"=>"8 Portable Public IP Addresses", "id"=>3902, "itemTaxCategoryId"=>166, "keyName"=>"8_PORTABLE_PUBLIC_IP_ADDRESSES", "softwareDescriptionId"=>nil, "units"=>"IPs", "upgradeItemId"=>nil}, {"capacity"=>"6", "description"=>".com - 6 year", "id"=>4037, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_COM_6_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"7", "description"=>".com - 7 year", "id"=>4042, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_COM_7_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>".com - 10 year", "id"=>4029, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_COM_10_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>".net - 1 year", "id"=>4000, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_NET_1_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"3", "description"=>".net - 3 year", "id"=>4043, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_NET_3_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"4", "description"=>".net - 4 year", "id"=>4017, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_NET_4_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>".info - 10 year", "id"=>4008, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_INFO_10_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"9", "description"=>".info - 9 year", "id"=>4024, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_INFO_9_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>".info - 1 year", "id"=>4006, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_INFO_1_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"8", "description"=>".us - 8 year", "id"=>4035, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_US_8_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"Load Balancer 1,000 VIP Connections (with SSL offload)", "id"=>4127, "itemTaxCategoryId"=>166, "keyName"=>"LOAD_BALANCER_1000_VIP_CONNECTIONS_WITH_SSL_OFFLOAD", "softwareDescriptionId"=>nil, "units"=>"Connections/Second", "upgradeItemId"=>4128}, {"capacity"=>"130000", "description"=>"Load Balancer (Dedicated, with SSL offload) - 150,000 Connections", "id"=>4163, "itemTaxCategoryId"=>166, "keyName"=>"LOAD_BALANCER_DEDICATED_WITH_SSL_OFFLOAD_150000_CONNECTIONS", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"100000", "description"=>"Message Queue Notifications Pay as You Go", "id"=>4212, "itemTaxCategoryId"=>166, "keyName"=>"MESSAGE_QUEUE_NOTIFICATIONS_PAY_AS_YOU_GO", "softwareDescriptionId"=>nil, "units"=>"COUNT", "upgradeItemId"=>nil}, {"capacity"=>"200", "description"=>"Citrix NetScaler VPX 10.1 200Mbps Standard", "id"=>4427, "itemTaxCategoryId"=>166, "keyName"=>"CITRIX_NETSCALER_VPX_10_1_200MBPS_STANDARD", "softwareDescriptionId"=>1178, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"20000", "description"=>"20000 GB iSCSI SAN Replication", "id"=>4614, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_REPLICATION_20000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"40", "description"=>"40 GB NAS", "id"=>41, "itemTaxCategoryId"=>166, "keyName"=>"NAS_40_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>42}, {"capacity"=>"500", "description"=>"500 GB iSCSI SAN Storage", "id"=>553, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_500_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>621}, {"capacity"=>"500", "description"=>"500GB EVault Disk to Disk Enterprise Backup", "id"=>562, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_500_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4184}, {"capacity"=>"50", "description"=>"Load Balancer 50 connections", "id"=>565, "itemTaxCategoryId"=>166, "keyName"=>"LOAD_BALANCER_50_CONNECTIONS", "softwareDescriptionId"=>nil, "units"=>"Connections/Second", "upgradeItemId"=>567}, {"capacity"=>"120", "description"=>"120 GB iSCSI SAN Storage", "id"=>575, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_120_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>622}, {"capacity"=>"32", "description"=>"32 Static Public IP Addresses", "id"=>585, "itemTaxCategoryId"=>166, "keyName"=>"32_STATIC_PUBLIC_IP_ADDRESSES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"EVault Plugin - Open TXN Manager", "id"=>609, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_PLUGIN_OPEN_TXN_MANAGER", "softwareDescriptionId"=>176, "upgradeItemId"=>nil}, {"capacity"=>"300", "description"=>"300 GB iSCSI SAN Storage", "id"=>612, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_300_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>625}, {"capacity"=>"40", "description"=>"40 GB iSCSI SAN Snapshot Space", "id"=>695, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_SNAPSHOT_40_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>696}, {"capacity"=>"80", "description"=>"80 GB iSCSI SAN Snapshot Space", "id"=>697, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_SNAPSHOT_80_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>698}, {"capacity"=>"700", "description"=>"700 GB iSCSI SAN Snapshot Space", "id"=>708, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_SNAPSHOT_700_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>709}, {"capacity"=>"40", "description"=>"40 GB iSCSI SAN Replication", "id"=>712, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_REPLICATION_40_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"60", "description"=>"60 GB iSCSI SAN Replication", "id"=>713, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_REPLICATION_60_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"250", "description"=>"250 GB iSCSI SAN Replication", "id"=>718, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_REPLICATION_250_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"600", "description"=>"600 GB iSCSI SAN Replication", "id"=>724, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_REPLICATION_600_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CDN Pay as You Go Storage", "id"=>902, "itemTaxCategoryId"=>166, "keyName"=>"CDN_PAY_AS_YOU_GO_STORAGE", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Symantec Identity Protection", "id"=>1067, "itemTaxCategoryId"=>98, "keyName"=>"SYMANTEC_IDENTITY_PROTECTION", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Private Network Vlan", "id"=>1072, "itemTaxCategoryId"=>166, "keyName"=>"PRIVATE_NETWORK_VLAN", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Data Transfer Request Service", "id"=>1124, "itemTaxCategoryId"=>166, "keyName"=>"DATA_TRANSFER_REQUEST_SERVICE", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"100000", "description"=>"Advanced Package", "id"=>3859, "itemTaxCategoryId"=>166, "keyName"=>"NETWORK_MESSAGE_DELIVERY_ADVANCED_PACKAGE", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"4", "description"=>"4 Portable Private IP Addresses", "id"=>3935, "itemTaxCategoryId"=>166, "keyName"=>"4_PORTABLE_PRIVATE_IP_ADDRESSES", "softwareDescriptionId"=>nil, "units"=>"IPs", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"International Services", "id"=>3955, "itemTaxCategoryId"=>166, "keyName"=>"INTERNATIONAL_SERVICES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"8", "description"=>".com - 8 year", "id"=>4016, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_COM_8_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"6", "description"=>".net - 6 year", "id"=>4044, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_NET_6_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"2", "description"=>".org - 2 year", "id"=>3993, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_ORG_2_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>".org - 10 year", "id"=>3994, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_ORG_10_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"4", "description"=>".biz - 4 year", "id"=>4021, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_BIZ_4_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"9", "description"=>".biz - 9 year", "id"=>4049, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_BIZ_9_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"3", "description"=>".us - 3 year", "id"=>4011, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_US_3_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>".us - 5 year", "id"=>3997, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_US_5_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"9", "description"=>".us - 9 year", "id"=>4012, "itemTaxCategoryId"=>166, "keyName"=>"DOMAIN_US_9_YEAR", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"500", "description"=>"Load Balancer 500 VIP Connections (with SSL offload)", "id"=>4126, "itemTaxCategoryId"=>166, "keyName"=>"LOAD_BALANCER_500_VIP_CONNECTIONS_WITH_SSL_OFFLOAD", "softwareDescriptionId"=>nil, "units"=>"Connections/Second", "upgradeItemId"=>4127}, {"capacity"=>"250", "description"=>"Load Balancer 250 VIP Connections (with SSL offload)", "id"=>4125, "itemTaxCategoryId"=>166, "keyName"=>"LOAD_BALANCER_250_VIP_CONNECTIONS_WITH_SSL_OFFLOAD", "softwareDescriptionId"=>nil, "units"=>"Connections/Second", "upgradeItemId"=>4126}, {"capacity"=>"2", "description"=>"FortiGate Security Appliance (High Availability)", "id"=>4338, "itemTaxCategoryId"=>166, "keyName"=>"FORTIGATE_SECURITY_APPLIANCE_HIGH_AVAILABILITY", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"200", "description"=>"200Mbps Hardware Firewall", "id"=>4551, "itemTaxCategoryId"=>166, "keyName"=>"200MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"3000", "description"=>"3000 GB iSCSI SAN Replication", "id"=>4602, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_REPLICATION_3000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"4000", "description"=>"4000 GB iSCSI SAN Replication", "id"=>4616, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_REPLICATION_4000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>621}, {"capacity"=>"10000", "description"=>"10000 GB iSCSI SAN Replication", "id"=>4618, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_REPLICATION_10000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"Citrix NetScaler VPX 10.5 10Mbps Standard", "id"=>5914, "itemTaxCategoryId"=>166, "keyName"=>"CITRIX_NETSCALER_VPX_10_5_10MBPS_STANDARD", "softwareDescriptionId"=>1372, "units"=>"Mbps", "upgradeItemId"=>nil}]
          fixture_package_items[10] = [{"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 for VPS (Linux) 100 Domain w/ Power Pack", "id"=>4201, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_FOR_VPS_LINUX_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1196, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 for VPS (Windows) Unlimited Domain w/ Power Pack", "id"=>4530, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_FOR_VPS_WINDOWS_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1230, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 12 for VPS - Unlimited Domain w/ Power Pack", "id"=>6016, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_12_FOR_VPS_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1422, "upgradeItemId"=>nil}, {"capacity"=>"3", "description"=>"Monitoring Package - Premium Application", "id"=>1250, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_PREMIUM_APPLICATION", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"description"=>"cPanel for VPS", "id"=>146, "itemTaxCategoryId"=>166, "keyName"=>"CPANEL_FOR_VPS", "softwareDescriptionId"=>44, "upgradeItemId"=>nil}, {"description"=>"cPanel for Virtuozzo and OpenVZ", "id"=>145, "itemTaxCategoryId"=>166, "keyName"=>"CPANEL_FOR_VIRTUOZZO_AND_OPENVZ", "softwareDescriptionId"=>43, "upgradeItemId"=>nil}, {"description"=>"cPanel for VPS with Fantastico and RVskin", "id"=>148, "itemTaxCategoryId"=>166, "keyName"=>"CPANEL_FOR_VPS_WITH_FANTASTICO_AND_RVSKIN", "softwareDescriptionId"=>46, "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 10 for VPS (Linux) 100 Domain w/ Power Pack", "id"=>3945, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_FOR_VPS_LINUX_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>941, "upgradeItemId"=>nil}, {"capacity"=>"2", "description"=>"Monitoring Package - Advanced", "id"=>1249, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_ADVANCED", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Linux Virtuozzo) 100 Domain w/ Power Pack", "id"=>4193, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_LINUX_VIRTUOZZO_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1195, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 for VPS (Linux) Unlimited Domain w/ Power Pack", "id"=>4202, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_FOR_VPS_LINUX_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1198, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 for VPS (Windows) 100 Domain w/ Power Pack", "id"=>4529, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_FOR_VPS_WINDOWS_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1229, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"cPanel for Virtuozzo and OpenVZ with Fantastico and RVskin", "id"=>147, "itemTaxCategoryId"=>166, "keyName"=>"CPANEL_FOR_VIRTUOZZO_AND_OPENVZ_WITH_FANTASTICO_AND_RVSKIN", "softwareDescriptionId"=>47, "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Monitoring Package - Basic", "id"=>1248, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_BASIC", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 10 for VPS (Linux) Unlimited Domain w/ Power Pack", "id"=>3946, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_FOR_VPS_LINUX_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>942, "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 10 for VPS (Windows) 100 Domain w/ Power Pack", "id"=>3948, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_FOR_VPS_WINDOWS_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>865, "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 10 (Linux Virtuozzo) 100 Domain w/ Power Pack", "id"=>3943, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_LINUX_VIRTUOZZO_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>940, "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 10 (Linux Virtuozzo) Unlimited Domain w/ Power Pack", "id"=>3944, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_LINUX_VIRTUOZZO_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>943, "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 10 for VPS (Windows) Unlimited Domain w/ Power Pack", "id"=>3947, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_FOR_VPS_WINDOWS_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>882, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"International Services", "id"=>3955, "itemTaxCategoryId"=>166, "keyName"=>"INTERNATIONAL_SERVICES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 12 for VPS - 30 Domain w/ Power Pack", "id"=>6012, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_12_FOR_VPS_30_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1416, "upgradeItemId"=>nil}]
          fixture_package_items[32] = [{"capacity"=>"20", "description"=>"20 GB NAS", "id"=>40, "itemTaxCategoryId"=>166, "keyName"=>"NAS_20_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>41}, {"description"=>"Microsoft SQL Server 2005 Standard", "id"=>79, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_STANDARD", "softwareDescriptionId"=>8, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10Mbps Hardware Firewall", "id"=>299, "itemTaxCategoryId"=>166, "keyName"=>"10MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"Unlimited SSL VPN Users & 1 PPTP VPN User per account", "id"=>309, "itemTaxCategoryId"=>166, "keyName"=>"UNLIMITED_SSL_VPN_USERS_1_PPTP_VPN_USER_PER_ACCOUNT", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Enterprise SP2 with R2 (64 bit)", "id"=>424, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_ENT_64_BIT_SP2_WR2", "softwareDescriptionId"=>127, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB iSCSI SAN Storage", "id"=>551, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_100_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>575}, {"capacity"=>"40", "description"=>"40GB EVault Disk to Disk Enterprise Backup", "id"=>559, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_40_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>3784}, {"capacity"=>"1000", "description"=>"1000GB EVault Disk to Disk Enterprise Backup", "id"=>563, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_1000_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4185}, {"description"=>"Microsoft SQL Server 2008 Web", "id"=>685, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WEB", "softwareDescriptionId"=>305, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Enterprise Edition SP2 (32bit)", "id"=>937, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_32_BIT_SP2", "softwareDescriptionId"=>448, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2000GB EVault Disk to Disk Enterprise Backup", "id"=>955, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_2000_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Standard SP2 with R2 (64 bit)", "id"=>422, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_STD_64_BIT_SP2_WR2", "softwareDescriptionId"=>126, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"Virtuozzo Containers 4 for Linux - 4 processors - 100 VPS", "id"=>1085, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_4_PROCESSORS_100_VPS", "softwareDescriptionId"=>587, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Web R2", "id"=>1163, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WEB_R2", "softwareDescriptionId"=>696, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Express R2", "id"=>1162, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_EXPRESS_R2", "softwareDescriptionId"=>701, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 10 (Linux) 100 Domain w/ Power Pack", "id"=>1305, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_LINUX_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>938, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"200", "description"=>"200 GB SSD", "id"=>3811, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_200GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 6.x Squeeze/Stable (64 bit)", "id"=>3968, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_6_X_SQUEEZE_64_BIT", "softwareDescriptionId"=>919, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.0.0", "id"=>3977, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_0_0", "softwareDescriptionId"=>836, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 5.x (32 bit)", "id"=>4092, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_5_X_32_BIT_2", "softwareDescriptionId"=>1156, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 10 Pack", "id"=>4155, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_10_PACK", "softwareDescriptionId"=>1011, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin - Minimal Install (32 bit)", "id"=>4169, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_MINIMAL_32_BIT", "softwareDescriptionId"=>1186, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"350", "description"=>"350GB EVault Disk to Disk Enterprise Backup", "id"=>4183, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_350_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>562}, {"capacity"=>"750", "description"=>"750GB EVault Disk to Disk Enterprise Backup", "id"=>4184, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_750_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>563}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Linux) 100 Domain w/ Power Pack", "id"=>4195, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_LINUX_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1191, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Windows) 100 Domain w/ Power Pack", "id"=>4199, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_WINDOWS_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1273, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 1 VM", "id"=>4303, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_1_VM", "softwareDescriptionId"=>1105, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - Unlimited VMs", "id"=>4307, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_UNLIMITED_VMS", "softwareDescriptionId"=>1112, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Redundant Private Network Uplinks", "id"=>4335, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.2", "id"=>4467, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_2", "softwareDescriptionId"=>1171, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Dual Public & Private Network Uplinks (Unbonded)", "id"=>5118, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_DUAL_PUBLIC_PRIVATE_NETWORK_UPLINKS_UNBONDED", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"80", "description"=>"80 GB NAS", "id"=>42, "itemTaxCategoryId"=>166, "keyName"=>"NAS_80_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>43}, {"capacity"=>"250", "description"=>"250 GB NAS", "id"=>44, "itemTaxCategoryId"=>166, "keyName"=>"NAS_250_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>411}, {"capacity"=>"1000", "description"=>"1 Gbps Public & Private Network Uplinks", "id"=>188, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"APF Software Firewall for Linux", "id"=>300, "itemTaxCategoryId"=>166, "keyName"=>"APF_SOFTWARE_FIREWALL_FOR_LINUX", "softwareDescriptionId"=>71, "upgradeItemId"=>nil}, {"description"=>"Nessus Vulnerability Assessment & Reporting", "id"=>307, "itemTaxCategoryId"=>98, "keyName"=>"NESSUS_VULNERABILITY_ASSESSMENT_REPORTING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"McAfee VirusScan Enterprise", "id"=>397, "itemTaxCategoryId"=>98, "keyName"=>"MCAFEE_VIRUSSCAN_ANTIVIRUS_WINDOWS", "softwareDescriptionId"=>820, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x (32 bit)", "id"=>419, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_32_BIT", "softwareDescriptionId"=>1239, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Non-RAID", "id"=>487, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_NONRAID", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Microsoft Windows Firewall", "id"=>495, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_WINDOWS_FIREWALL", "softwareDescriptionId"=>106, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Private Network Uplink", "id"=>498, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"80", "description"=>"80 GB iSCSI SAN Storage", "id"=>550, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_80_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>551}, {"capacity"=>"250", "description"=>"250GB EVault Disk to Disk Enterprise Backup", "id"=>561, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_250_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4183}, {"description"=>"Microsoft SQL Server 2008 Express", "id"=>681, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_EXPRESS", "softwareDescriptionId"=>308, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Enterprise", "id"=>682, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_ENTERPRISE", "softwareDescriptionId"=>307, "upgradeItemId"=>nil}, {"capacity"=>"30", "description"=>"30GB EVault Disk to Disk Enterprise Backup", "id"=>739, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_30_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>559}, {"capacity"=>"0", "description"=>"Windows Server 2008 Datacenter Edition SP2 (32bit)", "id"=>939, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_32_BIT_SP2", "softwareDescriptionId"=>450, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"Virtuozzo Containers 4 for Linux - 4 processors - 5 VPS", "id"=>1080, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_4_PROCESSORS_5_VPS", "softwareDescriptionId"=>582, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Standard R2", "id"=>1161, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_STANDARD_R2", "softwareDescriptionId"=>698, "upgradeItemId"=>nil}, {"capacity"=>"3000", "description"=>"3000 GB iSCSI SAN Storage", "id"=>1176, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_3000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"3", "description"=>"Monitoring Package - Premium Application", "id"=>1250, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_PREMIUM_APPLICATION", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 10 (Windows) Unlimited Domain w/ Power Pack", "id"=>3785, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_WINDOWS_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>788, "upgradeItemId"=>nil}, {"capacity"=>"10000", "description"=>"10 Gbps Private Network Uplink", "id"=>3957, "itemTaxCategoryId"=>166, "keyName"=>"10_GBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Standard Edition", "id"=>4148, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_STANDARD", "softwareDescriptionId"=>1003, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 5 Pack", "id"=>4154, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_5_PACK", "softwareDescriptionId"=>1012, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 Standard Edition (64 bit)", "id"=>4233, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_STD_64_BIT", "softwareDescriptionId"=>1076, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESXi 5.1", "id"=>4272, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESXI_5_1", "softwareDescriptionId"=>1086, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 5 VMs", "id"=>4304, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_5_VMS", "softwareDescriptionId"=>1109, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 10 VMs", "id"=>4305, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_10_VMS", "softwareDescriptionId"=>1110, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"15", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 15 VMs", "id"=>4306, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_15_VMS", "softwareDescriptionId"=>1111, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x (64 bit) (per-processor licensing)", "id"=>4319, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_64_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1228, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Server Backup 5.0 Enterprise (Linux)", "id"=>4343, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_SERVER_BACKUP_5_0_ENTERPRISE_LINUX", "softwareDescriptionId"=>1093, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 10 Pack", "id"=>4347, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_10_PACK", "softwareDescriptionId"=>1096, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable (32 bit)", "id"=>4404, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_32_BIT", "softwareDescriptionId"=>1169, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"RAID", "id"=>4478, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Datacenter Edition With Hyper-V (64bit)", "id"=>4548, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_DC_64_BIT_2", "softwareDescriptionId"=>1226, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Host Ping and TCP Service Monitoring", "id"=>50, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_HOST_PING_AND_TCP_SERVICE", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Public & Private Network Uplinks", "id"=>186, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>187}, {"description"=>"McAfee Host Intrusion Protection w/Reporting", "id"=>302, "itemTaxCategoryId"=>98, "keyName"=>"MCAFEE_HOST_INTRUSION_PROTECTION_WREPORTING", "softwareDescriptionId"=>916, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1.00 TB SATA II", "id"=>471, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_1_00TB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Private Network Uplink", "id"=>497, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>498}, {"capacity"=>"20", "description"=>"20 GB iSCSI SAN Storage", "id"=>548, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_20_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>549}, {"capacity"=>"40", "description"=>"40 GB iSCSI SAN Storage", "id"=>549, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_40_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>598}, {"capacity"=>"2000", "description"=>"2000 GB iSCSI SAN Storage", "id"=>626, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_2000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>1176}, {"description"=>"Microsoft SQL Server 2008 Standard", "id"=>683, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_STANDARD", "softwareDescriptionId"=>306, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Standard Edition (64bit)", "id"=>977, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_R2", "softwareDescriptionId"=>475, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Datacenter Edition (64bit)", "id"=>979, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_R2", "softwareDescriptionId"=>478, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 8.x (64 bit)", "id"=>1065, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_8_X_64_BIT_2", "softwareDescriptionId"=>1019, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"Virtuozzo Containers 4 for Linux - 4 processors - 10 VPS", "id"=>1081, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_4_PROCESSORS_10_VPS", "softwareDescriptionId"=>583, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"600", "description"=>"600 GB SA-SCSI 15K RPM", "id"=>1094, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_600GB_SASCSI_15K_RPM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx (32 bit)", "id"=>1136, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_32_BIT", "softwareDescriptionId"=>774, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 25 Pack", "id"=>4156, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_25_PACK", "softwareDescriptionId"=>1016, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin (64 bit)", "id"=>4166, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_64_BIT", "softwareDescriptionId"=>1165, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"175", "description"=>"175GB EVault Disk to Disk Enterprise Backup", "id"=>4182, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_175_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>561}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Linux) Unlimited Domain w/ Power Pack", "id"=>4197, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_LINUX_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1197, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10000", "description"=>"10 Gbps Redundant Private Network Uplinks", "id"=>4341, "itemTaxCategoryId"=>166, "keyName"=>"10_GBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"800", "description"=>"800 GB SSD", "id"=>4356, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_800GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (128 TB)", "id"=>4369, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_128_TB", "softwareDescriptionId"=>1155, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (16 TB)", "id"=>4371, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_16_TB", "softwareDescriptionId"=>1153, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"No Operating System", "id"=>4648, "itemTaxCategoryId"=>166, "keyName"=>"OS_NO_OPERATING_SYSTEM", "softwareDescriptionId"=>1312, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10000", "description"=>"10 Gbps Dual Public & Private Network Uplinks (Unbonded)", "id"=>5106, "itemTaxCategoryId"=>166, "keyName"=>"10_GBPS_DUAL_PUBLIC_PRIVATE_NETWORK_UPLINKS_UNBONDED", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Standard Edition", "id"=>5124, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_STANDARD_EDITION", "softwareDescriptionId"=>1334, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.5 - Minimal Install (64 bit) - version-locked", "id"=>5984, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_5_MINIMAL_64_BIT", "softwareDescriptionId"=>1263, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"1 IP Address", "id"=>15, "itemTaxCategoryId"=>166, "keyName"=>"1_IP_ADDRESS", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"MySQL for Linux", "id"=>22, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_LINUX", "softwareDescriptionId"=>156, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Workgroup", "id"=>80, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_WORKGROUP", "softwareDescriptionId"=>20, "upgradeItemId"=>nil}, {"capacity"=>"20000", "description"=>"20000 GB Bandwidth", "id"=>249, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_20000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100Mbps Hardware Firewall", "id"=>298, "itemTaxCategoryId"=>166, "keyName"=>"100MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"Redundant Power Supply", "id"=>469, "itemTaxCategoryId"=>166, "keyName"=>"REDUNDANT_POWER_SUPPLY", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"500", "description"=>"500 GB SATA II", "id"=>14, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_500GB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"RAID 0", "id"=>488, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_0", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"RAID 10", "id"=>491, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_10", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Private Network Uplink", "id"=>496, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>497}, {"capacity"=>"16", "description"=>"16 GB Registered (FB) DDR2 667", "id"=>280, "itemTaxCategoryId"=>166, "keyName"=>"RAM_16_GB_DDR2_667_ECC_FB_DIMM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"250", "description"=>"250 GB iSCSI SAN Storage", "id"=>552, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_250_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>612}, {"capacity"=>"20", "description"=>"20GB EVault Disk to Disk Enterprise Backup", "id"=>558, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_20_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>739}, {"capacity"=>"500", "description"=>"500 GB NAS", "id"=>611, "itemTaxCategoryId"=>166, "keyName"=>"NAS_500_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>605}, {"description"=>"Microsoft SQL Server 2008 Workgroup", "id"=>684, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WORKGROUP", "softwareDescriptionId"=>304, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard Edition SP2 (64bit)", "id"=>936, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_SP2", "softwareDescriptionId"=>447, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Enterprise Edition (64bit)", "id"=>978, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_64_BIT_R2_2", "softwareDescriptionId"=>477, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Datacenter Edition With Hyper-V (64bit)", "id"=>980, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_R2_2", "softwareDescriptionId"=>478, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix Essentials for XenServer 5.5 (Billed per VM)", "id"=>1077, "itemTaxCategoryId"=>166, "keyName"=>"CITRIX_ESSENTIALS_XENSERVER_5_5", "softwareDescriptionId"=>521, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Workgroup R2", "id"=>1164, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WORKGROUP_R2", "softwareDescriptionId"=>697, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Redundant Public & Private Network Uplinks", "id"=>1284, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_REDUNDANT_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 10 (Linux) Unlimited Domain w/ Power Pack", "id"=>1306, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_LINUX_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>939, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 5.6.1", "id"=>1322, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6_1", "softwareDescriptionId"=>801, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x (32 bit)", "id"=>3904, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_32_BIT", "softwareDescriptionId"=>1258, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 6.x Squeeze/Stable (32 bit)", "id"=>3967, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_6_X_SQUEEZE_32_BIT", "softwareDescriptionId"=>918, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESX 4.1", "id"=>3969, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESX_4_1", "softwareDescriptionId"=>800, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 5.x (64 bit)", "id"=>4093, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_5_X_64_BIT_3", "softwareDescriptionId"=>1158, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Express Edition", "id"=>4150, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_EXPRESS", "softwareDescriptionId"=>1005, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1500", "description"=>"1500GB EVault Disk to Disk Enterprise Backup", "id"=>4185, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_1500_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>955}, {"capacity"=>"0", "description"=>"Windows Server 2012 Datacenter Edition (64bit)", "id"=>4237, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_DC_64_BIT", "softwareDescriptionId"=>1082, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 1 Pack", "id"=>4345, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_1_PACK", "softwareDescriptionId"=>1094, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 25 Pack", "id"=>4348, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_25_PACK", "softwareDescriptionId"=>1097, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable (64 bit)", "id"=>4405, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_64_BIT", "softwareDescriptionId"=>1104, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware vCenter 5.5 Standard", "id"=>4598, "itemTaxCategoryId"=>166, "keyName"=>"VMWARE_VCENTER_5_5_STANDARD", "softwareDescriptionId"=>1275, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 12 - 30 Domain w/ Power Pack", "id"=>6010, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_12_30_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1414, "upgradeItemId"=>nil}, {"capacity"=>"8", "description"=>"8 Public IP Addresses", "id"=>17, "itemTaxCategoryId"=>166, "keyName"=>"8_PUBLIC_IP_ADDRESSES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"MySQL 5.0 for Windows", "id"=>23, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_0_WINDOWS", "softwareDescriptionId"=>13, "upgradeItemId"=>nil}, {"description"=>"Email and Ticket", "id"=>51, "itemTaxCategoryId"=>166, "keyName"=>"NOTIFICATION_EMAIL_AND_TICKET", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"NOC Monitoring", "id"=>54, "itemTaxCategoryId"=>166, "keyName"=>"NOC_MONITORING", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"cPanel/WHM with Fantastico and RVskin", "id"=>96, "itemTaxCategoryId"=>166, "keyName"=>"CPANELWHM_WITH_FANTASTICO_AND_RVSKIN", "softwareDescriptionId"=>31, "upgradeItemId"=>nil}, {"description"=>"Unlimited Bandwidth (100 Mbps Uplink)", "id"=>97, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_UNLIMITED_100_MBPS_UPLINK", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"RAID 1", "id"=>489, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_1", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"RAID 5", "id"=>490, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_5", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Reboot / KVM over IP", "id"=>504, "itemTaxCategoryId"=>166, "keyName"=>"REBOOT_KVM_OVER_IP", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1000 GB iSCSI SAN Storage", "id"=>554, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_1000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>783}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard Edition SP2 (32bit)", "id"=>933, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_32_BIT_SP2", "softwareDescriptionId"=>444, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Enterprise Edition SP2 (64bit)", "id"=>938, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_64_BIT_SP2", "softwareDescriptionId"=>449, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Datacenter Edition SP2 (64bit)", "id"=>940, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_SP2", "softwareDescriptionId"=>451, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Citrix XenServer 5.5", "id"=>950, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_5", "softwareDescriptionId"=>642, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Web Edition (64bit)", "id"=>976, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_64_BIT_R2_SP1", "softwareDescriptionId"=>832, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Standard SP2 with R2 (32 bit)", "id"=>421, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_STD_32_BIT_SP2_WR2", "softwareDescriptionId"=>125, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Web Edition SP2 (32bit)", "id"=>934, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_32_BIT_SP2", "softwareDescriptionId"=>445, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"70", "description"=>"Virtuozzo Containers 4 for Linux - 4 processors - 70 VPS", "id"=>1084, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_4_PROCESSORS_70_VPS", "softwareDescriptionId"=>586, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2.00 TB SATA II", "id"=>1091, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_2_00TB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Enterprise for XenServer 5.6", "id"=>1300, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ENTERPRISE_FOR_XENSERVER_5_6", "softwareDescriptionId"=>726, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin - Minimal Install (64 bit)", "id"=>4170, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_MINIMAL_64_BIT_2", "softwareDescriptionId"=>1184, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Windows) Unlimited Domain w/ Power Pack", "id"=>4200, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_WINDOWS_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1274, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.1", "id"=>4258, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_1", "softwareDescriptionId"=>1065, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware vCenter 5.1 Standard", "id"=>4298, "itemTaxCategoryId"=>166, "keyName"=>"VMWARE_VCENTER_5_1_STANDARD", "softwareDescriptionId"=>1090, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (4 TB)", "id"=>4372, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_4_TB", "softwareDescriptionId"=>1123, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"20", "description"=>"20Mbps Hardware Firewall", "id"=>4550, "itemTaxCategoryId"=>166, "keyName"=>"20MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.2.1", "id"=>4569, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_2_1", "softwareDescriptionId"=>1257, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10000", "description"=>"10 Gbps Dual Private Network Uplinks (Unbonded)", "id"=>5102, "itemTaxCategoryId"=>166, "keyName"=>"10_GBPS_DUAL_PRIVATE_NETWORK_UPLINKS_UNBONDED", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Enterprise Edition", "id"=>5120, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_ENTERPRISE_EDITION_2", "softwareDescriptionId"=>1330, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Enterprise", "id"=>81, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_ENTERPRISE", "softwareDescriptionId"=>21, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Public & Private Network Uplinks", "id"=>187, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>188}, {"capacity"=>"1000", "description"=>"1000Mbps Hardware Firewall", "id"=>297, "itemTaxCategoryId"=>166, "keyName"=>"1000MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x (64 bit)", "id"=>420, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_64_BIT", "softwareDescriptionId"=>1240, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Enterprise SP2 with R2 (32 bit)", "id"=>423, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_ENT_32_BIT_SP2_WR2", "softwareDescriptionId"=>128, "upgradeItemId"=>nil}, {"capacity"=>"96", "description"=>"96 GB Registered (FB) DDR2 667", "id"=>671, "itemTaxCategoryId"=>166, "keyName"=>"RAM_96_GB_DDR2_667_ECC_FB_DIMM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 8.x (32 bit)", "id"=>1066, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_8_X_32_BIT", "softwareDescriptionId"=>1022, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"60", "description"=>"60GB EVault Disk to Disk Enterprise Backup", "id"=>1076, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_60_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>560}, {"capacity"=>"3", "description"=>"Virtuozzo Containers 4 for Linux - 4 processors - 3 VPS", "id"=>1079, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_4_PROCESSORS_3_VPS", "softwareDescriptionId"=>581, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"150", "description"=>"Virtuozzo Containers 4 for Linux - 4 processors - 150 VPS", "id"=>1086, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_4_PROCESSORS_150_VPS", "softwareDescriptionId"=>588, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"2", "description"=>"Monitoring Package - Advanced", "id"=>1249, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_ADVANCED", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"capacity"=>"10000", "description"=>"10 Gbps Public & Private Network Uplinks", "id"=>1281, "itemTaxCategoryId"=>166, "keyName"=>"10_GBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"50", "description"=>"50GB EVault Disk to Disk Enterprise Backup", "id"=>3784, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_50_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>1076}, {"description"=>"Parallels Plesk Panel 10 (Windows) 100 Domain w/ Power Pack", "id"=>3786, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_WINDOWS_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>787, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x (64 bit)", "id"=>3907, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_64_BIT", "softwareDescriptionId"=>1261, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Redundant Private Network Uplinks", "id"=>3956, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"3000", "description"=>"3.00 TB SATA III", "id"=>3989, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_3_00TB_SATA_III", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Enterprise for XenServer 6.x", "id"=>4105, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ENTERPRISE_FOR_XENSERVER_6_X", "softwareDescriptionId"=>909, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 1 Pack", "id"=>4153, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_1_PACK", "softwareDescriptionId"=>1015, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin (32 bit)", "id"=>4165, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_32_BIT", "softwareDescriptionId"=>1166, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Dual Public & Private Network Uplinks (Unbonded)", "id"=>4263, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_DUAL_PUBLIC_PRIVATE_NETWORK_UPLINKS_UNBONDED", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"4000", "description"=>"4.00 TB SATA III", "id"=>4281, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_4_00TB_SATA_III", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x (64 bit) (per-processor licensing)", "id"=>4321, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_64_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1247, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable - Minimal Install (32 bit)", "id"=>4406, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_MINIMAL_32_BIT", "softwareDescriptionId"=>1176, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable - Minimal Install (64 bit)", "id"=>4407, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_MINIMAL_64_BIT", "softwareDescriptionId"=>1177, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MySQL 5.0.51 for Windows", "id"=>4557, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_0_51_WINDOWS", "softwareDescriptionId"=>220, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESXi 5.5", "id"=>4562, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESXI_5_5", "softwareDescriptionId"=>1256, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Express Edition", "id"=>5122, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_EXPRESS_EDITION", "softwareDescriptionId"=>1332, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 12 - Unlimited Domain w/ Power Pack", "id"=>6014, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_12_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1420, "upgradeItemId"=>nil}, {"capacity"=>"4", "description"=>"4 Public IP Addresses", "id"=>16, "itemTaxCategoryId"=>166, "keyName"=>"4_PUBLIC_IP_ADDRESSES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Unlimited Bandwidth (10 Mbps Uplink)", "id"=>30, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_UNLIMITED_10_MBPS_UPLINK", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB NAS", "id"=>43, "itemTaxCategoryId"=>166, "keyName"=>"NAS_100_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>44}, {"description"=>"Business Continuance Insurance", "id"=>84, "itemTaxCategoryId"=>108, "keyName"=>"BUSINESS_CONTINUANCE_INSURANCE", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"24", "description"=>"24 GB Registered (FB) DDR2 667", "id"=>492, "itemTaxCategoryId"=>166, "keyName"=>"RAM_24_GB_DDR2_667_ECC_FB_DIMM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100GB EVault Disk to Disk Enterprise Backup", "id"=>560, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_100_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4182}, {"capacity"=>"64", "description"=>"/64 Block Static Public IPv6 Addresses", "id"=>784, "itemTaxCategoryId"=>166, "keyName"=>"64_BLOCK_STATIC_PUBLIC_IPV6_ADDRESSES", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESX 4.0", "id"=>1078, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESX_4_0", "softwareDescriptionId"=>497, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"50", "description"=>"Virtuozzo Containers 4 for Linux - 4 processors - 50 VPS", "id"=>1083, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_4_PROCESSORS_50_VPS", "softwareDescriptionId"=>585, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx (64 bit)", "id"=>1137, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_64_BIT", "softwareDescriptionId"=>775, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Enterprise R2", "id"=>1165, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_ENTERPRISE_R2", "softwareDescriptionId"=>699, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Datacenter R2", "id"=>1166, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_DATACENTER_R2", "softwareDescriptionId"=>700, "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Monitoring Package - Basic", "id"=>1248, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_BASIC", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2000Mbps Hardware Firewall", "id"=>1296, "itemTaxCategoryId"=>166, "keyName"=>"2000MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Advanced for XenServer 5.6", "id"=>1299, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ADVANCED_FOR_XENSERVER_5_6", "softwareDescriptionId"=>726, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"EVault Plugin - BMR (Bare Metal Restore)", "id"=>961, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_PLUGIN_BMR_BARE_METAL_RESTORE", "softwareDescriptionId"=>467, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 5.6.2", "id"=>3886, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6_2", "softwareDescriptionId"=>867, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Advanced for XenServer 6.x", "id"=>4104, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ADVANCED_FOR_XENSERVER_6_X", "softwareDescriptionId"=>908, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"400", "description"=>"400 GB SSD", "id"=>4181, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_400GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Cloudera Distribution for Hadoop 4", "id"=>4301, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_CLOUDERA_DISTRIBUTION_HADOOP_4", "softwareDescriptionId"=>1099, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x (32 bit) (per-processor licensing)", "id"=>4320, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_32_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1246, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Riak 1.x", "id"=>4327, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_RIAK_1_X", "softwareDescriptionId"=>1114, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Redundant Private Network Uplinks", "id"=>4331, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Redundant Public & Private Network Uplinks", "id"=>4336, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_REDUNDANT_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>1284}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (48 TB)", "id"=>4370, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_48_TB", "softwareDescriptionId"=>1154, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Standard Edition (64 bit)", "id"=>4549, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_STD_64_BIT", "softwareDescriptionId"=>1225, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Express", "id"=>24, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_EXPRESS", "softwareDescriptionId"=>9, "upgradeItemId"=>nil}, {"capacity"=>"40", "description"=>"40 GB NAS", "id"=>41, "itemTaxCategoryId"=>166, "keyName"=>"NAS_40_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>42}, {"description"=>"Host Ping", "id"=>49, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_HOST_PING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Automated Notification", "id"=>52, "itemTaxCategoryId"=>166, "keyName"=>"AUTOMATED_NOTIFICATION", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Automated Reboot from Monitoring", "id"=>53, "itemTaxCategoryId"=>166, "keyName"=>"AUTOMATED_REBOOT_FROM_MONITORING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"300", "description"=>"300 GB SA-SCSI 15K RPM", "id"=>352, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_300GB_SASCSI_15K_RPM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"32", "description"=>"32 GB Registered (FB) DDR2 667", "id"=>493, "itemTaxCategoryId"=>166, "keyName"=>"RAM_32_GB_DDR2_667_ECC_FB_DIMM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"500", "description"=>"500 GB iSCSI SAN Storage", "id"=>553, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_500_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>621}, {"capacity"=>"500", "description"=>"500GB EVault Disk to Disk Enterprise Backup", "id"=>562, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_500_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4184}, {"capacity"=>"120", "description"=>"120 GB iSCSI SAN Storage", "id"=>575, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_120_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>622}, {"capacity"=>"48", "description"=>"48 GB Registered (FB) DDR2 667", "id"=>646, "itemTaxCategoryId"=>166, "keyName"=>"RAM_48_GB_DDR2_667_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Web Edition SP2 (64bit)", "id"=>935, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_64_BIT_SP2", "softwareDescriptionId"=>446, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Cloudera Distribution for Hadoop 2", "id"=>1044, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_CLOUDERA_DISTRIBUTION_HADOOP_2", "softwareDescriptionId"=>520, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"30", "description"=>"Virtuozzo Containers 4 for Linux - 4 processors - 30 VPS", "id"=>1082, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_4_PROCESSORS_30_VPS", "softwareDescriptionId"=>584, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Citrix XenServer 5.6", "id"=>1189, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6", "softwareDescriptionId"=>704, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft WebMatrix", "id"=>3898, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_WEBMATRIX_2", "softwareDescriptionId"=>868, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"International Services", "id"=>3955, "itemTaxCategoryId"=>166, "keyName"=>"INTERNATIONAL_SERVICES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 6.x (32 bit)", "id"=>4094, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_6_X_32_BIT_2", "softwareDescriptionId"=>1172, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 6.x (64 bit)", "id"=>4095, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_6_X_64_BIT", "softwareDescriptionId"=>1175, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"64", "description"=>"1 IPv6 Address", "id"=>4097, "itemTaxCategoryId"=>166, "keyName"=>"1_IPV6_ADDRESS", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Web Edition", "id"=>4147, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_WEB", "softwareDescriptionId"=>1004, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Enterprise Edition", "id"=>4149, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_ENTERPRISE", "softwareDescriptionId"=>1001, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MongoDB", "id"=>4226, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MONGODB", "softwareDescriptionId"=>1083, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 Datacenter Edition With Hyper-V (64bit)", "id"=>4247, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_DC_64_BIT_2", "softwareDescriptionId"=>1082, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x (32 bit) (per-processor licensing)", "id"=>4318, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_32_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1227, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Redundant Public & Private Network Uplinks", "id"=>4332, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_REDUNDANT_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>4336}, {"capacity"=>"0", "description"=>"Idera Server Backup 5.0 Enterprise (Windows)", "id"=>4344, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_SERVER_BACKUP_5_0_ENTERPRISE_WINDOWS", "softwareDescriptionId"=>1092, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 5 Pack", "id"=>4346, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_5_PACK", "softwareDescriptionId"=>1095, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"0 GB Bandwidth", "id"=>4481, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_0_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Datacenter Edition (64bit)", "id"=>4547, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_DC_64_BIT", "softwareDescriptionId"=>1226, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"200", "description"=>"200Mbps Hardware Firewall", "id"=>4551, "itemTaxCategoryId"=>166, "keyName"=>"200MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"cPanel/WHM with Softaculous and RVskin", "id"=>4608, "itemTaxCategoryId"=>166, "keyName"=>"CPANELWHM_WITH_SOFTACULOUS_AND_RVSKIN", "softwareDescriptionId"=>1292, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 7.x (64 bit)", "id"=>5920, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_7_X_64_BIT", "softwareDescriptionId"=>1400, "units"=>"N/A", "upgradeItemId"=>nil}]
          fixture_package_items[35] = [{"capacity"=>"20", "description"=>"20 GB NAS", "id"=>40, "itemTaxCategoryId"=>166, "keyName"=>"NAS_20_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>41}, {"description"=>"Microsoft SQL Server 2005 Standard", "id"=>79, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_STANDARD", "softwareDescriptionId"=>8, "upgradeItemId"=>nil}, {"capacity"=>"2", "description"=>"2 GB Registered (FB) DDR2 667", "id"=>253, "itemTaxCategoryId"=>166, "keyName"=>"RAM_2_GB_DDR2_667_ECC_FB_DIMM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10Mbps Hardware Firewall", "id"=>299, "itemTaxCategoryId"=>166, "keyName"=>"10MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"Unlimited SSL VPN Users & 1 PPTP VPN User per account", "id"=>309, "itemTaxCategoryId"=>166, "keyName"=>"UNLIMITED_SSL_VPN_USERS_1_PPTP_VPN_USER_PER_ACCOUNT", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Standard SP2 with R2 (64 bit)", "id"=>422, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_STD_64_BIT_SP2_WR2", "softwareDescriptionId"=>126, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Enterprise SP2 with R2 (64 bit)", "id"=>424, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_ENT_64_BIT_SP2_WR2", "softwareDescriptionId"=>127, "upgradeItemId"=>nil}, {"capacity"=>"12", "description"=>"12 GB Registered (FB) DDR2 667", "id"=>279, "itemTaxCategoryId"=>166, "keyName"=>"RAM_12_GB_DDR2_667_ECC_FB_DIMM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB iSCSI SAN Storage", "id"=>551, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_100_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>575}, {"capacity"=>"40", "description"=>"40GB EVault Disk to Disk Enterprise Backup", "id"=>559, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_40_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>3784}, {"capacity"=>"1000", "description"=>"1000GB EVault Disk to Disk Enterprise Backup", "id"=>563, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_1000_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4185}, {"capacity"=>"0", "description"=>"FreeBSD 7.x  (64 bit)", "id"=>637, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_7_X_64_BIT", "softwareDescriptionId"=>667, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Web", "id"=>685, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WEB", "softwareDescriptionId"=>305, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Enterprise Edition SP2 (32bit)", "id"=>937, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_32_BIT_SP2", "softwareDescriptionId"=>448, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2000GB EVault Disk to Disk Enterprise Backup", "id"=>955, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_2000_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Web R2", "id"=>1163, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WEB_R2", "softwareDescriptionId"=>696, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Express R2", "id"=>1162, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_EXPRESS_R2", "softwareDescriptionId"=>701, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 10 (Linux) 100 Domain w/ Power Pack", "id"=>1305, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_LINUX_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>938, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"200", "description"=>"200 GB SSD", "id"=>3811, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_200GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 6.x Squeeze/Stable (64 bit)", "id"=>3968, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_6_X_SQUEEZE_64_BIT", "softwareDescriptionId"=>919, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.0.0", "id"=>3977, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_0_0", "softwareDescriptionId"=>836, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 5.x (32 bit)", "id"=>4092, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_5_X_32_BIT_2", "softwareDescriptionId"=>1156, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.0.2", "id"=>4133, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_0_2", "softwareDescriptionId"=>961, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin - Minimal Install (32 bit)", "id"=>4169, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_MINIMAL_32_BIT", "softwareDescriptionId"=>1186, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"350", "description"=>"350GB EVault Disk to Disk Enterprise Backup", "id"=>4183, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_350_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>562}, {"capacity"=>"750", "description"=>"750GB EVault Disk to Disk Enterprise Backup", "id"=>4184, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_750_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>563}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Linux) 100 Domain w/ Power Pack", "id"=>4195, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_LINUX_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1191, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Windows) 100 Domain w/ Power Pack", "id"=>4199, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_WINDOWS_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1273, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 1 VM", "id"=>4303, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_1_VM", "softwareDescriptionId"=>1105, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - Unlimited VMs", "id"=>4307, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_UNLIMITED_VMS", "softwareDescriptionId"=>1112, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.2", "id"=>4467, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_2", "softwareDescriptionId"=>1171, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Dual Public & Private Network Uplinks (Unbonded)", "id"=>5118, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_DUAL_PUBLIC_PRIVATE_NETWORK_UPLINKS_UNBONDED", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"80", "description"=>"80 GB NAS", "id"=>42, "itemTaxCategoryId"=>166, "keyName"=>"NAS_80_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>43}, {"capacity"=>"250", "description"=>"250 GB NAS", "id"=>44, "itemTaxCategoryId"=>166, "keyName"=>"NAS_250_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>411}, {"capacity"=>"1000", "description"=>"1 Gbps Public & Private Network Uplinks", "id"=>188, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"APF Software Firewall for Linux", "id"=>300, "itemTaxCategoryId"=>166, "keyName"=>"APF_SOFTWARE_FIREWALL_FOR_LINUX", "softwareDescriptionId"=>71, "upgradeItemId"=>nil}, {"description"=>"Nessus Vulnerability Assessment & Reporting", "id"=>307, "itemTaxCategoryId"=>98, "keyName"=>"NESSUS_VULNERABILITY_ASSESSMENT_REPORTING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"McAfee VirusScan Enterprise", "id"=>397, "itemTaxCategoryId"=>98, "keyName"=>"MCAFEE_VIRUSSCAN_ANTIVIRUS_WINDOWS", "softwareDescriptionId"=>820, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x (32 bit)", "id"=>419, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_32_BIT", "softwareDescriptionId"=>1239, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"6", "description"=>"6 GB Registered (FB) DDR2 667", "id"=>255, "itemTaxCategoryId"=>166, "keyName"=>"RAM_6_GB_DDR2_667_ECC_FB_DIMM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"description"=>"Non-RAID", "id"=>487, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_NONRAID", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Microsoft Windows Firewall", "id"=>495, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_WINDOWS_FIREWALL", "softwareDescriptionId"=>106, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Private Network Uplink", "id"=>498, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"4", "description"=>"4 GB Registered (FB) DDR2 667", "id"=>254, "itemTaxCategoryId"=>166, "keyName"=>"RAM_4_GB_DDR2_667_ECC_FB_DIMM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"80", "description"=>"80 GB iSCSI SAN Storage", "id"=>550, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_80_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>551}, {"capacity"=>"250", "description"=>"250GB EVault Disk to Disk Enterprise Backup", "id"=>561, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_250_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4183}, {"capacity"=>"0", "description"=>"FreeBSD 6.x  (64 bit)", "id"=>640, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_6_X_64_BIT", "softwareDescriptionId"=>371, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Express", "id"=>681, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_EXPRESS", "softwareDescriptionId"=>308, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Enterprise", "id"=>682, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_ENTERPRISE", "softwareDescriptionId"=>307, "upgradeItemId"=>nil}, {"capacity"=>"30", "description"=>"30GB EVault Disk to Disk Enterprise Backup", "id"=>739, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_30_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>559}, {"capacity"=>"10", "description"=>"Virtuozzo Containers 4 for Linux - 10 VPS", "id"=>741, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_10_VPS", "softwareDescriptionId"=>318, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Datacenter Edition SP2 (32bit)", "id"=>939, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_32_BIT_SP2", "softwareDescriptionId"=>450, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Standard R2", "id"=>1161, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_STANDARD_R2", "softwareDescriptionId"=>698, "upgradeItemId"=>nil}, {"capacity"=>"3000", "description"=>"3000 GB iSCSI SAN Storage", "id"=>1176, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_3000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"3", "description"=>"Monitoring Package - Premium Application", "id"=>1250, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_PREMIUM_APPLICATION", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 10 (Windows) Unlimited Domain w/ Power Pack", "id"=>3785, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_WINDOWS_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>788, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Standard Edition", "id"=>4148, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_STANDARD", "softwareDescriptionId"=>1003, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 Standard Edition (64 bit)", "id"=>4233, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_STD_64_BIT", "softwareDescriptionId"=>1076, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESXi 5.1", "id"=>4272, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESXI_5_1", "softwareDescriptionId"=>1086, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 5 VMs", "id"=>4304, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_5_VMS", "softwareDescriptionId"=>1109, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 10 VMs", "id"=>4305, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_10_VMS", "softwareDescriptionId"=>1110, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"15", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 15 VMs", "id"=>4306, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_15_VMS", "softwareDescriptionId"=>1111, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x (64 bit) (per-processor licensing)", "id"=>4319, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_64_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1228, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable (32 bit)", "id"=>4404, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_32_BIT", "softwareDescriptionId"=>1169, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"RAID", "id"=>4478, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Datacenter Edition With Hyper-V (64bit)", "id"=>4548, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_DC_64_BIT_2", "softwareDescriptionId"=>1226, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Host Ping and TCP Service Monitoring", "id"=>50, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_HOST_PING_AND_TCP_SERVICE", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Public & Private Network Uplinks", "id"=>186, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>187}, {"description"=>"McAfee Host Intrusion Protection w/Reporting", "id"=>302, "itemTaxCategoryId"=>98, "keyName"=>"MCAFEE_HOST_INTRUSION_PROTECTION_WREPORTING", "softwareDescriptionId"=>916, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1.00 TB SATA II", "id"=>471, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_1_00TB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Private Network Uplink", "id"=>497, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>498}, {"capacity"=>"20", "description"=>"20 GB iSCSI SAN Storage", "id"=>548, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_20_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>549}, {"capacity"=>"40", "description"=>"40 GB iSCSI SAN Storage", "id"=>549, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_40_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>598}, {"capacity"=>"2000", "description"=>"2000 GB iSCSI SAN Storage", "id"=>626, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_2000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>1176}, {"description"=>"Microsoft SQL Server 2008 Standard", "id"=>683, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_STANDARD", "softwareDescriptionId"=>306, "upgradeItemId"=>nil}, {"capacity"=>"70", "description"=>"Virtuozzo Containers 4 for Linux - 70 VPS", "id"=>744, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_70_VPS", "softwareDescriptionId"=>322, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Standard Edition (64bit)", "id"=>977, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_R2", "softwareDescriptionId"=>475, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Datacenter Edition (64bit)", "id"=>979, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_R2", "softwareDescriptionId"=>478, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 8.x (64 bit)", "id"=>1065, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_8_X_64_BIT_2", "softwareDescriptionId"=>1019, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"600", "description"=>"600 GB SA-SCSI 15K RPM", "id"=>1094, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_600GB_SASCSI_15K_RPM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx (32 bit)", "id"=>1136, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_32_BIT", "softwareDescriptionId"=>774, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 9.x (32 bit)", "id"=>4137, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_9_X_32_BIT_2", "softwareDescriptionId"=>1264, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin (64 bit)", "id"=>4166, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_64_BIT", "softwareDescriptionId"=>1165, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"175", "description"=>"175GB EVault Disk to Disk Enterprise Backup", "id"=>4182, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_175_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>561}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Linux) Unlimited Domain w/ Power Pack", "id"=>4197, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_LINUX_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1197, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"800", "description"=>"800 GB SSD", "id"=>4356, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_800GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (128 TB)", "id"=>4369, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_128_TB", "softwareDescriptionId"=>1155, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (16 TB)", "id"=>4371, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_16_TB", "softwareDescriptionId"=>1153, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Vyatta 6.x Subscription Edition (64 bit)", "id"=>4396, "itemTaxCategoryId"=>166, "keyName"=>"OS_VYATTA_6_X_SUBSCRIPTION_EDITION_64_BIT_2", "softwareDescriptionId"=>1221, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"No Operating System", "id"=>4648, "itemTaxCategoryId"=>166, "keyName"=>"OS_NO_OPERATING_SYSTEM", "softwareDescriptionId"=>1312, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Standard Edition", "id"=>5124, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_STANDARD_EDITION", "softwareDescriptionId"=>1334, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"1 IP Address", "id"=>15, "itemTaxCategoryId"=>166, "keyName"=>"1_IP_ADDRESS", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"MySQL for Linux", "id"=>22, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_LINUX", "softwareDescriptionId"=>156, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Workgroup", "id"=>80, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_WORKGROUP", "softwareDescriptionId"=>20, "upgradeItemId"=>nil}, {"capacity"=>"20000", "description"=>"20000 GB Bandwidth", "id"=>249, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_20000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100Mbps Hardware Firewall", "id"=>298, "itemTaxCategoryId"=>166, "keyName"=>"100MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"16", "description"=>"16 GB Registered (FB) DDR2 667", "id"=>280, "itemTaxCategoryId"=>166, "keyName"=>"RAM_16_GB_DDR2_667_ECC_FB_DIMM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"500", "description"=>"500 GB SATA II", "id"=>14, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_500GB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"RAID 0", "id"=>488, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_0", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"RAID 10", "id"=>491, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_10", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Private Network Uplink", "id"=>496, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>497}, {"capacity"=>"250", "description"=>"250 GB iSCSI SAN Storage", "id"=>552, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_250_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>612}, {"capacity"=>"20", "description"=>"20GB EVault Disk to Disk Enterprise Backup", "id"=>558, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_20_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>739}, {"capacity"=>"500", "description"=>"500 GB NAS", "id"=>611, "itemTaxCategoryId"=>166, "keyName"=>"NAS_500_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>605}, {"description"=>"Microsoft SQL Server 2008 Workgroup", "id"=>684, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WORKGROUP", "softwareDescriptionId"=>304, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"Virtuozzo Containers 4 for Linux - 5 VPS", "id"=>740, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_5_VPS", "softwareDescriptionId"=>317, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard Edition SP2 (64bit)", "id"=>936, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_SP2", "softwareDescriptionId"=>447, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Enterprise Edition (64bit)", "id"=>978, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_64_BIT_R2_2", "softwareDescriptionId"=>477, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Datacenter Edition With Hyper-V (64bit)", "id"=>980, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_R2_2", "softwareDescriptionId"=>478, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix Essentials for XenServer 5.5 (Billed per VM)", "id"=>1077, "itemTaxCategoryId"=>166, "keyName"=>"CITRIX_ESSENTIALS_XENSERVER_5_5", "softwareDescriptionId"=>521, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Workgroup R2", "id"=>1164, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WORKGROUP_R2", "softwareDescriptionId"=>697, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Redundant Public & Private Network Uplinks", "id"=>1284, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_REDUNDANT_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 10 (Linux) Unlimited Domain w/ Power Pack", "id"=>1306, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_LINUX_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>939, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 5.6.1", "id"=>1322, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6_1", "softwareDescriptionId"=>801, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x (32 bit)", "id"=>3904, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_32_BIT", "softwareDescriptionId"=>1258, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 6.x Squeeze/Stable (32 bit)", "id"=>3967, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_6_X_SQUEEZE_32_BIT", "softwareDescriptionId"=>918, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESX 4.1", "id"=>3969, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESX_4_1", "softwareDescriptionId"=>800, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 5.x (64 bit)", "id"=>4093, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_5_X_64_BIT_3", "softwareDescriptionId"=>1158, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Express Edition", "id"=>4150, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_EXPRESS", "softwareDescriptionId"=>1005, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1500", "description"=>"1500GB EVault Disk to Disk Enterprise Backup", "id"=>4185, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_1500_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>955}, {"capacity"=>"0", "description"=>"Windows Server 2012 Datacenter Edition (64bit)", "id"=>4237, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_DC_64_BIT", "softwareDescriptionId"=>1082, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable (64 bit)", "id"=>4405, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_64_BIT", "softwareDescriptionId"=>1104, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware vCenter 5.5 Standard", "id"=>4598, "itemTaxCategoryId"=>166, "keyName"=>"VMWARE_VCENTER_5_5_STANDARD", "softwareDescriptionId"=>1275, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 12 - 30 Domain w/ Power Pack", "id"=>6010, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_12_30_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1414, "upgradeItemId"=>nil}, {"capacity"=>"8", "description"=>"8 Public IP Addresses", "id"=>17, "itemTaxCategoryId"=>166, "keyName"=>"8_PUBLIC_IP_ADDRESSES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"MySQL 5.0 for Windows", "id"=>23, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_0_WINDOWS", "softwareDescriptionId"=>13, "upgradeItemId"=>nil}, {"description"=>"Email and Ticket", "id"=>51, "itemTaxCategoryId"=>166, "keyName"=>"NOTIFICATION_EMAIL_AND_TICKET", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"NOC Monitoring", "id"=>54, "itemTaxCategoryId"=>166, "keyName"=>"NOC_MONITORING", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"cPanel/WHM with Fantastico and RVskin", "id"=>96, "itemTaxCategoryId"=>166, "keyName"=>"CPANELWHM_WITH_FANTASTICO_AND_RVSKIN", "softwareDescriptionId"=>31, "upgradeItemId"=>nil}, {"description"=>"Unlimited Bandwidth (100 Mbps Uplink)", "id"=>97, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_UNLIMITED_100_MBPS_UPLINK", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"RAID 1", "id"=>489, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_1", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"RAID 5", "id"=>490, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_5", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Reboot / KVM over IP", "id"=>504, "itemTaxCategoryId"=>166, "keyName"=>"REBOOT_KVM_OVER_IP", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1000 GB iSCSI SAN Storage", "id"=>554, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_1000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>783}, {"capacity"=>"0", "description"=>"FreeBSD 6.x  (32 bit)", "id"=>639, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_6_X_32_BIT", "softwareDescriptionId"=>372, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"150", "description"=>"Virtuozzo Containers 4 for Linux - 150 VPS", "id"=>746, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_150_VPS", "softwareDescriptionId"=>324, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"50", "description"=>"Virtuozzo Containers 4 for Linux - 50 VPS", "id"=>743, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_50_VPS", "softwareDescriptionId"=>321, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard Edition SP2 (32bit)", "id"=>933, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_32_BIT_SP2", "softwareDescriptionId"=>444, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Enterprise Edition SP2 (64bit)", "id"=>938, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_64_BIT_SP2", "softwareDescriptionId"=>449, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Datacenter Edition SP2 (64bit)", "id"=>940, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_SP2", "softwareDescriptionId"=>451, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Citrix XenServer 5.5", "id"=>950, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_5", "softwareDescriptionId"=>642, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Web Edition (64bit)", "id"=>976, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_64_BIT_R2_SP1", "softwareDescriptionId"=>832, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Standard SP2 with R2 (32 bit)", "id"=>421, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_STD_32_BIT_SP2_WR2", "softwareDescriptionId"=>125, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Web Edition SP2 (32bit)", "id"=>934, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_32_BIT_SP2", "softwareDescriptionId"=>445, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2.00 TB SATA II", "id"=>1091, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_2_00TB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Enterprise for XenServer 5.6", "id"=>1300, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ENTERPRISE_FOR_XENSERVER_5_6", "softwareDescriptionId"=>726, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin - Minimal Install (64 bit)", "id"=>4170, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_MINIMAL_64_BIT_2", "softwareDescriptionId"=>1184, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Windows) Unlimited Domain w/ Power Pack", "id"=>4200, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_WINDOWS_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1274, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.1", "id"=>4258, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_1", "softwareDescriptionId"=>1065, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware vCenter 5.1 Standard", "id"=>4298, "itemTaxCategoryId"=>166, "keyName"=>"VMWARE_VCENTER_5_1_STANDARD", "softwareDescriptionId"=>1090, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (4 TB)", "id"=>4372, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_4_TB", "softwareDescriptionId"=>1123, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Vyatta 6.6 Community Edition (64 bit)", "id"=>4495, "itemTaxCategoryId"=>166, "keyName"=>"OS_VYATTA_6_6_COMMUNITY_EDITION_64_BIT", "softwareDescriptionId"=>1192, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"20", "description"=>"20Mbps Hardware Firewall", "id"=>4550, "itemTaxCategoryId"=>166, "keyName"=>"20MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Enterprise Edition", "id"=>5120, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_ENTERPRISE_EDITION_2", "softwareDescriptionId"=>1330, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Enterprise", "id"=>81, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_ENTERPRISE", "softwareDescriptionId"=>21, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Public & Private Network Uplinks", "id"=>187, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>188}, {"capacity"=>"1000", "description"=>"1000Mbps Hardware Firewall", "id"=>297, "itemTaxCategoryId"=>166, "keyName"=>"1000MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x (64 bit)", "id"=>420, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_64_BIT", "softwareDescriptionId"=>1240, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Enterprise SP2 with R2 (32 bit)", "id"=>423, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_ENT_32_BIT_SP2_WR2", "softwareDescriptionId"=>128, "upgradeItemId"=>nil}, {"capacity"=>"8", "description"=>"8 GB Registered (FB) DDR2 667", "id"=>256, "itemTaxCategoryId"=>166, "keyName"=>"RAM_8_GB_DDR2_667_ECC_FB_DIMM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 8.x (32 bit)", "id"=>1066, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_8_X_32_BIT", "softwareDescriptionId"=>1022, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"60", "description"=>"60GB EVault Disk to Disk Enterprise Backup", "id"=>1076, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_60_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>560}, {"capacity"=>"2", "description"=>"Monitoring Package - Advanced", "id"=>1249, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_ADVANCED", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"capacity"=>"50", "description"=>"50GB EVault Disk to Disk Enterprise Backup", "id"=>3784, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_50_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>1076}, {"description"=>"Parallels Plesk Panel 10 (Windows) 100 Domain w/ Power Pack", "id"=>3786, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_WINDOWS_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>787, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x (64 bit)", "id"=>3907, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_64_BIT", "softwareDescriptionId"=>1261, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"3000", "description"=>"3.00 TB SATA III", "id"=>3989, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_3_00TB_SATA_III", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Enterprise for XenServer 6.x", "id"=>4105, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ENTERPRISE_FOR_XENSERVER_6_X", "softwareDescriptionId"=>909, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin (32 bit)", "id"=>4165, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_32_BIT", "softwareDescriptionId"=>1166, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Dual Public & Private Network Uplinks (Unbonded)", "id"=>4263, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_DUAL_PUBLIC_PRIVATE_NETWORK_UPLINKS_UNBONDED", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"4000", "description"=>"4.00 TB SATA III", "id"=>4281, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_4_00TB_SATA_III", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Vyatta 6.5 Community Edition (64 bit)", "id"=>4315, "itemTaxCategoryId"=>166, "keyName"=>"OS_VYATTA_6_5_COMMUNITY_EDITION_64_BIT", "softwareDescriptionId"=>1106, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x (64 bit) (per-processor licensing)", "id"=>4321, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_64_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1247, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable - Minimal Install (32 bit)", "id"=>4406, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_MINIMAL_32_BIT", "softwareDescriptionId"=>1176, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable - Minimal Install (64 bit)", "id"=>4407, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_MINIMAL_64_BIT", "softwareDescriptionId"=>1177, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MySQL 5.0.51 for Windows", "id"=>4557, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_0_51_WINDOWS", "softwareDescriptionId"=>220, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESXi 5.5", "id"=>4562, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESXI_5_5", "softwareDescriptionId"=>1256, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 10.x (32 bit)", "id"=>4640, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_10_X_32_BIT", "softwareDescriptionId"=>1284, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 10.x (64 bit)", "id"=>4638, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_10_X_64_BIT", "softwareDescriptionId"=>1286, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Express Edition", "id"=>5122, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_EXPRESS_EDITION", "softwareDescriptionId"=>1332, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 12 - Unlimited Domain w/ Power Pack", "id"=>6014, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_12_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1420, "upgradeItemId"=>nil}, {"capacity"=>"4", "description"=>"4 Public IP Addresses", "id"=>16, "itemTaxCategoryId"=>166, "keyName"=>"4_PUBLIC_IP_ADDRESSES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Unlimited Bandwidth (10 Mbps Uplink)", "id"=>30, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_UNLIMITED_10_MBPS_UPLINK", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB NAS", "id"=>43, "itemTaxCategoryId"=>166, "keyName"=>"NAS_100_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>44}, {"description"=>"Business Continuance Insurance", "id"=>84, "itemTaxCategoryId"=>108, "keyName"=>"BUSINESS_CONTINUANCE_INSURANCE", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100GB EVault Disk to Disk Enterprise Backup", "id"=>560, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_100_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4182}, {"capacity"=>"30", "description"=>"Virtuozzo Containers 4 for Linux - 30 VPS", "id"=>742, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_30_VPS", "softwareDescriptionId"=>320, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"64", "description"=>"/64 Block Static Public IPv6 Addresses", "id"=>784, "itemTaxCategoryId"=>166, "keyName"=>"64_BLOCK_STATIC_PUBLIC_IPV6_ADDRESSES", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESX 4.0", "id"=>1078, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESX_4_0", "softwareDescriptionId"=>497, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx (64 bit)", "id"=>1137, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_64_BIT", "softwareDescriptionId"=>775, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Enterprise R2", "id"=>1165, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_ENTERPRISE_R2", "softwareDescriptionId"=>699, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Datacenter R2", "id"=>1166, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_DATACENTER_R2", "softwareDescriptionId"=>700, "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Monitoring Package - Basic", "id"=>1248, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_BASIC", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2000Mbps Hardware Firewall", "id"=>1296, "itemTaxCategoryId"=>166, "keyName"=>"2000MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Advanced for XenServer 5.6", "id"=>1299, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ADVANCED_FOR_XENSERVER_5_6", "softwareDescriptionId"=>726, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"EVault Plugin - BMR (Bare Metal Restore)", "id"=>961, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_PLUGIN_BMR_BARE_METAL_RESTORE", "softwareDescriptionId"=>467, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 5.6.2", "id"=>3886, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6_2", "softwareDescriptionId"=>867, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Advanced for XenServer 6.x", "id"=>4104, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ADVANCED_FOR_XENSERVER_6_X", "softwareDescriptionId"=>908, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 9.x (64 bit)", "id"=>4138, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_9_X_64_BIT", "softwareDescriptionId"=>1265, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"400", "description"=>"400 GB SSD", "id"=>4181, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_400GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Cloudera Distribution for Hadoop 4", "id"=>4301, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_CLOUDERA_DISTRIBUTION_HADOOP_4", "softwareDescriptionId"=>1099, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x (32 bit) (per-processor licensing)", "id"=>4320, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_32_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1246, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Riak 1.x", "id"=>4327, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_RIAK_1_X", "softwareDescriptionId"=>1114, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Redundant Public & Private Network Uplinks", "id"=>4336, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_REDUNDANT_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>1284}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (48 TB)", "id"=>4370, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_48_TB", "softwareDescriptionId"=>1154, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Standard Edition (64 bit)", "id"=>4549, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_STD_64_BIT", "softwareDescriptionId"=>1225, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Express", "id"=>24, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_EXPRESS", "softwareDescriptionId"=>9, "upgradeItemId"=>nil}, {"capacity"=>"40", "description"=>"40 GB NAS", "id"=>41, "itemTaxCategoryId"=>166, "keyName"=>"NAS_40_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>42}, {"description"=>"Host Ping", "id"=>49, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_HOST_PING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Automated Notification", "id"=>52, "itemTaxCategoryId"=>166, "keyName"=>"AUTOMATED_NOTIFICATION", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Automated Reboot from Monitoring", "id"=>53, "itemTaxCategoryId"=>166, "keyName"=>"AUTOMATED_REBOOT_FROM_MONITORING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"300", "description"=>"300 GB SA-SCSI 15K RPM", "id"=>352, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_300GB_SASCSI_15K_RPM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"500", "description"=>"500 GB iSCSI SAN Storage", "id"=>553, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_500_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>621}, {"capacity"=>"500", "description"=>"500GB EVault Disk to Disk Enterprise Backup", "id"=>562, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_500_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4184}, {"capacity"=>"120", "description"=>"120 GB iSCSI SAN Storage", "id"=>575, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_120_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>622}, {"capacity"=>"0", "description"=>"FreeBSD 7.x  (32 bit)", "id"=>638, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_7_X_32_BIT", "softwareDescriptionId"=>666, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Virtuozzo Containers 4 for Linux - 3 VPS", "id"=>738, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_3_VPS", "softwareDescriptionId"=>319, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"Virtuozzo Containers 4 for Linux - 100 VPS", "id"=>745, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_100_VPS", "softwareDescriptionId"=>323, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Web Edition SP2 (64bit)", "id"=>935, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_64_BIT_SP2", "softwareDescriptionId"=>446, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"32", "description"=>"32 GB Registered (FB) DDR2 667", "id"=>493, "itemTaxCategoryId"=>166, "keyName"=>"RAM_32_GB_DDR2_667_ECC_FB_DIMM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Cloudera Distribution for Hadoop 2", "id"=>1044, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_CLOUDERA_DISTRIBUTION_HADOOP_2", "softwareDescriptionId"=>520, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Citrix XenServer 5.6", "id"=>1189, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6", "softwareDescriptionId"=>704, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft WebMatrix", "id"=>3898, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_WEBMATRIX_2", "softwareDescriptionId"=>868, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 6.x (32 bit)", "id"=>4094, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_6_X_32_BIT_2", "softwareDescriptionId"=>1172, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 6.x (64 bit)", "id"=>4095, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_6_X_64_BIT", "softwareDescriptionId"=>1175, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"64", "description"=>"1 IPv6 Address", "id"=>4097, "itemTaxCategoryId"=>166, "keyName"=>"1_IPV6_ADDRESS", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Web Edition", "id"=>4147, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_WEB", "softwareDescriptionId"=>1004, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Enterprise Edition", "id"=>4149, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_ENTERPRISE", "softwareDescriptionId"=>1001, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MongoDB", "id"=>4226, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MONGODB", "softwareDescriptionId"=>1083, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 Datacenter Edition With Hyper-V (64bit)", "id"=>4247, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_DC_64_BIT_2", "softwareDescriptionId"=>1082, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x (32 bit) (per-processor licensing)", "id"=>4318, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_32_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1227, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Redundant Public & Private Network Uplinks", "id"=>4332, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_REDUNDANT_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>4336}, {"capacity"=>"0", "description"=>"0 GB Bandwidth", "id"=>4481, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_0_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Datacenter Edition (64bit)", "id"=>4547, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_DC_64_BIT", "softwareDescriptionId"=>1226, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"200", "description"=>"200Mbps Hardware Firewall", "id"=>4551, "itemTaxCategoryId"=>166, "keyName"=>"200MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"cPanel/WHM with Softaculous and RVskin", "id"=>4608, "itemTaxCategoryId"=>166, "keyName"=>"CPANELWHM_WITH_SOFTACULOUS_AND_RVSKIN", "softwareDescriptionId"=>1292, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 7.x (64 bit)", "id"=>5920, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_7_X_64_BIT", "softwareDescriptionId"=>1400, "units"=>"N/A", "upgradeItemId"=>nil}]
          fixture_package_items[41] = [{"capacity"=>"20", "description"=>"20 GB NAS", "id"=>40, "itemTaxCategoryId"=>166, "keyName"=>"NAS_20_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>41}, {"description"=>"Microsoft SQL Server 2005 Standard", "id"=>79, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_STANDARD", "softwareDescriptionId"=>8, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10Mbps Hardware Firewall", "id"=>299, "itemTaxCategoryId"=>166, "keyName"=>"10MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"Unlimited SSL VPN Users & 1 PPTP VPN User per account", "id"=>309, "itemTaxCategoryId"=>166, "keyName"=>"UNLIMITED_SSL_VPN_USERS_1_PPTP_VPN_USER_PER_ACCOUNT", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Enterprise SP2 with R2 (64 bit)", "id"=>424, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_ENT_64_BIT_SP2_WR2", "softwareDescriptionId"=>127, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Standard SP2 with R2 (64 bit)", "id"=>422, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_STD_64_BIT_SP2_WR2", "softwareDescriptionId"=>126, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB iSCSI SAN Storage", "id"=>551, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_100_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>575}, {"capacity"=>"40", "description"=>"40GB EVault Disk to Disk Enterprise Backup", "id"=>559, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_40_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>3784}, {"capacity"=>"1000", "description"=>"1000GB EVault Disk to Disk Enterprise Backup", "id"=>563, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_1000_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4185}, {"capacity"=>"0", "description"=>"FreeBSD 7.x  (64 bit)", "id"=>637, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_7_X_64_BIT", "softwareDescriptionId"=>667, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Web", "id"=>685, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WEB", "softwareDescriptionId"=>305, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Enterprise Edition SP2 (32bit)", "id"=>937, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_32_BIT_SP2", "softwareDescriptionId"=>448, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2000GB EVault Disk to Disk Enterprise Backup", "id"=>955, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_2000_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Web R2", "id"=>1163, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WEB_R2", "softwareDescriptionId"=>696, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Express R2", "id"=>1162, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_EXPRESS_R2", "softwareDescriptionId"=>701, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 10 (Linux) 100 Domain w/ Power Pack", "id"=>1305, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_LINUX_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>938, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"200", "description"=>"200 GB SSD", "id"=>3811, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_200GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 6.x Squeeze/Stable (64 bit)", "id"=>3968, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_6_X_SQUEEZE_64_BIT", "softwareDescriptionId"=>919, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.0.0", "id"=>3977, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_0_0", "softwareDescriptionId"=>836, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 5.x (32 bit)", "id"=>4092, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_5_X_32_BIT_2", "softwareDescriptionId"=>1156, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.0.2", "id"=>4133, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_0_2", "softwareDescriptionId"=>961, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 10 Pack", "id"=>4155, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_10_PACK", "softwareDescriptionId"=>1011, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin - Minimal Install (32 bit)", "id"=>4169, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_MINIMAL_32_BIT", "softwareDescriptionId"=>1186, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"350", "description"=>"350GB EVault Disk to Disk Enterprise Backup", "id"=>4183, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_350_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>562}, {"capacity"=>"750", "description"=>"750GB EVault Disk to Disk Enterprise Backup", "id"=>4184, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_750_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>563}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Linux) 100 Domain w/ Power Pack", "id"=>4195, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_LINUX_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1191, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Windows) 100 Domain w/ Power Pack", "id"=>4199, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_WINDOWS_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1273, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 1 VM", "id"=>4303, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_1_VM", "softwareDescriptionId"=>1105, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - Unlimited VMs", "id"=>4307, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_UNLIMITED_VMS", "softwareDescriptionId"=>1112, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Redundant Private Network Uplinks", "id"=>4335, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.2", "id"=>4467, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_2", "softwareDescriptionId"=>1171, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Dual Public & Private Network Uplinks (Unbonded)", "id"=>5118, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_DUAL_PUBLIC_PRIVATE_NETWORK_UPLINKS_UNBONDED", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"80", "description"=>"80 GB NAS", "id"=>42, "itemTaxCategoryId"=>166, "keyName"=>"NAS_80_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>43}, {"capacity"=>"250", "description"=>"250 GB NAS", "id"=>44, "itemTaxCategoryId"=>166, "keyName"=>"NAS_250_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>411}, {"capacity"=>"1000", "description"=>"1 Gbps Public & Private Network Uplinks", "id"=>188, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"APF Software Firewall for Linux", "id"=>300, "itemTaxCategoryId"=>166, "keyName"=>"APF_SOFTWARE_FIREWALL_FOR_LINUX", "softwareDescriptionId"=>71, "upgradeItemId"=>nil}, {"description"=>"Nessus Vulnerability Assessment & Reporting", "id"=>307, "itemTaxCategoryId"=>98, "keyName"=>"NESSUS_VULNERABILITY_ASSESSMENT_REPORTING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"McAfee VirusScan Enterprise", "id"=>397, "itemTaxCategoryId"=>98, "keyName"=>"MCAFEE_VIRUSSCAN_ANTIVIRUS_WINDOWS", "softwareDescriptionId"=>820, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x (32 bit)", "id"=>419, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_32_BIT", "softwareDescriptionId"=>1239, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Non-RAID", "id"=>487, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_NONRAID", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Microsoft Windows Firewall", "id"=>495, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_WINDOWS_FIREWALL", "softwareDescriptionId"=>106, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Private Network Uplink", "id"=>498, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"80", "description"=>"80 GB iSCSI SAN Storage", "id"=>550, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_80_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>551}, {"capacity"=>"250", "description"=>"250GB EVault Disk to Disk Enterprise Backup", "id"=>561, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_250_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4183}, {"description"=>"Microsoft SQL Server 2008 Express", "id"=>681, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_EXPRESS", "softwareDescriptionId"=>308, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Enterprise", "id"=>682, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_ENTERPRISE", "softwareDescriptionId"=>307, "upgradeItemId"=>nil}, {"capacity"=>"30", "description"=>"30GB EVault Disk to Disk Enterprise Backup", "id"=>739, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_30_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>559}, {"capacity"=>"10", "description"=>"Virtuozzo Containers 4 for Linux - 10 VPS", "id"=>741, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_10_VPS", "softwareDescriptionId"=>318, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Datacenter Edition SP2 (32bit)", "id"=>939, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_32_BIT_SP2", "softwareDescriptionId"=>450, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Standard R2", "id"=>1161, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_STANDARD_R2", "softwareDescriptionId"=>698, "upgradeItemId"=>nil}, {"capacity"=>"3000", "description"=>"3000 GB iSCSI SAN Storage", "id"=>1176, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_3000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"3", "description"=>"Monitoring Package - Premium Application", "id"=>1250, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_PREMIUM_APPLICATION", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 10 (Windows) Unlimited Domain w/ Power Pack", "id"=>3785, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_WINDOWS_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>788, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Standard Edition", "id"=>4148, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_STANDARD", "softwareDescriptionId"=>1003, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 5 Pack", "id"=>4154, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_5_PACK", "softwareDescriptionId"=>1012, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 Standard Edition (64 bit)", "id"=>4233, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_STD_64_BIT", "softwareDescriptionId"=>1076, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESXi 5.1", "id"=>4272, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESXI_5_1", "softwareDescriptionId"=>1086, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 5 VMs", "id"=>4304, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_5_VMS", "softwareDescriptionId"=>1109, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 10 VMs", "id"=>4305, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_10_VMS", "softwareDescriptionId"=>1110, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"15", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 15 VMs", "id"=>4306, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_15_VMS", "softwareDescriptionId"=>1111, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x (64 bit) (per-processor licensing)", "id"=>4319, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_64_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1228, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Server Backup 5.0 Enterprise (Linux)", "id"=>4343, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_SERVER_BACKUP_5_0_ENTERPRISE_LINUX", "softwareDescriptionId"=>1093, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 10 Pack", "id"=>4347, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_10_PACK", "softwareDescriptionId"=>1096, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable (32 bit)", "id"=>4404, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_32_BIT", "softwareDescriptionId"=>1169, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"RAID", "id"=>4478, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Datacenter Edition With Hyper-V (64bit)", "id"=>4548, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_DC_64_BIT_2", "softwareDescriptionId"=>1226, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Host Ping and TCP Service Monitoring", "id"=>50, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_HOST_PING_AND_TCP_SERVICE", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Public & Private Network Uplinks", "id"=>186, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>187}, {"description"=>"McAfee Host Intrusion Protection w/Reporting", "id"=>302, "itemTaxCategoryId"=>98, "keyName"=>"MCAFEE_HOST_INTRUSION_PROTECTION_WREPORTING", "softwareDescriptionId"=>916, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1.00 TB SATA II", "id"=>471, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_1_00TB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Private Network Uplink", "id"=>497, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>498}, {"capacity"=>"20", "description"=>"20 GB iSCSI SAN Storage", "id"=>548, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_20_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>549}, {"capacity"=>"40", "description"=>"40 GB iSCSI SAN Storage", "id"=>549, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_40_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>598}, {"capacity"=>"2000", "description"=>"2000 GB iSCSI SAN Storage", "id"=>626, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_2000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>1176}, {"description"=>"Microsoft SQL Server 2008 Standard", "id"=>683, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_STANDARD", "softwareDescriptionId"=>306, "upgradeItemId"=>nil}, {"capacity"=>"70", "description"=>"Virtuozzo Containers 4 for Linux - 70 VPS", "id"=>744, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_70_VPS", "softwareDescriptionId"=>322, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"24", "description"=>"24 GB Registered DDR3 1333", "id"=>826, "itemTaxCategoryId"=>166, "keyName"=>"RAM_24_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"6", "description"=>"6 GB Registered DDR3 1333", "id"=>823, "itemTaxCategoryId"=>166, "keyName"=>"RAM_6_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Standard Edition (64bit)", "id"=>977, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_R2", "softwareDescriptionId"=>475, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Datacenter Edition (64bit)", "id"=>979, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_R2", "softwareDescriptionId"=>478, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 8.x (64 bit)", "id"=>1065, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_8_X_64_BIT_2", "softwareDescriptionId"=>1019, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"600", "description"=>"600 GB SA-SCSI 15K RPM", "id"=>1094, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_600GB_SASCSI_15K_RPM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx (32 bit)", "id"=>1136, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_32_BIT", "softwareDescriptionId"=>774, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 9.x (32 bit)", "id"=>4137, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_9_X_32_BIT_2", "softwareDescriptionId"=>1264, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 25 Pack", "id"=>4156, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_25_PACK", "softwareDescriptionId"=>1016, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin (64 bit)", "id"=>4166, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_64_BIT", "softwareDescriptionId"=>1165, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"175", "description"=>"175GB EVault Disk to Disk Enterprise Backup", "id"=>4182, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_175_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>561}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Linux) Unlimited Domain w/ Power Pack", "id"=>4197, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_LINUX_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1197, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"800", "description"=>"800 GB SSD", "id"=>4356, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_800GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (128 TB)", "id"=>4369, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_128_TB", "softwareDescriptionId"=>1155, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (16 TB)", "id"=>4371, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_16_TB", "softwareDescriptionId"=>1153, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Vyatta 6.x Subscription Edition (64 bit)", "id"=>4396, "itemTaxCategoryId"=>166, "keyName"=>"OS_VYATTA_6_X_SUBSCRIPTION_EDITION_64_BIT_2", "softwareDescriptionId"=>1221, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"No Operating System", "id"=>4648, "itemTaxCategoryId"=>166, "keyName"=>"OS_NO_OPERATING_SYSTEM", "softwareDescriptionId"=>1312, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr (32 bit)", "id"=>4700, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_32_BIT", "softwareDescriptionId"=>1360, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Standard Edition", "id"=>5124, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_STANDARD_EDITION", "softwareDescriptionId"=>1334, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.5 - Minimal Install (64 bit) - version-locked", "id"=>5984, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_5_MINIMAL_64_BIT", "softwareDescriptionId"=>1263, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"1 IP Address", "id"=>15, "itemTaxCategoryId"=>166, "keyName"=>"1_IP_ADDRESS", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"MySQL for Linux", "id"=>22, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_LINUX", "softwareDescriptionId"=>156, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Workgroup", "id"=>80, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_WORKGROUP", "softwareDescriptionId"=>20, "upgradeItemId"=>nil}, {"capacity"=>"20000", "description"=>"20000 GB Bandwidth", "id"=>249, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_20000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100Mbps Hardware Firewall", "id"=>298, "itemTaxCategoryId"=>166, "keyName"=>"100MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"500", "description"=>"500 GB SATA II", "id"=>14, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_500GB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"RAID 0", "id"=>488, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_0", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"RAID 10", "id"=>491, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_10", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Private Network Uplink", "id"=>496, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>497}, {"capacity"=>"250", "description"=>"250 GB iSCSI SAN Storage", "id"=>552, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_250_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>612}, {"capacity"=>"20", "description"=>"20GB EVault Disk to Disk Enterprise Backup", "id"=>558, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_20_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>739}, {"capacity"=>"500", "description"=>"500 GB NAS", "id"=>611, "itemTaxCategoryId"=>166, "keyName"=>"NAS_500_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>605}, {"description"=>"Microsoft SQL Server 2008 Workgroup", "id"=>684, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WORKGROUP", "softwareDescriptionId"=>304, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"Virtuozzo Containers 4 for Linux - 5 VPS", "id"=>740, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_5_VPS", "softwareDescriptionId"=>317, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard Edition SP2 (64bit)", "id"=>936, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_SP2", "softwareDescriptionId"=>447, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Enterprise Edition (64bit)", "id"=>978, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_64_BIT_R2_2", "softwareDescriptionId"=>477, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Datacenter Edition With Hyper-V (64bit)", "id"=>980, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_R2_2", "softwareDescriptionId"=>478, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix Essentials for XenServer 5.5 (Billed per VM)", "id"=>1077, "itemTaxCategoryId"=>166, "keyName"=>"CITRIX_ESSENTIALS_XENSERVER_5_5", "softwareDescriptionId"=>521, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Workgroup R2", "id"=>1164, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WORKGROUP_R2", "softwareDescriptionId"=>697, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Redundant Public & Private Network Uplinks", "id"=>1284, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_REDUNDANT_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 10 (Linux) Unlimited Domain w/ Power Pack", "id"=>1306, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_LINUX_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>939, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 5.6.1", "id"=>1322, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6_1", "softwareDescriptionId"=>801, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x (32 bit)", "id"=>3904, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_32_BIT", "softwareDescriptionId"=>1258, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 6.x Squeeze/Stable (32 bit)", "id"=>3967, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_6_X_SQUEEZE_32_BIT", "softwareDescriptionId"=>918, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESX 4.1", "id"=>3969, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESX_4_1", "softwareDescriptionId"=>800, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 5.x (64 bit)", "id"=>4093, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_5_X_64_BIT_3", "softwareDescriptionId"=>1158, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Express Edition", "id"=>4150, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_EXPRESS", "softwareDescriptionId"=>1005, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1500", "description"=>"1500GB EVault Disk to Disk Enterprise Backup", "id"=>4185, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_1500_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>955}, {"capacity"=>"0", "description"=>"Windows Server 2012 Datacenter Edition (64bit)", "id"=>4237, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_DC_64_BIT", "softwareDescriptionId"=>1082, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard SP1 with R2 (64 bit)", "id"=>4248, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_R2_SP1", "softwareDescriptionId"=>831, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 1 Pack", "id"=>4345, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_1_PACK", "softwareDescriptionId"=>1094, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 25 Pack", "id"=>4348, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_25_PACK", "softwareDescriptionId"=>1097, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable (64 bit)", "id"=>4405, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_64_BIT", "softwareDescriptionId"=>1104, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware vCenter 5.5 Standard", "id"=>4598, "itemTaxCategoryId"=>166, "keyName"=>"VMWARE_VCENTER_5_5_STANDARD", "softwareDescriptionId"=>1275, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr - Minimal Install (64 bit)", "id"=>4710, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_MINIMAL_64_BIT_2", "softwareDescriptionId"=>1346, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 12 - 30 Domain w/ Power Pack", "id"=>6010, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_12_30_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1414, "upgradeItemId"=>nil}, {"capacity"=>"8", "description"=>"8 Public IP Addresses", "id"=>17, "itemTaxCategoryId"=>166, "keyName"=>"8_PUBLIC_IP_ADDRESSES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"MySQL 5.0 for Windows", "id"=>23, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_0_WINDOWS", "softwareDescriptionId"=>13, "upgradeItemId"=>nil}, {"description"=>"Email and Ticket", "id"=>51, "itemTaxCategoryId"=>166, "keyName"=>"NOTIFICATION_EMAIL_AND_TICKET", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"NOC Monitoring", "id"=>54, "itemTaxCategoryId"=>166, "keyName"=>"NOC_MONITORING", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"cPanel/WHM with Fantastico and RVskin", "id"=>96, "itemTaxCategoryId"=>166, "keyName"=>"CPANELWHM_WITH_FANTASTICO_AND_RVSKIN", "softwareDescriptionId"=>31, "upgradeItemId"=>nil}, {"description"=>"Unlimited Bandwidth (100 Mbps Uplink)", "id"=>97, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_UNLIMITED_100_MBPS_UPLINK", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Standard SP2 with R2 (32 bit)", "id"=>421, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_STD_32_BIT_SP2_WR2", "softwareDescriptionId"=>125, "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"RAID 1", "id"=>489, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_1", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"RAID 5", "id"=>490, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_5", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Reboot / KVM over IP", "id"=>504, "itemTaxCategoryId"=>166, "keyName"=>"REBOOT_KVM_OVER_IP", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1000 GB iSCSI SAN Storage", "id"=>554, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_1000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>783}, {"capacity"=>"150", "description"=>"Virtuozzo Containers 4 for Linux - 150 VPS", "id"=>746, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_150_VPS", "softwareDescriptionId"=>324, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"50", "description"=>"Virtuozzo Containers 4 for Linux - 50 VPS", "id"=>743, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_50_VPS", "softwareDescriptionId"=>321, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"12", "description"=>"12 GB Registered DDR3 1333", "id"=>824, "itemTaxCategoryId"=>166, "keyName"=>"RAM_12_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard Edition SP2 (32bit)", "id"=>933, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_32_BIT_SP2", "softwareDescriptionId"=>444, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Web Edition SP2 (32bit)", "id"=>934, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_32_BIT_SP2", "softwareDescriptionId"=>445, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Enterprise Edition SP2 (64bit)", "id"=>938, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_64_BIT_SP2", "softwareDescriptionId"=>449, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Datacenter Edition SP2 (64bit)", "id"=>940, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_SP2", "softwareDescriptionId"=>451, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Citrix XenServer 5.5", "id"=>950, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_5", "softwareDescriptionId"=>642, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Web Edition (64bit)", "id"=>976, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_64_BIT_R2_SP1", "softwareDescriptionId"=>832, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"36", "description"=>"36 GB Registered DDR3 1333", "id"=>827, "itemTaxCategoryId"=>166, "keyName"=>"RAM_36_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2.00 TB SATA II", "id"=>1091, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_2_00TB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Enterprise for XenServer 5.6", "id"=>1300, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ENTERPRISE_FOR_XENSERVER_5_6", "softwareDescriptionId"=>726, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin - Minimal Install (64 bit)", "id"=>4170, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_MINIMAL_64_BIT_2", "softwareDescriptionId"=>1184, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Windows) Unlimited Domain w/ Power Pack", "id"=>4200, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_WINDOWS_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1274, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.1", "id"=>4258, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_1", "softwareDescriptionId"=>1065, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware vCenter 5.1 Standard", "id"=>4298, "itemTaxCategoryId"=>166, "keyName"=>"VMWARE_VCENTER_5_1_STANDARD", "softwareDescriptionId"=>1090, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (4 TB)", "id"=>4372, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_4_TB", "softwareDescriptionId"=>1123, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Vyatta 6.6 Community Edition (64 bit)", "id"=>4495, "itemTaxCategoryId"=>166, "keyName"=>"OS_VYATTA_6_6_COMMUNITY_EDITION_64_BIT", "softwareDescriptionId"=>1192, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"20", "description"=>"20Mbps Hardware Firewall", "id"=>4550, "itemTaxCategoryId"=>166, "keyName"=>"20MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.2.1", "id"=>4569, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_2_1", "softwareDescriptionId"=>1257, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MySQL 5.7 for Windows", "id"=>4592, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_7_WINDOWS", "softwareDescriptionId"=>1272, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Enterprise Edition", "id"=>5120, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_ENTERPRISE_EDITION_2", "softwareDescriptionId"=>1330, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Enterprise", "id"=>81, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_ENTERPRISE", "softwareDescriptionId"=>21, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Public & Private Network Uplinks", "id"=>187, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>188}, {"capacity"=>"1000", "description"=>"1000Mbps Hardware Firewall", "id"=>297, "itemTaxCategoryId"=>166, "keyName"=>"1000MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x (64 bit)", "id"=>420, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_64_BIT", "softwareDescriptionId"=>1240, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Enterprise SP2 with R2 (32 bit)", "id"=>423, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_ENT_32_BIT_SP2_WR2", "softwareDescriptionId"=>128, "upgradeItemId"=>nil}, {"capacity"=>"18", "description"=>"18 GB Registered DDR3 1333", "id"=>825, "itemTaxCategoryId"=>166, "keyName"=>"RAM_18_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 8.x (32 bit)", "id"=>1066, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_8_X_32_BIT", "softwareDescriptionId"=>1022, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"60", "description"=>"60GB EVault Disk to Disk Enterprise Backup", "id"=>1076, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_60_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>560}, {"capacity"=>"2", "description"=>"Monitoring Package - Advanced", "id"=>1249, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_ADVANCED", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"capacity"=>"50", "description"=>"50GB EVault Disk to Disk Enterprise Backup", "id"=>3784, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_50_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>1076}, {"description"=>"Parallels Plesk Panel 10 (Windows) 100 Domain w/ Power Pack", "id"=>3786, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_WINDOWS_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>787, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x (64 bit)", "id"=>3907, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_64_BIT", "softwareDescriptionId"=>1261, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Redundant Private Network Uplinks", "id"=>3956, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"3000", "description"=>"3.00 TB SATA III", "id"=>3989, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_3_00TB_SATA_III", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Enterprise for XenServer 6.x", "id"=>4105, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ENTERPRISE_FOR_XENSERVER_6_X", "softwareDescriptionId"=>909, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 1 Pack", "id"=>4153, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_1_PACK", "softwareDescriptionId"=>1015, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin (32 bit)", "id"=>4165, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_32_BIT", "softwareDescriptionId"=>1166, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Dual Public & Private Network Uplinks (Unbonded)", "id"=>4263, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_DUAL_PUBLIC_PRIVATE_NETWORK_UPLINKS_UNBONDED", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"4000", "description"=>"4.00 TB SATA III", "id"=>4281, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_4_00TB_SATA_III", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Vyatta 6.5 Community Edition (64 bit)", "id"=>4315, "itemTaxCategoryId"=>166, "keyName"=>"OS_VYATTA_6_5_COMMUNITY_EDITION_64_BIT", "softwareDescriptionId"=>1106, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x (64 bit) (per-processor licensing)", "id"=>4321, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_64_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1247, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable - Minimal Install (32 bit)", "id"=>4406, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_MINIMAL_32_BIT", "softwareDescriptionId"=>1176, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable - Minimal Install (64 bit)", "id"=>4407, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_MINIMAL_64_BIT", "softwareDescriptionId"=>1177, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MySQL 5.0.51 for Windows", "id"=>4557, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_0_51_WINDOWS", "softwareDescriptionId"=>220, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESXi 5.5", "id"=>4562, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESXI_5_5", "softwareDescriptionId"=>1256, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 10.x (32 bit)", "id"=>4640, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_10_X_32_BIT", "softwareDescriptionId"=>1284, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 10.x (64 bit)", "id"=>4638, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_10_X_64_BIT", "softwareDescriptionId"=>1286, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr (64 bit)", "id"=>4702, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_64_BIT", "softwareDescriptionId"=>1362, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Express Edition", "id"=>5122, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_EXPRESS_EDITION", "softwareDescriptionId"=>1332, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 12 - Unlimited Domain w/ Power Pack", "id"=>6014, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_12_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1420, "upgradeItemId"=>nil}, {"capacity"=>"4", "description"=>"4 Public IP Addresses", "id"=>16, "itemTaxCategoryId"=>166, "keyName"=>"4_PUBLIC_IP_ADDRESSES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Unlimited Bandwidth (10 Mbps Uplink)", "id"=>30, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_UNLIMITED_10_MBPS_UPLINK", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB NAS", "id"=>43, "itemTaxCategoryId"=>166, "keyName"=>"NAS_100_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>44}, {"description"=>"Business Continuance Insurance", "id"=>84, "itemTaxCategoryId"=>108, "keyName"=>"BUSINESS_CONTINUANCE_INSURANCE", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100GB EVault Disk to Disk Enterprise Backup", "id"=>560, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_100_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4182}, {"capacity"=>"30", "description"=>"Virtuozzo Containers 4 for Linux - 30 VPS", "id"=>742, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_30_VPS", "softwareDescriptionId"=>320, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"64", "description"=>"/64 Block Static Public IPv6 Addresses", "id"=>784, "itemTaxCategoryId"=>166, "keyName"=>"64_BLOCK_STATIC_PUBLIC_IPV6_ADDRESSES", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"48", "description"=>"48 GB Registered DDR3 1333", "id"=>828, "itemTaxCategoryId"=>166, "keyName"=>"RAM_48_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESX 4.0", "id"=>1078, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESX_4_0", "softwareDescriptionId"=>497, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx (64 bit)", "id"=>1137, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_64_BIT", "softwareDescriptionId"=>775, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"96", "description"=>"96 GB Registered DDR3 1066", "id"=>1146, "itemTaxCategoryId"=>166, "keyName"=>"RAM_96_GB_DDR3_1066_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Enterprise R2", "id"=>1165, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_ENTERPRISE_R2", "softwareDescriptionId"=>699, "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Monitoring Package - Basic", "id"=>1248, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_BASIC", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2000Mbps Hardware Firewall", "id"=>1296, "itemTaxCategoryId"=>166, "keyName"=>"2000MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Advanced for XenServer 5.6", "id"=>1299, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ADVANCED_FOR_XENSERVER_5_6", "softwareDescriptionId"=>726, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"EVault Plugin - BMR (Bare Metal Restore)", "id"=>961, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_PLUGIN_BMR_BARE_METAL_RESTORE", "softwareDescriptionId"=>467, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 5.6.2", "id"=>3886, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6_2", "softwareDescriptionId"=>867, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Advanced for XenServer 6.x", "id"=>4104, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ADVANCED_FOR_XENSERVER_6_X", "softwareDescriptionId"=>908, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 9.x (64 bit)", "id"=>4138, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_9_X_64_BIT", "softwareDescriptionId"=>1265, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"400", "description"=>"400 GB SSD", "id"=>4181, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_400GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Cloudera Distribution for Hadoop 4", "id"=>4301, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_CLOUDERA_DISTRIBUTION_HADOOP_4", "softwareDescriptionId"=>1099, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x (32 bit) (per-processor licensing)", "id"=>4320, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_32_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1246, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Riak 1.x", "id"=>4327, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_RIAK_1_X", "softwareDescriptionId"=>1114, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Redundant Private Network Uplinks", "id"=>4331, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Redundant Public & Private Network Uplinks", "id"=>4336, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_REDUNDANT_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>1284}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (48 TB)", "id"=>4370, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_48_TB", "softwareDescriptionId"=>1154, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Standard Edition (64 bit)", "id"=>4549, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_STD_64_BIT", "softwareDescriptionId"=>1225, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Express", "id"=>24, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_EXPRESS", "softwareDescriptionId"=>9, "upgradeItemId"=>nil}, {"capacity"=>"40", "description"=>"40 GB NAS", "id"=>41, "itemTaxCategoryId"=>166, "keyName"=>"NAS_40_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>42}, {"description"=>"Host Ping", "id"=>49, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_HOST_PING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Automated Notification", "id"=>52, "itemTaxCategoryId"=>166, "keyName"=>"AUTOMATED_NOTIFICATION", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Automated Reboot from Monitoring", "id"=>53, "itemTaxCategoryId"=>166, "keyName"=>"AUTOMATED_REBOOT_FROM_MONITORING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"300", "description"=>"300 GB SA-SCSI 15K RPM", "id"=>352, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_300GB_SASCSI_15K_RPM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"500", "description"=>"500 GB iSCSI SAN Storage", "id"=>553, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_500_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>621}, {"capacity"=>"500", "description"=>"500GB EVault Disk to Disk Enterprise Backup", "id"=>562, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_500_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4184}, {"capacity"=>"120", "description"=>"120 GB iSCSI SAN Storage", "id"=>575, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_120_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>622}, {"capacity"=>"0", "description"=>"FreeBSD 7.x  (32 bit)", "id"=>638, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_7_X_32_BIT", "softwareDescriptionId"=>666, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Virtuozzo Containers 4 for Linux - 3 VPS", "id"=>738, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_3_VPS", "softwareDescriptionId"=>319, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"Virtuozzo Containers 4 for Linux - 100 VPS", "id"=>745, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_100_VPS", "softwareDescriptionId"=>323, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Web Edition SP2 (64bit)", "id"=>935, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_64_BIT_SP2", "softwareDescriptionId"=>446, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Cloudera Distribution for Hadoop 2", "id"=>1044, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_CLOUDERA_DISTRIBUTION_HADOOP_2", "softwareDescriptionId"=>520, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Citrix XenServer 5.6", "id"=>1189, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6", "softwareDescriptionId"=>704, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft WebMatrix", "id"=>3898, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_WEBMATRIX_2", "softwareDescriptionId"=>868, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"International Services", "id"=>3955, "itemTaxCategoryId"=>166, "keyName"=>"INTERNATIONAL_SERVICES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 6.x (32 bit)", "id"=>4094, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_6_X_32_BIT_2", "softwareDescriptionId"=>1172, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 6.x (64 bit)", "id"=>4095, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_6_X_64_BIT", "softwareDescriptionId"=>1175, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"64", "description"=>"1 IPv6 Address", "id"=>4097, "itemTaxCategoryId"=>166, "keyName"=>"1_IPV6_ADDRESS", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Web Edition", "id"=>4147, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_WEB", "softwareDescriptionId"=>1004, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Enterprise Edition", "id"=>4149, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_ENTERPRISE", "softwareDescriptionId"=>1001, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MongoDB", "id"=>4226, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MONGODB", "softwareDescriptionId"=>1083, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 Datacenter Edition With Hyper-V (64bit)", "id"=>4247, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_DC_64_BIT_2", "softwareDescriptionId"=>1082, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x (32 bit) (per-processor licensing)", "id"=>4318, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_32_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1227, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Redundant Public & Private Network Uplinks", "id"=>4332, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_REDUNDANT_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>4336}, {"capacity"=>"0", "description"=>"Idera Server Backup 5.0 Enterprise (Windows)", "id"=>4344, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_SERVER_BACKUP_5_0_ENTERPRISE_WINDOWS", "softwareDescriptionId"=>1092, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 5 Pack", "id"=>4346, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_5_PACK", "softwareDescriptionId"=>1095, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"0 GB Bandwidth", "id"=>4481, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_0_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Datacenter Edition (64bit)", "id"=>4547, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_DC_64_BIT", "softwareDescriptionId"=>1226, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"200", "description"=>"200Mbps Hardware Firewall", "id"=>4551, "itemTaxCategoryId"=>166, "keyName"=>"200MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"cPanel/WHM with Softaculous and RVskin", "id"=>4608, "itemTaxCategoryId"=>166, "keyName"=>"CPANELWHM_WITH_SOFTACULOUS_AND_RVSKIN", "softwareDescriptionId"=>1292, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr - Minimal Install (32 bit)", "id"=>4708, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_MINIMAL_32_BIT_2", "softwareDescriptionId"=>1350, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 7.x (64 bit)", "id"=>5920, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_7_X_64_BIT", "softwareDescriptionId"=>1400, "units"=>"N/A", "upgradeItemId"=>nil}]
          fixture_package_items[42] = [{"capacity"=>"20", "description"=>"20 GB NAS", "id"=>40, "itemTaxCategoryId"=>166, "keyName"=>"NAS_20_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>41}, {"description"=>"Microsoft SQL Server 2005 Standard", "id"=>79, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_STANDARD", "softwareDescriptionId"=>8, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10Mbps Hardware Firewall", "id"=>299, "itemTaxCategoryId"=>166, "keyName"=>"10MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"Unlimited SSL VPN Users & 1 PPTP VPN User per account", "id"=>309, "itemTaxCategoryId"=>166, "keyName"=>"UNLIMITED_SSL_VPN_USERS_1_PPTP_VPN_USER_PER_ACCOUNT", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Standard SP2 with R2 (64 bit)", "id"=>422, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_STD_64_BIT_SP2_WR2", "softwareDescriptionId"=>126, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Enterprise SP2 with R2 (64 bit)", "id"=>424, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_ENT_64_BIT_SP2_WR2", "softwareDescriptionId"=>127, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB iSCSI SAN Storage", "id"=>551, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_100_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>575}, {"capacity"=>"40", "description"=>"40GB EVault Disk to Disk Enterprise Backup", "id"=>559, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_40_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>3784}, {"capacity"=>"1000", "description"=>"1000GB EVault Disk to Disk Enterprise Backup", "id"=>563, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_1000_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4185}, {"capacity"=>"0", "description"=>"FreeBSD 7.x  (64 bit)", "id"=>637, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_7_X_64_BIT", "softwareDescriptionId"=>667, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Web", "id"=>685, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WEB", "softwareDescriptionId"=>305, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Enterprise Edition SP2 (32bit)", "id"=>937, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_32_BIT_SP2", "softwareDescriptionId"=>448, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2000GB EVault Disk to Disk Enterprise Backup", "id"=>955, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_2000_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>nil}, {"capacity"=>"192", "description"=>"192 GB Registered DDR3 1066", "id"=>1147, "itemTaxCategoryId"=>166, "keyName"=>"RAM_192_GB_DDR3_1066_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Web R2", "id"=>1163, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WEB_R2", "softwareDescriptionId"=>696, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Express R2", "id"=>1162, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_EXPRESS_R2", "softwareDescriptionId"=>701, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 10 (Linux) 100 Domain w/ Power Pack", "id"=>1305, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_LINUX_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>938, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"200", "description"=>"200 GB SSD", "id"=>3811, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_200GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 6.x Squeeze/Stable (64 bit)", "id"=>3968, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_6_X_SQUEEZE_64_BIT", "softwareDescriptionId"=>919, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.0.0", "id"=>3977, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_0_0", "softwareDescriptionId"=>836, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 5.x (32 bit)", "id"=>4092, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_5_X_32_BIT_2", "softwareDescriptionId"=>1156, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.0.2", "id"=>4133, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_0_2", "softwareDescriptionId"=>961, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 10 Pack", "id"=>4155, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_10_PACK", "softwareDescriptionId"=>1011, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin - Minimal Install (32 bit)", "id"=>4169, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_MINIMAL_32_BIT", "softwareDescriptionId"=>1186, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"350", "description"=>"350GB EVault Disk to Disk Enterprise Backup", "id"=>4183, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_350_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>562}, {"capacity"=>"750", "description"=>"750GB EVault Disk to Disk Enterprise Backup", "id"=>4184, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_750_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>563}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Linux) 100 Domain w/ Power Pack", "id"=>4195, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_LINUX_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1191, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Windows) 100 Domain w/ Power Pack", "id"=>4199, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_WINDOWS_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1273, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 1 VM", "id"=>4303, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_1_VM", "softwareDescriptionId"=>1105, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - Unlimited VMs", "id"=>4307, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_UNLIMITED_VMS", "softwareDescriptionId"=>1112, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Redundant Private Network Uplinks", "id"=>4335, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.2", "id"=>4467, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_2", "softwareDescriptionId"=>1171, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Dual Public & Private Network Uplinks (Unbonded)", "id"=>5118, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_DUAL_PUBLIC_PRIVATE_NETWORK_UPLINKS_UNBONDED", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"80", "description"=>"80 GB NAS", "id"=>42, "itemTaxCategoryId"=>166, "keyName"=>"NAS_80_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>43}, {"capacity"=>"250", "description"=>"250 GB NAS", "id"=>44, "itemTaxCategoryId"=>166, "keyName"=>"NAS_250_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>411}, {"capacity"=>"1000", "description"=>"1 Gbps Public & Private Network Uplinks", "id"=>188, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"APF Software Firewall for Linux", "id"=>300, "itemTaxCategoryId"=>166, "keyName"=>"APF_SOFTWARE_FIREWALL_FOR_LINUX", "softwareDescriptionId"=>71, "upgradeItemId"=>nil}, {"description"=>"Nessus Vulnerability Assessment & Reporting", "id"=>307, "itemTaxCategoryId"=>98, "keyName"=>"NESSUS_VULNERABILITY_ASSESSMENT_REPORTING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"McAfee VirusScan Enterprise", "id"=>397, "itemTaxCategoryId"=>98, "keyName"=>"MCAFEE_VIRUSSCAN_ANTIVIRUS_WINDOWS", "softwareDescriptionId"=>820, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x (32 bit)", "id"=>419, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_32_BIT", "softwareDescriptionId"=>1239, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Non-RAID", "id"=>487, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_NONRAID", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Microsoft Windows Firewall", "id"=>495, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_WINDOWS_FIREWALL", "softwareDescriptionId"=>106, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Private Network Uplink", "id"=>498, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"80", "description"=>"80 GB iSCSI SAN Storage", "id"=>550, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_80_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>551}, {"capacity"=>"250", "description"=>"250GB EVault Disk to Disk Enterprise Backup", "id"=>561, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_250_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4183}, {"description"=>"Microsoft SQL Server 2008 Express", "id"=>681, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_EXPRESS", "softwareDescriptionId"=>308, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Enterprise", "id"=>682, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_ENTERPRISE", "softwareDescriptionId"=>307, "upgradeItemId"=>nil}, {"capacity"=>"30", "description"=>"30GB EVault Disk to Disk Enterprise Backup", "id"=>739, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_30_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>559}, {"capacity"=>"10", "description"=>"Virtuozzo Containers 4 for Linux - 10 VPS", "id"=>741, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_10_VPS", "softwareDescriptionId"=>318, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Datacenter Edition SP2 (32bit)", "id"=>939, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_32_BIT_SP2", "softwareDescriptionId"=>450, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Standard R2", "id"=>1161, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_STANDARD_R2", "softwareDescriptionId"=>698, "upgradeItemId"=>nil}, {"capacity"=>"3000", "description"=>"3000 GB iSCSI SAN Storage", "id"=>1176, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_3000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"3", "description"=>"Monitoring Package - Premium Application", "id"=>1250, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_PREMIUM_APPLICATION", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 10 (Windows) Unlimited Domain w/ Power Pack", "id"=>3785, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_WINDOWS_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>788, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Standard Edition", "id"=>4148, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_STANDARD", "softwareDescriptionId"=>1003, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 5 Pack", "id"=>4154, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_5_PACK", "softwareDescriptionId"=>1012, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 Standard Edition (64 bit)", "id"=>4233, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_STD_64_BIT", "softwareDescriptionId"=>1076, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESXi 5.1", "id"=>4272, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESXI_5_1", "softwareDescriptionId"=>1086, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 5 VMs", "id"=>4304, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_5_VMS", "softwareDescriptionId"=>1109, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 10 VMs", "id"=>4305, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_10_VMS", "softwareDescriptionId"=>1110, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"15", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 15 VMs", "id"=>4306, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_15_VMS", "softwareDescriptionId"=>1111, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x (64 bit) (per-processor licensing)", "id"=>4319, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_64_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1228, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Server Backup 5.0 Enterprise (Linux)", "id"=>4343, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_SERVER_BACKUP_5_0_ENTERPRISE_LINUX", "softwareDescriptionId"=>1093, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 10 Pack", "id"=>4347, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_10_PACK", "softwareDescriptionId"=>1096, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable (32 bit)", "id"=>4404, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_32_BIT", "softwareDescriptionId"=>1169, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"RAID", "id"=>4478, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Datacenter Edition With Hyper-V (64bit)", "id"=>4548, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_DC_64_BIT_2", "softwareDescriptionId"=>1226, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Host Ping and TCP Service Monitoring", "id"=>50, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_HOST_PING_AND_TCP_SERVICE", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Public & Private Network Uplinks", "id"=>186, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>187}, {"description"=>"McAfee Host Intrusion Protection w/Reporting", "id"=>302, "itemTaxCategoryId"=>98, "keyName"=>"MCAFEE_HOST_INTRUSION_PROTECTION_WREPORTING", "softwareDescriptionId"=>916, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1.00 TB SATA II", "id"=>471, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_1_00TB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Private Network Uplink", "id"=>497, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>498}, {"capacity"=>"20", "description"=>"20 GB iSCSI SAN Storage", "id"=>548, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_20_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>549}, {"capacity"=>"40", "description"=>"40 GB iSCSI SAN Storage", "id"=>549, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_40_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>598}, {"capacity"=>"2000", "description"=>"2000 GB iSCSI SAN Storage", "id"=>626, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_2000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>1176}, {"description"=>"Microsoft SQL Server 2008 Standard", "id"=>683, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_STANDARD", "softwareDescriptionId"=>306, "upgradeItemId"=>nil}, {"capacity"=>"70", "description"=>"Virtuozzo Containers 4 for Linux - 70 VPS", "id"=>744, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_70_VPS", "softwareDescriptionId"=>322, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Standard Edition (64bit)", "id"=>977, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_R2", "softwareDescriptionId"=>475, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Datacenter Edition (64bit)", "id"=>979, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_R2", "softwareDescriptionId"=>478, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"24", "description"=>"24 GB Registered DDR3 1333", "id"=>826, "itemTaxCategoryId"=>166, "keyName"=>"RAM_24_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 8.x (64 bit)", "id"=>1065, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_8_X_64_BIT_2", "softwareDescriptionId"=>1019, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"600", "description"=>"600 GB SA-SCSI 15K RPM", "id"=>1094, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_600GB_SASCSI_15K_RPM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx (32 bit)", "id"=>1136, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_32_BIT", "softwareDescriptionId"=>774, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 9.x (32 bit)", "id"=>4137, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_9_X_32_BIT_2", "softwareDescriptionId"=>1264, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 25 Pack", "id"=>4156, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_25_PACK", "softwareDescriptionId"=>1016, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin (64 bit)", "id"=>4166, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_64_BIT", "softwareDescriptionId"=>1165, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"175", "description"=>"175GB EVault Disk to Disk Enterprise Backup", "id"=>4182, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_175_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>561}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Linux) Unlimited Domain w/ Power Pack", "id"=>4197, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_LINUX_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1197, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"800", "description"=>"800 GB SSD", "id"=>4356, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_800GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (128 TB)", "id"=>4369, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_128_TB", "softwareDescriptionId"=>1155, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (16 TB)", "id"=>4371, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_16_TB", "softwareDescriptionId"=>1153, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Vyatta 6.x Subscription Edition (64 bit)", "id"=>4396, "itemTaxCategoryId"=>166, "keyName"=>"OS_VYATTA_6_X_SUBSCRIPTION_EDITION_64_BIT_2", "softwareDescriptionId"=>1221, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"No Operating System", "id"=>4648, "itemTaxCategoryId"=>166, "keyName"=>"OS_NO_OPERATING_SYSTEM", "softwareDescriptionId"=>1312, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr (32 bit)", "id"=>4700, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_32_BIT", "softwareDescriptionId"=>1360, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Standard Edition", "id"=>5124, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_STANDARD_EDITION", "softwareDescriptionId"=>1334, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.5 - Minimal Install (64 bit) - version-locked", "id"=>5984, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_5_MINIMAL_64_BIT", "softwareDescriptionId"=>1263, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"1 IP Address", "id"=>15, "itemTaxCategoryId"=>166, "keyName"=>"1_IP_ADDRESS", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"MySQL for Linux", "id"=>22, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_LINUX", "softwareDescriptionId"=>156, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Workgroup", "id"=>80, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_WORKGROUP", "softwareDescriptionId"=>20, "upgradeItemId"=>nil}, {"capacity"=>"20000", "description"=>"20000 GB Bandwidth", "id"=>249, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_20000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100Mbps Hardware Firewall", "id"=>298, "itemTaxCategoryId"=>166, "keyName"=>"100MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"500", "description"=>"500 GB SATA II", "id"=>14, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_500GB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"RAID 0", "id"=>488, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_0", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"RAID 10", "id"=>491, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_10", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Private Network Uplink", "id"=>496, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>497}, {"capacity"=>"250", "description"=>"250 GB iSCSI SAN Storage", "id"=>552, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_250_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>612}, {"capacity"=>"20", "description"=>"20GB EVault Disk to Disk Enterprise Backup", "id"=>558, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_20_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>739}, {"capacity"=>"500", "description"=>"500 GB NAS", "id"=>611, "itemTaxCategoryId"=>166, "keyName"=>"NAS_500_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>605}, {"description"=>"Microsoft SQL Server 2008 Workgroup", "id"=>684, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WORKGROUP", "softwareDescriptionId"=>304, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"Virtuozzo Containers 4 for Linux - 5 VPS", "id"=>740, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_5_VPS", "softwareDescriptionId"=>317, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard Edition SP2 (64bit)", "id"=>936, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_SP2", "softwareDescriptionId"=>447, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Enterprise Edition (64bit)", "id"=>978, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_64_BIT_R2_2", "softwareDescriptionId"=>477, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Datacenter Edition With Hyper-V (64bit)", "id"=>980, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_R2_2", "softwareDescriptionId"=>478, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix Essentials for XenServer 5.5 (Billed per VM)", "id"=>1077, "itemTaxCategoryId"=>166, "keyName"=>"CITRIX_ESSENTIALS_XENSERVER_5_5", "softwareDescriptionId"=>521, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"72", "description"=>"72 GB Registered DDR3 1333", "id"=>829, "itemTaxCategoryId"=>166, "keyName"=>"RAM_72_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"96", "description"=>"96 GB Registered DDR3 1333", "id"=>1050, "itemTaxCategoryId"=>166, "keyName"=>"RAM_96_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Workgroup R2", "id"=>1164, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WORKGROUP_R2", "softwareDescriptionId"=>697, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Redundant Public & Private Network Uplinks", "id"=>1284, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_REDUNDANT_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 10 (Linux) Unlimited Domain w/ Power Pack", "id"=>1306, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_LINUX_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>939, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 5.6.1", "id"=>1322, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6_1", "softwareDescriptionId"=>801, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x (32 bit)", "id"=>3904, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_32_BIT", "softwareDescriptionId"=>1258, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 6.x Squeeze/Stable (32 bit)", "id"=>3967, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_6_X_SQUEEZE_32_BIT", "softwareDescriptionId"=>918, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESX 4.1", "id"=>3969, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESX_4_1", "softwareDescriptionId"=>800, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 5.x (64 bit)", "id"=>4093, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_5_X_64_BIT_3", "softwareDescriptionId"=>1158, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Express Edition", "id"=>4150, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_EXPRESS", "softwareDescriptionId"=>1005, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1500", "description"=>"1500GB EVault Disk to Disk Enterprise Backup", "id"=>4185, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_1500_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>955}, {"capacity"=>"0", "description"=>"Windows Server 2012 Datacenter Edition (64bit)", "id"=>4237, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_DC_64_BIT", "softwareDescriptionId"=>1082, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 1 Pack", "id"=>4345, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_1_PACK", "softwareDescriptionId"=>1094, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 25 Pack", "id"=>4348, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_25_PACK", "softwareDescriptionId"=>1097, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable (64 bit)", "id"=>4405, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_64_BIT", "softwareDescriptionId"=>1104, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware vCenter 5.5 Standard", "id"=>4598, "itemTaxCategoryId"=>166, "keyName"=>"VMWARE_VCENTER_5_5_STANDARD", "softwareDescriptionId"=>1275, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr - Minimal Install (64 bit)", "id"=>4710, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_MINIMAL_64_BIT_2", "softwareDescriptionId"=>1346, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 12 - 30 Domain w/ Power Pack", "id"=>6010, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_12_30_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1414, "upgradeItemId"=>nil}, {"capacity"=>"8", "description"=>"8 Public IP Addresses", "id"=>17, "itemTaxCategoryId"=>166, "keyName"=>"8_PUBLIC_IP_ADDRESSES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"MySQL 5.0 for Windows", "id"=>23, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_0_WINDOWS", "softwareDescriptionId"=>13, "upgradeItemId"=>nil}, {"description"=>"Email and Ticket", "id"=>51, "itemTaxCategoryId"=>166, "keyName"=>"NOTIFICATION_EMAIL_AND_TICKET", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"NOC Monitoring", "id"=>54, "itemTaxCategoryId"=>166, "keyName"=>"NOC_MONITORING", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"cPanel/WHM with Fantastico and RVskin", "id"=>96, "itemTaxCategoryId"=>166, "keyName"=>"CPANELWHM_WITH_FANTASTICO_AND_RVSKIN", "softwareDescriptionId"=>31, "upgradeItemId"=>nil}, {"description"=>"Unlimited Bandwidth (100 Mbps Uplink)", "id"=>97, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_UNLIMITED_100_MBPS_UPLINK", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"RAID 1", "id"=>489, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_1", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"RAID 5", "id"=>490, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_5", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Reboot / KVM over IP", "id"=>504, "itemTaxCategoryId"=>166, "keyName"=>"REBOOT_KVM_OVER_IP", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1000 GB iSCSI SAN Storage", "id"=>554, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_1000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>783}, {"capacity"=>"150", "description"=>"Virtuozzo Containers 4 for Linux - 150 VPS", "id"=>746, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_150_VPS", "softwareDescriptionId"=>324, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"50", "description"=>"Virtuozzo Containers 4 for Linux - 50 VPS", "id"=>743, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_50_VPS", "softwareDescriptionId"=>321, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard Edition SP2 (32bit)", "id"=>933, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_32_BIT_SP2", "softwareDescriptionId"=>444, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Enterprise Edition SP2 (64bit)", "id"=>938, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_64_BIT_SP2", "softwareDescriptionId"=>449, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Datacenter Edition SP2 (64bit)", "id"=>940, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_SP2", "softwareDescriptionId"=>451, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Citrix XenServer 5.5", "id"=>950, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_5", "softwareDescriptionId"=>642, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Web Edition (64bit)", "id"=>976, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_64_BIT_R2_SP1", "softwareDescriptionId"=>832, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Standard SP2 with R2 (32 bit)", "id"=>421, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_STD_32_BIT_SP2_WR2", "softwareDescriptionId"=>125, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Web Edition SP2 (32bit)", "id"=>934, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_32_BIT_SP2", "softwareDescriptionId"=>445, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2.00 TB SATA II", "id"=>1091, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_2_00TB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"12", "description"=>"12 GB Registered DDR3 1333", "id"=>824, "itemTaxCategoryId"=>166, "keyName"=>"RAM_12_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"36", "description"=>"36 GB Registered DDR3 1333", "id"=>827, "itemTaxCategoryId"=>166, "keyName"=>"RAM_36_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Enterprise for XenServer 5.6", "id"=>1300, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ENTERPRISE_FOR_XENSERVER_5_6", "softwareDescriptionId"=>726, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin - Minimal Install (64 bit)", "id"=>4170, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_MINIMAL_64_BIT_2", "softwareDescriptionId"=>1184, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Windows) Unlimited Domain w/ Power Pack", "id"=>4200, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_WINDOWS_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1274, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.1", "id"=>4258, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_1", "softwareDescriptionId"=>1065, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware vCenter 5.1 Standard", "id"=>4298, "itemTaxCategoryId"=>166, "keyName"=>"VMWARE_VCENTER_5_1_STANDARD", "softwareDescriptionId"=>1090, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (4 TB)", "id"=>4372, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_4_TB", "softwareDescriptionId"=>1123, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Vyatta 6.6 Community Edition (64 bit)", "id"=>4495, "itemTaxCategoryId"=>166, "keyName"=>"OS_VYATTA_6_6_COMMUNITY_EDITION_64_BIT", "softwareDescriptionId"=>1192, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"20", "description"=>"20Mbps Hardware Firewall", "id"=>4550, "itemTaxCategoryId"=>166, "keyName"=>"20MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.2.1", "id"=>4569, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_2_1", "softwareDescriptionId"=>1257, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MySQL 5.7 for Windows", "id"=>4592, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_7_WINDOWS", "softwareDescriptionId"=>1272, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Enterprise Edition", "id"=>5120, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_ENTERPRISE_EDITION_2", "softwareDescriptionId"=>1330, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Enterprise", "id"=>81, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_ENTERPRISE", "softwareDescriptionId"=>21, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Public & Private Network Uplinks", "id"=>187, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>188}, {"capacity"=>"1000", "description"=>"1000Mbps Hardware Firewall", "id"=>297, "itemTaxCategoryId"=>166, "keyName"=>"1000MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x (64 bit)", "id"=>420, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_64_BIT", "softwareDescriptionId"=>1240, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Enterprise SP2 with R2 (32 bit)", "id"=>423, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_ENT_32_BIT_SP2_WR2", "softwareDescriptionId"=>128, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 8.x (32 bit)", "id"=>1066, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_8_X_32_BIT", "softwareDescriptionId"=>1022, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"60", "description"=>"60GB EVault Disk to Disk Enterprise Backup", "id"=>1076, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_60_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>560}, {"capacity"=>"18", "description"=>"18 GB Registered DDR3 1333", "id"=>825, "itemTaxCategoryId"=>166, "keyName"=>"RAM_18_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"2", "description"=>"Monitoring Package - Advanced", "id"=>1249, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_ADVANCED", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"capacity"=>"50", "description"=>"50GB EVault Disk to Disk Enterprise Backup", "id"=>3784, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_50_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>1076}, {"description"=>"Parallels Plesk Panel 10 (Windows) 100 Domain w/ Power Pack", "id"=>3786, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_WINDOWS_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>787, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x (64 bit)", "id"=>3907, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_64_BIT", "softwareDescriptionId"=>1261, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Redundant Private Network Uplinks", "id"=>3956, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"3000", "description"=>"3.00 TB SATA III", "id"=>3989, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_3_00TB_SATA_III", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Enterprise for XenServer 6.x", "id"=>4105, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ENTERPRISE_FOR_XENSERVER_6_X", "softwareDescriptionId"=>909, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 1 Pack", "id"=>4153, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_1_PACK", "softwareDescriptionId"=>1015, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin (32 bit)", "id"=>4165, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_32_BIT", "softwareDescriptionId"=>1166, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Dual Public & Private Network Uplinks (Unbonded)", "id"=>4263, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_DUAL_PUBLIC_PRIVATE_NETWORK_UPLINKS_UNBONDED", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"4000", "description"=>"4.00 TB SATA III", "id"=>4281, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_4_00TB_SATA_III", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Vyatta 6.5 Community Edition (64 bit)", "id"=>4315, "itemTaxCategoryId"=>166, "keyName"=>"OS_VYATTA_6_5_COMMUNITY_EDITION_64_BIT", "softwareDescriptionId"=>1106, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x (64 bit) (per-processor licensing)", "id"=>4321, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_64_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1247, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable - Minimal Install (32 bit)", "id"=>4406, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_MINIMAL_32_BIT", "softwareDescriptionId"=>1176, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable - Minimal Install (64 bit)", "id"=>4407, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_MINIMAL_64_BIT", "softwareDescriptionId"=>1177, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MySQL 5.0.51 for Windows", "id"=>4557, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_0_51_WINDOWS", "softwareDescriptionId"=>220, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESXi 5.5", "id"=>4562, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESXI_5_5", "softwareDescriptionId"=>1256, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 10.x (32 bit)", "id"=>4640, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_10_X_32_BIT", "softwareDescriptionId"=>1284, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 10.x (64 bit)", "id"=>4638, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_10_X_64_BIT", "softwareDescriptionId"=>1286, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr (64 bit)", "id"=>4702, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_64_BIT", "softwareDescriptionId"=>1362, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Express Edition", "id"=>5122, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_EXPRESS_EDITION", "softwareDescriptionId"=>1332, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 12 - Unlimited Domain w/ Power Pack", "id"=>6014, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_12_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1420, "upgradeItemId"=>nil}, {"capacity"=>"4", "description"=>"4 Public IP Addresses", "id"=>16, "itemTaxCategoryId"=>166, "keyName"=>"4_PUBLIC_IP_ADDRESSES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Unlimited Bandwidth (10 Mbps Uplink)", "id"=>30, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_UNLIMITED_10_MBPS_UPLINK", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB NAS", "id"=>43, "itemTaxCategoryId"=>166, "keyName"=>"NAS_100_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>44}, {"description"=>"Business Continuance Insurance", "id"=>84, "itemTaxCategoryId"=>108, "keyName"=>"BUSINESS_CONTINUANCE_INSURANCE", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100GB EVault Disk to Disk Enterprise Backup", "id"=>560, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_100_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4182}, {"capacity"=>"30", "description"=>"Virtuozzo Containers 4 for Linux - 30 VPS", "id"=>742, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_30_VPS", "softwareDescriptionId"=>320, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"64", "description"=>"/64 Block Static Public IPv6 Addresses", "id"=>784, "itemTaxCategoryId"=>166, "keyName"=>"64_BLOCK_STATIC_PUBLIC_IPV6_ADDRESSES", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESX 4.0", "id"=>1078, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESX_4_0", "softwareDescriptionId"=>497, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"48", "description"=>"48 GB Registered DDR3 1333", "id"=>828, "itemTaxCategoryId"=>166, "keyName"=>"RAM_48_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx (64 bit)", "id"=>1137, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_64_BIT", "softwareDescriptionId"=>775, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Enterprise R2", "id"=>1165, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_ENTERPRISE_R2", "softwareDescriptionId"=>699, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Datacenter R2", "id"=>1166, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_DATACENTER_R2", "softwareDescriptionId"=>700, "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Monitoring Package - Basic", "id"=>1248, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_BASIC", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2000Mbps Hardware Firewall", "id"=>1296, "itemTaxCategoryId"=>166, "keyName"=>"2000MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Advanced for XenServer 5.6", "id"=>1299, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ADVANCED_FOR_XENSERVER_5_6", "softwareDescriptionId"=>726, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"EVault Plugin - BMR (Bare Metal Restore)", "id"=>961, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_PLUGIN_BMR_BARE_METAL_RESTORE", "softwareDescriptionId"=>467, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 5.6.2", "id"=>3886, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6_2", "softwareDescriptionId"=>867, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Advanced for XenServer 6.x", "id"=>4104, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ADVANCED_FOR_XENSERVER_6_X", "softwareDescriptionId"=>908, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 9.x (64 bit)", "id"=>4138, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_9_X_64_BIT", "softwareDescriptionId"=>1265, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"400", "description"=>"400 GB SSD", "id"=>4181, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_400GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Cloudera Distribution for Hadoop 4", "id"=>4301, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_CLOUDERA_DISTRIBUTION_HADOOP_4", "softwareDescriptionId"=>1099, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x (32 bit) (per-processor licensing)", "id"=>4320, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_32_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1246, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Riak 1.x", "id"=>4327, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_RIAK_1_X", "softwareDescriptionId"=>1114, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Redundant Private Network Uplinks", "id"=>4331, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Redundant Public & Private Network Uplinks", "id"=>4336, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_REDUNDANT_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>1284}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (48 TB)", "id"=>4370, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_48_TB", "softwareDescriptionId"=>1154, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Standard Edition (64 bit)", "id"=>4549, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_STD_64_BIT", "softwareDescriptionId"=>1225, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Express", "id"=>24, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_EXPRESS", "softwareDescriptionId"=>9, "upgradeItemId"=>nil}, {"capacity"=>"40", "description"=>"40 GB NAS", "id"=>41, "itemTaxCategoryId"=>166, "keyName"=>"NAS_40_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>42}, {"description"=>"Host Ping", "id"=>49, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_HOST_PING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Automated Notification", "id"=>52, "itemTaxCategoryId"=>166, "keyName"=>"AUTOMATED_NOTIFICATION", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Automated Reboot from Monitoring", "id"=>53, "itemTaxCategoryId"=>166, "keyName"=>"AUTOMATED_REBOOT_FROM_MONITORING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"300", "description"=>"300 GB SA-SCSI 15K RPM", "id"=>352, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_300GB_SASCSI_15K_RPM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"500", "description"=>"500 GB iSCSI SAN Storage", "id"=>553, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_500_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>621}, {"capacity"=>"500", "description"=>"500GB EVault Disk to Disk Enterprise Backup", "id"=>562, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_500_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4184}, {"capacity"=>"120", "description"=>"120 GB iSCSI SAN Storage", "id"=>575, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_120_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>622}, {"capacity"=>"0", "description"=>"FreeBSD 7.x  (32 bit)", "id"=>638, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_7_X_32_BIT", "softwareDescriptionId"=>666, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Virtuozzo Containers 4 for Linux - 3 VPS", "id"=>738, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_3_VPS", "softwareDescriptionId"=>319, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"Virtuozzo Containers 4 for Linux - 100 VPS", "id"=>745, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_100_VPS", "softwareDescriptionId"=>323, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Web Edition SP2 (64bit)", "id"=>935, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_64_BIT_SP2", "softwareDescriptionId"=>446, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Cloudera Distribution for Hadoop 2", "id"=>1044, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_CLOUDERA_DISTRIBUTION_HADOOP_2", "softwareDescriptionId"=>520, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Citrix XenServer 5.6", "id"=>1189, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6", "softwareDescriptionId"=>704, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft WebMatrix", "id"=>3898, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_WEBMATRIX_2", "softwareDescriptionId"=>868, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"International Services", "id"=>3955, "itemTaxCategoryId"=>166, "keyName"=>"INTERNATIONAL_SERVICES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 6.x (32 bit)", "id"=>4094, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_6_X_32_BIT_2", "softwareDescriptionId"=>1172, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 6.x (64 bit)", "id"=>4095, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_6_X_64_BIT", "softwareDescriptionId"=>1175, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"64", "description"=>"1 IPv6 Address", "id"=>4097, "itemTaxCategoryId"=>166, "keyName"=>"1_IPV6_ADDRESS", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Web Edition", "id"=>4147, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_WEB", "softwareDescriptionId"=>1004, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Enterprise Edition", "id"=>4149, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_ENTERPRISE", "softwareDescriptionId"=>1001, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MongoDB", "id"=>4226, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MONGODB", "softwareDescriptionId"=>1083, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 Datacenter Edition With Hyper-V (64bit)", "id"=>4247, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_DC_64_BIT_2", "softwareDescriptionId"=>1082, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x (32 bit) (per-processor licensing)", "id"=>4318, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_32_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1227, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Redundant Public & Private Network Uplinks", "id"=>4332, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_REDUNDANT_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>4336}, {"capacity"=>"0", "description"=>"Idera Server Backup 5.0 Enterprise (Windows)", "id"=>4344, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_SERVER_BACKUP_5_0_ENTERPRISE_WINDOWS", "softwareDescriptionId"=>1092, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 5 Pack", "id"=>4346, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_5_PACK", "softwareDescriptionId"=>1095, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"0 GB Bandwidth", "id"=>4481, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_0_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Datacenter Edition (64bit)", "id"=>4547, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_DC_64_BIT", "softwareDescriptionId"=>1226, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"200", "description"=>"200Mbps Hardware Firewall", "id"=>4551, "itemTaxCategoryId"=>166, "keyName"=>"200MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"cPanel/WHM with Softaculous and RVskin", "id"=>4608, "itemTaxCategoryId"=>166, "keyName"=>"CPANELWHM_WITH_SOFTACULOUS_AND_RVSKIN", "softwareDescriptionId"=>1292, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr - Minimal Install (32 bit)", "id"=>4708, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_MINIMAL_32_BIT_2", "softwareDescriptionId"=>1350, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 7.x (64 bit)", "id"=>5920, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_7_X_64_BIT", "softwareDescriptionId"=>1400, "units"=>"N/A", "upgradeItemId"=>nil}]
          fixture_package_items[43] = [{"capacity"=>"20", "description"=>"20 GB NAS", "id"=>40, "itemTaxCategoryId"=>166, "keyName"=>"NAS_20_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>41}, {"description"=>"Microsoft SQL Server 2005 Standard", "id"=>79, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_STANDARD", "softwareDescriptionId"=>8, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10Mbps Hardware Firewall", "id"=>299, "itemTaxCategoryId"=>166, "keyName"=>"10MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"Unlimited SSL VPN Users & 1 PPTP VPN User per account", "id"=>309, "itemTaxCategoryId"=>166, "keyName"=>"UNLIMITED_SSL_VPN_USERS_1_PPTP_VPN_USER_PER_ACCOUNT", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Standard SP2 with R2 (64 bit)", "id"=>422, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_STD_64_BIT_SP2_WR2", "softwareDescriptionId"=>126, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Enterprise SP2 with R2 (64 bit)", "id"=>424, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_ENT_64_BIT_SP2_WR2", "softwareDescriptionId"=>127, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB iSCSI SAN Storage", "id"=>551, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_100_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>575}, {"capacity"=>"40", "description"=>"40GB EVault Disk to Disk Enterprise Backup", "id"=>559, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_40_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>3784}, {"capacity"=>"1000", "description"=>"1000GB EVault Disk to Disk Enterprise Backup", "id"=>563, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_1000_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4185}, {"capacity"=>"0", "description"=>"FreeBSD 7.x  (64 bit)", "id"=>637, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_7_X_64_BIT", "softwareDescriptionId"=>667, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Web", "id"=>685, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WEB", "softwareDescriptionId"=>305, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Enterprise Edition SP2 (32bit)", "id"=>937, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_32_BIT_SP2", "softwareDescriptionId"=>448, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2000GB EVault Disk to Disk Enterprise Backup", "id"=>955, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_2000_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>nil}, {"capacity"=>"192", "description"=>"192 GB Registered DDR3 1066", "id"=>1147, "itemTaxCategoryId"=>166, "keyName"=>"RAM_192_GB_DDR3_1066_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Web R2", "id"=>1163, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WEB_R2", "softwareDescriptionId"=>696, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Express R2", "id"=>1162, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_EXPRESS_R2", "softwareDescriptionId"=>701, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 10 (Linux) 100 Domain w/ Power Pack", "id"=>1305, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_LINUX_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>938, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"200", "description"=>"200 GB SSD", "id"=>3811, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_200GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 6.x Squeeze/Stable (64 bit)", "id"=>3968, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_6_X_SQUEEZE_64_BIT", "softwareDescriptionId"=>919, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.0.0", "id"=>3977, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_0_0", "softwareDescriptionId"=>836, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 5.x (32 bit)", "id"=>4092, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_5_X_32_BIT_2", "softwareDescriptionId"=>1156, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.0.2", "id"=>4133, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_0_2", "softwareDescriptionId"=>961, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 10 Pack", "id"=>4155, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_10_PACK", "softwareDescriptionId"=>1011, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin - Minimal Install (32 bit)", "id"=>4169, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_MINIMAL_32_BIT", "softwareDescriptionId"=>1186, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"350", "description"=>"350GB EVault Disk to Disk Enterprise Backup", "id"=>4183, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_350_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>562}, {"capacity"=>"750", "description"=>"750GB EVault Disk to Disk Enterprise Backup", "id"=>4184, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_750_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>563}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Linux) 100 Domain w/ Power Pack", "id"=>4195, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_LINUX_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1191, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Windows) 100 Domain w/ Power Pack", "id"=>4199, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_WINDOWS_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1273, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 1 VM", "id"=>4303, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_1_VM", "softwareDescriptionId"=>1105, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - Unlimited VMs", "id"=>4307, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_UNLIMITED_VMS", "softwareDescriptionId"=>1112, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Redundant Private Network Uplinks", "id"=>4335, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.2", "id"=>4467, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_2", "softwareDescriptionId"=>1171, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Dual Public & Private Network Uplinks (Unbonded)", "id"=>5118, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_DUAL_PUBLIC_PRIVATE_NETWORK_UPLINKS_UNBONDED", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"80", "description"=>"80 GB NAS", "id"=>42, "itemTaxCategoryId"=>166, "keyName"=>"NAS_80_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>43}, {"capacity"=>"250", "description"=>"250 GB NAS", "id"=>44, "itemTaxCategoryId"=>166, "keyName"=>"NAS_250_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>411}, {"capacity"=>"1000", "description"=>"1 Gbps Public & Private Network Uplinks", "id"=>188, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"APF Software Firewall for Linux", "id"=>300, "itemTaxCategoryId"=>166, "keyName"=>"APF_SOFTWARE_FIREWALL_FOR_LINUX", "softwareDescriptionId"=>71, "upgradeItemId"=>nil}, {"description"=>"Nessus Vulnerability Assessment & Reporting", "id"=>307, "itemTaxCategoryId"=>98, "keyName"=>"NESSUS_VULNERABILITY_ASSESSMENT_REPORTING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"McAfee VirusScan Enterprise", "id"=>397, "itemTaxCategoryId"=>98, "keyName"=>"MCAFEE_VIRUSSCAN_ANTIVIRUS_WINDOWS", "softwareDescriptionId"=>820, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x (32 bit)", "id"=>419, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_32_BIT", "softwareDescriptionId"=>1239, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Non-RAID", "id"=>487, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_NONRAID", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Microsoft Windows Firewall", "id"=>495, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_WINDOWS_FIREWALL", "softwareDescriptionId"=>106, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Private Network Uplink", "id"=>498, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"80", "description"=>"80 GB iSCSI SAN Storage", "id"=>550, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_80_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>551}, {"capacity"=>"250", "description"=>"250GB EVault Disk to Disk Enterprise Backup", "id"=>561, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_250_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4183}, {"description"=>"Microsoft SQL Server 2008 Express", "id"=>681, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_EXPRESS", "softwareDescriptionId"=>308, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Enterprise", "id"=>682, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_ENTERPRISE", "softwareDescriptionId"=>307, "upgradeItemId"=>nil}, {"capacity"=>"30", "description"=>"30GB EVault Disk to Disk Enterprise Backup", "id"=>739, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_30_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>559}, {"capacity"=>"10", "description"=>"Virtuozzo Containers 4 for Linux - 10 VPS", "id"=>741, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_10_VPS", "softwareDescriptionId"=>318, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Datacenter Edition SP2 (32bit)", "id"=>939, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_32_BIT_SP2", "softwareDescriptionId"=>450, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Standard R2", "id"=>1161, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_STANDARD_R2", "softwareDescriptionId"=>698, "upgradeItemId"=>nil}, {"capacity"=>"3000", "description"=>"3000 GB iSCSI SAN Storage", "id"=>1176, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_3000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"3", "description"=>"Monitoring Package - Premium Application", "id"=>1250, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_PREMIUM_APPLICATION", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"capacity"=>"128", "description"=>"128 GB Registered DDR3 1333", "id"=>1307, "itemTaxCategoryId"=>166, "keyName"=>"RAM_128_GB_DDR3_1333_REG_2", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 10 (Windows) Unlimited Domain w/ Power Pack", "id"=>3785, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_WINDOWS_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>788, "upgradeItemId"=>nil}, {"capacity"=>"10000", "description"=>"10 Gbps Private Network Uplink", "id"=>3957, "itemTaxCategoryId"=>166, "keyName"=>"10_GBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Standard Edition", "id"=>4148, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_STANDARD", "softwareDescriptionId"=>1003, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 5 Pack", "id"=>4154, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_5_PACK", "softwareDescriptionId"=>1012, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 Standard Edition (64 bit)", "id"=>4233, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_STD_64_BIT", "softwareDescriptionId"=>1076, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESXi 5.1", "id"=>4272, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESXI_5_1", "softwareDescriptionId"=>1086, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 5 VMs", "id"=>4304, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_5_VMS", "softwareDescriptionId"=>1109, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 10 VMs", "id"=>4305, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_10_VMS", "softwareDescriptionId"=>1110, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"15", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 15 VMs", "id"=>4306, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_15_VMS", "softwareDescriptionId"=>1111, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x (64 bit) (per-processor licensing)", "id"=>4319, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_64_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1228, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Server Backup 5.0 Enterprise (Linux)", "id"=>4343, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_SERVER_BACKUP_5_0_ENTERPRISE_LINUX", "softwareDescriptionId"=>1093, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 10 Pack", "id"=>4347, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_10_PACK", "softwareDescriptionId"=>1096, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable (32 bit)", "id"=>4404, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_32_BIT", "softwareDescriptionId"=>1169, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"RAID", "id"=>4478, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Datacenter Edition With Hyper-V (64bit)", "id"=>4548, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_DC_64_BIT_2", "softwareDescriptionId"=>1226, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Host Ping and TCP Service Monitoring", "id"=>50, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_HOST_PING_AND_TCP_SERVICE", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Public & Private Network Uplinks", "id"=>186, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>187}, {"description"=>"McAfee Host Intrusion Protection w/Reporting", "id"=>302, "itemTaxCategoryId"=>98, "keyName"=>"MCAFEE_HOST_INTRUSION_PROTECTION_WREPORTING", "softwareDescriptionId"=>916, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1.00 TB SATA II", "id"=>471, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_1_00TB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Private Network Uplink", "id"=>497, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>498}, {"capacity"=>"20", "description"=>"20 GB iSCSI SAN Storage", "id"=>548, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_20_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>549}, {"capacity"=>"40", "description"=>"40 GB iSCSI SAN Storage", "id"=>549, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_40_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>598}, {"capacity"=>"2000", "description"=>"2000 GB iSCSI SAN Storage", "id"=>626, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_2000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>1176}, {"description"=>"Microsoft SQL Server 2008 Standard", "id"=>683, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_STANDARD", "softwareDescriptionId"=>306, "upgradeItemId"=>nil}, {"capacity"=>"70", "description"=>"Virtuozzo Containers 4 for Linux - 70 VPS", "id"=>744, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_70_VPS", "softwareDescriptionId"=>322, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Standard Edition (64bit)", "id"=>977, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_R2", "softwareDescriptionId"=>475, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Datacenter Edition (64bit)", "id"=>979, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_R2", "softwareDescriptionId"=>478, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"24", "description"=>"24 GB Registered DDR3 1333", "id"=>826, "itemTaxCategoryId"=>166, "keyName"=>"RAM_24_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 8.x (64 bit)", "id"=>1065, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_8_X_64_BIT_2", "softwareDescriptionId"=>1019, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"600", "description"=>"600 GB SA-SCSI 15K RPM", "id"=>1094, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_600GB_SASCSI_15K_RPM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx (32 bit)", "id"=>1136, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_32_BIT", "softwareDescriptionId"=>774, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 9.x (32 bit)", "id"=>4137, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_9_X_32_BIT_2", "softwareDescriptionId"=>1264, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 25 Pack", "id"=>4156, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_25_PACK", "softwareDescriptionId"=>1016, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin (64 bit)", "id"=>4166, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_64_BIT", "softwareDescriptionId"=>1165, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"175", "description"=>"175GB EVault Disk to Disk Enterprise Backup", "id"=>4182, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_175_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>561}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Linux) Unlimited Domain w/ Power Pack", "id"=>4197, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_LINUX_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1197, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10000", "description"=>"10 Gbps Redundant Private Network Uplinks", "id"=>4341, "itemTaxCategoryId"=>166, "keyName"=>"10_GBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"800", "description"=>"800 GB SSD", "id"=>4356, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_800GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (128 TB)", "id"=>4369, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_128_TB", "softwareDescriptionId"=>1155, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (16 TB)", "id"=>4371, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_16_TB", "softwareDescriptionId"=>1153, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Vyatta 6.x Subscription Edition (64 bit)", "id"=>4396, "itemTaxCategoryId"=>166, "keyName"=>"OS_VYATTA_6_X_SUBSCRIPTION_EDITION_64_BIT_2", "softwareDescriptionId"=>1221, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"No Operating System", "id"=>4648, "itemTaxCategoryId"=>166, "keyName"=>"OS_NO_OPERATING_SYSTEM", "softwareDescriptionId"=>1312, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr (32 bit)", "id"=>4700, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_32_BIT", "softwareDescriptionId"=>1360, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10000", "description"=>"10 Gbps Dual Public & Private Network Uplinks (Unbonded)", "id"=>5106, "itemTaxCategoryId"=>166, "keyName"=>"10_GBPS_DUAL_PUBLIC_PRIVATE_NETWORK_UPLINKS_UNBONDED", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Standard Edition", "id"=>5124, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_STANDARD_EDITION", "softwareDescriptionId"=>1334, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.5 - Minimal Install (64 bit) - version-locked", "id"=>5984, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_5_MINIMAL_64_BIT", "softwareDescriptionId"=>1263, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"1 IP Address", "id"=>15, "itemTaxCategoryId"=>166, "keyName"=>"1_IP_ADDRESS", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"MySQL for Linux", "id"=>22, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_LINUX", "softwareDescriptionId"=>156, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Workgroup", "id"=>80, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_WORKGROUP", "softwareDescriptionId"=>20, "upgradeItemId"=>nil}, {"capacity"=>"20000", "description"=>"20000 GB Bandwidth", "id"=>249, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_20000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100Mbps Hardware Firewall", "id"=>298, "itemTaxCategoryId"=>166, "keyName"=>"100MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"Redundant Power Supply", "id"=>469, "itemTaxCategoryId"=>166, "keyName"=>"REDUNDANT_POWER_SUPPLY", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"500", "description"=>"500 GB SATA II", "id"=>14, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_500GB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"RAID 0", "id"=>488, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_0", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"RAID 10", "id"=>491, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_10", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Private Network Uplink", "id"=>496, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>497}, {"capacity"=>"250", "description"=>"250 GB iSCSI SAN Storage", "id"=>552, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_250_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>612}, {"capacity"=>"20", "description"=>"20GB EVault Disk to Disk Enterprise Backup", "id"=>558, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_20_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>739}, {"capacity"=>"500", "description"=>"500 GB NAS", "id"=>611, "itemTaxCategoryId"=>166, "keyName"=>"NAS_500_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>605}, {"description"=>"Microsoft SQL Server 2008 Workgroup", "id"=>684, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WORKGROUP", "softwareDescriptionId"=>304, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"Virtuozzo Containers 4 for Linux - 5 VPS", "id"=>740, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_5_VPS", "softwareDescriptionId"=>317, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard Edition SP2 (64bit)", "id"=>936, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_SP2", "softwareDescriptionId"=>447, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Enterprise Edition (64bit)", "id"=>978, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_64_BIT_R2_2", "softwareDescriptionId"=>477, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Datacenter Edition With Hyper-V (64bit)", "id"=>980, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_R2_2", "softwareDescriptionId"=>478, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix Essentials for XenServer 5.5 (Billed per VM)", "id"=>1077, "itemTaxCategoryId"=>166, "keyName"=>"CITRIX_ESSENTIALS_XENSERVER_5_5", "softwareDescriptionId"=>521, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"72", "description"=>"72 GB Registered DDR3 1333", "id"=>829, "itemTaxCategoryId"=>166, "keyName"=>"RAM_72_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"96", "description"=>"96 GB Registered DDR3 1333", "id"=>1050, "itemTaxCategoryId"=>166, "keyName"=>"RAM_96_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Workgroup R2", "id"=>1164, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WORKGROUP_R2", "softwareDescriptionId"=>697, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Redundant Public & Private Network Uplinks", "id"=>1284, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_REDUNDANT_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 10 (Linux) Unlimited Domain w/ Power Pack", "id"=>1306, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_LINUX_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>939, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 5.6.1", "id"=>1322, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6_1", "softwareDescriptionId"=>801, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x (32 bit)", "id"=>3904, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_32_BIT", "softwareDescriptionId"=>1258, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 6.x Squeeze/Stable (32 bit)", "id"=>3967, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_6_X_SQUEEZE_32_BIT", "softwareDescriptionId"=>918, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESX 4.1", "id"=>3969, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESX_4_1", "softwareDescriptionId"=>800, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 5.x (64 bit)", "id"=>4093, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_5_X_64_BIT_3", "softwareDescriptionId"=>1158, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Express Edition", "id"=>4150, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_EXPRESS", "softwareDescriptionId"=>1005, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1500", "description"=>"1500GB EVault Disk to Disk Enterprise Backup", "id"=>4185, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_1500_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>955}, {"capacity"=>"0", "description"=>"Windows Server 2012 Datacenter Edition (64bit)", "id"=>4237, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_DC_64_BIT", "softwareDescriptionId"=>1082, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 1 Pack", "id"=>4345, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_1_PACK", "softwareDescriptionId"=>1094, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 25 Pack", "id"=>4348, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_25_PACK", "softwareDescriptionId"=>1097, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable (64 bit)", "id"=>4405, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_64_BIT", "softwareDescriptionId"=>1104, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware vCenter 5.5 Standard", "id"=>4598, "itemTaxCategoryId"=>166, "keyName"=>"VMWARE_VCENTER_5_5_STANDARD", "softwareDescriptionId"=>1275, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr - Minimal Install (64 bit)", "id"=>4710, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_MINIMAL_64_BIT_2", "softwareDescriptionId"=>1346, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 12 - 30 Domain w/ Power Pack", "id"=>6010, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_12_30_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1414, "upgradeItemId"=>nil}, {"capacity"=>"8", "description"=>"8 Public IP Addresses", "id"=>17, "itemTaxCategoryId"=>166, "keyName"=>"8_PUBLIC_IP_ADDRESSES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"MySQL 5.0 for Windows", "id"=>23, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_0_WINDOWS", "softwareDescriptionId"=>13, "upgradeItemId"=>nil}, {"description"=>"Email and Ticket", "id"=>51, "itemTaxCategoryId"=>166, "keyName"=>"NOTIFICATION_EMAIL_AND_TICKET", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"NOC Monitoring", "id"=>54, "itemTaxCategoryId"=>166, "keyName"=>"NOC_MONITORING", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"cPanel/WHM with Fantastico and RVskin", "id"=>96, "itemTaxCategoryId"=>166, "keyName"=>"CPANELWHM_WITH_FANTASTICO_AND_RVSKIN", "softwareDescriptionId"=>31, "upgradeItemId"=>nil}, {"description"=>"Unlimited Bandwidth (100 Mbps Uplink)", "id"=>97, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_UNLIMITED_100_MBPS_UPLINK", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"RAID 1", "id"=>489, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_1", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"RAID 5", "id"=>490, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_5", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Reboot / KVM over IP", "id"=>504, "itemTaxCategoryId"=>166, "keyName"=>"REBOOT_KVM_OVER_IP", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1000 GB iSCSI SAN Storage", "id"=>554, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_1000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>783}, {"capacity"=>"150", "description"=>"Virtuozzo Containers 4 for Linux - 150 VPS", "id"=>746, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_150_VPS", "softwareDescriptionId"=>324, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"50", "description"=>"Virtuozzo Containers 4 for Linux - 50 VPS", "id"=>743, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_50_VPS", "softwareDescriptionId"=>321, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard Edition SP2 (32bit)", "id"=>933, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_32_BIT_SP2", "softwareDescriptionId"=>444, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Enterprise Edition SP2 (64bit)", "id"=>938, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_64_BIT_SP2", "softwareDescriptionId"=>449, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Datacenter Edition SP2 (64bit)", "id"=>940, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_SP2", "softwareDescriptionId"=>451, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Citrix XenServer 5.5", "id"=>950, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_5", "softwareDescriptionId"=>642, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Web Edition (64bit)", "id"=>976, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_64_BIT_R2_SP1", "softwareDescriptionId"=>832, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Standard SP2 with R2 (32 bit)", "id"=>421, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_STD_32_BIT_SP2_WR2", "softwareDescriptionId"=>125, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Web Edition SP2 (32bit)", "id"=>934, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_32_BIT_SP2", "softwareDescriptionId"=>445, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2.00 TB SATA II", "id"=>1091, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_2_00TB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"12", "description"=>"12 GB Registered DDR3 1333", "id"=>824, "itemTaxCategoryId"=>166, "keyName"=>"RAM_12_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"36", "description"=>"36 GB Registered DDR3 1333", "id"=>827, "itemTaxCategoryId"=>166, "keyName"=>"RAM_36_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Enterprise for XenServer 5.6", "id"=>1300, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ENTERPRISE_FOR_XENSERVER_5_6", "softwareDescriptionId"=>726, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin - Minimal Install (64 bit)", "id"=>4170, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_MINIMAL_64_BIT_2", "softwareDescriptionId"=>1184, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Windows) Unlimited Domain w/ Power Pack", "id"=>4200, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_WINDOWS_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1274, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.1", "id"=>4258, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_1", "softwareDescriptionId"=>1065, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware vCenter 5.1 Standard", "id"=>4298, "itemTaxCategoryId"=>166, "keyName"=>"VMWARE_VCENTER_5_1_STANDARD", "softwareDescriptionId"=>1090, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (4 TB)", "id"=>4372, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_4_TB", "softwareDescriptionId"=>1123, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Vyatta 6.6 Community Edition (64 bit)", "id"=>4495, "itemTaxCategoryId"=>166, "keyName"=>"OS_VYATTA_6_6_COMMUNITY_EDITION_64_BIT", "softwareDescriptionId"=>1192, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"20", "description"=>"20Mbps Hardware Firewall", "id"=>4550, "itemTaxCategoryId"=>166, "keyName"=>"20MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.2.1", "id"=>4569, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_2_1", "softwareDescriptionId"=>1257, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MySQL 5.7 for Windows", "id"=>4592, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_7_WINDOWS", "softwareDescriptionId"=>1272, "upgradeItemId"=>nil}, {"capacity"=>"10000", "description"=>"10 Gbps Dual Private Network Uplinks (Unbonded)", "id"=>5102, "itemTaxCategoryId"=>166, "keyName"=>"10_GBPS_DUAL_PRIVATE_NETWORK_UPLINKS_UNBONDED", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Enterprise Edition", "id"=>5120, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_ENTERPRISE_EDITION_2", "softwareDescriptionId"=>1330, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Enterprise", "id"=>81, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_ENTERPRISE", "softwareDescriptionId"=>21, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Public & Private Network Uplinks", "id"=>187, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>188}, {"capacity"=>"1000", "description"=>"1000Mbps Hardware Firewall", "id"=>297, "itemTaxCategoryId"=>166, "keyName"=>"1000MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x (64 bit)", "id"=>420, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_64_BIT", "softwareDescriptionId"=>1240, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Enterprise SP2 with R2 (32 bit)", "id"=>423, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_ENT_32_BIT_SP2_WR2", "softwareDescriptionId"=>128, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 8.x (32 bit)", "id"=>1066, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_8_X_32_BIT", "softwareDescriptionId"=>1022, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"60", "description"=>"60GB EVault Disk to Disk Enterprise Backup", "id"=>1076, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_60_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>560}, {"capacity"=>"18", "description"=>"18 GB Registered DDR3 1333", "id"=>825, "itemTaxCategoryId"=>166, "keyName"=>"RAM_18_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"2", "description"=>"Monitoring Package - Advanced", "id"=>1249, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_ADVANCED", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"capacity"=>"10000", "description"=>"10 Gbps Public & Private Network Uplinks", "id"=>1281, "itemTaxCategoryId"=>166, "keyName"=>"10_GBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"50", "description"=>"50GB EVault Disk to Disk Enterprise Backup", "id"=>3784, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_50_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>1076}, {"description"=>"Parallels Plesk Panel 10 (Windows) 100 Domain w/ Power Pack", "id"=>3786, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_WINDOWS_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>787, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x (64 bit)", "id"=>3907, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_64_BIT", "softwareDescriptionId"=>1261, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Redundant Private Network Uplinks", "id"=>3956, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"3000", "description"=>"3.00 TB SATA III", "id"=>3989, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_3_00TB_SATA_III", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Enterprise for XenServer 6.x", "id"=>4105, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ENTERPRISE_FOR_XENSERVER_6_X", "softwareDescriptionId"=>909, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 1 Pack", "id"=>4153, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_1_PACK", "softwareDescriptionId"=>1015, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin (32 bit)", "id"=>4165, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_32_BIT", "softwareDescriptionId"=>1166, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Dual Public & Private Network Uplinks (Unbonded)", "id"=>4263, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_DUAL_PUBLIC_PRIVATE_NETWORK_UPLINKS_UNBONDED", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"4000", "description"=>"4.00 TB SATA III", "id"=>4281, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_4_00TB_SATA_III", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Vyatta 6.5 Community Edition (64 bit)", "id"=>4315, "itemTaxCategoryId"=>166, "keyName"=>"OS_VYATTA_6_5_COMMUNITY_EDITION_64_BIT", "softwareDescriptionId"=>1106, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x (64 bit) (per-processor licensing)", "id"=>4321, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_64_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1247, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable - Minimal Install (32 bit)", "id"=>4406, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_MINIMAL_32_BIT", "softwareDescriptionId"=>1176, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable - Minimal Install (64 bit)", "id"=>4407, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_MINIMAL_64_BIT", "softwareDescriptionId"=>1177, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MySQL 5.0.51 for Windows", "id"=>4557, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_0_51_WINDOWS", "softwareDescriptionId"=>220, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESXi 5.5", "id"=>4562, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESXI_5_5", "softwareDescriptionId"=>1256, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 10.x (32 bit)", "id"=>4640, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_10_X_32_BIT", "softwareDescriptionId"=>1284, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 10.x (64 bit)", "id"=>4638, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_10_X_64_BIT", "softwareDescriptionId"=>1286, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr (64 bit)", "id"=>4702, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_64_BIT", "softwareDescriptionId"=>1362, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Express Edition", "id"=>5122, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_EXPRESS_EDITION", "softwareDescriptionId"=>1332, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 12 - Unlimited Domain w/ Power Pack", "id"=>6014, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_12_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1420, "upgradeItemId"=>nil}, {"capacity"=>"4", "description"=>"4 Public IP Addresses", "id"=>16, "itemTaxCategoryId"=>166, "keyName"=>"4_PUBLIC_IP_ADDRESSES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Unlimited Bandwidth (10 Mbps Uplink)", "id"=>30, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_UNLIMITED_10_MBPS_UPLINK", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB NAS", "id"=>43, "itemTaxCategoryId"=>166, "keyName"=>"NAS_100_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>44}, {"description"=>"Business Continuance Insurance", "id"=>84, "itemTaxCategoryId"=>108, "keyName"=>"BUSINESS_CONTINUANCE_INSURANCE", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100GB EVault Disk to Disk Enterprise Backup", "id"=>560, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_100_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4182}, {"capacity"=>"30", "description"=>"Virtuozzo Containers 4 for Linux - 30 VPS", "id"=>742, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_30_VPS", "softwareDescriptionId"=>320, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"64", "description"=>"/64 Block Static Public IPv6 Addresses", "id"=>784, "itemTaxCategoryId"=>166, "keyName"=>"64_BLOCK_STATIC_PUBLIC_IPV6_ADDRESSES", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESX 4.0", "id"=>1078, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESX_4_0", "softwareDescriptionId"=>497, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"48", "description"=>"48 GB Registered DDR3 1333", "id"=>828, "itemTaxCategoryId"=>166, "keyName"=>"RAM_48_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx (64 bit)", "id"=>1137, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_64_BIT", "softwareDescriptionId"=>775, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Enterprise R2", "id"=>1165, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_ENTERPRISE_R2", "softwareDescriptionId"=>699, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Datacenter R2", "id"=>1166, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_DATACENTER_R2", "softwareDescriptionId"=>700, "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Monitoring Package - Basic", "id"=>1248, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_BASIC", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2000Mbps Hardware Firewall", "id"=>1296, "itemTaxCategoryId"=>166, "keyName"=>"2000MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Advanced for XenServer 5.6", "id"=>1299, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ADVANCED_FOR_XENSERVER_5_6", "softwareDescriptionId"=>726, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"EVault Plugin - BMR (Bare Metal Restore)", "id"=>961, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_PLUGIN_BMR_BARE_METAL_RESTORE", "softwareDescriptionId"=>467, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 5.6.2", "id"=>3886, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6_2", "softwareDescriptionId"=>867, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Advanced for XenServer 6.x", "id"=>4104, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ADVANCED_FOR_XENSERVER_6_X", "softwareDescriptionId"=>908, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 9.x (64 bit)", "id"=>4138, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_9_X_64_BIT", "softwareDescriptionId"=>1265, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"400", "description"=>"400 GB SSD", "id"=>4181, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_400GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Cloudera Distribution for Hadoop 4", "id"=>4301, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_CLOUDERA_DISTRIBUTION_HADOOP_4", "softwareDescriptionId"=>1099, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x (32 bit) (per-processor licensing)", "id"=>4320, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_32_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1246, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Riak 1.x", "id"=>4327, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_RIAK_1_X", "softwareDescriptionId"=>1114, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Redundant Private Network Uplinks", "id"=>4331, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Redundant Public & Private Network Uplinks", "id"=>4336, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_REDUNDANT_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>1284}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (48 TB)", "id"=>4370, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_48_TB", "softwareDescriptionId"=>1154, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Standard Edition (64 bit)", "id"=>4549, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_STD_64_BIT", "softwareDescriptionId"=>1225, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Express", "id"=>24, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_EXPRESS", "softwareDescriptionId"=>9, "upgradeItemId"=>nil}, {"capacity"=>"40", "description"=>"40 GB NAS", "id"=>41, "itemTaxCategoryId"=>166, "keyName"=>"NAS_40_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>42}, {"description"=>"Host Ping", "id"=>49, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_HOST_PING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Automated Notification", "id"=>52, "itemTaxCategoryId"=>166, "keyName"=>"AUTOMATED_NOTIFICATION", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Automated Reboot from Monitoring", "id"=>53, "itemTaxCategoryId"=>166, "keyName"=>"AUTOMATED_REBOOT_FROM_MONITORING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"300", "description"=>"300 GB SA-SCSI 15K RPM", "id"=>352, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_300GB_SASCSI_15K_RPM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"500", "description"=>"500 GB iSCSI SAN Storage", "id"=>553, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_500_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>621}, {"capacity"=>"500", "description"=>"500GB EVault Disk to Disk Enterprise Backup", "id"=>562, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_500_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4184}, {"capacity"=>"120", "description"=>"120 GB iSCSI SAN Storage", "id"=>575, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_120_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>622}, {"capacity"=>"0", "description"=>"FreeBSD 7.x  (32 bit)", "id"=>638, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_7_X_32_BIT", "softwareDescriptionId"=>666, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Virtuozzo Containers 4 for Linux - 3 VPS", "id"=>738, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_3_VPS", "softwareDescriptionId"=>319, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"Virtuozzo Containers 4 for Linux - 100 VPS", "id"=>745, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_100_VPS", "softwareDescriptionId"=>323, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Web Edition SP2 (64bit)", "id"=>935, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_64_BIT_SP2", "softwareDescriptionId"=>446, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Cloudera Distribution for Hadoop 2", "id"=>1044, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_CLOUDERA_DISTRIBUTION_HADOOP_2", "softwareDescriptionId"=>520, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"144", "description"=>"144 GB Registered DDR3 1333", "id"=>1011, "itemTaxCategoryId"=>166, "keyName"=>"RAM_144_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"description"=>"Citrix XenServer 5.6", "id"=>1189, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6", "softwareDescriptionId"=>704, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft WebMatrix", "id"=>3898, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_WEBMATRIX_2", "softwareDescriptionId"=>868, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"International Services", "id"=>3955, "itemTaxCategoryId"=>166, "keyName"=>"INTERNATIONAL_SERVICES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 6.x (32 bit)", "id"=>4094, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_6_X_32_BIT_2", "softwareDescriptionId"=>1172, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 6.x (64 bit)", "id"=>4095, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_6_X_64_BIT", "softwareDescriptionId"=>1175, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"64", "description"=>"1 IPv6 Address", "id"=>4097, "itemTaxCategoryId"=>166, "keyName"=>"1_IPV6_ADDRESS", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Web Edition", "id"=>4147, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_WEB", "softwareDescriptionId"=>1004, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Enterprise Edition", "id"=>4149, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_ENTERPRISE", "softwareDescriptionId"=>1001, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MongoDB", "id"=>4226, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MONGODB", "softwareDescriptionId"=>1083, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 Datacenter Edition With Hyper-V (64bit)", "id"=>4247, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_DC_64_BIT_2", "softwareDescriptionId"=>1082, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x (32 bit) (per-processor licensing)", "id"=>4318, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_32_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1227, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Redundant Public & Private Network Uplinks", "id"=>4332, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_REDUNDANT_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>4336}, {"capacity"=>"0", "description"=>"Idera Server Backup 5.0 Enterprise (Windows)", "id"=>4344, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_SERVER_BACKUP_5_0_ENTERPRISE_WINDOWS", "softwareDescriptionId"=>1092, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 5 Pack", "id"=>4346, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_5_PACK", "softwareDescriptionId"=>1095, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"0 GB Bandwidth", "id"=>4481, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_0_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Datacenter Edition (64bit)", "id"=>4547, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_DC_64_BIT", "softwareDescriptionId"=>1226, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"200", "description"=>"200Mbps Hardware Firewall", "id"=>4551, "itemTaxCategoryId"=>166, "keyName"=>"200MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"cPanel/WHM with Softaculous and RVskin", "id"=>4608, "itemTaxCategoryId"=>166, "keyName"=>"CPANELWHM_WITH_SOFTACULOUS_AND_RVSKIN", "softwareDescriptionId"=>1292, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr - Minimal Install (32 bit)", "id"=>4708, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_MINIMAL_32_BIT_2", "softwareDescriptionId"=>1350, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 7.x (64 bit)", "id"=>5920, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_7_X_64_BIT", "softwareDescriptionId"=>1400, "units"=>"N/A", "upgradeItemId"=>nil}]
          fixture_package_items[44] = [{"capacity"=>"20", "description"=>"20 GB NAS", "id"=>40, "itemTaxCategoryId"=>166, "keyName"=>"NAS_20_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>41}, {"description"=>"Microsoft SQL Server 2005 Standard", "id"=>79, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_STANDARD", "softwareDescriptionId"=>8, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10Mbps Hardware Firewall", "id"=>299, "itemTaxCategoryId"=>166, "keyName"=>"10MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"Unlimited SSL VPN Users & 1 PPTP VPN User per account", "id"=>309, "itemTaxCategoryId"=>166, "keyName"=>"UNLIMITED_SSL_VPN_USERS_1_PPTP_VPN_USER_PER_ACCOUNT", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Standard SP2 with R2 (64 bit)", "id"=>422, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_STD_64_BIT_SP2_WR2", "softwareDescriptionId"=>126, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Enterprise SP2 with R2 (64 bit)", "id"=>424, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_ENT_64_BIT_SP2_WR2", "softwareDescriptionId"=>127, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB iSCSI SAN Storage", "id"=>551, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_100_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>575}, {"capacity"=>"40", "description"=>"40GB EVault Disk to Disk Enterprise Backup", "id"=>559, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_40_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>3784}, {"capacity"=>"1000", "description"=>"1000GB EVault Disk to Disk Enterprise Backup", "id"=>563, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_1000_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4185}, {"capacity"=>"0", "description"=>"FreeBSD 7.x  (64 bit)", "id"=>637, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_7_X_64_BIT", "softwareDescriptionId"=>667, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Web", "id"=>685, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WEB", "softwareDescriptionId"=>305, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Enterprise Edition SP2 (32bit)", "id"=>937, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_32_BIT_SP2", "softwareDescriptionId"=>448, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2000GB EVault Disk to Disk Enterprise Backup", "id"=>955, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_2000_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>nil}, {"capacity"=>"192", "description"=>"192 GB Registered DDR3 1066", "id"=>1147, "itemTaxCategoryId"=>166, "keyName"=>"RAM_192_GB_DDR3_1066_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Web R2", "id"=>1163, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WEB_R2", "softwareDescriptionId"=>696, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Express R2", "id"=>1162, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_EXPRESS_R2", "softwareDescriptionId"=>701, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 10 (Linux) 100 Domain w/ Power Pack", "id"=>1305, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_LINUX_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>938, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"200", "description"=>"200 GB SSD", "id"=>3811, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_200GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 6.x Squeeze/Stable (64 bit)", "id"=>3968, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_6_X_SQUEEZE_64_BIT", "softwareDescriptionId"=>919, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.0.0", "id"=>3977, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_0_0", "softwareDescriptionId"=>836, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 5.x (32 bit)", "id"=>4092, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_5_X_32_BIT_2", "softwareDescriptionId"=>1156, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.0.2", "id"=>4133, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_0_2", "softwareDescriptionId"=>961, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 10 Pack", "id"=>4155, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_10_PACK", "softwareDescriptionId"=>1011, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin - Minimal Install (32 bit)", "id"=>4169, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_MINIMAL_32_BIT", "softwareDescriptionId"=>1186, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"350", "description"=>"350GB EVault Disk to Disk Enterprise Backup", "id"=>4183, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_350_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>562}, {"capacity"=>"750", "description"=>"750GB EVault Disk to Disk Enterprise Backup", "id"=>4184, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_750_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>563}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Linux) 100 Domain w/ Power Pack", "id"=>4195, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_LINUX_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1191, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Windows) 100 Domain w/ Power Pack", "id"=>4199, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_WINDOWS_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1273, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 1 VM", "id"=>4303, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_1_VM", "softwareDescriptionId"=>1105, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - Unlimited VMs", "id"=>4307, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_UNLIMITED_VMS", "softwareDescriptionId"=>1112, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Redundant Private Network Uplinks", "id"=>4335, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.2", "id"=>4467, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_2", "softwareDescriptionId"=>1171, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Dual Public & Private Network Uplinks (Unbonded)", "id"=>5118, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_DUAL_PUBLIC_PRIVATE_NETWORK_UPLINKS_UNBONDED", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"80", "description"=>"80 GB NAS", "id"=>42, "itemTaxCategoryId"=>166, "keyName"=>"NAS_80_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>43}, {"capacity"=>"250", "description"=>"250 GB NAS", "id"=>44, "itemTaxCategoryId"=>166, "keyName"=>"NAS_250_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>411}, {"capacity"=>"1000", "description"=>"1 Gbps Public & Private Network Uplinks", "id"=>188, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"APF Software Firewall for Linux", "id"=>300, "itemTaxCategoryId"=>166, "keyName"=>"APF_SOFTWARE_FIREWALL_FOR_LINUX", "softwareDescriptionId"=>71, "upgradeItemId"=>nil}, {"description"=>"Nessus Vulnerability Assessment & Reporting", "id"=>307, "itemTaxCategoryId"=>98, "keyName"=>"NESSUS_VULNERABILITY_ASSESSMENT_REPORTING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"McAfee VirusScan Enterprise", "id"=>397, "itemTaxCategoryId"=>98, "keyName"=>"MCAFEE_VIRUSSCAN_ANTIVIRUS_WINDOWS", "softwareDescriptionId"=>820, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x (32 bit)", "id"=>419, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_32_BIT", "softwareDescriptionId"=>1239, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Non-RAID", "id"=>487, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_NONRAID", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Microsoft Windows Firewall", "id"=>495, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_WINDOWS_FIREWALL", "softwareDescriptionId"=>106, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Private Network Uplink", "id"=>498, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"80", "description"=>"80 GB iSCSI SAN Storage", "id"=>550, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_80_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>551}, {"capacity"=>"250", "description"=>"250GB EVault Disk to Disk Enterprise Backup", "id"=>561, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_250_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4183}, {"description"=>"Microsoft SQL Server 2008 Express", "id"=>681, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_EXPRESS", "softwareDescriptionId"=>308, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Enterprise", "id"=>682, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_ENTERPRISE", "softwareDescriptionId"=>307, "upgradeItemId"=>nil}, {"capacity"=>"30", "description"=>"30GB EVault Disk to Disk Enterprise Backup", "id"=>739, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_30_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>559}, {"capacity"=>"10", "description"=>"Virtuozzo Containers 4 for Linux - 10 VPS", "id"=>741, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_10_VPS", "softwareDescriptionId"=>318, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Datacenter Edition SP2 (32bit)", "id"=>939, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_32_BIT_SP2", "softwareDescriptionId"=>450, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Standard R2", "id"=>1161, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_STANDARD_R2", "softwareDescriptionId"=>698, "upgradeItemId"=>nil}, {"capacity"=>"3000", "description"=>"3000 GB iSCSI SAN Storage", "id"=>1176, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_3000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"3", "description"=>"Monitoring Package - Premium Application", "id"=>1250, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_PREMIUM_APPLICATION", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"capacity"=>"128", "description"=>"128 GB Registered DDR3 1333", "id"=>1307, "itemTaxCategoryId"=>166, "keyName"=>"RAM_128_GB_DDR3_1333_REG_2", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 10 (Windows) Unlimited Domain w/ Power Pack", "id"=>3785, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_WINDOWS_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>788, "upgradeItemId"=>nil}, {"capacity"=>"10000", "description"=>"10 Gbps Private Network Uplink", "id"=>3957, "itemTaxCategoryId"=>166, "keyName"=>"10_GBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Standard Edition", "id"=>4148, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_STANDARD", "softwareDescriptionId"=>1003, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 5 Pack", "id"=>4154, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_5_PACK", "softwareDescriptionId"=>1012, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 Standard Edition (64 bit)", "id"=>4233, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_STD_64_BIT", "softwareDescriptionId"=>1076, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESXi 5.1", "id"=>4272, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESXI_5_1", "softwareDescriptionId"=>1086, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 5 VMs", "id"=>4304, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_5_VMS", "softwareDescriptionId"=>1109, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 10 VMs", "id"=>4305, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_10_VMS", "softwareDescriptionId"=>1110, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"15", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 15 VMs", "id"=>4306, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_15_VMS", "softwareDescriptionId"=>1111, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x (64 bit) (per-processor licensing)", "id"=>4319, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_64_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1228, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Server Backup 5.0 Enterprise (Linux)", "id"=>4343, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_SERVER_BACKUP_5_0_ENTERPRISE_LINUX", "softwareDescriptionId"=>1093, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 10 Pack", "id"=>4347, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_10_PACK", "softwareDescriptionId"=>1096, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable (32 bit)", "id"=>4404, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_32_BIT", "softwareDescriptionId"=>1169, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"RAID", "id"=>4478, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Datacenter Edition With Hyper-V (64bit)", "id"=>4548, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_DC_64_BIT_2", "softwareDescriptionId"=>1226, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Host Ping and TCP Service Monitoring", "id"=>50, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_HOST_PING_AND_TCP_SERVICE", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Public & Private Network Uplinks", "id"=>186, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>187}, {"description"=>"McAfee Host Intrusion Protection w/Reporting", "id"=>302, "itemTaxCategoryId"=>98, "keyName"=>"MCAFEE_HOST_INTRUSION_PROTECTION_WREPORTING", "softwareDescriptionId"=>916, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1.00 TB SATA II", "id"=>471, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_1_00TB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Private Network Uplink", "id"=>497, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>498}, {"capacity"=>"20", "description"=>"20 GB iSCSI SAN Storage", "id"=>548, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_20_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>549}, {"capacity"=>"40", "description"=>"40 GB iSCSI SAN Storage", "id"=>549, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_40_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>598}, {"capacity"=>"2000", "description"=>"2000 GB iSCSI SAN Storage", "id"=>626, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_2000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>1176}, {"description"=>"Microsoft SQL Server 2008 Standard", "id"=>683, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_STANDARD", "softwareDescriptionId"=>306, "upgradeItemId"=>nil}, {"capacity"=>"70", "description"=>"Virtuozzo Containers 4 for Linux - 70 VPS", "id"=>744, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_70_VPS", "softwareDescriptionId"=>322, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Standard Edition (64bit)", "id"=>977, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_R2", "softwareDescriptionId"=>475, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Datacenter Edition (64bit)", "id"=>979, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_R2", "softwareDescriptionId"=>478, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"24", "description"=>"24 GB Registered DDR3 1333", "id"=>826, "itemTaxCategoryId"=>166, "keyName"=>"RAM_24_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 8.x (64 bit)", "id"=>1065, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_8_X_64_BIT_2", "softwareDescriptionId"=>1019, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"600", "description"=>"600 GB SA-SCSI 15K RPM", "id"=>1094, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_600GB_SASCSI_15K_RPM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx (32 bit)", "id"=>1136, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_32_BIT", "softwareDescriptionId"=>774, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 9.x (32 bit)", "id"=>4137, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_9_X_32_BIT_2", "softwareDescriptionId"=>1264, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 25 Pack", "id"=>4156, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_25_PACK", "softwareDescriptionId"=>1016, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin (64 bit)", "id"=>4166, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_64_BIT", "softwareDescriptionId"=>1165, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"175", "description"=>"175GB EVault Disk to Disk Enterprise Backup", "id"=>4182, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_175_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>561}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Linux) Unlimited Domain w/ Power Pack", "id"=>4197, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_LINUX_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1197, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10000", "description"=>"10 Gbps Redundant Private Network Uplinks", "id"=>4341, "itemTaxCategoryId"=>166, "keyName"=>"10_GBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"800", "description"=>"800 GB SSD", "id"=>4356, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_800GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (128 TB)", "id"=>4369, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_128_TB", "softwareDescriptionId"=>1155, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (16 TB)", "id"=>4371, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_16_TB", "softwareDescriptionId"=>1153, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"No Operating System", "id"=>4648, "itemTaxCategoryId"=>166, "keyName"=>"OS_NO_OPERATING_SYSTEM", "softwareDescriptionId"=>1312, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr (32 bit)", "id"=>4700, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_32_BIT", "softwareDescriptionId"=>1360, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10000", "description"=>"10 Gbps Dual Public & Private Network Uplinks (Unbonded)", "id"=>5106, "itemTaxCategoryId"=>166, "keyName"=>"10_GBPS_DUAL_PUBLIC_PRIVATE_NETWORK_UPLINKS_UNBONDED", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Standard Edition", "id"=>5124, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_STANDARD_EDITION", "softwareDescriptionId"=>1334, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.5 - Minimal Install (64 bit) - version-locked", "id"=>5984, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_5_MINIMAL_64_BIT", "softwareDescriptionId"=>1263, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"1 IP Address", "id"=>15, "itemTaxCategoryId"=>166, "keyName"=>"1_IP_ADDRESS", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"MySQL for Linux", "id"=>22, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_LINUX", "softwareDescriptionId"=>156, "upgradeItemId"=>nil}, {"capacity"=>"20000", "description"=>"20000 GB Bandwidth", "id"=>249, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_20000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100Mbps Hardware Firewall", "id"=>298, "itemTaxCategoryId"=>166, "keyName"=>"100MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"Redundant Power Supply", "id"=>469, "itemTaxCategoryId"=>166, "keyName"=>"REDUNDANT_POWER_SUPPLY", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"500", "description"=>"500 GB SATA II", "id"=>14, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_500GB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"RAID 0", "id"=>488, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_0", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"RAID 10", "id"=>491, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_10", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Private Network Uplink", "id"=>496, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>497}, {"capacity"=>"250", "description"=>"250 GB iSCSI SAN Storage", "id"=>552, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_250_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>612}, {"capacity"=>"20", "description"=>"20GB EVault Disk to Disk Enterprise Backup", "id"=>558, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_20_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>739}, {"capacity"=>"500", "description"=>"500 GB NAS", "id"=>611, "itemTaxCategoryId"=>166, "keyName"=>"NAS_500_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>605}, {"description"=>"Microsoft SQL Server 2008 Workgroup", "id"=>684, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WORKGROUP", "softwareDescriptionId"=>304, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"Virtuozzo Containers 4 for Linux - 5 VPS", "id"=>740, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_5_VPS", "softwareDescriptionId"=>317, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard Edition SP2 (64bit)", "id"=>936, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_SP2", "softwareDescriptionId"=>447, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Enterprise Edition (64bit)", "id"=>978, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_64_BIT_R2_2", "softwareDescriptionId"=>477, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Datacenter Edition With Hyper-V (64bit)", "id"=>980, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_R2_2", "softwareDescriptionId"=>478, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix Essentials for XenServer 5.5 (Billed per VM)", "id"=>1077, "itemTaxCategoryId"=>166, "keyName"=>"CITRIX_ESSENTIALS_XENSERVER_5_5", "softwareDescriptionId"=>521, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"60", "description"=>"60 GB Registered DDR3 1333", "id"=>948, "itemTaxCategoryId"=>166, "keyName"=>"RAM_60_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"72", "description"=>"72 GB Registered DDR3 1333", "id"=>829, "itemTaxCategoryId"=>166, "keyName"=>"RAM_72_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"96", "description"=>"96 GB Registered DDR3 1333", "id"=>1050, "itemTaxCategoryId"=>166, "keyName"=>"RAM_96_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Workgroup R2", "id"=>1164, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WORKGROUP_R2", "softwareDescriptionId"=>697, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Redundant Public & Private Network Uplinks", "id"=>1284, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_REDUNDANT_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 10 (Linux) Unlimited Domain w/ Power Pack", "id"=>1306, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_LINUX_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>939, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 5.6.1", "id"=>1322, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6_1", "softwareDescriptionId"=>801, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x (32 bit)", "id"=>3904, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_32_BIT", "softwareDescriptionId"=>1258, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 6.x Squeeze/Stable (32 bit)", "id"=>3967, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_6_X_SQUEEZE_32_BIT", "softwareDescriptionId"=>918, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESX 4.1", "id"=>3969, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESX_4_1", "softwareDescriptionId"=>800, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 5.x (64 bit)", "id"=>4093, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_5_X_64_BIT_3", "softwareDescriptionId"=>1158, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Express Edition", "id"=>4150, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_EXPRESS", "softwareDescriptionId"=>1005, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1500", "description"=>"1500GB EVault Disk to Disk Enterprise Backup", "id"=>4185, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_1500_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>955}, {"capacity"=>"0", "description"=>"Windows Server 2012 Datacenter Edition (64bit)", "id"=>4237, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_DC_64_BIT", "softwareDescriptionId"=>1082, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 1 Pack", "id"=>4345, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_1_PACK", "softwareDescriptionId"=>1094, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 25 Pack", "id"=>4348, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_25_PACK", "softwareDescriptionId"=>1097, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable (64 bit)", "id"=>4405, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_64_BIT", "softwareDescriptionId"=>1104, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware vCenter 5.5 Standard", "id"=>4598, "itemTaxCategoryId"=>166, "keyName"=>"VMWARE_VCENTER_5_5_STANDARD", "softwareDescriptionId"=>1275, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr - Minimal Install (64 bit)", "id"=>4710, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_MINIMAL_64_BIT_2", "softwareDescriptionId"=>1346, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 12 - 30 Domain w/ Power Pack", "id"=>6010, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_12_30_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1414, "upgradeItemId"=>nil}, {"capacity"=>"8", "description"=>"8 Public IP Addresses", "id"=>17, "itemTaxCategoryId"=>166, "keyName"=>"8_PUBLIC_IP_ADDRESSES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"MySQL 5.0 for Windows", "id"=>23, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_0_WINDOWS", "softwareDescriptionId"=>13, "upgradeItemId"=>nil}, {"description"=>"Email and Ticket", "id"=>51, "itemTaxCategoryId"=>166, "keyName"=>"NOTIFICATION_EMAIL_AND_TICKET", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"NOC Monitoring", "id"=>54, "itemTaxCategoryId"=>166, "keyName"=>"NOC_MONITORING", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"cPanel/WHM with Fantastico and RVskin", "id"=>96, "itemTaxCategoryId"=>166, "keyName"=>"CPANELWHM_WITH_FANTASTICO_AND_RVSKIN", "softwareDescriptionId"=>31, "upgradeItemId"=>nil}, {"description"=>"Unlimited Bandwidth (100 Mbps Uplink)", "id"=>97, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_UNLIMITED_100_MBPS_UPLINK", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"RAID 1", "id"=>489, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_1", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"RAID 5", "id"=>490, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_5", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Reboot / KVM over IP", "id"=>504, "itemTaxCategoryId"=>166, "keyName"=>"REBOOT_KVM_OVER_IP", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1000 GB iSCSI SAN Storage", "id"=>554, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_1000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>783}, {"capacity"=>"150", "description"=>"Virtuozzo Containers 4 for Linux - 150 VPS", "id"=>746, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_150_VPS", "softwareDescriptionId"=>324, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"50", "description"=>"Virtuozzo Containers 4 for Linux - 50 VPS", "id"=>743, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_50_VPS", "softwareDescriptionId"=>321, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard Edition SP2 (32bit)", "id"=>933, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_32_BIT_SP2", "softwareDescriptionId"=>444, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Enterprise Edition SP2 (64bit)", "id"=>938, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_64_BIT_SP2", "softwareDescriptionId"=>449, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Datacenter Edition SP2 (64bit)", "id"=>940, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_SP2", "softwareDescriptionId"=>451, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Citrix XenServer 5.5", "id"=>950, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_5", "softwareDescriptionId"=>642, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Web Edition (64bit)", "id"=>976, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_64_BIT_R2_SP1", "softwareDescriptionId"=>832, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Standard SP2 with R2 (32 bit)", "id"=>421, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_STD_32_BIT_SP2_WR2", "softwareDescriptionId"=>125, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Web Edition SP2 (32bit)", "id"=>934, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_32_BIT_SP2", "softwareDescriptionId"=>445, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2.00 TB SATA II", "id"=>1091, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_2_00TB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"12", "description"=>"12 GB Registered DDR3 1333", "id"=>824, "itemTaxCategoryId"=>166, "keyName"=>"RAM_12_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"36", "description"=>"36 GB Registered DDR3 1333", "id"=>827, "itemTaxCategoryId"=>166, "keyName"=>"RAM_36_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Enterprise for XenServer 5.6", "id"=>1300, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ENTERPRISE_FOR_XENSERVER_5_6", "softwareDescriptionId"=>726, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin - Minimal Install (64 bit)", "id"=>4170, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_MINIMAL_64_BIT_2", "softwareDescriptionId"=>1184, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Windows) Unlimited Domain w/ Power Pack", "id"=>4200, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_WINDOWS_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1274, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.1", "id"=>4258, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_1", "softwareDescriptionId"=>1065, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware vCenter 5.1 Standard", "id"=>4298, "itemTaxCategoryId"=>166, "keyName"=>"VMWARE_VCENTER_5_1_STANDARD", "softwareDescriptionId"=>1090, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (4 TB)", "id"=>4372, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_4_TB", "softwareDescriptionId"=>1123, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"20", "description"=>"20Mbps Hardware Firewall", "id"=>4550, "itemTaxCategoryId"=>166, "keyName"=>"20MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.2.1", "id"=>4569, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_2_1", "softwareDescriptionId"=>1257, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MySQL 5.7 for Windows", "id"=>4592, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_7_WINDOWS", "softwareDescriptionId"=>1272, "upgradeItemId"=>nil}, {"capacity"=>"10000", "description"=>"10 Gbps Dual Private Network Uplinks (Unbonded)", "id"=>5102, "itemTaxCategoryId"=>166, "keyName"=>"10_GBPS_DUAL_PRIVATE_NETWORK_UPLINKS_UNBONDED", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Enterprise Edition", "id"=>5120, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_ENTERPRISE_EDITION_2", "softwareDescriptionId"=>1330, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Enterprise", "id"=>81, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_ENTERPRISE", "softwareDescriptionId"=>21, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Public & Private Network Uplinks", "id"=>187, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>188}, {"capacity"=>"1000", "description"=>"1000Mbps Hardware Firewall", "id"=>297, "itemTaxCategoryId"=>166, "keyName"=>"1000MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x (64 bit)", "id"=>420, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_64_BIT", "softwareDescriptionId"=>1240, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Enterprise SP2 with R2 (32 bit)", "id"=>423, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_ENT_32_BIT_SP2_WR2", "softwareDescriptionId"=>128, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 8.x (32 bit)", "id"=>1066, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_8_X_32_BIT", "softwareDescriptionId"=>1022, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"60", "description"=>"60GB EVault Disk to Disk Enterprise Backup", "id"=>1076, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_60_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>560}, {"capacity"=>"2", "description"=>"Monitoring Package - Advanced", "id"=>1249, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_ADVANCED", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"capacity"=>"10000", "description"=>"10 Gbps Public & Private Network Uplinks", "id"=>1281, "itemTaxCategoryId"=>166, "keyName"=>"10_GBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"50", "description"=>"50GB EVault Disk to Disk Enterprise Backup", "id"=>3784, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_50_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>1076}, {"description"=>"Parallels Plesk Panel 10 (Windows) 100 Domain w/ Power Pack", "id"=>3786, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_WINDOWS_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>787, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x (64 bit)", "id"=>3907, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_64_BIT", "softwareDescriptionId"=>1261, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Redundant Private Network Uplinks", "id"=>3956, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"3000", "description"=>"3.00 TB SATA III", "id"=>3989, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_3_00TB_SATA_III", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Enterprise for XenServer 6.x", "id"=>4105, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ENTERPRISE_FOR_XENSERVER_6_X", "softwareDescriptionId"=>909, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 1 Pack", "id"=>4153, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_1_PACK", "softwareDescriptionId"=>1015, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin (32 bit)", "id"=>4165, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_32_BIT", "softwareDescriptionId"=>1166, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Dual Public & Private Network Uplinks (Unbonded)", "id"=>4263, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_DUAL_PUBLIC_PRIVATE_NETWORK_UPLINKS_UNBONDED", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"4000", "description"=>"4.00 TB SATA III", "id"=>4281, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_4_00TB_SATA_III", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x (64 bit) (per-processor licensing)", "id"=>4321, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_64_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1247, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable - Minimal Install (32 bit)", "id"=>4406, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_MINIMAL_32_BIT", "softwareDescriptionId"=>1176, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable - Minimal Install (64 bit)", "id"=>4407, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_MINIMAL_64_BIT", "softwareDescriptionId"=>1177, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MySQL 5.0.51 for Windows", "id"=>4557, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_0_51_WINDOWS", "softwareDescriptionId"=>220, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESXi 5.5", "id"=>4562, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESXI_5_5", "softwareDescriptionId"=>1256, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 10.x (32 bit)", "id"=>4640, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_10_X_32_BIT", "softwareDescriptionId"=>1284, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 10.x (64 bit)", "id"=>4638, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_10_X_64_BIT", "softwareDescriptionId"=>1286, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr (64 bit)", "id"=>4702, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_64_BIT", "softwareDescriptionId"=>1362, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Express Edition", "id"=>5122, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_EXPRESS_EDITION", "softwareDescriptionId"=>1332, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 12 - Unlimited Domain w/ Power Pack", "id"=>6014, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_12_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1420, "upgradeItemId"=>nil}, {"capacity"=>"4", "description"=>"4 Public IP Addresses", "id"=>16, "itemTaxCategoryId"=>166, "keyName"=>"4_PUBLIC_IP_ADDRESSES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Unlimited Bandwidth (10 Mbps Uplink)", "id"=>30, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_UNLIMITED_10_MBPS_UPLINK", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB NAS", "id"=>43, "itemTaxCategoryId"=>166, "keyName"=>"NAS_100_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>44}, {"description"=>"Business Continuance Insurance", "id"=>84, "itemTaxCategoryId"=>108, "keyName"=>"BUSINESS_CONTINUANCE_INSURANCE", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100GB EVault Disk to Disk Enterprise Backup", "id"=>560, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_100_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4182}, {"capacity"=>"30", "description"=>"Virtuozzo Containers 4 for Linux - 30 VPS", "id"=>742, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_30_VPS", "softwareDescriptionId"=>320, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"64", "description"=>"/64 Block Static Public IPv6 Addresses", "id"=>784, "itemTaxCategoryId"=>166, "keyName"=>"64_BLOCK_STATIC_PUBLIC_IPV6_ADDRESSES", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESX 4.0", "id"=>1078, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESX_4_0", "softwareDescriptionId"=>497, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"48", "description"=>"48 GB Registered DDR3 1333", "id"=>828, "itemTaxCategoryId"=>166, "keyName"=>"RAM_48_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx (64 bit)", "id"=>1137, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_64_BIT", "softwareDescriptionId"=>775, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Enterprise R2", "id"=>1165, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_ENTERPRISE_R2", "softwareDescriptionId"=>699, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Datacenter R2", "id"=>1166, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_DATACENTER_R2", "softwareDescriptionId"=>700, "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Monitoring Package - Basic", "id"=>1248, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_BASIC", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2000Mbps Hardware Firewall", "id"=>1296, "itemTaxCategoryId"=>166, "keyName"=>"2000MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Advanced for XenServer 5.6", "id"=>1299, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ADVANCED_FOR_XENSERVER_5_6", "softwareDescriptionId"=>726, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"EVault Plugin - BMR (Bare Metal Restore)", "id"=>961, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_PLUGIN_BMR_BARE_METAL_RESTORE", "softwareDescriptionId"=>467, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 5.6.2", "id"=>3886, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6_2", "softwareDescriptionId"=>867, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Advanced for XenServer 6.x", "id"=>4104, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ADVANCED_FOR_XENSERVER_6_X", "softwareDescriptionId"=>908, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 9.x (64 bit)", "id"=>4138, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_9_X_64_BIT", "softwareDescriptionId"=>1265, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"400", "description"=>"400 GB SSD", "id"=>4181, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_400GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Cloudera Distribution for Hadoop 4", "id"=>4301, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_CLOUDERA_DISTRIBUTION_HADOOP_4", "softwareDescriptionId"=>1099, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x (32 bit) (per-processor licensing)", "id"=>4320, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_32_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1246, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Riak 1.x", "id"=>4327, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_RIAK_1_X", "softwareDescriptionId"=>1114, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Redundant Private Network Uplinks", "id"=>4331, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Redundant Public & Private Network Uplinks", "id"=>4336, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_REDUNDANT_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>1284}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (48 TB)", "id"=>4370, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_48_TB", "softwareDescriptionId"=>1154, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Standard Edition (64 bit)", "id"=>4549, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_STD_64_BIT", "softwareDescriptionId"=>1225, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Express", "id"=>24, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_EXPRESS", "softwareDescriptionId"=>9, "upgradeItemId"=>nil}, {"capacity"=>"40", "description"=>"40 GB NAS", "id"=>41, "itemTaxCategoryId"=>166, "keyName"=>"NAS_40_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>42}, {"description"=>"Host Ping", "id"=>49, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_HOST_PING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Automated Notification", "id"=>52, "itemTaxCategoryId"=>166, "keyName"=>"AUTOMATED_NOTIFICATION", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Automated Reboot from Monitoring", "id"=>53, "itemTaxCategoryId"=>166, "keyName"=>"AUTOMATED_REBOOT_FROM_MONITORING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"300", "description"=>"300 GB SA-SCSI 15K RPM", "id"=>352, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_300GB_SASCSI_15K_RPM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"500", "description"=>"500 GB iSCSI SAN Storage", "id"=>553, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_500_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>621}, {"capacity"=>"500", "description"=>"500GB EVault Disk to Disk Enterprise Backup", "id"=>562, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_500_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4184}, {"capacity"=>"120", "description"=>"120 GB iSCSI SAN Storage", "id"=>575, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_120_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>622}, {"capacity"=>"0", "description"=>"FreeBSD 7.x  (32 bit)", "id"=>638, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_7_X_32_BIT", "softwareDescriptionId"=>666, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Virtuozzo Containers 4 for Linux - 3 VPS", "id"=>738, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_3_VPS", "softwareDescriptionId"=>319, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"Virtuozzo Containers 4 for Linux - 100 VPS", "id"=>745, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_100_VPS", "softwareDescriptionId"=>323, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Web Edition SP2 (64bit)", "id"=>935, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_64_BIT_SP2", "softwareDescriptionId"=>446, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Cloudera Distribution for Hadoop 2", "id"=>1044, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_CLOUDERA_DISTRIBUTION_HADOOP_2", "softwareDescriptionId"=>520, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"144", "description"=>"144 GB Registered DDR3 1333", "id"=>1011, "itemTaxCategoryId"=>166, "keyName"=>"RAM_144_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"description"=>"Citrix XenServer 5.6", "id"=>1189, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6", "softwareDescriptionId"=>704, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft WebMatrix", "id"=>3898, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_WEBMATRIX_2", "softwareDescriptionId"=>868, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"International Services", "id"=>3955, "itemTaxCategoryId"=>166, "keyName"=>"INTERNATIONAL_SERVICES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 6.x (32 bit)", "id"=>4094, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_6_X_32_BIT_2", "softwareDescriptionId"=>1172, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 6.x (64 bit)", "id"=>4095, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_6_X_64_BIT", "softwareDescriptionId"=>1175, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"64", "description"=>"1 IPv6 Address", "id"=>4097, "itemTaxCategoryId"=>166, "keyName"=>"1_IPV6_ADDRESS", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Web Edition", "id"=>4147, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_WEB", "softwareDescriptionId"=>1004, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Enterprise Edition", "id"=>4149, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_ENTERPRISE", "softwareDescriptionId"=>1001, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MongoDB", "id"=>4226, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MONGODB", "softwareDescriptionId"=>1083, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 Datacenter Edition With Hyper-V (64bit)", "id"=>4247, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_DC_64_BIT_2", "softwareDescriptionId"=>1082, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x (32 bit) (per-processor licensing)", "id"=>4318, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_32_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1227, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Redundant Public & Private Network Uplinks", "id"=>4332, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_REDUNDANT_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>4336}, {"capacity"=>"0", "description"=>"Idera Server Backup 5.0 Enterprise (Windows)", "id"=>4344, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_SERVER_BACKUP_5_0_ENTERPRISE_WINDOWS", "softwareDescriptionId"=>1092, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 5 Pack", "id"=>4346, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_5_PACK", "softwareDescriptionId"=>1095, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"0 GB Bandwidth", "id"=>4481, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_0_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Datacenter Edition (64bit)", "id"=>4547, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_DC_64_BIT", "softwareDescriptionId"=>1226, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"200", "description"=>"200Mbps Hardware Firewall", "id"=>4551, "itemTaxCategoryId"=>166, "keyName"=>"200MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"cPanel/WHM with Softaculous and RVskin", "id"=>4608, "itemTaxCategoryId"=>166, "keyName"=>"CPANELWHM_WITH_SOFTACULOUS_AND_RVSKIN", "softwareDescriptionId"=>1292, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr - Minimal Install (32 bit)", "id"=>4708, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_MINIMAL_32_BIT_2", "softwareDescriptionId"=>1350, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 7.x (64 bit)", "id"=>5920, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_7_X_64_BIT", "softwareDescriptionId"=>1400, "units"=>"N/A", "upgradeItemId"=>nil}]
          fixture_package_items[46] = [{"capacity"=>"20", "description"=>"20 GB NAS", "id"=>40, "itemTaxCategoryId"=>166, "keyName"=>"NAS_20_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>41}, {"description"=>"Microsoft SQL Server 2005 Standard", "id"=>79, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_STANDARD", "softwareDescriptionId"=>8, "upgradeItemId"=>nil}, {"capacity"=>"6000", "description"=>"6000 GB Bandwidth", "id"=>100, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_6000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>249}, {"capacity"=>"10", "description"=>"10Mbps Hardware Firewall", "id"=>299, "itemTaxCategoryId"=>166, "keyName"=>"10MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"Unlimited SSL VPN Users & 1 PPTP VPN User per account", "id"=>309, "itemTaxCategoryId"=>166, "keyName"=>"UNLIMITED_SSL_VPN_USERS_1_PPTP_VPN_USER_PER_ACCOUNT", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"40", "description"=>"40GB EVault Disk to Disk Enterprise Backup", "id"=>559, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_40_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>3784}, {"capacity"=>"1000", "description"=>"1000GB EVault Disk to Disk Enterprise Backup", "id"=>563, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_1000_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4185}, {"description"=>"Microsoft SQL Server 2008 Web", "id"=>685, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WEB", "softwareDescriptionId"=>305, "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"1 x 2.0 GHz Core", "id"=>857, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_CORE_1", "softwareDescriptionId"=>nil, "units"=>"CORE", "upgradeItemId"=>nil}, {"capacity"=>"4", "description"=>"4 x 2.0 GHz Cores", "id"=>859, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_CORES_4", "softwareDescriptionId"=>nil, "units"=>"CORE", "upgradeItemId"=>nil}, {"capacity"=>"8", "description"=>"8 x 2.0 GHz Cores", "id"=>860, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_CORES_8", "softwareDescriptionId"=>nil, "units"=>"CORE", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"1 GB", "id"=>861, "itemTaxCategoryId"=>166, "keyName"=>"RAM_1_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"8", "description"=>"8 GB", "id"=>864, "itemTaxCategoryId"=>166, "keyName"=>"RAM_8_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Standard SP2 with R2 (64 bit)", "id"=>422, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_STD_64_BIT_SP2_WR2", "softwareDescriptionId"=>126, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Enterprise SP2 with R2 (64 bit)", "id"=>424, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_ENT_64_BIT_SP2_WR2", "softwareDescriptionId"=>127, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Datacenter SP2 with R2 (64 bit)", "id"=>921, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_DC_64_BIT_SP2_WR2", "softwareDescriptionId"=>402, "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2000GB EVault Disk to Disk Enterprise Backup", "id"=>955, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_2000_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Private 1 x 2.0 GHz Core", "id"=>1045, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_PRIVATE_CORE_1", "softwareDescriptionId"=>nil, "units"=>"PRIVATE_CORE", "upgradeItemId"=>nil}, {"capacity"=>"2", "description"=>"Private 2 x 2.0 GHz Cores", "id"=>1046, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_PRIVATE_CORES_2", "softwareDescriptionId"=>nil, "units"=>"PRIVATE_CORE", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx - Minimal Install (32 bit)", "id"=>1138, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_MINIMAL_32_BIT", "softwareDescriptionId"=>689, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Web R2", "id"=>1163, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WEB_R2", "softwareDescriptionId"=>696, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Express R2", "id"=>1162, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_EXPRESS_R2", "softwareDescriptionId"=>701, "upgradeItemId"=>nil}, {"capacity"=>"40", "description"=>"40 GB (SAN)", "id"=>1217, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_DISK_40_GB_SAN", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"75", "description"=>"75 GB (SAN)", "id"=>1219, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_DISK_75_GB_SAN", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB (SAN)", "id"=>922, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_DISK_100_GB_SAN_3", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 10 (Linux) 100 Domain w/ Power Pack", "id"=>1305, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_LINUX_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>938, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Enterprise Edition SP2 (32bit)", "id"=>937, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_32_BIT_SP2", "softwareDescriptionId"=>448, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x - LAMP Install (32 bit)", "id"=>3906, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_LAMP_32_BIT", "softwareDescriptionId"=>886, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 5.x (64 bit)", "id"=>4091, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_5_X_64_BIT", "softwareDescriptionId"=>964, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 10 Pack", "id"=>4155, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_10_PACK", "softwareDescriptionId"=>1011, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin - LAMP Install (64 bit)", "id"=>4172, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_LAMP_64_BIT", "softwareDescriptionId"=>1026, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"350", "description"=>"350GB EVault Disk to Disk Enterprise Backup", "id"=>4183, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_350_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>562}, {"capacity"=>"750", "description"=>"750GB EVault Disk to Disk Enterprise Backup", "id"=>4184, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_750_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>563}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Linux) 100 Domain w/ Power Pack", "id"=>4195, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_LINUX_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1191, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Windows) 100 Domain w/ Power Pack", "id"=>4199, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_WINDOWS_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1273, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"64", "description"=>"64 GB", "id"=>1154, "itemTaxCategoryId"=>166, "keyName"=>"RAM_64_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"description"=>"CentOS 7.x - LAMP Install (64 bit)", "id"=>5950, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_7_X_LAMP_64_BIT", "softwareDescriptionId"=>1450, "upgradeItemId"=>nil}, {"capacity"=>"80", "description"=>"80 GB NAS", "id"=>42, "itemTaxCategoryId"=>166, "keyName"=>"NAS_80_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>43}, {"capacity"=>"250", "description"=>"250 GB NAS", "id"=>44, "itemTaxCategoryId"=>166, "keyName"=>"NAS_250_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>411}, {"capacity"=>"1000", "description"=>"1 Gbps Public & Private Network Uplinks", "id"=>188, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"APF Software Firewall for Linux", "id"=>300, "itemTaxCategoryId"=>166, "keyName"=>"APF_SOFTWARE_FIREWALL_FOR_LINUX", "softwareDescriptionId"=>71, "upgradeItemId"=>nil}, {"description"=>"Nessus Vulnerability Assessment & Reporting", "id"=>307, "itemTaxCategoryId"=>98, "keyName"=>"NESSUS_VULNERABILITY_ASSESSMENT_REPORTING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"McAfee VirusScan Enterprise", "id"=>397, "itemTaxCategoryId"=>98, "keyName"=>"MCAFEE_VIRUSSCAN_ANTIVIRUS_WINDOWS", "softwareDescriptionId"=>820, "upgradeItemId"=>nil}, {"description"=>"Microsoft Windows Firewall", "id"=>495, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_WINDOWS_FIREWALL", "softwareDescriptionId"=>106, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Private Network Uplink", "id"=>498, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"250", "description"=>"250GB EVault Disk to Disk Enterprise Backup", "id"=>561, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_250_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4183}, {"description"=>"Microsoft SQL Server 2008 Express", "id"=>681, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_EXPRESS", "softwareDescriptionId"=>308, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Enterprise", "id"=>682, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_ENTERPRISE", "softwareDescriptionId"=>307, "upgradeItemId"=>nil}, {"capacity"=>"30", "description"=>"30GB EVault Disk to Disk Enterprise Backup", "id"=>739, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_30_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>559}, {"capacity"=>"0", "description"=>"CentOS 5.x - Minimal Install (64 bit)", "id"=>876, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_MINIMAL_64_BIT", "softwareDescriptionId"=>856, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Account Setup Fee", "id"=>947, "itemTaxCategoryId"=>4, "keyName"=>"ACCOUNT_SETUP_FEE", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Standard R2", "id"=>1161, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_STANDARD_R2", "softwareDescriptionId"=>698, "upgradeItemId"=>nil}, {"capacity"=>"16", "description"=>"16 x 2.0 GHz Cores", "id"=>1194, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_CORES_16", "softwareDescriptionId"=>nil, "units"=>"CORE", "upgradeItemId"=>nil}, {"capacity"=>"12", "description"=>"12 GB", "id"=>1209, "itemTaxCategoryId"=>166, "keyName"=>"RAM_12_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"30", "description"=>"30 GB (SAN)", "id"=>1216, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_DISK_30_GB_SAN", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"125", "description"=>"125 GB (SAN)", "id"=>1220, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_DISK_125_GB_SAN", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"175", "description"=>"175 GB (SAN)", "id"=>1222, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_DISK_175_GB_SAN", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"500", "description"=>"500 GB (SAN)", "id"=>916, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_DISK_500_GB_SAN", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"3", "description"=>"Monitoring Package - Premium Application", "id"=>1250, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_PREMIUM_APPLICATION", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 10 (Windows) Unlimited Domain w/ Power Pack", "id"=>3785, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_WINDOWS_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>788, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Standard Edition", "id"=>4148, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_STANDARD", "softwareDescriptionId"=>1003, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 5 Pack", "id"=>4154, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_5_PACK", "softwareDescriptionId"=>1012, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin - Minimal Install (64 bit)", "id"=>4174, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_MINIMAL_64_BIT", "softwareDescriptionId"=>1025, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 Standard Edition (64 bit)", "id"=>4233, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_STD_64_BIT", "softwareDescriptionId"=>1076, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Server Backup 5.0 Enterprise (Linux)", "id"=>4343, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_SERVER_BACKUP_5_0_ENTERPRISE_LINUX", "softwareDescriptionId"=>1093, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 10 Pack", "id"=>4347, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_10_PACK", "softwareDescriptionId"=>1096, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable - Minimal Install (64 bit)", "id"=>4411, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_MINIMAL_64_BIT_2", "softwareDescriptionId"=>1163, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"CentOS 7.x - Minimal Install (64 bit)", "id"=>5952, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_7_X_MINIMAL_64_BIT", "softwareDescriptionId"=>1448, "upgradeItemId"=>nil}, {"description"=>"Host Ping and TCP Service Monitoring", "id"=>50, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_HOST_PING_AND_TCP_SERVICE", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"8000", "description"=>"8000 GB Bandwidth", "id"=>101, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_8000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>249}, {"capacity"=>"5000", "description"=>"5000 GB Bandwidth", "id"=>173, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_5000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>249}, {"capacity"=>"10", "description"=>"10 Mbps Public & Private Network Uplinks", "id"=>186, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>187}, {"description"=>"McAfee Host Intrusion Protection w/Reporting", "id"=>302, "itemTaxCategoryId"=>98, "keyName"=>"MCAFEE_HOST_INTRUSION_PROTECTION_WREPORTING", "softwareDescriptionId"=>916, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Private Network Uplink", "id"=>497, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>498}, {"description"=>"Microsoft SQL Server 2008 Standard", "id"=>683, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_STANDARD", "softwareDescriptionId"=>306, "upgradeItemId"=>nil}, {"capacity"=>"2", "description"=>"2 GB", "id"=>862, "itemTaxCategoryId"=>166, "keyName"=>"RAM_2_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Datacenter SP2 with R2 (32 bit)", "id"=>920, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_DC_32_BIT_SP2_WR2", "softwareDescriptionId"=>401, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"0 GB Bandwidth", "id"=>439, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_0_GB_2", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Standard Edition (64bit)", "id"=>977, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_R2", "softwareDescriptionId"=>475, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"50", "description"=>"50 GB (SAN)", "id"=>1218, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_DISK_50_GB_SAN", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"300", "description"=>"300 GB (SAN)", "id"=>1225, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_DISK_300_GB_SAN", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x - Minimal Install (32 bit)", "id"=>3837, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_MINIMAL_32_BIT_2", "softwareDescriptionId"=>796, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Datacenter Edition (64bit)", "id"=>979, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_R2", "softwareDescriptionId"=>478, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 5.x (32 bit)", "id"=>4090, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_5_X_32_BIT_3", "softwareDescriptionId"=>965, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 6.x (64 bit)", "id"=>4089, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_6_X_64_BIT_2", "softwareDescriptionId"=>963, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 25 Pack", "id"=>4156, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_25_PACK", "softwareDescriptionId"=>1016, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin - Minimal Install (32 bit)", "id"=>4173, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_MINIMAL_32_BIT_2", "softwareDescriptionId"=>1023, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"175", "description"=>"175GB EVault Disk to Disk Enterprise Backup", "id"=>4182, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_175_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>561}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Linux) Unlimited Domain w/ Power Pack", "id"=>4197, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_LINUX_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1197, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable - Minimal Install (32 bit)", "id"=>4410, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_MINIMAL_32_BIT_2", "softwareDescriptionId"=>1161, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr - LAMP Install (64 bit)", "id"=>4664, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_LAMP_64_BIT", "softwareDescriptionId"=>1344, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr - Minimal Install (32 bit)", "id"=>4666, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_MINIMAL_32_BIT", "softwareDescriptionId"=>1338, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Standard Edition", "id"=>5124, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_STANDARD_EDITION", "softwareDescriptionId"=>1334, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"1 IP Address", "id"=>15, "itemTaxCategoryId"=>166, "keyName"=>"1_IP_ADDRESS", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"MySQL for Linux", "id"=>22, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_LINUX", "softwareDescriptionId"=>156, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Workgroup", "id"=>80, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_WORKGROUP", "softwareDescriptionId"=>20, "upgradeItemId"=>nil}, {"capacity"=>"10000", "description"=>"10000 GB Bandwidth", "id"=>102, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_10000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>249}, {"capacity"=>"100", "description"=>"100Mbps Hardware Firewall", "id"=>298, "itemTaxCategoryId"=>166, "keyName"=>"100MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Private Network Uplink", "id"=>496, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>497}, {"capacity"=>"20", "description"=>"20GB EVault Disk to Disk Enterprise Backup", "id"=>558, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_20_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>739}, {"capacity"=>"500", "description"=>"500 GB NAS", "id"=>611, "itemTaxCategoryId"=>166, "keyName"=>"NAS_500_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>605}, {"description"=>"Microsoft SQL Server 2008 Workgroup", "id"=>684, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WORKGROUP", "softwareDescriptionId"=>304, "upgradeItemId"=>nil}, {"capacity"=>"4", "description"=>"4 GB", "id"=>863, "itemTaxCategoryId"=>166, "keyName"=>"RAM_4_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x - LAMP Install (32 bit)", "id"=>877, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_LAMP_32_BIT", "softwareDescriptionId"=>857, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x - Minimal Install (64 bit)", "id"=>880, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_MINIMAL_64_BIT", "softwareDescriptionId"=>664, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard Edition SP2 (64bit)", "id"=>936, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_SP2", "softwareDescriptionId"=>447, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Enterprise Edition (64bit)", "id"=>978, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_64_BIT_R2_2", "softwareDescriptionId"=>477, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Workgroup R2", "id"=>1164, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WORKGROUP_R2", "softwareDescriptionId"=>697, "upgradeItemId"=>nil}, {"capacity"=>"350", "description"=>"350 GB (SAN)", "id"=>1226, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_DISK_350_GB_SAN", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"1500", "description"=>"1.50 TB (SAN)", "id"=>1231, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_DISK_1500_GB_SAN", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 10 (Linux) Unlimited Domain w/ Power Pack", "id"=>1306, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_LINUX_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>939, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x - LAMP Install (64 bit)", "id"=>3835, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_LAMP_64_BIT_2", "softwareDescriptionId"=>798, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x - Minimal Install (64 bit)", "id"=>3839, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_MINIMAL_64_BIT", "softwareDescriptionId"=>795, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB (LOCAL)", "id"=>3876, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_DISK_100_GB_LOCAL", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"25", "description"=>"25 GB (LOCAL)", "id"=>3891, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_DISK_25_GB_LOCAL", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB (LOCAL)", "id"=>3899, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_DISK_100_GB_LOCAL_3", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Express Edition", "id"=>4150, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_EXPRESS", "softwareDescriptionId"=>1005, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1500", "description"=>"1500GB EVault Disk to Disk Enterprise Backup", "id"=>4185, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_1500_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>955}, {"capacity"=>"0", "description"=>"Windows Server 2012 Datacenter Edition (64bit)", "id"=>4237, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_DC_64_BIT", "softwareDescriptionId"=>1082, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard SP1 with R2 (64 bit)", "id"=>4248, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_R2_SP1", "softwareDescriptionId"=>831, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 1 Pack", "id"=>4345, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_1_PACK", "softwareDescriptionId"=>1094, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 25 Pack", "id"=>4348, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_25_PACK", "softwareDescriptionId"=>1097, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware vCenter 5.5 Standard", "id"=>4598, "itemTaxCategoryId"=>166, "keyName"=>"VMWARE_VCENTER_5_5_STANDARD", "softwareDescriptionId"=>1275, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr - LAMP Install (32 bit)", "id"=>4662, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_LAMP_32_BIT", "softwareDescriptionId"=>1340, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 12 - 30 Domain w/ Power Pack", "id"=>6010, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_12_30_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1414, "upgradeItemId"=>nil}, {"capacity"=>"8", "description"=>"8 Public IP Addresses", "id"=>17, "itemTaxCategoryId"=>166, "keyName"=>"8_PUBLIC_IP_ADDRESSES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"MySQL 5.0 for Windows", "id"=>23, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_0_WINDOWS", "softwareDescriptionId"=>13, "upgradeItemId"=>nil}, {"description"=>"Email and Ticket", "id"=>51, "itemTaxCategoryId"=>166, "keyName"=>"NOTIFICATION_EMAIL_AND_TICKET", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"NOC Monitoring", "id"=>54, "itemTaxCategoryId"=>166, "keyName"=>"NOC_MONITORING", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Unlimited Bandwidth (100 Mbps Uplink)", "id"=>97, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_UNLIMITED_100_MBPS_UPLINK", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Reboot / Remote Console", "id"=>503, "itemTaxCategoryId"=>166, "keyName"=>"REBOOT_REMOTE_CONSOLE", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Standard SP2 with R2 (32 bit)", "id"=>421, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_STD_32_BIT_SP2_WR2", "softwareDescriptionId"=>125, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"cPanel/WHM with Fantastico and RVskin", "id"=>928, "itemTaxCategoryId"=>166, "keyName"=>"CPANELWHM_WITH_FANTASTICO_AND_RVSKIN_2", "softwareDescriptionId"=>46, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard Edition SP2 (32bit)", "id"=>933, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_32_BIT_SP2", "softwareDescriptionId"=>444, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx - LAMP Install (32 bit)", "id"=>1144, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_LAMP_32_BIT_2", "softwareDescriptionId"=>688, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"20", "description"=>"20 GB (SAN)", "id"=>1214, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_DISK_20_GB_SAN", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"750", "description"=>"750 GB (SAN)", "id"=>1229, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_DISK_750_GB_SAN_2", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1.00 TB (SAN)", "id"=>1230, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_DISK_1000_GB_SAN_2", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Enterprise Edition SP2 (64bit)", "id"=>938, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_64_BIT_SP2", "softwareDescriptionId"=>449, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Datacenter Edition SP2 (64bit)", "id"=>940, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_SP2", "softwareDescriptionId"=>451, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x - LAMP Install (64 bit)", "id"=>3909, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_LAMP_64_BIT_2", "softwareDescriptionId"=>888, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"150", "description"=>"150 GB (LOCAL)", "id"=>3953, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_DISK_150_GB_LOCAL", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Windows) Unlimited Domain w/ Power Pack", "id"=>4200, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_WINDOWS_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1274, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware vCenter 5.1 Standard", "id"=>4298, "itemTaxCategoryId"=>166, "keyName"=>"VMWARE_VCENTER_5_1_STANDARD", "softwareDescriptionId"=>1090, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Storage Backend Upgrade", "id"=>4390, "itemTaxCategoryId"=>166, "keyName"=>"STORAGE_BACKEND_UPGRADE", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable - LAMP Install (32 bit)", "id"=>4408, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_LAMP_32_BIT", "softwareDescriptionId"=>1162, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"20", "description"=>"20Mbps Hardware Firewall", "id"=>4550, "itemTaxCategoryId"=>166, "keyName"=>"20MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MySQL 5.7 for Windows", "id"=>4592, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_7_WINDOWS", "softwareDescriptionId"=>1272, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Enterprise Edition", "id"=>5120, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_ENTERPRISE_EDITION_2", "softwareDescriptionId"=>1330, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Enterprise", "id"=>81, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_ENTERPRISE", "softwareDescriptionId"=>21, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Public & Private Network Uplinks", "id"=>187, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>188}, {"capacity"=>"1000", "description"=>"1000Mbps Hardware Firewall", "id"=>297, "itemTaxCategoryId"=>166, "keyName"=>"1000MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x - LAMP Install (32 bit)", "id"=>881, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_LAMP_32_BIT_2", "softwareDescriptionId"=>663, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x - LAMP Install (64 bit)", "id"=>882, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_LAMP_64_BIT_2", "softwareDescriptionId"=>665, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Enterprise SP2 with R2 (32 bit)", "id"=>423, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_ENT_32_BIT_SP2_WR2", "softwareDescriptionId"=>128, "upgradeItemId"=>nil}, {"capacity"=>"4", "description"=>"Private 4 x 2.0 GHz Cores", "id"=>1047, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_PRIVATE_CORES_4", "softwareDescriptionId"=>nil, "units"=>"PRIVATE_CORE", "upgradeItemId"=>nil}, {"capacity"=>"60", "description"=>"60GB EVault Disk to Disk Enterprise Backup", "id"=>1076, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_60_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>560}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx - Minimal Install (64 bit)", "id"=>1140, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_MINIMAL_64_BIT_2", "softwareDescriptionId"=>690, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 GB (SAN)", "id"=>1213, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_DISK_10_GB_SAN", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"150", "description"=>"150 GB (SAN)", "id"=>1221, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_DISK_150_GB_SAN", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"400", "description"=>"400 GB (SAN)", "id"=>1227, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_DISK_400_GB_SAN", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"2", "description"=>"Monitoring Package - Advanced", "id"=>1249, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_ADVANCED", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"capacity"=>"50", "description"=>"50GB EVault Disk to Disk Enterprise Backup", "id"=>3784, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_50_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>1076}, {"capacity"=>"200", "description"=>"200 GB (LOCAL)", "id"=>3889, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_DISK_200_GB_LOCAL", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 6.x Squeeze/Stable - LAMP Install (64 bit)", "id"=>3975, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_6_X_SQUEEZE_LAMP_64_BIT", "softwareDescriptionId"=>881, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 6.x Squeeze/Stable - Minimal Install (64 bit)", "id"=>3976, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_6_X_SQUEEZE_MINIMAL_64_BIT", "softwareDescriptionId"=>819, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"RightLink", "id"=>4060, "itemTaxCategoryId"=>166, "keyName"=>"RIGHTLINK", "softwareDescriptionId"=>917, "upgradeItemId"=>nil}, {"capacity"=>"25", "description"=>"25 GB (SAN)", "id"=>4386, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_DISK_25_GB_SAN_4", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MySQL 5.0.51 for Windows", "id"=>4557, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_0_51_WINDOWS", "softwareDescriptionId"=>220, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"cPanel/WHM with Softaculous and RVskin ", "id"=>4610, "itemTaxCategoryId"=>166, "keyName"=>"CPANELWHM_WITH_SOFTACULOUS_AND_RVSKIN_2", "softwareDescriptionId"=>1294, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Express Edition", "id"=>5122, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_EXPRESS_EDITION", "softwareDescriptionId"=>1332, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 12 - Unlimited Domain w/ Power Pack", "id"=>6014, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_12_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1420, "upgradeItemId"=>nil}, {"capacity"=>"4", "description"=>"4 Public IP Addresses", "id"=>16, "itemTaxCategoryId"=>166, "keyName"=>"4_PUBLIC_IP_ADDRESSES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Unlimited Bandwidth (10 Mbps Uplink)", "id"=>30, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_UNLIMITED_10_MBPS_UPLINK", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB NAS", "id"=>43, "itemTaxCategoryId"=>166, "keyName"=>"NAS_100_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>44}, {"description"=>"Business Continuance Insurance", "id"=>84, "itemTaxCategoryId"=>108, "keyName"=>"BUSINESS_CONTINUANCE_INSURANCE", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100GB EVault Disk to Disk Enterprise Backup", "id"=>560, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_100_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4182}, {"capacity"=>"64", "description"=>"/64 Block Static Public IPv6 Addresses", "id"=>784, "itemTaxCategoryId"=>166, "keyName"=>"64_BLOCK_STATIC_PUBLIC_IPV6_ADDRESSES", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB (SAN)", "id"=>865, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_DISK_100_GB_SAN", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x - LAMP Install (64 bit)", "id"=>878, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_LAMP_64_BIT", "softwareDescriptionId"=>858, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x - Minimal Install (32 bit)", "id"=>879, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_MINIMAL_32_BIT", "softwareDescriptionId"=>662, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"16", "description"=>"16 GB", "id"=>1017, "itemTaxCategoryId"=>166, "keyName"=>"RAM_16_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"8", "description"=>"Private 8 x 2.0 GHz Cores", "id"=>1048, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_PRIVATE_CORES_8", "softwareDescriptionId"=>nil, "units"=>"PRIVATE_CORE", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Enterprise R2", "id"=>1165, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_ENTERPRISE_R2", "softwareDescriptionId"=>699, "upgradeItemId"=>nil}, {"capacity"=>"12", "description"=>"12 x 2.0 GHz Cores", "id"=>1198, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_CORES_12", "softwareDescriptionId"=>nil, "units"=>"CORE", "upgradeItemId"=>nil}, {"capacity"=>"6", "description"=>"6 GB", "id"=>1204, "itemTaxCategoryId"=>166, "keyName"=>"RAM_6_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"250", "description"=>"250 GB (SAN)", "id"=>866, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_DISK_250_GB_SAN", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2.00 TB (SAN)", "id"=>1232, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_DISK_2000_GB_SAN", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Monitoring Package - Basic", "id"=>1248, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_BASIC", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x - Minimal Install (64 bit)", "id"=>3908, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_MINIMAL_64_BIT_2", "softwareDescriptionId"=>887, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 6.x Squeeze/Stable - LAMP Install (32 bit)", "id"=>3973, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_6_X_SQUEEZE_LAMP_32_BIT_2", "softwareDescriptionId"=>880, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 6.x (32 bit)", "id"=>4088, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_6_X_32_BIT", "softwareDescriptionId"=>962, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin - LAMP Install (32 bit)", "id"=>4171, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_LAMP_32_BIT_2", "softwareDescriptionId"=>1024, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Riak 1.x", "id"=>4327, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_RIAK_1_X", "softwareDescriptionId"=>1114, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable - LAMP Install (64 bit)", "id"=>4409, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_LAMP_64_BIT", "softwareDescriptionId"=>1164, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Express", "id"=>24, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_EXPRESS", "softwareDescriptionId"=>9, "upgradeItemId"=>nil}, {"capacity"=>"40", "description"=>"40 GB NAS", "id"=>41, "itemTaxCategoryId"=>166, "keyName"=>"NAS_40_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>42}, {"description"=>"Host Ping", "id"=>49, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_HOST_PING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Automated Notification", "id"=>52, "itemTaxCategoryId"=>166, "keyName"=>"AUTOMATED_NOTIFICATION", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Automated Reboot from Monitoring", "id"=>53, "itemTaxCategoryId"=>166, "keyName"=>"AUTOMATED_REBOOT_FROM_MONITORING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"500", "description"=>"500GB EVault Disk to Disk Enterprise Backup", "id"=>562, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_500_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4184}, {"capacity"=>"2", "description"=>"2 x 2.0 GHz Cores", "id"=>858, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_CORES_2", "softwareDescriptionId"=>nil, "units"=>"CORE", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x - Minimal Install (32 bit)", "id"=>875, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_MINIMAL_32_BIT", "softwareDescriptionId"=>855, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx - LAMP Install (64 bit)", "id"=>1145, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_LAMP_64_BIT", "softwareDescriptionId"=>691, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"25", "description"=>"25 GB (SAN)", "id"=>1178, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_DISK_25_GB_SAN", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"200", "description"=>"200 GB (SAN)", "id"=>1223, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_DISK_200_GB_SAN", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x - LAMP Install (32 bit)", "id"=>3833, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_LAMP_32_BIT", "softwareDescriptionId"=>797, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"300", "description"=>"300 GB (LOCAL)", "id"=>3890, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_DISK_300_GB_LOCAL", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft WebMatrix", "id"=>3898, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_WEBMATRIX_2", "softwareDescriptionId"=>868, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x - Minimal Install (32 bit)", "id"=>3905, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_MINIMAL_32_BIT", "softwareDescriptionId"=>885, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"International Services", "id"=>3955, "itemTaxCategoryId"=>166, "keyName"=>"INTERNATIONAL_SERVICES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 6.x Squeeze/Stable - Minimal Install (32 bit)", "id"=>3974, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_6_X_SQUEEZE_MINIMAL_32_BIT", "softwareDescriptionId"=>818, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"64", "description"=>"1 IPv6 Address", "id"=>4097, "itemTaxCategoryId"=>166, "keyName"=>"1_IPV6_ADDRESS", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Web Edition", "id"=>4147, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_WEB", "softwareDescriptionId"=>1004, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Enterprise Edition", "id"=>4149, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_ENTERPRISE", "softwareDescriptionId"=>1001, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MongoDB", "id"=>4226, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MONGODB", "softwareDescriptionId"=>1083, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Vyatta 6.5 Community Edition (64 bit)", "id"=>4288, "itemTaxCategoryId"=>166, "keyName"=>"OS_VYATTA_6_5_COMMUNITY_EDITION_64_BIT_2", "softwareDescriptionId"=>1098, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"32", "description"=>"32 GB", "id"=>1155, "itemTaxCategoryId"=>166, "keyName"=>"RAM_32_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Server Backup 5.0 Enterprise (Windows)", "id"=>4344, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_SERVER_BACKUP_5_0_ENTERPRISE_WINDOWS", "softwareDescriptionId"=>1092, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 5 Pack", "id"=>4346, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_5_PACK", "softwareDescriptionId"=>1095, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"25", "description"=>"25 GB (LOCAL)", "id"=>4385, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_DISK_25_GB_LOCAL_3", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"48", "description"=>"48 GB", "id"=>4468, "itemTaxCategoryId"=>166, "keyName"=>"RAM_48_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"0 GB Bandwidth", "id"=>4481, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_0_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Vyatta 6.6 Community Edition (64 bit)", "id"=>4496, "itemTaxCategoryId"=>166, "keyName"=>"OS_VYATTA_6_6_COMMUNITY_EDITION_64_BIT_2", "softwareDescriptionId"=>1200, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"200", "description"=>"200Mbps Hardware Firewall", "id"=>4551, "itemTaxCategoryId"=>166, "keyName"=>"200MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr - Minimal Install (64 bit)", "id"=>4668, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_MINIMAL_64_BIT", "softwareDescriptionId"=>1342, "units"=>"N/A", "upgradeItemId"=>nil}]
          fixture_package_items[49] = [{"capacity"=>"20", "description"=>"20 GB NAS", "id"=>40, "itemTaxCategoryId"=>166, "keyName"=>"NAS_20_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>41}, {"description"=>"Microsoft SQL Server 2005 Standard", "id"=>79, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_STANDARD", "softwareDescriptionId"=>8, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10Mbps Hardware Firewall", "id"=>299, "itemTaxCategoryId"=>166, "keyName"=>"10MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"Unlimited SSL VPN Users & 1 PPTP VPN User per account", "id"=>309, "itemTaxCategoryId"=>166, "keyName"=>"UNLIMITED_SSL_VPN_USERS_1_PPTP_VPN_USER_PER_ACCOUNT", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Standard SP2 with R2 (64 bit)", "id"=>422, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_STD_64_BIT_SP2_WR2", "softwareDescriptionId"=>126, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Enterprise SP2 with R2 (64 bit)", "id"=>424, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_ENT_64_BIT_SP2_WR2", "softwareDescriptionId"=>127, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB iSCSI SAN Storage", "id"=>551, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_100_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>575}, {"capacity"=>"40", "description"=>"40GB EVault Disk to Disk Enterprise Backup", "id"=>559, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_40_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>3784}, {"capacity"=>"1000", "description"=>"1000GB EVault Disk to Disk Enterprise Backup", "id"=>563, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_1000_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4185}, {"capacity"=>"0", "description"=>"FreeBSD 7.x  (64 bit)", "id"=>637, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_7_X_64_BIT", "softwareDescriptionId"=>667, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Web", "id"=>685, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WEB", "softwareDescriptionId"=>305, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Enterprise Edition SP2 (32bit)", "id"=>937, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_32_BIT_SP2", "softwareDescriptionId"=>448, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2000GB EVault Disk to Disk Enterprise Backup", "id"=>955, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_2000_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>nil}, {"capacity"=>"192", "description"=>"192 GB Registered DDR3 1066", "id"=>1147, "itemTaxCategoryId"=>166, "keyName"=>"RAM_192_GB_DDR3_1066_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Web R2", "id"=>1163, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WEB_R2", "softwareDescriptionId"=>696, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Express R2", "id"=>1162, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_EXPRESS_R2", "softwareDescriptionId"=>701, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 10 (Linux) 100 Domain w/ Power Pack", "id"=>1305, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_LINUX_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>938, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"200", "description"=>"200 GB SSD", "id"=>3811, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_200GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 6.x Squeeze/Stable (64 bit)", "id"=>3968, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_6_X_SQUEEZE_64_BIT", "softwareDescriptionId"=>919, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.0.0", "id"=>3977, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_0_0", "softwareDescriptionId"=>836, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 5.x (32 bit)", "id"=>4092, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_5_X_32_BIT_2", "softwareDescriptionId"=>1156, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.0.2", "id"=>4133, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_0_2", "softwareDescriptionId"=>961, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 10 Pack", "id"=>4155, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_10_PACK", "softwareDescriptionId"=>1011, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin - Minimal Install (32 bit)", "id"=>4169, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_MINIMAL_32_BIT", "softwareDescriptionId"=>1186, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"350", "description"=>"350GB EVault Disk to Disk Enterprise Backup", "id"=>4183, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_350_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>562}, {"capacity"=>"750", "description"=>"750GB EVault Disk to Disk Enterprise Backup", "id"=>4184, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_750_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>563}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Linux) 100 Domain w/ Power Pack", "id"=>4195, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_LINUX_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1191, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Windows) 100 Domain w/ Power Pack", "id"=>4199, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_WINDOWS_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1273, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 1 VM", "id"=>4303, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_1_VM", "softwareDescriptionId"=>1105, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - Unlimited VMs", "id"=>4307, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_UNLIMITED_VMS", "softwareDescriptionId"=>1112, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Redundant Private Network Uplinks", "id"=>4335, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.2", "id"=>4467, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_2", "softwareDescriptionId"=>1171, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Dual Public & Private Network Uplinks (Unbonded)", "id"=>5118, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_DUAL_PUBLIC_PRIVATE_NETWORK_UPLINKS_UNBONDED", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"80", "description"=>"80 GB NAS", "id"=>42, "itemTaxCategoryId"=>166, "keyName"=>"NAS_80_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>43}, {"capacity"=>"250", "description"=>"250 GB NAS", "id"=>44, "itemTaxCategoryId"=>166, "keyName"=>"NAS_250_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>411}, {"capacity"=>"1000", "description"=>"1 Gbps Public & Private Network Uplinks", "id"=>188, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"APF Software Firewall for Linux", "id"=>300, "itemTaxCategoryId"=>166, "keyName"=>"APF_SOFTWARE_FIREWALL_FOR_LINUX", "softwareDescriptionId"=>71, "upgradeItemId"=>nil}, {"description"=>"Nessus Vulnerability Assessment & Reporting", "id"=>307, "itemTaxCategoryId"=>98, "keyName"=>"NESSUS_VULNERABILITY_ASSESSMENT_REPORTING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"McAfee VirusScan Enterprise", "id"=>397, "itemTaxCategoryId"=>98, "keyName"=>"MCAFEE_VIRUSSCAN_ANTIVIRUS_WINDOWS", "softwareDescriptionId"=>820, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x (32 bit)", "id"=>419, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_32_BIT", "softwareDescriptionId"=>1239, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Non-RAID", "id"=>487, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_NONRAID", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Microsoft Windows Firewall", "id"=>495, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_WINDOWS_FIREWALL", "softwareDescriptionId"=>106, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Private Network Uplink", "id"=>498, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"80", "description"=>"80 GB iSCSI SAN Storage", "id"=>550, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_80_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>551}, {"capacity"=>"250", "description"=>"250GB EVault Disk to Disk Enterprise Backup", "id"=>561, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_250_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4183}, {"description"=>"Microsoft SQL Server 2008 Express", "id"=>681, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_EXPRESS", "softwareDescriptionId"=>308, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Enterprise", "id"=>682, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_ENTERPRISE", "softwareDescriptionId"=>307, "upgradeItemId"=>nil}, {"capacity"=>"30", "description"=>"30GB EVault Disk to Disk Enterprise Backup", "id"=>739, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_30_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>559}, {"capacity"=>"10", "description"=>"Virtuozzo Containers 4 for Linux - 10 VPS", "id"=>741, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_10_VPS", "softwareDescriptionId"=>318, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Datacenter Edition SP2 (32bit)", "id"=>939, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_32_BIT_SP2", "softwareDescriptionId"=>450, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Standard R2", "id"=>1161, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_STANDARD_R2", "softwareDescriptionId"=>698, "upgradeItemId"=>nil}, {"capacity"=>"3000", "description"=>"3000 GB iSCSI SAN Storage", "id"=>1176, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_3000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"3", "description"=>"Monitoring Package - Premium Application", "id"=>1250, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_PREMIUM_APPLICATION", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"capacity"=>"128", "description"=>"128 GB Registered DDR3 1333", "id"=>1307, "itemTaxCategoryId"=>166, "keyName"=>"RAM_128_GB_DDR3_1333_REG_2", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 10 (Windows) Unlimited Domain w/ Power Pack", "id"=>3785, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_WINDOWS_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>788, "upgradeItemId"=>nil}, {"capacity"=>"10000", "description"=>"10 Gbps Private Network Uplink", "id"=>3957, "itemTaxCategoryId"=>166, "keyName"=>"10_GBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Standard Edition", "id"=>4148, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_STANDARD", "softwareDescriptionId"=>1003, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 5 Pack", "id"=>4154, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_5_PACK", "softwareDescriptionId"=>1012, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 Standard Edition (64 bit)", "id"=>4233, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_STD_64_BIT", "softwareDescriptionId"=>1076, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESXi 5.1", "id"=>4272, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESXI_5_1", "softwareDescriptionId"=>1086, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 5 VMs", "id"=>4304, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_5_VMS", "softwareDescriptionId"=>1109, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 10 VMs", "id"=>4305, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_10_VMS", "softwareDescriptionId"=>1110, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"15", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 15 VMs", "id"=>4306, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_15_VMS", "softwareDescriptionId"=>1111, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x (64 bit) (per-processor licensing)", "id"=>4319, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_64_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1228, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Server Backup 5.0 Enterprise (Linux)", "id"=>4343, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_SERVER_BACKUP_5_0_ENTERPRISE_LINUX", "softwareDescriptionId"=>1093, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 10 Pack", "id"=>4347, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_10_PACK", "softwareDescriptionId"=>1096, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable (32 bit)", "id"=>4404, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_32_BIT", "softwareDescriptionId"=>1169, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"RAID", "id"=>4478, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Datacenter Edition With Hyper-V (64bit)", "id"=>4548, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_DC_64_BIT_2", "softwareDescriptionId"=>1226, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Host Ping and TCP Service Monitoring", "id"=>50, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_HOST_PING_AND_TCP_SERVICE", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Public & Private Network Uplinks", "id"=>186, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>187}, {"description"=>"McAfee Host Intrusion Protection w/Reporting", "id"=>302, "itemTaxCategoryId"=>98, "keyName"=>"MCAFEE_HOST_INTRUSION_PROTECTION_WREPORTING", "softwareDescriptionId"=>916, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1.00 TB SATA II", "id"=>471, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_1_00TB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Private Network Uplink", "id"=>497, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>498}, {"capacity"=>"20", "description"=>"20 GB iSCSI SAN Storage", "id"=>548, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_20_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>549}, {"capacity"=>"40", "description"=>"40 GB iSCSI SAN Storage", "id"=>549, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_40_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>598}, {"capacity"=>"2000", "description"=>"2000 GB iSCSI SAN Storage", "id"=>626, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_2000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>1176}, {"description"=>"Microsoft SQL Server 2008 Standard", "id"=>683, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_STANDARD", "softwareDescriptionId"=>306, "upgradeItemId"=>nil}, {"capacity"=>"70", "description"=>"Virtuozzo Containers 4 for Linux - 70 VPS", "id"=>744, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_70_VPS", "softwareDescriptionId"=>322, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Standard Edition (64bit)", "id"=>977, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_R2", "softwareDescriptionId"=>475, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Datacenter Edition (64bit)", "id"=>979, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_R2", "softwareDescriptionId"=>478, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"24", "description"=>"24 GB Registered DDR3 1333", "id"=>826, "itemTaxCategoryId"=>166, "keyName"=>"RAM_24_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 8.x (64 bit)", "id"=>1065, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_8_X_64_BIT_2", "softwareDescriptionId"=>1019, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"600", "description"=>"600 GB SA-SCSI 15K RPM", "id"=>1094, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_600GB_SASCSI_15K_RPM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx (32 bit)", "id"=>1136, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_32_BIT", "softwareDescriptionId"=>774, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 9.x (32 bit)", "id"=>4137, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_9_X_32_BIT_2", "softwareDescriptionId"=>1264, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 25 Pack", "id"=>4156, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_25_PACK", "softwareDescriptionId"=>1016, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin (64 bit)", "id"=>4166, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_64_BIT", "softwareDescriptionId"=>1165, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"175", "description"=>"175GB EVault Disk to Disk Enterprise Backup", "id"=>4182, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_175_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>561}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Linux) Unlimited Domain w/ Power Pack", "id"=>4197, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_LINUX_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1197, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10000", "description"=>"10 Gbps Redundant Private Network Uplinks", "id"=>4341, "itemTaxCategoryId"=>166, "keyName"=>"10_GBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"800", "description"=>"800 GB SSD", "id"=>4356, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_800GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (128 TB)", "id"=>4369, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_128_TB", "softwareDescriptionId"=>1155, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (16 TB)", "id"=>4371, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_16_TB", "softwareDescriptionId"=>1153, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"No Operating System", "id"=>4648, "itemTaxCategoryId"=>166, "keyName"=>"OS_NO_OPERATING_SYSTEM", "softwareDescriptionId"=>1312, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr (32 bit)", "id"=>4700, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_32_BIT", "softwareDescriptionId"=>1360, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10000", "description"=>"10 Gbps Dual Public & Private Network Uplinks (Unbonded)", "id"=>5106, "itemTaxCategoryId"=>166, "keyName"=>"10_GBPS_DUAL_PUBLIC_PRIVATE_NETWORK_UPLINKS_UNBONDED", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Standard Edition", "id"=>5124, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_STANDARD_EDITION", "softwareDescriptionId"=>1334, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.5 - Minimal Install (64 bit) - version-locked", "id"=>5984, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_5_MINIMAL_64_BIT", "softwareDescriptionId"=>1263, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"1 IP Address", "id"=>15, "itemTaxCategoryId"=>166, "keyName"=>"1_IP_ADDRESS", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"MySQL for Linux", "id"=>22, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_LINUX", "softwareDescriptionId"=>156, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Workgroup", "id"=>80, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_WORKGROUP", "softwareDescriptionId"=>20, "upgradeItemId"=>nil}, {"capacity"=>"20000", "description"=>"20000 GB Bandwidth", "id"=>249, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_20000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100Mbps Hardware Firewall", "id"=>298, "itemTaxCategoryId"=>166, "keyName"=>"100MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"Redundant Power Supply", "id"=>469, "itemTaxCategoryId"=>166, "keyName"=>"REDUNDANT_POWER_SUPPLY", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"500", "description"=>"500 GB SATA II", "id"=>14, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_500GB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Private Network Uplink", "id"=>496, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>497}, {"capacity"=>"250", "description"=>"250 GB iSCSI SAN Storage", "id"=>552, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_250_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>612}, {"capacity"=>"20", "description"=>"20GB EVault Disk to Disk Enterprise Backup", "id"=>558, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_20_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>739}, {"capacity"=>"500", "description"=>"500 GB NAS", "id"=>611, "itemTaxCategoryId"=>166, "keyName"=>"NAS_500_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>605}, {"description"=>"Microsoft SQL Server 2008 Workgroup", "id"=>684, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WORKGROUP", "softwareDescriptionId"=>304, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"Virtuozzo Containers 4 for Linux - 5 VPS", "id"=>740, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_5_VPS", "softwareDescriptionId"=>317, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard Edition SP2 (64bit)", "id"=>936, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_SP2", "softwareDescriptionId"=>447, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Enterprise Edition (64bit)", "id"=>978, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_64_BIT_R2_2", "softwareDescriptionId"=>477, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Datacenter Edition With Hyper-V (64bit)", "id"=>980, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_R2_2", "softwareDescriptionId"=>478, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"RAID 0", "id"=>488, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_0", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"RAID 10", "id"=>491, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_10", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix Essentials for XenServer 5.5 (Billed per VM)", "id"=>1077, "itemTaxCategoryId"=>166, "keyName"=>"CITRIX_ESSENTIALS_XENSERVER_5_5", "softwareDescriptionId"=>521, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"72", "description"=>"72 GB Registered DDR3 1333", "id"=>829, "itemTaxCategoryId"=>166, "keyName"=>"RAM_72_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"96", "description"=>"96 GB Registered DDR3 1333", "id"=>1050, "itemTaxCategoryId"=>166, "keyName"=>"RAM_96_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Workgroup R2", "id"=>1164, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WORKGROUP_R2", "softwareDescriptionId"=>697, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Redundant Public & Private Network Uplinks", "id"=>1284, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_REDUNDANT_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 10 (Linux) Unlimited Domain w/ Power Pack", "id"=>1306, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_LINUX_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>939, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 5.6.1", "id"=>1322, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6_1", "softwareDescriptionId"=>801, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x (32 bit)", "id"=>3904, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_32_BIT", "softwareDescriptionId"=>1258, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 6.x Squeeze/Stable (32 bit)", "id"=>3967, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_6_X_SQUEEZE_32_BIT", "softwareDescriptionId"=>918, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESX 4.1", "id"=>3969, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESX_4_1", "softwareDescriptionId"=>800, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 5.x (64 bit)", "id"=>4093, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_5_X_64_BIT_3", "softwareDescriptionId"=>1158, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Express Edition", "id"=>4150, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_EXPRESS", "softwareDescriptionId"=>1005, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1500", "description"=>"1500GB EVault Disk to Disk Enterprise Backup", "id"=>4185, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_1500_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>955}, {"capacity"=>"0", "description"=>"Windows Server 2012 Datacenter Edition (64bit)", "id"=>4237, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_DC_64_BIT", "softwareDescriptionId"=>1082, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 1 Pack", "id"=>4345, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_1_PACK", "softwareDescriptionId"=>1094, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 25 Pack", "id"=>4348, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_25_PACK", "softwareDescriptionId"=>1097, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable (64 bit)", "id"=>4405, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_64_BIT", "softwareDescriptionId"=>1104, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware vCenter 5.5 Standard", "id"=>4598, "itemTaxCategoryId"=>166, "keyName"=>"VMWARE_VCENTER_5_5_STANDARD", "softwareDescriptionId"=>1275, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr - Minimal Install (64 bit)", "id"=>4710, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_MINIMAL_64_BIT_2", "softwareDescriptionId"=>1346, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 12 - 30 Domain w/ Power Pack", "id"=>6010, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_12_30_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1414, "upgradeItemId"=>nil}, {"capacity"=>"8", "description"=>"8 Public IP Addresses", "id"=>17, "itemTaxCategoryId"=>166, "keyName"=>"8_PUBLIC_IP_ADDRESSES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"MySQL 5.0 for Windows", "id"=>23, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_0_WINDOWS", "softwareDescriptionId"=>13, "upgradeItemId"=>nil}, {"description"=>"Email and Ticket", "id"=>51, "itemTaxCategoryId"=>166, "keyName"=>"NOTIFICATION_EMAIL_AND_TICKET", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"NOC Monitoring", "id"=>54, "itemTaxCategoryId"=>166, "keyName"=>"NOC_MONITORING", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"cPanel/WHM with Fantastico and RVskin", "id"=>96, "itemTaxCategoryId"=>166, "keyName"=>"CPANELWHM_WITH_FANTASTICO_AND_RVSKIN", "softwareDescriptionId"=>31, "upgradeItemId"=>nil}, {"description"=>"Unlimited Bandwidth (100 Mbps Uplink)", "id"=>97, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_UNLIMITED_100_MBPS_UPLINK", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Reboot / KVM over IP", "id"=>504, "itemTaxCategoryId"=>166, "keyName"=>"REBOOT_KVM_OVER_IP", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1000 GB iSCSI SAN Storage", "id"=>554, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_1000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>783}, {"capacity"=>"150", "description"=>"Virtuozzo Containers 4 for Linux - 150 VPS", "id"=>746, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_150_VPS", "softwareDescriptionId"=>324, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"50", "description"=>"Virtuozzo Containers 4 for Linux - 50 VPS", "id"=>743, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_50_VPS", "softwareDescriptionId"=>321, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard Edition SP2 (32bit)", "id"=>933, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_32_BIT_SP2", "softwareDescriptionId"=>444, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Enterprise Edition SP2 (64bit)", "id"=>938, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_64_BIT_SP2", "softwareDescriptionId"=>449, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Datacenter Edition SP2 (64bit)", "id"=>940, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_SP2", "softwareDescriptionId"=>451, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Citrix XenServer 5.5", "id"=>950, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_5", "softwareDescriptionId"=>642, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Web Edition (64bit)", "id"=>976, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_64_BIT_R2_SP1", "softwareDescriptionId"=>832, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Standard SP2 with R2 (32 bit)", "id"=>421, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_STD_32_BIT_SP2_WR2", "softwareDescriptionId"=>125, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Web Edition SP2 (32bit)", "id"=>934, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_32_BIT_SP2", "softwareDescriptionId"=>445, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"RAID 1", "id"=>489, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_1", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"RAID 5", "id"=>490, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_5", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2.00 TB SATA II", "id"=>1091, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_2_00TB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"12", "description"=>"12 GB Registered DDR3 1333", "id"=>824, "itemTaxCategoryId"=>166, "keyName"=>"RAM_12_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"36", "description"=>"36 GB Registered DDR3 1333", "id"=>827, "itemTaxCategoryId"=>166, "keyName"=>"RAM_36_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Enterprise for XenServer 5.6", "id"=>1300, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ENTERPRISE_FOR_XENSERVER_5_6", "softwareDescriptionId"=>726, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin - Minimal Install (64 bit)", "id"=>4170, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_MINIMAL_64_BIT_2", "softwareDescriptionId"=>1184, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Windows) Unlimited Domain w/ Power Pack", "id"=>4200, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_WINDOWS_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1274, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.1", "id"=>4258, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_1", "softwareDescriptionId"=>1065, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware vCenter 5.1 Standard", "id"=>4298, "itemTaxCategoryId"=>166, "keyName"=>"VMWARE_VCENTER_5_1_STANDARD", "softwareDescriptionId"=>1090, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (4 TB)", "id"=>4372, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_4_TB", "softwareDescriptionId"=>1123, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"20", "description"=>"20Mbps Hardware Firewall", "id"=>4550, "itemTaxCategoryId"=>166, "keyName"=>"20MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.2.1", "id"=>4569, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_2_1", "softwareDescriptionId"=>1257, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MySQL 5.7 for Windows", "id"=>4592, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_7_WINDOWS", "softwareDescriptionId"=>1272, "upgradeItemId"=>nil}, {"capacity"=>"10000", "description"=>"10 Gbps Dual Private Network Uplinks (Unbonded)", "id"=>5102, "itemTaxCategoryId"=>166, "keyName"=>"10_GBPS_DUAL_PRIVATE_NETWORK_UPLINKS_UNBONDED", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Enterprise Edition", "id"=>5120, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_ENTERPRISE_EDITION_2", "softwareDescriptionId"=>1330, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Enterprise", "id"=>81, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_ENTERPRISE", "softwareDescriptionId"=>21, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Public & Private Network Uplinks", "id"=>187, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>188}, {"capacity"=>"1000", "description"=>"1000Mbps Hardware Firewall", "id"=>297, "itemTaxCategoryId"=>166, "keyName"=>"1000MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x (64 bit)", "id"=>420, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_64_BIT", "softwareDescriptionId"=>1240, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Enterprise SP2 with R2 (32 bit)", "id"=>423, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_ENT_32_BIT_SP2_WR2", "softwareDescriptionId"=>128, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 8.x (32 bit)", "id"=>1066, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_8_X_32_BIT", "softwareDescriptionId"=>1022, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"60", "description"=>"60GB EVault Disk to Disk Enterprise Backup", "id"=>1076, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_60_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>560}, {"capacity"=>"18", "description"=>"18 GB Registered DDR3 1333", "id"=>825, "itemTaxCategoryId"=>166, "keyName"=>"RAM_18_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"2", "description"=>"Monitoring Package - Advanced", "id"=>1249, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_ADVANCED", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"capacity"=>"10000", "description"=>"10 Gbps Public & Private Network Uplinks", "id"=>1281, "itemTaxCategoryId"=>166, "keyName"=>"10_GBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"50", "description"=>"50GB EVault Disk to Disk Enterprise Backup", "id"=>3784, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_50_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>1076}, {"description"=>"Parallels Plesk Panel 10 (Windows) 100 Domain w/ Power Pack", "id"=>3786, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_WINDOWS_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>787, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x (64 bit)", "id"=>3907, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_64_BIT", "softwareDescriptionId"=>1261, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Redundant Private Network Uplinks", "id"=>3956, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"3000", "description"=>"3.00 TB SATA III", "id"=>3989, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_3_00TB_SATA_III", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Enterprise for XenServer 6.x", "id"=>4105, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ENTERPRISE_FOR_XENSERVER_6_X", "softwareDescriptionId"=>909, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 1 Pack", "id"=>4153, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_1_PACK", "softwareDescriptionId"=>1015, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin (32 bit)", "id"=>4165, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_32_BIT", "softwareDescriptionId"=>1166, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Dual Public & Private Network Uplinks (Unbonded)", "id"=>4263, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_DUAL_PUBLIC_PRIVATE_NETWORK_UPLINKS_UNBONDED", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"4000", "description"=>"4.00 TB SATA III", "id"=>4281, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_4_00TB_SATA_III", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x (64 bit) (per-processor licensing)", "id"=>4321, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_64_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1247, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable - Minimal Install (32 bit)", "id"=>4406, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_MINIMAL_32_BIT", "softwareDescriptionId"=>1176, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable - Minimal Install (64 bit)", "id"=>4407, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_MINIMAL_64_BIT", "softwareDescriptionId"=>1177, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MySQL 5.0.51 for Windows", "id"=>4557, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_0_51_WINDOWS", "softwareDescriptionId"=>220, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESXi 5.5", "id"=>4562, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESXI_5_5", "softwareDescriptionId"=>1256, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 10.x (32 bit)", "id"=>4640, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_10_X_32_BIT", "softwareDescriptionId"=>1284, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 10.x (64 bit)", "id"=>4638, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_10_X_64_BIT", "softwareDescriptionId"=>1286, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr (64 bit)", "id"=>4702, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_64_BIT", "softwareDescriptionId"=>1362, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Express Edition", "id"=>5122, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_EXPRESS_EDITION", "softwareDescriptionId"=>1332, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 12 - Unlimited Domain w/ Power Pack", "id"=>6014, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_12_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1420, "upgradeItemId"=>nil}, {"capacity"=>"4", "description"=>"4 Public IP Addresses", "id"=>16, "itemTaxCategoryId"=>166, "keyName"=>"4_PUBLIC_IP_ADDRESSES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Unlimited Bandwidth (10 Mbps Uplink)", "id"=>30, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_UNLIMITED_10_MBPS_UPLINK", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB NAS", "id"=>43, "itemTaxCategoryId"=>166, "keyName"=>"NAS_100_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>44}, {"description"=>"Business Continuance Insurance", "id"=>84, "itemTaxCategoryId"=>108, "keyName"=>"BUSINESS_CONTINUANCE_INSURANCE", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100GB EVault Disk to Disk Enterprise Backup", "id"=>560, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_100_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4182}, {"capacity"=>"30", "description"=>"Virtuozzo Containers 4 for Linux - 30 VPS", "id"=>742, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_30_VPS", "softwareDescriptionId"=>320, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"64", "description"=>"/64 Block Static Public IPv6 Addresses", "id"=>784, "itemTaxCategoryId"=>166, "keyName"=>"64_BLOCK_STATIC_PUBLIC_IPV6_ADDRESSES", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESX 4.0", "id"=>1078, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESX_4_0", "softwareDescriptionId"=>497, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"48", "description"=>"48 GB Registered DDR3 1333", "id"=>828, "itemTaxCategoryId"=>166, "keyName"=>"RAM_48_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx (64 bit)", "id"=>1137, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_64_BIT", "softwareDescriptionId"=>775, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Enterprise R2", "id"=>1165, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_ENTERPRISE_R2", "softwareDescriptionId"=>699, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Datacenter R2", "id"=>1166, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_DATACENTER_R2", "softwareDescriptionId"=>700, "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Monitoring Package - Basic", "id"=>1248, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_BASIC", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2000Mbps Hardware Firewall", "id"=>1296, "itemTaxCategoryId"=>166, "keyName"=>"2000MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Advanced for XenServer 5.6", "id"=>1299, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ADVANCED_FOR_XENSERVER_5_6", "softwareDescriptionId"=>726, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"EVault Plugin - BMR (Bare Metal Restore)", "id"=>961, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_PLUGIN_BMR_BARE_METAL_RESTORE", "softwareDescriptionId"=>467, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 5.6.2", "id"=>3886, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6_2", "softwareDescriptionId"=>867, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Advanced for XenServer 6.x", "id"=>4104, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ADVANCED_FOR_XENSERVER_6_X", "softwareDescriptionId"=>908, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 9.x (64 bit)", "id"=>4138, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_9_X_64_BIT", "softwareDescriptionId"=>1265, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"400", "description"=>"400 GB SSD", "id"=>4181, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_400GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Cloudera Distribution for Hadoop 4", "id"=>4301, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_CLOUDERA_DISTRIBUTION_HADOOP_4", "softwareDescriptionId"=>1099, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x (32 bit) (per-processor licensing)", "id"=>4320, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_32_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1246, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Riak 1.x", "id"=>4327, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_RIAK_1_X", "softwareDescriptionId"=>1114, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Redundant Private Network Uplinks", "id"=>4331, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Redundant Public & Private Network Uplinks", "id"=>4336, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_REDUNDANT_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>1284}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (48 TB)", "id"=>4370, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_48_TB", "softwareDescriptionId"=>1154, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Standard Edition (64 bit)", "id"=>4549, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_STD_64_BIT", "softwareDescriptionId"=>1225, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Express", "id"=>24, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_EXPRESS", "softwareDescriptionId"=>9, "upgradeItemId"=>nil}, {"capacity"=>"40", "description"=>"40 GB NAS", "id"=>41, "itemTaxCategoryId"=>166, "keyName"=>"NAS_40_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>42}, {"description"=>"Host Ping", "id"=>49, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_HOST_PING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Automated Notification", "id"=>52, "itemTaxCategoryId"=>166, "keyName"=>"AUTOMATED_NOTIFICATION", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Automated Reboot from Monitoring", "id"=>53, "itemTaxCategoryId"=>166, "keyName"=>"AUTOMATED_REBOOT_FROM_MONITORING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"300", "description"=>"300 GB SA-SCSI 15K RPM", "id"=>352, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_300GB_SASCSI_15K_RPM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"500", "description"=>"500 GB iSCSI SAN Storage", "id"=>553, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_500_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>621}, {"capacity"=>"500", "description"=>"500GB EVault Disk to Disk Enterprise Backup", "id"=>562, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_500_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4184}, {"capacity"=>"120", "description"=>"120 GB iSCSI SAN Storage", "id"=>575, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_120_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>622}, {"capacity"=>"0", "description"=>"FreeBSD 7.x  (32 bit)", "id"=>638, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_7_X_32_BIT", "softwareDescriptionId"=>666, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Virtuozzo Containers 4 for Linux - 3 VPS", "id"=>738, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_3_VPS", "softwareDescriptionId"=>319, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"Virtuozzo Containers 4 for Linux - 100 VPS", "id"=>745, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_100_VPS", "softwareDescriptionId"=>323, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Web Edition SP2 (64bit)", "id"=>935, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_64_BIT_SP2", "softwareDescriptionId"=>446, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Cloudera Distribution for Hadoop 2", "id"=>1044, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_CLOUDERA_DISTRIBUTION_HADOOP_2", "softwareDescriptionId"=>520, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"144", "description"=>"144 GB Registered DDR3 1333", "id"=>1011, "itemTaxCategoryId"=>166, "keyName"=>"RAM_144_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"description"=>"Citrix XenServer 5.6", "id"=>1189, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6", "softwareDescriptionId"=>704, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft WebMatrix", "id"=>3898, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_WEBMATRIX_2", "softwareDescriptionId"=>868, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"International Services", "id"=>3955, "itemTaxCategoryId"=>166, "keyName"=>"INTERNATIONAL_SERVICES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 6.x (32 bit)", "id"=>4094, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_6_X_32_BIT_2", "softwareDescriptionId"=>1172, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 6.x (64 bit)", "id"=>4095, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_6_X_64_BIT", "softwareDescriptionId"=>1175, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"64", "description"=>"1 IPv6 Address", "id"=>4097, "itemTaxCategoryId"=>166, "keyName"=>"1_IPV6_ADDRESS", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Web Edition", "id"=>4147, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_WEB", "softwareDescriptionId"=>1004, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Enterprise Edition", "id"=>4149, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_ENTERPRISE", "softwareDescriptionId"=>1001, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MongoDB", "id"=>4226, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MONGODB", "softwareDescriptionId"=>1083, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 Datacenter Edition With Hyper-V (64bit)", "id"=>4247, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_DC_64_BIT_2", "softwareDescriptionId"=>1082, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x (32 bit) (per-processor licensing)", "id"=>4318, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_32_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1227, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Redundant Public & Private Network Uplinks", "id"=>4332, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_REDUNDANT_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>4336}, {"capacity"=>"0", "description"=>"Idera Server Backup 5.0 Enterprise (Windows)", "id"=>4344, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_SERVER_BACKUP_5_0_ENTERPRISE_WINDOWS", "softwareDescriptionId"=>1092, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 5 Pack", "id"=>4346, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_5_PACK", "softwareDescriptionId"=>1095, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"0 GB Bandwidth", "id"=>4481, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_0_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Datacenter Edition (64bit)", "id"=>4547, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_DC_64_BIT", "softwareDescriptionId"=>1226, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"200", "description"=>"200Mbps Hardware Firewall", "id"=>4551, "itemTaxCategoryId"=>166, "keyName"=>"200MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"cPanel/WHM with Softaculous and RVskin", "id"=>4608, "itemTaxCategoryId"=>166, "keyName"=>"CPANELWHM_WITH_SOFTACULOUS_AND_RVSKIN", "softwareDescriptionId"=>1292, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr - Minimal Install (32 bit)", "id"=>4708, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_MINIMAL_32_BIT_2", "softwareDescriptionId"=>1350, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 7.x (64 bit)", "id"=>5920, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_7_X_64_BIT", "softwareDescriptionId"=>1400, "units"=>"N/A", "upgradeItemId"=>nil}]
          fixture_package_items[50] = [{"capacity"=>"20", "description"=>"20 GB NAS", "id"=>40, "itemTaxCategoryId"=>166, "keyName"=>"NAS_20_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>41}, {"description"=>"Microsoft SQL Server 2005 Standard", "id"=>79, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_STANDARD", "softwareDescriptionId"=>8, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10Mbps Hardware Firewall", "id"=>299, "itemTaxCategoryId"=>166, "keyName"=>"10MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"Unlimited SSL VPN Users & 1 PPTP VPN User per account", "id"=>309, "itemTaxCategoryId"=>166, "keyName"=>"UNLIMITED_SSL_VPN_USERS_1_PPTP_VPN_USER_PER_ACCOUNT", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"40", "description"=>"40GB EVault Disk to Disk Enterprise Backup", "id"=>559, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_40_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>3784}, {"capacity"=>"1000", "description"=>"1000GB EVault Disk to Disk Enterprise Backup", "id"=>563, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_1000_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4185}, {"description"=>"Microsoft SQL Server 2008 Web", "id"=>685, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WEB", "softwareDescriptionId"=>305, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Standard SP2 with R2 (64 bit)", "id"=>422, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_STD_64_BIT_SP2_WR2", "softwareDescriptionId"=>126, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Enterprise SP2 with R2 (64 bit)", "id"=>424, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_ENT_64_BIT_SP2_WR2", "softwareDescriptionId"=>127, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Datacenter SP2 with R2 (64 bit)", "id"=>921, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_DC_64_BIT_SP2_WR2", "softwareDescriptionId"=>402, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Enterprise Edition SP2 (32bit)", "id"=>937, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_32_BIT_SP2", "softwareDescriptionId"=>448, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2000GB EVault Disk to Disk Enterprise Backup", "id"=>955, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_2000_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>nil}, {"capacity"=>"2", "description"=>"2 x 2.0 GHz Core Bare Metal Instance - 2 GB Ram", "id"=>1013, "itemTaxCategoryId"=>166, "keyName"=>"BARE_METAL_2_CORE_2_GB_RAM", "softwareDescriptionId"=>nil, "units"=>"CORE", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x - LAMP Install (64 bit)", "id"=>1026, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_LAMP_64_BIT", "softwareDescriptionId"=>1235, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx - Minimal Install (64 bit)", "id"=>1141, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_MINIMAL_64_BIT", "softwareDescriptionId"=>790, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Web R2", "id"=>1163, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WEB_R2", "softwareDescriptionId"=>696, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Express R2", "id"=>1162, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_EXPRESS_R2", "softwareDescriptionId"=>701, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 10 (Linux) 100 Domain w/ Power Pack", "id"=>1305, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_LINUX_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>938, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x - LAMP Install (32 bit)", "id"=>3918, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_LAMP_32_BIT_2", "softwareDescriptionId"=>1259, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.0.0", "id"=>3977, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_0_0", "softwareDescriptionId"=>836, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.0.2", "id"=>4133, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_0_2", "softwareDescriptionId"=>961, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin - Minimal Install (32 bit)", "id"=>4169, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_MINIMAL_32_BIT", "softwareDescriptionId"=>1186, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"350", "description"=>"350GB EVault Disk to Disk Enterprise Backup", "id"=>4183, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_350_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>562}, {"capacity"=>"750", "description"=>"750GB EVault Disk to Disk Enterprise Backup", "id"=>4184, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_750_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>563}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Linux) 100 Domain w/ Power Pack", "id"=>4195, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_LINUX_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1191, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Windows) 100 Domain w/ Power Pack", "id"=>4199, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_WINDOWS_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1273, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 5.x (64 bit)", "id"=>4377, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_5_X_64_BIT_2", "softwareDescriptionId"=>1159, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.2", "id"=>4467, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_2", "softwareDescriptionId"=>1171, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Dual Public & Private Network Uplinks (Unbonded)", "id"=>5118, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_DUAL_PUBLIC_PRIVATE_NETWORK_UPLINKS_UNBONDED", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"80", "description"=>"80 GB NAS", "id"=>42, "itemTaxCategoryId"=>166, "keyName"=>"NAS_80_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>43}, {"capacity"=>"250", "description"=>"250 GB NAS", "id"=>44, "itemTaxCategoryId"=>166, "keyName"=>"NAS_250_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>411}, {"capacity"=>"1000", "description"=>"1 Gbps Public & Private Network Uplinks", "id"=>188, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"APF Software Firewall for Linux", "id"=>300, "itemTaxCategoryId"=>166, "keyName"=>"APF_SOFTWARE_FIREWALL_FOR_LINUX", "softwareDescriptionId"=>71, "upgradeItemId"=>nil}, {"description"=>"Nessus Vulnerability Assessment & Reporting", "id"=>307, "itemTaxCategoryId"=>98, "keyName"=>"NESSUS_VULNERABILITY_ASSESSMENT_REPORTING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"McAfee VirusScan Enterprise", "id"=>397, "itemTaxCategoryId"=>98, "keyName"=>"MCAFEE_VIRUSSCAN_ANTIVIRUS_WINDOWS", "softwareDescriptionId"=>820, "upgradeItemId"=>nil}, {"description"=>"Microsoft Windows Firewall", "id"=>495, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_WINDOWS_FIREWALL", "softwareDescriptionId"=>106, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Private Network Uplink", "id"=>498, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"80", "description"=>"80 GB iSCSI SAN Storage", "id"=>550, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_80_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>551}, {"capacity"=>"250", "description"=>"250GB EVault Disk to Disk Enterprise Backup", "id"=>561, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_250_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4183}, {"description"=>"Microsoft SQL Server 2008 Express", "id"=>681, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_EXPRESS", "softwareDescriptionId"=>308, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Enterprise", "id"=>682, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_ENTERPRISE", "softwareDescriptionId"=>307, "upgradeItemId"=>nil}, {"capacity"=>"30", "description"=>"30GB EVault Disk to Disk Enterprise Backup", "id"=>739, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_30_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>559}, {"capacity"=>"0", "description"=>"Windows Server 2008 Datacenter Edition SP2 (32bit)", "id"=>939, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_32_BIT_SP2", "softwareDescriptionId"=>450, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Account Setup Fee", "id"=>947, "itemTaxCategoryId"=>4, "keyName"=>"ACCOUNT_SETUP_FEE", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"8", "description"=>"8 x 2.0 GHz Core Bare Metal Instance - 8 GB Ram", "id"=>1015, "itemTaxCategoryId"=>166, "keyName"=>"BARE_METAL_8_CORE_8_GB_RAM", "softwareDescriptionId"=>nil, "units"=>"CORE", "upgradeItemId"=>nil}, {"capacity"=>"2", "description"=>"2 x 2.0 GHz Core Bare Metal Instance - 8 GB Ram ", "id"=>1159, "itemTaxCategoryId"=>166, "keyName"=>"BARE_METAL_2_CORE_8_GB_RAM", "softwareDescriptionId"=>nil, "units"=>"CORE", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Standard R2", "id"=>1161, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_STANDARD_R2", "softwareDescriptionId"=>698, "upgradeItemId"=>nil}, {"capacity"=>"3", "description"=>"Monitoring Package - Premium Application", "id"=>1250, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_PREMIUM_APPLICATION", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 10 (Windows) Unlimited Domain w/ Power Pack", "id"=>3785, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_WINDOWS_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>788, "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x - Minimal Install (32 bit)", "id"=>3836, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_MINIMAL_32_BIT", "softwareDescriptionId"=>1249, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x - Minimal Install (64 bit)", "id"=>3838, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_MINIMAL_64_BIT_2", "softwareDescriptionId"=>1251, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x - Minimal Install (32 bit)", "id"=>3920, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_MINIMAL_32_BIT_2", "softwareDescriptionId"=>1260, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 Standard Edition (64 bit)", "id"=>4233, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_STD_64_BIT", "softwareDescriptionId"=>1076, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESXi 5.1", "id"=>4272, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESXI_5_1", "softwareDescriptionId"=>1086, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 9.x (64 bit)", "id"=>4294, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_9_X_64_BIT_2", "softwareDescriptionId"=>1271, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Host Ping and TCP Service Monitoring", "id"=>50, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_HOST_PING_AND_TCP_SERVICE", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Public & Private Network Uplinks", "id"=>186, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>187}, {"description"=>"McAfee Host Intrusion Protection w/Reporting", "id"=>302, "itemTaxCategoryId"=>98, "keyName"=>"MCAFEE_HOST_INTRUSION_PROTECTION_WREPORTING", "softwareDescriptionId"=>916, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Private Network Uplink", "id"=>497, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>498}, {"capacity"=>"20", "description"=>"20 GB iSCSI SAN Storage", "id"=>548, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_20_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>549}, {"capacity"=>"40", "description"=>"40 GB iSCSI SAN Storage", "id"=>549, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_40_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>598}, {"description"=>"Microsoft SQL Server 2008 Standard", "id"=>683, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_STANDARD", "softwareDescriptionId"=>306, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Datacenter SP2 with R2 (32 bit)", "id"=>920, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_DC_32_BIT_SP2_WR2", "softwareDescriptionId"=>401, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"0 GB Bandwidth", "id"=>439, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_0_GB_2", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Standard Edition (64bit)", "id"=>977, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_R2", "softwareDescriptionId"=>475, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x - Minimal Install (64 bit)", "id"=>1025, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_MINIMAL_64_BIT_2", "softwareDescriptionId"=>1234, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"4", "description"=>"4 x 2.0 GHz Core Bare Metal Instance - 16 GB Ram", "id"=>1158, "itemTaxCategoryId"=>166, "keyName"=>"BARE_METAL_4_CORE_16_GB_RAM", "softwareDescriptionId"=>nil, "units"=>"CORE", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x - LAMP Install (32 bit)", "id"=>3832, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_LAMP_32_BIT_2", "softwareDescriptionId"=>1248, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Datacenter Edition (64bit)", "id"=>979, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_R2", "softwareDescriptionId"=>478, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 6.x Squeeze/Stable - LAMP Install (32 bit)", "id"=>3984, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_6_X_SQUEEZE_LAMP_32_BIT", "softwareDescriptionId"=>921, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 6.x Squeeze/Stable - Minimal Install (64 bit)", "id"=>3987, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_6_X_SQUEEZE_MINIMAL_64_BIT_2", "softwareDescriptionId"=>1033, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin - LAMP Install (64 bit)", "id"=>4168, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_LAMP_64_BIT_2", "softwareDescriptionId"=>1027, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"175", "description"=>"175GB EVault Disk to Disk Enterprise Backup", "id"=>4182, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_175_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>561}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Linux) Unlimited Domain w/ Power Pack", "id"=>4197, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_LINUX_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1197, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Vyatta 6.x Subscription Edition (64 bit)", "id"=>4396, "itemTaxCategoryId"=>166, "keyName"=>"OS_VYATTA_6_X_SUBSCRIPTION_EDITION_64_BIT_2", "softwareDescriptionId"=>1221, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"No Operating System", "id"=>4648, "itemTaxCategoryId"=>166, "keyName"=>"OS_NO_OPERATING_SYSTEM", "softwareDescriptionId"=>1312, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"CentOS 7.x - LAMP Install (64 bit)", "id"=>5956, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_7_X_LAMP_64_BIT_2", "softwareDescriptionId"=>1444, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.5 - Minimal Install (64 bit) - version-locked", "id"=>5984, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_5_MINIMAL_64_BIT", "softwareDescriptionId"=>1263, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"1 IP Address", "id"=>15, "itemTaxCategoryId"=>166, "keyName"=>"1_IP_ADDRESS", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"MySQL for Linux", "id"=>22, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_LINUX", "softwareDescriptionId"=>156, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Workgroup", "id"=>80, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_WORKGROUP", "softwareDescriptionId"=>20, "upgradeItemId"=>nil}, {"capacity"=>"20000", "description"=>"20000 GB Bandwidth", "id"=>249, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_20000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100Mbps Hardware Firewall", "id"=>298, "itemTaxCategoryId"=>166, "keyName"=>"100MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Private Network Uplink", "id"=>496, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>497}, {"capacity"=>"250", "description"=>"250 GB iSCSI SAN Storage", "id"=>552, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_250_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>612}, {"capacity"=>"20", "description"=>"20GB EVault Disk to Disk Enterprise Backup", "id"=>558, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_20_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>739}, {"capacity"=>"500", "description"=>"500 GB NAS", "id"=>611, "itemTaxCategoryId"=>166, "keyName"=>"NAS_500_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>605}, {"capacity"=>"500", "description"=>"500 GB SATA II", "id"=>14, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_500GB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Workgroup", "id"=>684, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WORKGROUP", "softwareDescriptionId"=>304, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard Edition SP2 (64bit)", "id"=>936, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_SP2", "softwareDescriptionId"=>447, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Enterprise Edition (64bit)", "id"=>978, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_64_BIT_R2_2", "softwareDescriptionId"=>477, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx - LAMP Install (64 bit)", "id"=>1143, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_LAMP_64_BIT_2", "softwareDescriptionId"=>792, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Workgroup R2", "id"=>1164, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WORKGROUP_R2", "softwareDescriptionId"=>697, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Redundant Public & Private Network Uplinks", "id"=>1284, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_REDUNDANT_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 10 (Linux) Unlimited Domain w/ Power Pack", "id"=>1306, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_LINUX_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>939, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 5.6.1", "id"=>1322, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6_1", "softwareDescriptionId"=>801, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x - LAMP Install (64 bit)", "id"=>3834, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_LAMP_64_BIT", "softwareDescriptionId"=>1250, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESX 4.1", "id"=>3969, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESX_4_1", "softwareDescriptionId"=>800, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin - LAMP Install (32 bit)", "id"=>4167, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_LAMP_32_BIT", "softwareDescriptionId"=>1030, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1500", "description"=>"1500GB EVault Disk to Disk Enterprise Backup", "id"=>4185, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_1500_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>955}, {"capacity"=>"0", "description"=>"Windows Server 2012 Datacenter Edition (64bit)", "id"=>4237, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_DC_64_BIT", "softwareDescriptionId"=>1082, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard SP1 with R2 (64 bit)", "id"=>4248, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_R2_SP1", "softwareDescriptionId"=>831, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 8.x (32 bit)", "id"=>4291, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_8_X_32_BIT_2", "softwareDescriptionId"=>1102, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 9.x (32 bit)", "id"=>4293, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_9_X_32_BIT", "softwareDescriptionId"=>1270, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Datacenter Edition With Hyper-V (64bit)", "id"=>980, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_R2_2", "softwareDescriptionId"=>478, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware vCenter 5.5 Standard", "id"=>4598, "itemTaxCategoryId"=>166, "keyName"=>"VMWARE_VCENTER_5_5_STANDARD", "softwareDescriptionId"=>1275, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr - LAMP Install (64 bit)", "id"=>4706, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_LAMP_64_BIT_2", "softwareDescriptionId"=>1356, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr - Minimal Install (64 bit)", "id"=>4710, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_MINIMAL_64_BIT_2", "softwareDescriptionId"=>1346, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 12 - 30 Domain w/ Power Pack", "id"=>6010, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_12_30_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1414, "upgradeItemId"=>nil}, {"capacity"=>"8", "description"=>"8 Public IP Addresses", "id"=>17, "itemTaxCategoryId"=>166, "keyName"=>"8_PUBLIC_IP_ADDRESSES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"MySQL 5.0 for Windows", "id"=>23, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_0_WINDOWS", "softwareDescriptionId"=>13, "upgradeItemId"=>nil}, {"description"=>"Email and Ticket", "id"=>51, "itemTaxCategoryId"=>166, "keyName"=>"NOTIFICATION_EMAIL_AND_TICKET", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"NOC Monitoring", "id"=>54, "itemTaxCategoryId"=>166, "keyName"=>"NOC_MONITORING", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"cPanel/WHM with Fantastico and RVskin", "id"=>96, "itemTaxCategoryId"=>166, "keyName"=>"CPANELWHM_WITH_FANTASTICO_AND_RVSKIN", "softwareDescriptionId"=>31, "upgradeItemId"=>nil}, {"description"=>"Unlimited Bandwidth (100 Mbps Uplink)", "id"=>97, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_UNLIMITED_100_MBPS_UPLINK", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Reboot / Remote Console", "id"=>503, "itemTaxCategoryId"=>166, "keyName"=>"REBOOT_REMOTE_CONSOLE", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Standard SP2 with R2 (32 bit)", "id"=>421, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_STD_32_BIT_SP2_WR2", "softwareDescriptionId"=>125, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard Edition SP2 (32bit)", "id"=>933, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_32_BIT_SP2", "softwareDescriptionId"=>444, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Enterprise Edition SP2 (64bit)", "id"=>938, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_64_BIT_SP2", "softwareDescriptionId"=>449, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Datacenter Edition SP2 (64bit)", "id"=>940, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_SP2", "softwareDescriptionId"=>451, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Citrix XenServer 5.5", "id"=>950, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_5", "softwareDescriptionId"=>642, "upgradeItemId"=>nil}, {"capacity"=>"16", "description"=>"16 x 2.0 GHz Core Bare Metal Instance - 16 GB Ram", "id"=>1012, "itemTaxCategoryId"=>166, "keyName"=>"BARE_METAL_16_CORE_16_GB_RAM", "softwareDescriptionId"=>nil, "units"=>"CORE", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x - LAMP Install (32 bit)", "id"=>1024, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_LAMP_32_BIT_2", "softwareDescriptionId"=>1243, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x - LAMP Install (64 bit)", "id"=>1029, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_LAMP_64_BIT_2", "softwareDescriptionId"=>1244, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x - Minimal Install (32 bit)", "id"=>1030, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_MINIMAL_32_BIT_2", "softwareDescriptionId"=>1232, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Enterprise for XenServer 5.6", "id"=>1300, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ENTERPRISE_FOR_XENSERVER_5_6", "softwareDescriptionId"=>726, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin - Minimal Install (64 bit)", "id"=>4170, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_MINIMAL_64_BIT_2", "softwareDescriptionId"=>1184, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Windows) Unlimited Domain w/ Power Pack", "id"=>4200, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_WINDOWS_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1274, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.1", "id"=>4258, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_1", "softwareDescriptionId"=>1065, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware vCenter 5.1 Standard", "id"=>4298, "itemTaxCategoryId"=>166, "keyName"=>"VMWARE_VCENTER_5_1_STANDARD", "softwareDescriptionId"=>1090, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Vyatta 6.6 Community Edition (64 bit)", "id"=>4495, "itemTaxCategoryId"=>166, "keyName"=>"OS_VYATTA_6_6_COMMUNITY_EDITION_64_BIT", "softwareDescriptionId"=>1192, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"20", "description"=>"20Mbps Hardware Firewall", "id"=>4550, "itemTaxCategoryId"=>166, "keyName"=>"20MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.2.1", "id"=>4569, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_2_1", "softwareDescriptionId"=>1257, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MySQL 5.7 for Windows", "id"=>4592, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_7_WINDOWS", "softwareDescriptionId"=>1272, "upgradeItemId"=>nil}, {"description"=>"CentOS 7.x - Minimal Install (64 bit)", "id"=>5958, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_7_X_MINIMAL_64_BIT_2", "softwareDescriptionId"=>1446, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Enterprise", "id"=>81, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_ENTERPRISE", "softwareDescriptionId"=>21, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Public & Private Network Uplinks", "id"=>187, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>188}, {"capacity"=>"1000", "description"=>"1000Mbps Hardware Firewall", "id"=>297, "itemTaxCategoryId"=>166, "keyName"=>"1000MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Enterprise SP2 with R2 (32 bit)", "id"=>423, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_ENT_32_BIT_SP2_WR2", "softwareDescriptionId"=>128, "upgradeItemId"=>nil}, {"capacity"=>"60", "description"=>"60GB EVault Disk to Disk Enterprise Backup", "id"=>1076, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_60_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>560}, {"capacity"=>"8", "description"=>"8 x 2.0 GHz Core Bare Metal Instance - 32 GB Ram", "id"=>1157, "itemTaxCategoryId"=>166, "keyName"=>"BARE_METAL_8_CORE_32_GB_RAM", "softwareDescriptionId"=>nil, "units"=>"CORE", "upgradeItemId"=>nil}, {"capacity"=>"2", "description"=>"Monitoring Package - Advanced", "id"=>1249, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_ADVANCED", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"capacity"=>"50", "description"=>"50GB EVault Disk to Disk Enterprise Backup", "id"=>3784, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_50_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>1076}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 6.x Squeeze/Stable - Minimal Install (32 bit)", "id"=>3985, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_6_X_SQUEEZE_MINIMAL_32_BIT_2", "softwareDescriptionId"=>923, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 6.x Squeeze/Stable - LAMP Install (64 bit)", "id"=>3986, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_6_X_SQUEEZE_LAMP_64_BIT_2", "softwareDescriptionId"=>1034, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Enterprise for XenServer 6.x", "id"=>4105, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ENTERPRISE_FOR_XENSERVER_6_X", "softwareDescriptionId"=>909, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Dual Public & Private Network Uplinks (Unbonded)", "id"=>4263, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_DUAL_PUBLIC_PRIVATE_NETWORK_UPLINKS_UNBONDED", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Vyatta 6.5 Community Edition (64 bit)", "id"=>4315, "itemTaxCategoryId"=>166, "keyName"=>"OS_VYATTA_6_5_COMMUNITY_EDITION_64_BIT", "softwareDescriptionId"=>1106, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 6.x (64 bit)", "id"=>4379, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_6_X_64_BIT_3", "softwareDescriptionId"=>1175, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable - Minimal Install (32 bit)", "id"=>4406, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_MINIMAL_32_BIT", "softwareDescriptionId"=>1176, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable - Minimal Install (64 bit)", "id"=>4407, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_MINIMAL_64_BIT", "softwareDescriptionId"=>1177, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MySQL 5.0.51 for Windows", "id"=>4557, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_0_51_WINDOWS", "softwareDescriptionId"=>220, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESXi 5.5", "id"=>4562, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESXI_5_5", "softwareDescriptionId"=>1256, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 10.x (32 bit)", "id"=>4640, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_10_X_32_BIT", "softwareDescriptionId"=>1284, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 10.x (64 bit)", "id"=>4638, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_10_X_64_BIT", "softwareDescriptionId"=>1286, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 12 - Unlimited Domain w/ Power Pack", "id"=>6014, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_12_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1420, "upgradeItemId"=>nil}, {"capacity"=>"4", "description"=>"4 Public IP Addresses", "id"=>16, "itemTaxCategoryId"=>166, "keyName"=>"4_PUBLIC_IP_ADDRESSES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Unlimited Bandwidth (10 Mbps Uplink)", "id"=>30, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_UNLIMITED_10_MBPS_UPLINK", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB NAS", "id"=>43, "itemTaxCategoryId"=>166, "keyName"=>"NAS_100_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>44}, {"description"=>"Business Continuance Insurance", "id"=>84, "itemTaxCategoryId"=>108, "keyName"=>"BUSINESS_CONTINUANCE_INSURANCE", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100GB EVault Disk to Disk Enterprise Backup", "id"=>560, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_100_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4182}, {"capacity"=>"64", "description"=>"/64 Block Static Public IPv6 Addresses", "id"=>784, "itemTaxCategoryId"=>166, "keyName"=>"64_BLOCK_STATIC_PUBLIC_IPV6_ADDRESSES", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"4", "description"=>"4 x 2.0 GHz Core Bare Metal Instance - 4 GB Ram", "id"=>1014, "itemTaxCategoryId"=>166, "keyName"=>"BARE_METAL_4_CORE_4_GB_RAM", "softwareDescriptionId"=>nil, "units"=>"CORE", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x - LAMP Install (32 bit)", "id"=>1018, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_LAMP_32_BIT", "softwareDescriptionId"=>1233, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESX 4.0", "id"=>1078, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESX_4_0", "softwareDescriptionId"=>497, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx - LAMP Install (32 bit)", "id"=>1142, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_LAMP_32_BIT", "softwareDescriptionId"=>791, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx - Minimal Install (32 bit)", "id"=>1139, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_MINIMAL_32_BIT_2", "softwareDescriptionId"=>789, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Enterprise R2", "id"=>1165, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_ENTERPRISE_R2", "softwareDescriptionId"=>699, "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Monitoring Package - Basic", "id"=>1248, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_BASIC", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Advanced for XenServer 5.6", "id"=>1299, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ADVANCED_FOR_XENSERVER_5_6", "softwareDescriptionId"=>726, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 5.6.2", "id"=>3886, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6_2", "softwareDescriptionId"=>867, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Advanced for XenServer 6.x", "id"=>4104, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ADVANCED_FOR_XENSERVER_6_X", "softwareDescriptionId"=>908, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 8.x (64 bit)", "id"=>4292, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_8_X_64_BIT", "softwareDescriptionId"=>1101, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Riak 1.x", "id"=>4327, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_RIAK_1_X", "softwareDescriptionId"=>1114, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Redundant Public & Private Network Uplinks", "id"=>4336, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_REDUNDANT_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>1284}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr - LAMP Install (32 bit)", "id"=>4704, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_LAMP_32_BIT_2", "softwareDescriptionId"=>1358, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Express", "id"=>24, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_EXPRESS", "softwareDescriptionId"=>9, "upgradeItemId"=>nil}, {"capacity"=>"40", "description"=>"40 GB NAS", "id"=>41, "itemTaxCategoryId"=>166, "keyName"=>"NAS_40_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>42}, {"description"=>"Host Ping", "id"=>49, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_HOST_PING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Automated Notification", "id"=>52, "itemTaxCategoryId"=>166, "keyName"=>"AUTOMATED_NOTIFICATION", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Automated Reboot from Monitoring", "id"=>53, "itemTaxCategoryId"=>166, "keyName"=>"AUTOMATED_REBOOT_FROM_MONITORING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"500", "description"=>"500 GB iSCSI SAN Storage", "id"=>553, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_500_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>621}, {"capacity"=>"500", "description"=>"500GB EVault Disk to Disk Enterprise Backup", "id"=>562, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_500_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4184}, {"capacity"=>"0", "description"=>"CentOS 5.x - Minimal Install (32 bit)", "id"=>1022, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_MINIMAL_32_BIT_2", "softwareDescriptionId"=>1241, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x - Minimal Install (64 bit)", "id"=>1023, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_MINIMAL_64_BIT_2", "softwareDescriptionId"=>1242, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"16", "description"=>"16 x 2.0 GHz Core Bare Metal Instance - 64 GB Ram", "id"=>1156, "itemTaxCategoryId"=>166, "keyName"=>"BARE_METAL_16_CORE_64_GB_RAM", "softwareDescriptionId"=>nil, "units"=>"CORE", "upgradeItemId"=>nil}, {"description"=>"Citrix XenServer 5.6", "id"=>1189, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6", "softwareDescriptionId"=>704, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft WebMatrix", "id"=>3898, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_WEBMATRIX_2", "softwareDescriptionId"=>868, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x - LAMP Install (64 bit)", "id"=>3919, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_LAMP_64_BIT", "softwareDescriptionId"=>1262, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x - Minimal Install (64 bit)", "id"=>3921, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_MINIMAL_64_BIT", "softwareDescriptionId"=>1263, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"International Services", "id"=>3955, "itemTaxCategoryId"=>166, "keyName"=>"INTERNATIONAL_SERVICES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"64", "description"=>"1 IPv6 Address", "id"=>4097, "itemTaxCategoryId"=>166, "keyName"=>"1_IPV6_ADDRESS", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MongoDB", "id"=>4226, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MONGODB", "softwareDescriptionId"=>1083, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 Datacenter Edition With Hyper-V (64bit)", "id"=>4247, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_DC_64_BIT_2", "softwareDescriptionId"=>1082, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Redundant Public & Private Network Uplinks", "id"=>4332, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_REDUNDANT_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>4336}, {"capacity"=>"0", "description"=>"CloudLinux 5.x (32 bit)", "id"=>4376, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_5_X_32_BIT", "softwareDescriptionId"=>1157, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 6.x (32 bit)", "id"=>4378, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_6_X_32_BIT_3", "softwareDescriptionId"=>1173, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"0 GB Bandwidth", "id"=>4481, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_0_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"200", "description"=>"200Mbps Hardware Firewall", "id"=>4551, "itemTaxCategoryId"=>166, "keyName"=>"200MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"cPanel/WHM with Softaculous and RVskin", "id"=>4608, "itemTaxCategoryId"=>166, "keyName"=>"CPANELWHM_WITH_SOFTACULOUS_AND_RVSKIN", "softwareDescriptionId"=>1292, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr - Minimal Install (32 bit)", "id"=>4708, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_MINIMAL_32_BIT_2", "softwareDescriptionId"=>1350, "units"=>"N/A", "upgradeItemId"=>nil}]
          fixture_package_items[51] = [{"capacity"=>"20", "description"=>"20 GB NAS", "id"=>40, "itemTaxCategoryId"=>166, "keyName"=>"NAS_20_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>41}, {"description"=>"Microsoft SQL Server 2005 Standard", "id"=>79, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_STANDARD", "softwareDescriptionId"=>8, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10Mbps Hardware Firewall", "id"=>299, "itemTaxCategoryId"=>166, "keyName"=>"10MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"Unlimited SSL VPN Users & 1 PPTP VPN User per account", "id"=>309, "itemTaxCategoryId"=>166, "keyName"=>"UNLIMITED_SSL_VPN_USERS_1_PPTP_VPN_USER_PER_ACCOUNT", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Enterprise SP2 with R2 (64 bit)", "id"=>424, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_ENT_64_BIT_SP2_WR2", "softwareDescriptionId"=>127, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Standard SP2 with R2 (64 bit)", "id"=>422, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_STD_64_BIT_SP2_WR2", "softwareDescriptionId"=>126, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB iSCSI SAN Storage", "id"=>551, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_100_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>575}, {"capacity"=>"40", "description"=>"40GB EVault Disk to Disk Enterprise Backup", "id"=>559, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_40_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>3784}, {"capacity"=>"1000", "description"=>"1000GB EVault Disk to Disk Enterprise Backup", "id"=>563, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_1000_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4185}, {"capacity"=>"0", "description"=>"FreeBSD 7.x  (64 bit)", "id"=>637, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_7_X_64_BIT", "softwareDescriptionId"=>667, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Web", "id"=>685, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WEB", "softwareDescriptionId"=>305, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Enterprise Edition SP2 (32bit)", "id"=>937, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_32_BIT_SP2", "softwareDescriptionId"=>448, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2000GB EVault Disk to Disk Enterprise Backup", "id"=>955, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_2000_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Web R2", "id"=>1163, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WEB_R2", "softwareDescriptionId"=>696, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Express R2", "id"=>1162, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_EXPRESS_R2", "softwareDescriptionId"=>701, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 10 (Linux) 100 Domain w/ Power Pack", "id"=>1305, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_LINUX_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>938, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"200", "description"=>"200 GB SSD", "id"=>3811, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_200GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 6.x Squeeze/Stable (64 bit)", "id"=>3968, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_6_X_SQUEEZE_64_BIT", "softwareDescriptionId"=>919, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.0.0", "id"=>3977, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_0_0", "softwareDescriptionId"=>836, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 5.x (32 bit)", "id"=>4092, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_5_X_32_BIT_2", "softwareDescriptionId"=>1156, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.0.2", "id"=>4133, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_0_2", "softwareDescriptionId"=>961, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 10 Pack", "id"=>4155, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_10_PACK", "softwareDescriptionId"=>1011, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin - Minimal Install (32 bit)", "id"=>4169, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_MINIMAL_32_BIT", "softwareDescriptionId"=>1186, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"350", "description"=>"350GB EVault Disk to Disk Enterprise Backup", "id"=>4183, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_350_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>562}, {"capacity"=>"750", "description"=>"750GB EVault Disk to Disk Enterprise Backup", "id"=>4184, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_750_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>563}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Linux) 100 Domain w/ Power Pack", "id"=>4195, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_LINUX_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1191, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Windows) 100 Domain w/ Power Pack", "id"=>4199, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_WINDOWS_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1273, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 1 VM", "id"=>4303, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_1_VM", "softwareDescriptionId"=>1105, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - Unlimited VMs", "id"=>4307, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_UNLIMITED_VMS", "softwareDescriptionId"=>1112, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.2", "id"=>4467, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_2", "softwareDescriptionId"=>1171, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Dual Public & Private Network Uplinks (Unbonded)", "id"=>5118, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_DUAL_PUBLIC_PRIVATE_NETWORK_UPLINKS_UNBONDED", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"80", "description"=>"80 GB NAS", "id"=>42, "itemTaxCategoryId"=>166, "keyName"=>"NAS_80_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>43}, {"capacity"=>"250", "description"=>"250 GB NAS", "id"=>44, "itemTaxCategoryId"=>166, "keyName"=>"NAS_250_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>411}, {"capacity"=>"1000", "description"=>"1 Gbps Public & Private Network Uplinks", "id"=>188, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"APF Software Firewall for Linux", "id"=>300, "itemTaxCategoryId"=>166, "keyName"=>"APF_SOFTWARE_FIREWALL_FOR_LINUX", "softwareDescriptionId"=>71, "upgradeItemId"=>nil}, {"description"=>"Nessus Vulnerability Assessment & Reporting", "id"=>307, "itemTaxCategoryId"=>98, "keyName"=>"NESSUS_VULNERABILITY_ASSESSMENT_REPORTING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"McAfee VirusScan Enterprise", "id"=>397, "itemTaxCategoryId"=>98, "keyName"=>"MCAFEE_VIRUSSCAN_ANTIVIRUS_WINDOWS", "softwareDescriptionId"=>820, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x (32 bit)", "id"=>419, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_32_BIT", "softwareDescriptionId"=>1239, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Non-RAID", "id"=>487, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_NONRAID", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Microsoft Windows Firewall", "id"=>495, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_WINDOWS_FIREWALL", "softwareDescriptionId"=>106, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Private Network Uplink", "id"=>498, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"80", "description"=>"80 GB iSCSI SAN Storage", "id"=>550, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_80_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>551}, {"capacity"=>"250", "description"=>"250GB EVault Disk to Disk Enterprise Backup", "id"=>561, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_250_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4183}, {"description"=>"Microsoft SQL Server 2008 Express", "id"=>681, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_EXPRESS", "softwareDescriptionId"=>308, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Enterprise", "id"=>682, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_ENTERPRISE", "softwareDescriptionId"=>307, "upgradeItemId"=>nil}, {"capacity"=>"30", "description"=>"30GB EVault Disk to Disk Enterprise Backup", "id"=>739, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_30_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>559}, {"capacity"=>"10", "description"=>"Virtuozzo Containers 4 for Linux - 10 VPS", "id"=>741, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_10_VPS", "softwareDescriptionId"=>318, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Datacenter Edition SP2 (32bit)", "id"=>939, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_32_BIT_SP2", "softwareDescriptionId"=>450, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Standard R2", "id"=>1161, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_STANDARD_R2", "softwareDescriptionId"=>698, "upgradeItemId"=>nil}, {"capacity"=>"3000", "description"=>"3000 GB iSCSI SAN Storage", "id"=>1176, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_3000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"3", "description"=>"Monitoring Package - Premium Application", "id"=>1250, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_PREMIUM_APPLICATION", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 10 (Windows) Unlimited Domain w/ Power Pack", "id"=>3785, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_WINDOWS_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>788, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Standard Edition", "id"=>4148, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_STANDARD", "softwareDescriptionId"=>1003, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 5 Pack", "id"=>4154, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_5_PACK", "softwareDescriptionId"=>1012, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 Standard Edition (64 bit)", "id"=>4233, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_STD_64_BIT", "softwareDescriptionId"=>1076, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"4", "description"=>"4 GB Registered DDR3 1333", "id"=>1039, "itemTaxCategoryId"=>166, "keyName"=>"RAM_4_GB_DDR3_1333_ECC_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESXi 5.1", "id"=>4272, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESXI_5_1", "softwareDescriptionId"=>1086, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 5 VMs", "id"=>4304, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_5_VMS", "softwareDescriptionId"=>1109, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 10 VMs", "id"=>4305, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_10_VMS", "softwareDescriptionId"=>1110, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"15", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 15 VMs", "id"=>4306, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_15_VMS", "softwareDescriptionId"=>1111, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x (64 bit) (per-processor licensing)", "id"=>4319, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_64_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1228, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Server Backup 5.0 Enterprise (Linux)", "id"=>4343, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_SERVER_BACKUP_5_0_ENTERPRISE_LINUX", "softwareDescriptionId"=>1093, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 10 Pack", "id"=>4347, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_10_PACK", "softwareDescriptionId"=>1096, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable (32 bit)", "id"=>4404, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_32_BIT", "softwareDescriptionId"=>1169, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"RAID", "id"=>4478, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Datacenter Edition With Hyper-V (64bit)", "id"=>4548, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_DC_64_BIT_2", "softwareDescriptionId"=>1226, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Host Ping and TCP Service Monitoring", "id"=>50, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_HOST_PING_AND_TCP_SERVICE", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Public & Private Network Uplinks", "id"=>186, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>187}, {"description"=>"McAfee Host Intrusion Protection w/Reporting", "id"=>302, "itemTaxCategoryId"=>98, "keyName"=>"MCAFEE_HOST_INTRUSION_PROTECTION_WREPORTING", "softwareDescriptionId"=>916, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1.00 TB SATA II", "id"=>471, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_1_00TB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Private Network Uplink", "id"=>497, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>498}, {"capacity"=>"20", "description"=>"20 GB iSCSI SAN Storage", "id"=>548, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_20_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>549}, {"capacity"=>"40", "description"=>"40 GB iSCSI SAN Storage", "id"=>549, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_40_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>598}, {"capacity"=>"2000", "description"=>"2000 GB iSCSI SAN Storage", "id"=>626, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_2000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>1176}, {"description"=>"Microsoft SQL Server 2008 Standard", "id"=>683, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_STANDARD", "softwareDescriptionId"=>306, "upgradeItemId"=>nil}, {"capacity"=>"70", "description"=>"Virtuozzo Containers 4 for Linux - 70 VPS", "id"=>744, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_70_VPS", "softwareDescriptionId"=>322, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Standard Edition (64bit)", "id"=>977, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_R2", "softwareDescriptionId"=>475, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Datacenter Edition (64bit)", "id"=>979, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_R2", "softwareDescriptionId"=>478, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 8.x (64 bit)", "id"=>1065, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_8_X_64_BIT_2", "softwareDescriptionId"=>1019, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"600", "description"=>"600 GB SA-SCSI 15K RPM", "id"=>1094, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_600GB_SASCSI_15K_RPM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx (32 bit)", "id"=>1136, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_32_BIT", "softwareDescriptionId"=>774, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 9.x (32 bit)", "id"=>4137, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_9_X_32_BIT_2", "softwareDescriptionId"=>1264, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 25 Pack", "id"=>4156, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_25_PACK", "softwareDescriptionId"=>1016, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin (64 bit)", "id"=>4166, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_64_BIT", "softwareDescriptionId"=>1165, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"175", "description"=>"175GB EVault Disk to Disk Enterprise Backup", "id"=>4182, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_175_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>561}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Linux) Unlimited Domain w/ Power Pack", "id"=>4197, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_LINUX_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1197, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"20", "description"=>"20 GB Registered DDR3 1333", "id"=>1034, "itemTaxCategoryId"=>166, "keyName"=>"RAM_20_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"24", "description"=>"24 GB Registered DDR3 1333", "id"=>826, "itemTaxCategoryId"=>166, "keyName"=>"RAM_24_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"800", "description"=>"800 GB SSD", "id"=>4356, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_800GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (128 TB)", "id"=>4369, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_128_TB", "softwareDescriptionId"=>1155, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (16 TB)", "id"=>4371, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_16_TB", "softwareDescriptionId"=>1153, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Vyatta 6.x Subscription Edition (64 bit)", "id"=>4396, "itemTaxCategoryId"=>166, "keyName"=>"OS_VYATTA_6_X_SUBSCRIPTION_EDITION_64_BIT_2", "softwareDescriptionId"=>1221, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"No Operating System", "id"=>4648, "itemTaxCategoryId"=>166, "keyName"=>"OS_NO_OPERATING_SYSTEM", "softwareDescriptionId"=>1312, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Standard Edition", "id"=>5124, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_STANDARD_EDITION", "softwareDescriptionId"=>1334, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.5 - Minimal Install (64 bit) - version-locked", "id"=>5984, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_5_MINIMAL_64_BIT", "softwareDescriptionId"=>1263, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"1 IP Address", "id"=>15, "itemTaxCategoryId"=>166, "keyName"=>"1_IP_ADDRESS", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"MySQL for Linux", "id"=>22, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_LINUX", "softwareDescriptionId"=>156, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Workgroup", "id"=>80, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_WORKGROUP", "softwareDescriptionId"=>20, "upgradeItemId"=>nil}, {"capacity"=>"20000", "description"=>"20000 GB Bandwidth", "id"=>249, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_20000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100Mbps Hardware Firewall", "id"=>298, "itemTaxCategoryId"=>166, "keyName"=>"100MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"500", "description"=>"500 GB SATA II", "id"=>14, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_500GB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"RAID 0", "id"=>488, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_0", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"RAID 10", "id"=>491, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_10", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Private Network Uplink", "id"=>496, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>497}, {"capacity"=>"250", "description"=>"250 GB iSCSI SAN Storage", "id"=>552, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_250_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>612}, {"capacity"=>"20", "description"=>"20GB EVault Disk to Disk Enterprise Backup", "id"=>558, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_20_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>739}, {"capacity"=>"500", "description"=>"500 GB NAS", "id"=>611, "itemTaxCategoryId"=>166, "keyName"=>"NAS_500_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>605}, {"description"=>"Microsoft SQL Server 2008 Workgroup", "id"=>684, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WORKGROUP", "softwareDescriptionId"=>304, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"Virtuozzo Containers 4 for Linux - 5 VPS", "id"=>740, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_5_VPS", "softwareDescriptionId"=>317, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard Edition SP2 (64bit)", "id"=>936, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_SP2", "softwareDescriptionId"=>447, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Enterprise Edition (64bit)", "id"=>978, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_64_BIT_R2_2", "softwareDescriptionId"=>477, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Datacenter Edition With Hyper-V (64bit)", "id"=>980, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_R2_2", "softwareDescriptionId"=>478, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix Essentials for XenServer 5.5 (Billed per VM)", "id"=>1077, "itemTaxCategoryId"=>166, "keyName"=>"CITRIX_ESSENTIALS_XENSERVER_5_5", "softwareDescriptionId"=>521, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Workgroup R2", "id"=>1164, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WORKGROUP_R2", "softwareDescriptionId"=>697, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Redundant Public & Private Network Uplinks", "id"=>1284, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_REDUNDANT_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 10 (Linux) Unlimited Domain w/ Power Pack", "id"=>1306, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_LINUX_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>939, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 5.6.1", "id"=>1322, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6_1", "softwareDescriptionId"=>801, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x (32 bit)", "id"=>3904, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_32_BIT", "softwareDescriptionId"=>1258, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 6.x Squeeze/Stable (32 bit)", "id"=>3967, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_6_X_SQUEEZE_32_BIT", "softwareDescriptionId"=>918, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESX 4.1", "id"=>3969, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESX_4_1", "softwareDescriptionId"=>800, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 5.x (64 bit)", "id"=>4093, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_5_X_64_BIT_3", "softwareDescriptionId"=>1158, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Express Edition", "id"=>4150, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_EXPRESS", "softwareDescriptionId"=>1005, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1500", "description"=>"1500GB EVault Disk to Disk Enterprise Backup", "id"=>4185, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_1500_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>955}, {"capacity"=>"0", "description"=>"Windows Server 2012 Datacenter Edition (64bit)", "id"=>4237, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_DC_64_BIT", "softwareDescriptionId"=>1082, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard SP1 with R2 (64 bit)", "id"=>4248, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_R2_SP1", "softwareDescriptionId"=>831, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 1 Pack", "id"=>4345, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_1_PACK", "softwareDescriptionId"=>1094, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 25 Pack", "id"=>4348, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_25_PACK", "softwareDescriptionId"=>1097, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable (64 bit)", "id"=>4405, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_64_BIT", "softwareDescriptionId"=>1104, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware vCenter 5.5 Standard", "id"=>4598, "itemTaxCategoryId"=>166, "keyName"=>"VMWARE_VCENTER_5_5_STANDARD", "softwareDescriptionId"=>1275, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 12 - 30 Domain w/ Power Pack", "id"=>6010, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_12_30_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1414, "upgradeItemId"=>nil}, {"capacity"=>"8", "description"=>"8 Public IP Addresses", "id"=>17, "itemTaxCategoryId"=>166, "keyName"=>"8_PUBLIC_IP_ADDRESSES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"MySQL 5.0 for Windows", "id"=>23, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_0_WINDOWS", "softwareDescriptionId"=>13, "upgradeItemId"=>nil}, {"description"=>"Email and Ticket", "id"=>51, "itemTaxCategoryId"=>166, "keyName"=>"NOTIFICATION_EMAIL_AND_TICKET", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"NOC Monitoring", "id"=>54, "itemTaxCategoryId"=>166, "keyName"=>"NOC_MONITORING", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"cPanel/WHM with Fantastico and RVskin", "id"=>96, "itemTaxCategoryId"=>166, "keyName"=>"CPANELWHM_WITH_FANTASTICO_AND_RVSKIN", "softwareDescriptionId"=>31, "upgradeItemId"=>nil}, {"description"=>"Unlimited Bandwidth (100 Mbps Uplink)", "id"=>97, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_UNLIMITED_100_MBPS_UPLINK", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Standard SP2 with R2 (32 bit)", "id"=>421, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_STD_32_BIT_SP2_WR2", "softwareDescriptionId"=>125, "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"RAID 1", "id"=>489, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_1", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"RAID 5", "id"=>490, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_5", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Reboot / KVM over IP", "id"=>504, "itemTaxCategoryId"=>166, "keyName"=>"REBOOT_KVM_OVER_IP", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1000 GB iSCSI SAN Storage", "id"=>554, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_1000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>783}, {"capacity"=>"150", "description"=>"Virtuozzo Containers 4 for Linux - 150 VPS", "id"=>746, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_150_VPS", "softwareDescriptionId"=>324, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"50", "description"=>"Virtuozzo Containers 4 for Linux - 50 VPS", "id"=>743, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_50_VPS", "softwareDescriptionId"=>321, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard Edition SP2 (32bit)", "id"=>933, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_32_BIT_SP2", "softwareDescriptionId"=>444, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Web Edition SP2 (32bit)", "id"=>934, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_32_BIT_SP2", "softwareDescriptionId"=>445, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Enterprise Edition SP2 (64bit)", "id"=>938, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_64_BIT_SP2", "softwareDescriptionId"=>449, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Datacenter Edition SP2 (64bit)", "id"=>940, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_SP2", "softwareDescriptionId"=>451, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Citrix XenServer 5.5", "id"=>950, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_5", "softwareDescriptionId"=>642, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Web Edition (64bit)", "id"=>976, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_64_BIT_R2_SP1", "softwareDescriptionId"=>832, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2.00 TB SATA II", "id"=>1091, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_2_00TB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Enterprise for XenServer 5.6", "id"=>1300, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ENTERPRISE_FOR_XENSERVER_5_6", "softwareDescriptionId"=>726, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin - Minimal Install (64 bit)", "id"=>4170, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_MINIMAL_64_BIT_2", "softwareDescriptionId"=>1184, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Windows) Unlimited Domain w/ Power Pack", "id"=>4200, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_WINDOWS_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1274, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"12", "description"=>"12 GB Registered DDR3 1333", "id"=>824, "itemTaxCategoryId"=>166, "keyName"=>"RAM_12_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.1", "id"=>4258, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_1", "softwareDescriptionId"=>1065, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware vCenter 5.1 Standard", "id"=>4298, "itemTaxCategoryId"=>166, "keyName"=>"VMWARE_VCENTER_5_1_STANDARD", "softwareDescriptionId"=>1090, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (4 TB)", "id"=>4372, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_4_TB", "softwareDescriptionId"=>1123, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Vyatta 6.6 Community Edition (64 bit)", "id"=>4495, "itemTaxCategoryId"=>166, "keyName"=>"OS_VYATTA_6_6_COMMUNITY_EDITION_64_BIT", "softwareDescriptionId"=>1192, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"20", "description"=>"20Mbps Hardware Firewall", "id"=>4550, "itemTaxCategoryId"=>166, "keyName"=>"20MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.2.1", "id"=>4569, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_2_1", "softwareDescriptionId"=>1257, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MySQL 5.7 for Windows", "id"=>4592, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_7_WINDOWS", "softwareDescriptionId"=>1272, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Enterprise Edition", "id"=>5120, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_ENTERPRISE_EDITION_2", "softwareDescriptionId"=>1330, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Enterprise", "id"=>81, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_ENTERPRISE", "softwareDescriptionId"=>21, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Public & Private Network Uplinks", "id"=>187, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>188}, {"capacity"=>"1000", "description"=>"1000Mbps Hardware Firewall", "id"=>297, "itemTaxCategoryId"=>166, "keyName"=>"1000MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x (64 bit)", "id"=>420, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_64_BIT", "softwareDescriptionId"=>1240, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Enterprise SP2 with R2 (32 bit)", "id"=>423, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_ENT_32_BIT_SP2_WR2", "softwareDescriptionId"=>128, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 8.x (32 bit)", "id"=>1066, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_8_X_32_BIT", "softwareDescriptionId"=>1022, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"60", "description"=>"60GB EVault Disk to Disk Enterprise Backup", "id"=>1076, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_60_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>560}, {"capacity"=>"2", "description"=>"Monitoring Package - Advanced", "id"=>1249, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_ADVANCED", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"capacity"=>"50", "description"=>"50GB EVault Disk to Disk Enterprise Backup", "id"=>3784, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_50_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>1076}, {"description"=>"Parallels Plesk Panel 10 (Windows) 100 Domain w/ Power Pack", "id"=>3786, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_WINDOWS_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>787, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x (64 bit)", "id"=>3907, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_64_BIT", "softwareDescriptionId"=>1261, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"3000", "description"=>"3.00 TB SATA III", "id"=>3989, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_3_00TB_SATA_III", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Enterprise for XenServer 6.x", "id"=>4105, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ENTERPRISE_FOR_XENSERVER_6_X", "softwareDescriptionId"=>909, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 1 Pack", "id"=>4153, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_1_PACK", "softwareDescriptionId"=>1015, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin (32 bit)", "id"=>4165, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_32_BIT", "softwareDescriptionId"=>1166, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Dual Public & Private Network Uplinks (Unbonded)", "id"=>4263, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_DUAL_PUBLIC_PRIVATE_NETWORK_UPLINKS_UNBONDED", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"4000", "description"=>"4.00 TB SATA III", "id"=>4281, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_4_00TB_SATA_III", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Vyatta 6.5 Community Edition (64 bit)", "id"=>4315, "itemTaxCategoryId"=>166, "keyName"=>"OS_VYATTA_6_5_COMMUNITY_EDITION_64_BIT", "softwareDescriptionId"=>1106, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x (64 bit) (per-processor licensing)", "id"=>4321, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_64_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1247, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable - Minimal Install (32 bit)", "id"=>4406, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_MINIMAL_32_BIT", "softwareDescriptionId"=>1176, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable - Minimal Install (64 bit)", "id"=>4407, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_MINIMAL_64_BIT", "softwareDescriptionId"=>1177, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MySQL 5.0.51 for Windows", "id"=>4557, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_0_51_WINDOWS", "softwareDescriptionId"=>220, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESXi 5.5", "id"=>4562, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESXI_5_5", "softwareDescriptionId"=>1256, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 10.x (32 bit)", "id"=>4640, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_10_X_32_BIT", "softwareDescriptionId"=>1284, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 10.x (64 bit)", "id"=>4638, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_10_X_64_BIT", "softwareDescriptionId"=>1286, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Express Edition", "id"=>5122, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_EXPRESS_EDITION", "softwareDescriptionId"=>1332, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 12 - Unlimited Domain w/ Power Pack", "id"=>6014, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_12_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1420, "upgradeItemId"=>nil}, {"capacity"=>"4", "description"=>"4 Public IP Addresses", "id"=>16, "itemTaxCategoryId"=>166, "keyName"=>"4_PUBLIC_IP_ADDRESSES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Unlimited Bandwidth (10 Mbps Uplink)", "id"=>30, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_UNLIMITED_10_MBPS_UPLINK", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB NAS", "id"=>43, "itemTaxCategoryId"=>166, "keyName"=>"NAS_100_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>44}, {"description"=>"Business Continuance Insurance", "id"=>84, "itemTaxCategoryId"=>108, "keyName"=>"BUSINESS_CONTINUANCE_INSURANCE", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100GB EVault Disk to Disk Enterprise Backup", "id"=>560, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_100_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4182}, {"capacity"=>"30", "description"=>"Virtuozzo Containers 4 for Linux - 30 VPS", "id"=>742, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_30_VPS", "softwareDescriptionId"=>320, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"64", "description"=>"/64 Block Static Public IPv6 Addresses", "id"=>784, "itemTaxCategoryId"=>166, "keyName"=>"64_BLOCK_STATIC_PUBLIC_IPV6_ADDRESSES", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESX 4.0", "id"=>1078, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESX_4_0", "softwareDescriptionId"=>497, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx (64 bit)", "id"=>1137, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_64_BIT", "softwareDescriptionId"=>775, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Enterprise R2", "id"=>1165, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_ENTERPRISE_R2", "softwareDescriptionId"=>699, "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Monitoring Package - Basic", "id"=>1248, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_BASIC", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2000Mbps Hardware Firewall", "id"=>1296, "itemTaxCategoryId"=>166, "keyName"=>"2000MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Advanced for XenServer 5.6", "id"=>1299, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ADVANCED_FOR_XENSERVER_5_6", "softwareDescriptionId"=>726, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"EVault Plugin - BMR (Bare Metal Restore)", "id"=>961, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_PLUGIN_BMR_BARE_METAL_RESTORE", "softwareDescriptionId"=>467, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 5.6.2", "id"=>3886, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6_2", "softwareDescriptionId"=>867, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Advanced for XenServer 6.x", "id"=>4104, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ADVANCED_FOR_XENSERVER_6_X", "softwareDescriptionId"=>908, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 9.x (64 bit)", "id"=>4138, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_9_X_64_BIT", "softwareDescriptionId"=>1265, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"400", "description"=>"400 GB SSD", "id"=>4181, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_400GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"16", "description"=>"16 GB Registered DDR3 1333", "id"=>1041, "itemTaxCategoryId"=>166, "keyName"=>"RAM_16_GB_DDR3_1333_ECC_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Cloudera Distribution for Hadoop 4", "id"=>4301, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_CLOUDERA_DISTRIBUTION_HADOOP_4", "softwareDescriptionId"=>1099, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x (32 bit) (per-processor licensing)", "id"=>4320, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_32_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1246, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Riak 1.x", "id"=>4327, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_RIAK_1_X", "softwareDescriptionId"=>1114, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Redundant Public & Private Network Uplinks", "id"=>4336, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_REDUNDANT_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>1284}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (48 TB)", "id"=>4370, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_48_TB", "softwareDescriptionId"=>1154, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Standard Edition (64 bit)", "id"=>4549, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_STD_64_BIT", "softwareDescriptionId"=>1225, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Express", "id"=>24, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_EXPRESS", "softwareDescriptionId"=>9, "upgradeItemId"=>nil}, {"capacity"=>"40", "description"=>"40 GB NAS", "id"=>41, "itemTaxCategoryId"=>166, "keyName"=>"NAS_40_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>42}, {"description"=>"Host Ping", "id"=>49, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_HOST_PING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Automated Notification", "id"=>52, "itemTaxCategoryId"=>166, "keyName"=>"AUTOMATED_NOTIFICATION", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Automated Reboot from Monitoring", "id"=>53, "itemTaxCategoryId"=>166, "keyName"=>"AUTOMATED_REBOOT_FROM_MONITORING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"300", "description"=>"300 GB SA-SCSI 15K RPM", "id"=>352, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_300GB_SASCSI_15K_RPM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"500", "description"=>"500 GB iSCSI SAN Storage", "id"=>553, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_500_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>621}, {"capacity"=>"500", "description"=>"500GB EVault Disk to Disk Enterprise Backup", "id"=>562, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_500_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4184}, {"capacity"=>"120", "description"=>"120 GB iSCSI SAN Storage", "id"=>575, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_120_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>622}, {"capacity"=>"0", "description"=>"FreeBSD 7.x  (32 bit)", "id"=>638, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_7_X_32_BIT", "softwareDescriptionId"=>666, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Virtuozzo Containers 4 for Linux - 3 VPS", "id"=>738, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_3_VPS", "softwareDescriptionId"=>319, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"Virtuozzo Containers 4 for Linux - 100 VPS", "id"=>745, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_100_VPS", "softwareDescriptionId"=>323, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Web Edition SP2 (64bit)", "id"=>935, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_64_BIT_SP2", "softwareDescriptionId"=>446, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Cloudera Distribution for Hadoop 2", "id"=>1044, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_CLOUDERA_DISTRIBUTION_HADOOP_2", "softwareDescriptionId"=>520, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Citrix XenServer 5.6", "id"=>1189, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6", "softwareDescriptionId"=>704, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft WebMatrix", "id"=>3898, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_WEBMATRIX_2", "softwareDescriptionId"=>868, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"International Services", "id"=>3955, "itemTaxCategoryId"=>166, "keyName"=>"INTERNATIONAL_SERVICES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 6.x (32 bit)", "id"=>4094, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_6_X_32_BIT_2", "softwareDescriptionId"=>1172, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 6.x (64 bit)", "id"=>4095, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_6_X_64_BIT", "softwareDescriptionId"=>1175, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"64", "description"=>"1 IPv6 Address", "id"=>4097, "itemTaxCategoryId"=>166, "keyName"=>"1_IPV6_ADDRESS", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Web Edition", "id"=>4147, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_WEB", "softwareDescriptionId"=>1004, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Enterprise Edition", "id"=>4149, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_ENTERPRISE", "softwareDescriptionId"=>1001, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MongoDB", "id"=>4226, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MONGODB", "softwareDescriptionId"=>1083, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"8", "description"=>"8 GB Registered DDR3 1333", "id"=>1040, "itemTaxCategoryId"=>166, "keyName"=>"RAM_8_GB_DDR3_1333_ECC_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 Datacenter Edition With Hyper-V (64bit)", "id"=>4247, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_DC_64_BIT_2", "softwareDescriptionId"=>1082, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x (32 bit) (per-processor licensing)", "id"=>4318, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_32_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1227, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Redundant Public & Private Network Uplinks", "id"=>4332, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_REDUNDANT_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>4336}, {"capacity"=>"0", "description"=>"Idera Server Backup 5.0 Enterprise (Windows)", "id"=>4344, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_SERVER_BACKUP_5_0_ENTERPRISE_WINDOWS", "softwareDescriptionId"=>1092, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 5 Pack", "id"=>4346, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_5_PACK", "softwareDescriptionId"=>1095, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"0 GB Bandwidth", "id"=>4481, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_0_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Datacenter Edition (64bit)", "id"=>4547, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_DC_64_BIT", "softwareDescriptionId"=>1226, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"200", "description"=>"200Mbps Hardware Firewall", "id"=>4551, "itemTaxCategoryId"=>166, "keyName"=>"200MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"cPanel/WHM with Softaculous and RVskin", "id"=>4608, "itemTaxCategoryId"=>166, "keyName"=>"CPANELWHM_WITH_SOFTACULOUS_AND_RVSKIN", "softwareDescriptionId"=>1292, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 7.x (64 bit)", "id"=>5920, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_7_X_64_BIT", "softwareDescriptionId"=>1400, "units"=>"N/A", "upgradeItemId"=>nil}]
          fixture_package_items[52] = [{"capacity"=>"20", "description"=>"20 GB NAS", "id"=>40, "itemTaxCategoryId"=>166, "keyName"=>"NAS_20_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>41}, {"description"=>"Microsoft SQL Server 2005 Standard", "id"=>79, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_STANDARD", "softwareDescriptionId"=>8, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10Mbps Hardware Firewall", "id"=>299, "itemTaxCategoryId"=>166, "keyName"=>"10MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"Unlimited SSL VPN Users & 1 PPTP VPN User per account", "id"=>309, "itemTaxCategoryId"=>166, "keyName"=>"UNLIMITED_SSL_VPN_USERS_1_PPTP_VPN_USER_PER_ACCOUNT", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Standard SP2 with R2 (64 bit)", "id"=>422, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_STD_64_BIT_SP2_WR2", "softwareDescriptionId"=>126, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Enterprise SP2 with R2 (64 bit)", "id"=>424, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_ENT_64_BIT_SP2_WR2", "softwareDescriptionId"=>127, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB iSCSI SAN Storage", "id"=>551, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_100_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>575}, {"capacity"=>"40", "description"=>"40GB EVault Disk to Disk Enterprise Backup", "id"=>559, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_40_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>3784}, {"capacity"=>"1000", "description"=>"1000GB EVault Disk to Disk Enterprise Backup", "id"=>563, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_1000_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4185}, {"capacity"=>"0", "description"=>"FreeBSD 7.x  (64 bit)", "id"=>637, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_7_X_64_BIT", "softwareDescriptionId"=>667, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Web", "id"=>685, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WEB", "softwareDescriptionId"=>305, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Enterprise Edition SP2 (32bit)", "id"=>937, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_32_BIT_SP2", "softwareDescriptionId"=>448, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2000GB EVault Disk to Disk Enterprise Backup", "id"=>955, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_2000_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>nil}, {"capacity"=>"192", "description"=>"192 GB Registered DDR3 1066", "id"=>1147, "itemTaxCategoryId"=>166, "keyName"=>"RAM_192_GB_DDR3_1066_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Web R2", "id"=>1163, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WEB_R2", "softwareDescriptionId"=>696, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Express R2", "id"=>1162, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_EXPRESS_R2", "softwareDescriptionId"=>701, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 10 (Linux) 100 Domain w/ Power Pack", "id"=>1305, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_LINUX_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>938, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"200", "description"=>"200 GB SSD", "id"=>3811, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_200GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 6.x Squeeze/Stable (64 bit)", "id"=>3968, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_6_X_SQUEEZE_64_BIT", "softwareDescriptionId"=>919, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.0.0", "id"=>3977, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_0_0", "softwareDescriptionId"=>836, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 5.x (32 bit)", "id"=>4092, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_5_X_32_BIT_2", "softwareDescriptionId"=>1156, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.0.2", "id"=>4133, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_0_2", "softwareDescriptionId"=>961, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 10 Pack", "id"=>4155, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_10_PACK", "softwareDescriptionId"=>1011, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin - Minimal Install (32 bit)", "id"=>4169, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_MINIMAL_32_BIT", "softwareDescriptionId"=>1186, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"350", "description"=>"350GB EVault Disk to Disk Enterprise Backup", "id"=>4183, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_350_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>562}, {"capacity"=>"750", "description"=>"750GB EVault Disk to Disk Enterprise Backup", "id"=>4184, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_750_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>563}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Linux) 100 Domain w/ Power Pack", "id"=>4195, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_LINUX_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1191, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Windows) 100 Domain w/ Power Pack", "id"=>4199, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_WINDOWS_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1273, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 1 VM", "id"=>4303, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_1_VM", "softwareDescriptionId"=>1105, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - Unlimited VMs", "id"=>4307, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_UNLIMITED_VMS", "softwareDescriptionId"=>1112, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Redundant Private Network Uplinks", "id"=>4335, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.2", "id"=>4467, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_2", "softwareDescriptionId"=>1171, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Dual Public & Private Network Uplinks (Unbonded)", "id"=>5118, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_DUAL_PUBLIC_PRIVATE_NETWORK_UPLINKS_UNBONDED", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"80", "description"=>"80 GB NAS", "id"=>42, "itemTaxCategoryId"=>166, "keyName"=>"NAS_80_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>43}, {"capacity"=>"250", "description"=>"250 GB NAS", "id"=>44, "itemTaxCategoryId"=>166, "keyName"=>"NAS_250_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>411}, {"capacity"=>"1000", "description"=>"1 Gbps Public & Private Network Uplinks", "id"=>188, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"APF Software Firewall for Linux", "id"=>300, "itemTaxCategoryId"=>166, "keyName"=>"APF_SOFTWARE_FIREWALL_FOR_LINUX", "softwareDescriptionId"=>71, "upgradeItemId"=>nil}, {"description"=>"Nessus Vulnerability Assessment & Reporting", "id"=>307, "itemTaxCategoryId"=>98, "keyName"=>"NESSUS_VULNERABILITY_ASSESSMENT_REPORTING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"McAfee VirusScan Enterprise", "id"=>397, "itemTaxCategoryId"=>98, "keyName"=>"MCAFEE_VIRUSSCAN_ANTIVIRUS_WINDOWS", "softwareDescriptionId"=>820, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x (32 bit)", "id"=>419, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_32_BIT", "softwareDescriptionId"=>1239, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Non-RAID", "id"=>487, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_NONRAID", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Microsoft Windows Firewall", "id"=>495, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_WINDOWS_FIREWALL", "softwareDescriptionId"=>106, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Private Network Uplink", "id"=>498, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"80", "description"=>"80 GB iSCSI SAN Storage", "id"=>550, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_80_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>551}, {"capacity"=>"250", "description"=>"250GB EVault Disk to Disk Enterprise Backup", "id"=>561, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_250_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4183}, {"description"=>"Microsoft SQL Server 2008 Express", "id"=>681, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_EXPRESS", "softwareDescriptionId"=>308, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Enterprise", "id"=>682, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_ENTERPRISE", "softwareDescriptionId"=>307, "upgradeItemId"=>nil}, {"capacity"=>"30", "description"=>"30GB EVault Disk to Disk Enterprise Backup", "id"=>739, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_30_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>559}, {"capacity"=>"10", "description"=>"Virtuozzo Containers 4 for Linux - 10 VPS", "id"=>741, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_10_VPS", "softwareDescriptionId"=>318, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Datacenter Edition SP2 (32bit)", "id"=>939, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_32_BIT_SP2", "softwareDescriptionId"=>450, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Standard R2", "id"=>1161, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_STANDARD_R2", "softwareDescriptionId"=>698, "upgradeItemId"=>nil}, {"capacity"=>"3000", "description"=>"3000 GB iSCSI SAN Storage", "id"=>1176, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_3000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"3", "description"=>"Monitoring Package - Premium Application", "id"=>1250, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_PREMIUM_APPLICATION", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"capacity"=>"128", "description"=>"128 GB Registered DDR3 1333", "id"=>1307, "itemTaxCategoryId"=>166, "keyName"=>"RAM_128_GB_DDR3_1333_REG_2", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 10 (Windows) Unlimited Domain w/ Power Pack", "id"=>3785, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_WINDOWS_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>788, "upgradeItemId"=>nil}, {"capacity"=>"10000", "description"=>"10 Gbps Private Network Uplink", "id"=>3957, "itemTaxCategoryId"=>166, "keyName"=>"10_GBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Standard Edition", "id"=>4148, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_STANDARD", "softwareDescriptionId"=>1003, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 5 Pack", "id"=>4154, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_5_PACK", "softwareDescriptionId"=>1012, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 Standard Edition (64 bit)", "id"=>4233, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_STD_64_BIT", "softwareDescriptionId"=>1076, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESXi 5.1", "id"=>4272, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESXI_5_1", "softwareDescriptionId"=>1086, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 5 VMs", "id"=>4304, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_5_VMS", "softwareDescriptionId"=>1109, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 10 VMs", "id"=>4305, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_10_VMS", "softwareDescriptionId"=>1110, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"15", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 15 VMs", "id"=>4306, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_15_VMS", "softwareDescriptionId"=>1111, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x (64 bit) (per-processor licensing)", "id"=>4319, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_64_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1228, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Server Backup 5.0 Enterprise (Linux)", "id"=>4343, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_SERVER_BACKUP_5_0_ENTERPRISE_LINUX", "softwareDescriptionId"=>1093, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 10 Pack", "id"=>4347, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_10_PACK", "softwareDescriptionId"=>1096, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable (32 bit)", "id"=>4404, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_32_BIT", "softwareDescriptionId"=>1169, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"RAID", "id"=>4478, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Datacenter Edition With Hyper-V (64bit)", "id"=>4548, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_DC_64_BIT_2", "softwareDescriptionId"=>1226, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Host Ping and TCP Service Monitoring", "id"=>50, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_HOST_PING_AND_TCP_SERVICE", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Public & Private Network Uplinks", "id"=>186, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>187}, {"description"=>"McAfee Host Intrusion Protection w/Reporting", "id"=>302, "itemTaxCategoryId"=>98, "keyName"=>"MCAFEE_HOST_INTRUSION_PROTECTION_WREPORTING", "softwareDescriptionId"=>916, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"SATA RAID 5 Disk Controller", "id"=>118, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_SATA_RAID_5", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1.00 TB SATA II", "id"=>471, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_1_00TB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Private Network Uplink", "id"=>497, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>498}, {"capacity"=>"20", "description"=>"20 GB iSCSI SAN Storage", "id"=>548, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_20_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>549}, {"capacity"=>"40", "description"=>"40 GB iSCSI SAN Storage", "id"=>549, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_40_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>598}, {"capacity"=>"2000", "description"=>"2000 GB iSCSI SAN Storage", "id"=>626, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_2000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>1176}, {"description"=>"Microsoft SQL Server 2008 Standard", "id"=>683, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_STANDARD", "softwareDescriptionId"=>306, "upgradeItemId"=>nil}, {"capacity"=>"70", "description"=>"Virtuozzo Containers 4 for Linux - 70 VPS", "id"=>744, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_70_VPS", "softwareDescriptionId"=>322, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Standard Edition (64bit)", "id"=>977, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_R2", "softwareDescriptionId"=>475, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Datacenter Edition (64bit)", "id"=>979, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_R2", "softwareDescriptionId"=>478, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"24", "description"=>"24 GB Registered DDR3 1333", "id"=>826, "itemTaxCategoryId"=>166, "keyName"=>"RAM_24_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 8.x (64 bit)", "id"=>1065, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_8_X_64_BIT_2", "softwareDescriptionId"=>1019, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"600", "description"=>"600 GB SA-SCSI 15K RPM", "id"=>1094, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_600GB_SASCSI_15K_RPM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx (32 bit)", "id"=>1136, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_32_BIT", "softwareDescriptionId"=>774, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 9.x (32 bit)", "id"=>4137, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_9_X_32_BIT_2", "softwareDescriptionId"=>1264, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 25 Pack", "id"=>4156, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_25_PACK", "softwareDescriptionId"=>1016, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin (64 bit)", "id"=>4166, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_64_BIT", "softwareDescriptionId"=>1165, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"175", "description"=>"175GB EVault Disk to Disk Enterprise Backup", "id"=>4182, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_175_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>561}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Linux) Unlimited Domain w/ Power Pack", "id"=>4197, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_LINUX_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1197, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10000", "description"=>"10 Gbps Redundant Private Network Uplinks", "id"=>4341, "itemTaxCategoryId"=>166, "keyName"=>"10_GBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"800", "description"=>"800 GB SSD", "id"=>4356, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_800GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (128 TB)", "id"=>4369, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_128_TB", "softwareDescriptionId"=>1155, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (16 TB)", "id"=>4371, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_16_TB", "softwareDescriptionId"=>1153, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"No Operating System", "id"=>4648, "itemTaxCategoryId"=>166, "keyName"=>"OS_NO_OPERATING_SYSTEM", "softwareDescriptionId"=>1312, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr (32 bit)", "id"=>4700, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_32_BIT", "softwareDescriptionId"=>1360, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10000", "description"=>"10 Gbps Dual Public & Private Network Uplinks (Unbonded)", "id"=>5106, "itemTaxCategoryId"=>166, "keyName"=>"10_GBPS_DUAL_PUBLIC_PRIVATE_NETWORK_UPLINKS_UNBONDED", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Standard Edition", "id"=>5124, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_STANDARD_EDITION", "softwareDescriptionId"=>1334, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.5 - Minimal Install (64 bit) - version-locked", "id"=>5984, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_5_MINIMAL_64_BIT", "softwareDescriptionId"=>1263, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"1 IP Address", "id"=>15, "itemTaxCategoryId"=>166, "keyName"=>"1_IP_ADDRESS", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"MySQL for Linux", "id"=>22, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_LINUX", "softwareDescriptionId"=>156, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Workgroup", "id"=>80, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_WORKGROUP", "softwareDescriptionId"=>20, "upgradeItemId"=>nil}, {"capacity"=>"20000", "description"=>"20000 GB Bandwidth", "id"=>249, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_20000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100Mbps Hardware Firewall", "id"=>298, "itemTaxCategoryId"=>166, "keyName"=>"100MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"Redundant Power Supply", "id"=>469, "itemTaxCategoryId"=>166, "keyName"=>"REDUNDANT_POWER_SUPPLY", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"500", "description"=>"500 GB SATA II", "id"=>14, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_500GB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Private Network Uplink", "id"=>496, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>497}, {"capacity"=>"250", "description"=>"250 GB iSCSI SAN Storage", "id"=>552, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_250_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>612}, {"capacity"=>"20", "description"=>"20GB EVault Disk to Disk Enterprise Backup", "id"=>558, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_20_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>739}, {"capacity"=>"500", "description"=>"500 GB NAS", "id"=>611, "itemTaxCategoryId"=>166, "keyName"=>"NAS_500_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>605}, {"description"=>"Microsoft SQL Server 2008 Workgroup", "id"=>684, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WORKGROUP", "softwareDescriptionId"=>304, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"Virtuozzo Containers 4 for Linux - 5 VPS", "id"=>740, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_5_VPS", "softwareDescriptionId"=>317, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard Edition SP2 (64bit)", "id"=>936, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_SP2", "softwareDescriptionId"=>447, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Enterprise Edition (64bit)", "id"=>978, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_64_BIT_R2_2", "softwareDescriptionId"=>477, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Datacenter Edition With Hyper-V (64bit)", "id"=>980, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_R2_2", "softwareDescriptionId"=>478, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"RAID 0", "id"=>488, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_0", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"RAID 10", "id"=>491, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_10", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix Essentials for XenServer 5.5 (Billed per VM)", "id"=>1077, "itemTaxCategoryId"=>166, "keyName"=>"CITRIX_ESSENTIALS_XENSERVER_5_5", "softwareDescriptionId"=>521, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"60", "description"=>"60 GB Registered DDR3 1333", "id"=>948, "itemTaxCategoryId"=>166, "keyName"=>"RAM_60_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"72", "description"=>"72 GB Registered DDR3 1333", "id"=>829, "itemTaxCategoryId"=>166, "keyName"=>"RAM_72_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"96", "description"=>"96 GB Registered DDR3 1333", "id"=>1050, "itemTaxCategoryId"=>166, "keyName"=>"RAM_96_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Workgroup R2", "id"=>1164, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WORKGROUP_R2", "softwareDescriptionId"=>697, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Redundant Public & Private Network Uplinks", "id"=>1284, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_REDUNDANT_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 10 (Linux) Unlimited Domain w/ Power Pack", "id"=>1306, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_LINUX_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>939, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 5.6.1", "id"=>1322, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6_1", "softwareDescriptionId"=>801, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x (32 bit)", "id"=>3904, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_32_BIT", "softwareDescriptionId"=>1258, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 6.x Squeeze/Stable (32 bit)", "id"=>3967, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_6_X_SQUEEZE_32_BIT", "softwareDescriptionId"=>918, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESX 4.1", "id"=>3969, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESX_4_1", "softwareDescriptionId"=>800, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 5.x (64 bit)", "id"=>4093, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_5_X_64_BIT_3", "softwareDescriptionId"=>1158, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Express Edition", "id"=>4150, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_EXPRESS", "softwareDescriptionId"=>1005, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1500", "description"=>"1500GB EVault Disk to Disk Enterprise Backup", "id"=>4185, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_1500_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>955}, {"capacity"=>"0", "description"=>"Windows Server 2012 Datacenter Edition (64bit)", "id"=>4237, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_DC_64_BIT", "softwareDescriptionId"=>1082, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 1 Pack", "id"=>4345, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_1_PACK", "softwareDescriptionId"=>1094, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 25 Pack", "id"=>4348, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_25_PACK", "softwareDescriptionId"=>1097, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable (64 bit)", "id"=>4405, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_64_BIT", "softwareDescriptionId"=>1104, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware vCenter 5.5 Standard", "id"=>4598, "itemTaxCategoryId"=>166, "keyName"=>"VMWARE_VCENTER_5_5_STANDARD", "softwareDescriptionId"=>1275, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr - Minimal Install (64 bit)", "id"=>4710, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_MINIMAL_64_BIT_2", "softwareDescriptionId"=>1346, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 12 - 30 Domain w/ Power Pack", "id"=>6010, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_12_30_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1414, "upgradeItemId"=>nil}, {"capacity"=>"8", "description"=>"8 Public IP Addresses", "id"=>17, "itemTaxCategoryId"=>166, "keyName"=>"8_PUBLIC_IP_ADDRESSES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"MySQL 5.0 for Windows", "id"=>23, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_0_WINDOWS", "softwareDescriptionId"=>13, "upgradeItemId"=>nil}, {"description"=>"Email and Ticket", "id"=>51, "itemTaxCategoryId"=>166, "keyName"=>"NOTIFICATION_EMAIL_AND_TICKET", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"NOC Monitoring", "id"=>54, "itemTaxCategoryId"=>166, "keyName"=>"NOC_MONITORING", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"cPanel/WHM with Fantastico and RVskin", "id"=>96, "itemTaxCategoryId"=>166, "keyName"=>"CPANELWHM_WITH_FANTASTICO_AND_RVSKIN", "softwareDescriptionId"=>31, "upgradeItemId"=>nil}, {"description"=>"Unlimited Bandwidth (100 Mbps Uplink)", "id"=>97, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_UNLIMITED_100_MBPS_UPLINK", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Reboot / KVM over IP", "id"=>504, "itemTaxCategoryId"=>166, "keyName"=>"REBOOT_KVM_OVER_IP", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1000 GB iSCSI SAN Storage", "id"=>554, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_1000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>783}, {"capacity"=>"150", "description"=>"Virtuozzo Containers 4 for Linux - 150 VPS", "id"=>746, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_150_VPS", "softwareDescriptionId"=>324, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"50", "description"=>"Virtuozzo Containers 4 for Linux - 50 VPS", "id"=>743, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_50_VPS", "softwareDescriptionId"=>321, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard Edition SP2 (32bit)", "id"=>933, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_32_BIT_SP2", "softwareDescriptionId"=>444, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Enterprise Edition SP2 (64bit)", "id"=>938, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_64_BIT_SP2", "softwareDescriptionId"=>449, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Datacenter Edition SP2 (64bit)", "id"=>940, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_SP2", "softwareDescriptionId"=>451, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Citrix XenServer 5.5", "id"=>950, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_5", "softwareDescriptionId"=>642, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Web Edition (64bit)", "id"=>976, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_64_BIT_R2_SP1", "softwareDescriptionId"=>832, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Standard SP2 with R2 (32 bit)", "id"=>421, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_STD_32_BIT_SP2_WR2", "softwareDescriptionId"=>125, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Web Edition SP2 (32bit)", "id"=>934, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_32_BIT_SP2", "softwareDescriptionId"=>445, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"RAID 1", "id"=>489, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_1", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"RAID 5", "id"=>490, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_5", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2.00 TB SATA II", "id"=>1091, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_2_00TB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"12", "description"=>"12 GB Registered DDR3 1333", "id"=>824, "itemTaxCategoryId"=>166, "keyName"=>"RAM_12_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"36", "description"=>"36 GB Registered DDR3 1333", "id"=>827, "itemTaxCategoryId"=>166, "keyName"=>"RAM_36_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Enterprise for XenServer 5.6", "id"=>1300, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ENTERPRISE_FOR_XENSERVER_5_6", "softwareDescriptionId"=>726, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin - Minimal Install (64 bit)", "id"=>4170, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_MINIMAL_64_BIT_2", "softwareDescriptionId"=>1184, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Windows) Unlimited Domain w/ Power Pack", "id"=>4200, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_WINDOWS_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1274, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.1", "id"=>4258, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_1", "softwareDescriptionId"=>1065, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware vCenter 5.1 Standard", "id"=>4298, "itemTaxCategoryId"=>166, "keyName"=>"VMWARE_VCENTER_5_1_STANDARD", "softwareDescriptionId"=>1090, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (4 TB)", "id"=>4372, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_4_TB", "softwareDescriptionId"=>1123, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"20", "description"=>"20Mbps Hardware Firewall", "id"=>4550, "itemTaxCategoryId"=>166, "keyName"=>"20MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.2.1", "id"=>4569, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_2_1", "softwareDescriptionId"=>1257, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MySQL 5.7 for Windows", "id"=>4592, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_7_WINDOWS", "softwareDescriptionId"=>1272, "upgradeItemId"=>nil}, {"capacity"=>"10000", "description"=>"10 Gbps Dual Private Network Uplinks (Unbonded)", "id"=>5102, "itemTaxCategoryId"=>166, "keyName"=>"10_GBPS_DUAL_PRIVATE_NETWORK_UPLINKS_UNBONDED", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Enterprise Edition", "id"=>5120, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_ENTERPRISE_EDITION_2", "softwareDescriptionId"=>1330, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Enterprise", "id"=>81, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_ENTERPRISE", "softwareDescriptionId"=>21, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Public & Private Network Uplinks", "id"=>187, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>188}, {"capacity"=>"1000", "description"=>"1000Mbps Hardware Firewall", "id"=>297, "itemTaxCategoryId"=>166, "keyName"=>"1000MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x (64 bit)", "id"=>420, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_64_BIT", "softwareDescriptionId"=>1240, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Enterprise SP2 with R2 (32 bit)", "id"=>423, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_ENT_32_BIT_SP2_WR2", "softwareDescriptionId"=>128, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 8.x (32 bit)", "id"=>1066, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_8_X_32_BIT", "softwareDescriptionId"=>1022, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"60", "description"=>"60GB EVault Disk to Disk Enterprise Backup", "id"=>1076, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_60_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>560}, {"capacity"=>"2", "description"=>"Monitoring Package - Advanced", "id"=>1249, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_ADVANCED", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"capacity"=>"10000", "description"=>"10 Gbps Public & Private Network Uplinks", "id"=>1281, "itemTaxCategoryId"=>166, "keyName"=>"10_GBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"50", "description"=>"50GB EVault Disk to Disk Enterprise Backup", "id"=>3784, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_50_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>1076}, {"description"=>"Parallels Plesk Panel 10 (Windows) 100 Domain w/ Power Pack", "id"=>3786, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_WINDOWS_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>787, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x (64 bit)", "id"=>3907, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_64_BIT", "softwareDescriptionId"=>1261, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Redundant Private Network Uplinks", "id"=>3956, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"3000", "description"=>"3.00 TB SATA III", "id"=>3989, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_3_00TB_SATA_III", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Enterprise for XenServer 6.x", "id"=>4105, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ENTERPRISE_FOR_XENSERVER_6_X", "softwareDescriptionId"=>909, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 1 Pack", "id"=>4153, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_1_PACK", "softwareDescriptionId"=>1015, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin (32 bit)", "id"=>4165, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_32_BIT", "softwareDescriptionId"=>1166, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Dual Public & Private Network Uplinks (Unbonded)", "id"=>4263, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_DUAL_PUBLIC_PRIVATE_NETWORK_UPLINKS_UNBONDED", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"4000", "description"=>"4.00 TB SATA III", "id"=>4281, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_4_00TB_SATA_III", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x (64 bit) (per-processor licensing)", "id"=>4321, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_64_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1247, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable - Minimal Install (32 bit)", "id"=>4406, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_MINIMAL_32_BIT", "softwareDescriptionId"=>1176, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable - Minimal Install (64 bit)", "id"=>4407, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_MINIMAL_64_BIT", "softwareDescriptionId"=>1177, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MySQL 5.0.51 for Windows", "id"=>4557, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_0_51_WINDOWS", "softwareDescriptionId"=>220, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESXi 5.5", "id"=>4562, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESXI_5_5", "softwareDescriptionId"=>1256, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 10.x (32 bit)", "id"=>4640, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_10_X_32_BIT", "softwareDescriptionId"=>1284, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 10.x (64 bit)", "id"=>4638, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_10_X_64_BIT", "softwareDescriptionId"=>1286, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr (64 bit)", "id"=>4702, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_64_BIT", "softwareDescriptionId"=>1362, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Express Edition", "id"=>5122, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_EXPRESS_EDITION", "softwareDescriptionId"=>1332, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 12 - Unlimited Domain w/ Power Pack", "id"=>6014, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_12_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1420, "upgradeItemId"=>nil}, {"capacity"=>"4", "description"=>"4 Public IP Addresses", "id"=>16, "itemTaxCategoryId"=>166, "keyName"=>"4_PUBLIC_IP_ADDRESSES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Unlimited Bandwidth (10 Mbps Uplink)", "id"=>30, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_UNLIMITED_10_MBPS_UPLINK", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB NAS", "id"=>43, "itemTaxCategoryId"=>166, "keyName"=>"NAS_100_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>44}, {"description"=>"Business Continuance Insurance", "id"=>84, "itemTaxCategoryId"=>108, "keyName"=>"BUSINESS_CONTINUANCE_INSURANCE", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100GB EVault Disk to Disk Enterprise Backup", "id"=>560, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_100_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4182}, {"capacity"=>"30", "description"=>"Virtuozzo Containers 4 for Linux - 30 VPS", "id"=>742, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_30_VPS", "softwareDescriptionId"=>320, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"64", "description"=>"/64 Block Static Public IPv6 Addresses", "id"=>784, "itemTaxCategoryId"=>166, "keyName"=>"64_BLOCK_STATIC_PUBLIC_IPV6_ADDRESSES", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESX 4.0", "id"=>1078, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESX_4_0", "softwareDescriptionId"=>497, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"48", "description"=>"48 GB Registered DDR3 1333", "id"=>828, "itemTaxCategoryId"=>166, "keyName"=>"RAM_48_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx (64 bit)", "id"=>1137, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_64_BIT", "softwareDescriptionId"=>775, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Enterprise R2", "id"=>1165, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_ENTERPRISE_R2", "softwareDescriptionId"=>699, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Datacenter R2", "id"=>1166, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_DATACENTER_R2", "softwareDescriptionId"=>700, "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Monitoring Package - Basic", "id"=>1248, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_BASIC", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2000Mbps Hardware Firewall", "id"=>1296, "itemTaxCategoryId"=>166, "keyName"=>"2000MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Advanced for XenServer 5.6", "id"=>1299, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ADVANCED_FOR_XENSERVER_5_6", "softwareDescriptionId"=>726, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"EVault Plugin - BMR (Bare Metal Restore)", "id"=>961, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_PLUGIN_BMR_BARE_METAL_RESTORE", "softwareDescriptionId"=>467, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 5.6.2", "id"=>3886, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6_2", "softwareDescriptionId"=>867, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Advanced for XenServer 6.x", "id"=>4104, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ADVANCED_FOR_XENSERVER_6_X", "softwareDescriptionId"=>908, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 9.x (64 bit)", "id"=>4138, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_9_X_64_BIT", "softwareDescriptionId"=>1265, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"400", "description"=>"400 GB SSD", "id"=>4181, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_400GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Cloudera Distribution for Hadoop 4", "id"=>4301, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_CLOUDERA_DISTRIBUTION_HADOOP_4", "softwareDescriptionId"=>1099, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x (32 bit) (per-processor licensing)", "id"=>4320, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_32_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1246, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Riak 1.x", "id"=>4327, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_RIAK_1_X", "softwareDescriptionId"=>1114, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Redundant Private Network Uplinks", "id"=>4331, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Redundant Public & Private Network Uplinks", "id"=>4336, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_REDUNDANT_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>1284}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (48 TB)", "id"=>4370, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_48_TB", "softwareDescriptionId"=>1154, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Standard Edition (64 bit)", "id"=>4549, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_STD_64_BIT", "softwareDescriptionId"=>1225, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Express", "id"=>24, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_EXPRESS", "softwareDescriptionId"=>9, "upgradeItemId"=>nil}, {"capacity"=>"40", "description"=>"40 GB NAS", "id"=>41, "itemTaxCategoryId"=>166, "keyName"=>"NAS_40_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>42}, {"description"=>"Host Ping", "id"=>49, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_HOST_PING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Automated Notification", "id"=>52, "itemTaxCategoryId"=>166, "keyName"=>"AUTOMATED_NOTIFICATION", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Automated Reboot from Monitoring", "id"=>53, "itemTaxCategoryId"=>166, "keyName"=>"AUTOMATED_REBOOT_FROM_MONITORING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"300", "description"=>"300 GB SA-SCSI 15K RPM", "id"=>352, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_300GB_SASCSI_15K_RPM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"500", "description"=>"500 GB iSCSI SAN Storage", "id"=>553, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_500_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>621}, {"capacity"=>"500", "description"=>"500GB EVault Disk to Disk Enterprise Backup", "id"=>562, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_500_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4184}, {"capacity"=>"120", "description"=>"120 GB iSCSI SAN Storage", "id"=>575, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_120_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>622}, {"capacity"=>"0", "description"=>"FreeBSD 7.x  (32 bit)", "id"=>638, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_7_X_32_BIT", "softwareDescriptionId"=>666, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Virtuozzo Containers 4 for Linux - 3 VPS", "id"=>738, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_3_VPS", "softwareDescriptionId"=>319, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"Virtuozzo Containers 4 for Linux - 100 VPS", "id"=>745, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_100_VPS", "softwareDescriptionId"=>323, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Web Edition SP2 (64bit)", "id"=>935, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_64_BIT_SP2", "softwareDescriptionId"=>446, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Cloudera Distribution for Hadoop 2", "id"=>1044, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_CLOUDERA_DISTRIBUTION_HADOOP_2", "softwareDescriptionId"=>520, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"144", "description"=>"144 GB Registered DDR3 1333", "id"=>1011, "itemTaxCategoryId"=>166, "keyName"=>"RAM_144_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"description"=>"Citrix XenServer 5.6", "id"=>1189, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6", "softwareDescriptionId"=>704, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft WebMatrix", "id"=>3898, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_WEBMATRIX_2", "softwareDescriptionId"=>868, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"International Services", "id"=>3955, "itemTaxCategoryId"=>166, "keyName"=>"INTERNATIONAL_SERVICES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 6.x (32 bit)", "id"=>4094, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_6_X_32_BIT_2", "softwareDescriptionId"=>1172, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 6.x (64 bit)", "id"=>4095, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_6_X_64_BIT", "softwareDescriptionId"=>1175, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"64", "description"=>"1 IPv6 Address", "id"=>4097, "itemTaxCategoryId"=>166, "keyName"=>"1_IPV6_ADDRESS", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Web Edition", "id"=>4147, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_WEB", "softwareDescriptionId"=>1004, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Enterprise Edition", "id"=>4149, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_ENTERPRISE", "softwareDescriptionId"=>1001, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MongoDB", "id"=>4226, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MONGODB", "softwareDescriptionId"=>1083, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 Datacenter Edition With Hyper-V (64bit)", "id"=>4247, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_DC_64_BIT_2", "softwareDescriptionId"=>1082, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x (32 bit) (per-processor licensing)", "id"=>4318, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_32_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1227, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Redundant Public & Private Network Uplinks", "id"=>4332, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_REDUNDANT_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>4336}, {"capacity"=>"0", "description"=>"Idera Server Backup 5.0 Enterprise (Windows)", "id"=>4344, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_SERVER_BACKUP_5_0_ENTERPRISE_WINDOWS", "softwareDescriptionId"=>1092, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 5 Pack", "id"=>4346, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_5_PACK", "softwareDescriptionId"=>1095, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"0 GB Bandwidth", "id"=>4481, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_0_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Datacenter Edition (64bit)", "id"=>4547, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_DC_64_BIT", "softwareDescriptionId"=>1226, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"200", "description"=>"200Mbps Hardware Firewall", "id"=>4551, "itemTaxCategoryId"=>166, "keyName"=>"200MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"cPanel/WHM with Softaculous and RVskin", "id"=>4608, "itemTaxCategoryId"=>166, "keyName"=>"CPANELWHM_WITH_SOFTACULOUS_AND_RVSKIN", "softwareDescriptionId"=>1292, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr - Minimal Install (32 bit)", "id"=>4708, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_MINIMAL_32_BIT_2", "softwareDescriptionId"=>1350, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 7.x (64 bit)", "id"=>5920, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_7_X_64_BIT", "softwareDescriptionId"=>1400, "units"=>"N/A", "upgradeItemId"=>nil}]
          fixture_package_items[53] = [{"capacity"=>"20", "description"=>"20 GB NAS", "id"=>40, "itemTaxCategoryId"=>166, "keyName"=>"NAS_20_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>41}, {"description"=>"Microsoft SQL Server 2005 Standard", "id"=>79, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_STANDARD", "softwareDescriptionId"=>8, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10Mbps Hardware Firewall", "id"=>299, "itemTaxCategoryId"=>166, "keyName"=>"10MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"Unlimited SSL VPN Users & 1 PPTP VPN User per account", "id"=>309, "itemTaxCategoryId"=>166, "keyName"=>"UNLIMITED_SSL_VPN_USERS_1_PPTP_VPN_USER_PER_ACCOUNT", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Enterprise SP2 with R2 (64 bit)", "id"=>424, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_ENT_64_BIT_SP2_WR2", "softwareDescriptionId"=>127, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Standard SP2 with R2 (64 bit)", "id"=>422, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_STD_64_BIT_SP2_WR2", "softwareDescriptionId"=>126, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB iSCSI SAN Storage", "id"=>551, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_100_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>575}, {"capacity"=>"40", "description"=>"40GB EVault Disk to Disk Enterprise Backup", "id"=>559, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_40_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>3784}, {"capacity"=>"1000", "description"=>"1000GB EVault Disk to Disk Enterprise Backup", "id"=>563, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_1000_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4185}, {"capacity"=>"0", "description"=>"FreeBSD 7.x  (64 bit)", "id"=>637, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_7_X_64_BIT", "softwareDescriptionId"=>667, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Web", "id"=>685, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WEB", "softwareDescriptionId"=>305, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Enterprise Edition SP2 (32bit)", "id"=>937, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_32_BIT_SP2", "softwareDescriptionId"=>448, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2000GB EVault Disk to Disk Enterprise Backup", "id"=>955, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_2000_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Web R2", "id"=>1163, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WEB_R2", "softwareDescriptionId"=>696, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Express R2", "id"=>1162, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_EXPRESS_R2", "softwareDescriptionId"=>701, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 10 (Linux) 100 Domain w/ Power Pack", "id"=>1305, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_LINUX_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>938, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"200", "description"=>"200 GB SSD", "id"=>3811, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_200GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 6.x Squeeze/Stable (64 bit)", "id"=>3968, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_6_X_SQUEEZE_64_BIT", "softwareDescriptionId"=>919, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.0.0", "id"=>3977, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_0_0", "softwareDescriptionId"=>836, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 5.x (32 bit)", "id"=>4092, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_5_X_32_BIT_2", "softwareDescriptionId"=>1156, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.0.2", "id"=>4133, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_0_2", "softwareDescriptionId"=>961, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin - Minimal Install (32 bit)", "id"=>4169, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_MINIMAL_32_BIT", "softwareDescriptionId"=>1186, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"350", "description"=>"350GB EVault Disk to Disk Enterprise Backup", "id"=>4183, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_350_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>562}, {"capacity"=>"750", "description"=>"750GB EVault Disk to Disk Enterprise Backup", "id"=>4184, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_750_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>563}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Linux) 100 Domain w/ Power Pack", "id"=>4195, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_LINUX_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1191, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Windows) 100 Domain w/ Power Pack", "id"=>4199, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_WINDOWS_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1273, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 1 VM", "id"=>4303, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_1_VM", "softwareDescriptionId"=>1105, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - Unlimited VMs", "id"=>4307, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_UNLIMITED_VMS", "softwareDescriptionId"=>1112, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Redundant Private Network Uplinks", "id"=>4335, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.2", "id"=>4467, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_2", "softwareDescriptionId"=>1171, "upgradeItemId"=>nil}, {"capacity"=>"80", "description"=>"80 GB NAS", "id"=>42, "itemTaxCategoryId"=>166, "keyName"=>"NAS_80_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>43}, {"capacity"=>"250", "description"=>"250 GB NAS", "id"=>44, "itemTaxCategoryId"=>166, "keyName"=>"NAS_250_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>411}, {"description"=>"APF Software Firewall for Linux", "id"=>300, "itemTaxCategoryId"=>166, "keyName"=>"APF_SOFTWARE_FIREWALL_FOR_LINUX", "softwareDescriptionId"=>71, "upgradeItemId"=>nil}, {"description"=>"Nessus Vulnerability Assessment & Reporting", "id"=>307, "itemTaxCategoryId"=>98, "keyName"=>"NESSUS_VULNERABILITY_ASSESSMENT_REPORTING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"McAfee VirusScan Enterprise", "id"=>397, "itemTaxCategoryId"=>98, "keyName"=>"MCAFEE_VIRUSSCAN_ANTIVIRUS_WINDOWS", "softwareDescriptionId"=>820, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x (32 bit)", "id"=>419, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_32_BIT", "softwareDescriptionId"=>1239, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Non-RAID", "id"=>487, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_NONRAID", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Microsoft Windows Firewall", "id"=>495, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_WINDOWS_FIREWALL", "softwareDescriptionId"=>106, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Private Network Uplink", "id"=>498, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"80", "description"=>"80 GB iSCSI SAN Storage", "id"=>550, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_80_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>551}, {"capacity"=>"250", "description"=>"250GB EVault Disk to Disk Enterprise Backup", "id"=>561, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_250_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4183}, {"description"=>"Microsoft SQL Server 2008 Express", "id"=>681, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_EXPRESS", "softwareDescriptionId"=>308, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Enterprise", "id"=>682, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_ENTERPRISE", "softwareDescriptionId"=>307, "upgradeItemId"=>nil}, {"capacity"=>"30", "description"=>"30GB EVault Disk to Disk Enterprise Backup", "id"=>739, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_30_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>559}, {"capacity"=>"10", "description"=>"Virtuozzo Containers 4 for Linux - 10 VPS", "id"=>741, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_10_VPS", "softwareDescriptionId"=>318, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Datacenter Edition SP2 (32bit)", "id"=>939, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_32_BIT_SP2", "softwareDescriptionId"=>450, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Standard R2", "id"=>1161, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_STANDARD_R2", "softwareDescriptionId"=>698, "upgradeItemId"=>nil}, {"capacity"=>"3000", "description"=>"3000 GB iSCSI SAN Storage", "id"=>1176, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_3000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"3", "description"=>"Monitoring Package - Premium Application", "id"=>1250, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_PREMIUM_APPLICATION", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 10 (Windows) Unlimited Domain w/ Power Pack", "id"=>3785, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_WINDOWS_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>788, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Standard Edition", "id"=>4148, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_STANDARD", "softwareDescriptionId"=>1003, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 Standard Edition (64 bit)", "id"=>4233, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_STD_64_BIT", "softwareDescriptionId"=>1076, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"4", "description"=>"4 GB Registered DDR3 1333", "id"=>1039, "itemTaxCategoryId"=>166, "keyName"=>"RAM_4_GB_DDR3_1333_ECC_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESXi 5.1", "id"=>4272, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESXI_5_1", "softwareDescriptionId"=>1086, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 5 VMs", "id"=>4304, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_5_VMS", "softwareDescriptionId"=>1109, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 10 VMs", "id"=>4305, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_10_VMS", "softwareDescriptionId"=>1110, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"15", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 15 VMs", "id"=>4306, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_15_VMS", "softwareDescriptionId"=>1111, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x (64 bit) (per-processor licensing)", "id"=>4319, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_64_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1228, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable (32 bit)", "id"=>4404, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_32_BIT", "softwareDescriptionId"=>1169, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"RAID", "id"=>4478, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Datacenter Edition With Hyper-V (64bit)", "id"=>4548, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_DC_64_BIT_2", "softwareDescriptionId"=>1226, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Host Ping and TCP Service Monitoring", "id"=>50, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_HOST_PING_AND_TCP_SERVICE", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"McAfee Host Intrusion Protection w/Reporting", "id"=>302, "itemTaxCategoryId"=>98, "keyName"=>"MCAFEE_HOST_INTRUSION_PROTECTION_WREPORTING", "softwareDescriptionId"=>916, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"0 GB Bandwidth", "id"=>439, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_0_GB_2", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1.00 TB SATA II", "id"=>471, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_1_00TB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Private Network Uplink", "id"=>497, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>498}, {"capacity"=>"20", "description"=>"20 GB iSCSI SAN Storage", "id"=>548, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_20_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>549}, {"capacity"=>"40", "description"=>"40 GB iSCSI SAN Storage", "id"=>549, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_40_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>598}, {"capacity"=>"2000", "description"=>"2000 GB iSCSI SAN Storage", "id"=>626, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_2000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>1176}, {"description"=>"Microsoft SQL Server 2008 Standard", "id"=>683, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_STANDARD", "softwareDescriptionId"=>306, "upgradeItemId"=>nil}, {"capacity"=>"70", "description"=>"Virtuozzo Containers 4 for Linux - 70 VPS", "id"=>744, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_70_VPS", "softwareDescriptionId"=>322, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Standard Edition (64bit)", "id"=>977, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_R2", "softwareDescriptionId"=>475, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Datacenter Edition (64bit)", "id"=>979, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_R2", "softwareDescriptionId"=>478, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 8.x (64 bit)", "id"=>1065, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_8_X_64_BIT_2", "softwareDescriptionId"=>1019, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"600", "description"=>"600 GB SA-SCSI 15K RPM", "id"=>1094, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_600GB_SASCSI_15K_RPM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx (32 bit)", "id"=>1136, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_32_BIT", "softwareDescriptionId"=>774, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 9.x (32 bit)", "id"=>4137, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_9_X_32_BIT_2", "softwareDescriptionId"=>1264, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin (64 bit)", "id"=>4166, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_64_BIT", "softwareDescriptionId"=>1165, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"175", "description"=>"175GB EVault Disk to Disk Enterprise Backup", "id"=>4182, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_175_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>561}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Linux) Unlimited Domain w/ Power Pack", "id"=>4197, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_LINUX_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1197, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"20", "description"=>"20 GB Registered DDR3 1333", "id"=>1034, "itemTaxCategoryId"=>166, "keyName"=>"RAM_20_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"24", "description"=>"24 GB Registered DDR3 1333", "id"=>826, "itemTaxCategoryId"=>166, "keyName"=>"RAM_24_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"800", "description"=>"800 GB SSD", "id"=>4356, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_800GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (128 TB)", "id"=>4369, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_128_TB", "softwareDescriptionId"=>1155, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (16 TB)", "id"=>4371, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_16_TB", "softwareDescriptionId"=>1153, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Vyatta 6.x Subscription Edition (64 bit)", "id"=>4396, "itemTaxCategoryId"=>166, "keyName"=>"OS_VYATTA_6_X_SUBSCRIPTION_EDITION_64_BIT_2", "softwareDescriptionId"=>1221, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Standard Edition", "id"=>5124, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_STANDARD_EDITION", "softwareDescriptionId"=>1334, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"MySQL for Linux", "id"=>22, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_LINUX", "softwareDescriptionId"=>156, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Workgroup", "id"=>80, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_WORKGROUP", "softwareDescriptionId"=>20, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100Mbps Hardware Firewall", "id"=>298, "itemTaxCategoryId"=>166, "keyName"=>"100MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"500", "description"=>"500 GB SATA II", "id"=>14, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_500GB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"RAID 0", "id"=>488, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_0", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"RAID 10", "id"=>491, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_10", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Private Network Uplink", "id"=>496, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>497}, {"capacity"=>"250", "description"=>"250 GB iSCSI SAN Storage", "id"=>552, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_250_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>612}, {"capacity"=>"20", "description"=>"20GB EVault Disk to Disk Enterprise Backup", "id"=>558, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_20_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>739}, {"capacity"=>"500", "description"=>"500 GB NAS", "id"=>611, "itemTaxCategoryId"=>166, "keyName"=>"NAS_500_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>605}, {"description"=>"Microsoft SQL Server 2008 Workgroup", "id"=>684, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WORKGROUP", "softwareDescriptionId"=>304, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"Virtuozzo Containers 4 for Linux - 5 VPS", "id"=>740, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_5_VPS", "softwareDescriptionId"=>317, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard Edition SP2 (64bit)", "id"=>936, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_SP2", "softwareDescriptionId"=>447, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Enterprise Edition (64bit)", "id"=>978, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_64_BIT_R2_2", "softwareDescriptionId"=>477, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Datacenter Edition With Hyper-V (64bit)", "id"=>980, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_R2_2", "softwareDescriptionId"=>478, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix Essentials for XenServer 5.5 (Billed per VM)", "id"=>1077, "itemTaxCategoryId"=>166, "keyName"=>"CITRIX_ESSENTIALS_XENSERVER_5_5", "softwareDescriptionId"=>521, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Workgroup R2", "id"=>1164, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WORKGROUP_R2", "softwareDescriptionId"=>697, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 10 (Linux) Unlimited Domain w/ Power Pack", "id"=>1306, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_LINUX_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>939, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 5.6.1", "id"=>1322, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6_1", "softwareDescriptionId"=>801, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x (32 bit)", "id"=>3904, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_32_BIT", "softwareDescriptionId"=>1258, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 6.x Squeeze/Stable (32 bit)", "id"=>3967, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_6_X_SQUEEZE_32_BIT", "softwareDescriptionId"=>918, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESX 4.1", "id"=>3969, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESX_4_1", "softwareDescriptionId"=>800, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 5.x (64 bit)", "id"=>4093, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_5_X_64_BIT_3", "softwareDescriptionId"=>1158, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Express Edition", "id"=>4150, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_EXPRESS", "softwareDescriptionId"=>1005, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1500", "description"=>"1500GB EVault Disk to Disk Enterprise Backup", "id"=>4185, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_1500_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>955}, {"capacity"=>"0", "description"=>"Windows Server 2012 Datacenter Edition (64bit)", "id"=>4237, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_DC_64_BIT", "softwareDescriptionId"=>1082, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard SP1 with R2 (64 bit)", "id"=>4248, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_R2_SP1", "softwareDescriptionId"=>831, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable (64 bit)", "id"=>4405, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_64_BIT", "softwareDescriptionId"=>1104, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware vCenter 5.5 Standard", "id"=>4598, "itemTaxCategoryId"=>166, "keyName"=>"VMWARE_VCENTER_5_5_STANDARD", "softwareDescriptionId"=>1275, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 12 - 30 Domain w/ Power Pack", "id"=>6010, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_12_30_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1414, "upgradeItemId"=>nil}, {"description"=>"MySQL 5.0 for Windows", "id"=>23, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_0_WINDOWS", "softwareDescriptionId"=>13, "upgradeItemId"=>nil}, {"description"=>"Email and Ticket", "id"=>51, "itemTaxCategoryId"=>166, "keyName"=>"NOTIFICATION_EMAIL_AND_TICKET", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"NOC Monitoring", "id"=>54, "itemTaxCategoryId"=>166, "keyName"=>"NOC_MONITORING", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"cPanel/WHM with Fantastico and RVskin", "id"=>96, "itemTaxCategoryId"=>166, "keyName"=>"CPANELWHM_WITH_FANTASTICO_AND_RVSKIN", "softwareDescriptionId"=>31, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Standard SP2 with R2 (32 bit)", "id"=>421, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_STD_32_BIT_SP2_WR2", "softwareDescriptionId"=>125, "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"RAID 1", "id"=>489, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_1", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"RAID 5", "id"=>490, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_5", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Reboot / KVM over IP", "id"=>504, "itemTaxCategoryId"=>166, "keyName"=>"REBOOT_KVM_OVER_IP", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1000 GB iSCSI SAN Storage", "id"=>554, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_1000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>783}, {"capacity"=>"150", "description"=>"Virtuozzo Containers 4 for Linux - 150 VPS", "id"=>746, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_150_VPS", "softwareDescriptionId"=>324, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"50", "description"=>"Virtuozzo Containers 4 for Linux - 50 VPS", "id"=>743, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_50_VPS", "softwareDescriptionId"=>321, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard Edition SP2 (32bit)", "id"=>933, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_32_BIT_SP2", "softwareDescriptionId"=>444, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Web Edition SP2 (32bit)", "id"=>934, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_32_BIT_SP2", "softwareDescriptionId"=>445, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Enterprise Edition SP2 (64bit)", "id"=>938, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_64_BIT_SP2", "softwareDescriptionId"=>449, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Datacenter Edition SP2 (64bit)", "id"=>940, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_SP2", "softwareDescriptionId"=>451, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Citrix XenServer 5.5", "id"=>950, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_5", "softwareDescriptionId"=>642, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Web Edition (64bit)", "id"=>976, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_64_BIT_R2_SP1", "softwareDescriptionId"=>832, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2.00 TB SATA II", "id"=>1091, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_2_00TB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Enterprise for XenServer 5.6", "id"=>1300, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ENTERPRISE_FOR_XENSERVER_5_6", "softwareDescriptionId"=>726, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin - Minimal Install (64 bit)", "id"=>4170, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_MINIMAL_64_BIT_2", "softwareDescriptionId"=>1184, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Windows) Unlimited Domain w/ Power Pack", "id"=>4200, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_WINDOWS_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1274, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"12", "description"=>"12 GB Registered DDR3 1333", "id"=>824, "itemTaxCategoryId"=>166, "keyName"=>"RAM_12_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.1", "id"=>4258, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_1", "softwareDescriptionId"=>1065, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware vCenter 5.1 Standard", "id"=>4298, "itemTaxCategoryId"=>166, "keyName"=>"VMWARE_VCENTER_5_1_STANDARD", "softwareDescriptionId"=>1090, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (4 TB)", "id"=>4372, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_4_TB", "softwareDescriptionId"=>1123, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Vyatta 6.6 Community Edition (64 bit)", "id"=>4495, "itemTaxCategoryId"=>166, "keyName"=>"OS_VYATTA_6_6_COMMUNITY_EDITION_64_BIT", "softwareDescriptionId"=>1192, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"20", "description"=>"20Mbps Hardware Firewall", "id"=>4550, "itemTaxCategoryId"=>166, "keyName"=>"20MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.2.1", "id"=>4569, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_2_1", "softwareDescriptionId"=>1257, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MySQL 5.7 for Windows", "id"=>4592, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_7_WINDOWS", "softwareDescriptionId"=>1272, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Enterprise Edition", "id"=>5120, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_ENTERPRISE_EDITION_2", "softwareDescriptionId"=>1330, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Enterprise", "id"=>81, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_ENTERPRISE", "softwareDescriptionId"=>21, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1000Mbps Hardware Firewall", "id"=>297, "itemTaxCategoryId"=>166, "keyName"=>"1000MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x (64 bit)", "id"=>420, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_64_BIT", "softwareDescriptionId"=>1240, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Enterprise SP2 with R2 (32 bit)", "id"=>423, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_ENT_32_BIT_SP2_WR2", "softwareDescriptionId"=>128, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 8.x (32 bit)", "id"=>1066, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_8_X_32_BIT", "softwareDescriptionId"=>1022, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"60", "description"=>"60GB EVault Disk to Disk Enterprise Backup", "id"=>1076, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_60_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>560}, {"capacity"=>"2", "description"=>"Monitoring Package - Advanced", "id"=>1249, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_ADVANCED", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"capacity"=>"50", "description"=>"50GB EVault Disk to Disk Enterprise Backup", "id"=>3784, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_50_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>1076}, {"description"=>"Parallels Plesk Panel 10 (Windows) 100 Domain w/ Power Pack", "id"=>3786, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_WINDOWS_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>787, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x (64 bit)", "id"=>3907, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_64_BIT", "softwareDescriptionId"=>1261, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Redundant Private Network Uplinks", "id"=>3956, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"3000", "description"=>"3.00 TB SATA III", "id"=>3989, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_3_00TB_SATA_III", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Enterprise for XenServer 6.x", "id"=>4105, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ENTERPRISE_FOR_XENSERVER_6_X", "softwareDescriptionId"=>909, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin (32 bit)", "id"=>4165, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_32_BIT", "softwareDescriptionId"=>1166, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"4000", "description"=>"4.00 TB SATA III", "id"=>4281, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_4_00TB_SATA_III", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Vyatta 6.5 Community Edition (64 bit)", "id"=>4315, "itemTaxCategoryId"=>166, "keyName"=>"OS_VYATTA_6_5_COMMUNITY_EDITION_64_BIT", "softwareDescriptionId"=>1106, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x (64 bit) (per-processor licensing)", "id"=>4321, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_64_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1247, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable - Minimal Install (32 bit)", "id"=>4406, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_MINIMAL_32_BIT", "softwareDescriptionId"=>1176, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable - Minimal Install (64 bit)", "id"=>4407, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_MINIMAL_64_BIT", "softwareDescriptionId"=>1177, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MySQL 5.0.51 for Windows", "id"=>4557, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_0_51_WINDOWS", "softwareDescriptionId"=>220, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESXi 5.5", "id"=>4562, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESXI_5_5", "softwareDescriptionId"=>1256, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 10.x (32 bit)", "id"=>4640, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_10_X_32_BIT", "softwareDescriptionId"=>1284, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 10.x (64 bit)", "id"=>4638, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_10_X_64_BIT", "softwareDescriptionId"=>1286, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Express Edition", "id"=>5122, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_EXPRESS_EDITION", "softwareDescriptionId"=>1332, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 12 - Unlimited Domain w/ Power Pack", "id"=>6014, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_12_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1420, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB NAS", "id"=>43, "itemTaxCategoryId"=>166, "keyName"=>"NAS_100_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>44}, {"description"=>"Business Continuance Insurance", "id"=>84, "itemTaxCategoryId"=>108, "keyName"=>"BUSINESS_CONTINUANCE_INSURANCE", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100GB EVault Disk to Disk Enterprise Backup", "id"=>560, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_100_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4182}, {"capacity"=>"30", "description"=>"Virtuozzo Containers 4 for Linux - 30 VPS", "id"=>742, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_30_VPS", "softwareDescriptionId"=>320, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"64", "description"=>"/64 Block Static Public IPv6 Addresses", "id"=>784, "itemTaxCategoryId"=>166, "keyName"=>"64_BLOCK_STATIC_PUBLIC_IPV6_ADDRESSES", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESX 4.0", "id"=>1078, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESX_4_0", "softwareDescriptionId"=>497, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx (64 bit)", "id"=>1137, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_64_BIT", "softwareDescriptionId"=>775, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Enterprise R2", "id"=>1165, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_ENTERPRISE_R2", "softwareDescriptionId"=>699, "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Monitoring Package - Basic", "id"=>1248, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_BASIC", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2000Mbps Hardware Firewall", "id"=>1296, "itemTaxCategoryId"=>166, "keyName"=>"2000MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Advanced for XenServer 5.6", "id"=>1299, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ADVANCED_FOR_XENSERVER_5_6", "softwareDescriptionId"=>726, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"EVault Plugin - BMR (Bare Metal Restore)", "id"=>961, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_PLUGIN_BMR_BARE_METAL_RESTORE", "softwareDescriptionId"=>467, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 5.6.2", "id"=>3886, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6_2", "softwareDescriptionId"=>867, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Advanced for XenServer 6.x", "id"=>4104, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ADVANCED_FOR_XENSERVER_6_X", "softwareDescriptionId"=>908, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 9.x (64 bit)", "id"=>4138, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_9_X_64_BIT", "softwareDescriptionId"=>1265, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"400", "description"=>"400 GB SSD", "id"=>4181, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_400GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"16", "description"=>"16 GB Registered DDR3 1333", "id"=>1041, "itemTaxCategoryId"=>166, "keyName"=>"RAM_16_GB_DDR3_1333_ECC_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Cloudera Distribution for Hadoop 4", "id"=>4301, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_CLOUDERA_DISTRIBUTION_HADOOP_4", "softwareDescriptionId"=>1099, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x (32 bit) (per-processor licensing)", "id"=>4320, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_32_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1246, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Riak 1.x", "id"=>4327, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_RIAK_1_X", "softwareDescriptionId"=>1114, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Redundant Private Network Uplinks", "id"=>4331, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (48 TB)", "id"=>4370, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_48_TB", "softwareDescriptionId"=>1154, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Standard Edition (64 bit)", "id"=>4549, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_STD_64_BIT", "softwareDescriptionId"=>1225, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Express", "id"=>24, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_EXPRESS", "softwareDescriptionId"=>9, "upgradeItemId"=>nil}, {"capacity"=>"40", "description"=>"40 GB NAS", "id"=>41, "itemTaxCategoryId"=>166, "keyName"=>"NAS_40_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>42}, {"description"=>"Host Ping", "id"=>49, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_HOST_PING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Automated Notification", "id"=>52, "itemTaxCategoryId"=>166, "keyName"=>"AUTOMATED_NOTIFICATION", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Automated Reboot from Monitoring", "id"=>53, "itemTaxCategoryId"=>166, "keyName"=>"AUTOMATED_REBOOT_FROM_MONITORING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"300", "description"=>"300 GB SA-SCSI 15K RPM", "id"=>352, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_300GB_SASCSI_15K_RPM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"500", "description"=>"500 GB iSCSI SAN Storage", "id"=>553, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_500_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>621}, {"capacity"=>"500", "description"=>"500GB EVault Disk to Disk Enterprise Backup", "id"=>562, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_500_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4184}, {"capacity"=>"120", "description"=>"120 GB iSCSI SAN Storage", "id"=>575, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_120_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>622}, {"capacity"=>"0", "description"=>"FreeBSD 7.x  (32 bit)", "id"=>638, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_7_X_32_BIT", "softwareDescriptionId"=>666, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Virtuozzo Containers 4 for Linux - 3 VPS", "id"=>738, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_3_VPS", "softwareDescriptionId"=>319, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"Virtuozzo Containers 4 for Linux - 100 VPS", "id"=>745, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_100_VPS", "softwareDescriptionId"=>323, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Web Edition SP2 (64bit)", "id"=>935, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_64_BIT_SP2", "softwareDescriptionId"=>446, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Cloudera Distribution for Hadoop 2", "id"=>1044, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_CLOUDERA_DISTRIBUTION_HADOOP_2", "softwareDescriptionId"=>520, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Citrix XenServer 5.6", "id"=>1189, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6", "softwareDescriptionId"=>704, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft WebMatrix", "id"=>3898, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_WEBMATRIX_2", "softwareDescriptionId"=>868, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"International Services", "id"=>3955, "itemTaxCategoryId"=>166, "keyName"=>"INTERNATIONAL_SERVICES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 6.x (32 bit)", "id"=>4094, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_6_X_32_BIT_2", "softwareDescriptionId"=>1172, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 6.x (64 bit)", "id"=>4095, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_6_X_64_BIT", "softwareDescriptionId"=>1175, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"64", "description"=>"1 IPv6 Address", "id"=>4097, "itemTaxCategoryId"=>166, "keyName"=>"1_IPV6_ADDRESS", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Web Edition", "id"=>4147, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_WEB", "softwareDescriptionId"=>1004, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Enterprise Edition", "id"=>4149, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_ENTERPRISE", "softwareDescriptionId"=>1001, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MongoDB", "id"=>4226, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MONGODB", "softwareDescriptionId"=>1083, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"8", "description"=>"8 GB Registered DDR3 1333", "id"=>1040, "itemTaxCategoryId"=>166, "keyName"=>"RAM_8_GB_DDR3_1333_ECC_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 Datacenter Edition With Hyper-V (64bit)", "id"=>4247, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_DC_64_BIT_2", "softwareDescriptionId"=>1082, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x (32 bit) (per-processor licensing)", "id"=>4318, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_32_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1227, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"0 GB Bandwidth", "id"=>4481, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_0_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Datacenter Edition (64bit)", "id"=>4547, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_DC_64_BIT", "softwareDescriptionId"=>1226, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"200", "description"=>"200Mbps Hardware Firewall", "id"=>4551, "itemTaxCategoryId"=>166, "keyName"=>"200MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"cPanel/WHM with Softaculous and RVskin", "id"=>4608, "itemTaxCategoryId"=>166, "keyName"=>"CPANELWHM_WITH_SOFTACULOUS_AND_RVSKIN", "softwareDescriptionId"=>1292, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 7.x (64 bit)", "id"=>5920, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_7_X_64_BIT", "softwareDescriptionId"=>1400, "units"=>"N/A", "upgradeItemId"=>nil}]
          fixture_package_items[54] = [{"capacity"=>"20", "description"=>"20 GB NAS", "id"=>40, "itemTaxCategoryId"=>166, "keyName"=>"NAS_20_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>41}, {"description"=>"Microsoft SQL Server 2005 Standard", "id"=>79, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_STANDARD", "softwareDescriptionId"=>8, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10Mbps Hardware Firewall", "id"=>299, "itemTaxCategoryId"=>166, "keyName"=>"10MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"Unlimited SSL VPN Users & 1 PPTP VPN User per account", "id"=>309, "itemTaxCategoryId"=>166, "keyName"=>"UNLIMITED_SSL_VPN_USERS_1_PPTP_VPN_USER_PER_ACCOUNT", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Standard SP2 with R2 (64 bit)", "id"=>422, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_STD_64_BIT_SP2_WR2", "softwareDescriptionId"=>126, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Enterprise SP2 with R2 (64 bit)", "id"=>424, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_ENT_64_BIT_SP2_WR2", "softwareDescriptionId"=>127, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB iSCSI SAN Storage", "id"=>551, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_100_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>575}, {"capacity"=>"40", "description"=>"40GB EVault Disk to Disk Enterprise Backup", "id"=>559, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_40_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>3784}, {"capacity"=>"1000", "description"=>"1000GB EVault Disk to Disk Enterprise Backup", "id"=>563, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_1000_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4185}, {"capacity"=>"0", "description"=>"FreeBSD 7.x  (64 bit)", "id"=>637, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_7_X_64_BIT", "softwareDescriptionId"=>667, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Web", "id"=>685, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WEB", "softwareDescriptionId"=>305, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Enterprise Edition SP2 (32bit)", "id"=>937, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_32_BIT_SP2", "softwareDescriptionId"=>448, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2000GB EVault Disk to Disk Enterprise Backup", "id"=>955, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_2000_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>nil}, {"capacity"=>"192", "description"=>"192 GB Registered DDR3 1066", "id"=>1147, "itemTaxCategoryId"=>166, "keyName"=>"RAM_192_GB_DDR3_1066_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Web R2", "id"=>1163, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WEB_R2", "softwareDescriptionId"=>696, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Express R2", "id"=>1162, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_EXPRESS_R2", "softwareDescriptionId"=>701, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 10 (Linux) 100 Domain w/ Power Pack", "id"=>1305, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_LINUX_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>938, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"200", "description"=>"200 GB SSD", "id"=>3811, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_200GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 6.x Squeeze/Stable (64 bit)", "id"=>3968, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_6_X_SQUEEZE_64_BIT", "softwareDescriptionId"=>919, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.0.0", "id"=>3977, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_0_0", "softwareDescriptionId"=>836, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 5.x (32 bit)", "id"=>4092, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_5_X_32_BIT_2", "softwareDescriptionId"=>1156, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.0.2", "id"=>4133, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_0_2", "softwareDescriptionId"=>961, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin - Minimal Install (32 bit)", "id"=>4169, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_MINIMAL_32_BIT", "softwareDescriptionId"=>1186, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"350", "description"=>"350GB EVault Disk to Disk Enterprise Backup", "id"=>4183, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_350_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>562}, {"capacity"=>"750", "description"=>"750GB EVault Disk to Disk Enterprise Backup", "id"=>4184, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_750_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>563}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Linux) 100 Domain w/ Power Pack", "id"=>4195, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_LINUX_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1191, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Windows) 100 Domain w/ Power Pack", "id"=>4199, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_WINDOWS_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1273, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 1 VM", "id"=>4303, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_1_VM", "softwareDescriptionId"=>1105, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - Unlimited VMs", "id"=>4307, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_UNLIMITED_VMS", "softwareDescriptionId"=>1112, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Redundant Private Network Uplinks", "id"=>4335, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.2", "id"=>4467, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_2", "softwareDescriptionId"=>1171, "upgradeItemId"=>nil}, {"capacity"=>"80", "description"=>"80 GB NAS", "id"=>42, "itemTaxCategoryId"=>166, "keyName"=>"NAS_80_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>43}, {"capacity"=>"250", "description"=>"250 GB NAS", "id"=>44, "itemTaxCategoryId"=>166, "keyName"=>"NAS_250_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>411}, {"description"=>"APF Software Firewall for Linux", "id"=>300, "itemTaxCategoryId"=>166, "keyName"=>"APF_SOFTWARE_FIREWALL_FOR_LINUX", "softwareDescriptionId"=>71, "upgradeItemId"=>nil}, {"description"=>"Nessus Vulnerability Assessment & Reporting", "id"=>307, "itemTaxCategoryId"=>98, "keyName"=>"NESSUS_VULNERABILITY_ASSESSMENT_REPORTING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"McAfee VirusScan Enterprise", "id"=>397, "itemTaxCategoryId"=>98, "keyName"=>"MCAFEE_VIRUSSCAN_ANTIVIRUS_WINDOWS", "softwareDescriptionId"=>820, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x (32 bit)", "id"=>419, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_32_BIT", "softwareDescriptionId"=>1239, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Non-RAID", "id"=>487, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_NONRAID", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Microsoft Windows Firewall", "id"=>495, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_WINDOWS_FIREWALL", "softwareDescriptionId"=>106, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Private Network Uplink", "id"=>498, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"80", "description"=>"80 GB iSCSI SAN Storage", "id"=>550, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_80_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>551}, {"capacity"=>"250", "description"=>"250GB EVault Disk to Disk Enterprise Backup", "id"=>561, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_250_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4183}, {"description"=>"Microsoft SQL Server 2008 Express", "id"=>681, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_EXPRESS", "softwareDescriptionId"=>308, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Enterprise", "id"=>682, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_ENTERPRISE", "softwareDescriptionId"=>307, "upgradeItemId"=>nil}, {"capacity"=>"30", "description"=>"30GB EVault Disk to Disk Enterprise Backup", "id"=>739, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_30_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>559}, {"capacity"=>"10", "description"=>"Virtuozzo Containers 4 for Linux - 10 VPS", "id"=>741, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_10_VPS", "softwareDescriptionId"=>318, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Datacenter Edition SP2 (32bit)", "id"=>939, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_32_BIT_SP2", "softwareDescriptionId"=>450, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Standard R2", "id"=>1161, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_STANDARD_R2", "softwareDescriptionId"=>698, "upgradeItemId"=>nil}, {"capacity"=>"3000", "description"=>"3000 GB iSCSI SAN Storage", "id"=>1176, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_3000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"3", "description"=>"Monitoring Package - Premium Application", "id"=>1250, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_PREMIUM_APPLICATION", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 10 (Windows) Unlimited Domain w/ Power Pack", "id"=>3785, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_WINDOWS_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>788, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Standard Edition", "id"=>4148, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_STANDARD", "softwareDescriptionId"=>1003, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 Standard Edition (64 bit)", "id"=>4233, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_STD_64_BIT", "softwareDescriptionId"=>1076, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESXi 5.1", "id"=>4272, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESXI_5_1", "softwareDescriptionId"=>1086, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 5 VMs", "id"=>4304, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_5_VMS", "softwareDescriptionId"=>1109, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 10 VMs", "id"=>4305, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_10_VMS", "softwareDescriptionId"=>1110, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"15", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 15 VMs", "id"=>4306, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_15_VMS", "softwareDescriptionId"=>1111, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x (64 bit) (per-processor licensing)", "id"=>4319, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_64_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1228, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable (32 bit)", "id"=>4404, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_32_BIT", "softwareDescriptionId"=>1169, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"RAID", "id"=>4478, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Datacenter Edition With Hyper-V (64bit)", "id"=>4548, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_DC_64_BIT_2", "softwareDescriptionId"=>1226, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Host Ping and TCP Service Monitoring", "id"=>50, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_HOST_PING_AND_TCP_SERVICE", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"McAfee Host Intrusion Protection w/Reporting", "id"=>302, "itemTaxCategoryId"=>98, "keyName"=>"MCAFEE_HOST_INTRUSION_PROTECTION_WREPORTING", "softwareDescriptionId"=>916, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"0 GB Bandwidth", "id"=>439, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_0_GB_2", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1.00 TB SATA II", "id"=>471, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_1_00TB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Private Network Uplink", "id"=>497, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>498}, {"capacity"=>"20", "description"=>"20 GB iSCSI SAN Storage", "id"=>548, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_20_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>549}, {"capacity"=>"40", "description"=>"40 GB iSCSI SAN Storage", "id"=>549, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_40_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>598}, {"capacity"=>"2000", "description"=>"2000 GB iSCSI SAN Storage", "id"=>626, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_2000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>1176}, {"description"=>"Microsoft SQL Server 2008 Standard", "id"=>683, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_STANDARD", "softwareDescriptionId"=>306, "upgradeItemId"=>nil}, {"capacity"=>"70", "description"=>"Virtuozzo Containers 4 for Linux - 70 VPS", "id"=>744, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_70_VPS", "softwareDescriptionId"=>322, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Standard Edition (64bit)", "id"=>977, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_R2", "softwareDescriptionId"=>475, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Datacenter Edition (64bit)", "id"=>979, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_R2", "softwareDescriptionId"=>478, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"24", "description"=>"24 GB Registered DDR3 1333", "id"=>826, "itemTaxCategoryId"=>166, "keyName"=>"RAM_24_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 8.x (64 bit)", "id"=>1065, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_8_X_64_BIT_2", "softwareDescriptionId"=>1019, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"600", "description"=>"600 GB SA-SCSI 15K RPM", "id"=>1094, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_600GB_SASCSI_15K_RPM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx (32 bit)", "id"=>1136, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_32_BIT", "softwareDescriptionId"=>774, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 9.x (32 bit)", "id"=>4137, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_9_X_32_BIT_2", "softwareDescriptionId"=>1264, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin (64 bit)", "id"=>4166, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_64_BIT", "softwareDescriptionId"=>1165, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"175", "description"=>"175GB EVault Disk to Disk Enterprise Backup", "id"=>4182, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_175_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>561}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Linux) Unlimited Domain w/ Power Pack", "id"=>4197, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_LINUX_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1197, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"800", "description"=>"800 GB SSD", "id"=>4356, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_800GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (128 TB)", "id"=>4369, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_128_TB", "softwareDescriptionId"=>1155, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (16 TB)", "id"=>4371, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_16_TB", "softwareDescriptionId"=>1153, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Vyatta 6.x Subscription Edition (64 bit)", "id"=>4396, "itemTaxCategoryId"=>166, "keyName"=>"OS_VYATTA_6_X_SUBSCRIPTION_EDITION_64_BIT_2", "softwareDescriptionId"=>1221, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr (32 bit)", "id"=>4700, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_32_BIT", "softwareDescriptionId"=>1360, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Standard Edition", "id"=>5124, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_STANDARD_EDITION", "softwareDescriptionId"=>1334, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.5 - Minimal Install (64 bit) - version-locked", "id"=>5984, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_5_MINIMAL_64_BIT", "softwareDescriptionId"=>1263, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"MySQL for Linux", "id"=>22, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_LINUX", "softwareDescriptionId"=>156, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100Mbps Hardware Firewall", "id"=>298, "itemTaxCategoryId"=>166, "keyName"=>"100MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"500", "description"=>"500 GB SATA II", "id"=>14, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_500GB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"RAID 0", "id"=>488, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_0", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"RAID 10", "id"=>491, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_10", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Private Network Uplink", "id"=>496, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>497}, {"capacity"=>"250", "description"=>"250 GB iSCSI SAN Storage", "id"=>552, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_250_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>612}, {"capacity"=>"20", "description"=>"20GB EVault Disk to Disk Enterprise Backup", "id"=>558, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_20_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>739}, {"capacity"=>"500", "description"=>"500 GB NAS", "id"=>611, "itemTaxCategoryId"=>166, "keyName"=>"NAS_500_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>605}, {"description"=>"Microsoft SQL Server 2008 Workgroup", "id"=>684, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WORKGROUP", "softwareDescriptionId"=>304, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"Virtuozzo Containers 4 for Linux - 5 VPS", "id"=>740, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_5_VPS", "softwareDescriptionId"=>317, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard Edition SP2 (64bit)", "id"=>936, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_SP2", "softwareDescriptionId"=>447, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Enterprise Edition (64bit)", "id"=>978, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_64_BIT_R2_2", "softwareDescriptionId"=>477, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Datacenter Edition With Hyper-V (64bit)", "id"=>980, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_R2_2", "softwareDescriptionId"=>478, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix Essentials for XenServer 5.5 (Billed per VM)", "id"=>1077, "itemTaxCategoryId"=>166, "keyName"=>"CITRIX_ESSENTIALS_XENSERVER_5_5", "softwareDescriptionId"=>521, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"72", "description"=>"72 GB Registered DDR3 1333", "id"=>829, "itemTaxCategoryId"=>166, "keyName"=>"RAM_72_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"96", "description"=>"96 GB Registered DDR3 1333", "id"=>1050, "itemTaxCategoryId"=>166, "keyName"=>"RAM_96_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Workgroup R2", "id"=>1164, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WORKGROUP_R2", "softwareDescriptionId"=>697, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 10 (Linux) Unlimited Domain w/ Power Pack", "id"=>1306, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_LINUX_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>939, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 5.6.1", "id"=>1322, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6_1", "softwareDescriptionId"=>801, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x (32 bit)", "id"=>3904, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_32_BIT", "softwareDescriptionId"=>1258, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 6.x Squeeze/Stable (32 bit)", "id"=>3967, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_6_X_SQUEEZE_32_BIT", "softwareDescriptionId"=>918, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESX 4.1", "id"=>3969, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESX_4_1", "softwareDescriptionId"=>800, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 5.x (64 bit)", "id"=>4093, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_5_X_64_BIT_3", "softwareDescriptionId"=>1158, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Express Edition", "id"=>4150, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_EXPRESS", "softwareDescriptionId"=>1005, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1500", "description"=>"1500GB EVault Disk to Disk Enterprise Backup", "id"=>4185, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_1500_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>955}, {"capacity"=>"0", "description"=>"Windows Server 2012 Datacenter Edition (64bit)", "id"=>4237, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_DC_64_BIT", "softwareDescriptionId"=>1082, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable (64 bit)", "id"=>4405, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_64_BIT", "softwareDescriptionId"=>1104, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware vCenter 5.5 Standard", "id"=>4598, "itemTaxCategoryId"=>166, "keyName"=>"VMWARE_VCENTER_5_5_STANDARD", "softwareDescriptionId"=>1275, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr - Minimal Install (64 bit)", "id"=>4710, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_MINIMAL_64_BIT_2", "softwareDescriptionId"=>1346, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 12 - 30 Domain w/ Power Pack", "id"=>6010, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_12_30_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1414, "upgradeItemId"=>nil}, {"description"=>"MySQL 5.0 for Windows", "id"=>23, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_0_WINDOWS", "softwareDescriptionId"=>13, "upgradeItemId"=>nil}, {"description"=>"Email and Ticket", "id"=>51, "itemTaxCategoryId"=>166, "keyName"=>"NOTIFICATION_EMAIL_AND_TICKET", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"NOC Monitoring", "id"=>54, "itemTaxCategoryId"=>166, "keyName"=>"NOC_MONITORING", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"cPanel/WHM with Fantastico and RVskin", "id"=>96, "itemTaxCategoryId"=>166, "keyName"=>"CPANELWHM_WITH_FANTASTICO_AND_RVSKIN", "softwareDescriptionId"=>31, "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"RAID 1", "id"=>489, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_1", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"RAID 5", "id"=>490, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_5", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Reboot / KVM over IP", "id"=>504, "itemTaxCategoryId"=>166, "keyName"=>"REBOOT_KVM_OVER_IP", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1000 GB iSCSI SAN Storage", "id"=>554, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_1000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>783}, {"capacity"=>"150", "description"=>"Virtuozzo Containers 4 for Linux - 150 VPS", "id"=>746, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_150_VPS", "softwareDescriptionId"=>324, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"50", "description"=>"Virtuozzo Containers 4 for Linux - 50 VPS", "id"=>743, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_50_VPS", "softwareDescriptionId"=>321, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard Edition SP2 (32bit)", "id"=>933, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_32_BIT_SP2", "softwareDescriptionId"=>444, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Enterprise Edition SP2 (64bit)", "id"=>938, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_64_BIT_SP2", "softwareDescriptionId"=>449, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Datacenter Edition SP2 (64bit)", "id"=>940, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_SP2", "softwareDescriptionId"=>451, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Citrix XenServer 5.5", "id"=>950, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_5", "softwareDescriptionId"=>642, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Web Edition (64bit)", "id"=>976, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_64_BIT_R2_SP1", "softwareDescriptionId"=>832, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Standard SP2 with R2 (32 bit)", "id"=>421, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_STD_32_BIT_SP2_WR2", "softwareDescriptionId"=>125, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Web Edition SP2 (32bit)", "id"=>934, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_32_BIT_SP2", "softwareDescriptionId"=>445, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2.00 TB SATA II", "id"=>1091, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_2_00TB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"12", "description"=>"12 GB Registered DDR3 1333", "id"=>824, "itemTaxCategoryId"=>166, "keyName"=>"RAM_12_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"36", "description"=>"36 GB Registered DDR3 1333", "id"=>827, "itemTaxCategoryId"=>166, "keyName"=>"RAM_36_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Enterprise for XenServer 5.6", "id"=>1300, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ENTERPRISE_FOR_XENSERVER_5_6", "softwareDescriptionId"=>726, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin - Minimal Install (64 bit)", "id"=>4170, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_MINIMAL_64_BIT_2", "softwareDescriptionId"=>1184, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Windows) Unlimited Domain w/ Power Pack", "id"=>4200, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_WINDOWS_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1274, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.1", "id"=>4258, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_1", "softwareDescriptionId"=>1065, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware vCenter 5.1 Standard", "id"=>4298, "itemTaxCategoryId"=>166, "keyName"=>"VMWARE_VCENTER_5_1_STANDARD", "softwareDescriptionId"=>1090, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (4 TB)", "id"=>4372, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_4_TB", "softwareDescriptionId"=>1123, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Vyatta 6.6 Community Edition (64 bit)", "id"=>4495, "itemTaxCategoryId"=>166, "keyName"=>"OS_VYATTA_6_6_COMMUNITY_EDITION_64_BIT", "softwareDescriptionId"=>1192, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"20", "description"=>"20Mbps Hardware Firewall", "id"=>4550, "itemTaxCategoryId"=>166, "keyName"=>"20MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.2.1", "id"=>4569, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_2_1", "softwareDescriptionId"=>1257, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MySQL 5.7 for Windows", "id"=>4592, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_7_WINDOWS", "softwareDescriptionId"=>1272, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Enterprise Edition", "id"=>5120, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_ENTERPRISE_EDITION_2", "softwareDescriptionId"=>1330, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Enterprise", "id"=>81, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_ENTERPRISE", "softwareDescriptionId"=>21, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1000Mbps Hardware Firewall", "id"=>297, "itemTaxCategoryId"=>166, "keyName"=>"1000MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x (64 bit)", "id"=>420, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_64_BIT", "softwareDescriptionId"=>1240, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Enterprise SP2 with R2 (32 bit)", "id"=>423, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_ENT_32_BIT_SP2_WR2", "softwareDescriptionId"=>128, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 8.x (32 bit)", "id"=>1066, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_8_X_32_BIT", "softwareDescriptionId"=>1022, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"60", "description"=>"60GB EVault Disk to Disk Enterprise Backup", "id"=>1076, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_60_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>560}, {"capacity"=>"18", "description"=>"18 GB Registered DDR3 1333", "id"=>825, "itemTaxCategoryId"=>166, "keyName"=>"RAM_18_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"2", "description"=>"Monitoring Package - Advanced", "id"=>1249, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_ADVANCED", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"capacity"=>"50", "description"=>"50GB EVault Disk to Disk Enterprise Backup", "id"=>3784, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_50_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>1076}, {"description"=>"Parallels Plesk Panel 10 (Windows) 100 Domain w/ Power Pack", "id"=>3786, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_WINDOWS_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>787, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x (64 bit)", "id"=>3907, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_64_BIT", "softwareDescriptionId"=>1261, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Redundant Private Network Uplinks", "id"=>3956, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"3000", "description"=>"3.00 TB SATA III", "id"=>3989, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_3_00TB_SATA_III", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Enterprise for XenServer 6.x", "id"=>4105, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ENTERPRISE_FOR_XENSERVER_6_X", "softwareDescriptionId"=>909, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin (32 bit)", "id"=>4165, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_32_BIT", "softwareDescriptionId"=>1166, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"4000", "description"=>"4.00 TB SATA III", "id"=>4281, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_4_00TB_SATA_III", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Vyatta 6.5 Community Edition (64 bit)", "id"=>4315, "itemTaxCategoryId"=>166, "keyName"=>"OS_VYATTA_6_5_COMMUNITY_EDITION_64_BIT", "softwareDescriptionId"=>1106, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x (64 bit) (per-processor licensing)", "id"=>4321, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_64_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1247, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable - Minimal Install (32 bit)", "id"=>4406, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_MINIMAL_32_BIT", "softwareDescriptionId"=>1176, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable - Minimal Install (64 bit)", "id"=>4407, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_MINIMAL_64_BIT", "softwareDescriptionId"=>1177, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MySQL 5.0.51 for Windows", "id"=>4557, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_0_51_WINDOWS", "softwareDescriptionId"=>220, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESXi 5.5", "id"=>4562, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESXI_5_5", "softwareDescriptionId"=>1256, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 10.x (32 bit)", "id"=>4640, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_10_X_32_BIT", "softwareDescriptionId"=>1284, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 10.x (64 bit)", "id"=>4638, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_10_X_64_BIT", "softwareDescriptionId"=>1286, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr (64 bit)", "id"=>4702, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_64_BIT", "softwareDescriptionId"=>1362, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Express Edition", "id"=>5122, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_EXPRESS_EDITION", "softwareDescriptionId"=>1332, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 12 - Unlimited Domain w/ Power Pack", "id"=>6014, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_12_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1420, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB NAS", "id"=>43, "itemTaxCategoryId"=>166, "keyName"=>"NAS_100_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>44}, {"description"=>"Business Continuance Insurance", "id"=>84, "itemTaxCategoryId"=>108, "keyName"=>"BUSINESS_CONTINUANCE_INSURANCE", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100GB EVault Disk to Disk Enterprise Backup", "id"=>560, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_100_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4182}, {"capacity"=>"30", "description"=>"Virtuozzo Containers 4 for Linux - 30 VPS", "id"=>742, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_30_VPS", "softwareDescriptionId"=>320, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"64", "description"=>"/64 Block Static Public IPv6 Addresses", "id"=>784, "itemTaxCategoryId"=>166, "keyName"=>"64_BLOCK_STATIC_PUBLIC_IPV6_ADDRESSES", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESX 4.0", "id"=>1078, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESX_4_0", "softwareDescriptionId"=>497, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"48", "description"=>"48 GB Registered DDR3 1333", "id"=>828, "itemTaxCategoryId"=>166, "keyName"=>"RAM_48_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx (64 bit)", "id"=>1137, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_64_BIT", "softwareDescriptionId"=>775, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Enterprise R2", "id"=>1165, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_ENTERPRISE_R2", "softwareDescriptionId"=>699, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Datacenter R2", "id"=>1166, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_DATACENTER_R2", "softwareDescriptionId"=>700, "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Monitoring Package - Basic", "id"=>1248, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_BASIC", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2000Mbps Hardware Firewall", "id"=>1296, "itemTaxCategoryId"=>166, "keyName"=>"2000MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Advanced for XenServer 5.6", "id"=>1299, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ADVANCED_FOR_XENSERVER_5_6", "softwareDescriptionId"=>726, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"EVault Plugin - BMR (Bare Metal Restore)", "id"=>961, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_PLUGIN_BMR_BARE_METAL_RESTORE", "softwareDescriptionId"=>467, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 5.6.2", "id"=>3886, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6_2", "softwareDescriptionId"=>867, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Advanced for XenServer 6.x", "id"=>4104, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ADVANCED_FOR_XENSERVER_6_X", "softwareDescriptionId"=>908, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 9.x (64 bit)", "id"=>4138, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_9_X_64_BIT", "softwareDescriptionId"=>1265, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"400", "description"=>"400 GB SSD", "id"=>4181, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_400GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Cloudera Distribution for Hadoop 4", "id"=>4301, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_CLOUDERA_DISTRIBUTION_HADOOP_4", "softwareDescriptionId"=>1099, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x (32 bit) (per-processor licensing)", "id"=>4320, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_32_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1246, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Riak 1.x", "id"=>4327, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_RIAK_1_X", "softwareDescriptionId"=>1114, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Redundant Private Network Uplinks", "id"=>4331, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (48 TB)", "id"=>4370, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_48_TB", "softwareDescriptionId"=>1154, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Standard Edition (64 bit)", "id"=>4549, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_STD_64_BIT", "softwareDescriptionId"=>1225, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Express", "id"=>24, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_EXPRESS", "softwareDescriptionId"=>9, "upgradeItemId"=>nil}, {"capacity"=>"40", "description"=>"40 GB NAS", "id"=>41, "itemTaxCategoryId"=>166, "keyName"=>"NAS_40_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>42}, {"description"=>"Host Ping", "id"=>49, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_HOST_PING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Automated Notification", "id"=>52, "itemTaxCategoryId"=>166, "keyName"=>"AUTOMATED_NOTIFICATION", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Automated Reboot from Monitoring", "id"=>53, "itemTaxCategoryId"=>166, "keyName"=>"AUTOMATED_REBOOT_FROM_MONITORING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"300", "description"=>"300 GB SA-SCSI 15K RPM", "id"=>352, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_300GB_SASCSI_15K_RPM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"500", "description"=>"500 GB iSCSI SAN Storage", "id"=>553, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_500_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>621}, {"capacity"=>"500", "description"=>"500GB EVault Disk to Disk Enterprise Backup", "id"=>562, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_500_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4184}, {"capacity"=>"120", "description"=>"120 GB iSCSI SAN Storage", "id"=>575, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_120_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>622}, {"capacity"=>"0", "description"=>"FreeBSD 7.x  (32 bit)", "id"=>638, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_7_X_32_BIT", "softwareDescriptionId"=>666, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Virtuozzo Containers 4 for Linux - 3 VPS", "id"=>738, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_3_VPS", "softwareDescriptionId"=>319, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"Virtuozzo Containers 4 for Linux - 100 VPS", "id"=>745, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_100_VPS", "softwareDescriptionId"=>323, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Web Edition SP2 (64bit)", "id"=>935, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_64_BIT_SP2", "softwareDescriptionId"=>446, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Cloudera Distribution for Hadoop 2", "id"=>1044, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_CLOUDERA_DISTRIBUTION_HADOOP_2", "softwareDescriptionId"=>520, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Citrix XenServer 5.6", "id"=>1189, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6", "softwareDescriptionId"=>704, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft WebMatrix", "id"=>3898, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_WEBMATRIX_2", "softwareDescriptionId"=>868, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"International Services", "id"=>3955, "itemTaxCategoryId"=>166, "keyName"=>"INTERNATIONAL_SERVICES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 6.x (32 bit)", "id"=>4094, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_6_X_32_BIT_2", "softwareDescriptionId"=>1172, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 6.x (64 bit)", "id"=>4095, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_6_X_64_BIT", "softwareDescriptionId"=>1175, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"64", "description"=>"1 IPv6 Address", "id"=>4097, "itemTaxCategoryId"=>166, "keyName"=>"1_IPV6_ADDRESS", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Web Edition", "id"=>4147, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_WEB", "softwareDescriptionId"=>1004, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Enterprise Edition", "id"=>4149, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_ENTERPRISE", "softwareDescriptionId"=>1001, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MongoDB", "id"=>4226, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MONGODB", "softwareDescriptionId"=>1083, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 Datacenter Edition With Hyper-V (64bit)", "id"=>4247, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_DC_64_BIT_2", "softwareDescriptionId"=>1082, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x (32 bit) (per-processor licensing)", "id"=>4318, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_32_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1227, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"0 GB Bandwidth", "id"=>4481, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_0_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Datacenter Edition (64bit)", "id"=>4547, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_DC_64_BIT", "softwareDescriptionId"=>1226, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"200", "description"=>"200Mbps Hardware Firewall", "id"=>4551, "itemTaxCategoryId"=>166, "keyName"=>"200MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"cPanel/WHM with Softaculous and RVskin", "id"=>4608, "itemTaxCategoryId"=>166, "keyName"=>"CPANELWHM_WITH_SOFTACULOUS_AND_RVSKIN", "softwareDescriptionId"=>1292, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr - Minimal Install (32 bit)", "id"=>4708, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_MINIMAL_32_BIT_2", "softwareDescriptionId"=>1350, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 7.x (64 bit)", "id"=>5920, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_7_X_64_BIT", "softwareDescriptionId"=>1400, "units"=>"N/A", "upgradeItemId"=>nil}]
          fixture_package_items[55] = [{"capacity"=>"20", "description"=>"20 GB NAS", "id"=>40, "itemTaxCategoryId"=>166, "keyName"=>"NAS_20_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>41}, {"description"=>"Microsoft SQL Server 2005 Standard", "id"=>79, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_STANDARD", "softwareDescriptionId"=>8, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10Mbps Hardware Firewall", "id"=>299, "itemTaxCategoryId"=>166, "keyName"=>"10MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"Unlimited SSL VPN Users & 1 PPTP VPN User per account", "id"=>309, "itemTaxCategoryId"=>166, "keyName"=>"UNLIMITED_SSL_VPN_USERS_1_PPTP_VPN_USER_PER_ACCOUNT", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Standard SP2 with R2 (64 bit)", "id"=>422, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_STD_64_BIT_SP2_WR2", "softwareDescriptionId"=>126, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Enterprise SP2 with R2 (64 bit)", "id"=>424, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_ENT_64_BIT_SP2_WR2", "softwareDescriptionId"=>127, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB iSCSI SAN Storage", "id"=>551, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_100_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>575}, {"capacity"=>"40", "description"=>"40GB EVault Disk to Disk Enterprise Backup", "id"=>559, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_40_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>3784}, {"capacity"=>"1000", "description"=>"1000GB EVault Disk to Disk Enterprise Backup", "id"=>563, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_1000_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4185}, {"capacity"=>"0", "description"=>"FreeBSD 7.x  (64 bit)", "id"=>637, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_7_X_64_BIT", "softwareDescriptionId"=>667, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Web", "id"=>685, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WEB", "softwareDescriptionId"=>305, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Enterprise Edition SP2 (32bit)", "id"=>937, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_32_BIT_SP2", "softwareDescriptionId"=>448, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2000GB EVault Disk to Disk Enterprise Backup", "id"=>955, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_2000_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>nil}, {"capacity"=>"192", "description"=>"192 GB Registered DDR3 1066", "id"=>1147, "itemTaxCategoryId"=>166, "keyName"=>"RAM_192_GB_DDR3_1066_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Web R2", "id"=>1163, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WEB_R2", "softwareDescriptionId"=>696, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Express R2", "id"=>1162, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_EXPRESS_R2", "softwareDescriptionId"=>701, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 10 (Linux) 100 Domain w/ Power Pack", "id"=>1305, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_LINUX_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>938, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"200", "description"=>"200 GB SSD", "id"=>3811, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_200GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 6.x Squeeze/Stable (64 bit)", "id"=>3968, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_6_X_SQUEEZE_64_BIT", "softwareDescriptionId"=>919, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.0.0", "id"=>3977, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_0_0", "softwareDescriptionId"=>836, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 5.x (32 bit)", "id"=>4092, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_5_X_32_BIT_2", "softwareDescriptionId"=>1156, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.0.2", "id"=>4133, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_0_2", "softwareDescriptionId"=>961, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin - Minimal Install (32 bit)", "id"=>4169, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_MINIMAL_32_BIT", "softwareDescriptionId"=>1186, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"350", "description"=>"350GB EVault Disk to Disk Enterprise Backup", "id"=>4183, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_350_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>562}, {"capacity"=>"750", "description"=>"750GB EVault Disk to Disk Enterprise Backup", "id"=>4184, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_750_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>563}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Linux) 100 Domain w/ Power Pack", "id"=>4195, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_LINUX_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1191, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Windows) 100 Domain w/ Power Pack", "id"=>4199, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_WINDOWS_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1273, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 1 VM", "id"=>4303, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_1_VM", "softwareDescriptionId"=>1105, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - Unlimited VMs", "id"=>4307, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_UNLIMITED_VMS", "softwareDescriptionId"=>1112, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Redundant Private Network Uplinks", "id"=>4335, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.2", "id"=>4467, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_2", "softwareDescriptionId"=>1171, "upgradeItemId"=>nil}, {"capacity"=>"80", "description"=>"80 GB NAS", "id"=>42, "itemTaxCategoryId"=>166, "keyName"=>"NAS_80_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>43}, {"capacity"=>"250", "description"=>"250 GB NAS", "id"=>44, "itemTaxCategoryId"=>166, "keyName"=>"NAS_250_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>411}, {"description"=>"APF Software Firewall for Linux", "id"=>300, "itemTaxCategoryId"=>166, "keyName"=>"APF_SOFTWARE_FIREWALL_FOR_LINUX", "softwareDescriptionId"=>71, "upgradeItemId"=>nil}, {"description"=>"Nessus Vulnerability Assessment & Reporting", "id"=>307, "itemTaxCategoryId"=>98, "keyName"=>"NESSUS_VULNERABILITY_ASSESSMENT_REPORTING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"McAfee VirusScan Enterprise", "id"=>397, "itemTaxCategoryId"=>98, "keyName"=>"MCAFEE_VIRUSSCAN_ANTIVIRUS_WINDOWS", "softwareDescriptionId"=>820, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x (32 bit)", "id"=>419, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_32_BIT", "softwareDescriptionId"=>1239, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Non-RAID", "id"=>487, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_NONRAID", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Microsoft Windows Firewall", "id"=>495, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_WINDOWS_FIREWALL", "softwareDescriptionId"=>106, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Private Network Uplink", "id"=>498, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"80", "description"=>"80 GB iSCSI SAN Storage", "id"=>550, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_80_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>551}, {"capacity"=>"250", "description"=>"250GB EVault Disk to Disk Enterprise Backup", "id"=>561, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_250_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4183}, {"description"=>"Microsoft SQL Server 2008 Express", "id"=>681, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_EXPRESS", "softwareDescriptionId"=>308, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Enterprise", "id"=>682, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_ENTERPRISE", "softwareDescriptionId"=>307, "upgradeItemId"=>nil}, {"capacity"=>"30", "description"=>"30GB EVault Disk to Disk Enterprise Backup", "id"=>739, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_30_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>559}, {"capacity"=>"10", "description"=>"Virtuozzo Containers 4 for Linux - 10 VPS", "id"=>741, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_10_VPS", "softwareDescriptionId"=>318, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Datacenter Edition SP2 (32bit)", "id"=>939, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_32_BIT_SP2", "softwareDescriptionId"=>450, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Standard R2", "id"=>1161, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_STANDARD_R2", "softwareDescriptionId"=>698, "upgradeItemId"=>nil}, {"capacity"=>"3000", "description"=>"3000 GB iSCSI SAN Storage", "id"=>1176, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_3000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"3", "description"=>"Monitoring Package - Premium Application", "id"=>1250, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_PREMIUM_APPLICATION", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 10 (Windows) Unlimited Domain w/ Power Pack", "id"=>3785, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_WINDOWS_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>788, "upgradeItemId"=>nil}, {"capacity"=>"10000", "description"=>"10 Gbps Private Network Uplink", "id"=>3957, "itemTaxCategoryId"=>166, "keyName"=>"10_GBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Standard Edition", "id"=>4148, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_STANDARD", "softwareDescriptionId"=>1003, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 Standard Edition (64 bit)", "id"=>4233, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_STD_64_BIT", "softwareDescriptionId"=>1076, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESXi 5.1", "id"=>4272, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESXI_5_1", "softwareDescriptionId"=>1086, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 5 VMs", "id"=>4304, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_5_VMS", "softwareDescriptionId"=>1109, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 10 VMs", "id"=>4305, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_10_VMS", "softwareDescriptionId"=>1110, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"15", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 15 VMs", "id"=>4306, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_15_VMS", "softwareDescriptionId"=>1111, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x (64 bit) (per-processor licensing)", "id"=>4319, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_64_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1228, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable (32 bit)", "id"=>4404, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_32_BIT", "softwareDescriptionId"=>1169, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"RAID", "id"=>4478, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Datacenter Edition With Hyper-V (64bit)", "id"=>4548, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_DC_64_BIT_2", "softwareDescriptionId"=>1226, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Host Ping and TCP Service Monitoring", "id"=>50, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_HOST_PING_AND_TCP_SERVICE", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"McAfee Host Intrusion Protection w/Reporting", "id"=>302, "itemTaxCategoryId"=>98, "keyName"=>"MCAFEE_HOST_INTRUSION_PROTECTION_WREPORTING", "softwareDescriptionId"=>916, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"0 GB Bandwidth", "id"=>439, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_0_GB_2", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1.00 TB SATA II", "id"=>471, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_1_00TB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Private Network Uplink", "id"=>497, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>498}, {"capacity"=>"20", "description"=>"20 GB iSCSI SAN Storage", "id"=>548, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_20_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>549}, {"capacity"=>"40", "description"=>"40 GB iSCSI SAN Storage", "id"=>549, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_40_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>598}, {"capacity"=>"2000", "description"=>"2000 GB iSCSI SAN Storage", "id"=>626, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_2000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>1176}, {"description"=>"Microsoft SQL Server 2008 Standard", "id"=>683, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_STANDARD", "softwareDescriptionId"=>306, "upgradeItemId"=>nil}, {"capacity"=>"70", "description"=>"Virtuozzo Containers 4 for Linux - 70 VPS", "id"=>744, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_70_VPS", "softwareDescriptionId"=>322, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Standard Edition (64bit)", "id"=>977, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_R2", "softwareDescriptionId"=>475, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Datacenter Edition (64bit)", "id"=>979, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_R2", "softwareDescriptionId"=>478, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"24", "description"=>"24 GB Registered DDR3 1333", "id"=>826, "itemTaxCategoryId"=>166, "keyName"=>"RAM_24_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 8.x (64 bit)", "id"=>1065, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_8_X_64_BIT_2", "softwareDescriptionId"=>1019, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"600", "description"=>"600 GB SA-SCSI 15K RPM", "id"=>1094, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_600GB_SASCSI_15K_RPM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx (32 bit)", "id"=>1136, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_32_BIT", "softwareDescriptionId"=>774, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 9.x (32 bit)", "id"=>4137, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_9_X_32_BIT_2", "softwareDescriptionId"=>1264, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin (64 bit)", "id"=>4166, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_64_BIT", "softwareDescriptionId"=>1165, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"175", "description"=>"175GB EVault Disk to Disk Enterprise Backup", "id"=>4182, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_175_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>561}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Linux) Unlimited Domain w/ Power Pack", "id"=>4197, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_LINUX_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1197, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"800", "description"=>"800 GB SSD", "id"=>4356, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_800GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (128 TB)", "id"=>4369, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_128_TB", "softwareDescriptionId"=>1155, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (16 TB)", "id"=>4371, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_16_TB", "softwareDescriptionId"=>1153, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr (32 bit)", "id"=>4700, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_32_BIT", "softwareDescriptionId"=>1360, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Standard Edition", "id"=>5124, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_STANDARD_EDITION", "softwareDescriptionId"=>1334, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.5 - Minimal Install (64 bit) - version-locked", "id"=>5984, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_5_MINIMAL_64_BIT", "softwareDescriptionId"=>1263, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"MySQL for Linux", "id"=>22, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_LINUX", "softwareDescriptionId"=>156, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100Mbps Hardware Firewall", "id"=>298, "itemTaxCategoryId"=>166, "keyName"=>"100MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"Redundant Power Supply", "id"=>469, "itemTaxCategoryId"=>166, "keyName"=>"REDUNDANT_POWER_SUPPLY", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"500", "description"=>"500 GB SATA II", "id"=>14, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_500GB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"RAID 0", "id"=>488, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_0", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"RAID 10", "id"=>491, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_10", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Private Network Uplink", "id"=>496, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>497}, {"capacity"=>"250", "description"=>"250 GB iSCSI SAN Storage", "id"=>552, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_250_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>612}, {"capacity"=>"20", "description"=>"20GB EVault Disk to Disk Enterprise Backup", "id"=>558, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_20_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>739}, {"capacity"=>"500", "description"=>"500 GB NAS", "id"=>611, "itemTaxCategoryId"=>166, "keyName"=>"NAS_500_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>605}, {"description"=>"Microsoft SQL Server 2008 Workgroup", "id"=>684, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WORKGROUP", "softwareDescriptionId"=>304, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"Virtuozzo Containers 4 for Linux - 5 VPS", "id"=>740, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_5_VPS", "softwareDescriptionId"=>317, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard Edition SP2 (64bit)", "id"=>936, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_SP2", "softwareDescriptionId"=>447, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Enterprise Edition (64bit)", "id"=>978, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_64_BIT_R2_2", "softwareDescriptionId"=>477, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Datacenter Edition With Hyper-V (64bit)", "id"=>980, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_R2_2", "softwareDescriptionId"=>478, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix Essentials for XenServer 5.5 (Billed per VM)", "id"=>1077, "itemTaxCategoryId"=>166, "keyName"=>"CITRIX_ESSENTIALS_XENSERVER_5_5", "softwareDescriptionId"=>521, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"72", "description"=>"72 GB Registered DDR3 1333", "id"=>829, "itemTaxCategoryId"=>166, "keyName"=>"RAM_72_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"96", "description"=>"96 GB Registered DDR3 1333", "id"=>1050, "itemTaxCategoryId"=>166, "keyName"=>"RAM_96_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Workgroup R2", "id"=>1164, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WORKGROUP_R2", "softwareDescriptionId"=>697, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 10 (Linux) Unlimited Domain w/ Power Pack", "id"=>1306, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_LINUX_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>939, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 5.6.1", "id"=>1322, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6_1", "softwareDescriptionId"=>801, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x (32 bit)", "id"=>3904, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_32_BIT", "softwareDescriptionId"=>1258, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 6.x Squeeze/Stable (32 bit)", "id"=>3967, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_6_X_SQUEEZE_32_BIT", "softwareDescriptionId"=>918, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESX 4.1", "id"=>3969, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESX_4_1", "softwareDescriptionId"=>800, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 5.x (64 bit)", "id"=>4093, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_5_X_64_BIT_3", "softwareDescriptionId"=>1158, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Express Edition", "id"=>4150, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_EXPRESS", "softwareDescriptionId"=>1005, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1500", "description"=>"1500GB EVault Disk to Disk Enterprise Backup", "id"=>4185, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_1500_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>955}, {"capacity"=>"0", "description"=>"Windows Server 2012 Datacenter Edition (64bit)", "id"=>4237, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_DC_64_BIT", "softwareDescriptionId"=>1082, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable (64 bit)", "id"=>4405, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_64_BIT", "softwareDescriptionId"=>1104, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware vCenter 5.5 Standard", "id"=>4598, "itemTaxCategoryId"=>166, "keyName"=>"VMWARE_VCENTER_5_5_STANDARD", "softwareDescriptionId"=>1275, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr - Minimal Install (64 bit)", "id"=>4710, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_MINIMAL_64_BIT_2", "softwareDescriptionId"=>1346, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 12 - 30 Domain w/ Power Pack", "id"=>6010, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_12_30_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1414, "upgradeItemId"=>nil}, {"description"=>"MySQL 5.0 for Windows", "id"=>23, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_0_WINDOWS", "softwareDescriptionId"=>13, "upgradeItemId"=>nil}, {"description"=>"Email and Ticket", "id"=>51, "itemTaxCategoryId"=>166, "keyName"=>"NOTIFICATION_EMAIL_AND_TICKET", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"NOC Monitoring", "id"=>54, "itemTaxCategoryId"=>166, "keyName"=>"NOC_MONITORING", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"cPanel/WHM with Fantastico and RVskin", "id"=>96, "itemTaxCategoryId"=>166, "keyName"=>"CPANELWHM_WITH_FANTASTICO_AND_RVSKIN", "softwareDescriptionId"=>31, "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"RAID 1", "id"=>489, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_1", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"RAID 5", "id"=>490, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_5", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Reboot / KVM over IP", "id"=>504, "itemTaxCategoryId"=>166, "keyName"=>"REBOOT_KVM_OVER_IP", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1000 GB iSCSI SAN Storage", "id"=>554, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_1000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>783}, {"capacity"=>"150", "description"=>"Virtuozzo Containers 4 for Linux - 150 VPS", "id"=>746, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_150_VPS", "softwareDescriptionId"=>324, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"50", "description"=>"Virtuozzo Containers 4 for Linux - 50 VPS", "id"=>743, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_50_VPS", "softwareDescriptionId"=>321, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard Edition SP2 (32bit)", "id"=>933, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_32_BIT_SP2", "softwareDescriptionId"=>444, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Enterprise Edition SP2 (64bit)", "id"=>938, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_64_BIT_SP2", "softwareDescriptionId"=>449, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Datacenter Edition SP2 (64bit)", "id"=>940, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_SP2", "softwareDescriptionId"=>451, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Citrix XenServer 5.5", "id"=>950, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_5", "softwareDescriptionId"=>642, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Web Edition (64bit)", "id"=>976, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_64_BIT_R2_SP1", "softwareDescriptionId"=>832, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Standard SP2 with R2 (32 bit)", "id"=>421, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_STD_32_BIT_SP2_WR2", "softwareDescriptionId"=>125, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Web Edition SP2 (32bit)", "id"=>934, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_32_BIT_SP2", "softwareDescriptionId"=>445, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2.00 TB SATA II", "id"=>1091, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_2_00TB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"12", "description"=>"12 GB Registered DDR3 1333", "id"=>824, "itemTaxCategoryId"=>166, "keyName"=>"RAM_12_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"36", "description"=>"36 GB Registered DDR3 1333", "id"=>827, "itemTaxCategoryId"=>166, "keyName"=>"RAM_36_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Enterprise for XenServer 5.6", "id"=>1300, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ENTERPRISE_FOR_XENSERVER_5_6", "softwareDescriptionId"=>726, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin - Minimal Install (64 bit)", "id"=>4170, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_MINIMAL_64_BIT_2", "softwareDescriptionId"=>1184, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Windows) Unlimited Domain w/ Power Pack", "id"=>4200, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_WINDOWS_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1274, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.1", "id"=>4258, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_1", "softwareDescriptionId"=>1065, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware vCenter 5.1 Standard", "id"=>4298, "itemTaxCategoryId"=>166, "keyName"=>"VMWARE_VCENTER_5_1_STANDARD", "softwareDescriptionId"=>1090, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (4 TB)", "id"=>4372, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_4_TB", "softwareDescriptionId"=>1123, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"20", "description"=>"20Mbps Hardware Firewall", "id"=>4550, "itemTaxCategoryId"=>166, "keyName"=>"20MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.2.1", "id"=>4569, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_2_1", "softwareDescriptionId"=>1257, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MySQL 5.7 for Windows", "id"=>4592, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_7_WINDOWS", "softwareDescriptionId"=>1272, "upgradeItemId"=>nil}, {"capacity"=>"10000", "description"=>"10 Gbps Dual Private Network Uplinks (Unbonded)", "id"=>5102, "itemTaxCategoryId"=>166, "keyName"=>"10_GBPS_DUAL_PRIVATE_NETWORK_UPLINKS_UNBONDED", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Enterprise Edition", "id"=>5120, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_ENTERPRISE_EDITION_2", "softwareDescriptionId"=>1330, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Enterprise", "id"=>81, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_ENTERPRISE", "softwareDescriptionId"=>21, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1000Mbps Hardware Firewall", "id"=>297, "itemTaxCategoryId"=>166, "keyName"=>"1000MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x (64 bit)", "id"=>420, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_64_BIT", "softwareDescriptionId"=>1240, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Enterprise SP2 with R2 (32 bit)", "id"=>423, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_ENT_32_BIT_SP2_WR2", "softwareDescriptionId"=>128, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 8.x (32 bit)", "id"=>1066, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_8_X_32_BIT", "softwareDescriptionId"=>1022, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"60", "description"=>"60GB EVault Disk to Disk Enterprise Backup", "id"=>1076, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_60_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>560}, {"capacity"=>"18", "description"=>"18 GB Registered DDR3 1333", "id"=>825, "itemTaxCategoryId"=>166, "keyName"=>"RAM_18_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"2", "description"=>"Monitoring Package - Advanced", "id"=>1249, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_ADVANCED", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"capacity"=>"50", "description"=>"50GB EVault Disk to Disk Enterprise Backup", "id"=>3784, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_50_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>1076}, {"description"=>"Parallels Plesk Panel 10 (Windows) 100 Domain w/ Power Pack", "id"=>3786, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_WINDOWS_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>787, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x (64 bit)", "id"=>3907, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_64_BIT", "softwareDescriptionId"=>1261, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Redundant Private Network Uplinks", "id"=>3956, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"3000", "description"=>"3.00 TB SATA III", "id"=>3989, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_3_00TB_SATA_III", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Enterprise for XenServer 6.x", "id"=>4105, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ENTERPRISE_FOR_XENSERVER_6_X", "softwareDescriptionId"=>909, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin (32 bit)", "id"=>4165, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_32_BIT", "softwareDescriptionId"=>1166, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"4000", "description"=>"4.00 TB SATA III", "id"=>4281, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_4_00TB_SATA_III", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x (64 bit) (per-processor licensing)", "id"=>4321, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_64_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1247, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable - Minimal Install (32 bit)", "id"=>4406, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_MINIMAL_32_BIT", "softwareDescriptionId"=>1176, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable - Minimal Install (64 bit)", "id"=>4407, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_MINIMAL_64_BIT", "softwareDescriptionId"=>1177, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MySQL 5.0.51 for Windows", "id"=>4557, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_0_51_WINDOWS", "softwareDescriptionId"=>220, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESXi 5.5", "id"=>4562, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESXI_5_5", "softwareDescriptionId"=>1256, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 10.x (32 bit)", "id"=>4640, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_10_X_32_BIT", "softwareDescriptionId"=>1284, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 10.x (64 bit)", "id"=>4638, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_10_X_64_BIT", "softwareDescriptionId"=>1286, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr (64 bit)", "id"=>4702, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_64_BIT", "softwareDescriptionId"=>1362, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Express Edition", "id"=>5122, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_EXPRESS_EDITION", "softwareDescriptionId"=>1332, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 12 - Unlimited Domain w/ Power Pack", "id"=>6014, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_12_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1420, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB NAS", "id"=>43, "itemTaxCategoryId"=>166, "keyName"=>"NAS_100_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>44}, {"description"=>"Business Continuance Insurance", "id"=>84, "itemTaxCategoryId"=>108, "keyName"=>"BUSINESS_CONTINUANCE_INSURANCE", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100GB EVault Disk to Disk Enterprise Backup", "id"=>560, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_100_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4182}, {"capacity"=>"30", "description"=>"Virtuozzo Containers 4 for Linux - 30 VPS", "id"=>742, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_30_VPS", "softwareDescriptionId"=>320, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"64", "description"=>"/64 Block Static Public IPv6 Addresses", "id"=>784, "itemTaxCategoryId"=>166, "keyName"=>"64_BLOCK_STATIC_PUBLIC_IPV6_ADDRESSES", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESX 4.0", "id"=>1078, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESX_4_0", "softwareDescriptionId"=>497, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"48", "description"=>"48 GB Registered DDR3 1333", "id"=>828, "itemTaxCategoryId"=>166, "keyName"=>"RAM_48_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx (64 bit)", "id"=>1137, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_64_BIT", "softwareDescriptionId"=>775, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Enterprise R2", "id"=>1165, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_ENTERPRISE_R2", "softwareDescriptionId"=>699, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Datacenter R2", "id"=>1166, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_DATACENTER_R2", "softwareDescriptionId"=>700, "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Monitoring Package - Basic", "id"=>1248, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_BASIC", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2000Mbps Hardware Firewall", "id"=>1296, "itemTaxCategoryId"=>166, "keyName"=>"2000MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Advanced for XenServer 5.6", "id"=>1299, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ADVANCED_FOR_XENSERVER_5_6", "softwareDescriptionId"=>726, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"EVault Plugin - BMR (Bare Metal Restore)", "id"=>961, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_PLUGIN_BMR_BARE_METAL_RESTORE", "softwareDescriptionId"=>467, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 5.6.2", "id"=>3886, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6_2", "softwareDescriptionId"=>867, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Advanced for XenServer 6.x", "id"=>4104, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ADVANCED_FOR_XENSERVER_6_X", "softwareDescriptionId"=>908, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 9.x (64 bit)", "id"=>4138, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_9_X_64_BIT", "softwareDescriptionId"=>1265, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"400", "description"=>"400 GB SSD", "id"=>4181, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_400GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Cloudera Distribution for Hadoop 4", "id"=>4301, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_CLOUDERA_DISTRIBUTION_HADOOP_4", "softwareDescriptionId"=>1099, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x (32 bit) (per-processor licensing)", "id"=>4320, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_32_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1246, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Riak 1.x", "id"=>4327, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_RIAK_1_X", "softwareDescriptionId"=>1114, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Redundant Private Network Uplinks", "id"=>4331, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (48 TB)", "id"=>4370, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_48_TB", "softwareDescriptionId"=>1154, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Standard Edition (64 bit)", "id"=>4549, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_STD_64_BIT", "softwareDescriptionId"=>1225, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Express", "id"=>24, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_EXPRESS", "softwareDescriptionId"=>9, "upgradeItemId"=>nil}, {"capacity"=>"40", "description"=>"40 GB NAS", "id"=>41, "itemTaxCategoryId"=>166, "keyName"=>"NAS_40_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>42}, {"description"=>"Host Ping", "id"=>49, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_HOST_PING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Automated Notification", "id"=>52, "itemTaxCategoryId"=>166, "keyName"=>"AUTOMATED_NOTIFICATION", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Automated Reboot from Monitoring", "id"=>53, "itemTaxCategoryId"=>166, "keyName"=>"AUTOMATED_REBOOT_FROM_MONITORING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"300", "description"=>"300 GB SA-SCSI 15K RPM", "id"=>352, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_300GB_SASCSI_15K_RPM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"500", "description"=>"500 GB iSCSI SAN Storage", "id"=>553, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_500_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>621}, {"capacity"=>"500", "description"=>"500GB EVault Disk to Disk Enterprise Backup", "id"=>562, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_500_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4184}, {"capacity"=>"120", "description"=>"120 GB iSCSI SAN Storage", "id"=>575, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_120_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>622}, {"capacity"=>"0", "description"=>"FreeBSD 7.x  (32 bit)", "id"=>638, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_7_X_32_BIT", "softwareDescriptionId"=>666, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Virtuozzo Containers 4 for Linux - 3 VPS", "id"=>738, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_3_VPS", "softwareDescriptionId"=>319, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"Virtuozzo Containers 4 for Linux - 100 VPS", "id"=>745, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_100_VPS", "softwareDescriptionId"=>323, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Web Edition SP2 (64bit)", "id"=>935, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_64_BIT_SP2", "softwareDescriptionId"=>446, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Cloudera Distribution for Hadoop 2", "id"=>1044, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_CLOUDERA_DISTRIBUTION_HADOOP_2", "softwareDescriptionId"=>520, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"144", "description"=>"144 GB Registered DDR3 1333", "id"=>1011, "itemTaxCategoryId"=>166, "keyName"=>"RAM_144_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"description"=>"Citrix XenServer 5.6", "id"=>1189, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6", "softwareDescriptionId"=>704, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft WebMatrix", "id"=>3898, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_WEBMATRIX_2", "softwareDescriptionId"=>868, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"International Services", "id"=>3955, "itemTaxCategoryId"=>166, "keyName"=>"INTERNATIONAL_SERVICES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 6.x (32 bit)", "id"=>4094, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_6_X_32_BIT_2", "softwareDescriptionId"=>1172, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 6.x (64 bit)", "id"=>4095, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_6_X_64_BIT", "softwareDescriptionId"=>1175, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"64", "description"=>"1 IPv6 Address", "id"=>4097, "itemTaxCategoryId"=>166, "keyName"=>"1_IPV6_ADDRESS", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Web Edition", "id"=>4147, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_WEB", "softwareDescriptionId"=>1004, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Enterprise Edition", "id"=>4149, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_ENTERPRISE", "softwareDescriptionId"=>1001, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MongoDB", "id"=>4226, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MONGODB", "softwareDescriptionId"=>1083, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 Datacenter Edition With Hyper-V (64bit)", "id"=>4247, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_DC_64_BIT_2", "softwareDescriptionId"=>1082, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x (32 bit) (per-processor licensing)", "id"=>4318, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_32_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1227, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"0 GB Bandwidth", "id"=>4481, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_0_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Datacenter Edition (64bit)", "id"=>4547, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_DC_64_BIT", "softwareDescriptionId"=>1226, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"200", "description"=>"200Mbps Hardware Firewall", "id"=>4551, "itemTaxCategoryId"=>166, "keyName"=>"200MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"cPanel/WHM with Softaculous and RVskin", "id"=>4608, "itemTaxCategoryId"=>166, "keyName"=>"CPANELWHM_WITH_SOFTACULOUS_AND_RVSKIN", "softwareDescriptionId"=>1292, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr - Minimal Install (32 bit)", "id"=>4708, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_MINIMAL_32_BIT_2", "softwareDescriptionId"=>1350, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 7.x (64 bit)", "id"=>5920, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_7_X_64_BIT", "softwareDescriptionId"=>1400, "units"=>"N/A", "upgradeItemId"=>nil}]
          fixture_package_items[56] = [{"capacity"=>"20", "description"=>"20 GB NAS", "id"=>40, "itemTaxCategoryId"=>166, "keyName"=>"NAS_20_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>41}, {"description"=>"Microsoft SQL Server 2005 Standard", "id"=>79, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_STANDARD", "softwareDescriptionId"=>8, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10Mbps Hardware Firewall", "id"=>299, "itemTaxCategoryId"=>166, "keyName"=>"10MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"Unlimited SSL VPN Users & 1 PPTP VPN User per account", "id"=>309, "itemTaxCategoryId"=>166, "keyName"=>"UNLIMITED_SSL_VPN_USERS_1_PPTP_VPN_USER_PER_ACCOUNT", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Enterprise SP2 with R2 (64 bit)", "id"=>424, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_ENT_64_BIT_SP2_WR2", "softwareDescriptionId"=>127, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB iSCSI SAN Storage", "id"=>551, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_100_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>575}, {"capacity"=>"40", "description"=>"40GB EVault Disk to Disk Enterprise Backup", "id"=>559, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_40_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>3784}, {"capacity"=>"1000", "description"=>"1000GB EVault Disk to Disk Enterprise Backup", "id"=>563, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_1000_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4185}, {"capacity"=>"0", "description"=>"FreeBSD 7.x  (64 bit)", "id"=>637, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_7_X_64_BIT", "softwareDescriptionId"=>667, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Web", "id"=>685, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WEB", "softwareDescriptionId"=>305, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Enterprise Edition SP2 (32bit)", "id"=>937, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_32_BIT_SP2", "softwareDescriptionId"=>448, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2000GB EVault Disk to Disk Enterprise Backup", "id"=>955, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_2000_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Standard SP2 with R2 (64 bit)", "id"=>422, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_STD_64_BIT_SP2_WR2", "softwareDescriptionId"=>126, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"Virtuozzo Containers 4 for Linux - 4 processors - 100 VPS", "id"=>1085, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_4_PROCESSORS_100_VPS", "softwareDescriptionId"=>587, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Web R2", "id"=>1163, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WEB_R2", "softwareDescriptionId"=>696, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Express R2", "id"=>1162, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_EXPRESS_R2", "softwareDescriptionId"=>701, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 10 (Linux) 100 Domain w/ Power Pack", "id"=>1305, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_LINUX_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>938, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"200", "description"=>"200 GB SSD", "id"=>3811, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_200GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 6.x Squeeze/Stable (64 bit)", "id"=>3968, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_6_X_SQUEEZE_64_BIT", "softwareDescriptionId"=>919, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.0.0", "id"=>3977, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_0_0", "softwareDescriptionId"=>836, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 5.x (32 bit)", "id"=>4092, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_5_X_32_BIT_2", "softwareDescriptionId"=>1156, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.0.2", "id"=>4133, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_0_2", "softwareDescriptionId"=>961, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 10 Pack", "id"=>4155, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_10_PACK", "softwareDescriptionId"=>1011, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin - Minimal Install (32 bit)", "id"=>4169, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_MINIMAL_32_BIT", "softwareDescriptionId"=>1186, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"350", "description"=>"350GB EVault Disk to Disk Enterprise Backup", "id"=>4183, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_350_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>562}, {"capacity"=>"750", "description"=>"750GB EVault Disk to Disk Enterprise Backup", "id"=>4184, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_750_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>563}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Linux) 100 Domain w/ Power Pack", "id"=>4195, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_LINUX_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1191, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Windows) 100 Domain w/ Power Pack", "id"=>4199, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_WINDOWS_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1273, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 1 VM", "id"=>4303, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_1_VM", "softwareDescriptionId"=>1105, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - Unlimited VMs", "id"=>4307, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_UNLIMITED_VMS", "softwareDescriptionId"=>1112, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Redundant Private Network Uplinks", "id"=>4335, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.2", "id"=>4467, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_2", "softwareDescriptionId"=>1171, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Dual Public & Private Network Uplinks (Unbonded)", "id"=>5118, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_DUAL_PUBLIC_PRIVATE_NETWORK_UPLINKS_UNBONDED", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"80", "description"=>"80 GB NAS", "id"=>42, "itemTaxCategoryId"=>166, "keyName"=>"NAS_80_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>43}, {"capacity"=>"250", "description"=>"250 GB NAS", "id"=>44, "itemTaxCategoryId"=>166, "keyName"=>"NAS_250_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>411}, {"capacity"=>"1000", "description"=>"1 Gbps Public & Private Network Uplinks", "id"=>188, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"APF Software Firewall for Linux", "id"=>300, "itemTaxCategoryId"=>166, "keyName"=>"APF_SOFTWARE_FIREWALL_FOR_LINUX", "softwareDescriptionId"=>71, "upgradeItemId"=>nil}, {"description"=>"Nessus Vulnerability Assessment & Reporting", "id"=>307, "itemTaxCategoryId"=>98, "keyName"=>"NESSUS_VULNERABILITY_ASSESSMENT_REPORTING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"McAfee VirusScan Enterprise", "id"=>397, "itemTaxCategoryId"=>98, "keyName"=>"MCAFEE_VIRUSSCAN_ANTIVIRUS_WINDOWS", "softwareDescriptionId"=>820, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x (32 bit)", "id"=>419, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_32_BIT", "softwareDescriptionId"=>1239, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Non-RAID", "id"=>487, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_NONRAID", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Microsoft Windows Firewall", "id"=>495, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_WINDOWS_FIREWALL", "softwareDescriptionId"=>106, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Private Network Uplink", "id"=>498, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"80", "description"=>"80 GB iSCSI SAN Storage", "id"=>550, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_80_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>551}, {"capacity"=>"250", "description"=>"250GB EVault Disk to Disk Enterprise Backup", "id"=>561, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_250_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4183}, {"description"=>"Microsoft SQL Server 2008 Express", "id"=>681, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_EXPRESS", "softwareDescriptionId"=>308, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Enterprise", "id"=>682, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_ENTERPRISE", "softwareDescriptionId"=>307, "upgradeItemId"=>nil}, {"capacity"=>"30", "description"=>"30GB EVault Disk to Disk Enterprise Backup", "id"=>739, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_30_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>559}, {"capacity"=>"0", "description"=>"Windows Server 2008 Datacenter Edition SP2 (32bit)", "id"=>939, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_32_BIT_SP2", "softwareDescriptionId"=>450, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Standard R2", "id"=>1161, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_STANDARD_R2", "softwareDescriptionId"=>698, "upgradeItemId"=>nil}, {"capacity"=>"3000", "description"=>"3000 GB iSCSI SAN Storage", "id"=>1176, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_3000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"3", "description"=>"Monitoring Package - Premium Application", "id"=>1250, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_PREMIUM_APPLICATION", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 10 (Windows) Unlimited Domain w/ Power Pack", "id"=>3785, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_WINDOWS_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>788, "upgradeItemId"=>nil}, {"capacity"=>"10000", "description"=>"10 Gbps Private Network Uplink", "id"=>3957, "itemTaxCategoryId"=>166, "keyName"=>"10_GBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Standard Edition", "id"=>4148, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_STANDARD", "softwareDescriptionId"=>1003, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 5 Pack", "id"=>4154, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_5_PACK", "softwareDescriptionId"=>1012, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 Standard Edition (64 bit)", "id"=>4233, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_STD_64_BIT", "softwareDescriptionId"=>1076, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESXi 5.1", "id"=>4272, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESXI_5_1", "softwareDescriptionId"=>1086, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 5 VMs", "id"=>4304, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_5_VMS", "softwareDescriptionId"=>1109, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 10 VMs", "id"=>4305, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_10_VMS", "softwareDescriptionId"=>1110, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"15", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 15 VMs", "id"=>4306, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_15_VMS", "softwareDescriptionId"=>1111, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x (64 bit) (per-processor licensing)", "id"=>4319, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_64_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1228, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Server Backup 5.0 Enterprise (Linux)", "id"=>4343, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_SERVER_BACKUP_5_0_ENTERPRISE_LINUX", "softwareDescriptionId"=>1093, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 10 Pack", "id"=>4347, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_10_PACK", "softwareDescriptionId"=>1096, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable (32 bit)", "id"=>4404, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_32_BIT", "softwareDescriptionId"=>1169, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"RAID", "id"=>4478, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Datacenter Edition With Hyper-V (64bit)", "id"=>4548, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_DC_64_BIT_2", "softwareDescriptionId"=>1226, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Host Ping and TCP Service Monitoring", "id"=>50, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_HOST_PING_AND_TCP_SERVICE", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Public & Private Network Uplinks", "id"=>186, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>187}, {"description"=>"McAfee Host Intrusion Protection w/Reporting", "id"=>302, "itemTaxCategoryId"=>98, "keyName"=>"MCAFEE_HOST_INTRUSION_PROTECTION_WREPORTING", "softwareDescriptionId"=>916, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1.00 TB SATA II", "id"=>471, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_1_00TB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Private Network Uplink", "id"=>497, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>498}, {"capacity"=>"20", "description"=>"20 GB iSCSI SAN Storage", "id"=>548, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_20_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>549}, {"capacity"=>"40", "description"=>"40 GB iSCSI SAN Storage", "id"=>549, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_40_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>598}, {"capacity"=>"2000", "description"=>"2000 GB iSCSI SAN Storage", "id"=>626, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_2000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>1176}, {"description"=>"Microsoft SQL Server 2008 Standard", "id"=>683, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_STANDARD", "softwareDescriptionId"=>306, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Standard Edition (64bit)", "id"=>977, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_R2", "softwareDescriptionId"=>475, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Datacenter Edition (64bit)", "id"=>979, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_R2", "softwareDescriptionId"=>478, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 8.x (64 bit)", "id"=>1065, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_8_X_64_BIT_2", "softwareDescriptionId"=>1019, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"Virtuozzo Containers 4 for Linux - 4 processors - 10 VPS", "id"=>1081, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_4_PROCESSORS_10_VPS", "softwareDescriptionId"=>583, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"600", "description"=>"600 GB SA-SCSI 15K RPM", "id"=>1094, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_600GB_SASCSI_15K_RPM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"128", "description"=>"128 GB Registered DDR3 1066", "id"=>1133, "itemTaxCategoryId"=>166, "keyName"=>"RAM_128_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx (32 bit)", "id"=>1136, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_32_BIT", "softwareDescriptionId"=>774, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 9.x (32 bit)", "id"=>4137, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_9_X_32_BIT_2", "softwareDescriptionId"=>1264, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 25 Pack", "id"=>4156, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_25_PACK", "softwareDescriptionId"=>1016, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin (64 bit)", "id"=>4166, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_64_BIT", "softwareDescriptionId"=>1165, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"175", "description"=>"175GB EVault Disk to Disk Enterprise Backup", "id"=>4182, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_175_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>561}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Linux) Unlimited Domain w/ Power Pack", "id"=>4197, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_LINUX_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1197, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10000", "description"=>"10 Gbps Redundant Private Network Uplinks", "id"=>4341, "itemTaxCategoryId"=>166, "keyName"=>"10_GBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"800", "description"=>"800 GB SSD", "id"=>4356, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_800GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (128 TB)", "id"=>4369, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_128_TB", "softwareDescriptionId"=>1155, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (16 TB)", "id"=>4371, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_16_TB", "softwareDescriptionId"=>1153, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"No Operating System", "id"=>4648, "itemTaxCategoryId"=>166, "keyName"=>"OS_NO_OPERATING_SYSTEM", "softwareDescriptionId"=>1312, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10000", "description"=>"10 Gbps Dual Public & Private Network Uplinks (Unbonded)", "id"=>5106, "itemTaxCategoryId"=>166, "keyName"=>"10_GBPS_DUAL_PUBLIC_PRIVATE_NETWORK_UPLINKS_UNBONDED", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Standard Edition", "id"=>5124, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_STANDARD_EDITION", "softwareDescriptionId"=>1334, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.5 - Minimal Install (64 bit) - version-locked", "id"=>5984, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_5_MINIMAL_64_BIT", "softwareDescriptionId"=>1263, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"1 IP Address", "id"=>15, "itemTaxCategoryId"=>166, "keyName"=>"1_IP_ADDRESS", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"MySQL for Linux", "id"=>22, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_LINUX", "softwareDescriptionId"=>156, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Workgroup", "id"=>80, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_WORKGROUP", "softwareDescriptionId"=>20, "upgradeItemId"=>nil}, {"capacity"=>"20000", "description"=>"20000 GB Bandwidth", "id"=>249, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_20000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100Mbps Hardware Firewall", "id"=>298, "itemTaxCategoryId"=>166, "keyName"=>"100MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"Redundant Power Supply", "id"=>469, "itemTaxCategoryId"=>166, "keyName"=>"REDUNDANT_POWER_SUPPLY", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"500", "description"=>"500 GB SATA II", "id"=>14, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_500GB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Private Network Uplink", "id"=>496, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>497}, {"capacity"=>"250", "description"=>"250 GB iSCSI SAN Storage", "id"=>552, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_250_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>612}, {"capacity"=>"20", "description"=>"20GB EVault Disk to Disk Enterprise Backup", "id"=>558, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_20_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>739}, {"capacity"=>"500", "description"=>"500 GB NAS", "id"=>611, "itemTaxCategoryId"=>166, "keyName"=>"NAS_500_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>605}, {"description"=>"Microsoft SQL Server 2008 Workgroup", "id"=>684, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WORKGROUP", "softwareDescriptionId"=>304, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard Edition SP2 (64bit)", "id"=>936, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_SP2", "softwareDescriptionId"=>447, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Enterprise Edition (64bit)", "id"=>978, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_64_BIT_R2_2", "softwareDescriptionId"=>477, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Datacenter Edition With Hyper-V (64bit)", "id"=>980, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_R2_2", "softwareDescriptionId"=>478, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"RAID 0", "id"=>488, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_0", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"RAID 10", "id"=>491, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_10", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix Essentials for XenServer 5.5 (Billed per VM)", "id"=>1077, "itemTaxCategoryId"=>166, "keyName"=>"CITRIX_ESSENTIALS_XENSERVER_5_5", "softwareDescriptionId"=>521, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"256", "description"=>"256 GB Registered DDR3 1066", "id"=>1134, "itemTaxCategoryId"=>166, "keyName"=>"RAM_256_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Workgroup R2", "id"=>1164, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WORKGROUP_R2", "softwareDescriptionId"=>697, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Redundant Public & Private Network Uplinks", "id"=>1284, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_REDUNDANT_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 10 (Linux) Unlimited Domain w/ Power Pack", "id"=>1306, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_LINUX_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>939, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 5.6.1", "id"=>1322, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6_1", "softwareDescriptionId"=>801, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x (32 bit)", "id"=>3904, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_32_BIT", "softwareDescriptionId"=>1258, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 6.x Squeeze/Stable (32 bit)", "id"=>3967, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_6_X_SQUEEZE_32_BIT", "softwareDescriptionId"=>918, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESX 4.1", "id"=>3969, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESX_4_1", "softwareDescriptionId"=>800, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 5.x (64 bit)", "id"=>4093, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_5_X_64_BIT_3", "softwareDescriptionId"=>1158, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Express Edition", "id"=>4150, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_EXPRESS", "softwareDescriptionId"=>1005, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1500", "description"=>"1500GB EVault Disk to Disk Enterprise Backup", "id"=>4185, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_1500_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>955}, {"capacity"=>"0", "description"=>"Windows Server 2012 Datacenter Edition (64bit)", "id"=>4237, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_DC_64_BIT", "softwareDescriptionId"=>1082, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 1 Pack", "id"=>4345, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_1_PACK", "softwareDescriptionId"=>1094, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 25 Pack", "id"=>4348, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_25_PACK", "softwareDescriptionId"=>1097, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable (64 bit)", "id"=>4405, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_64_BIT", "softwareDescriptionId"=>1104, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware vCenter 5.5 Standard", "id"=>4598, "itemTaxCategoryId"=>166, "keyName"=>"VMWARE_VCENTER_5_5_STANDARD", "softwareDescriptionId"=>1275, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 12 - 30 Domain w/ Power Pack", "id"=>6010, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_12_30_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1414, "upgradeItemId"=>nil}, {"capacity"=>"8", "description"=>"8 Public IP Addresses", "id"=>17, "itemTaxCategoryId"=>166, "keyName"=>"8_PUBLIC_IP_ADDRESSES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"MySQL 5.0 for Windows", "id"=>23, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_0_WINDOWS", "softwareDescriptionId"=>13, "upgradeItemId"=>nil}, {"description"=>"Email and Ticket", "id"=>51, "itemTaxCategoryId"=>166, "keyName"=>"NOTIFICATION_EMAIL_AND_TICKET", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"NOC Monitoring", "id"=>54, "itemTaxCategoryId"=>166, "keyName"=>"NOC_MONITORING", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"cPanel/WHM with Fantastico and RVskin", "id"=>96, "itemTaxCategoryId"=>166, "keyName"=>"CPANELWHM_WITH_FANTASTICO_AND_RVSKIN", "softwareDescriptionId"=>31, "upgradeItemId"=>nil}, {"description"=>"Unlimited Bandwidth (100 Mbps Uplink)", "id"=>97, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_UNLIMITED_100_MBPS_UPLINK", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Reboot / KVM over IP", "id"=>504, "itemTaxCategoryId"=>166, "keyName"=>"REBOOT_KVM_OVER_IP", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1000 GB iSCSI SAN Storage", "id"=>554, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_1000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>783}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard Edition SP2 (32bit)", "id"=>933, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_32_BIT_SP2", "softwareDescriptionId"=>444, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Enterprise Edition SP2 (64bit)", "id"=>938, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_64_BIT_SP2", "softwareDescriptionId"=>449, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Datacenter Edition SP2 (64bit)", "id"=>940, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_SP2", "softwareDescriptionId"=>451, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Citrix XenServer 5.5", "id"=>950, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_5", "softwareDescriptionId"=>642, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Web Edition (64bit)", "id"=>976, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_64_BIT_R2_SP1", "softwareDescriptionId"=>832, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Standard SP2 with R2 (32 bit)", "id"=>421, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_STD_32_BIT_SP2_WR2", "softwareDescriptionId"=>125, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Web Edition SP2 (32bit)", "id"=>934, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_32_BIT_SP2", "softwareDescriptionId"=>445, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"RAID 1", "id"=>489, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_1", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"RAID 5", "id"=>490, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_5", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"70", "description"=>"Virtuozzo Containers 4 for Linux - 4 processors - 70 VPS", "id"=>1084, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_4_PROCESSORS_70_VPS", "softwareDescriptionId"=>586, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2.00 TB SATA II", "id"=>1091, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_2_00TB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Enterprise for XenServer 5.6", "id"=>1300, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ENTERPRISE_FOR_XENSERVER_5_6", "softwareDescriptionId"=>726, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin - Minimal Install (64 bit)", "id"=>4170, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_MINIMAL_64_BIT_2", "softwareDescriptionId"=>1184, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Windows) Unlimited Domain w/ Power Pack", "id"=>4200, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_WINDOWS_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1274, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.1", "id"=>4258, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_1", "softwareDescriptionId"=>1065, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware vCenter 5.1 Standard", "id"=>4298, "itemTaxCategoryId"=>166, "keyName"=>"VMWARE_VCENTER_5_1_STANDARD", "softwareDescriptionId"=>1090, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (4 TB)", "id"=>4372, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_4_TB", "softwareDescriptionId"=>1123, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"20", "description"=>"20Mbps Hardware Firewall", "id"=>4550, "itemTaxCategoryId"=>166, "keyName"=>"20MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.2.1", "id"=>4569, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_2_1", "softwareDescriptionId"=>1257, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MySQL 5.7 for Windows", "id"=>4592, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_7_WINDOWS", "softwareDescriptionId"=>1272, "upgradeItemId"=>nil}, {"capacity"=>"10000", "description"=>"10 Gbps Dual Private Network Uplinks (Unbonded)", "id"=>5102, "itemTaxCategoryId"=>166, "keyName"=>"10_GBPS_DUAL_PRIVATE_NETWORK_UPLINKS_UNBONDED", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Enterprise Edition", "id"=>5120, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_ENTERPRISE_EDITION_2", "softwareDescriptionId"=>1330, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Enterprise", "id"=>81, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_ENTERPRISE", "softwareDescriptionId"=>21, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Public & Private Network Uplinks", "id"=>187, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>188}, {"capacity"=>"1000", "description"=>"1000Mbps Hardware Firewall", "id"=>297, "itemTaxCategoryId"=>166, "keyName"=>"1000MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x (64 bit)", "id"=>420, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_64_BIT", "softwareDescriptionId"=>1240, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Enterprise SP2 with R2 (32 bit)", "id"=>423, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_ENT_32_BIT_SP2_WR2", "softwareDescriptionId"=>128, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 8.x (32 bit)", "id"=>1066, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_8_X_32_BIT", "softwareDescriptionId"=>1022, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"60", "description"=>"60GB EVault Disk to Disk Enterprise Backup", "id"=>1076, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_60_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>560}, {"capacity"=>"3", "description"=>"Virtuozzo Containers 4 for Linux - 4 processors - 3 VPS", "id"=>1079, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_4_PROCESSORS_3_VPS", "softwareDescriptionId"=>581, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"150", "description"=>"Virtuozzo Containers 4 for Linux - 4 processors - 150 VPS", "id"=>1086, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_4_PROCESSORS_150_VPS", "softwareDescriptionId"=>588, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"2", "description"=>"Monitoring Package - Advanced", "id"=>1249, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_ADVANCED", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"capacity"=>"10000", "description"=>"10 Gbps Public & Private Network Uplinks", "id"=>1281, "itemTaxCategoryId"=>166, "keyName"=>"10_GBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"50", "description"=>"50GB EVault Disk to Disk Enterprise Backup", "id"=>3784, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_50_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>1076}, {"description"=>"Parallels Plesk Panel 10 (Windows) 100 Domain w/ Power Pack", "id"=>3786, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_WINDOWS_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>787, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x (64 bit)", "id"=>3907, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_64_BIT", "softwareDescriptionId"=>1261, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Redundant Private Network Uplinks", "id"=>3956, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"3000", "description"=>"3.00 TB SATA III", "id"=>3989, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_3_00TB_SATA_III", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Enterprise for XenServer 6.x", "id"=>4105, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ENTERPRISE_FOR_XENSERVER_6_X", "softwareDescriptionId"=>909, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 1 Pack", "id"=>4153, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_1_PACK", "softwareDescriptionId"=>1015, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin (32 bit)", "id"=>4165, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_32_BIT", "softwareDescriptionId"=>1166, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Dual Public & Private Network Uplinks (Unbonded)", "id"=>4263, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_DUAL_PUBLIC_PRIVATE_NETWORK_UPLINKS_UNBONDED", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"4000", "description"=>"4.00 TB SATA III", "id"=>4281, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_4_00TB_SATA_III", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x (64 bit) (per-processor licensing)", "id"=>4321, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_64_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1247, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable - Minimal Install (32 bit)", "id"=>4406, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_MINIMAL_32_BIT", "softwareDescriptionId"=>1176, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable - Minimal Install (64 bit)", "id"=>4407, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_MINIMAL_64_BIT", "softwareDescriptionId"=>1177, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MySQL 5.0.51 for Windows", "id"=>4557, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_0_51_WINDOWS", "softwareDescriptionId"=>220, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESXi 5.5", "id"=>4562, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESXI_5_5", "softwareDescriptionId"=>1256, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 10.x (32 bit)", "id"=>4640, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_10_X_32_BIT", "softwareDescriptionId"=>1284, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 10.x (64 bit)", "id"=>4638, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_10_X_64_BIT", "softwareDescriptionId"=>1286, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Express Edition", "id"=>5122, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_EXPRESS_EDITION", "softwareDescriptionId"=>1332, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 12 - Unlimited Domain w/ Power Pack", "id"=>6014, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_12_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1420, "upgradeItemId"=>nil}, {"capacity"=>"4", "description"=>"4 Public IP Addresses", "id"=>16, "itemTaxCategoryId"=>166, "keyName"=>"4_PUBLIC_IP_ADDRESSES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Unlimited Bandwidth (10 Mbps Uplink)", "id"=>30, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_UNLIMITED_10_MBPS_UPLINK", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB NAS", "id"=>43, "itemTaxCategoryId"=>166, "keyName"=>"NAS_100_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>44}, {"description"=>"Business Continuance Insurance", "id"=>84, "itemTaxCategoryId"=>108, "keyName"=>"BUSINESS_CONTINUANCE_INSURANCE", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100GB EVault Disk to Disk Enterprise Backup", "id"=>560, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_100_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4182}, {"capacity"=>"64", "description"=>"/64 Block Static Public IPv6 Addresses", "id"=>784, "itemTaxCategoryId"=>166, "keyName"=>"64_BLOCK_STATIC_PUBLIC_IPV6_ADDRESSES", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESX 4.0", "id"=>1078, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESX_4_0", "softwareDescriptionId"=>497, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"50", "description"=>"Virtuozzo Containers 4 for Linux - 4 processors - 50 VPS", "id"=>1083, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_4_PROCESSORS_50_VPS", "softwareDescriptionId"=>585, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"64", "description"=>"64 GB Registered DDR3 1066", "id"=>1132, "itemTaxCategoryId"=>166, "keyName"=>"RAM_64_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx (64 bit)", "id"=>1137, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_64_BIT", "softwareDescriptionId"=>775, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Enterprise R2", "id"=>1165, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_ENTERPRISE_R2", "softwareDescriptionId"=>699, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Datacenter R2", "id"=>1166, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_DATACENTER_R2", "softwareDescriptionId"=>700, "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Monitoring Package - Basic", "id"=>1248, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_BASIC", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2000Mbps Hardware Firewall", "id"=>1296, "itemTaxCategoryId"=>166, "keyName"=>"2000MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Advanced for XenServer 5.6", "id"=>1299, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ADVANCED_FOR_XENSERVER_5_6", "softwareDescriptionId"=>726, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"96", "description"=>"96 GB Registered DDR3 1066", "id"=>1146, "itemTaxCategoryId"=>166, "keyName"=>"RAM_96_GB_DDR3_1066_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"EVault Plugin - BMR (Bare Metal Restore)", "id"=>961, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_PLUGIN_BMR_BARE_METAL_RESTORE", "softwareDescriptionId"=>467, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Advanced for XenServer 6.x", "id"=>4104, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ADVANCED_FOR_XENSERVER_6_X", "softwareDescriptionId"=>908, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 9.x (64 bit)", "id"=>4138, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_9_X_64_BIT", "softwareDescriptionId"=>1265, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"400", "description"=>"400 GB SSD", "id"=>4181, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_400GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Cloudera Distribution for Hadoop 4", "id"=>4301, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_CLOUDERA_DISTRIBUTION_HADOOP_4", "softwareDescriptionId"=>1099, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x (32 bit) (per-processor licensing)", "id"=>4320, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_32_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1246, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Riak 1.x", "id"=>4327, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_RIAK_1_X", "softwareDescriptionId"=>1114, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Redundant Private Network Uplinks", "id"=>4331, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Redundant Public & Private Network Uplinks", "id"=>4336, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_REDUNDANT_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>1284}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (48 TB)", "id"=>4370, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_48_TB", "softwareDescriptionId"=>1154, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Standard Edition (64 bit)", "id"=>4549, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_STD_64_BIT", "softwareDescriptionId"=>1225, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Express", "id"=>24, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_EXPRESS", "softwareDescriptionId"=>9, "upgradeItemId"=>nil}, {"capacity"=>"40", "description"=>"40 GB NAS", "id"=>41, "itemTaxCategoryId"=>166, "keyName"=>"NAS_40_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>42}, {"description"=>"Host Ping", "id"=>49, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_HOST_PING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Automated Notification", "id"=>52, "itemTaxCategoryId"=>166, "keyName"=>"AUTOMATED_NOTIFICATION", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Automated Reboot from Monitoring", "id"=>53, "itemTaxCategoryId"=>166, "keyName"=>"AUTOMATED_REBOOT_FROM_MONITORING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"300", "description"=>"300 GB SA-SCSI 15K RPM", "id"=>352, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_300GB_SASCSI_15K_RPM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"500", "description"=>"500 GB iSCSI SAN Storage", "id"=>553, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_500_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>621}, {"capacity"=>"500", "description"=>"500GB EVault Disk to Disk Enterprise Backup", "id"=>562, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_500_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4184}, {"capacity"=>"120", "description"=>"120 GB iSCSI SAN Storage", "id"=>575, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_120_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>622}, {"capacity"=>"0", "description"=>"FreeBSD 7.x  (32 bit)", "id"=>638, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_7_X_32_BIT", "softwareDescriptionId"=>666, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Web Edition SP2 (64bit)", "id"=>935, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_64_BIT_SP2", "softwareDescriptionId"=>446, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Cloudera Distribution for Hadoop 2", "id"=>1044, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_CLOUDERA_DISTRIBUTION_HADOOP_2", "softwareDescriptionId"=>520, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"30", "description"=>"Virtuozzo Containers 4 for Linux - 4 processors - 30 VPS", "id"=>1082, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_4_PROCESSORS_30_VPS", "softwareDescriptionId"=>584, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"32", "description"=>"32 GB Registered DDR3 1066", "id"=>1131, "itemTaxCategoryId"=>166, "keyName"=>"RAM_32_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"description"=>"Citrix XenServer 5.6", "id"=>1189, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6", "softwareDescriptionId"=>704, "upgradeItemId"=>nil}, {"capacity"=>"512", "description"=>"512 GB Registered DDR3 1066", "id"=>1319, "itemTaxCategoryId"=>166, "keyName"=>"RAM_512_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Quad Processor 10 Core Westmere EX 4850 - 2.00GHz - 4 x 24MB cache", "id"=>3843, "itemTaxCategoryId"=>166, "keyName"=>"INTEL_XEON_4850_2_00", "softwareDescriptionId"=>nil, "units"=>"GHz", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft WebMatrix", "id"=>3898, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_WEBMATRIX_2", "softwareDescriptionId"=>868, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"International Services", "id"=>3955, "itemTaxCategoryId"=>166, "keyName"=>"INTERNATIONAL_SERVICES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 6.x (32 bit)", "id"=>4094, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_6_X_32_BIT_2", "softwareDescriptionId"=>1172, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 6.x (64 bit)", "id"=>4095, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_6_X_64_BIT", "softwareDescriptionId"=>1175, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"64", "description"=>"1 IPv6 Address", "id"=>4097, "itemTaxCategoryId"=>166, "keyName"=>"1_IPV6_ADDRESS", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Web Edition", "id"=>4147, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_WEB", "softwareDescriptionId"=>1004, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Enterprise Edition", "id"=>4149, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_ENTERPRISE", "softwareDescriptionId"=>1001, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MongoDB", "id"=>4226, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MONGODB", "softwareDescriptionId"=>1083, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 Datacenter Edition With Hyper-V (64bit)", "id"=>4247, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_DC_64_BIT_2", "softwareDescriptionId"=>1082, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x (32 bit) (per-processor licensing)", "id"=>4318, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_32_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1227, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Redundant Public & Private Network Uplinks", "id"=>4332, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_REDUNDANT_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>4336}, {"capacity"=>"0", "description"=>"Idera Server Backup 5.0 Enterprise (Windows)", "id"=>4344, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_SERVER_BACKUP_5_0_ENTERPRISE_WINDOWS", "softwareDescriptionId"=>1092, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 5 Pack", "id"=>4346, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_5_PACK", "softwareDescriptionId"=>1095, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"0 GB Bandwidth", "id"=>4481, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_0_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Datacenter Edition (64bit)", "id"=>4547, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_DC_64_BIT", "softwareDescriptionId"=>1226, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"200", "description"=>"200Mbps Hardware Firewall", "id"=>4551, "itemTaxCategoryId"=>166, "keyName"=>"200MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"cPanel/WHM with Softaculous and RVskin", "id"=>4608, "itemTaxCategoryId"=>166, "keyName"=>"CPANELWHM_WITH_SOFTACULOUS_AND_RVSKIN", "softwareDescriptionId"=>1292, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 7.x (64 bit)", "id"=>5920, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_7_X_64_BIT", "softwareDescriptionId"=>1400, "units"=>"N/A", "upgradeItemId"=>nil}]
          fixture_package_items[58] = [{"capacity"=>"6000", "description"=>"6000 GB Bandwidth", "id"=>100, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_6000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>249}, {"capacity"=>"1000", "description"=>"1 Gbps Public & Private Network Uplinks", "id"=>188, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"8000", "description"=>"8000 GB Bandwidth", "id"=>101, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_8000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>249}, {"capacity"=>"5000", "description"=>"5000 GB Bandwidth", "id"=>173, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_5000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>249}, {"capacity"=>"10", "description"=>"10 Mbps Public & Private Network Uplinks", "id"=>186, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>187}, {"capacity"=>"1", "description"=>"1 IP Address", "id"=>15, "itemTaxCategoryId"=>166, "keyName"=>"1_IP_ADDRESS", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"10000", "description"=>"10000 GB Bandwidth", "id"=>102, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_10000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>249}, {"capacity"=>"20000", "description"=>"20000 GB Bandwidth", "id"=>249, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_20000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"8", "description"=>"8 Public IP Addresses", "id"=>17, "itemTaxCategoryId"=>166, "keyName"=>"8_PUBLIC_IP_ADDRESSES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Unlimited Bandwidth (100 Mbps Uplink)", "id"=>97, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_UNLIMITED_100_MBPS_UPLINK", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Public & Private Network Uplinks", "id"=>187, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>188}, {"capacity"=>"4", "description"=>"4 Public IP Addresses", "id"=>16, "itemTaxCategoryId"=>166, "keyName"=>"4_PUBLIC_IP_ADDRESSES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Unlimited Bandwidth (10 Mbps Uplink)", "id"=>30, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_UNLIMITED_10_MBPS_UPLINK", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"1U Colocation Appliance", "id"=>1314, "itemTaxCategoryId"=>60, "keyName"=>"1U_COLOCATION_APPLIANCE", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"12000", "description"=>"12000 GB Bandwidth", "id"=>206, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_12000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>249}, {"capacity"=>"0", "description"=>"International Services", "id"=>3955, "itemTaxCategoryId"=>166, "keyName"=>"INTERNATIONAL_SERVICES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}]
          fixture_package_items[60] = []
          fixture_package_items[61] = []
          fixture_package_items[62] = [{"description"=>"Dual Port 1000mbps NIC", "id"=>2551, "itemTaxCategoryId"=>166, "keyName"=>"DUAL_PORT_1000MBPS_NIC", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"32", "description"=>"32 GB RAM", "id"=>2515, "itemTaxCategoryId"=>166, "keyName"=>"LEGACY_32_GB_RAM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}]
          fixture_package_items[63] = [{"description"=>"Dual Port 1000mbps NIC", "id"=>2551, "itemTaxCategoryId"=>166, "keyName"=>"DUAL_PORT_1000MBPS_NIC", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"32", "description"=>"32 GB RAM", "id"=>2515, "itemTaxCategoryId"=>166, "keyName"=>"LEGACY_32_GB_RAM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}]
          fixture_package_items[64] = [{"description"=>"Dual Port 1000mbps NIC", "id"=>2551, "itemTaxCategoryId"=>166, "keyName"=>"DUAL_PORT_1000MBPS_NIC", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"32", "description"=>"32 GB RAM", "id"=>2515, "itemTaxCategoryId"=>166, "keyName"=>"LEGACY_32_GB_RAM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}]
          fixture_package_items[65] = []
          fixture_package_items[66] = [{"capacity"=>"32", "description"=>"32 GB RAM", "id"=>2515, "itemTaxCategoryId"=>166, "keyName"=>"LEGACY_32_GB_RAM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}]
          fixture_package_items[67] = [{"description"=>"Dual Port 1000mbps NIC", "id"=>2551, "itemTaxCategoryId"=>166, "keyName"=>"DUAL_PORT_1000MBPS_NIC", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"32", "description"=>"32 GB RAM", "id"=>2515, "itemTaxCategoryId"=>166, "keyName"=>"LEGACY_32_GB_RAM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}]
          fixture_package_items[68] = [{"description"=>"Dual Port 1000mbps NIC", "id"=>2551, "itemTaxCategoryId"=>166, "keyName"=>"DUAL_PORT_1000MBPS_NIC", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"32", "description"=>"32 GB RAM", "id"=>2515, "itemTaxCategoryId"=>166, "keyName"=>"LEGACY_32_GB_RAM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}]
          fixture_package_items[69] = [{"description"=>"Dual Port 1000mbps NIC", "id"=>2551, "itemTaxCategoryId"=>166, "keyName"=>"DUAL_PORT_1000MBPS_NIC", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"32", "description"=>"32 GB RAM", "id"=>2515, "itemTaxCategoryId"=>166, "keyName"=>"LEGACY_32_GB_RAM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}]
          fixture_package_items[70] = []
          fixture_package_items[71] = []
          fixture_package_items[72] = [{"description"=>"Dual Port 1000mbps NIC", "id"=>2551, "itemTaxCategoryId"=>166, "keyName"=>"DUAL_PORT_1000MBPS_NIC", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}]
          fixture_package_items[73] = [{"description"=>"Dual Port 1000mbps NIC", "id"=>2551, "itemTaxCategoryId"=>166, "keyName"=>"DUAL_PORT_1000MBPS_NIC", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}]
          fixture_package_items[74] = []
          fixture_package_items[75] = []
          fixture_package_items[76] = [{"description"=>"Dual Port 1000mbps NIC", "id"=>2551, "itemTaxCategoryId"=>166, "keyName"=>"DUAL_PORT_1000MBPS_NIC", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}]
          fixture_package_items[77] = [{"description"=>"Dual Port 1000mbps NIC", "id"=>2551, "itemTaxCategoryId"=>166, "keyName"=>"DUAL_PORT_1000MBPS_NIC", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}]
          fixture_package_items[78] = [{"capacity"=>"32", "description"=>"32 GB RAM", "id"=>2515, "itemTaxCategoryId"=>166, "keyName"=>"LEGACY_32_GB_RAM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}]
          fixture_package_items[79] = [{"description"=>"Dual Port 1000mbps NIC", "id"=>2551, "itemTaxCategoryId"=>166, "keyName"=>"DUAL_PORT_1000MBPS_NIC", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"32", "description"=>"32 GB RAM", "id"=>2515, "itemTaxCategoryId"=>166, "keyName"=>"LEGACY_32_GB_RAM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}]
          fixture_package_items[80] = [{"description"=>"Dual Port 1000mbps NIC", "id"=>2551, "itemTaxCategoryId"=>166, "keyName"=>"DUAL_PORT_1000MBPS_NIC", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}]
          fixture_package_items[81] = [{"description"=>"Dual Port 1000mbps NIC", "id"=>2551, "itemTaxCategoryId"=>166, "keyName"=>"DUAL_PORT_1000MBPS_NIC", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}]
          fixture_package_items[82] = []
          fixture_package_items[83] = [{"description"=>"Dual Port 1000mbps NIC", "id"=>2551, "itemTaxCategoryId"=>166, "keyName"=>"DUAL_PORT_1000MBPS_NIC", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}]
          fixture_package_items[84] = []
          fixture_package_items[85] = []
          fixture_package_items[86] = []
          fixture_package_items[87] = []
          fixture_package_items[88] = []
          fixture_package_items[89] = []
          fixture_package_items[90] = []
          fixture_package_items[91] = []
          fixture_package_items[92] = []
          fixture_package_items[93] = []
          fixture_package_items[94] = [{"description"=>"Dual Port 1000mbps NIC", "id"=>2551, "itemTaxCategoryId"=>166, "keyName"=>"DUAL_PORT_1000MBPS_NIC", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"32", "description"=>"32 GB RAM", "id"=>2515, "itemTaxCategoryId"=>166, "keyName"=>"LEGACY_32_GB_RAM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}]
          fixture_package_items[95] = [{"description"=>"Dual Port 1000mbps NIC", "id"=>2551, "itemTaxCategoryId"=>166, "keyName"=>"DUAL_PORT_1000MBPS_NIC", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"32", "description"=>"32 GB RAM", "id"=>2515, "itemTaxCategoryId"=>166, "keyName"=>"LEGACY_32_GB_RAM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}]
          fixture_package_items[96] = [{"description"=>"Dual Port 1000mbps NIC", "id"=>2551, "itemTaxCategoryId"=>166, "keyName"=>"DUAL_PORT_1000MBPS_NIC", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"32", "description"=>"32 GB RAM", "id"=>2515, "itemTaxCategoryId"=>166, "keyName"=>"LEGACY_32_GB_RAM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}]
          fixture_package_items[97] = [{"description"=>"Dual Port 1000mbps NIC", "id"=>2551, "itemTaxCategoryId"=>166, "keyName"=>"DUAL_PORT_1000MBPS_NIC", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"32", "description"=>"32 GB RAM", "id"=>2515, "itemTaxCategoryId"=>166, "keyName"=>"LEGACY_32_GB_RAM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}]
          fixture_package_items[98] = [{"description"=>"Dual Port 1000mbps NIC", "id"=>2551, "itemTaxCategoryId"=>166, "keyName"=>"DUAL_PORT_1000MBPS_NIC", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"32", "description"=>"32 GB RAM", "id"=>2515, "itemTaxCategoryId"=>166, "keyName"=>"LEGACY_32_GB_RAM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}]
          fixture_package_items[99] = [{"description"=>"Dual Port 1000mbps NIC", "id"=>2551, "itemTaxCategoryId"=>166, "keyName"=>"DUAL_PORT_1000MBPS_NIC", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}]
          fixture_package_items[100] = [{"description"=>"Dual Port 1000mbps NIC", "id"=>2551, "itemTaxCategoryId"=>166, "keyName"=>"DUAL_PORT_1000MBPS_NIC", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}]
          fixture_package_items[101] = [{"description"=>"Dual Port 1000mbps NIC", "id"=>2551, "itemTaxCategoryId"=>166, "keyName"=>"DUAL_PORT_1000MBPS_NIC", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"32", "description"=>"32 GB RAM", "id"=>2515, "itemTaxCategoryId"=>166, "keyName"=>"LEGACY_32_GB_RAM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}]
          fixture_package_items[102] = [{"description"=>"Dual Port 1000mbps NIC", "id"=>2551, "itemTaxCategoryId"=>166, "keyName"=>"DUAL_PORT_1000MBPS_NIC", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"32", "description"=>"32 GB RAM", "id"=>2515, "itemTaxCategoryId"=>166, "keyName"=>"LEGACY_32_GB_RAM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}]
          fixture_package_items[103] = []
          fixture_package_items[104] = [{"description"=>"Dual Port 1000mbps NIC", "id"=>2551, "itemTaxCategoryId"=>166, "keyName"=>"DUAL_PORT_1000MBPS_NIC", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}]
          fixture_package_items[105] = [{"description"=>"Dual Port 1000mbps NIC", "id"=>2551, "itemTaxCategoryId"=>166, "keyName"=>"DUAL_PORT_1000MBPS_NIC", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}]
          fixture_package_items[106] = []
          fixture_package_items[107] = []
          fixture_package_items[108] = []
          fixture_package_items[109] = [{"capacity"=>"32", "description"=>"32 GB RAM", "id"=>2515, "itemTaxCategoryId"=>166, "keyName"=>"LEGACY_32_GB_RAM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}]
          fixture_package_items[110] = [{"capacity"=>"32", "description"=>"32 GB RAM", "id"=>2515, "itemTaxCategoryId"=>166, "keyName"=>"LEGACY_32_GB_RAM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}]
          fixture_package_items[111] = []
          fixture_package_items[112] = [{"capacity"=>"32", "description"=>"32 GB RAM", "id"=>2515, "itemTaxCategoryId"=>166, "keyName"=>"LEGACY_32_GB_RAM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}]
          fixture_package_items[113] = [{"capacity"=>"32", "description"=>"32 GB RAM", "id"=>2515, "itemTaxCategoryId"=>166, "keyName"=>"LEGACY_32_GB_RAM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}]
          fixture_package_items[114] = [{"capacity"=>"32", "description"=>"32 GB RAM", "id"=>2515, "itemTaxCategoryId"=>166, "keyName"=>"LEGACY_32_GB_RAM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}]
          fixture_package_items[115] = [{"capacity"=>"32", "description"=>"32 GB RAM", "id"=>2515, "itemTaxCategoryId"=>166, "keyName"=>"LEGACY_32_GB_RAM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}]
          fixture_package_items[116] = [{"capacity"=>"32", "description"=>"32 GB RAM", "id"=>2515, "itemTaxCategoryId"=>166, "keyName"=>"LEGACY_32_GB_RAM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}]
          fixture_package_items[117] = [{"capacity"=>"32", "description"=>"32 GB RAM", "id"=>2515, "itemTaxCategoryId"=>166, "keyName"=>"LEGACY_32_GB_RAM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}]
          fixture_package_items[118] = [{"description"=>"Dual Port 1000mbps NIC", "id"=>2551, "itemTaxCategoryId"=>166, "keyName"=>"DUAL_PORT_1000MBPS_NIC", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}]
          fixture_package_items[119] = [{"description"=>"Dual Port 1000mbps NIC", "id"=>2551, "itemTaxCategoryId"=>166, "keyName"=>"DUAL_PORT_1000MBPS_NIC", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}]
          fixture_package_items[120] = []
          fixture_package_items[121] = []
          fixture_package_items[122] = [{"description"=>"Dual Port 1000mbps NIC", "id"=>2551, "itemTaxCategoryId"=>166, "keyName"=>"DUAL_PORT_1000MBPS_NIC", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}]
          fixture_package_items[123] = [{"description"=>"Dual Port 1000mbps NIC", "id"=>2551, "itemTaxCategoryId"=>166, "keyName"=>"DUAL_PORT_1000MBPS_NIC", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}]
          fixture_package_items[124] = []
          fixture_package_items[125] = []
          fixture_package_items[126] = [{"capacity"=>"20", "description"=>"20 GB NAS", "id"=>40, "itemTaxCategoryId"=>166, "keyName"=>"NAS_20_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>41}, {"description"=>"Microsoft SQL Server 2005 Standard", "id"=>79, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_STANDARD", "softwareDescriptionId"=>8, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10Mbps Hardware Firewall", "id"=>299, "itemTaxCategoryId"=>166, "keyName"=>"10MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"Unlimited SSL VPN Users & 1 PPTP VPN User per account", "id"=>309, "itemTaxCategoryId"=>166, "keyName"=>"UNLIMITED_SSL_VPN_USERS_1_PPTP_VPN_USER_PER_ACCOUNT", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Enterprise SP2 with R2 (64 bit)", "id"=>424, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_ENT_64_BIT_SP2_WR2", "softwareDescriptionId"=>127, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Standard SP2 with R2 (64 bit)", "id"=>422, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_STD_64_BIT_SP2_WR2", "softwareDescriptionId"=>126, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB iSCSI SAN Storage", "id"=>551, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_100_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>575}, {"capacity"=>"40", "description"=>"40GB EVault Disk to Disk Enterprise Backup", "id"=>559, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_40_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>3784}, {"capacity"=>"1000", "description"=>"1000GB EVault Disk to Disk Enterprise Backup", "id"=>563, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_1000_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4185}, {"capacity"=>"0", "description"=>"FreeBSD 7.x  (64 bit)", "id"=>637, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_7_X_64_BIT", "softwareDescriptionId"=>667, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Web", "id"=>685, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WEB", "softwareDescriptionId"=>305, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Enterprise Edition SP2 (32bit)", "id"=>937, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_32_BIT_SP2", "softwareDescriptionId"=>448, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2000GB EVault Disk to Disk Enterprise Backup", "id"=>955, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_2000_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Web R2", "id"=>1163, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WEB_R2", "softwareDescriptionId"=>696, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Express R2", "id"=>1162, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_EXPRESS_R2", "softwareDescriptionId"=>701, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 10 (Linux) 100 Domain w/ Power Pack", "id"=>1305, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_LINUX_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>938, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"200", "description"=>"200 GB SSD", "id"=>3811, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_200GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 6.x Squeeze/Stable (64 bit)", "id"=>3968, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_6_X_SQUEEZE_64_BIT", "softwareDescriptionId"=>919, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.0.0", "id"=>3977, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_0_0", "softwareDescriptionId"=>836, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 5.x (32 bit)", "id"=>4092, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_5_X_32_BIT_2", "softwareDescriptionId"=>1156, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.0.2", "id"=>4133, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_0_2", "softwareDescriptionId"=>961, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 10 Pack", "id"=>4155, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_10_PACK", "softwareDescriptionId"=>1011, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin - Minimal Install (32 bit)", "id"=>4169, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_MINIMAL_32_BIT", "softwareDescriptionId"=>1186, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"350", "description"=>"350GB EVault Disk to Disk Enterprise Backup", "id"=>4183, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_350_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>562}, {"capacity"=>"750", "description"=>"750GB EVault Disk to Disk Enterprise Backup", "id"=>4184, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_750_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>563}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Linux) 100 Domain w/ Power Pack", "id"=>4195, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_LINUX_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1191, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Windows) 100 Domain w/ Power Pack", "id"=>4199, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_WINDOWS_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1273, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 1 VM", "id"=>4303, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_1_VM", "softwareDescriptionId"=>1105, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - Unlimited VMs", "id"=>4307, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_UNLIMITED_VMS", "softwareDescriptionId"=>1112, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Redundant Private Network Uplinks", "id"=>4335, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.2", "id"=>4467, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_2", "softwareDescriptionId"=>1171, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Dual Public & Private Network Uplinks (Unbonded)", "id"=>5118, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_DUAL_PUBLIC_PRIVATE_NETWORK_UPLINKS_UNBONDED", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"80", "description"=>"80 GB NAS", "id"=>42, "itemTaxCategoryId"=>166, "keyName"=>"NAS_80_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>43}, {"capacity"=>"250", "description"=>"250 GB NAS", "id"=>44, "itemTaxCategoryId"=>166, "keyName"=>"NAS_250_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>411}, {"capacity"=>"1000", "description"=>"1 Gbps Public & Private Network Uplinks", "id"=>188, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"APF Software Firewall for Linux", "id"=>300, "itemTaxCategoryId"=>166, "keyName"=>"APF_SOFTWARE_FIREWALL_FOR_LINUX", "softwareDescriptionId"=>71, "upgradeItemId"=>nil}, {"description"=>"Nessus Vulnerability Assessment & Reporting", "id"=>307, "itemTaxCategoryId"=>98, "keyName"=>"NESSUS_VULNERABILITY_ASSESSMENT_REPORTING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"McAfee VirusScan Enterprise", "id"=>397, "itemTaxCategoryId"=>98, "keyName"=>"MCAFEE_VIRUSSCAN_ANTIVIRUS_WINDOWS", "softwareDescriptionId"=>820, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x (32 bit)", "id"=>419, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_32_BIT", "softwareDescriptionId"=>1239, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Non-RAID", "id"=>487, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_NONRAID", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Microsoft Windows Firewall", "id"=>495, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_WINDOWS_FIREWALL", "softwareDescriptionId"=>106, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Private Network Uplink", "id"=>498, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"80", "description"=>"80 GB iSCSI SAN Storage", "id"=>550, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_80_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>551}, {"capacity"=>"250", "description"=>"250GB EVault Disk to Disk Enterprise Backup", "id"=>561, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_250_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4183}, {"description"=>"Microsoft SQL Server 2008 Express", "id"=>681, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_EXPRESS", "softwareDescriptionId"=>308, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Enterprise", "id"=>682, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_ENTERPRISE", "softwareDescriptionId"=>307, "upgradeItemId"=>nil}, {"capacity"=>"30", "description"=>"30GB EVault Disk to Disk Enterprise Backup", "id"=>739, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_30_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>559}, {"capacity"=>"10", "description"=>"Virtuozzo Containers 4 for Linux - 10 VPS", "id"=>741, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_10_VPS", "softwareDescriptionId"=>318, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Datacenter Edition SP2 (32bit)", "id"=>939, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_32_BIT_SP2", "softwareDescriptionId"=>450, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Standard R2", "id"=>1161, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_STANDARD_R2", "softwareDescriptionId"=>698, "upgradeItemId"=>nil}, {"capacity"=>"3000", "description"=>"3000 GB iSCSI SAN Storage", "id"=>1176, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_3000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"3", "description"=>"Monitoring Package - Premium Application", "id"=>1250, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_PREMIUM_APPLICATION", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 10 (Windows) Unlimited Domain w/ Power Pack", "id"=>3785, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_WINDOWS_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>788, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Standard Edition", "id"=>4148, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_STANDARD", "softwareDescriptionId"=>1003, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 5 Pack", "id"=>4154, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_5_PACK", "softwareDescriptionId"=>1012, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 Standard Edition (64 bit)", "id"=>4233, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_STD_64_BIT", "softwareDescriptionId"=>1076, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESXi 5.1", "id"=>4272, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESXI_5_1", "softwareDescriptionId"=>1086, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 5 VMs", "id"=>4304, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_5_VMS", "softwareDescriptionId"=>1109, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 10 VMs", "id"=>4305, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_10_VMS", "softwareDescriptionId"=>1110, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"15", "description"=>"Parallels Cloud Server 6.0 Service Provider Edition - 15 VMs", "id"=>4306, "itemTaxCategoryId"=>166, "keyName"=>"OS_PARALLELS_CLOUD_SERVER_6_0_SERVICE_PROVIDER_EDITION_15_VMS", "softwareDescriptionId"=>1111, "units"=>"VM", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x (64 bit) (per-processor licensing)", "id"=>4319, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_64_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1228, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Server Backup 5.0 Enterprise (Linux)", "id"=>4343, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_SERVER_BACKUP_5_0_ENTERPRISE_LINUX", "softwareDescriptionId"=>1093, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 10 Pack", "id"=>4347, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_10_PACK", "softwareDescriptionId"=>1096, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable (32 bit)", "id"=>4404, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_32_BIT", "softwareDescriptionId"=>1169, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"RAID", "id"=>4478, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Datacenter Edition With Hyper-V (64bit)", "id"=>4548, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_DC_64_BIT_2", "softwareDescriptionId"=>1226, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Host Ping and TCP Service Monitoring", "id"=>50, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_HOST_PING_AND_TCP_SERVICE", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Public & Private Network Uplinks", "id"=>186, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>187}, {"description"=>"McAfee Host Intrusion Protection w/Reporting", "id"=>302, "itemTaxCategoryId"=>98, "keyName"=>"MCAFEE_HOST_INTRUSION_PROTECTION_WREPORTING", "softwareDescriptionId"=>916, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1.00 TB SATA II", "id"=>471, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_1_00TB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Private Network Uplink", "id"=>497, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>498}, {"capacity"=>"20", "description"=>"20 GB iSCSI SAN Storage", "id"=>548, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_20_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>549}, {"capacity"=>"40", "description"=>"40 GB iSCSI SAN Storage", "id"=>549, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_40_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>598}, {"capacity"=>"2000", "description"=>"2000 GB iSCSI SAN Storage", "id"=>626, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_2000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>1176}, {"description"=>"Microsoft SQL Server 2008 Standard", "id"=>683, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_STANDARD", "softwareDescriptionId"=>306, "upgradeItemId"=>nil}, {"capacity"=>"70", "description"=>"Virtuozzo Containers 4 for Linux - 70 VPS", "id"=>744, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_70_VPS", "softwareDescriptionId"=>322, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Standard Edition (64bit)", "id"=>977, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_R2", "softwareDescriptionId"=>475, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Datacenter Edition (64bit)", "id"=>979, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_R2", "softwareDescriptionId"=>478, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 8.x (64 bit)", "id"=>1065, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_8_X_64_BIT_2", "softwareDescriptionId"=>1019, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"600", "description"=>"600 GB SA-SCSI 15K RPM", "id"=>1094, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_600GB_SASCSI_15K_RPM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx (32 bit)", "id"=>1136, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_32_BIT", "softwareDescriptionId"=>774, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 9.x (32 bit)", "id"=>4137, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_9_X_32_BIT_2", "softwareDescriptionId"=>1264, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 25 Pack", "id"=>4156, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_25_PACK", "softwareDescriptionId"=>1016, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin (64 bit)", "id"=>4166, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_64_BIT", "softwareDescriptionId"=>1165, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"175", "description"=>"175GB EVault Disk to Disk Enterprise Backup", "id"=>4182, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_175_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>561}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Linux) Unlimited Domain w/ Power Pack", "id"=>4197, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_LINUX_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1197, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"4", "description"=>"4 GB DDR3 1333", "id"=>3798, "itemTaxCategoryId"=>166, "keyName"=>"RAM_4_GB_DDR3_1333_ECC_NON_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"800", "description"=>"800 GB SSD", "id"=>4356, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_800GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Vyatta 6.x Subscription Edition (64 bit)", "id"=>4396, "itemTaxCategoryId"=>166, "keyName"=>"OS_VYATTA_6_X_SUBSCRIPTION_EDITION_64_BIT_2", "softwareDescriptionId"=>1221, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"No Operating System", "id"=>4648, "itemTaxCategoryId"=>166, "keyName"=>"OS_NO_OPERATING_SYSTEM", "softwareDescriptionId"=>1312, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr (32 bit)", "id"=>4700, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_32_BIT", "softwareDescriptionId"=>1360, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Standard Edition", "id"=>5124, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_STANDARD_EDITION", "softwareDescriptionId"=>1334, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.5 - Minimal Install (64 bit) - version-locked", "id"=>5984, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_5_MINIMAL_64_BIT", "softwareDescriptionId"=>1263, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"1 IP Address", "id"=>15, "itemTaxCategoryId"=>166, "keyName"=>"1_IP_ADDRESS", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"MySQL for Linux", "id"=>22, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_LINUX", "softwareDescriptionId"=>156, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Workgroup", "id"=>80, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_WORKGROUP", "softwareDescriptionId"=>20, "upgradeItemId"=>nil}, {"capacity"=>"20000", "description"=>"20000 GB Bandwidth", "id"=>249, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_20000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100Mbps Hardware Firewall", "id"=>298, "itemTaxCategoryId"=>166, "keyName"=>"100MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"500", "description"=>"500 GB SATA II", "id"=>14, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_500GB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"RAID 0", "id"=>488, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_0", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"RAID 10", "id"=>491, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_10", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Private Network Uplink", "id"=>496, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>497}, {"capacity"=>"250", "description"=>"250 GB iSCSI SAN Storage", "id"=>552, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_250_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>612}, {"capacity"=>"20", "description"=>"20GB EVault Disk to Disk Enterprise Backup", "id"=>558, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_20_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>739}, {"capacity"=>"500", "description"=>"500 GB NAS", "id"=>611, "itemTaxCategoryId"=>166, "keyName"=>"NAS_500_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>605}, {"description"=>"Microsoft SQL Server 2008 Workgroup", "id"=>684, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WORKGROUP", "softwareDescriptionId"=>304, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"Virtuozzo Containers 4 for Linux - 5 VPS", "id"=>740, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_5_VPS", "softwareDescriptionId"=>317, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard Edition SP2 (64bit)", "id"=>936, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_SP2", "softwareDescriptionId"=>447, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Enterprise Edition (64bit)", "id"=>978, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_64_BIT_R2_2", "softwareDescriptionId"=>477, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Datacenter Edition With Hyper-V (64bit)", "id"=>980, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_R2_2", "softwareDescriptionId"=>478, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix Essentials for XenServer 5.5 (Billed per VM)", "id"=>1077, "itemTaxCategoryId"=>166, "keyName"=>"CITRIX_ESSENTIALS_XENSERVER_5_5", "softwareDescriptionId"=>521, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Workgroup R2", "id"=>1164, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_WORKGROUP_R2", "softwareDescriptionId"=>697, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Redundant Public & Private Network Uplinks", "id"=>1284, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_REDUNDANT_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 10 (Linux) Unlimited Domain w/ Power Pack", "id"=>1306, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_LINUX_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>939, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 5.6.1", "id"=>1322, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6_1", "softwareDescriptionId"=>801, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x (32 bit)", "id"=>3904, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_32_BIT", "softwareDescriptionId"=>1258, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 6.x Squeeze/Stable (32 bit)", "id"=>3967, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_6_X_SQUEEZE_32_BIT", "softwareDescriptionId"=>918, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESX 4.1", "id"=>3969, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESX_4_1", "softwareDescriptionId"=>800, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 5.x (64 bit)", "id"=>4093, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_5_X_64_BIT_3", "softwareDescriptionId"=>1158, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Express Edition", "id"=>4150, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_EXPRESS", "softwareDescriptionId"=>1005, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1500", "description"=>"1500GB EVault Disk to Disk Enterprise Backup", "id"=>4185, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_1500_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>955}, {"capacity"=>"0", "description"=>"Windows Server 2012 Datacenter Edition (64bit)", "id"=>4237, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_DC_64_BIT", "softwareDescriptionId"=>1082, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard SP1 with R2 (64 bit)", "id"=>4248, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_R2_SP1", "softwareDescriptionId"=>831, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 1 Pack", "id"=>4345, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_1_PACK", "softwareDescriptionId"=>1094, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 25 Pack", "id"=>4348, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_25_PACK", "softwareDescriptionId"=>1097, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable (64 bit)", "id"=>4405, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_64_BIT", "softwareDescriptionId"=>1104, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware vCenter 5.5 Standard", "id"=>4598, "itemTaxCategoryId"=>166, "keyName"=>"VMWARE_VCENTER_5_5_STANDARD", "softwareDescriptionId"=>1275, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr - Minimal Install (64 bit)", "id"=>4710, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_MINIMAL_64_BIT_2", "softwareDescriptionId"=>1346, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 12 - 30 Domain w/ Power Pack", "id"=>6010, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_12_30_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1414, "upgradeItemId"=>nil}, {"capacity"=>"8", "description"=>"8 Public IP Addresses", "id"=>17, "itemTaxCategoryId"=>166, "keyName"=>"8_PUBLIC_IP_ADDRESSES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"MySQL 5.0 for Windows", "id"=>23, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_0_WINDOWS", "softwareDescriptionId"=>13, "upgradeItemId"=>nil}, {"description"=>"Email and Ticket", "id"=>51, "itemTaxCategoryId"=>166, "keyName"=>"NOTIFICATION_EMAIL_AND_TICKET", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"NOC Monitoring", "id"=>54, "itemTaxCategoryId"=>166, "keyName"=>"NOC_MONITORING", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"cPanel/WHM with Fantastico and RVskin", "id"=>96, "itemTaxCategoryId"=>166, "keyName"=>"CPANELWHM_WITH_FANTASTICO_AND_RVSKIN", "softwareDescriptionId"=>31, "upgradeItemId"=>nil}, {"description"=>"Unlimited Bandwidth (100 Mbps Uplink)", "id"=>97, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_UNLIMITED_100_MBPS_UPLINK", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Standard SP2 with R2 (32 bit)", "id"=>421, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_STD_32_BIT_SP2_WR2", "softwareDescriptionId"=>125, "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"RAID 1", "id"=>489, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_1", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"RAID 5", "id"=>490, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_5", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Reboot / KVM over IP", "id"=>504, "itemTaxCategoryId"=>166, "keyName"=>"REBOOT_KVM_OVER_IP", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1000 GB iSCSI SAN Storage", "id"=>554, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_1000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>783}, {"capacity"=>"150", "description"=>"Virtuozzo Containers 4 for Linux - 150 VPS", "id"=>746, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_150_VPS", "softwareDescriptionId"=>324, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"50", "description"=>"Virtuozzo Containers 4 for Linux - 50 VPS", "id"=>743, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_50_VPS", "softwareDescriptionId"=>321, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard Edition SP2 (32bit)", "id"=>933, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_32_BIT_SP2", "softwareDescriptionId"=>444, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Web Edition SP2 (32bit)", "id"=>934, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_32_BIT_SP2", "softwareDescriptionId"=>445, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Enterprise Edition SP2 (64bit)", "id"=>938, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_64_BIT_SP2", "softwareDescriptionId"=>449, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Datacenter Edition SP2 (64bit)", "id"=>940, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_SP2", "softwareDescriptionId"=>451, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Citrix XenServer 5.5", "id"=>950, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_5", "softwareDescriptionId"=>642, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Web Edition (64bit)", "id"=>976, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_64_BIT_R2_SP1", "softwareDescriptionId"=>832, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2.00 TB SATA II", "id"=>1091, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_2_00TB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Enterprise for XenServer 5.6", "id"=>1300, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ENTERPRISE_FOR_XENSERVER_5_6", "softwareDescriptionId"=>726, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"12", "description"=>"12 GB DDR3 1333", "id"=>3800, "itemTaxCategoryId"=>166, "keyName"=>"RAM_12_GB_DDR3_1333_NON_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin - Minimal Install (64 bit)", "id"=>4170, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_MINIMAL_64_BIT_2", "softwareDescriptionId"=>1184, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Parallels Plesk Panel 11 (Windows) Unlimited Domain w/ Power Pack", "id"=>4200, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_11_WINDOWS_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1274, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.1", "id"=>4258, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_1", "softwareDescriptionId"=>1065, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware vCenter 5.1 Standard", "id"=>4298, "itemTaxCategoryId"=>166, "keyName"=>"VMWARE_VCENTER_5_1_STANDARD", "softwareDescriptionId"=>1090, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Vyatta 6.6 Community Edition (64 bit)", "id"=>4495, "itemTaxCategoryId"=>166, "keyName"=>"OS_VYATTA_6_6_COMMUNITY_EDITION_64_BIT", "softwareDescriptionId"=>1192, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"20", "description"=>"20Mbps Hardware Firewall", "id"=>4550, "itemTaxCategoryId"=>166, "keyName"=>"20MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 6.2.1", "id"=>4569, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_6_2_1", "softwareDescriptionId"=>1257, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"3.5", "description"=>"Single Processor Quad Core Xeon 1270 V3 - 3.50GHz  (Haswell) - 1 x 8MB", "id"=>4578, "itemTaxCategoryId"=>166, "keyName"=>"INTEL_SINGLE_XEON_1270_3_50", "softwareDescriptionId"=>nil, "units"=>"GHZ", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MySQL 5.7 for Windows", "id"=>4592, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_7_WINDOWS", "softwareDescriptionId"=>1272, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Enterprise Edition", "id"=>5120, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_ENTERPRISE_EDITION_2", "softwareDescriptionId"=>1330, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Intel TXT (Trusted Execution Technology)", "id"=>5868, "itemTaxCategoryId"=>166, "keyName"=>"INTEL_TXT_TRUSTED_EXECUTION_TECHNOLOGY", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Enterprise", "id"=>81, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_ENTERPRISE", "softwareDescriptionId"=>21, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Public & Private Network Uplinks", "id"=>187, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>188}, {"capacity"=>"1000", "description"=>"1000Mbps Hardware Firewall", "id"=>297, "itemTaxCategoryId"=>166, "keyName"=>"1000MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x (64 bit)", "id"=>420, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_64_BIT", "softwareDescriptionId"=>1240, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Enterprise SP2 with R2 (32 bit)", "id"=>423, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_ENT_32_BIT_SP2_WR2", "softwareDescriptionId"=>128, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 8.x (32 bit)", "id"=>1066, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_8_X_32_BIT", "softwareDescriptionId"=>1022, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"60", "description"=>"60GB EVault Disk to Disk Enterprise Backup", "id"=>1076, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_60_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>560}, {"capacity"=>"2", "description"=>"Monitoring Package - Advanced", "id"=>1249, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_ADVANCED", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"capacity"=>"50", "description"=>"50GB EVault Disk to Disk Enterprise Backup", "id"=>3784, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_50_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>1076}, {"description"=>"Parallels Plesk Panel 10 (Windows) 100 Domain w/ Power Pack", "id"=>3786, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_PANEL_10_WINDOWS_100_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>787, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x (64 bit)", "id"=>3907, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_64_BIT", "softwareDescriptionId"=>1261, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Redundant Private Network Uplinks", "id"=>3956, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"3000", "description"=>"3.00 TB SATA III", "id"=>3989, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_3_00TB_SATA_III", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Enterprise for XenServer 6.x", "id"=>4105, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ENTERPRISE_FOR_XENSERVER_6_X", "softwareDescriptionId"=>909, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Disk Agent 1 Pack", "id"=>4153, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_DISK_AGENT_1_PACK", "softwareDescriptionId"=>1015, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin (32 bit)", "id"=>4165, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_12_04_LTS_PRECISE_PANGOLIN_32_BIT", "softwareDescriptionId"=>1166, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Dual Public & Private Network Uplinks (Unbonded)", "id"=>4263, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_DUAL_PUBLIC_PRIVATE_NETWORK_UPLINKS_UNBONDED", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"4000", "description"=>"4.00 TB SATA III", "id"=>4281, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_4_00TB_SATA_III", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Vyatta 6.5 Community Edition (64 bit)", "id"=>4315, "itemTaxCategoryId"=>166, "keyName"=>"OS_VYATTA_6_5_COMMUNITY_EDITION_64_BIT", "softwareDescriptionId"=>1106, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x (64 bit) (per-processor licensing)", "id"=>4321, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_64_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1247, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable - Minimal Install (32 bit)", "id"=>4406, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_MINIMAL_32_BIT", "softwareDescriptionId"=>1176, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Debian GNU/Linux 7.x Wheezy/Stable - Minimal Install (64 bit)", "id"=>4407, "itemTaxCategoryId"=>166, "keyName"=>"OS_DEBIAN_7_X_WHEEZY_MINIMAL_64_BIT", "softwareDescriptionId"=>1177, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MySQL 5.0.51 for Windows", "id"=>4557, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MYSQL_5_0_51_WINDOWS", "softwareDescriptionId"=>220, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"VMware ESXi 5.5", "id"=>4562, "itemTaxCategoryId"=>166, "keyName"=>"OS_VMWARE_ESXI_5_5", "softwareDescriptionId"=>1256, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 10.x (32 bit)", "id"=>4640, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_10_X_32_BIT", "softwareDescriptionId"=>1284, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 10.x (64 bit)", "id"=>4638, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_10_X_64_BIT", "softwareDescriptionId"=>1286, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr (64 bit)", "id"=>4702, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_64_BIT", "softwareDescriptionId"=>1362, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2014 Express Edition", "id"=>5122, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_SQL_SERVER_2014_EXPRESS_EDITION", "softwareDescriptionId"=>1332, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Parallels Plesk Panel 12 - Unlimited Domain w/ Power Pack", "id"=>6014, "itemTaxCategoryId"=>166, "keyName"=>"PARALLELS_PLESK_12_UNLIMITED_DOMAIN_W_POWER_PACK", "softwareDescriptionId"=>1420, "upgradeItemId"=>nil}, {"capacity"=>"4", "description"=>"4 Public IP Addresses", "id"=>16, "itemTaxCategoryId"=>166, "keyName"=>"4_PUBLIC_IP_ADDRESSES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Unlimited Bandwidth (10 Mbps Uplink)", "id"=>30, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_UNLIMITED_10_MBPS_UPLINK", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB NAS", "id"=>43, "itemTaxCategoryId"=>166, "keyName"=>"NAS_100_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>44}, {"description"=>"Business Continuance Insurance", "id"=>84, "itemTaxCategoryId"=>108, "keyName"=>"BUSINESS_CONTINUANCE_INSURANCE", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100GB EVault Disk to Disk Enterprise Backup", "id"=>560, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_100_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4182}, {"capacity"=>"30", "description"=>"Virtuozzo Containers 4 for Linux - 30 VPS", "id"=>742, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_30_VPS", "softwareDescriptionId"=>320, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"64", "description"=>"/64 Block Static Public IPv6 Addresses", "id"=>784, "itemTaxCategoryId"=>166, "keyName"=>"64_BLOCK_STATIC_PUBLIC_IPV6_ADDRESSES", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx (64 bit)", "id"=>1137, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_64_BIT", "softwareDescriptionId"=>775, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2008 Enterprise R2", "id"=>1165, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2008_ENTERPRISE_R2", "softwareDescriptionId"=>699, "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Monitoring Package - Basic", "id"=>1248, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_PACKAGE_BASIC", "softwareDescriptionId"=>727, "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2000Mbps Hardware Firewall", "id"=>1296, "itemTaxCategoryId"=>166, "keyName"=>"2000MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Advanced for XenServer 5.6", "id"=>1299, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ADVANCED_FOR_XENSERVER_5_6", "softwareDescriptionId"=>726, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"EVault Plugin - BMR (Bare Metal Restore)", "id"=>961, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_PLUGIN_BMR_BARE_METAL_RESTORE", "softwareDescriptionId"=>467, "upgradeItemId"=>nil}, {"capacity"=>"3.4", "description"=>"Single Processor Quad Core Xeon 1270 - 3.40GHz  (Sandy Bridge) - 1 x 8MB cache w/HT", "id"=>3796, "itemTaxCategoryId"=>166, "keyName"=>"INTEL_SINGLE_XEON_1270_3_40_2", "softwareDescriptionId"=>nil, "units"=>"GHZ", "upgradeItemId"=>nil}, {"capacity"=>"8", "description"=>"8 GB DDR3 1333", "id"=>3799, "itemTaxCategoryId"=>166, "keyName"=>"RAM_8_GB_DDR3_1333_ECC_NON_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"16", "description"=>"16 GB DDR3 1333", "id"=>3801, "itemTaxCategoryId"=>166, "keyName"=>"RAM_16_GB_DDR3_1333_ECC_NON_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"32", "description"=>"32 GB DDR3 1333", "id"=>3805, "itemTaxCategoryId"=>166, "keyName"=>"RAM_32_GB_DDR3_1333_NON_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Citrix XenServer 5.6.2", "id"=>3886, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6_2", "softwareDescriptionId"=>867, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"XenServer Advanced for XenServer 6.x", "id"=>4104, "itemTaxCategoryId"=>166, "keyName"=>"XENSERVER_ADVANCED_FOR_XENSERVER_6_X", "softwareDescriptionId"=>908, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"FreeBSD 9.x (64 bit)", "id"=>4138, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_9_X_64_BIT", "softwareDescriptionId"=>1265, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"400", "description"=>"400 GB SSD", "id"=>4181, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_400GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Cloudera Distribution for Hadoop 4", "id"=>4301, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_CLOUDERA_DISTRIBUTION_HADOOP_4", "softwareDescriptionId"=>1099, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x (32 bit) (per-processor licensing)", "id"=>4320, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_32_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1246, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Riak 1.x", "id"=>4327, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_RIAK_1_X", "softwareDescriptionId"=>1114, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Redundant Private Network Uplinks", "id"=>4331, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Redundant Public & Private Network Uplinks", "id"=>4336, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_REDUNDANT_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>1284}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Standard Edition (64 bit)", "id"=>4549, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_STD_64_BIT", "softwareDescriptionId"=>1225, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Microsoft SQL Server 2005 Express", "id"=>24, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2005_EXPRESS", "softwareDescriptionId"=>9, "upgradeItemId"=>nil}, {"capacity"=>"40", "description"=>"40 GB NAS", "id"=>41, "itemTaxCategoryId"=>166, "keyName"=>"NAS_40_GB", "softwareDescriptionId"=>nil, "units"=>"GIGABYTE", "upgradeItemId"=>42}, {"description"=>"Host Ping", "id"=>49, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_HOST_PING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Automated Notification", "id"=>52, "itemTaxCategoryId"=>166, "keyName"=>"AUTOMATED_NOTIFICATION", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Automated Reboot from Monitoring", "id"=>53, "itemTaxCategoryId"=>166, "keyName"=>"AUTOMATED_REBOOT_FROM_MONITORING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"300", "description"=>"300 GB SA-SCSI 15K RPM", "id"=>352, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_300GB_SASCSI_15K_RPM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"500", "description"=>"500 GB iSCSI SAN Storage", "id"=>553, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_500_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>621}, {"capacity"=>"500", "description"=>"500GB EVault Disk to Disk Enterprise Backup", "id"=>562, "itemTaxCategoryId"=>166, "keyName"=>"EVAULT_500_GB", "softwareDescriptionId"=>159, "units"=>"GIGABYTE", "upgradeItemId"=>4184}, {"capacity"=>"120", "description"=>"120 GB iSCSI SAN Storage", "id"=>575, "itemTaxCategoryId"=>166, "keyName"=>"ISCSI_SAN_STORAGE_120_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>622}, {"capacity"=>"0", "description"=>"FreeBSD 7.x  (32 bit)", "id"=>638, "itemTaxCategoryId"=>166, "keyName"=>"OS_FREEBSD_7_X_32_BIT", "softwareDescriptionId"=>666, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Virtuozzo Containers 4 for Linux - 3 VPS", "id"=>738, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_3_VPS", "softwareDescriptionId"=>319, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"Virtuozzo Containers 4 for Linux - 100 VPS", "id"=>745, "itemTaxCategoryId"=>166, "keyName"=>"VIRTUOZZO_CONTAINERS_4_FOR_LINUX_100_VPS", "softwareDescriptionId"=>323, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Web Edition SP2 (64bit)", "id"=>935, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_WEB_64_BIT_SP2", "softwareDescriptionId"=>446, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Cloudera Distribution for Hadoop 2", "id"=>1044, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_CLOUDERA_DISTRIBUTION_HADOOP_2", "softwareDescriptionId"=>520, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Citrix XenServer 5.6", "id"=>1189, "itemTaxCategoryId"=>166, "keyName"=>"OS_CITRIX_XENSERVER_5_6", "softwareDescriptionId"=>704, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft WebMatrix", "id"=>3898, "itemTaxCategoryId"=>166, "keyName"=>"MICROSOFT_WEBMATRIX_2", "softwareDescriptionId"=>868, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"International Services", "id"=>3955, "itemTaxCategoryId"=>166, "keyName"=>"INTERNATIONAL_SERVICES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 6.x (32 bit)", "id"=>4094, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_6_X_32_BIT_2", "softwareDescriptionId"=>1172, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CloudLinux 6.x (64 bit)", "id"=>4095, "itemTaxCategoryId"=>166, "keyName"=>"OS_CLOUDLINUX_6_X_64_BIT", "softwareDescriptionId"=>1175, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"64", "description"=>"1 IPv6 Address", "id"=>4097, "itemTaxCategoryId"=>166, "keyName"=>"1_IPV6_ADDRESS", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Web Edition", "id"=>4147, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_WEB", "softwareDescriptionId"=>1004, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Microsoft SQL Server 2012 Enterprise Edition", "id"=>4149, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MICROSOFT_SQL_SERVER_2012_ENTERPRISE", "softwareDescriptionId"=>1001, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"MongoDB", "id"=>4226, "itemTaxCategoryId"=>166, "keyName"=>"DATABASE_MONGODB", "softwareDescriptionId"=>1083, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 Datacenter Edition With Hyper-V (64bit)", "id"=>4247, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_DC_64_BIT_2", "softwareDescriptionId"=>1082, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x (32 bit) (per-processor licensing)", "id"=>4318, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_32_BIT_PER_PROCESSOR_LICENSING", "softwareDescriptionId"=>1227, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Redundant Public & Private Network Uplinks", "id"=>4332, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_REDUNDANT_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>4336}, {"capacity"=>"0", "description"=>"Idera Server Backup 5.0 Enterprise (Windows)", "id"=>4344, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_SERVER_BACKUP_5_0_ENTERPRISE_WINDOWS", "softwareDescriptionId"=>1092, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Idera Backup Agent 5 Pack", "id"=>4346, "itemTaxCategoryId"=>166, "keyName"=>"IDERA_BACKUP_AGENT_5_PACK", "softwareDescriptionId"=>1095, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"0 GB Bandwidth", "id"=>4481, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_0_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 R2 Datacenter Edition (64bit)", "id"=>4547, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_R2_FULL_DC_64_BIT", "softwareDescriptionId"=>1226, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"200", "description"=>"200Mbps Hardware Firewall", "id"=>4551, "itemTaxCategoryId"=>166, "keyName"=>"200MBPS_HARDWARE_FIREWALL", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"cPanel/WHM with Softaculous and RVskin", "id"=>4608, "itemTaxCategoryId"=>166, "keyName"=>"CPANELWHM_WITH_SOFTACULOUS_AND_RVSKIN", "softwareDescriptionId"=>1292, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr - Minimal Install (32 bit)", "id"=>4708, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_14_04_LTS_TRUSTY_TAHR_MINIMAL_32_BIT_2", "softwareDescriptionId"=>1350, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 7.x (64 bit)", "id"=>5920, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_7_X_64_BIT", "softwareDescriptionId"=>1400, "units"=>"N/A", "upgradeItemId"=>nil}]
          fixture_package_items[132] = [{"capacity"=>"32", "description"=>"32 GB RAM", "id"=>2515, "itemTaxCategoryId"=>166, "keyName"=>"LEGACY_32_GB_RAM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}]
          fixture_package_items[135] = [{"description"=>"Unlimited SSL VPN Users & 1 PPTP VPN User per account", "id"=>309, "itemTaxCategoryId"=>166, "keyName"=>"UNLIMITED_SSL_VPN_USERS_1_PPTP_VPN_USER_PER_ACCOUNT", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"1 x 2.0 GHz Core", "id"=>857, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_CORE_1", "softwareDescriptionId"=>nil, "units"=>"CORE", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"1 GB", "id"=>861, "itemTaxCategoryId"=>166, "keyName"=>"RAM_1_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Standard SP2 with R2 (64 bit)", "id"=>422, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_STD_64_BIT_SP2_WR2", "softwareDescriptionId"=>126, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Enterprise SP2 with R2 (64 bit)", "id"=>424, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_ENT_64_BIT_SP2_WR2", "softwareDescriptionId"=>127, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Datacenter SP2 with R2 (64 bit)", "id"=>921, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_DC_64_BIT_SP2_WR2", "softwareDescriptionId"=>402, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx - Minimal Install (32 bit)", "id"=>1138, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_MINIMAL_32_BIT", "softwareDescriptionId"=>689, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Enterprise Edition SP2 (32bit)", "id"=>937, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_32_BIT_SP2", "softwareDescriptionId"=>448, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x - LAMP Install (32 bit)", "id"=>3906, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_LAMP_32_BIT", "softwareDescriptionId"=>886, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"CentOS 7.x - LAMP Install (64 bit)", "id"=>5950, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_7_X_LAMP_64_BIT", "softwareDescriptionId"=>1450, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Public & Private Network Uplinks", "id"=>188, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"Nessus Vulnerability Assessment & Reporting", "id"=>307, "itemTaxCategoryId"=>98, "keyName"=>"NESSUS_VULNERABILITY_ASSESSMENT_REPORTING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x - Minimal Install (64 bit)", "id"=>876, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_MINIMAL_64_BIT", "softwareDescriptionId"=>856, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Datacenter Edition SP2 (32bit)", "id"=>939, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_32_BIT_SP2", "softwareDescriptionId"=>450, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 Standard Edition (64 bit)", "id"=>4233, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_STD_64_BIT", "softwareDescriptionId"=>1076, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"CentOS 7.x - Minimal Install (64 bit)", "id"=>5952, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_7_X_MINIMAL_64_BIT", "softwareDescriptionId"=>1448, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Datacenter SP2 with R2 (32 bit)", "id"=>920, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_DC_32_BIT_SP2_WR2", "softwareDescriptionId"=>401, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"0 GB Bandwidth", "id"=>439, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_0_GB_2", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Standard Edition (64bit)", "id"=>977, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_R2", "softwareDescriptionId"=>475, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x - Minimal Install (32 bit)", "id"=>3837, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_MINIMAL_32_BIT_2", "softwareDescriptionId"=>796, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Datacenter Edition (64bit)", "id"=>979, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_R2", "softwareDescriptionId"=>478, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"1 IP Address", "id"=>15, "itemTaxCategoryId"=>166, "keyName"=>"1_IP_ADDRESS", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x - LAMP Install (32 bit)", "id"=>877, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_LAMP_32_BIT", "softwareDescriptionId"=>857, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x - Minimal Install (64 bit)", "id"=>880, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_MINIMAL_64_BIT", "softwareDescriptionId"=>664, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard Edition SP2 (64bit)", "id"=>936, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_SP2", "softwareDescriptionId"=>447, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Enterprise Edition (64bit)", "id"=>978, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_64_BIT_R2_2", "softwareDescriptionId"=>477, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x - LAMP Install (64 bit)", "id"=>3835, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_LAMP_64_BIT_2", "softwareDescriptionId"=>798, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x - Minimal Install (64 bit)", "id"=>3839, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_MINIMAL_64_BIT", "softwareDescriptionId"=>795, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB (LOCAL)", "id"=>3876, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_DISK_100_GB_LOCAL", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 Datacenter Edition (64bit)", "id"=>4237, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_DC_64_BIT", "softwareDescriptionId"=>1082, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard SP1 with R2 (64 bit)", "id"=>4248, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_R2_SP1", "softwareDescriptionId"=>831, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Email and Ticket", "id"=>51, "itemTaxCategoryId"=>166, "keyName"=>"NOTIFICATION_EMAIL_AND_TICKET", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Reboot / Remote Console", "id"=>503, "itemTaxCategoryId"=>166, "keyName"=>"REBOOT_REMOTE_CONSOLE", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Standard SP2 with R2 (32 bit)", "id"=>421, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_STD_32_BIT_SP2_WR2", "softwareDescriptionId"=>125, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard Edition SP2 (32bit)", "id"=>933, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_32_BIT_SP2", "softwareDescriptionId"=>444, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx - LAMP Install (32 bit)", "id"=>1144, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_LAMP_32_BIT_2", "softwareDescriptionId"=>688, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Enterprise Edition SP2 (64bit)", "id"=>938, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_64_BIT_SP2", "softwareDescriptionId"=>449, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Datacenter Edition SP2 (64bit)", "id"=>940, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_SP2", "softwareDescriptionId"=>451, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x - LAMP Install (64 bit)", "id"=>3909, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_LAMP_64_BIT_2", "softwareDescriptionId"=>888, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x - LAMP Install (32 bit)", "id"=>881, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_LAMP_32_BIT_2", "softwareDescriptionId"=>663, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x - LAMP Install (64 bit)", "id"=>882, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_LAMP_64_BIT_2", "softwareDescriptionId"=>665, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Enterprise SP2 with R2 (32 bit)", "id"=>423, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_ENT_32_BIT_SP2_WR2", "softwareDescriptionId"=>128, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx - Minimal Install (64 bit)", "id"=>1140, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_MINIMAL_64_BIT_2", "softwareDescriptionId"=>690, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"RightLink", "id"=>4060, "itemTaxCategoryId"=>166, "keyName"=>"RIGHTLINK", "softwareDescriptionId"=>917, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x - LAMP Install (64 bit)", "id"=>878, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_LAMP_64_BIT", "softwareDescriptionId"=>858, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x - Minimal Install (32 bit)", "id"=>879, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_MINIMAL_32_BIT", "softwareDescriptionId"=>662, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x - Minimal Install (64 bit)", "id"=>3908, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_MINIMAL_64_BIT_2", "softwareDescriptionId"=>887, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Host Ping", "id"=>49, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_HOST_PING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Automated Notification", "id"=>52, "itemTaxCategoryId"=>166, "keyName"=>"AUTOMATED_NOTIFICATION", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x - Minimal Install (32 bit)", "id"=>875, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_MINIMAL_32_BIT", "softwareDescriptionId"=>855, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx - LAMP Install (64 bit)", "id"=>1145, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_LAMP_64_BIT", "softwareDescriptionId"=>691, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x - LAMP Install (32 bit)", "id"=>3833, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_LAMP_32_BIT", "softwareDescriptionId"=>797, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x - Minimal Install (32 bit)", "id"=>3905, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_MINIMAL_32_BIT", "softwareDescriptionId"=>885, "units"=>"N/A", "upgradeItemId"=>nil}]
          fixture_package_items[136] = [{"description"=>"Unlimited SSL VPN Users & 1 PPTP VPN User per account", "id"=>309, "itemTaxCategoryId"=>166, "keyName"=>"UNLIMITED_SSL_VPN_USERS_1_PPTP_VPN_USER_PER_ACCOUNT", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Standard SP2 with R2 (64 bit)", "id"=>422, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_STD_64_BIT_SP2_WR2", "softwareDescriptionId"=>126, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Enterprise SP2 with R2 (64 bit)", "id"=>424, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_ENT_64_BIT_SP2_WR2", "softwareDescriptionId"=>127, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Datacenter SP2 with R2 (64 bit)", "id"=>921, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_DC_64_BIT_SP2_WR2", "softwareDescriptionId"=>402, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx - Minimal Install (32 bit)", "id"=>1138, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_MINIMAL_32_BIT", "softwareDescriptionId"=>689, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Enterprise Edition SP2 (32bit)", "id"=>937, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_32_BIT_SP2", "softwareDescriptionId"=>448, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x - LAMP Install (32 bit)", "id"=>3906, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_LAMP_32_BIT", "softwareDescriptionId"=>886, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"CentOS 7.x - LAMP Install (64 bit)", "id"=>5950, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_7_X_LAMP_64_BIT", "softwareDescriptionId"=>1450, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Public & Private Network Uplinks", "id"=>188, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"Nessus Vulnerability Assessment & Reporting", "id"=>307, "itemTaxCategoryId"=>98, "keyName"=>"NESSUS_VULNERABILITY_ASSESSMENT_REPORTING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x - Minimal Install (64 bit)", "id"=>876, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_MINIMAL_64_BIT", "softwareDescriptionId"=>856, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Datacenter Edition SP2 (32bit)", "id"=>939, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_32_BIT_SP2", "softwareDescriptionId"=>450, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 Standard Edition (64 bit)", "id"=>4233, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_STD_64_BIT", "softwareDescriptionId"=>1076, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"CentOS 7.x - Minimal Install (64 bit)", "id"=>5952, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_7_X_MINIMAL_64_BIT", "softwareDescriptionId"=>1448, "upgradeItemId"=>nil}, {"capacity"=>"2", "description"=>"2 GB", "id"=>862, "itemTaxCategoryId"=>166, "keyName"=>"RAM_2_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Datacenter SP2 with R2 (32 bit)", "id"=>920, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_DC_32_BIT_SP2_WR2", "softwareDescriptionId"=>401, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"0 GB Bandwidth", "id"=>439, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_0_GB_2", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Standard Edition (64bit)", "id"=>977, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_R2", "softwareDescriptionId"=>475, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x - Minimal Install (32 bit)", "id"=>3837, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_MINIMAL_32_BIT_2", "softwareDescriptionId"=>796, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Datacenter Edition (64bit)", "id"=>979, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_R2", "softwareDescriptionId"=>478, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"1 IP Address", "id"=>15, "itemTaxCategoryId"=>166, "keyName"=>"1_IP_ADDRESS", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x - LAMP Install (32 bit)", "id"=>877, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_LAMP_32_BIT", "softwareDescriptionId"=>857, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x - Minimal Install (64 bit)", "id"=>880, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_MINIMAL_64_BIT", "softwareDescriptionId"=>664, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard Edition SP2 (64bit)", "id"=>936, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_SP2", "softwareDescriptionId"=>447, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Enterprise Edition (64bit)", "id"=>978, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_64_BIT_R2_2", "softwareDescriptionId"=>477, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x - LAMP Install (64 bit)", "id"=>3835, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_LAMP_64_BIT_2", "softwareDescriptionId"=>798, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x - Minimal Install (64 bit)", "id"=>3839, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_MINIMAL_64_BIT", "softwareDescriptionId"=>795, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB (LOCAL)", "id"=>3876, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_DISK_100_GB_LOCAL", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 Datacenter Edition (64bit)", "id"=>4237, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_DC_64_BIT", "softwareDescriptionId"=>1082, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard SP1 with R2 (64 bit)", "id"=>4248, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_R2_SP1", "softwareDescriptionId"=>831, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Email and Ticket", "id"=>51, "itemTaxCategoryId"=>166, "keyName"=>"NOTIFICATION_EMAIL_AND_TICKET", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Reboot / Remote Console", "id"=>503, "itemTaxCategoryId"=>166, "keyName"=>"REBOOT_REMOTE_CONSOLE", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Standard SP2 with R2 (32 bit)", "id"=>421, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_STD_32_BIT_SP2_WR2", "softwareDescriptionId"=>125, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard Edition SP2 (32bit)", "id"=>933, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_32_BIT_SP2", "softwareDescriptionId"=>444, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx - LAMP Install (32 bit)", "id"=>1144, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_LAMP_32_BIT_2", "softwareDescriptionId"=>688, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Enterprise Edition SP2 (64bit)", "id"=>938, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_64_BIT_SP2", "softwareDescriptionId"=>449, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Datacenter Edition SP2 (64bit)", "id"=>940, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_SP2", "softwareDescriptionId"=>451, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x - LAMP Install (64 bit)", "id"=>3909, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_LAMP_64_BIT_2", "softwareDescriptionId"=>888, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x - LAMP Install (32 bit)", "id"=>881, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_LAMP_32_BIT_2", "softwareDescriptionId"=>663, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x - LAMP Install (64 bit)", "id"=>882, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_LAMP_64_BIT_2", "softwareDescriptionId"=>665, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Enterprise SP2 with R2 (32 bit)", "id"=>423, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_ENT_32_BIT_SP2_WR2", "softwareDescriptionId"=>128, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx - Minimal Install (64 bit)", "id"=>1140, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_MINIMAL_64_BIT_2", "softwareDescriptionId"=>690, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"RightLink", "id"=>4060, "itemTaxCategoryId"=>166, "keyName"=>"RIGHTLINK", "softwareDescriptionId"=>917, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x - LAMP Install (64 bit)", "id"=>878, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_LAMP_64_BIT", "softwareDescriptionId"=>858, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x - Minimal Install (32 bit)", "id"=>879, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_MINIMAL_32_BIT", "softwareDescriptionId"=>662, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x - Minimal Install (64 bit)", "id"=>3908, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_MINIMAL_64_BIT_2", "softwareDescriptionId"=>887, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Host Ping", "id"=>49, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_HOST_PING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Automated Notification", "id"=>52, "itemTaxCategoryId"=>166, "keyName"=>"AUTOMATED_NOTIFICATION", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"2", "description"=>"2 x 2.0 GHz Cores", "id"=>858, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_CORES_2", "softwareDescriptionId"=>nil, "units"=>"CORE", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x - Minimal Install (32 bit)", "id"=>875, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_MINIMAL_32_BIT", "softwareDescriptionId"=>855, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx - LAMP Install (64 bit)", "id"=>1145, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_LAMP_64_BIT", "softwareDescriptionId"=>691, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x - LAMP Install (32 bit)", "id"=>3833, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_LAMP_32_BIT", "softwareDescriptionId"=>797, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x - Minimal Install (32 bit)", "id"=>3905, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_MINIMAL_32_BIT", "softwareDescriptionId"=>885, "units"=>"N/A", "upgradeItemId"=>nil}]
          fixture_package_items[137] = [{"description"=>"Unlimited SSL VPN Users & 1 PPTP VPN User per account", "id"=>309, "itemTaxCategoryId"=>166, "keyName"=>"UNLIMITED_SSL_VPN_USERS_1_PPTP_VPN_USER_PER_ACCOUNT", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"4", "description"=>"4 x 2.0 GHz Cores", "id"=>859, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_CORES_4", "softwareDescriptionId"=>nil, "units"=>"CORE", "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Standard SP2 with R2 (64 bit)", "id"=>422, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_STD_64_BIT_SP2_WR2", "softwareDescriptionId"=>126, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Enterprise SP2 with R2 (64 bit)", "id"=>424, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_ENT_64_BIT_SP2_WR2", "softwareDescriptionId"=>127, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Datacenter SP2 with R2 (64 bit)", "id"=>921, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_DC_64_BIT_SP2_WR2", "softwareDescriptionId"=>402, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx - Minimal Install (32 bit)", "id"=>1138, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_MINIMAL_32_BIT", "softwareDescriptionId"=>689, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Enterprise Edition SP2 (32bit)", "id"=>937, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_32_BIT_SP2", "softwareDescriptionId"=>448, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x - LAMP Install (32 bit)", "id"=>3906, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_LAMP_32_BIT", "softwareDescriptionId"=>886, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"CentOS 7.x - LAMP Install (64 bit)", "id"=>5950, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_7_X_LAMP_64_BIT", "softwareDescriptionId"=>1450, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Public & Private Network Uplinks", "id"=>188, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"Nessus Vulnerability Assessment & Reporting", "id"=>307, "itemTaxCategoryId"=>98, "keyName"=>"NESSUS_VULNERABILITY_ASSESSMENT_REPORTING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x - Minimal Install (64 bit)", "id"=>876, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_MINIMAL_64_BIT", "softwareDescriptionId"=>856, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Datacenter Edition SP2 (32bit)", "id"=>939, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_32_BIT_SP2", "softwareDescriptionId"=>450, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 Standard Edition (64 bit)", "id"=>4233, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_STD_64_BIT", "softwareDescriptionId"=>1076, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"CentOS 7.x - Minimal Install (64 bit)", "id"=>5952, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_7_X_MINIMAL_64_BIT", "softwareDescriptionId"=>1448, "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Public & Private Network Uplinks", "id"=>186, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>187}, {"description"=>"Windows Server 2003 Datacenter SP2 with R2 (32 bit)", "id"=>920, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_DC_32_BIT_SP2_WR2", "softwareDescriptionId"=>401, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"0 GB Bandwidth", "id"=>439, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_0_GB_2", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Standard Edition (64bit)", "id"=>977, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_R2", "softwareDescriptionId"=>475, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x - Minimal Install (32 bit)", "id"=>3837, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_MINIMAL_32_BIT_2", "softwareDescriptionId"=>796, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Datacenter Edition (64bit)", "id"=>979, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_R2", "softwareDescriptionId"=>478, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"1 IP Address", "id"=>15, "itemTaxCategoryId"=>166, "keyName"=>"1_IP_ADDRESS", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"4", "description"=>"4 GB", "id"=>863, "itemTaxCategoryId"=>166, "keyName"=>"RAM_4_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x - LAMP Install (32 bit)", "id"=>877, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_LAMP_32_BIT", "softwareDescriptionId"=>857, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x - Minimal Install (64 bit)", "id"=>880, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_MINIMAL_64_BIT", "softwareDescriptionId"=>664, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard Edition SP2 (64bit)", "id"=>936, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_SP2", "softwareDescriptionId"=>447, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Enterprise Edition (64bit)", "id"=>978, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_64_BIT_R2_2", "softwareDescriptionId"=>477, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x - LAMP Install (64 bit)", "id"=>3835, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_LAMP_64_BIT_2", "softwareDescriptionId"=>798, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x - Minimal Install (64 bit)", "id"=>3839, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_MINIMAL_64_BIT", "softwareDescriptionId"=>795, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB (LOCAL)", "id"=>3876, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_DISK_100_GB_LOCAL", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 Datacenter Edition (64bit)", "id"=>4237, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_DC_64_BIT", "softwareDescriptionId"=>1082, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard SP1 with R2 (64 bit)", "id"=>4248, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_64_BIT_R2_SP1", "softwareDescriptionId"=>831, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Email and Ticket", "id"=>51, "itemTaxCategoryId"=>166, "keyName"=>"NOTIFICATION_EMAIL_AND_TICKET", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Reboot / Remote Console", "id"=>503, "itemTaxCategoryId"=>166, "keyName"=>"REBOOT_REMOTE_CONSOLE", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Standard SP2 with R2 (32 bit)", "id"=>421, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_STD_32_BIT_SP2_WR2", "softwareDescriptionId"=>125, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Standard Edition SP2 (32bit)", "id"=>933, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_STD_32_BIT_SP2", "softwareDescriptionId"=>444, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx - LAMP Install (32 bit)", "id"=>1144, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_LAMP_32_BIT_2", "softwareDescriptionId"=>688, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Enterprise Edition SP2 (64bit)", "id"=>938, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_64_BIT_SP2", "softwareDescriptionId"=>449, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Datacenter Edition SP2 (64bit)", "id"=>940, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_SP2", "softwareDescriptionId"=>451, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x - LAMP Install (64 bit)", "id"=>3909, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_LAMP_64_BIT_2", "softwareDescriptionId"=>888, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x - LAMP Install (32 bit)", "id"=>881, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_LAMP_32_BIT_2", "softwareDescriptionId"=>663, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x - LAMP Install (64 bit)", "id"=>882, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_LAMP_64_BIT_2", "softwareDescriptionId"=>665, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Enterprise SP2 with R2 (32 bit)", "id"=>423, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_ENT_32_BIT_SP2_WR2", "softwareDescriptionId"=>128, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx - Minimal Install (64 bit)", "id"=>1140, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_MINIMAL_64_BIT_2", "softwareDescriptionId"=>690, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"RightLink", "id"=>4060, "itemTaxCategoryId"=>166, "keyName"=>"RIGHTLINK", "softwareDescriptionId"=>917, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x - LAMP Install (64 bit)", "id"=>878, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_LAMP_64_BIT", "softwareDescriptionId"=>858, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x - Minimal Install (32 bit)", "id"=>879, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_MINIMAL_32_BIT", "softwareDescriptionId"=>662, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x - Minimal Install (64 bit)", "id"=>3908, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_MINIMAL_64_BIT_2", "softwareDescriptionId"=>887, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Host Ping", "id"=>49, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_HOST_PING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Automated Notification", "id"=>52, "itemTaxCategoryId"=>166, "keyName"=>"AUTOMATED_NOTIFICATION", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x - Minimal Install (32 bit)", "id"=>875, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_MINIMAL_32_BIT", "softwareDescriptionId"=>855, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx - LAMP Install (64 bit)", "id"=>1145, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_LAMP_64_BIT", "softwareDescriptionId"=>691, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x - LAMP Install (32 bit)", "id"=>3833, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_LAMP_32_BIT", "softwareDescriptionId"=>797, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x - Minimal Install (32 bit)", "id"=>3905, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_MINIMAL_32_BIT", "softwareDescriptionId"=>885, "units"=>"N/A", "upgradeItemId"=>nil}]
          fixture_package_items[138] = [{"description"=>"Unlimited SSL VPN Users & 1 PPTP VPN User per account", "id"=>309, "itemTaxCategoryId"=>166, "keyName"=>"UNLIMITED_SSL_VPN_USERS_1_PPTP_VPN_USER_PER_ACCOUNT", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"8", "description"=>"8 x 2.0 GHz Cores", "id"=>860, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_CORES_8", "softwareDescriptionId"=>nil, "units"=>"CORE", "upgradeItemId"=>nil}, {"capacity"=>"8", "description"=>"8 GB", "id"=>864, "itemTaxCategoryId"=>166, "keyName"=>"RAM_8_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Enterprise SP2 with R2 (64 bit)", "id"=>424, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_ENT_64_BIT_SP2_WR2", "softwareDescriptionId"=>127, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Datacenter SP2 with R2 (64 bit)", "id"=>921, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_DC_64_BIT_SP2_WR2", "softwareDescriptionId"=>402, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx - Minimal Install (32 bit)", "id"=>1138, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_MINIMAL_32_BIT", "softwareDescriptionId"=>689, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Enterprise Edition SP2 (32bit)", "id"=>937, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_32_BIT_SP2", "softwareDescriptionId"=>448, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x - LAMP Install (32 bit)", "id"=>3906, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_LAMP_32_BIT", "softwareDescriptionId"=>886, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"CentOS 7.x - LAMP Install (64 bit)", "id"=>5950, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_7_X_LAMP_64_BIT", "softwareDescriptionId"=>1450, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Public & Private Network Uplinks", "id"=>188, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"Nessus Vulnerability Assessment & Reporting", "id"=>307, "itemTaxCategoryId"=>98, "keyName"=>"NESSUS_VULNERABILITY_ASSESSMENT_REPORTING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x - Minimal Install (64 bit)", "id"=>876, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_MINIMAL_64_BIT", "softwareDescriptionId"=>856, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Datacenter Edition SP2 (32bit)", "id"=>939, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_32_BIT_SP2", "softwareDescriptionId"=>450, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"CentOS 7.x - Minimal Install (64 bit)", "id"=>5952, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_7_X_MINIMAL_64_BIT", "softwareDescriptionId"=>1448, "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Datacenter SP2 with R2 (32 bit)", "id"=>920, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_DC_32_BIT_SP2_WR2", "softwareDescriptionId"=>401, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"0 GB Bandwidth", "id"=>439, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_0_GB_2", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x - Minimal Install (32 bit)", "id"=>3837, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_MINIMAL_32_BIT_2", "softwareDescriptionId"=>796, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Datacenter Edition (64bit)", "id"=>979, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_R2", "softwareDescriptionId"=>478, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"1 IP Address", "id"=>15, "itemTaxCategoryId"=>166, "keyName"=>"1_IP_ADDRESS", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x - LAMP Install (32 bit)", "id"=>877, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_LAMP_32_BIT", "softwareDescriptionId"=>857, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x - Minimal Install (64 bit)", "id"=>880, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_MINIMAL_64_BIT", "softwareDescriptionId"=>664, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 R2 Enterprise Edition (64bit)", "id"=>978, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_64_BIT_R2_2", "softwareDescriptionId"=>477, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x - LAMP Install (64 bit)", "id"=>3835, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_LAMP_64_BIT_2", "softwareDescriptionId"=>798, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x - Minimal Install (64 bit)", "id"=>3839, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_MINIMAL_64_BIT", "softwareDescriptionId"=>795, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB (LOCAL)", "id"=>3876, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_DISK_100_GB_LOCAL", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2012 Datacenter Edition (64bit)", "id"=>4237, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2012_FULL_DC_64_BIT", "softwareDescriptionId"=>1082, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Email and Ticket", "id"=>51, "itemTaxCategoryId"=>166, "keyName"=>"NOTIFICATION_EMAIL_AND_TICKET", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Reboot / Remote Console", "id"=>503, "itemTaxCategoryId"=>166, "keyName"=>"REBOOT_REMOTE_CONSOLE", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx - LAMP Install (32 bit)", "id"=>1144, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_LAMP_32_BIT_2", "softwareDescriptionId"=>688, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Enterprise Edition SP2 (64bit)", "id"=>938, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_ENT_64_BIT_SP2", "softwareDescriptionId"=>449, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Windows Server 2008 Datacenter Edition SP2 (64bit)", "id"=>940, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2008_FULL_DC_64_BIT_SP2", "softwareDescriptionId"=>451, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x - LAMP Install (64 bit)", "id"=>3909, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_LAMP_64_BIT_2", "softwareDescriptionId"=>888, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x - LAMP Install (32 bit)", "id"=>881, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_LAMP_32_BIT_2", "softwareDescriptionId"=>663, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x - LAMP Install (64 bit)", "id"=>882, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_LAMP_64_BIT_2", "softwareDescriptionId"=>665, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Windows Server 2003 Enterprise SP2 with R2 (32 bit)", "id"=>423, "itemTaxCategoryId"=>166, "keyName"=>"OS_WINDOWS_2003_ENT_32_BIT_SP2_WR2", "softwareDescriptionId"=>128, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx - Minimal Install (64 bit)", "id"=>1140, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_MINIMAL_64_BIT_2", "softwareDescriptionId"=>690, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"RightLink", "id"=>4060, "itemTaxCategoryId"=>166, "keyName"=>"RIGHTLINK", "softwareDescriptionId"=>917, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x - LAMP Install (64 bit)", "id"=>878, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_LAMP_64_BIT", "softwareDescriptionId"=>858, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x - Minimal Install (32 bit)", "id"=>879, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_MINIMAL_32_BIT", "softwareDescriptionId"=>662, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x - Minimal Install (64 bit)", "id"=>3908, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_MINIMAL_64_BIT_2", "softwareDescriptionId"=>887, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Host Ping", "id"=>49, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_HOST_PING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Automated Notification", "id"=>52, "itemTaxCategoryId"=>166, "keyName"=>"AUTOMATED_NOTIFICATION", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x - Minimal Install (32 bit)", "id"=>875, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_MINIMAL_32_BIT", "softwareDescriptionId"=>855, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx - LAMP Install (64 bit)", "id"=>1145, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_LAMP_64_BIT", "softwareDescriptionId"=>691, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x - LAMP Install (32 bit)", "id"=>3833, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_LAMP_32_BIT", "softwareDescriptionId"=>797, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x - Minimal Install (32 bit)", "id"=>3905, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_MINIMAL_32_BIT", "softwareDescriptionId"=>885, "units"=>"N/A", "upgradeItemId"=>nil}]
          fixture_package_items[139] = [{"description"=>"Unlimited SSL VPN Users & 1 PPTP VPN User per account", "id"=>309, "itemTaxCategoryId"=>166, "keyName"=>"UNLIMITED_SSL_VPN_USERS_1_PPTP_VPN_USER_PER_ACCOUNT", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx - Minimal Install (32 bit)", "id"=>1138, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_MINIMAL_32_BIT", "softwareDescriptionId"=>689, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x - LAMP Install (32 bit)", "id"=>3906, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_LAMP_32_BIT", "softwareDescriptionId"=>886, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"CentOS 7.x - LAMP Install (64 bit)", "id"=>5950, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_7_X_LAMP_64_BIT", "softwareDescriptionId"=>1450, "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Public & Private Network Uplinks", "id"=>188, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"description"=>"Nessus Vulnerability Assessment & Reporting", "id"=>307, "itemTaxCategoryId"=>98, "keyName"=>"NESSUS_VULNERABILITY_ASSESSMENT_REPORTING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x - Minimal Install (64 bit)", "id"=>876, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_MINIMAL_64_BIT", "softwareDescriptionId"=>856, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"16", "description"=>"16 x 2.0 GHz Cores", "id"=>1194, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_CORES_16", "softwareDescriptionId"=>nil, "units"=>"CORE", "upgradeItemId"=>nil}, {"description"=>"CentOS 7.x - Minimal Install (64 bit)", "id"=>5952, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_7_X_MINIMAL_64_BIT", "softwareDescriptionId"=>1448, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"0 GB Bandwidth", "id"=>439, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_0_GB_2", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x - Minimal Install (32 bit)", "id"=>3837, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_MINIMAL_32_BIT_2", "softwareDescriptionId"=>796, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"1 IP Address", "id"=>15, "itemTaxCategoryId"=>166, "keyName"=>"1_IP_ADDRESS", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x - LAMP Install (32 bit)", "id"=>877, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_LAMP_32_BIT", "softwareDescriptionId"=>857, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x - Minimal Install (64 bit)", "id"=>880, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_MINIMAL_64_BIT", "softwareDescriptionId"=>664, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x - LAMP Install (64 bit)", "id"=>3835, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_LAMP_64_BIT_2", "softwareDescriptionId"=>798, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x - Minimal Install (64 bit)", "id"=>3839, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_MINIMAL_64_BIT", "softwareDescriptionId"=>795, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 GB (LOCAL)", "id"=>3876, "itemTaxCategoryId"=>166, "keyName"=>"GUEST_DISK_100_GB_LOCAL", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"description"=>"Email and Ticket", "id"=>51, "itemTaxCategoryId"=>166, "keyName"=>"NOTIFICATION_EMAIL_AND_TICKET", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Reboot / Remote Console", "id"=>503, "itemTaxCategoryId"=>166, "keyName"=>"REBOOT_REMOTE_CONSOLE", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx - LAMP Install (32 bit)", "id"=>1144, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_LAMP_32_BIT_2", "softwareDescriptionId"=>688, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x - LAMP Install (64 bit)", "id"=>3909, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_LAMP_64_BIT_2", "softwareDescriptionId"=>888, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x - LAMP Install (32 bit)", "id"=>881, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_LAMP_32_BIT_2", "softwareDescriptionId"=>663, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x - LAMP Install (64 bit)", "id"=>882, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_LAMP_64_BIT_2", "softwareDescriptionId"=>665, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx - Minimal Install (64 bit)", "id"=>1140, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_MINIMAL_64_BIT_2", "softwareDescriptionId"=>690, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"RightLink", "id"=>4060, "itemTaxCategoryId"=>166, "keyName"=>"RIGHTLINK", "softwareDescriptionId"=>917, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x - LAMP Install (64 bit)", "id"=>878, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_LAMP_64_BIT", "softwareDescriptionId"=>858, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 5.x - Minimal Install (32 bit)", "id"=>879, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_5_MINIMAL_32_BIT", "softwareDescriptionId"=>662, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"16", "description"=>"16 GB", "id"=>1017, "itemTaxCategoryId"=>166, "keyName"=>"RAM_16_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x - Minimal Install (64 bit)", "id"=>3908, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_MINIMAL_64_BIT_2", "softwareDescriptionId"=>887, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Host Ping", "id"=>49, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_HOST_PING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Automated Notification", "id"=>52, "itemTaxCategoryId"=>166, "keyName"=>"AUTOMATED_NOTIFICATION", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 5.x - Minimal Install (32 bit)", "id"=>875, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_5_X_MINIMAL_32_BIT", "softwareDescriptionId"=>855, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx - LAMP Install (64 bit)", "id"=>1145, "itemTaxCategoryId"=>166, "keyName"=>"OS_UBUNTU_10_04_LTS_LUCID_LYNX_LAMP_64_BIT", "softwareDescriptionId"=>691, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"1", "description"=>"Red Hat Enterprise Linux 6.x - LAMP Install (32 bit)", "id"=>3833, "itemTaxCategoryId"=>166, "keyName"=>"OS_RHEL_6_LAMP_32_BIT", "softwareDescriptionId"=>797, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"CentOS 6.x - Minimal Install (32 bit)", "id"=>3905, "itemTaxCategoryId"=>166, "keyName"=>"OS_CENTOS_6_X_MINIMAL_32_BIT", "softwareDescriptionId"=>885, "units"=>"N/A", "upgradeItemId"=>nil}]
          fixture_package_items[140] = [{"capacity"=>"192", "description"=>"192 GB Registered DDR3 1066", "id"=>1147, "itemTaxCategoryId"=>166, "keyName"=>"RAM_192_GB_DDR3_1066_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"6", "description"=>"RAID 6", "id"=>3958, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_6", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 2.x (48 TB)", "id"=>3961, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_2_X_48_TB", "softwareDescriptionId"=>1126, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"200", "description"=>"200 GB SSD", "id"=>3811, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_200GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Private Network Uplink", "id"=>498, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"128", "description"=>"128 GB Registered DDR3 1333", "id"=>1307, "itemTaxCategoryId"=>166, "keyName"=>"RAM_128_GB_DDR3_1333_REG_2", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"10000", "description"=>"10 Gbps Private Network Uplink", "id"=>3957, "itemTaxCategoryId"=>166, "keyName"=>"10_GBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 2.x (4 TB)", "id"=>3959, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_2_X_4_TB", "softwareDescriptionId"=>1124, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"RAID", "id"=>4478, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"0 GB Bandwidth", "id"=>439, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_0_GB_2", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Private Network Uplink", "id"=>497, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>498}, {"capacity"=>"1000", "description"=>"1.00 TB SATA II", "id"=>471, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_1_00TB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"24", "description"=>"24 GB Registered DDR3 1333", "id"=>826, "itemTaxCategoryId"=>166, "keyName"=>"RAM_24_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"600", "description"=>"600 GB SA-SCSI 15K RPM", "id"=>1094, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_600GB_SASCSI_15K_RPM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"800", "description"=>"800 GB SSD", "id"=>4356, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_800GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (128 TB)", "id"=>4369, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_128_TB", "softwareDescriptionId"=>1155, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (16 TB)", "id"=>4371, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_16_TB", "softwareDescriptionId"=>1153, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"20000", "description"=>"20000 GB Bandwidth", "id"=>249, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_20000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"description"=>"Redundant Power Supply", "id"=>469, "itemTaxCategoryId"=>166, "keyName"=>"REDUNDANT_POWER_SUPPLY", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"500", "description"=>"500 GB SATA II", "id"=>14, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_500GB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Private Network Uplink", "id"=>496, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>497}, {"capacity"=>"10", "description"=>"RAID 10", "id"=>491, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_10", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"60", "description"=>"60 GB Registered DDR3 1333", "id"=>948, "itemTaxCategoryId"=>166, "keyName"=>"RAM_60_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"72", "description"=>"72 GB Registered DDR3 1333", "id"=>829, "itemTaxCategoryId"=>166, "keyName"=>"RAM_72_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"96", "description"=>"96 GB Registered DDR3 1333", "id"=>1050, "itemTaxCategoryId"=>166, "keyName"=>"RAM_96_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 2.x (16 TB)", "id"=>3960, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_2_X_16_TB", "softwareDescriptionId"=>1125, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Email and Ticket", "id"=>51, "itemTaxCategoryId"=>166, "keyName"=>"NOTIFICATION_EMAIL_AND_TICKET", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Reboot / KVM over IP", "id"=>504, "itemTaxCategoryId"=>166, "keyName"=>"REBOOT_KVM_OVER_IP", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"RAID 5", "id"=>490, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_5", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"36", "description"=>"36 GB Registered DDR3 1333", "id"=>827, "itemTaxCategoryId"=>166, "keyName"=>"RAM_36_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 2.x (128 TB)", "id"=>3962, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_2_X_128_TB", "softwareDescriptionId"=>1127, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2.00 TB SATA II", "id"=>1091, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_2_00TB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (4 TB)", "id"=>4372, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_4_TB", "softwareDescriptionId"=>1123, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10000", "description"=>"10 Gbps Public & Private Network Uplinks", "id"=>1281, "itemTaxCategoryId"=>166, "keyName"=>"10_GBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Redundant Private Network Uplinks", "id"=>3956, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"3000", "description"=>"3.00 TB SATA III", "id"=>3989, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_3_00TB_SATA_III", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"4000", "description"=>"4.00 TB SATA III", "id"=>4281, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_4_00TB_SATA_III", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"48", "description"=>"48 GB Registered DDR3 1333", "id"=>828, "itemTaxCategoryId"=>166, "keyName"=>"RAM_48_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (48 TB)", "id"=>4370, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_48_TB", "softwareDescriptionId"=>1154, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Host Ping", "id"=>49, "itemTaxCategoryId"=>166, "keyName"=>"MONITORING_HOST_PING", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Automated Notification", "id"=>52, "itemTaxCategoryId"=>166, "keyName"=>"AUTOMATED_NOTIFICATION", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"300", "description"=>"300 GB SA-SCSI 15K RPM", "id"=>352, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_300GB_SASCSI_15K_RPM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"144", "description"=>"144 GB Registered DDR3 1333", "id"=>1011, "itemTaxCategoryId"=>166, "keyName"=>"RAM_144_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"International Services", "id"=>3955, "itemTaxCategoryId"=>166, "keyName"=>"INTERNATIONAL_SERVICES", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"0 GB Bandwidth", "id"=>4481, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_0_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}]
          fixture_package_items[141] = [{"capacity"=>"192", "description"=>"192 GB Registered DDR3 1066", "id"=>1147, "itemTaxCategoryId"=>166, "keyName"=>"RAM_192_GB_DDR3_1066_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"6", "description"=>"RAID 6", "id"=>3958, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_6", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 2.x (48 TB)", "id"=>3961, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_2_X_48_TB", "softwareDescriptionId"=>1126, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"200", "description"=>"200 GB SSD", "id"=>3811, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_200GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Private Network Uplink", "id"=>498, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"128", "description"=>"128 GB Registered DDR3 1333", "id"=>1307, "itemTaxCategoryId"=>166, "keyName"=>"RAM_128_GB_DDR3_1333_REG_2", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"10000", "description"=>"10 Gbps Private Network Uplink", "id"=>3957, "itemTaxCategoryId"=>166, "keyName"=>"10_GBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 2.x (4 TB)", "id"=>3959, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_2_X_4_TB", "softwareDescriptionId"=>1124, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"RAID", "id"=>4478, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID", "softwareDescriptionId"=>nil, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"0 GB Bandwidth", "id"=>439, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_0_GB_2", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"100", "description"=>"100 Mbps Private Network Uplink", "id"=>497, "itemTaxCategoryId"=>166, "keyName"=>"100_MBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>498}, {"capacity"=>"1000", "description"=>"1.00 TB SATA II", "id"=>471, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_1_00TB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"24", "description"=>"24 GB Registered DDR3 1333", "id"=>826, "itemTaxCategoryId"=>166, "keyName"=>"RAM_24_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"600", "description"=>"600 GB SA-SCSI 15K RPM", "id"=>1094, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_600GB_SASCSI_15K_RPM", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"800", "description"=>"800 GB SSD", "id"=>4356, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_800GB_SSD", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (128 TB)", "id"=>4369, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_128_TB", "softwareDescriptionId"=>1155, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (16 TB)", "id"=>4371, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_16_TB", "softwareDescriptionId"=>1153, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"20000", "description"=>"20000 GB Bandwidth", "id"=>249, "itemTaxCategoryId"=>166, "keyName"=>"BANDWIDTH_20000_GB", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"description"=>"Redundant Power Supply", "id"=>469, "itemTaxCategoryId"=>166, "keyName"=>"REDUNDANT_POWER_SUPPLY", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"500", "description"=>"500 GB SATA II", "id"=>14, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_500GB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"10", "description"=>"10 Mbps Private Network Uplink", "id"=>496, "itemTaxCategoryId"=>166, "keyName"=>"10_MBPS_PRIVATE_NETWORK_UPLINK", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>497}, {"capacity"=>"10", "description"=>"RAID 10", "id"=>491, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_10", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"60", "description"=>"60 GB Registered DDR3 1333", "id"=>948, "itemTaxCategoryId"=>166, "keyName"=>"RAM_60_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"72", "description"=>"72 GB Registered DDR3 1333", "id"=>829, "itemTaxCategoryId"=>166, "keyName"=>"RAM_72_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"96", "description"=>"96 GB Registered DDR3 1333", "id"=>1050, "itemTaxCategoryId"=>166, "keyName"=>"RAM_96_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 2.x (16 TB)", "id"=>3960, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_2_X_16_TB", "softwareDescriptionId"=>1125, "units"=>"N/A", "upgradeItemId"=>nil}, {"description"=>"Email and Ticket", "id"=>51, "itemTaxCategoryId"=>166, "keyName"=>"NOTIFICATION_EMAIL_AND_TICKET", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"description"=>"Reboot / KVM over IP", "id"=>504, "itemTaxCategoryId"=>166, "keyName"=>"REBOOT_KVM_OVER_IP", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"5", "description"=>"RAID 5", "id"=>490, "itemTaxCategoryId"=>166, "keyName"=>"DISK_CONTROLLER_RAID_5", "softwareDescriptionId"=>nil, "upgradeItemId"=>nil}, {"capacity"=>"36", "description"=>"36 GB Registered DDR3 1333", "id"=>827, "itemTaxCategoryId"=>166, "keyName"=>"RAM_36_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 2.x (128 TB)", "id"=>3962, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_2_X_128_TB", "softwareDescriptionId"=>1127, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"2000", "description"=>"2.00 TB SATA II", "id"=>1091, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_2_00TB_SATA_II", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (4 TB)", "id"=>4372, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_4_TB", "softwareDescriptionId"=>1123, "units"=>"N/A", "upgradeItemId"=>nil}, {"capacity"=>"10000", "description"=>"10 Gbps Public & Private Network Uplinks", "id"=>1281, "itemTaxCategoryId"=>166, "keyName"=>"10_GBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"1000", "description"=>"1 Gbps Redundant Private Network Uplinks", "id"=>3956, "itemTaxCategoryId"=>166, "keyName"=>"1_GBPS_REDUNDANT_PRIVATE_NETWORK_UPLINKS", "softwareDescriptionId"=>nil, "units"=>"Mbps", "upgradeItemId"=>nil}, {"capacity"=>"3000", "description"=>"3.00 TB SATA III", "id"=>3989, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_3_00TB_SATA_III", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"4000", "description"=>"4.00 TB SATA III", "id"=>4281, "itemTaxCategoryId"=>166, "keyName"=>"HARD_DRIVE_4_00TB_SATA_III", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"48", "description"=>"48 GB Registered DDR3 1333", "id"=>828, "itemTaxCategoryId"=>166, "keyName"=>"RAM_48_GB_DDR3_1333_REG", "softwareDescriptionId"=>nil, "units"=>"GB", "upgradeItemId"=>nil}, {"capacity"=>"0", "description"=>"QuantaStor 3.x (48 TB)", "id"=>4370, "itemTaxCategoryId"=>166, "keyName"=>"OS_QUANTASTOR_3_X_48_TB", "softwareDescriptionId"=>1154, "units"=>"N/