/*
 * Decompiled with CFR 0.152.
 */
package org.grails.transaction;

import grails.config.Config;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.grails.config.PropertySourcesConfig;
import org.grails.transaction.ChainedTransactionManager;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.Ordered;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.util.ClassUtils;

public class ChainedTransactionManagerPostProcessor
implements BeanDefinitionRegistryPostProcessor,
Ordered {
    private static final String TRANSACTIONAL = "transactional";
    private static final String DEFAULT_TRANSACTION_MANAGER_BEAN_NAME_WHITELIST_PATTERN = "(?i).*transactionManager(_.+)?";
    private static final String DEFAULT_TRANSACTION_MANAGER_INTERNAL_BEAN_NAME_BLACKLIST_PATTERN = "(?i)chainedTransactionManagerPostProcessor|transactionManagerPostProcessor|.*PostProcessor";
    public static final String DATA_SOURCE_SETTING = "dataSource";
    public static final String DATA_SOURCES_SETTING = "dataSources";
    public static final String DATA_SOURCES_PREFIX = "dataSources.";
    private String beanNameWhitelistPattern = "(?i).*transactionManager(_.+)?";
    private String beanNameBlacklistPattern = null;
    private String beanNameInternalBlacklistPattern = "(?i)chainedTransactionManagerPostProcessor|transactionManagerPostProcessor|.*PostProcessor";
    private static final Pattern SUFFIX_PATTERN = Pattern.compile("^transactionManager_(.+)$");
    private static final String PRIMARY_TRANSACTION_MANAGER = "$primaryTransactionManager";
    private static final String TRANSACTION_MANAGER = "transactionManager";
    private static final String READONLY = "readOnly";
    private Config config;
    private Map<String, Map> dsConfigs;
    private static String[] transactionManagerBeanNames = null;

    public ChainedTransactionManagerPostProcessor(Config config) {
        this(config, null, null);
    }

    public ChainedTransactionManagerPostProcessor(Config config, String whitelistPattern, String blacklistPattern) {
        transactionManagerBeanNames = null;
        this.config = config;
        if (whitelistPattern != null) {
            this.beanNameWhitelistPattern = whitelistPattern;
        }
        if (blacklistPattern != null) {
            this.beanNameBlacklistPattern = blacklistPattern;
        }
    }

    public ChainedTransactionManagerPostProcessor() {
        this(new PropertySourcesConfig(), null, null);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    protected void registerAdditionalTransactionManagers(BeanDefinitionRegistry registry, BeanDefinition chainedTransactionManagerBeanDefinition, ManagedList<RuntimeBeanReference> transactionManagerRefs) {
        String[] allBeanNames;
        for (String beanName : allBeanNames = ChainedTransactionManagerPostProcessor.getTransactionManagerBeanNames(registry)) {
            String suffix;
            BeanDefinition beanDefinition = registry.getBeanDefinition(beanName);
            if (TRANSACTION_MANAGER.equals(beanName) || PRIMARY_TRANSACTION_MANAGER.equals(beanName) || !this.isValidTransactionManagerBeanDefinition(beanName, beanDefinition) || this.isNotTransactional(suffix = this.resolveDataSourceSuffix(beanName))) continue;
            transactionManagerRefs.add((Object)new RuntimeBeanReference(beanName));
        }
    }

    protected static String[] getTransactionManagerBeanNames(BeanDefinitionRegistry registry) {
        if (transactionManagerBeanNames == null) {
            transactionManagerBeanNames = registry instanceof ListableBeanFactory ? ((ListableBeanFactory)registry).getBeanNamesForType(PlatformTransactionManager.class, false, false) : registry.getBeanDefinitionNames();
        }
        return transactionManagerBeanNames;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        if (registry.containsBeanDefinition(TRANSACTION_MANAGER) && this.countChainableTransactionManagerBeans(registry) > 1 && !this.hasJtaOrChainedTransactionManager(registry)) {
            BeanDefinition chainedTransactionManagerBeanDefinition = this.addChainedTransactionManager(registry);
            ManagedList<RuntimeBeanReference> transactionManagerRefs = this.createTransactionManagerBeanReferences(chainedTransactionManagerBeanDefinition);
            this.registerAdditionalTransactionManagers(registry, chainedTransactionManagerBeanDefinition, transactionManagerRefs);
        }
    }

    protected ManagedList<RuntimeBeanReference> createTransactionManagerBeanReferences(BeanDefinition chainedTransactionManagerBeanDefinition) {
        ManagedList transactionManagerRefs = new ManagedList();
        ConstructorArgumentValues constructorValues = chainedTransactionManagerBeanDefinition.getConstructorArgumentValues();
        constructorValues.addIndexedArgumentValue(0, (Object)transactionManagerRefs);
        transactionManagerRefs.add((Object)new RuntimeBeanReference(PRIMARY_TRANSACTION_MANAGER));
        return transactionManagerRefs;
    }

    protected BeanDefinition addChainedTransactionManager(BeanDefinitionRegistry registry) {
        ChainedTransactionManagerPostProcessor.renameBean(TRANSACTION_MANAGER, PRIMARY_TRANSACTION_MANAGER, registry);
        RootBeanDefinition beanDefinition = new RootBeanDefinition(ChainedTransactionManager.class);
        registry.registerBeanDefinition(TRANSACTION_MANAGER, (BeanDefinition)beanDefinition);
        return beanDefinition;
    }

    protected boolean hasJtaOrChainedTransactionManager(BeanDefinitionRegistry registry) {
        Class<?> transactionManagerBeanClass = this.resolveTransactionManagerClass(registry);
        if (transactionManagerBeanClass == null) {
            return false;
        }
        boolean isJtaTransactionManager = JtaTransactionManager.class.isAssignableFrom(transactionManagerBeanClass);
        boolean isChainedTransactionManager = ChainedTransactionManager.class.isAssignableFrom(transactionManagerBeanClass);
        return isJtaTransactionManager || isChainedTransactionManager;
    }

    protected Class<?> resolveTransactionManagerClass(BeanDefinitionRegistry registry) {
        if (!registry.containsBeanDefinition(TRANSACTION_MANAGER)) {
            return null;
        }
        BeanDefinition transactionManagerBeanDefinition = registry.getBeanDefinition(TRANSACTION_MANAGER);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class transactionManagerBeanClass = ClassUtils.resolveClassName((String)transactionManagerBeanDefinition.getBeanClassName(), (ClassLoader)classLoader);
        return transactionManagerBeanClass;
    }

    protected int countChainableTransactionManagerBeans(BeanDefinitionRegistry registry) {
        int transactionManagerBeanCount = 0;
        for (String beanName : ChainedTransactionManagerPostProcessor.getTransactionManagerBeanNames(registry)) {
            BeanDefinition beanDefinition = registry.getBeanDefinition(beanName);
            if (!this.isValidTransactionManagerBeanDefinition(beanName, beanDefinition)) continue;
            String suffix = this.resolveDataSourceSuffix(beanName);
            if (!beanName.equals(TRANSACTION_MANAGER) && this.isNotTransactional(suffix)) continue;
            ++transactionManagerBeanCount;
        }
        return transactionManagerBeanCount;
    }

    protected boolean isValidTransactionManagerBeanDefinition(String beanName, BeanDefinition beanDefinition) {
        return beanName.matches(this.beanNameWhitelistPattern) && (this.beanNameBlacklistPattern == null || !beanName.matches(this.beanNameBlacklistPattern)) && !beanName.matches(this.beanNameInternalBlacklistPattern);
    }

    protected boolean isNotTransactional(String suffix) {
        if (suffix == null || this.config == null) {
            return false;
        }
        Boolean transactional = (Boolean)this.config.getProperty(DATA_SOURCES_PREFIX + suffix + "." + TRANSACTIONAL, Boolean.class, null);
        if (transactional == null) {
            transactional = (Boolean)this.config.getProperty(DATA_SOURCES_PREFIX + suffix + "." + READONLY, Boolean.class, null);
        }
        if (transactional != null) {
            return transactional == false;
        }
        return false;
    }

    protected String resolveDataSourceSuffix(String transactionManagerBeanName) {
        if (TRANSACTION_MANAGER.equals(transactionManagerBeanName)) {
            return "";
        }
        Matcher matcher = SUFFIX_PATTERN.matcher(transactionManagerBeanName);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    private static boolean renameBean(String oldName, String newName, BeanDefinitionRegistry registry) {
        if (!registry.containsBeanDefinition(oldName)) {
            return false;
        }
        LinkedHashSet<String> previousChildBeans = new LinkedHashSet<String>();
        for (String bdName : ChainedTransactionManagerPostProcessor.getTransactionManagerBeanNames(registry)) {
            BeanDefinition bd;
            if (oldName.equals(bdName) || !oldName.equals((bd = registry.getBeanDefinition(bdName)).getParentName())) continue;
            bd.setParentName(null);
            previousChildBeans.add(bdName);
        }
        BeanDefinition oldBeanDefinition = registry.getBeanDefinition(oldName);
        registry.removeBeanDefinition(oldName);
        registry.registerBeanDefinition(newName, oldBeanDefinition);
        for (String bdName : previousChildBeans) {
            BeanDefinition bd = registry.getBeanDefinition(bdName);
            bd.setParentName(newName);
        }
        return true;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public String getBeanNameWhitelistPattern() {
        return this.beanNameWhitelistPattern;
    }

    public void setBeanNameWhitelistPattern(String beanNameWhitelistPattern) {
        this.beanNameWhitelistPattern = beanNameWhitelistPattern;
    }

    public String getBeanNameBlacklistPattern() {
        return this.beanNameBlacklistPattern;
    }

    public void setBeanNameBlacklistPattern(String beanNameBlacklistPattern) {
        this.beanNameBlacklistPattern = beanNameBlacklistPattern;
    }

    public String getBeanNameInternalBlacklistPattern() {
        return this.beanNameInternalBlacklistPattern;
    }

    public void setBeanNameInternalBlacklistPattern(String beanNameInternalBlacklistPattern) {
        this.beanNameInternalBlacklistPattern = beanNameInternalBlacklistPattern;
    }
}

