/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapesurface;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.java.BS;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.quantum.QS;
import org.jmol.shape.MeshCollection;
import org.jmol.shapesurface.Isosurface;
import org.jmol.shapesurface.IsosurfaceMesh;
import org.jmol.util.Escape;

public class MolecularOrbital
extends Isosurface {
    private String moTranslucency;
    private Float moTranslucentLevel;
    private P4 moPlane;
    private Float moCutoff;
    private Float moResolution;
    private Float moScale;
    private Integer moColorPos;
    private Integer moColorNeg;
    private Integer moMonteCarloCount;
    private boolean moIsPositiveOnly;
    private Boolean moSquareData;
    private Boolean moSquareLinear;
    private Integer moRandomSeed;
    private int moFill = 1073742046;
    private int moMesh = 1073742018;
    private int moDots = 1073742042;
    private int moFrontOnly = 0x40000088;
    private int moShell = 1073742057;
    private String moTitleFormat;
    private boolean moDebug;
    private int myColorPt;
    private String strID;
    private int moNumber;
    private float[] moLinearCombination;
    private Map<String, Map<String, Object>> htModels;
    private Map<String, Object> thisModel;
    private Lst<Object> moSlab;
    private Integer moSlabValue;
    private String nboType;

    @Override
    public void initShape() {
        super.initShape();
        this.myType = "mo";
        this.setPropI("thisID", this.myType, null);
    }

    @Override
    public void setProperty(String propertyName, Object value, BS bs) {
        if ("init" == propertyName) {
            this.myColorPt = 0;
            this.moDebug = false;
            int modelIndex = (Integer)value;
            this.strID = this.getId(modelIndex);
            this.setPropI("init", null, null);
            this.setPropI("modelIndex", modelIndex, null);
            if (this.htModels == null) {
                this.htModels = new Hashtable<String, Map<String, Object>>();
            }
            if (!this.htModels.containsKey(this.strID)) {
                this.htModels.put(this.strID, new Hashtable());
            }
            this.thisModel = this.htModels.get(this.strID);
            this.moNumber = !this.thisModel.containsKey("moNumber") ? 0 : (Integer)this.thisModel.get("moNumber");
            this.moLinearCombination = (float[])this.thisModel.get("moLinearCombination");
            this.moSquareLinear = null;
            this.moSquareData = null;
            return;
        }
        if ("slab" == propertyName) {
            if (value instanceof Integer) {
                this.thisModel.put("slabValue", value);
            } else {
                Object[] slabInfo = (Object[])value;
                int tok = (Integer)slabInfo[0];
                this.moSlab = (Lst)this.thisModel.get("slab");
                if (this.moSlab == null) {
                    this.moSlab = new Lst();
                    this.thisModel.put("slab", this.moSlab);
                }
                if (tok == 1073742333) {
                    this.moSlab = null;
                    this.thisModel.remove("slab");
                    return;
                }
                this.moSlab.addLast(value);
            }
            return;
        }
        if ("cutoff" == propertyName) {
            this.thisModel.put("moCutoff", value);
            this.thisModel.put("moIsPositiveOnly", Boolean.FALSE);
            return;
        }
        if ("scale" == propertyName) {
            this.thisModel.put("moScale", value);
            return;
        }
        if ("squareData" == propertyName) {
            this.thisModel.put("moSquareData", Boolean.TRUE);
            this.moSquareData = Boolean.TRUE;
            return;
        }
        if ("squareLinear" == propertyName) {
            this.thisModel.put("moSquareLinear", Boolean.TRUE);
            this.moSquareLinear = Boolean.TRUE;
            return;
        }
        if ("cutoffPositive" == propertyName) {
            this.thisModel.put("moCutoff", value);
            this.thisModel.put("moIsPositiveOnly", Boolean.TRUE);
            return;
        }
        if ("resolution" == propertyName) {
            this.thisModel.put("moResolution", value);
            return;
        }
        if ("titleFormat" == propertyName) {
            this.moTitleFormat = (String)value;
            return;
        }
        if ("color" == propertyName) {
            if (!(value instanceof Integer)) {
                return;
            }
            this.thisModel.remove("moTranslucency");
            this.setPropI("color", value, bs);
            propertyName = "colorRGB";
            this.myColorPt = 0;
        }
        if ("colorRGB" == propertyName) {
            this.moColorPos = (Integer)value;
            if (this.myColorPt++ == 0) {
                this.moColorNeg = this.moColorPos;
            }
            this.thisModel.put("moColorNeg", this.moColorNeg);
            this.thisModel.put("moColorPos", this.moColorPos);
            return;
        }
        if ("plane" == propertyName) {
            if (value == null) {
                this.thisModel.remove("moPlane");
            } else {
                this.thisModel.put("moPlane", value);
            }
            return;
        }
        if ("monteCarloCount" == propertyName) {
            this.thisModel.put("monteCarloCount", value);
            return;
        }
        if ("randomSeed" == propertyName) {
            if (value == null) {
                this.thisModel.remove("randomSeed");
            } else {
                this.thisModel.put("randomSeed", value);
            }
            return;
        }
        if ("molecularOrbital" == propertyName) {
            if (value instanceof Integer) {
                this.moNumber = (Integer)value;
                this.thisModel.put("moNumber", value);
                this.thisModel.remove("moLinearCombination");
                this.moLinearCombination = null;
            } else {
                this.moNumber = 0;
                this.moLinearCombination = (float[])value;
                this.thisModel.put("moNumber", 0);
                this.thisModel.put("moLinearCombination", this.moLinearCombination);
            }
            if (this.moSquareData == Boolean.TRUE) {
                this.thisModel.put("moSquareData", Boolean.TRUE);
            } else {
                this.thisModel.remove("moSquareData");
            }
            if (this.moSquareLinear == Boolean.TRUE) {
                this.thisModel.put("moSquareLinear", Boolean.TRUE);
            } else {
                this.thisModel.remove("moSquareLinear");
            }
            this.setOrbital(this.moNumber, this.moLinearCombination);
            return;
        }
        if (propertyName == "deleteModelAtoms") {
            int modelIndex = ((int[])((Object[])value)[2])[0];
            Hashtable<String, Map<String, Object>> htModelsNew = new Hashtable<String, Map<String, Object>>();
            int i = this.meshCount;
            while (--i >= 0) {
                if (this.meshes[i] == null) continue;
                if (this.meshes[i].modelIndex == modelIndex) {
                    --this.meshCount;
                    if (this.meshes[i] == this.currentMesh) {
                        this.currentMesh = null;
                        this.thisModel = null;
                    }
                    this.meshes = (IsosurfaceMesh[])AU.deleteElements(this.meshes, i, 1);
                    continue;
                }
                Map<String, Object> htModel = this.htModels.get(this.meshes[i].thisID);
                if (this.meshes[i].modelIndex > modelIndex) {
                    --this.meshes[i].modelIndex;
                    this.meshes[i].thisID = this.getId(this.meshes[i].modelIndex);
                }
                htModelsNew.put(this.meshes[i].thisID, htModel);
            }
            this.htModels = htModelsNew;
            return;
        }
        if ("moData" == propertyName) {
            Map moData = (Map)value;
            this.nboType = (String)moData.get("nboType");
            if (this.nboType == null) {
                this.thisModel.remove("nboType");
            } else {
                this.thisModel.put("nboType", this.nboType);
            }
        } else if ("translucentLevel" == propertyName) {
            if (this.thisModel == null) {
                if (this.currentMesh == null) {
                    return;
                }
                this.thisModel = this.htModels.get(this.currentMesh.thisID);
            }
            this.thisModel.put("moTranslucentLevel", value);
        } else if ("delete" == propertyName) {
            this.htModels.remove(this.strID);
            this.moNumber = 0;
            this.moLinearCombination = null;
        } else if ("token" == propertyName) {
            int tok = (Integer)value;
            switch (tok) {
                case 1073742042: 
                case 1112150019: {
                    this.moDots = tok;
                    break;
                }
                case 1073741938: 
                case 1073742046: {
                    this.moFill = tok;
                    break;
                }
                case 1073742018: 
                case 0x400000E4: {
                    this.moMesh = tok;
                    break;
                }
                case 1073741862: 
                case 1073742057: {
                    this.moShell = tok;
                    break;
                }
                case 0x40000088: 
                case 1073742058: {
                    this.moFrontOnly = tok;
                }
            }
        } else if ("translucency" == propertyName) {
            if (this.thisModel == null) {
                if (this.currentMesh == null) {
                    return;
                }
                this.thisModel = this.htModels.get(this.currentMesh.thisID);
            }
            this.thisModel.put("moTranslucency", value);
        }
        this.setPropI(propertyName, value, bs);
    }

    private String getId(int modelIndex) {
        return "mo_model" + this.vwr.getModelNumberDotted(modelIndex);
    }

    @Override
    public Object getProperty(String propertyName, int index) {
        if (propertyName.startsWith("list")) {
            String s = "";
            if (propertyName.equals("list")) {
                s = (String)this.getPropI("list", index);
                if (s.length() > 1) {
                    s = s + "cutoff = " + this.jvxlData.cutoff + "\n";
                }
                s = "\n" + s;
            }
            return this.getMoInfo(-1) + s;
        }
        if (propertyName == "moNumber") {
            return this.moNumber;
        }
        if (propertyName == "moLinearCombination") {
            return this.moLinearCombination;
        }
        if (propertyName == "showMO") {
            int i0;
            boolean doOneMo;
            boolean isShowCurrent;
            SB str = new SB();
            Lst mos = (Lst)this.sg.params.moData.get("mos");
            int nOrb = mos == null ? 0 : mos.size();
            int thisMO = index;
            int currentMO = this.moNumber;
            boolean bl = isShowCurrent = thisMO == Integer.MIN_VALUE;
            if (isShowCurrent) {
                thisMO = currentMO;
            }
            if (nOrb == 0 || isShowCurrent && currentMO == 0) {
                return "";
            }
            boolean bl2 = doOneMo = thisMO != 0;
            if (currentMO == 0) {
                thisMO = 0;
            }
            boolean haveHeader = false;
            int nTotal = thisMO > 0 ? 1 : nOrb;
            for (int i = i0 = nTotal == 1 && currentMO > 0 ? currentMO : 1; i <= nOrb; ++i) {
                if (thisMO != 0 && thisMO != i && (doOneMo || i != currentMO)) continue;
                if (!doOneMo) {
                    this.setPropI("init", this.sg.params, null);
                    this.setOrbital(i, null);
                }
                this.jvxlData.moleculeXml = this.vwr.getModelCml(this.vwr.getModelUndeletedAtomsBitSet(this.thisMesh.modelIndex), 100, true, false);
                if (!haveHeader) {
                    str.append(JvxlCoder.jvxlGetFileVwr(this.vwr, this.jvxlData, null, null, "HEADERONLY", true, nTotal, null, null));
                    haveHeader = true;
                }
                str.append(JvxlCoder.jvxlGetFileVwr(this.vwr, this.jvxlData, null, this.jvxlData.title, null, false, 1, this.thisMesh.getState(this.myType), this.thisMesh.scriptCommand == null ? "" : this.thisMesh.scriptCommand));
                if (!doOneMo) {
                    this.setPropI("delete", "mo_show", null);
                }
                if (nTotal == 1) break;
            }
            str.append(JvxlCoder.jvxlGetFileVwr(this.vwr, this.jvxlData, null, null, "TRAILERONLY", true, 0, null, null));
            return str.toString();
        }
        return this.getPropI(propertyName, index);
    }

    public String getMoInfo(int modelIndex) {
        SB sb = new SB();
        int mc = this.vwr.ms.mc;
        for (int m = 0; m < mc; ++m) {
            int nOrb;
            Map moData;
            if (modelIndex >= 0 && m != modelIndex || (moData = (Map)this.vwr.ms.getInfo(m, "moData")) == null) continue;
            Lst mos = (Lst)moData.get("mos");
            int n = nOrb = mos == null ? 0 : mos.size();
            if (nOrb == 0) continue;
            String moType = (String)moData.get("nboType");
            if (moType == null) {
                moType = "mo";
            }
            int i = nOrb;
            while (--i >= 0) {
                String energy;
                String sym;
                Float occ;
                String units;
                Map mo = (Map)mos.get(i);
                String type = (String)mo.get("type");
                if (type == null) {
                    type = "";
                }
                if ((units = (String)mo.get("energyUnits")) == null) {
                    units = "";
                }
                if ((occ = (Float)mo.get("occupancy")) != null) {
                    type = "occupancy " + occ.floatValue() + " " + type;
                }
                if ((sym = (String)mo.get("symmetry")) != null) {
                    type = type + sym;
                }
                if (Float.isNaN(PT.parseFloat(energy = "" + mo.get("energy")))) {
                    sb.append(PT.sprintf("model %-2s; %s %-2i # %s\n", "ssis", new Object[]{this.vwr.ms.getModelNumberDotted(m), moType, i + 1, type}));
                    continue;
                }
                sb.append(PT.sprintf("model %-2s;  %s %-2i # energy %-8.3f %s %s\n", "ssifss", new Object[]{this.vwr.ms.getModelNumberDotted(m), moType, i + 1, mo.get("energy"), units, type}));
            }
        }
        return sb.toString();
    }

    @Override
    protected void clearSg() {
    }

    private boolean getSettings(String strID) {
        this.thisModel = this.htModels.get(strID);
        if (this.thisModel == null || this.thisModel.get("moNumber") == null) {
            return false;
        }
        this.moTranslucency = (String)this.thisModel.get("moTranslucency");
        this.moTranslucentLevel = (Float)this.thisModel.get("moTranslucentLevel");
        this.moPlane = (P4)this.thisModel.get("moPlane");
        this.moCutoff = (Float)this.thisModel.get("moCutoff");
        if (this.moCutoff == null) {
            this.moCutoff = (Float)this.sg.params.moData.get("defaultCutoff");
        }
        if (this.moCutoff == null) {
            this.moCutoff = Float.valueOf(0.05f);
        }
        this.thisModel.put("moCutoff", Float.valueOf(this.moCutoff.floatValue()));
        this.moResolution = (Float)this.thisModel.get("moResolution");
        this.moScale = (Float)this.thisModel.get("moScale");
        this.nboType = (String)this.thisModel.get("moType");
        this.moColorPos = (Integer)this.thisModel.get("moColorPos");
        this.moColorNeg = (Integer)this.thisModel.get("moColorNeg");
        this.moSquareData = (Boolean)this.thisModel.get("moSquareData");
        this.moSquareLinear = (Boolean)this.thisModel.get("moSquareLinear");
        this.moMonteCarloCount = (Integer)this.thisModel.get("monteCarloCount");
        this.moRandomSeed = (Integer)this.thisModel.get("randomSeed");
        this.moSlabValue = (Integer)this.thisModel.get("slabValue");
        this.moSlab = (Lst)this.thisModel.get("slab");
        if (this.moRandomSeed == null) {
            this.moRandomSeed = (int)(-System.currentTimeMillis()) % 10000;
            this.thisModel.put("randomSeed", this.moRandomSeed);
        }
        this.moNumber = (Integer)this.thisModel.get("moNumber");
        this.moLinearCombination = (float[])this.thisModel.get("moLinearCombination");
        Object b = this.thisModel.get("moIsPositiveOnly");
        this.moIsPositiveOnly = b != null && (Boolean)b != false;
        return true;
    }

    private void setOrbital(int moNumber, float[] linearCombination) {
        this.setPropI("reset", this.strID, null);
        if (this.moDebug) {
            this.setPropI("debug", Boolean.TRUE, null);
        }
        this.getSettings(this.strID);
        if (this.moScale != null) {
            this.setPropI("scale", this.moScale, null);
        }
        if (this.moResolution != null) {
            this.setPropI("resolution", this.moResolution, null);
        }
        if (this.moPlane != null) {
            this.setPropI("plane", this.moPlane, null);
            if (this.moCutoff != null) {
                this.setPropI("red", Float.valueOf(-this.moCutoff.floatValue()), null);
                this.setPropI("blue", this.moCutoff, null);
            }
        } else {
            if (this.moCutoff != null) {
                this.setPropI(this.moIsPositiveOnly ? "cutoffPositive" : "cutoff", this.moCutoff, null);
            }
            if (this.moColorNeg != null) {
                this.setPropI("colorRGB", this.moColorNeg, null);
            }
            if (this.moColorPos != null) {
                this.setPropI("colorRGB", this.moColorPos, null);
            }
            if (this.moMonteCarloCount != null) {
                this.setPropI("randomSeed", this.moRandomSeed, null);
                this.setPropI("monteCarloCount", this.moMonteCarloCount, null);
            }
        }
        this.setPropI("squareData", this.moSquareData, null);
        this.setPropI("squareLinear", this.moSquareLinear, null);
        this.setPropI("title", this.moTitleFormat, null);
        this.setPropI("fileName", this.vwr.fm.getFileName(), null);
        this.currentMesh.modelIndex = this.modelIndex;
        this.setPropI("molecularOrbital", linearCombination == null ? (Object)moNumber : linearCombination, null);
        if (this.moPlane != null && this.moColorNeg != null) {
            this.setPropI("colorRGB", this.moColorNeg, null);
        }
        if (this.moPlane != null && this.moColorPos != null) {
            this.setPropI("colorRGB", this.moColorPos, null);
        }
        this.currentMesh.isColorSolid = false;
        if (this.moSlabValue != null) {
            this.setPropI("slab", this.moSlabValue, null);
        }
        if (this.moSlab != null) {
            for (int i = 0; i < this.moSlab.size(); ++i) {
                this.setPropI("slab", this.moSlab.get(i), null);
            }
        }
        if (this.moTranslucentLevel != null) {
            this.setPropI("translucentLevel", this.moTranslucentLevel, null);
        }
        if (this.moTranslucency != null) {
            this.setPropI("translucency", this.moTranslucency, null);
        }
        this.setPropI("token", this.moFill, null);
        this.setPropI("token", this.moMesh, null);
        this.setPropI("token", this.moShell, null);
        this.setPropI("token", this.moDots, null);
        this.setPropI("token", this.moFrontOnly, null);
        this.thisModel.put("mesh", this.currentMesh);
    }

    @Override
    public String getShapeState() {
        if (this.htModels == null) {
            return "";
        }
        SB s = new SB();
        int modelCount = this.vwr.ms.mc;
        for (int iModel = 0; iModel < modelCount; ++iModel) {
            if (!this.getSettings(this.getId(iModel))) continue;
            if (modelCount > 1) {
                MolecularOrbital.appendCmd(s, "frame " + this.vwr.getModelNumberDotted(iModel));
            }
            if (this.nboType != null) {
                MolecularOrbital.appendCmd(s, "nbo type " + this.nboType);
            }
            if (this.moCutoff != null) {
                MolecularOrbital.appendCmd(s, this.myType + " cutoff " + (this.sg.params.isPositiveOnly ? "+" : "") + this.moCutoff);
            }
            if (this.moScale != null) {
                MolecularOrbital.appendCmd(s, this.myType + " scale " + this.moScale);
            }
            if (this.moMonteCarloCount != null) {
                MolecularOrbital.appendCmd(s, this.myType + " points " + this.moMonteCarloCount + " " + this.moRandomSeed);
            }
            if (this.moResolution != null) {
                MolecularOrbital.appendCmd(s, this.myType + " resolution " + this.moResolution);
            }
            if (this.moPlane != null) {
                MolecularOrbital.appendCmd(s, this.myType + " plane {" + this.moPlane.x + " " + this.moPlane.y + " " + this.moPlane.z + " " + this.moPlane.w + "}");
            }
            if (this.moTitleFormat != null) {
                MolecularOrbital.appendCmd(s, this.myType + " titleFormat " + PT.esc(this.moTitleFormat));
            }
            if (this.moColorNeg != null) {
                MolecularOrbital.appendCmd(s, this.myType + " color " + Escape.escapeColor(this.moColorNeg) + (this.moColorNeg.equals(this.moColorPos) ? "" : " " + Escape.escapeColor(this.moColorPos)));
            }
            if (this.moSlab != null) {
                if (this.thisMesh.slabOptions != null) {
                    MolecularOrbital.appendCmd(s, this.thisMesh.slabOptions.toString());
                }
                if (this.thisMesh.jvxlData.slabValue != Integer.MIN_VALUE) {
                    MolecularOrbital.appendCmd(s, this.myType + " slab " + this.thisMesh.jvxlData.slabValue);
                }
            }
            if (this.moLinearCombination == null) {
                MolecularOrbital.appendCmd(s, this.myType + " " + (this.moSquareData == Boolean.TRUE ? "squared " : "") + this.moNumber);
            } else {
                MolecularOrbital.appendCmd(s, this.myType + " " + QS.getMOString(this.moLinearCombination) + (this.moSquareLinear == Boolean.TRUE ? " squared" : ""));
            }
            if (this.moTranslucency != null) {
                MolecularOrbital.appendCmd(s, this.myType + " translucent " + this.moTranslucentLevel);
            }
            MolecularOrbital.appendCmd(s, ((IsosurfaceMesh)this.thisModel.get("mesh")).getState(this.myType));
        }
        return s.toString();
    }

    @Override
    public void merge(MeshCollection shape) {
        Map<String, Map<String, Object>> ht;
        MolecularOrbital mo = (MolecularOrbital)shape;
        this.moColorNeg = mo.moColorNeg;
        this.moColorPos = mo.moColorPos;
        this.moCutoff = mo.moCutoff;
        this.moPlane = mo.moPlane;
        this.moResolution = mo.moResolution;
        this.moScale = mo.moScale;
        this.moSlab = mo.moSlab;
        this.moSlabValue = mo.moSlabValue;
        this.moTitleFormat = mo.moTitleFormat;
        this.moTranslucency = mo.moTranslucency;
        if (this.htModels == null) {
            this.htModels = new Hashtable<String, Map<String, Object>>();
        }
        if ((ht = mo.htModels) != null) {
            for (Map.Entry<String, Map<String, Object>> entry : ht.entrySet()) {
                String key = entry.getKey();
                this.htModels.put(key, entry.getValue());
            }
        }
        super.merge(shape);
    }
}

