/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.Hashtable;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.SB;
import org.jmol.atomdata.RadiusData;
import org.jmol.geodesic.EnvelopeCalculation;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.shape.AtomShape;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.Escape;

public class Dots
extends AtomShape {
    public EnvelopeCalculation ec;
    public boolean isSurface = false;
    static final float SURFACE_DISTANCE_FOR_CALCULATION = 10.0f;
    BS bsOn = new BS();
    private BS bsSelected;
    private BS bsIgnore;
    public static int MAX_LEVEL = 3;
    int thisAtom;
    float thisRadius;
    int thisArgb;
    RadiusData rdLast = new RadiusData(null, 0.0f, null, null);

    @Override
    public void initShape() {
        super.initShape();
        this.translucentAllowed = false;
        this.ec = new EnvelopeCalculation().set(this.vwr, this.ac, this.mads);
    }

    @Override
    public int getSize(int atomIndex) {
        return this.mads != null ? this.mads[atomIndex] * 2 : (this.bsOn.get(atomIndex) ? (int)Math.floor(this.ec.getRadius(atomIndex) * 2000.0f) : 0);
    }

    @Override
    public void setProperty(String propertyName, Object value, BS bs) {
        if ("init" == propertyName) {
            this.initialize();
            return;
        }
        if ("translucency" == propertyName && !this.translucentAllowed) {
            return;
        }
        if ("ignore" == propertyName) {
            this.bsIgnore = (BS)value;
            return;
        }
        if ("select" == propertyName) {
            this.bsSelected = (BS)value;
            return;
        }
        if ("radius" == propertyName) {
            this.thisRadius = ((Float)value).floatValue();
            if (this.thisRadius > 16.0f) {
                this.thisRadius = 16.1f;
            }
            return;
        }
        if ("colorRGB" == propertyName) {
            this.thisArgb = (Integer)value;
            return;
        }
        if ("atom" == propertyName) {
            this.thisAtom = (Integer)value;
            if (this.thisAtom >= this.atoms.length) {
                return;
            }
            this.atoms[this.thisAtom].setShapeVisibility(this.vf, true);
            this.ec.allocDotsConvexMaps(this.ac);
            return;
        }
        if ("dots" == propertyName) {
            if (this.thisAtom >= this.atoms.length) {
                return;
            }
            this.isActive = true;
            this.ec.setFromBits(this.thisAtom, (BS)value);
            this.atoms[this.thisAtom].setShapeVisibility(this.vf, true);
            if (this.mads == null) {
                this.ec.setMads(null);
                this.mads = new short[this.ac];
                for (int i = 0; i < this.ac; ++i) {
                    if (!this.atoms[i].isVisible(1 | this.vf)) continue;
                    try {
                        this.mads[i] = (short)(this.ec.getAppropriateRadius(i) * 1000.0f);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.ec.setMads(this.mads);
            }
            this.mads[this.thisAtom] = (short)(this.thisRadius * 1000.0f);
            if (this.colixes == null) {
                this.checkColixLength((short)4, this.ac);
            }
            this.colixes[this.thisAtom] = C.getColix(this.thisArgb);
            this.bsOn.set(this.thisAtom);
            return;
        }
        if ("refreshTrajectories" == propertyName) {
            bs = (BS)((Object[])value)[1];
            M4 m4 = (M4)((Object[])value)[2];
            if (m4 == null) {
                return;
            }
            M3 m = new M3();
            m4.getRotationScale(m);
            this.ec.reCalculate(bs, m);
            return;
        }
        if (propertyName == "deleteModelAtoms") {
            int firstAtomDeleted = ((int[])((Object[])value)[2])[1];
            int nAtomsDeleted = ((int[])((Object[])value)[2])[2];
            BSUtil.deleteBits(this.bsOn, bs);
            this.ec.deleteAtoms(firstAtomDeleted, nAtomsDeleted);
        }
        this.setPropAS(propertyName, value, bs);
    }

    void initialize() {
        this.bsSelected = null;
        this.bsIgnore = null;
        this.isActive = false;
        if (this.ec == null) {
            this.ec = new EnvelopeCalculation().set(this.vwr, this.ac, this.mads);
        }
    }

    @Override
    protected void setSizeRD(RadiusData rd, BS bsSelected) {
        BS[] dotsConvexMaps;
        int i;
        boolean newSet;
        float maxRadius;
        if (rd == null) {
            rd = new RadiusData(null, 0.0f, RadiusData.EnumType.ABSOLUTE, null);
        }
        if (this.bsSelected != null) {
            bsSelected = this.bsSelected;
        }
        boolean isVisible = true;
        float setRadius = Float.MAX_VALUE;
        this.isActive = true;
        switch (rd.factorType) {
            case OFFSET: {
                break;
            }
            case ABSOLUTE: {
                if (rd.value == 0.0f) {
                    isVisible = false;
                }
                setRadius = rd.value;
            }
            default: {
                rd.valueExtended = this.vwr.getCurrentSolventProbeRadius();
            }
        }
        switch (rd.vdwType) {
            case ADPMIN: 
            case ADPMAX: 
            case HYDRO: 
            case TEMP: {
                maxRadius = setRadius;
                break;
            }
            case BONDING: {
                maxRadius = this.ms.getMaxVanderwaalsRadius() * 2.0f;
                break;
            }
            default: {
                maxRadius = this.ms.getMaxVanderwaalsRadius();
            }
        }
        boolean bl = newSet = this.rdLast.value != rd.value || this.rdLast.valueExtended != rd.valueExtended || this.rdLast.factorType != rd.factorType || this.rdLast.vdwType != rd.vdwType || this.ec.getDotsConvexMax() == 0;
        if (isVisible) {
            i = bsSelected.nextSetBit(0);
            while (i >= 0) {
                if (!this.bsOn.get(i)) {
                    this.bsOn.set(i);
                    newSet = true;
                }
                i = bsSelected.nextSetBit(i + 1);
            }
        } else {
            int i0;
            boolean isAll = bsSelected == null;
            int i2 = i0 = isAll ? this.ac - 1 : bsSelected.nextSetBit(0);
            while (i2 >= 0) {
                this.bsOn.setBitTo(i2, false);
                i2 = isAll ? i2 - 1 : bsSelected.nextSetBit(i2 + 1);
            }
        }
        i = this.ac;
        while (--i >= 0) {
            this.atoms[i].setShapeVisibility(this.vf, this.bsOn.get(i));
        }
        if (!isVisible) {
            return;
        }
        if (newSet) {
            this.mads = null;
            this.ec.newSet();
        }
        if ((dotsConvexMaps = this.ec.getDotsConvexMaps()) != null) {
            int i3 = this.ac;
            while (--i3 >= 0) {
                if (!this.bsOn.get(i3)) continue;
                dotsConvexMaps[i3] = null;
            }
        }
        if (dotsConvexMaps == null && (this.colixes == null || this.colixes.length != this.ac)) {
            this.checkColixLength((short)4, this.ac);
        }
        this.ec.calculate(rd, maxRadius, this.bsOn, this.bsIgnore, !this.vwr.getBoolean(603979830), this.vwr.getBoolean(603979829), this.isSurface, true);
        this.rdLast = rd;
    }

    @Override
    public void setAtomClickability() {
        int i = this.ac;
        while (--i >= 0) {
            Atom atom = this.atoms[i];
            if ((atom.shapeVisibilityFlags & this.vf) == 0 || this.ms.isAtomHidden(i)) continue;
            atom.setClickable(this.vf);
        }
    }

    @Override
    public String getShapeState() {
        BS[] dotsConvexMaps = this.ec.getDotsConvexMaps();
        if (dotsConvexMaps == null || this.ec.getDotsConvexMax() == 0) {
            return "";
        }
        SB s = new SB();
        Hashtable<String, BS> temp = new Hashtable<String, BS>();
        int ac = this.vwr.ms.ac;
        String type = this.isSurface ? "geoSurface " : "dots ";
        for (int i = 0; i < ac; ++i) {
            BS bs;
            if (!this.bsOn.get(i) || dotsConvexMaps[i] == null) continue;
            if (this.bsColixSet != null && this.bsColixSet.get(i)) {
                BSUtil.setMapBitSet(temp, i, i, Dots.getColorCommand(type, this.paletteIDs[i], this.colixes[i], this.translucentAllowed));
            }
            if ((bs = dotsConvexMaps[i]).isEmpty()) continue;
            float r = this.ec.getAppropriateRadius(i);
            Dots.appendCmd(s, type + i + " radius " + r + " " + Escape.eBS(bs));
        }
        return s.append(this.vwr.getCommands(temp, null, "select")).toString();
    }
}

