/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleValue;
import javax.swing.JComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.help.Helpful;
import org.openstreetmap.josm.tools.I18n;

public class MapScaler
extends JComponent
implements Helpful,
Accessible {
    private final NavigatableComponent mv;
    private static final int PADDING_LEFT = 5;
    private static final int PADDING_RIGHT = 50;

    public MapScaler(NavigatableComponent navigatableComponent) {
        this.mv = navigatableComponent;
        this.setPreferredLineLength(100);
        this.setOpaque(false);
    }

    public void setPreferredLineLength(int n) {
        this.setPreferredSize(new Dimension(n + 5 + 50, 30));
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(MapScaler.getColor());
        double d = this.mv.getDist100Pixel(true);
        TickMarks tickMarks = new TickMarks(d, this.getWidth() - 5 - 50);
        tickMarks.paintTicks(graphics);
    }

    public static Color getColor() {
        return Main.pref.getColor(I18n.marktr("scale"), Color.white);
    }

    @Override
    public String helpTopic() {
        return HelpUtil.ht("/MapView/Scaler");
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleMapScaler();
        }
        return this.accessibleContext;
    }

    private static final class TickMarks {
        private final double dist100Pixel;
        private final double lineDistance;
        private final double spacingMeter;
        private final int steps;
        private final int minorStepsPerMajor;

        TickMarks(double d, int n) {
            int n2;
            double d2;
            this.dist100Pixel = d;
            this.lineDistance = d * (double)n / 100.0;
            double d3 = Math.log(this.lineDistance) / Math.log(10.0);
            double d4 = Math.pow(10.0, Math.floor(d3));
            if (d3 - Math.floor(d3) < 0.75) {
                d2 = d4 / 2.0;
                n2 = 2;
            } else {
                d2 = d4;
                n2 = 5;
            }
            int n3 = (int)Math.floor(this.lineDistance / d2 / (double)n2);
            if (n3 >= 4) {
                this.spacingMeter = d2 * (double)n2;
                this.minorStepsPerMajor = 1;
            } else {
                this.minorStepsPerMajor = n2;
                this.spacingMeter = d2;
            }
            this.steps = n3 * this.minorStepsPerMajor;
        }

        public void paintTicks(Graphics graphics) {
            double d = this.spacingMeter / (this.dist100Pixel / 100.0);
            double d2 = -1.0;
            for (int i = 0; i <= this.steps; ++i) {
                int n = (int)(5.0 + d * (double)i);
                boolean bl = i % this.minorStepsPerMajor == 0;
                int n2 = bl ? 0 : 3;
                graphics.drawLine(n, n2, n, 10 - n2);
                if (i != 0 && i != this.steps) continue;
                String string = i == 0 ? "0" : NavigatableComponent.getDistText(this.spacingMeter * (double)i);
                Rectangle2D rectangle2D = graphics.getFontMetrics().getStringBounds(string, graphics);
                int n3 = (int)((double)n - rectangle2D.getWidth() / 2.0);
                if (d2 > (double)n3) {
                    n3 = (int)(d2 + 5.0);
                }
                graphics.drawString(string, n3, 23);
                d2 = (double)n3 + rectangle2D.getWidth() + 2.0;
            }
            graphics.drawLine(5, 5, (int)(5.0 + d * (double)this.steps), 5);
        }
    }

    class AccessibleMapScaler
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        AccessibleMapScaler() {
            super(MapScaler.this);
        }

        @Override
        public Number getCurrentAccessibleValue() {
            return MapScaler.this.mv.getDist100Pixel();
        }

        @Override
        public boolean setCurrentAccessibleValue(Number number) {
            return false;
        }

        @Override
        public Number getMinimumAccessibleValue() {
            return null;
        }

        @Override
        public Number getMaximumAccessibleValue() {
            return null;
        }
    }
}

