/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.LinkedList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.PluginDownloadException;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class PluginDownloadTask
extends PleaseWaitRunnable {
    public static final String PLUGIN_MIME_TYPES = "application/java-archive, application/zip; q=0.9, application/octet-stream; q=0.5";
    private final Collection<PluginInformation> toUpdate = new LinkedList<PluginInformation>();
    private final Collection<PluginInformation> failed = new LinkedList<PluginInformation>();
    private final Collection<PluginInformation> downloaded = new LinkedList<PluginInformation>();
    private Exception lastException;
    private boolean canceled;
    private HttpClient downloadConnection;

    public PluginDownloadTask(Component component, Collection<PluginInformation> collection, String string) {
        super(component, string == null ? "" : string, false);
        CheckParameterUtil.ensureParameterNotNull(collection, "toUpdate");
        this.toUpdate.addAll(collection);
    }

    public PluginDownloadTask(ProgressMonitor progressMonitor, Collection<PluginInformation> collection, String string) {
        super(string, progressMonitor == null ? NullProgressMonitor.INSTANCE : progressMonitor, false);
        CheckParameterUtil.ensureParameterNotNull(collection, "toUpdate");
        this.toUpdate.addAll(collection);
    }

    public void setPluginsToDownload(Collection<PluginInformation> collection) {
        CheckParameterUtil.ensureParameterNotNull(collection, "toUpdate");
        this.toUpdate.clear();
        this.toUpdate.addAll(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        this.canceled = true;
        PluginDownloadTask pluginDownloadTask = this;
        synchronized (pluginDownloadTask) {
            if (this.downloadConnection != null) {
                this.downloadConnection.disconnect();
            }
        }
    }

    @Override
    protected void finish() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void download(PluginInformation pluginInformation, File file) throws PluginDownloadException {
        Object object;
        if (pluginInformation.mainversion > Version.getInstance().getVersion()) {
            object = new ExtendedDialog(this.progressMonitor.getWindowParent(), I18n.tr("Skip download", new Object[0]), I18n.tr("Download Plugin", new Object[0]), I18n.tr("Skip Download", new Object[0]));
            ((ExtendedDialog)object).setContent(I18n.tr("JOSM version {0} required for plugin {1}.", pluginInformation.mainversion, pluginInformation.name));
            ((ExtendedDialog)object).setButtonIcons("download", "cancel");
            ((ExtendedDialog)object).showDialog();
            int n = ((ExtendedDialog)object).getValue();
            if (n != 1) {
                throw new PluginDownloadException(I18n.tr("Download skipped", new Object[0]));
            }
        }
        try {
            if (pluginInformation.downloadlink == null) {
                object = I18n.tr("Cannot download plugin ''{0}''. Its download link is not known. Skipping download.", pluginInformation.name);
                Main.warn((String)object);
                throw new PluginDownloadException((String)object);
            }
            object = new URL(pluginInformation.downloadlink);
            Object object2 = this;
            synchronized (object2) {
                this.downloadConnection = HttpClient.create((URL)object).setAccept(PLUGIN_MIME_TYPES);
                this.downloadConnection.connect();
            }
            object2 = this.downloadConnection.getResponse().getContent();
            Throwable throwable = null;
            try {
                Files.copy((InputStream)object2, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object2 != null) {
                    if (throwable != null) {
                        try {
                            ((InputStream)object2).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((InputStream)object2).close();
                    }
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            String string = I18n.tr("Cannot download plugin ''{0}''. Its download link ''{1}'' is not a valid URL. Skipping download.", pluginInformation.name, pluginInformation.downloadlink);
            Main.warn(string);
            throw new PluginDownloadException(string, malformedURLException);
        }
        catch (IOException iOException) {
            if (this.canceled) {
                return;
            }
            throw new PluginDownloadException(iOException);
        }
        finally {
            PluginDownloadTask pluginDownloadTask = this;
            synchronized (pluginDownloadTask) {
                this.downloadConnection = null;
            }
        }
    }

    @Override
    protected void realRun() throws SAXException, IOException {
        File file = Main.pref.getPluginsDirectory();
        if (!file.exists() && !file.mkdirs()) {
            String string = I18n.tr("Failed to create plugin directory ''{0}''", file.toString());
            this.lastException = new PluginDownloadException(string);
            Main.error(string);
            this.failed.addAll(this.toUpdate);
            return;
        }
        this.getProgressMonitor().setTicksCount(this.toUpdate.size());
        for (PluginInformation pluginInformation : this.toUpdate) {
            if (this.canceled) {
                return;
            }
            String string = I18n.tr("Downloading Plugin {0}...", pluginInformation.name);
            Main.info(string);
            this.progressMonitor.subTask(string);
            this.progressMonitor.worked(1);
            File file2 = new File(file, pluginInformation.name + ".jar.new");
            try {
                this.download(pluginInformation, file2);
            }
            catch (PluginDownloadException pluginDownloadException) {
                this.lastException = pluginDownloadException;
                Main.error(pluginDownloadException);
                this.failed.add(pluginInformation);
                continue;
            }
            this.downloaded.add(pluginInformation);
        }
        PluginHandler.installDownloadedPlugins(false);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public Collection<PluginInformation> getFailedPlugins() {
        return this.failed;
    }

    public Collection<PluginInformation> getDownloadedPlugins() {
        return this.downloaded;
    }

    public Exception getLastException() {
        return this.lastException;
    }
}

