/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.components;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.load.java.JavaBindingContext;
import org.jetbrains.kotlin.load.java.components.SignaturePropagator;
import org.jetbrains.kotlin.load.java.structure.JavaMethod;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.jvm.kotlinSignature.SignaturesPropagationData;
import org.jetbrains.kotlin.types.KotlinType;

public class SignaturePropagatorImpl
implements SignaturePropagator {
    private final BindingTrace trace;

    public SignaturePropagatorImpl(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/load/java/components/SignaturePropagatorImpl", "<init>"));
        }
        this.trace = trace;
    }

    @Override
    @NotNull
    public SignaturePropagator.PropagatedSignature resolvePropagatedSignature(@NotNull JavaMethod method, @NotNull ClassDescriptor owner, @NotNull KotlinType returnType, @Nullable KotlinType receiverType, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull List<TypeParameterDescriptor> typeParameters) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/load/java/components/SignaturePropagatorImpl", "resolvePropagatedSignature"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/load/java/components/SignaturePropagatorImpl", "resolvePropagatedSignature"));
        }
        if (returnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/kotlin/load/java/components/SignaturePropagatorImpl", "resolvePropagatedSignature"));
        }
        if (valueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameters", "org/jetbrains/kotlin/load/java/components/SignaturePropagatorImpl", "resolvePropagatedSignature"));
        }
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/load/java/components/SignaturePropagatorImpl", "resolvePropagatedSignature"));
        }
        SignaturesPropagationData data = new SignaturesPropagationData(owner, returnType, receiverType, valueParameters, typeParameters, method);
        SignaturePropagator.PropagatedSignature propagatedSignature = new SignaturePropagator.PropagatedSignature(returnType, data.getModifiedReceiverType(), data.getModifiedValueParameters(), typeParameters, data.getSignatureErrors(), data.getModifiedHasStableParameterNames());
        if (propagatedSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/components/SignaturePropagatorImpl", "resolvePropagatedSignature"));
        }
        return propagatedSignature;
    }

    @Override
    public void reportSignatureErrors(@NotNull CallableMemberDescriptor descriptor2, @NotNull List<String> signatureErrors) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/load/java/components/SignaturePropagatorImpl", "reportSignatureErrors"));
        }
        if (signatureErrors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signatureErrors", "org/jetbrains/kotlin/load/java/components/SignaturePropagatorImpl", "reportSignatureErrors"));
        }
        this.trace.record(JavaBindingContext.LOAD_FROM_JAVA_SIGNATURE_ERRORS, descriptor2.getOriginal(), signatureErrors);
    }
}

