/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.application.snapshot;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.application.snapshot.ApplicationSnapshot;
import com.sun.tools.visualvm.application.snapshot.ApplicationSnapshotsSupport;
import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasupport.DataChangeEvent;
import com.sun.tools.visualvm.core.datasupport.DataChangeListener;
import com.sun.tools.visualvm.core.snapshot.Snapshot;
import com.sun.tools.visualvm.core.ui.DataSourceViewsManager;
import com.sun.tools.visualvm.core.ui.actions.ActionUtils;
import com.sun.tools.visualvm.core.ui.actions.MultiDataSourceAction;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ApplicationSnapshotAction
extends MultiDataSourceAction<Application> {
    private Set<Application> lastSelectedApplications = new HashSet<Application>();
    private static ApplicationSnapshotAction instance;
    private final DataChangeListener changeListener = new DataChangeListener(){

        public void dataChanged(DataChangeEvent event) {
            ApplicationSnapshotAction.super.updateState(ActionUtils.getSelectedDataSources(Application.class));
        }
    };

    public static synchronized ApplicationSnapshotAction instance() {
        if (instance == null) {
            instance = new ApplicationSnapshotAction();
        }
        return instance;
    }

    protected void actionPerformed(Set<Application> applications, ActionEvent actionEvent) {
        for (Application application : applications) {
            ApplicationSnapshotsSupport.getInstance().getSnapshotProvider().createSnapshot(application, (actionEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) == 0);
        }
    }

    protected boolean isEnabled(Set<Application> applications) {
        for (Application application : applications) {
            if (DataSourceViewsManager.sharedInstance().canSaveViewsFor((DataSource)application, ApplicationSnapshot.class)) {
                return true;
            }
            if (!application.getRepository().getDataSources(Snapshot.class).isEmpty()) continue;
            return false;
        }
        return true;
    }

    protected void updateState(Set<Application> selectedApplications) {
        super.updateState(selectedApplications);
        if (!this.lastSelectedApplications.isEmpty()) {
            for (Application application : this.lastSelectedApplications) {
                application.getRepository().removeDataChangeListener(this.changeListener);
            }
        }
        this.lastSelectedApplications.clear();
        if (!selectedApplications.isEmpty()) {
            this.lastSelectedApplications.addAll(selectedApplications);
            for (Application application : this.lastSelectedApplications) {
                application.getRepository().addDataChangeListener(this.changeListener, Snapshot.class);
            }
        }
    }

    private ApplicationSnapshotAction() {
        super(Application.class);
        this.putValue("Name", NbBundle.getMessage(ApplicationSnapshotAction.class, (String)"LBL_Application_Snapshot"));
        this.putValue("ShortDescription", NbBundle.getMessage(ApplicationSnapshotAction.class, (String)"DESCR_Application_Snapshot"));
    }
}

