#ifndef _ECORE_POLLER_EO_H_
#define _ECORE_POLLER_EO_H_

#ifndef _ECORE_POLLER_EO_CLASS_TYPE
#define _ECORE_POLLER_EO_CLASS_TYPE

typedef Eo Ecore_Poller;

#endif

#ifndef _ECORE_POLLER_EO_TYPES
#define _ECORE_POLLER_EO_TYPES

/** Defines the frequency of ticks for the poller.
 *
 * @ingroup Ecore
 */
typedef enum
{
  ECORE_POLLER_CORE = 0 /** The core poller interval */
} Ecore_Poller_Type;


#endif
/**
 * @brief Ecore poller provides infrastructure for the creation of pollers.
 *
 * Pollers are, in essence, callbacks that share a single timer per type.
 * Because not all pollers need to be called at the same frequency the user may
 * specify the frequency in ticks(each expiration of the shared timer is called
 * a tick, in ecore poller parlance) for each added poller. Ecore pollers
 * should only be used when the poller doesn't have specific requirements on
 * the exact times to poll.
 *
 * This architecture means that the main loop is only woken up once to handle
 * all pollers of that type, this will save power as the CPU has more of a
 * chance to go into a low power state the longer it is asleep for, so this
 * should be used in situations where power usage is a concern.
 *
 * For now only 1 core poller type is supported: ECORE_POLLER_CORE, the default
 * interval for ECORE_POLLER_CORE is 0.125(or 1/8th) second.
 *
 * @ingroup Ecore_Poller
 */
#define ECORE_POLLER_CLASS ecore_poller_class_get()

EWAPI const Eo_Class *ecore_poller_class_get(void);

/**
 * @brief Polling interval rate of the poller.
 *
 * @param[in] interval The tick interval; must be a power of 2 and <= 32768.
 *
 * @return true on success, false on failure.
 *
 * @ingroup Ecore_Poller
 */
EOAPI Eina_Bool ecore_poller_interval_set(Eo *obj, int interval);

/**
 * @brief Polling interval rate of the poller.
 *
 * @return The tick interval; must be a power of 2 and <= 32768.
 *
 * @ingroup Ecore_Poller
 */
EOAPI int ecore_poller_interval_get(const Eo *obj);

/**
 * @brief Constructor with parameters for Ecore Poller.
 *
 * @param[in] type Ecore poller type which defines the frequency of ticks for
 * the poller.
 * @param[in] interval The tick interval; must be a power of 2 and <= 32768.
 * @param[in] func Ecore poller callback function.
 * @param[in] data Private data passed to callback function.
 *
 * @ingroup Ecore_Poller
 */
EOAPI void ecore_poller_constructor(Eo *obj, Ecore_Poller_Type type, int interval, Ecore_Task_Cb func, const void *data);


#endif
