#ifndef _EFL_NETWORK_SERVER_EO_H_
#define _EFL_NETWORK_SERVER_EO_H_

#ifndef _EFL_NETWORK_SERVER_EO_CLASS_TYPE
#define _EFL_NETWORK_SERVER_EO_CLASS_TYPE

typedef Eo Efl_Network_Server;

#endif

#ifndef _EFL_NETWORK_SERVER_EO_TYPES
#define _EFL_NETWORK_SERVER_EO_TYPES


#endif
/** Efl network server
 *
 * @ingroup Efl_Network_Server
 */
#define EFL_NETWORK_SERVER_CLASS efl_network_server_class_get()

EWAPI const Eo_Class *efl_network_server_class_get(void);

/**
 * @brief Retrieves the name of server.
 *
 * The name returned is the name used to connect on this server.
 *
 * @param[in] name The name of the server.
 *
 * @ingroup Efl_Network_Server
 */
EOAPI void efl_network_server_name_set(Eo *obj, const char *name);

/**
 * @brief Retrieves the name of server.
 *
 * The name returned is the name used to connect on this server.
 *
 * @return The name of the server.
 *
 * @ingroup Efl_Network_Server
 */
EOAPI const char *efl_network_server_name_get(const Eo *obj);

/**
 * @brief Sets a limit on the number of clients that can be handled
 * concurrently by the given server, and a policy on what to do if excess
 * clients try to connect.
 *
 * Beware that if you set this once ecore is already running, you may already
 * have pending CLIENT_ADD events in your event queue.  Those clients have
 * already connected and will not be affected by this call. Only clients
 * subsequently trying to connect will be affected.
 *
 * @param[in] client_limit The maximum number of clients to handle
 * concurrently. -1 means unlimited (default). 0 effectively disables the
 * server.
 * @param[in] reject_excess_clients Set to 1 to automatically disconnect excess
 * clients as soon as they connect if you are already handling client_limit
 * clients. Set to 0 (default) to just hold off on the "accept()" system call
 * until the number of active  clients drops. This causes the kernel to queue
 * up to 4096 connections (or your kernel's limit, whichever is lower).
 *
 * @ingroup Efl_Network_Server
 */
EOAPI void efl_network_server_client_limit_set(Eo *obj, int client_limit, char reject_excess_clients);

/**
 * @brief Sets a limit on the number of clients that can be handled
 * concurrently by the given server, and a policy on what to do if excess
 * clients try to connect.
 *
 * Beware that if you set this once ecore is already running, you may already
 * have pending CLIENT_ADD events in your event queue.  Those clients have
 * already connected and will not be affected by this call. Only clients
 * subsequently trying to connect will be affected.
 *
 * @param[out] client_limit The maximum number of clients to handle
 * concurrently. -1 means unlimited (default). 0 effectively disables the
 * server.
 * @param[out] reject_excess_clients Set to 1 to automatically disconnect
 * excess clients as soon as they connect if you are already handling
 * client_limit clients. Set to 0 (default) to just hold off on the "accept()"
 * system call until the number of active  clients drops. This causes the
 * kernel to queue up to 4096 connections (or your kernel's limit, whichever is
 * lower).
 *
 * @ingroup Efl_Network_Server
 */
EOAPI void efl_network_server_client_limit_get(const Eo *obj, int *client_limit, char *reject_excess_clients);

/**
 * @brief Retrieves the current list of clients.
 *
 * Each node in the returned list points to an @ref Efl_Network_Client. This
 * list cannot be modified or freed. It can also change if new clients are
 * connected or disconnected, and will become invalid when the server is
 * deleted/freed.
 *
 * @return The list of clients on this server.
 *
 * @ingroup Efl_Network_Server
 */
EOAPI const Eina_List *efl_network_server_clients_get(const Eo *obj);

/**
 * @brief Type of the server connection as defined in @ref Ecore_Con_Type
 *
 * @param[in] conn_type Connection type
 *
 * @ingroup Efl_Network_Server
 */
EOAPI void efl_network_server_connection_type_set(Eo *obj, Ecore_Con_Type conn_type);

/**
 * @brief Type of the server connection as defined in @ref Ecore_Con_Type
 *
 * @return Connection type
 *
 * @ingroup Efl_Network_Server
 */
EOAPI Ecore_Con_Type efl_network_server_connection_type_get(const Eo *obj);


#endif
