/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import net.sourceforge.jnlp.util.logging.OutputController;

public class ConnectionFactory {
    private final List<URLConnection> httpsConnections = new ArrayList<URLConnection>();

    private boolean isSyncForced() {
        return false;
    }

    public static ConnectionFactory getConnectionFactory() {
        return ConnectionFactoryHolder.INSTANCE;
    }

    public URLConnection openConnection(URL url) throws IOException {
        OutputController.getLogger().log("Connecting " + url.toExternalForm());
        if (url.getProtocol().equalsIgnoreCase("https")) {
            if (this.isSyncForced()) {
                OutputController.getLogger().log("Waiting for " + this.httpsConnections.size() + " connections to finish");
                while (!this.httpsConnections.isEmpty()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ex) {
                        throw new IOException(ex);
                    }
                }
            }
            return this.openHttpsConnection(url);
        }
        URLConnection conn = url.openConnection();
        OutputController.getLogger().log("done " + url.toExternalForm());
        return conn;
    }

    private synchronized URLConnection openHttpsConnection(URL url) throws IOException {
        URLConnection conn = null;
        conn = url.openConnection();
        OutputController.getLogger().log("Adding " + conn.toString());
        this.httpsConnections.add(conn);
        OutputController.getLogger().log("done " + url.toExternalForm());
        return conn;
    }

    public void disconnect(URLConnection conn) {
        if (conn != null) {
            OutputController.getLogger().log("Disconnecting " + conn.toString());
            if (conn instanceof HttpsURLConnection) {
                this.closeHttpsConnection((HttpsURLConnection)conn);
            } else if (conn instanceof HttpURLConnection) {
                ((HttpURLConnection)conn).disconnect();
            }
        } else {
            OutputController.getLogger().log("\"Disconnecting\" null connection. This is ok if you are offline.");
        }
    }

    private synchronized void closeHttpsConnection(HttpsURLConnection conn) {
        conn.disconnect();
        for (int i = 0; i < this.httpsConnections.size(); ++i) {
            URLConnection urlConnection = this.httpsConnections.get(i);
            if (urlConnection != conn) continue;
            this.httpsConnections.remove(i);
            OutputController.getLogger().log("Removed " + urlConnection.toString());
            --i;
        }
    }

    private static class ConnectionFactoryHolder {
        private static volatile ConnectionFactory INSTANCE = new ConnectionFactory();

        private ConnectionFactoryHolder() {
        }
    }
}

