/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.Switches;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.ActionUtils;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class DockWindowAction
extends AbstractAction {
    private final TopComponent tc;

    public DockWindowAction() {
        this.tc = null;
        this.putValue("Name", NbBundle.getMessage(DockWindowAction.class, (String)"CTL_UndockWindowAction_Dock"));
    }

    public DockWindowAction(TopComponent topComponent) {
        this.tc = topComponent;
        this.putValue("Name", NbBundle.getMessage(DockWindowAction.class, (String)"CTL_UndockWindowAction_Dock"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        TopComponent topComponent = this.getTC2WorkWith();
        if (null == topComponent) {
            return;
        }
        if (windowManagerImpl.isTopComponentMinimized(topComponent)) {
            windowManagerImpl.setTopComponentMinimized(topComponent, false);
        } else {
            boolean bl = windowManagerImpl.isDocked(topComponent);
            ModeImpl modeImpl = (ModeImpl)windowManagerImpl.findMode(topComponent);
            if (!bl) {
                windowManagerImpl.userDockedTopComponent(topComponent, modeImpl);
            }
        }
    }

    @Override
    public void putValue(String string, Object object) {
        if ("AcceleratorKey".equals(string)) {
            ActionUtils.putSharedAccelerator("DockWindowAction", object);
        } else {
            super.putValue(string, object);
        }
    }

    @Override
    public Object getValue(String string) {
        if ("AcceleratorKey".equals(string)) {
            return ActionUtils.getSharedAccelerator("DockWindowAction");
        }
        return super.getValue(string);
    }

    @Override
    public boolean isEnabled() {
        boolean bl;
        TopComponent topComponent = this.getTC2WorkWith();
        boolean bl2 = bl = null != topComponent;
        if (bl) {
            if (WindowManagerImpl.getInstance().isTopComponentMinimized(topComponent)) {
                bl = true;
            } else if (bl &= Switches.isTopComponentUndockingEnabled() && Switches.isUndockingEnabled(topComponent)) {
                bl &= !WindowManagerImpl.getInstance().isDocked(topComponent);
            }
        }
        return bl;
    }

    private TopComponent getTC2WorkWith() {
        if (this.tc != null) {
            return this.tc;
        }
        return WindowManager.getDefault().getRegistry().getActivated();
    }
}

