/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.config;

import ch.interlis.ili2c.config.BoidEntry;
import ch.interlis.ili2c.config.Configuration;
import ch.interlis.ili2c.config.FileEntry;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;

public class PersistenceService {
    private static final String AUTO_COMPLETE_MODELS = "--auto-complete-models";

    public static Configuration readConfig(String filename) throws IOException, FileNotFoundException {
        String line;
        File inputFile = new File(filename);
        BufferedReader in = new BufferedReader(new FileReader(inputFile));
        Configuration config = new Configuration();
        config.setCheckMetaObjs(false);
        while ((line = in.readLine()) != null) {
            String arg = line.trim();
            if (arg.startsWith("-")) {
                String optvalue;
                if (arg.startsWith("-m ")) {
                    optvalue = arg.substring(3);
                    FileEntry entry = new FileEntry(optvalue, 2);
                    config.addFileEntry(entry);
                    continue;
                }
                if (arg.startsWith("-o0")) {
                    config.setOutputKind(1);
                    continue;
                }
                if (arg.startsWith("-o1 ")) {
                    optvalue = arg.substring(4);
                    config.setOutputFile(optvalue);
                    config.setOutputKind(2);
                    continue;
                }
                if (arg.startsWith("-o2 ")) {
                    optvalue = arg.substring(4);
                    config.setOutputFile(optvalue);
                    config.setOutputKind(3);
                    continue;
                }
                if (arg.startsWith("-oXSD ")) {
                    optvalue = arg.substring(6);
                    config.setOutputFile(optvalue);
                    config.setOutputKind(4);
                    continue;
                }
                if (arg.startsWith("-oFMT ")) {
                    optvalue = arg.substring(6);
                    config.setOutputFile(optvalue);
                    config.setOutputKind(5);
                    continue;
                }
                if (arg.startsWith("-oJAVA ")) continue;
                if (arg.startsWith("-oGML ")) {
                    optvalue = arg.substring(8);
                    config.setOutputFile(optvalue);
                    config.setOutputKind(6);
                    continue;
                }
                if (arg.startsWith("-oIOM ")) continue;
                if (arg.startsWith("-boid ")) {
                    optvalue = arg.substring(6);
                    int eqpos = optvalue.indexOf(61);
                    String qualifiedBasketName = optvalue.substring(0, eqpos);
                    String boid = optvalue.substring(eqpos + 1);
                    config.addBoidEntry(new BoidEntry(qualifiedBasketName, boid));
                    continue;
                }
                if (arg.startsWith("--with-predefined")) continue;
                if (arg.startsWith("--check-metaobj")) {
                    config.setCheckMetaObjs(true);
                    continue;
                }
                if (arg.startsWith(AUTO_COMPLETE_MODELS)) {
                    config.setAutoCompleteModelList(true);
                    continue;
                }
                if (!arg.startsWith("--without-warnings")) continue;
                config.setGenerateWarnings(false);
                continue;
            }
            if (arg.length() <= 0) continue;
            FileEntry entry = new FileEntry(arg, 1);
            config.addFileEntry(entry);
        }
        in.close();
        return config;
    }

    public static void writeConfig(String filename, Configuration config) throws IOException {
        File outputFile = new File(filename);
        BufferedWriter out = new BufferedWriter(new FileWriter(outputFile));
        if (!config.isGenerateWarnings()) {
            out.write("--without-warnings");
            out.newLine();
        }
        if (config.isCheckMetaObjs()) {
            out.write("--check-metaobj");
            out.newLine();
        }
        if (config.isAutoCompleteModelList()) {
            out.write(AUTO_COMPLETE_MODELS);
            out.newLine();
        }
        Iterator boidi = config.iteratorBoidEntry();
        while (boidi.hasNext()) {
            BoidEntry e = (BoidEntry)boidi.next();
            out.write("-boid ");
            out.write(e.getMetaDataUseDef());
            out.write("=");
            out.write(e.getBoid());
            out.newLine();
        }
        Iterator filei = config.iteratorFileEntry();
        while (filei.hasNext()) {
            FileEntry e = (FileEntry)filei.next();
            if (e.getKind() == 2) {
                out.write("-m ");
            }
            out.write(e.getFilename());
            out.newLine();
        }
        switch (config.getOutputKind()) {
            case 1: {
                out.write("-o0");
                break;
            }
            case 2: {
                out.write("-o1 ");
                out.write(config.getOutputFile());
                break;
            }
            case 3: {
                out.write("-o2 ");
                out.write(config.getOutputFile());
                break;
            }
            case 4: {
                out.write("-oXSD ");
                out.write(config.getOutputFile());
                break;
            }
            case 5: {
                out.write("-oFMT ");
                out.write(config.getOutputFile());
                break;
            }
            case 6: {
                out.write("-oGML ");
                out.write(config.getOutputFile());
                break;
            }
        }
        out.newLine();
        out.close();
    }
}

