/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.styleelement;

import java.util.Objects;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.styleelement.StyleElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.TextLabel;

public class LineTextElement
extends StyleElement {
    private final TextLabel text;

    protected LineTextElement(Cascade cascade, TextLabel textLabel) {
        super(cascade, 4.9f);
        this.text = textLabel;
    }

    public static LineTextElement create(Environment environment) {
        Cascade cascade = environment.mc.getCascade(environment.layer);
        Keyword keyword = cascade.get("text-position", null, Keyword.class);
        if (keyword != null && !"line".equals(keyword.val)) {
            return null;
        }
        TextLabel textLabel = TextLabel.create(environment, PaintColors.TEXT.get(), false);
        if (textLabel == null) {
            return null;
        }
        return new LineTextElement(cascade, textLabel);
    }

    @Override
    public void paintPrimitive(OsmPrimitive osmPrimitive, MapPaintSettings mapPaintSettings, StyledMapRenderer styledMapRenderer, boolean bl, boolean bl2, boolean bl3) {
        Way way = (Way)osmPrimitive;
        styledMapRenderer.drawTextOnPath(way, this.text);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        LineTextElement lineTextElement = (LineTextElement)object;
        return Objects.equals(this.text, lineTextElement.text);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.text);
    }

    @Override
    public String toString() {
        return "LineTextElemStyle{" + super.toString() + "text=" + this.text + '}';
    }
}

