/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.common;

import com.sun.star.beans.PropertyValue;
import com.sun.star.bridge.XUnoUrlResolver;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.container.XHierarchicalNameAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XFramesSupplier;
import com.sun.star.i18n.ParseResult;
import com.sun.star.i18n.XCharacterClassification;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.uno.XInterface;
import com.sun.star.util.URL;
import com.sun.star.util.XURLTransformer;
import com.sun.star.wizards.common.FileAccess;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.NoValidPathException;
import com.sun.star.wizards.common.PropertyNames;

public class Desktop {
    public static XDesktop getDesktop(XMultiServiceFactory xMSF) {
        XInterface xInterface = null;
        XDesktop xDesktop = null;
        if (xMSF != null) {
            try {
                xInterface = (XInterface)xMSF.createInstance("com.sun.star.frame.Desktop");
                xDesktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)xInterface);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        } else {
            System.out.println("Can't create a desktop. null pointer !");
        }
        return xDesktop;
    }

    public static XFrame getActiveFrame(XMultiServiceFactory xMSF) {
        XDesktop xDesktop = Desktop.getDesktop(xMSF);
        XFramesSupplier xFrameSuppl = (XFramesSupplier)UnoRuntime.queryInterface(XFramesSupplier.class, (Object)xDesktop);
        return xFrameSuppl.getActiveFrame();
    }

    private static XDispatch getDispatcher(XFrame xFrame, String _stargetframe, URL oURL) {
        try {
            URL[] oURLArray = new URL[]{oURL};
            XDispatchProvider xDispatchProvider = (XDispatchProvider)UnoRuntime.queryInterface(XDispatchProvider.class, (Object)xFrame);
            return xDispatchProvider.queryDispatch(oURLArray[0], _stargetframe, 23);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    private static URL getDispatchURL(XMultiServiceFactory xMSF, String _sURL) throws com.sun.star.uno.Exception {
        Object oTransformer = xMSF.createInstance("com.sun.star.util.URLTransformer");
        XURLTransformer xTransformer = (XURLTransformer)UnoRuntime.queryInterface(XURLTransformer.class, (Object)oTransformer);
        URL[] oURL = new URL[]{new URL()};
        oURL[0].Complete = _sURL;
        xTransformer.parseStrict(oURL);
        return oURL[0];
    }

    private static void dispatchURL(XMultiServiceFactory xMSF, String sURL, XFrame xFrame, String _stargetframe) throws com.sun.star.uno.Exception {
        URL oURL = Desktop.getDispatchURL(xMSF, sURL);
        XDispatch xDispatch = Desktop.getDispatcher(xFrame, _stargetframe, oURL);
        Desktop.dispatchURL(xDispatch, oURL);
    }

    public static void dispatchURL(XMultiServiceFactory xMSF, String sURL, XFrame xFrame) throws com.sun.star.uno.Exception {
        Desktop.dispatchURL(xMSF, sURL, xFrame, PropertyNames.EMPTY_STRING);
    }

    private static void dispatchURL(XDispatch _xDispatch, URL oURL) {
        PropertyValue[] oArg = new PropertyValue[]{};
        _xDispatch.dispatch(oURL, oArg);
    }

    private static XMultiComponentFactory getMultiComponentFactory() throws com.sun.star.uno.Exception, java.lang.RuntimeException, Exception {
        XComponentContext xcomponentcontext = Bootstrap.createInitialComponentContext(null);
        return xcomponentcontext.getServiceManager();
    }

    public static XMultiServiceFactory connect(String connectStr) throws com.sun.star.uno.Exception, RuntimeException, Exception {
        XMultiComponentFactory componentFactory = Desktop.getMultiComponentFactory();
        Object xUrlResolver = componentFactory.createInstanceWithContext("com.sun.star.bridge.UnoUrlResolver", null);
        XUnoUrlResolver urlResolver = (XUnoUrlResolver)UnoRuntime.queryInterface(XUnoUrlResolver.class, (Object)xUrlResolver);
        return (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)urlResolver.resolve(connectStr));
    }

    public static String getIncrementSuffix(XNameAccess xElementContainer, String ElementName) {
        boolean bElementexists = true;
        int i = 1;
        String sIncSuffix = PropertyNames.EMPTY_STRING;
        String BaseName = ElementName;
        while (bElementexists) {
            bElementexists = xElementContainer.hasByName(ElementName);
            if (!bElementexists) continue;
            ElementName = BaseName + Integer.toString(++i);
        }
        if (i > 1) {
            sIncSuffix = Integer.toString(i);
        }
        return sIncSuffix;
    }

    private static String getIncrementSuffix(XHierarchicalNameAccess xElementContainer, String ElementName) {
        boolean bElementexists = true;
        int i = 1;
        String sIncSuffix = PropertyNames.EMPTY_STRING;
        String BaseName = ElementName;
        while (bElementexists) {
            bElementexists = xElementContainer.hasByHierarchicalName(ElementName);
            if (!bElementexists) continue;
            ElementName = BaseName + Integer.toString(++i);
        }
        if (i > 1) {
            sIncSuffix = Integer.toString(i);
        }
        return sIncSuffix;
    }

    private static int checkforfirstSpecialCharacter(XMultiServiceFactory _xMSF, String _sString, Locale _aLocale) {
        try {
            int nStartFlags = 1044495;
            Object ocharservice = _xMSF.createInstance("com.sun.star.i18n.CharacterClassification");
            XCharacterClassification xCharacterClassification = (XCharacterClassification)UnoRuntime.queryInterface(XCharacterClassification.class, (Object)ocharservice);
            ParseResult aResult = xCharacterClassification.parsePredefinedToken(4, _sString, 0, _aLocale, nStartFlags, PropertyNames.EMPTY_STRING, nStartFlags, PropertyNames.SPACE);
            return aResult.EndPos;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return -1;
        }
    }

    public static String removeSpecialCharacters(XMultiServiceFactory _xMSF, Locale _aLocale, String _sname) {
        String snewname = _sname;
        int i = 0;
        while (i < snewname.length()) {
            i = Desktop.checkforfirstSpecialCharacter(_xMSF, snewname, _aLocale);
            if (i >= snewname.length()) continue;
            String sspecialchar = snewname.substring(i, i + 1);
            snewname = JavaTools.replaceSubString(snewname, PropertyNames.EMPTY_STRING, sspecialchar);
        }
        return snewname;
    }

    public static String getUniqueName(XNameAccess xElementContainer, String sElementName) {
        String sIncSuffix = Desktop.getIncrementSuffix(xElementContainer, sElementName);
        return sElementName + sIncSuffix;
    }

    public static String getUniqueName(XHierarchicalNameAccess xElementContainer, String sElementName) {
        String sIncSuffix = Desktop.getIncrementSuffix(xElementContainer, sElementName);
        return sElementName + sIncSuffix;
    }

    public static String getUniqueName(String[] _slist, String _sElementName, String _sSuffixSeparator) {
        if (_slist == null || _slist.length == 0) {
            return _sElementName;
        }
        String scompname = _sElementName;
        int a = 2;
        while (true) {
            for (int i = 0; i < _slist.length; ++i) {
                if (JavaTools.FieldInList(_slist, scompname) != -1) continue;
                return scompname;
            }
            scompname = _sElementName + _sSuffixSeparator + a++;
        }
    }

    private static String getTemplatePath(XMultiServiceFactory _xMSF) {
        try {
            return FileAccess.getOfficePath(_xMSF, "Template", "share", "/wizard");
        }
        catch (NoValidPathException noValidPathException) {
            return PropertyNames.EMPTY_STRING;
        }
    }

    public static String getBitmapPath(XMultiServiceFactory _xMSF) {
        try {
            return FileAccess.combinePaths(_xMSF, Desktop.getTemplatePath(_xMSF), "/../wizard/bitmap");
        }
        catch (NoValidPathException noValidPathException) {
            return PropertyNames.EMPTY_STRING;
        }
    }
}

