/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.converter.xml.EmbeddedBinaryObject;
import org.openoffice.xmerge.converter.xml.EmbeddedObject;
import org.openoffice.xmerge.converter.xml.EmbeddedXMLObject;
import org.openoffice.xmerge.converter.xml.OfficeConstants;
import org.openoffice.xmerge.converter.xml.OfficeDocumentException;
import org.openoffice.xmerge.converter.xml.OfficeZip;
import org.openoffice.xmerge.util.Debug;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OfficeDocument
implements Document,
OfficeConstants {
    private static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private org.w3c.dom.Document contentDoc = null;
    private org.w3c.dom.Document metaDoc = null;
    private org.w3c.dom.Document settingsDoc = null;
    private org.w3c.dom.Document styleDoc = null;
    private org.w3c.dom.Document manifestDoc = null;
    private String documentName = null;
    private String fileName = null;
    private OfficeZip zip = null;
    private Map<String, EmbeddedObject> embeddedObjects = null;

    public OfficeDocument(String name) {
        this(name, true, false);
    }

    public OfficeDocument(String name, boolean namespaceAware, boolean validating) {
        factory.setValidating(validating);
        factory.setNamespaceAware(namespaceAware);
        this.documentName = this.trimDocumentName(name);
        this.fileName = this.documentName + this.getFileExtension();
    }

    private String trimDocumentName(String name) {
        String ext;
        String temp = name.toLowerCase();
        if (temp.endsWith(ext = this.getFileExtension())) {
            int nlen = name.length();
            int endIndex = nlen - ext.length();
            name = name.substring(0, endIndex);
        }
        return name;
    }

    public org.w3c.dom.Document getContentDOM() {
        return this.contentDoc;
    }

    public org.w3c.dom.Document getMetaDOM() {
        return this.metaDoc;
    }

    public org.w3c.dom.Document getSettingsDOM() {
        return this.settingsDoc;
    }

    public void setContentDOM(Node newDom) {
        this.contentDoc = (org.w3c.dom.Document)newDom;
    }

    public void setMetaDOM(Node newDom) {
        this.metaDoc = (org.w3c.dom.Document)newDom;
    }

    public void setSettingsDOM(Node newDom) {
        this.settingsDoc = (org.w3c.dom.Document)newDom;
    }

    public void setStyleDOM(Node newDom) {
        this.styleDoc = (org.w3c.dom.Document)newDom;
    }

    public org.w3c.dom.Document getStyleDOM() {
        return this.styleDoc;
    }

    @Override
    public String getName() {
        return this.documentName;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    protected abstract String getFileExtension();

    private Iterator<EmbeddedObject> getEmbeddedObjects() {
        if (this.embeddedObjects == null && this.manifestDoc != null) {
            this.embeddedObjects = new HashMap<String, EmbeddedObject>();
            NodeList nl = this.manifestDoc.getElementsByTagName("manifest:file-entry");
            int len = nl.getLength();
            for (int i = 0; i < len; ++i) {
                Node n = nl.item(i);
                NamedNodeMap attrs = n.getAttributes();
                String type = attrs.getNamedItem("manifest:media-type").getNodeValue();
                String path = attrs.getNamedItem("manifest:full-path").getNodeValue();
                if (type.startsWith("application/vnd.sun.xml")) {
                    if (path.equals("/")) continue;
                    String name = path.substring(0, path.length() - 1);
                    this.embeddedObjects.put(name, new EmbeddedXMLObject(name, type, this.zip));
                    continue;
                }
                if (type.equals("text/xml")) continue;
                this.embeddedObjects.put(path, new EmbeddedBinaryObject(path, type, this.zip));
            }
        }
        if (this.embeddedObjects == null) {
            return null;
        }
        return this.embeddedObjects.values().iterator();
    }

    @Override
    public void read(InputStream is) throws IOException {
        byte[] manifestBytes;
        byte[] settingsBytes;
        byte[] metaBytes;
        Debug.log(1, "reading Office file");
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new OfficeDocumentException(ex);
        }
        this.zip = new OfficeZip();
        this.zip.read(is);
        byte[] contentBytes = this.zip.getContentXMLBytes();
        if (contentBytes == null) {
            throw new OfficeDocumentException("Entry content.xml not found in file");
        }
        try {
            this.contentDoc = OfficeDocument.parse(builder, contentBytes);
        }
        catch (SAXException ex) {
            throw new OfficeDocumentException(ex);
        }
        byte[] styleBytes = this.zip.getStyleXMLBytes();
        if (styleBytes != null) {
            try {
                this.styleDoc = OfficeDocument.parse(builder, styleBytes);
            }
            catch (SAXException ex) {
                throw new OfficeDocumentException(ex);
            }
        }
        if ((metaBytes = this.zip.getMetaXMLBytes()) != null) {
            try {
                this.metaDoc = OfficeDocument.parse(builder, metaBytes);
            }
            catch (SAXException ex) {
                throw new OfficeDocumentException(ex);
            }
        }
        if ((settingsBytes = this.zip.getSettingsXMLBytes()) != null) {
            try {
                this.settingsDoc = OfficeDocument.parse(builder, settingsBytes);
            }
            catch (SAXException ex) {
                throw new OfficeDocumentException(ex);
            }
        }
        if ((manifestBytes = this.zip.getManifestXMLBytes()) != null) {
            try {
                this.manifestDoc = OfficeDocument.parse(builder, manifestBytes);
            }
            catch (SAXException ex) {
                throw new OfficeDocumentException(ex);
            }
        }
    }

    public void read(InputStream is, boolean isZip) throws IOException {
        Debug.log(1, "reading Office file");
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new OfficeDocumentException(ex);
        }
        if (isZip) {
            this.read(is);
        } else {
            try {
                Node tmpNode;
                Element rootElement;
                Reader r = OfficeDocument.secondHack(is);
                InputSource ins = new InputSource(r);
                org.w3c.dom.Document newDoc = builder.parse(ins);
                Element rootNode = rootElement = newDoc.getDocumentElement();
                this.contentDoc = this.createDOM("office:document-content");
                rootNode = rootElement = this.contentDoc.getDocumentElement();
                NodeList nodeList = newDoc.getElementsByTagName("office:font-decls");
                if (nodeList.getLength() > 0) {
                    tmpNode = this.contentDoc.importNode(nodeList.item(0), true);
                    rootNode.appendChild(tmpNode);
                }
                if ((nodeList = newDoc.getElementsByTagName("office:automatic-styles")).getLength() > 0) {
                    tmpNode = this.contentDoc.importNode(nodeList.item(0), true);
                    rootNode.appendChild(tmpNode);
                }
                if ((nodeList = newDoc.getElementsByTagName("office:body")).getLength() > 0) {
                    tmpNode = this.contentDoc.importNode(nodeList.item(0), true);
                    rootNode.appendChild(tmpNode);
                }
                this.styleDoc = this.createDOM("office:document-styles");
                rootNode = rootElement = this.styleDoc.getDocumentElement();
                nodeList = newDoc.getElementsByTagName("office:font-decls");
                if (nodeList.getLength() > 0) {
                    tmpNode = this.styleDoc.importNode(nodeList.item(0), true);
                    rootNode.appendChild(tmpNode);
                }
                if ((nodeList = newDoc.getElementsByTagName("office:styles")).getLength() > 0) {
                    tmpNode = this.styleDoc.importNode(nodeList.item(0), true);
                    rootNode.appendChild(tmpNode);
                }
                if ((nodeList = newDoc.getElementsByTagName("office:automatic-styles")).getLength() > 0) {
                    tmpNode = this.styleDoc.importNode(nodeList.item(0), true);
                    rootNode.appendChild(tmpNode);
                }
                if ((nodeList = newDoc.getElementsByTagName("office:master-styles")).getLength() > 0) {
                    tmpNode = this.styleDoc.importNode(nodeList.item(0), true);
                    rootNode.appendChild(tmpNode);
                }
                this.settingsDoc = this.createDOM("office:document-settings");
                rootNode = rootElement = this.settingsDoc.getDocumentElement();
                nodeList = newDoc.getElementsByTagName("office:settings");
                if (nodeList.getLength() > 0) {
                    tmpNode = this.settingsDoc.importNode(nodeList.item(0), true);
                    rootNode.appendChild(tmpNode);
                }
                this.metaDoc = this.createDOM("office:document-meta");
                rootNode = rootElement = this.metaDoc.getDocumentElement();
                nodeList = newDoc.getElementsByTagName("office:meta");
                if (nodeList.getLength() > 0) {
                    tmpNode = this.metaDoc.importNode(nodeList.item(0), true);
                    rootNode.appendChild(tmpNode);
                }
            }
            catch (SAXException ex) {
                throw new OfficeDocumentException(ex);
            }
        }
    }

    static org.w3c.dom.Document parse(DocumentBuilder builder, byte[] bytes) throws SAXException, IOException {
        org.w3c.dom.Document doc = null;
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        Reader r = OfficeDocument.hack(is);
        InputSource ins = new InputSource(r);
        doc = builder.parse(ins);
        return doc;
    }

    protected abstract String getDocumentMimeType();

    @Override
    public void write(OutputStream os) throws IOException {
        if (this.zip == null) {
            this.zip = new OfficeZip();
        }
        this.initManifestDOM();
        Element manifestRoot = this.manifestDoc.getDocumentElement();
        Iterator<EmbeddedObject> embObjs = this.getEmbeddedObjects();
        if (embObjs != null) {
            while (embObjs.hasNext()) {
                EmbeddedObject obj = embObjs.next();
                obj.writeManifestData(this.manifestDoc);
                obj.write(this.zip);
            }
        }
        Element domEntry = this.manifestDoc.createElement("manifest:file-entry");
        domEntry.setAttribute("manifest:full-path", "Pictures/");
        domEntry.setAttribute("manifest:media-type", "");
        manifestRoot.appendChild(domEntry);
        this.zip.setContentXMLBytes(OfficeDocument.docToBytes(this.contentDoc));
        domEntry = this.manifestDoc.createElement("manifest:file-entry");
        domEntry.setAttribute("manifest:full-path", "content.xml");
        domEntry.setAttribute("manifest:media-type", "text/xml");
        manifestRoot.appendChild(domEntry);
        if (this.styleDoc != null) {
            this.zip.setStyleXMLBytes(OfficeDocument.docToBytes(this.styleDoc));
            domEntry = this.manifestDoc.createElement("manifest:file-entry");
            domEntry.setAttribute("manifest:full-path", "styles.xml");
            domEntry.setAttribute("manifest:media-type", "text/xml");
            manifestRoot.appendChild(domEntry);
        }
        if (this.metaDoc != null) {
            this.zip.setMetaXMLBytes(OfficeDocument.docToBytes(this.metaDoc));
            domEntry = this.manifestDoc.createElement("manifest:file-entry");
            domEntry.setAttribute("manifest:full-path", "meta.xml");
            domEntry.setAttribute("manifest:media-type", "text/xml");
            manifestRoot.appendChild(domEntry);
        }
        if (this.settingsDoc != null) {
            this.zip.setSettingsXMLBytes(OfficeDocument.docToBytes(this.settingsDoc));
            domEntry = this.manifestDoc.createElement("manifest:file-entry");
            domEntry.setAttribute("manifest:full-path", "settings.xml");
            domEntry.setAttribute("manifest:media-type", "text/xml");
            manifestRoot.appendChild(domEntry);
        }
        this.zip.setManifestXMLBytes(OfficeDocument.docToBytes(this.manifestDoc));
        this.zip.write(os);
    }

    public void write(OutputStream os, boolean isZip) throws IOException {
        if (isZip) {
            this.write(os);
        } else {
            try {
                Node tmpNode;
                NodeList nodeList;
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                DOMImplementation domImpl = builder.getDOMImplementation();
                domImpl.createDocumentType("office:document", "-//OpenOffice.org//DTD OfficeDocument 1.0//EN", null);
                org.w3c.dom.Document newDoc = domImpl.createDocument("http://openoffice.org/2000/office", "office:document", null);
                Element rootElement = newDoc.getDocumentElement();
                rootElement.setAttribute("xmlns:office", "http://openoffice.org/2000/office");
                rootElement.setAttribute("xmlns:style", "http://openoffice.org/2000/style");
                rootElement.setAttribute("xmlns:text", "http://openoffice.org/2000/text");
                rootElement.setAttribute("xmlns:table", "http://openoffice.org/2000/table");
                rootElement.setAttribute("xmlns:draw", "http://openoffice.org/2000/drawing");
                rootElement.setAttribute("xmlns:fo", "http://www.w3.org/1999/XSL/Format");
                rootElement.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
                rootElement.setAttribute("xmlns:dc", "http://purl.org/dc/elements/1.1/");
                rootElement.setAttribute("xmlns:meta", "http://openoffice.org/2000/meta");
                rootElement.setAttribute("xmlns:number", "http://openoffice.org/2000/datastyle");
                rootElement.setAttribute("xmlns:svg", "http://www.w3.org/2000/svg");
                rootElement.setAttribute("xmlns:chart", "http://openoffice.org/2000/chart");
                rootElement.setAttribute("xmlns:dr3d", "http://openoffice.org/2000/dr3d");
                rootElement.setAttribute("xmlns:math", "http://www.w3.org/1998/Math/MathML");
                rootElement.setAttribute("xmlns:form", "http://openoffice.org/2000/form");
                rootElement.setAttribute("xmlns:script", "http://openoffice.org/2000/script");
                rootElement.setAttribute("xmlns:config", "http://openoffice.org/2001/config");
                if (this.getDocumentMimeType().equals("application/vnd.sun.xml.calc")) {
                    rootElement.setAttribute("office:class", "spreadsheet");
                } else if (this.getDocumentMimeType().equals("application/vnd.sun.xml.writer")) {
                    rootElement.setAttribute("office:class", "text");
                }
                rootElement.setAttribute("office:version", "1.0");
                Element rootNode = rootElement;
                if (this.metaDoc != null && (nodeList = this.metaDoc.getElementsByTagName("office:meta")).getLength() > 0) {
                    tmpNode = newDoc.importNode(nodeList.item(0), true);
                    rootNode.appendChild(tmpNode);
                }
                if (this.styleDoc != null && (nodeList = this.styleDoc.getElementsByTagName("office:styles")).getLength() > 0) {
                    tmpNode = newDoc.importNode(nodeList.item(0), true);
                    rootNode.appendChild(tmpNode);
                }
                if (this.settingsDoc != null && (nodeList = this.settingsDoc.getElementsByTagName("office:settings")).getLength() > 0) {
                    tmpNode = newDoc.importNode(nodeList.item(0), true);
                    rootNode.appendChild(tmpNode);
                }
                if (this.contentDoc != null) {
                    nodeList = this.contentDoc.getElementsByTagName("office:automatic-styles");
                    if (nodeList.getLength() > 0) {
                        tmpNode = newDoc.importNode(nodeList.item(0), true);
                        rootNode.appendChild(tmpNode);
                    }
                    if ((nodeList = this.contentDoc.getElementsByTagName("office:body")).getLength() > 0) {
                        tmpNode = newDoc.importNode(nodeList.item(0), true);
                        rootNode.appendChild(tmpNode);
                    }
                }
                byte[] contentBytes = OfficeDocument.docToBytes(newDoc);
                os.write(contentBytes);
            }
            catch (Exception exc) {
                System.out.println("\nException in OfficeDocument.write():" + exc);
            }
        }
    }

    static byte[] docToBytes(org.w3c.dom.Document doc) throws IOException {
        ByteArrayOutputStream baos;
        block8: {
            baos = new ByteArrayOutputStream();
            String domImpl = doc.getClass().getName();
            try {
                if (domImpl.equals("com.sun.xml.tree.XmlDocument")) {
                    Debug.log(1, "Using JAXP");
                    Class<?> jaxpDoc = Class.forName("com.sun.xml.tree.XmlDocument");
                    Method meth = jaxpDoc.getMethod("write", Class.forName("java.io.OutputStream"));
                    meth.invoke((Object)doc, baos);
                    break block8;
                }
                if (domImpl.equals("org.apache.crimson.tree.XmlDocument")) {
                    Debug.log(1, "Using Crimson");
                    Class<?> crimsonDoc = Class.forName("org.apache.crimson.tree.XmlDocument");
                    Method meth = crimsonDoc.getMethod("write", Class.forName("java.io.OutputStream"));
                    meth.invoke((Object)doc, baos);
                    break block8;
                }
                if (domImpl.equals("org.apache.xerces.dom.DocumentImpl") || domImpl.equals("org.apache.xerces.dom.DeferredDocumentImpl")) {
                    Debug.log(1, "Using Xerces");
                    Class<?> xercesSer = Class.forName("org.apache.xml.serialize.XMLSerializer");
                    Constructor<?> con = xercesSer.getConstructor(Class.forName("java.io.OutputStream"), Class.forName("org.apache.xml.serialize.OutputFormat"));
                    Method meth = xercesSer.getMethod("serialize", Class.forName("org.w3c.dom.Document"));
                    Object serializer = con.newInstance(baos, null);
                    meth.invoke(serializer, doc);
                    break block8;
                }
                if (domImpl.equals("gnu.xml.dom.DomDocument")) {
                    Debug.log(1, "Using GNU");
                    Class<?> gnuSer = Class.forName("gnu.xml.dom.ls.DomLSSerializer");
                    Method meth = gnuSer.getMethod("serialize", Class.forName("org.w3c.dom.Node"), Class.forName("java.io.OutputStream"));
                    Object serializer = gnuSer.newInstance();
                    meth.invoke(serializer, doc, baos);
                    break block8;
                }
                try {
                    DOMSource domSource = new DOMSource(doc);
                    StringWriter writer = new StringWriter();
                    StreamResult result = new StreamResult(writer);
                    TransformerFactory tf = TransformerFactory.newInstance();
                    Transformer transformer = tf.newTransformer();
                    transformer.transform(domSource, result);
                    return writer.toString().getBytes();
                }
                catch (Exception e) {
                    IOException newEx = new IOException("No appropriate API (JAXP/Xerces) to serialize XML document: " + domImpl);
                    newEx.initCause(e);
                    throw newEx;
                }
            }
            catch (Exception e) {
                IOException newEx = new IOException(e.getMessage());
                newEx.initCause(e);
                throw newEx;
            }
        }
        byte[] bytes = baos.toByteArray();
        return bytes;
    }

    public final void initContentDOM() throws IOException {
        this.contentDoc = this.createDOM("office:document-content");
        Element root = this.contentDoc.getDocumentElement();
        Element child = this.contentDoc.createElement("office:font-decls");
        root.appendChild(child);
        child = this.contentDoc.createElement("office:automatic-styles");
        root.appendChild(child);
        child = this.contentDoc.createElement("office:body");
        root.appendChild(child);
    }

    public final void initSettingsDOM() throws IOException {
        this.settingsDoc = this.createSettingsDOM("office:document-settings");
        Element root = this.settingsDoc.getDocumentElement();
        Element child = this.settingsDoc.createElement("office:settings");
        root.appendChild(child);
    }

    public final void initStyleDOM() throws IOException {
        this.styleDoc = this.createDOM("office:document-styles");
    }

    private final org.w3c.dom.Document createSettingsDOM(String rootName) throws IOException {
        org.w3c.dom.Document doc = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.newDocument();
        }
        catch (ParserConfigurationException ex) {
            throw new OfficeDocumentException(ex);
        }
        Element root = doc.createElement(rootName);
        doc.appendChild(root);
        root.setAttribute("xmlns:office", "http://openoffice.org/2000/office");
        root.setAttribute("xmlns:xlink", "http://openoffice.org/1999/xlink");
        root.setAttribute("xmlns:config", "http://openoffice.org/2001/config");
        root.setAttribute("office:version", "1.0");
        return doc;
    }

    private final org.w3c.dom.Document createDOM(String rootName) throws IOException {
        org.w3c.dom.Document doc = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.newDocument();
        }
        catch (ParserConfigurationException ex) {
            throw new OfficeDocumentException(ex);
        }
        Element root = doc.createElement(rootName);
        doc.appendChild(root);
        root.setAttribute("xmlns:office", "http://openoffice.org/2000/office");
        root.setAttribute("xmlns:style", "http://openoffice.org/2000/style");
        root.setAttribute("xmlns:text", "http://openoffice.org/2000/text");
        root.setAttribute("xmlns:table", "http://openoffice.org/2000/table");
        root.setAttribute("xmlns:draw", "http://openoffice.org/2000/drawing");
        root.setAttribute("xmlns:fo", "http://www.w3.org/1999/XSL/Format");
        root.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        root.setAttribute("xmlns:number", "http://openoffice.org/2000/datastyle");
        root.setAttribute("xmlns:svg", "http://www.w3.org/2000/svg");
        root.setAttribute("xmlns:chart", "http://openoffice.org/2000/chart");
        root.setAttribute("xmlns:dr3d", "http://openoffice.org/2000/dr3d");
        root.setAttribute("xmlns:math", "http://www.w3.org/1998/Math/MathML");
        root.setAttribute("xmlns:form", "http://openoffice.org/2000/form");
        root.setAttribute("xmlns:script", "http://openoffice.org/2000/script");
        root.setAttribute("office:class", this.getOfficeClassAttribute());
        root.setAttribute("office:version", "1.0");
        return doc;
    }

    protected abstract String getOfficeClassAttribute();

    private static Reader hack(InputStream is) throws IOException {
        String str;
        BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        StringBuffer buffer = new StringBuffer();
        while ((str = br.readLine()) != null) {
            int sIndex = str.indexOf("<!DOCTYPE");
            if (sIndex > -1) {
                buffer.append(str.substring(0, sIndex));
                int eIndex = str.indexOf(62, sIndex + 8);
                if (eIndex > -1) {
                    buffer.append(str.substring(eIndex + 1, str.length()));
                    buffer.append("\n");
                    continue;
                }
                boolean bOK = false;
                while ((str = br.readLine()) != null) {
                    eIndex = str.indexOf(62);
                    if (eIndex <= -1) continue;
                    buffer.append(str.substring(eIndex + 1));
                    buffer.append("\n");
                    bOK = true;
                    break;
                }
                if (bOK) continue;
                throw new IOException("Invalid XML");
            }
            buffer.append(str);
            buffer.append("\n");
        }
        StringReader r = new StringReader(buffer.toString());
        return r;
    }

    private static Reader secondHack(InputStream is) throws IOException {
        int n;
        BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        char[] charArray = new char[4096];
        StringBuffer sBuf = new StringBuffer();
        while ((n = br.read(charArray, 0, charArray.length)) > 0) {
            sBuf.append(charArray, 0, n);
        }
        int sIndex = sBuf.lastIndexOf("</office:document>");
        sBuf.delete(sIndex, sBuf.length());
        sBuf.append("</office:document>");
        StringReader r = new StringReader(sBuf.toString());
        return r;
    }

    private void initManifestDOM() throws IOException {
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation domImpl = builder.getDOMImplementation();
            DocumentType docType = domImpl.createDocumentType("manifest:manifest", "-//OpenOffice.org//DTD Manifest 1.0//EN", "Manifest.dtd");
            this.manifestDoc = domImpl.createDocument("manifest", "manifest:manifest", docType);
        }
        catch (ParserConfigurationException ex) {
            throw new OfficeDocumentException(ex);
        }
        Element manifestRoot = this.manifestDoc.getDocumentElement();
        manifestRoot.setAttribute("xmlns:manifest", "http://openoffice.org/2001/manifest");
        Element docRoot = this.manifestDoc.createElement("manifest:file-entry");
        docRoot.setAttribute("manifest:full-path", "/");
        docRoot.setAttribute("manifest:media-type", this.getDocumentMimeType());
        manifestRoot.appendChild(docRoot);
    }
}

