/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.beans.FeatureDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.explorer.propertysheet.PropertySetModel;
import org.openide.explorer.propertysheet.PropertySetModelEvent;
import org.openide.explorer.propertysheet.PropertySetModelListener;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

final class SheetTableModel
implements TableModel,
PropertySetModelListener {
    private transient List<TableModelListener> tableModelListenerList;
    PropertySetModel model = null;

    public SheetTableModel() {
    }

    public SheetTableModel(PropertySetModel propertySetModel) {
        this.setPropertySetModel(propertySetModel);
    }

    public void setPropertySetModel(PropertySetModel propertySetModel) {
        if (this.model == propertySetModel) {
            return;
        }
        if (this.model != null) {
            this.model.removePropertySetModelListener(this);
        }
        this.model = propertySetModel;
        if (this.model == null) {
            throw new IllegalArgumentException("Model cannot be null");
        }
        propertySetModel.addPropertySetModelListener(this);
        this.model = propertySetModel;
        this.fireTableChanged(new TableModelEvent(this));
    }

    public PropertySetModel getPropertySetModel() {
        return this.model;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Object.class;
            }
        }
        throw new IllegalArgumentException("Column " + n + " does not exist.");
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return NbBundle.getMessage(SheetTableModel.class, (String)"COLUMN_NAMES");
        }
        return NbBundle.getMessage(SheetTableModel.class, (String)"COLUMN_VALUES");
    }

    @Override
    public int getRowCount() {
        if (this.model == null) {
            return 0;
        }
        return this.model.getCount();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        FeatureDescriptor featureDescriptor = n == -1 ? null : this.model.getFeatureDescriptor(n);
        return featureDescriptor;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n2 == 0) {
            return false;
        }
        if (n2 == 1) {
            FeatureDescriptor featureDescriptor = this.model.getFeatureDescriptor(n);
            if (featureDescriptor instanceof Node.PropertySet) {
                return false;
            }
            return ((Node.Property)featureDescriptor).canWrite();
        }
        throw new IllegalArgumentException("Illegal row/column: " + Integer.toString(n) + Integer.toString(n2));
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 0) {
            throw new IllegalArgumentException("Cannot set property names.");
        }
        try {
            FeatureDescriptor featureDescriptor = this.model.getFeatureDescriptor(n);
            if (!(featureDescriptor instanceof Node.Property)) {
                throw new IllegalArgumentException("Index " + Integer.toString(n) + Integer.toString(n2) + " does not represent a property. ");
            }
            Node.Property property = (Node.Property)featureDescriptor;
            property.setValue(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.getLogger(SheetTableModel.class.getName()).log(Level.WARNING, null, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Logger.getLogger(SheetTableModel.class.getName()).log(Level.WARNING, null, invocationTargetException);
        }
    }

    public String getDescriptionFor(int n, int n2) {
        if (n == -1 || n2 == -1) {
            return "";
        }
        FeatureDescriptor featureDescriptor = this.model.getFeatureDescriptor(n);
        Node.Property property = featureDescriptor instanceof Node.Property ? (Node.Property)featureDescriptor : null;
        String string = null;
        if (property != null) {
            try {
                if (n2 == 0) {
                    string = property.getShortDescription();
                } else {
                    PropertyEditor propertyEditor = PropUtils.getPropertyEditor(property);
                    if (propertyEditor != null) {
                        string = propertyEditor.getAsText();
                    } else if (property.getValueType() == String.class) {
                        String string2 = (String)property.getValue();
                        if (string2 != null && string2.length() > 2048) {
                            return "";
                        }
                        return string2;
                    }
                }
            }
            catch (Exception exception) {
                string = n2 == 0 ? property.getShortDescription() : exception.toString();
            }
        } else {
            Node.PropertySet propertySet = (Node.PropertySet)featureDescriptor;
            string = propertySet.getShortDescription();
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    public synchronized void addTableModelListener(TableModelListener tableModelListener) {
        if (this.tableModelListenerList == null) {
            this.tableModelListenerList = new ArrayList<TableModelListener>();
        }
        this.tableModelListenerList.add(tableModelListener);
    }

    @Override
    public synchronized void removeTableModelListener(TableModelListener tableModelListener) {
        if (this.tableModelListenerList != null) {
            this.tableModelListenerList.remove(tableModelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireTableChanged(TableModelEvent tableModelEvent) {
        List list;
        SheetTableModel sheetTableModel = this;
        synchronized (sheetTableModel) {
            if (this.tableModelListenerList == null) {
                return;
            }
            list = (List)((ArrayList)this.tableModelListenerList).clone();
        }
        for (int i = 0; i < list.size(); ++i) {
            ((TableModelListener)list.get(i)).tableChanged(tableModelEvent);
        }
    }

    @Override
    public void boundedChange(PropertySetModelEvent propertySetModelEvent) {
        TableModelEvent tableModelEvent = new TableModelEvent(this, propertySetModelEvent.start, propertySetModelEvent.end, -1, propertySetModelEvent.type == 0 ? 1 : -1);
        this.fireTableChanged(tableModelEvent);
    }

    @Override
    public void wholesaleChange(PropertySetModelEvent propertySetModelEvent) {
        this.fireTableChanged(new TableModelEvent(this));
    }

    @Override
    public void pendingChange(PropertySetModelEvent propertySetModelEvent) {
    }
}

