/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.api;

import java.util.HashMap;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.lib.profiler.common.GlobalProfilingSettings;
import org.netbeans.modules.profiler.api.Bundle;
import org.openide.util.NbPreferences;

public final class ProfilerIDESettings
implements GlobalProfilingSettings {
    public static final String DO_NOT_SHOW_ATTACH_SETTINGS = "dns-attach-settings";
    public static final String DO_NOT_SHOW_JDK_DIALOG = "dns-jdk-dialog";
    public static final String DO_NOT_SHOW_PID_WINDOWS = "dns-pid-windows4";
    public static final int CPU_ENTIRE_APP = 0;
    public static final int CPU_PART_APP = 1;
    public static final int CPU_STARTUP = 2;
    public static final int CPU_PROFILING_POINTS = 3;
    public static final int OOME_DETECTION_NONE = 0;
    public static final int OOME_DETECTION_TEMPDIR = 1;
    public static final int OOME_DETECTION_PROJECTDIR = 2;
    public static final int OOME_DETECTION_CUSTOMDIR = 3;
    public static final int OPEN_ALWAYS = 1;
    public static final int OPEN_MONITORING = 2;
    public static final int OPEN_NEVER = 3;
    private static ProfilerIDESettings defaultInstance = new ProfilerIDESettings();
    private Map<String, String> dnsaMap;
    private final String AUTO_OPEN_SNAPSHOT_KEY_55 = "autoOpenSnapshot";
    private final String AUTO_SAVE_SNAPSHOT_KEY_55 = "autoSaveSnapshot";
    private final String CALIBRATION_PORT_NO_KEY_55 = "calibrationPortNo";
    private final String CPU_TASK_KEY_55 = "cpuTaskDefault";
    private final String LIVE_CPU_KEY_55 = "displayLiveResultsCPU";
    private final String LIVE_FRAGMENT_KEY_55 = "displayLiveResultsFragment";
    private final String LIVE_MEMORY_KEY_55 = "displayLiveResultsMemory";
    private final String MEMORY_TASK_ALLOCATIONS_KEY_55 = "memoryTaskAllocationsDefault";
    private final String PLATFORM_NAME_KEY_55 = "javaPlatformForProfiling";
    private final String PORT_NO_KEY_55 = "portNo";
    private final String RECORD_STACK_TRACES_KEY_55 = "recordStackTracesDefault";
    private final String THREADS_MONITORING_KEY_55 = "threadsMonitoringDefault";
    private final String TO_BEHAVIOR_KEY_55 = "telemetryOverviewBehavior";
    private final String TRACK_EVERY_KEY_55 = "trackEveryDefault";
    private final String TV_BEHAVIOR_KEY_55 = "threadsViewBehavior";
    private final String AUTO_OPEN_SNAPSHOT_KEY = "AUTO_OPEN_SNAPSHOT";
    private final String AUTO_SAVE_SNAPSHOT_KEY = "AUTO_SAVE_SNAPSHOT";
    private final String CALIBRATION_PORT_NO_KEY = "CALIBRATION_PORT_NO";
    private final String CPU_TASK_KEY = "CPU_TASK";
    private final String CUSTOM_HEAPDUMP_PATH_KEY = "CUSTOM_HEAPDUMP_PATH";
    private final String DNSA_SETTINGS_KEY = "DNSA_SETTINGS";
    private final String HEAPWALKER_ANALYSIS_ENABLED_KEY = "HEAPWALKER_ANALYSIS_ENABLED";
    private final String INSTR_FILTER_KEY = "INSTR_FILTER";
    private final String LIVE_CPU_KEY = "LIVE_CPU";
    private final String LIVE_FRAGMENT_KEY = "LIVE_FRAGMENT";
    private final String LIVE_MEMORY_KEY = "LIVE_MEMORY";
    private final String MEMORY_TASK_ALLOCATIONS_KEY = "MEMORY_TASK_ALLOCATIONS";
    private final String OOME_DETECTION_MODE_KEY = "OOME_DETECTION_MODE";
    private final String PLATFORM_NAME_KEY = "PLATFORM_NAME";
    private final String PORT_NO_KEY = "PORT_NO";
    private final String PPOINTS_DEPENDENCIES_INCLUDE_KEY = "PPOINTS_DEPENDENCIES_INCLUDE";
    private final String RECORD_STACK_TRACES_KEY = "RECORD_STACK_TRACES";
    private final String THREADS_MONITORING_KEY = "THREADS_MONITORING";
    private final String TO_BEHAVIOR_KEY = "TO_BEHAVIOR";
    private final String TRACK_EVERY_KEY = "TRACK_EVERY";
    private final String TV_BEHAVIOR_KEY = "TV_BEHAVIOR";
    private final String LCV_BEHAVIOR_KEY = "LCV_BEHAVIOR";
    private final String CUSTOM_HEAPDUMP_PATH_DEFAULT = "";
    private final String PLATFORM_NAME_DEFAULT = "PLATFORM_NAME_DEFAULT";
    private final String INSTR_FILTER_DEFAULT = "###";
    private final boolean AUTO_OPEN_SNAPSHOT_DEFAULT = true;
    private final boolean AUTO_SAVE_SNAPSHOT_DEFAULT = false;
    private final boolean HEAPWALKER_ANALYSIS_ENABLED_DEFAULT = false;
    private final boolean LIVE_CPU_DEFAULT = false;
    private final boolean LIVE_FRAGMENT_DEFAULT = false;
    private final boolean LIVE_MEMORY_DEFAULT = false;
    private final boolean MEMORY_TASK_ALLOCATIONS_DEFAULT = true;
    private final boolean PPOINTS_DEPENDENCIES_INCLUDE_DEFAULT = true;
    private final boolean RECORD_STACK_TRACES_DEFAULT = false;
    private final boolean THREADS_MONITORING_DEFAULT = true;
    private final int CALIBRATION_PORT_NO_DEFAULT = -1;
    private final int CPU_TASK_DEFAULT = 0;
    private final int OOME_DETECTION_MODE_DEFAULT = 2;
    private final int PORT_NO_DEFAULT = 5140;
    private final int TO_BEHAVIOR_DEFAULT = 2;
    private final int TRACK_EVERY_DEFAULT = 10;
    private final int TV_BEHAVIOR_DEFAULT = 1;
    private final int LCV_BEHAVIOR_DEFAULT = 1;

    public static ProfilerIDESettings getInstance() {
        return defaultInstance;
    }

    private ProfilerIDESettings() {
        try {
            if (this.contains55Settings()) {
                this.convert55Settings();
            } else if (this.contains701Settings()) {
                this.convert701Settings();
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    private boolean contains701Settings() throws BackingStoreException {
        return this.get701Preferences().keys().length > 0;
    }

    private void convert701Settings() throws BackingStoreException {
        Preferences preferences = this.getPreferences();
        Preferences preferences2 = this.get701Preferences();
        for (String string : preferences2.keys()) {
            String string2 = preferences2.get(string, null);
            assert (string2 != null);
            preferences.put(string, string2);
        }
        preferences2.clear();
    }

    private Preferences get701Preferences() {
        return NbPreferences.root().node("org/netbeans/modules/profiler");
    }

    private boolean contains55Settings() {
        return this.getPreferences().getInt("portNo", Integer.MIN_VALUE) != Integer.MIN_VALUE;
    }

    private void convert55Settings() throws BackingStoreException {
        String[] stringArray;
        Preferences preferences = this.getPreferences();
        for (String string : stringArray = preferences.keys()) {
            if ("autoOpenSnapshot".equals(string)) {
                ProfilerIDESettings.convertBoolean("autoOpenSnapshot", "AUTO_OPEN_SNAPSHOT", true, preferences);
                continue;
            }
            if ("autoSaveSnapshot".equals(string)) {
                ProfilerIDESettings.convertBoolean("autoSaveSnapshot", "AUTO_SAVE_SNAPSHOT", false, preferences);
                continue;
            }
            if ("calibrationPortNo".equals(string)) {
                ProfilerIDESettings.convertInteger("calibrationPortNo", "CALIBRATION_PORT_NO", -1, preferences);
                continue;
            }
            if ("cpuTaskDefault".equals(string)) {
                ProfilerIDESettings.convertInteger("cpuTaskDefault", "CPU_TASK", 0, preferences);
                continue;
            }
            if ("displayLiveResultsCPU".equals(string)) {
                ProfilerIDESettings.convertBoolean("displayLiveResultsCPU", "LIVE_CPU", false, preferences);
                continue;
            }
            if ("displayLiveResultsFragment".equals(string)) {
                ProfilerIDESettings.convertBoolean("displayLiveResultsFragment", "LIVE_FRAGMENT", false, preferences);
                continue;
            }
            if ("displayLiveResultsMemory".equals(string)) {
                ProfilerIDESettings.convertBoolean("displayLiveResultsMemory", "LIVE_MEMORY", false, preferences);
                continue;
            }
            if ("memoryTaskAllocationsDefault".equals(string)) {
                ProfilerIDESettings.convertBoolean("memoryTaskAllocationsDefault", "MEMORY_TASK_ALLOCATIONS", true, preferences);
                continue;
            }
            if ("javaPlatformForProfiling".equals(string)) {
                ProfilerIDESettings.convertString("javaPlatformForProfiling", "PLATFORM_NAME", "PLATFORM_NAME_DEFAULT", preferences);
                continue;
            }
            if ("portNo".equals(string)) {
                ProfilerIDESettings.convertInteger("portNo", "PORT_NO", 5140, preferences);
                continue;
            }
            if ("recordStackTracesDefault".equals(string)) {
                ProfilerIDESettings.convertBoolean("recordStackTracesDefault", "RECORD_STACK_TRACES", false, preferences);
                continue;
            }
            if ("threadsMonitoringDefault".equals(string)) {
                ProfilerIDESettings.convertBoolean("threadsMonitoringDefault", "THREADS_MONITORING", true, preferences);
                continue;
            }
            if ("telemetryOverviewBehavior".equals(string)) {
                ProfilerIDESettings.convertInteger("telemetryOverviewBehavior", "TO_BEHAVIOR", 2, preferences);
                continue;
            }
            if ("trackEveryDefault".equals(string)) {
                ProfilerIDESettings.convertInteger("trackEveryDefault", "TRACK_EVERY", 10, preferences);
                continue;
            }
            if (!"threadsViewBehavior".equals(string)) continue;
            ProfilerIDESettings.convertInteger("threadsViewBehavior", "TV_BEHAVIOR", 1, preferences);
        }
    }

    private static void convertBoolean(String string, String string2, boolean bl, Preferences preferences) {
        boolean bl2 = preferences.getBoolean(string, bl);
        preferences.remove(string);
        preferences.putBoolean(string2, bl2);
    }

    private static void convertInteger(String string, String string2, int n, Preferences preferences) {
        int n2 = preferences.getInt(string, n);
        preferences.remove(string);
        preferences.putInt(string2, n2);
    }

    private static void convertString(String string, String string2, String string3, Preferences preferences) {
        String string4 = preferences.get(string, string3);
        preferences.remove(string);
        preferences.put(string2, string4);
    }

    public void setAutoOpenSnapshot(boolean bl) {
        this.getPreferences().putBoolean("AUTO_OPEN_SNAPSHOT", bl);
    }

    public boolean getAutoOpenSnapshot() {
        return this.getPreferences().getBoolean("AUTO_OPEN_SNAPSHOT", true);
    }

    public void setAutoSaveSnapshot(boolean bl) {
        this.getPreferences().putBoolean("AUTO_SAVE_SNAPSHOT", bl);
    }

    public boolean getAutoSaveSnapshot() {
        return this.getPreferences().getBoolean("AUTO_SAVE_SNAPSHOT", false);
    }

    public void setCalibrationPortNo(int n) {
        this.getPreferences().putInt("CALIBRATION_PORT_NO", n);
    }

    public int getCalibrationPortNo() {
        int n = this.getPreferences().getInt("CALIBRATION_PORT_NO", -1);
        if (n == -1) {
            return this.getPortNo() + 1;
        }
        return n;
    }

    public void setCpuTaskDefault(int n) {
        this.getPreferences().putInt("CPU_TASK", n);
    }

    public int getCpuTaskDefault() {
        return this.getPreferences().getInt("CPU_TASK", 0);
    }

    public void setCustomHeapdumpPath(String string) {
        this.getPreferences().put("CUSTOM_HEAPDUMP_PATH", string);
    }

    public String getCustomHeapdumpPath() {
        return this.getPreferences().get("CUSTOM_HEAPDUMP_PATH", "");
    }

    public void setDisplayLiveResultsCPU(boolean bl) {
        this.getPreferences().putBoolean("LIVE_CPU", bl);
    }

    public boolean getDisplayLiveResultsCPU() {
        return this.getPreferences().getBoolean("LIVE_CPU", false);
    }

    public void setDisplayLiveResultsFragment(boolean bl) {
        this.getPreferences().putBoolean("LIVE_FRAGMENT", bl);
    }

    public boolean getDisplayLiveResultsFragment() {
        return this.getPreferences().getBoolean("LIVE_FRAGMENT", false);
    }

    public void setDisplayLiveResultsMemory(boolean bl) {
        this.getPreferences().putBoolean("LIVE_MEMORY", bl);
    }

    public boolean getDisplayLiveResultsMemory() {
        return this.getPreferences().getBoolean("LIVE_MEMORY", false);
    }

    public void setDoNotShowAgain(String string, String string2) {
        if (string2 != null) {
            this.getDNSAMap().put(string, string2);
        } else {
            this.getDNSAMap().remove(string);
        }
        this.storeDNSAMap();
    }

    public String getDoNotShowAgain(String string) {
        return this.getDNSAMap().get(string);
    }

    public void setHeapWalkerAnalysisEnabled(boolean bl) {
        this.getPreferences().putBoolean("HEAPWALKER_ANALYSIS_ENABLED", bl);
    }

    public boolean getHeapWalkerAnalysisEnabled() {
        return this.getPreferences().getBoolean("HEAPWALKER_ANALYSIS_ENABLED", false);
    }

    public void setIncludeProfilingPointsDependencies(boolean bl) {
        this.getPreferences().putBoolean("PPOINTS_DEPENDENCIES_INCLUDE", bl);
    }

    public boolean getIncludeProfilingPointsDependencies() {
        return this.getPreferences().getBoolean("PPOINTS_DEPENDENCIES_INCLUDE", true);
    }

    public void setInstrFilterDefault(String string) {
        this.getPreferences().put("INSTR_FILTER", string);
    }

    public String getInstrFilterDefault() {
        return this.getPreferences().get("INSTR_FILTER", "###");
    }

    public void setJavaPlatformForProfiling(String string) {
        this.getPreferences().put("PLATFORM_NAME", string == null ? "PLATFORM_NAME_DEFAULT" : string);
    }

    public String getJavaPlatformForProfiling() {
        String string = this.getPreferences().get("PLATFORM_NAME", "PLATFORM_NAME_DEFAULT");
        return "PLATFORM_NAME_DEFAULT".equals(string) ? null : string;
    }

    public void setMemoryTaskAllocationsDefault(boolean bl) {
        this.getPreferences().putBoolean("MEMORY_TASK_ALLOCATIONS", bl);
    }

    public boolean getMemoryTaskAllocationsDefault() {
        return this.getPreferences().getBoolean("MEMORY_TASK_ALLOCATIONS", true);
    }

    public boolean isOOMDetectionEnabled() {
        return this.getOOMDetectionMode() != 0;
    }

    public void setOOMDetectionMode(int n) {
        this.getPreferences().putInt("OOME_DETECTION_MODE", n);
    }

    public int getOOMDetectionMode() {
        return this.getPreferences().getInt("OOME_DETECTION_MODE", 2);
    }

    public void setPortNo(int n) {
        this.getPreferences().putInt("PORT_NO", n);
    }

    public int getPortNo() {
        return this.getPreferences().getInt("PORT_NO", 5140);
    }

    public void setRecordStackTracesDefault(boolean bl) {
        this.getPreferences().putBoolean("RECORD_STACK_TRACES", bl);
    }

    public boolean getRecordStackTracesDefault() {
        return this.getPreferences().getBoolean("RECORD_STACK_TRACES", false);
    }

    public void setTelemetryOverviewBehavior(int n) {
        this.getPreferences().putInt("TO_BEHAVIOR", n);
    }

    public int getTelemetryOverviewBehavior() {
        return this.getPreferences().getInt("TO_BEHAVIOR", 2);
    }

    public void setThreadsMonitoringDefault(boolean bl) {
        this.getPreferences().putBoolean("THREADS_MONITORING", bl);
    }

    public boolean getThreadsMonitoringDefault() {
        return this.getPreferences().getBoolean("THREADS_MONITORING", true);
    }

    public void setThreadsViewBehavior(int n) {
        this.getPreferences().putInt("TV_BEHAVIOR", n);
    }

    public int getThreadsViewBehavior() {
        return this.getPreferences().getInt("TV_BEHAVIOR", 1);
    }

    public void setLockContentionViewBehavior(int n) {
        this.getPreferences().putInt("LCV_BEHAVIOR", n);
    }

    public int getLockContentionViewBehavior() {
        return this.getPreferences().getInt("LCV_BEHAVIOR", 1);
    }

    public void setTrackEveryDefault(int n) {
        this.getPreferences().putInt("TRACK_EVERY", n);
    }

    public int getTrackEveryDefault() {
        return this.getPreferences().getInt("TRACK_EVERY", 10);
    }

    public void clearDoNotShowAgainMap() {
        this.getDNSAMap().clear();
        this.storeDNSAMap();
    }

    public String displayName() {
        return Bundle.ProfilerIDESettings_Name();
    }

    private Map<String, String> getDNSAMap() {
        if (this.dnsaMap != null) {
            return this.dnsaMap;
        }
        this.dnsaMap = new HashMap<String, String>();
        String string = this.getPreferences().get("DNSA_SETTINGS", null);
        if (string != null) {
            String[] stringArray = string.split(":");
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split(",");
                assert (stringArray2.length == 2);
                this.dnsaMap.put(stringArray2[0], stringArray2[1]);
            }
        }
        return this.dnsaMap;
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(ProfilerIDESettings.class);
    }

    private void storeDNSAMap() {
        StringBuilder stringBuilder = new StringBuilder();
        Object object = this.getDNSAMap().entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry<String, String> entry = object.next();
            stringBuilder.append((Object)entry.getKey()).append(",").append((Object)entry.getValue());
            if (!object.hasNext()) continue;
            stringBuilder.append(":");
        }
        object = stringBuilder.toString();
        if (((String)object).length() > 0) {
            this.getPreferences().put("DNSA_SETTINGS", (String)object);
        } else {
            this.getPreferences().remove("DNSA_SETTINGS");
        }
    }
}

