/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.run;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.internal.artifacts.dependencies.DefaultExternalModuleDependency;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.reflect.DirectInstantiator;
import org.gradle.play.internal.run.DefaultVersionedPlayRunAdapter;
import org.gradle.scala.internal.reflect.ScalaMethod;
import org.gradle.scala.internal.reflect.ScalaReflectionUtil;
import org.gradle.util.CollectionUtils;
import org.gradle.util.VersionNumber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayRunAdapterV23X
extends DefaultVersionedPlayRunAdapter {
    protected static final String RUN_SUPPORT_PLAY_MODULE = "run-support";
    private static final VersionNumber MINIMUM_PLAY_VERSION_WITH_RUN_SUPPORT = VersionNumber.parse((String)"2.3.7");

    @Override
    protected Class<?> getBuildLinkClass(ClassLoader classLoader) throws ClassNotFoundException {
        return classLoader.loadClass("play.core.BuildLink");
    }

    @Override
    protected Class<?> getBuildDocHandlerClass(ClassLoader classLoader) throws ClassNotFoundException {
        return classLoader.loadClass("play.core.BuildDocHandler");
    }

    @Override
    protected Class<?> getDocHandlerFactoryClass(ClassLoader docsClassLoader) throws ClassNotFoundException {
        return docsClassLoader.loadClass("play.docs.BuildDocHandlerFactory");
    }

    @Override
    protected ClassLoader createAssetsClassLoader(File assetsJar, Iterable<File> assetsDirs, ClassLoader classLoader) {
        Class<?> assetsClassLoaderClass = this.loadClass(classLoader, "play.runsupport.AssetsClassLoader");
        final Class<?> tuple2Class = this.loadClass(classLoader, "scala.Tuple2");
        List tuples = CollectionUtils.collect(assetsDirs, (Transformer)new Transformer<Object, File>(){

            public Object transform(File file) {
                return DirectInstantiator.instantiate((Class)tuple2Class, (Object[])new Object[]{"public", file});
            }
        });
        ScalaMethod listToScalaSeqMethod = ScalaReflectionUtil.scalaMethod(classLoader, "scala.collection.convert.WrapAsScala", "asScalaBuffer", List.class);
        Object scalaTuples = listToScalaSeqMethod.invoke(tuples);
        return (ClassLoader)Cast.uncheckedCast((Object)DirectInstantiator.instantiate(assetsClassLoaderClass, (Object[])new Object[]{classLoader, scalaTuples}));
    }

    private Class<?> loadClass(ClassLoader classLoader, String className) {
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    @Override
    public Iterable<Dependency> getRunsupportClasspathDependencies(String playVersion, String scalaCompatibilityVersion) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        String runsupportPlayVersion = playVersion;
        boolean transitive = true;
        if (VersionNumber.parse((String)playVersion).compareTo(MINIMUM_PLAY_VERSION_WITH_RUN_SUPPORT) < 0) {
            runsupportPlayVersion = "2.3.7";
            transitive = false;
        }
        DefaultExternalModuleDependency runSupportDependency = new DefaultExternalModuleDependency("com.typesafe.play", "run-support_" + scalaCompatibilityVersion, runsupportPlayVersion);
        runSupportDependency.setTransitive(transitive);
        listBuilder.add((Object)runSupportDependency);
        String name = scalaCompatibilityVersion.equals("2.10") ? "io" : "io_" + scalaCompatibilityVersion;
        DefaultExternalModuleDependency dependency = new DefaultExternalModuleDependency("org.scala-sbt", name, this.getIOSupportDependencyVersion(), "runtime");
        dependency.setTransitive(false);
        listBuilder.add((Object)dependency);
        return listBuilder.build();
    }

    protected String getIOSupportDependencyVersion() {
        return "0.13.6";
    }
}

