/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.plugins;

import java.util.Collection;
import java.util.Iterator;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.model.Each;
import org.gradle.model.Finalize;
import org.gradle.model.Model;
import org.gradle.model.Mutate;
import org.gradle.model.RuleSource;
import org.gradle.platform.base.BinaryContainer;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentType;
import org.gradle.platform.base.TypeBuilder;
import org.gradle.platform.base.binary.BaseBinarySpec;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.platform.base.plugins.ComponentBasePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class BinaryBasePlugin
implements Plugin<Project> {
    public void apply(Project target) {
        target.getPluginManager().apply(ComponentBasePlugin.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Rules
    extends RuleSource {
        Rules() {
        }

        @Model
        void binaries(BinaryContainer binaries) {
        }

        @ComponentType
        void registerBaseBinarySpec(TypeBuilder<BinarySpec> builder) {
            builder.defaultImplementation(BaseBinarySpec.class);
            builder.internalView(BinarySpecInternal.class);
        }

        @Mutate
        void copyBinaryTasksToTaskContainer(TaskContainer tasks, BinaryContainer binaries) {
            Iterator i$ = binaries.iterator();
            while (i$.hasNext()) {
                BinarySpec binary = (BinarySpec)i$.next();
                tasks.addAll((Collection)((Object)binary.getTasks()));
                Task buildTask = binary.getBuildTask();
                if (buildTask == null) continue;
                tasks.add((Object)buildTask);
            }
        }

        @Finalize
        public void defineBuildLifecycleTask(@Each BinarySpecInternal binary, ITaskFactory taskFactory) {
            if (binary.isLegacyBinary()) {
                return;
            }
            TaskInternal binaryLifecycleTask = (TaskInternal)taskFactory.create(binary.getProjectScopedName(), DefaultTask.class);
            binaryLifecycleTask.setGroup("build");
            binaryLifecycleTask.setDescription(String.format("Assembles %s.", binary));
            binary.setBuildTask((Task)binaryLifecycleTask);
        }

        @Finalize
        void addSourceSetsOwnedByBinariesToTheirInputs(@Each BinarySpecInternal binary) {
            if (binary.isLegacyBinary()) {
                return;
            }
            binary.getInputs().addAll(binary.getSources().values());
        }
    }
}

