/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import org.gradle.api.internal.changedetection.state.FileSnapshot;
import org.gradle.api.internal.changedetection.state.IncrementalFileSnapshot;
import org.gradle.internal.hash.HashValue;

class FileHashSnapshot
implements IncrementalFileSnapshot,
FileSnapshot {
    final HashValue hash;
    final transient long lastModified;

    public FileHashSnapshot(HashValue hash) {
        this.hash = hash;
        this.lastModified = 0L;
    }

    public FileHashSnapshot(HashValue hash, long lastModified) {
        this.hash = hash;
        this.lastModified = lastModified;
    }

    public boolean isContentUpToDate(IncrementalFileSnapshot snapshot) {
        if (!(snapshot instanceof FileHashSnapshot)) {
            return false;
        }
        FileHashSnapshot other = (FileHashSnapshot)snapshot;
        return this.hash.equals((Object)other.hash);
    }

    public boolean isContentAndMetadataUpToDate(IncrementalFileSnapshot snapshot) {
        if (!(snapshot instanceof FileHashSnapshot)) {
            return false;
        }
        FileHashSnapshot other = (FileHashSnapshot)snapshot;
        return this.lastModified == other.lastModified && this.hash.equals((Object)other.hash);
    }

    public String toString() {
        return this.hash.asHexString();
    }

    public HashValue getHash() {
        return this.hash;
    }
}

