/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.advanced;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.data.preferences.ListListSetting;
import org.openstreetmap.josm.gui.preferences.advanced.AbstractTableListEditor;
import org.openstreetmap.josm.gui.preferences.advanced.PrefEntry;
import org.openstreetmap.josm.tools.I18n;

public class ListListEditor
extends AbstractTableListEditor<List<String>> {
    private final transient List<List<String>> data;

    public ListListEditor(JComponent jComponent, PrefEntry prefEntry, ListListSetting listListSetting) {
        super((Component)jComponent, I18n.tr("Change list of lists setting", new Object[0]), prefEntry);
        List list = (List)listListSetting.getValue();
        this.data = new ArrayList<List<String>>();
        if (list != null) {
            for (List list2 : list) {
                this.data.add(new ArrayList(list2));
            }
        }
    }

    @Override
    public List<List<String>> getData() {
        return this.data;
    }

    @Override
    protected final JPanel build() {
        this.table.setTableHeader(null);
        return super.build();
    }

    @Override
    protected AbstractTableListEditor.AbstractEntryListModel newEntryListModel() {
        return new EntryListModel();
    }

    @Override
    protected AbstractTableModel newTableModel() {
        return new ListTableModel();
    }

    private class ListTableModel
    extends AbstractTableModel {
        private ListTableModel() {
        }

        private List<String> data() {
            return ListListEditor.this.entryIdx == null ? Collections.emptyList() : (List)ListListEditor.this.data.get(ListListEditor.this.entryIdx);
        }

        private int size() {
            return this.data().size();
        }

        @Override
        public int getRowCount() {
            return ListListEditor.this.entryIdx == null ? 0 : this.size() + 1;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.size() == n ? "" : this.data().get(n);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            String string = (String)object;
            if (n == this.size()) {
                this.data().add(string);
                this.fireTableRowsInserted(n + 1, n + 1);
            } else {
                this.data().set(n, string);
                this.fireTableCellUpdated(n, n2);
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }
    }

    private class EntryListModel
    extends AbstractTableListEditor.AbstractEntryListModel {
        private EntryListModel() {
        }

        @Override
        public String getElementAt(int n) {
            return n + 1 + ": " + ListListEditor.this.data.get(n);
        }

        @Override
        public int getSize() {
            return ListListEditor.this.data.size();
        }

        @Override
        public void add() {
            ListListEditor.this.data.add(new ArrayList());
            this.fireIntervalAdded(this, this.getSize() - 1, this.getSize() - 1);
        }

        @Override
        public void remove(int n) {
            ListListEditor.this.data.remove(n);
            this.fireIntervalRemoved(this, n, n);
        }
    }
}

