/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util.slicedMap;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import kotlin.jvm.functions.Function3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.util.slicedMap.AbstractWritableSlice;
import org.jetbrains.kotlin.util.slicedMap.MutableSlicedMap;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.RewritePolicy;
import org.jetbrains.kotlin.util.slicedMap.SlicedMap;
import org.jetbrains.kotlin.util.slicedMap.SlicedMapImpl;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;
import org.jetbrains.kotlin.utils.Printer;

public class TrackingSlicedMap
extends SlicedMapImpl {
    private final Map<ReadOnlySlice<?, ?>, SliceWithStackTrace<?, ?>> sliceTranslationMap = Maps.newHashMap();
    private final boolean trackWithStackTraces;

    public TrackingSlicedMap(boolean trackWithStackTraces) {
        this.trackWithStackTraces = trackWithStackTraces;
    }

    private <K, V> SliceWithStackTrace<K, V> wrapSlice(ReadOnlySlice<K, V> slice) {
        SliceWithStackTrace<Object, Object> translated = this.sliceTranslationMap.get(slice);
        if (translated == null) {
            translated = new SliceWithStackTrace(slice);
            this.sliceTranslationMap.put(slice, translated);
        }
        return translated;
    }

    @Override
    public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
        return (V)((TrackableValue)super.get(this.wrapSlice(slice), key)).value;
    }

    @Override
    public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
        return super.getKeys(this.wrapSlice(slice));
    }

    @Override
    public void forEach(final @NotNull Function3<WritableSlice, Object, Object, Void> f) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/kotlin/util/slicedMap/TrackingSlicedMap", "forEach"));
        }
        super.forEach(new Function3<WritableSlice, Object, Object, Void>(){

            @Override
            public Void invoke(WritableSlice slice, Object key, Object value) {
                f.invoke(((SliceWithStackTrace)slice).getWritableDelegate(), key, ((TrackableValue)value).value);
                return null;
            }
        });
    }

    @Override
    public <K, V> void put(WritableSlice<K, V> slice, K key, V value) {
        super.put(this.wrapSlice(slice), key, new TrackableValue(value, this.trackWithStackTraces));
    }

    private class SliceWithStackTrace<K, V>
    extends AbstractWritableSlice<K, TrackableValue<V>>
    implements WritableSlice<K, TrackableValue<V>> {
        private final ReadOnlySlice<K, V> delegate;

        private SliceWithStackTrace(@NotNull ReadOnlySlice<K, V> delegate2) {
            if (delegate2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/kotlin/util/slicedMap/TrackingSlicedMap$SliceWithStackTrace", "<init>"));
            }
            super(delegate2.toString());
            this.delegate = delegate2;
        }

        @Override
        public TrackableValue<V> computeValue(SlicedMap map2, K key, TrackableValue<V> value, boolean valueNotFound) {
            return new TrackableValue(this.delegate.computeValue(map2, key, value == null ? null : ((TrackableValue)value).value, valueNotFound), TrackingSlicedMap.this.trackWithStackTraces);
        }

        @Override
        public ReadOnlySlice<K, TrackableValue<V>> makeRawValueVersion() {
            return TrackingSlicedMap.this.wrapSlice(this.delegate.makeRawValueVersion());
        }

        private WritableSlice<K, V> getWritableDelegate() {
            return (WritableSlice)this.delegate;
        }

        @Override
        public boolean isCollective() {
            return this.getWritableDelegate().isCollective();
        }

        @Override
        public RewritePolicy getRewritePolicy() {
            return this.getWritableDelegate().getRewritePolicy();
        }

        @Override
        public void afterPut(MutableSlicedMap map2, K key, TrackableValue<V> value) {
            this.getWritableDelegate().afterPut(map2, key, ((TrackableValue)value).value);
        }

        @Override
        public boolean check(K key, TrackableValue<V> value) {
            return this.getWritableDelegate().check(key, ((TrackableValue)value).value);
        }
    }

    private static class TrackableValue<V> {
        private static final StackTraceElement[] EMPTY_STACK_TRACE = new StackTraceElement[0];
        private final V value;
        private final StackTraceElement[] stackTrace;
        private final String threadName;

        private TrackableValue(V value, boolean storeStack) {
            this.value = value;
            this.stackTrace = storeStack ? Thread.currentThread().getStackTrace() : EMPTY_STACK_TRACE;
            this.threadName = Thread.currentThread().getName();
        }

        private Appendable printStackTrace(Appendable appendable) {
            StackTraceElement[] trace;
            Printer s = new Printer(appendable);
            s.println(this.value);
            s.println("Thread: " + this.threadName);
            s.println("Written at ");
            for (StackTraceElement aTrace : trace = this.stackTrace) {
                s.println("\tat " + aTrace);
            }
            s.println("---------");
            return appendable;
        }

        public String toString() {
            return this.printStackTrace(new StringBuilder()).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TrackableValue other = (TrackableValue)o;
            return !(this.value != null ? !this.value.equals(other.value) : other.value != null);
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }
    }
}

