/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.randomize;

import org.encog.mathutil.LinearCongruentialGenerator;
import org.encog.mathutil.randomize.BasicRandomizer;
import org.encog.neural.networks.BasicNetwork;

public class ConsistentRandomizer
extends BasicRandomizer {
    private final LinearCongruentialGenerator rand;
    private final double min;
    private final double max;
    private final int seed;

    public ConsistentRandomizer(double min, double max) {
        this(min, max, 1000);
    }

    public ConsistentRandomizer(double min, double max, int seed) {
        this.max = max;
        this.min = min;
        this.seed = seed;
        this.rand = new LinearCongruentialGenerator(seed);
    }

    @Override
    public double randomize(double d) {
        return this.rand.range(this.min, this.max);
    }

    public void randomize(BasicNetwork network) {
        this.rand.setSeed(this.seed);
        super.randomize(network);
    }
}

