/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.bayesian.query.enumerate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.encog.ml.bayesian.BayesianError;
import org.encog.ml.bayesian.BayesianEvent;
import org.encog.ml.bayesian.BayesianNetwork;
import org.encog.ml.bayesian.EventType;
import org.encog.ml.bayesian.query.BasicQuery;
import org.encog.ml.bayesian.query.sample.EventState;
import org.encog.ml.bayesian.table.TableLine;
import org.encog.util.Format;

public class EnumerationQuery
extends BasicQuery
implements Serializable {
    private List<EventState> enumerationEvents = new ArrayList<EventState>();
    private double probability;

    public EnumerationQuery(BayesianNetwork theNetwork) {
        super(theNetwork);
    }

    public EnumerationQuery() {
    }

    public void resetEnumeration(boolean includeEvidence, boolean includeOutcome) {
        this.enumerationEvents.clear();
        for (EventState state : this.getEvents().values()) {
            if (state.getEventType() == EventType.Hidden) {
                this.enumerationEvents.add(state);
                state.setValue(0);
                continue;
            }
            if (includeEvidence && state.getEventType() == EventType.Evidence) {
                this.enumerationEvents.add(state);
                state.setValue(0);
                continue;
            }
            if (includeOutcome && state.getEventType() == EventType.Outcome) {
                this.enumerationEvents.add(state);
                state.setValue(0);
                continue;
            }
            state.setValue(state.getCompareValue());
        }
    }

    public boolean forward() {
        int currentIndex = 0;
        boolean done = false;
        boolean eof = false;
        if (this.enumerationEvents.size() == 0) {
            done = true;
            eof = true;
        }
        while (!done) {
            EventState state = this.enumerationEvents.get(currentIndex);
            int v = state.getValue();
            if (++v < state.getEvent().getChoices().size()) {
                state.setValue(v);
                done = true;
                break;
            }
            state.setValue(0);
            if (++currentIndex < this.enumerationEvents.size()) continue;
            done = true;
            eof = true;
        }
        return !eof;
    }

    private int[] obtainArgs(BayesianEvent event) {
        int[] result = new int[event.getParents().size()];
        int index = 0;
        for (BayesianEvent parentEvent : event.getParents()) {
            EventState state = this.getEventState(parentEvent);
            result[index++] = state.getValue();
        }
        return result;
    }

    private double calculateProbability(EventState state) {
        int[] args = this.obtainArgs(state.getEvent());
        for (TableLine line : state.getEvent().getTable().getLines()) {
            if (!line.compareArgs(args) || !((double)Math.abs(line.getResult() - state.getValue()) < 1.0E-13)) continue;
            return line.getProbability();
        }
        throw new BayesianError("Could not determine the probability for " + state.toString());
    }

    private double performEnumeration() {
        double result = 0.0;
        do {
            boolean first = true;
            double prob = 0.0;
            for (EventState state : this.getEvents().values()) {
                if (first) {
                    prob = this.calculateProbability(state);
                    first = false;
                    continue;
                }
                prob *= this.calculateProbability(state);
            }
            result += prob;
        } while (this.forward());
        return result;
    }

    @Override
    public void execute() {
        this.locateEventTypes();
        this.resetEnumeration(false, false);
        double numerator = this.performEnumeration();
        this.resetEnumeration(false, true);
        double denominator = this.performEnumeration();
        this.probability = numerator / denominator;
    }

    @Override
    public double getProbability() {
        return this.probability;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[SamplingQuery: ");
        result.append(this.getProblem());
        result.append("=");
        result.append(Format.formatPercent(this.getProbability()));
        result.append("]");
        return result.toString();
    }

    public static boolean roll(List<BayesianEvent> enumerationEvents, int[] args) {
        int currentIndex = 0;
        boolean done = false;
        boolean eof = false;
        if (enumerationEvents.size() == 0) {
            done = true;
            eof = true;
        }
        while (!done) {
            BayesianEvent event = enumerationEvents.get(currentIndex);
            int v = args[currentIndex];
            if (++v < event.getChoices().size()) {
                args[currentIndex] = v;
                done = true;
                break;
            }
            args[currentIndex] = 0;
            if (++currentIndex < args.length) continue;
            done = true;
            eof = true;
        }
        return !eof;
    }

    @Override
    public EnumerationQuery clone() {
        return new EnumerationQuery(this.getNetwork());
    }
}

