/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.factory.method;

import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import org.encog.EncogError;
import org.encog.ml.MLMethod;
import org.encog.ml.factory.parse.ArchitectureParse;
import org.encog.ml.prg.EncogProgramContext;
import org.encog.ml.prg.extension.StandardExtensions;
import org.encog.ml.prg.generator.RampedHalfAndHalf;
import org.encog.ml.prg.train.PrgPopulation;
import org.encog.util.ParamsHolder;

public class EPLFactory {
    public MLMethod create(String architecture, int input, int output) {
        if (input <= 0) {
            throw new EncogError("Must have at least one input for EPL.");
        }
        if (output <= 0) {
            throw new EncogError("Must have at least one output for EPL.");
        }
        Map<String, String> args = ArchitectureParse.parseParams(architecture);
        ParamsHolder holder = new ParamsHolder(args);
        int populationSize = holder.getInt("population", false, 1000);
        String variables = holder.getString("vars", false, "x");
        String funct = holder.getString("funct", false, null);
        EncogProgramContext context = new EncogProgramContext();
        StringTokenizer tok = new StringTokenizer(variables, ",");
        while (tok.hasMoreElements()) {
            context.defineVariable(tok.nextToken());
        }
        if ("numeric".equalsIgnoreCase(funct)) {
            StandardExtensions.createNumericOperators(context);
        }
        PrgPopulation pop = new PrgPopulation(context, populationSize);
        if (context.getFunctions().size() > 0) {
            new RampedHalfAndHalf(context, 2, 6).generate(new Random(), pop);
        }
        return pop;
    }
}

