/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transport.wagon;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.StreamingWagon;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.proxy.ProxyInfoProvider;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.repository.RepositoryPermissions;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.AuthenticationContext;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.transport.GetTask;
import org.eclipse.aether.spi.connector.transport.PeekTask;
import org.eclipse.aether.spi.connector.transport.PutTask;
import org.eclipse.aether.spi.connector.transport.TransportTask;
import org.eclipse.aether.spi.connector.transport.Transporter;
import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.transfer.NoTransporterException;
import org.eclipse.aether.transport.wagon.WagonCancelledException;
import org.eclipse.aether.transport.wagon.WagonConfigurator;
import org.eclipse.aether.transport.wagon.WagonProvider;
import org.eclipse.aether.transport.wagon.WagonTransferListener;
import org.eclipse.aether.util.ConfigUtils;

final class WagonTransporter
implements Transporter {
    private static final String CONFIG_PROP_CONFIG = "aether.connector.wagon.config";
    private static final String CONFIG_PROP_FILE_MODE = "aether.connector.perms.fileMode";
    private static final String CONFIG_PROP_DIR_MODE = "aether.connector.perms.dirMode";
    private static final String CONFIG_PROP_GROUP = "aether.connector.perms.group";
    private final Logger logger;
    private final RemoteRepository repository;
    private final RepositorySystemSession session;
    private final AuthenticationContext repoAuthContext;
    private final AuthenticationContext proxyAuthContext;
    private final WagonProvider wagonProvider;
    private final WagonConfigurator wagonConfigurator;
    private final String wagonHint;
    private final Repository wagonRepo;
    private final AuthenticationInfo wagonAuth;
    private final ProxyInfoProvider wagonProxy;
    private final Properties headers;
    private final Queue<Wagon> wagons = new ConcurrentLinkedQueue<Wagon>();
    private final AtomicBoolean closed = new AtomicBoolean();

    public WagonTransporter(WagonProvider wagonProvider, WagonConfigurator wagonConfigurator, RemoteRepository repository, RepositorySystemSession session, Logger logger) throws NoTransporterException {
        this.logger = logger;
        this.wagonProvider = wagonProvider;
        this.wagonConfigurator = wagonConfigurator;
        this.repository = repository;
        this.session = session;
        this.wagonRepo = new Repository(repository.getId(), repository.getUrl());
        this.wagonRepo.setPermissions(WagonTransporter.getPermissions(repository.getId(), session));
        this.wagonHint = this.wagonRepo.getProtocol().toLowerCase(Locale.ENGLISH);
        if (this.wagonHint == null || this.wagonHint.length() <= 0) {
            throw new NoTransporterException(repository);
        }
        try {
            this.wagons.add(this.lookupWagon());
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new NoTransporterException(repository, e.getMessage(), (Throwable)e);
        }
        this.repoAuthContext = AuthenticationContext.forRepository((RepositorySystemSession)session, (RemoteRepository)repository);
        this.proxyAuthContext = AuthenticationContext.forProxy((RepositorySystemSession)session, (RemoteRepository)repository);
        this.wagonAuth = this.getAuthenticationInfo(repository, this.repoAuthContext);
        this.wagonProxy = this.getProxy(repository, this.proxyAuthContext);
        this.headers = new Properties();
        this.headers.put("User-Agent", ConfigUtils.getString((RepositorySystemSession)session, (String)"Aether", (String[])new String[]{"aether.connector.userAgent"}));
        Map headers = ConfigUtils.getMap((RepositorySystemSession)session, null, (String[])new String[]{"aether.connector.http.headers." + repository.getId(), "aether.connector.http.headers"});
        if (headers != null) {
            this.headers.putAll((Map<?, ?>)headers);
        }
    }

    private static RepositoryPermissions getPermissions(String repoId, RepositorySystemSession session) {
        String group;
        String dirMode;
        RepositoryPermissions result = null;
        RepositoryPermissions perms = new RepositoryPermissions();
        String suffix = '.' + repoId;
        String fileMode = ConfigUtils.getString((RepositorySystemSession)session, (String)null, (String[])new String[]{CONFIG_PROP_FILE_MODE + suffix});
        if (fileMode != null) {
            perms.setFileMode(fileMode);
            result = perms;
        }
        if ((dirMode = ConfigUtils.getString((RepositorySystemSession)session, (String)null, (String[])new String[]{CONFIG_PROP_DIR_MODE + suffix})) != null) {
            perms.setDirectoryMode(dirMode);
            result = perms;
        }
        if ((group = ConfigUtils.getString((RepositorySystemSession)session, (String)null, (String[])new String[]{CONFIG_PROP_GROUP + suffix})) != null) {
            perms.setGroup(group);
            result = perms;
        }
        return result;
    }

    private AuthenticationInfo getAuthenticationInfo(RemoteRepository repository, final AuthenticationContext authContext) {
        AuthenticationInfo auth = null;
        if (authContext != null) {
            auth = new AuthenticationInfo(){

                public String getUserName() {
                    return authContext.get("username");
                }

                public String getPassword() {
                    return authContext.get("password");
                }

                public String getPrivateKey() {
                    return authContext.get("privateKey.path");
                }

                public String getPassphrase() {
                    return authContext.get("privateKey.passphrase");
                }
            };
        }
        return auth;
    }

    private ProxyInfoProvider getProxy(RemoteRepository repository, final AuthenticationContext authContext) {
        ProxyInfoProvider proxy = null;
        Proxy p = repository.getProxy();
        if (p != null) {
            final ProxyInfo prox = authContext != null ? new ProxyInfo(){

                public String getUserName() {
                    return authContext.get("username");
                }

                public String getPassword() {
                    return authContext.get("password");
                }

                public String getNtlmDomain() {
                    return authContext.get("ntlm.domain");
                }

                public String getNtlmHost() {
                    return authContext.get("ntlm.workstation");
                }
            } : new ProxyInfo();
            prox.setType(p.getType());
            prox.setHost(p.getHost());
            prox.setPort(p.getPort());
            proxy = new ProxyInfoProvider(){

                public ProxyInfo getProxyInfo(String protocol) {
                    return prox;
                }
            };
        }
        return proxy;
    }

    private Wagon lookupWagon() throws Exception {
        return this.wagonProvider.lookup(this.wagonHint);
    }

    private void releaseWagon(Wagon wagon) {
        this.wagonProvider.release(wagon);
    }

    private void connectWagon(Wagon wagon) throws Exception {
        if (!this.headers.isEmpty()) {
            try {
                Method setHttpHeaders = wagon.getClass().getMethod("setHttpHeaders", Properties.class);
                setHttpHeaders.invoke((Object)wagon, this.headers);
            }
            catch (NoSuchMethodException e) {
            }
            catch (Exception e) {
                this.logger.debug("Could not set user agent for wagon " + wagon.getClass().getName() + ": " + e);
            }
        }
        int connectTimeout = ConfigUtils.getInteger((RepositorySystemSession)this.session, (int)10000, (String[])new String[]{"aether.connector.connectTimeout"});
        int requestTimeout = ConfigUtils.getInteger((RepositorySystemSession)this.session, (int)1800000, (String[])new String[]{"aether.connector.requestTimeout"});
        wagon.setTimeout(Math.max(Math.max(connectTimeout, requestTimeout), 0));
        wagon.setInteractive(ConfigUtils.getBoolean((RepositorySystemSession)this.session, (boolean)false, (String[])new String[]{"aether.interactive"}));
        Object configuration = ConfigUtils.getObject((RepositorySystemSession)this.session, null, (String[])new String[]{"aether.connector.wagon.config." + this.repository.getId()});
        if (configuration != null && this.wagonConfigurator != null) {
            try {
                this.wagonConfigurator.configure(wagon, configuration);
            }
            catch (Exception e) {
                String msg = "Could not apply configuration for " + this.repository.getId() + " to wagon " + wagon.getClass().getName() + ":" + e.getMessage();
                if (this.logger.isDebugEnabled()) {
                    this.logger.warn(msg, (Throwable)e);
                }
                this.logger.warn(msg);
            }
        }
        wagon.connect(this.wagonRepo, this.wagonAuth, this.wagonProxy);
    }

    private void disconnectWagon(Wagon wagon) {
        try {
            if (wagon != null) {
                wagon.disconnect();
            }
        }
        catch (Exception e) {
            this.logger.debug("Could not disconnect wagon " + wagon, (Throwable)e);
        }
    }

    private Wagon pollWagon() throws Exception {
        Wagon wagon = this.wagons.poll();
        if (wagon == null) {
            try {
                wagon = this.lookupWagon();
                this.connectWagon(wagon);
            }
            catch (Exception e) {
                this.releaseWagon(wagon);
                throw e;
            }
        }
        if (wagon.getRepository() == null) {
            try {
                this.connectWagon(wagon);
            }
            catch (Exception e) {
                this.wagons.add(wagon);
                throw e;
            }
        }
        return wagon;
    }

    public int classify(Throwable error) {
        if (error instanceof ResourceDoesNotExistException) {
            return 1;
        }
        return 0;
    }

    public void peek(PeekTask task) throws Exception {
        this.execute((TransportTask)task, new PeekTaskRunner(task));
    }

    public void get(GetTask task) throws Exception {
        this.execute((TransportTask)task, new GetTaskRunner(task));
    }

    public void put(PutTask task) throws Exception {
        this.execute((TransportTask)task, new PutTaskRunner(task));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(TransportTask task, TaskRunner runner) throws Exception {
        if (this.closed.get()) {
            throw new IllegalStateException("transporter closed, cannot execute task " + task);
        }
        try {
            WagonTransferListener listener = new WagonTransferListener(task.getListener());
            Wagon wagon = this.pollWagon();
            try {
                wagon.addTransferListener((TransferListener)listener);
                runner.run(wagon);
            }
            finally {
                wagon.removeTransferListener((TransferListener)listener);
                this.wagons.add(wagon);
            }
        }
        catch (Exception e) {
            throw WagonCancelledException.unwrap(e);
        }
    }

    private static File newTempFile() throws IOException {
        return File.createTempFile("wagon-" + UUID.randomUUID().toString().replace("-", ""), ".tmp");
    }

    private void delTempFile(File path) {
        if (path != null && !path.delete() && path.exists()) {
            this.logger.debug("Could not delete temorary file " + path);
        }
    }

    private static void copy(OutputStream os, InputStream is) throws IOException {
        byte[] buffer = new byte[32768];
        int read = is.read(buffer);
        while (read >= 0) {
            os.write(buffer, 0, read);
            read = is.read(buffer);
        }
    }

    private static void close(Closeable file) {
        if (file != null) {
            try {
                file.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            AuthenticationContext.close((AuthenticationContext)this.repoAuthContext);
            AuthenticationContext.close((AuthenticationContext)this.proxyAuthContext);
            Wagon wagon = this.wagons.poll();
            while (wagon != null) {
                this.disconnectWagon(wagon);
                this.releaseWagon(wagon);
                wagon = this.wagons.poll();
            }
        }
    }

    private class PutTaskRunner
    implements TaskRunner {
        private final PutTask task;

        public PutTaskRunner(PutTask task) {
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(Wagon wagon) throws Exception {
            String dst = this.task.getLocation().toString();
            File file = this.task.getDataFile();
            if (file == null && wagon instanceof StreamingWagon) {
                InputStream src = this.task.newInputStream();
                try {
                    ((StreamingWagon)wagon).putFromStream(src, dst, this.task.getDataLength(), -1L);
                }
                finally {
                    WagonTransporter.close(src);
                }
            }
            File src = file != null ? file : this.createTempFile();
            try {
                wagon.put(src, dst);
            }
            finally {
                if (file == null) {
                    WagonTransporter.this.delTempFile(src);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File createTempFile() throws IOException {
            File tmp = WagonTransporter.newTempFile();
            try {
                FileOutputStream fos = new FileOutputStream(tmp);
                try {
                    InputStream is = this.task.newInputStream();
                    try {
                        WagonTransporter.copy(fos, is);
                        fos.close();
                    }
                    finally {
                        WagonTransporter.close(is);
                    }
                }
                finally {
                    WagonTransporter.close(fos);
                }
            }
            catch (IOException e) {
                WagonTransporter.this.delTempFile(tmp);
                throw e;
            }
            return tmp;
        }
    }

    private class GetTaskRunner
    implements TaskRunner {
        private final GetTask task;

        public GetTaskRunner(GetTask task) {
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(Wagon wagon) throws Exception {
            String src = this.task.getLocation().toString();
            File file = this.task.getDataFile();
            if (file == null && wagon instanceof StreamingWagon) {
                OutputStream dst = this.task.newOutputStream();
                try {
                    ((StreamingWagon)wagon).getToStream(src, dst);
                }
                finally {
                    dst.close();
                }
            }
            File dst = file != null ? file : WagonTransporter.newTempFile();
            try {
                wagon.get(src, dst);
                if (!dst.exists()) {
                    new FileOutputStream(dst).close();
                }
                if (file == null) {
                    this.readTempFile(dst);
                }
            }
            finally {
                if (file == null) {
                    WagonTransporter.this.delTempFile(dst);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readTempFile(File dst) throws IOException {
            FileInputStream fis = new FileInputStream(dst);
            try {
                OutputStream os = this.task.newOutputStream();
                try {
                    WagonTransporter.copy(os, fis);
                    os.close();
                }
                finally {
                    WagonTransporter.close(os);
                }
            }
            finally {
                WagonTransporter.close(fis);
            }
        }
    }

    private static class PeekTaskRunner
    implements TaskRunner {
        private final PeekTask task;

        public PeekTaskRunner(PeekTask task) {
            this.task = task;
        }

        public void run(Wagon wagon) throws Exception {
            String src = this.task.getLocation().toString();
            if (!wagon.resourceExists(src)) {
                throw new ResourceDoesNotExistException("Could not find " + src + " in " + wagon.getRepository().getUrl());
            }
        }
    }

    private static interface TaskRunner {
        public void run(Wagon var1) throws Exception;
    }
}

