/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.parameterdatabase;

import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ParameterValue {
    private Object value;
    private boolean isValid;
    private static int inventoryLimit = 10000;
    private static LinkedList inventory = new LinkedList();
    private LinkedList propertyChangeListeners;

    protected ParameterValue(Object value) {
        this.value = value;
        this.isValid = true;
        this.propertyChangeListeners = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParameterValue createParameterValue(Object value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        ParameterValue newValue = null;
        LinkedList linkedList = inventory;
        synchronized (linkedList) {
            if (!inventory.isEmpty()) {
                newValue = (ParameterValue)inventory.removeFirst();
                newValue.value = value;
                newValue.isValid = true;
            }
        }
        if (newValue == null) {
            newValue = new ParameterValue(value);
        }
        return newValue;
    }

    public Object getValue() {
        if (!this.isValid) {
            throw new IllegalStateException();
        }
        return this.value;
    }

    public void setValue(Object value) {
        if (!this.isValid) {
            throw new IllegalStateException();
        }
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.value = value;
    }

    protected void recycle() {
        this.isValid = false;
        this.value = null;
        this.propertyChangeListeners.clear();
    }

    public boolean equals(Object otherValue) {
        if (!this.isValid) {
            throw new IllegalStateException();
        }
        if (otherValue instanceof ParameterValue) {
            ParameterValue other = (ParameterValue)otherValue;
            return this.value.equals(other.value);
        }
        return false;
    }

    public int hashCode() {
        if (!this.isValid) {
            throw new IllegalStateException();
        }
        return this.value.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        LinkedList linkedList = inventory;
        synchronized (linkedList) {
            if (inventory.size() < inventoryLimit) {
                this.recycle();
                inventory.add(this);
                throw new Throwable();
            }
        }
    }

    public List getPropertyChangeListeners() {
        return Collections.unmodifiableList(this.propertyChangeListeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        LinkedList linkedList = this.propertyChangeListeners;
        synchronized (linkedList) {
            if (!this.propertyChangeListeners.contains(listener)) {
                this.propertyChangeListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        LinkedList linkedList = this.propertyChangeListeners;
        synchronized (linkedList) {
            this.propertyChangeListeners.remove(listener);
        }
    }
}

