/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.animation.shared;

import com.sun.scenario.animation.shared.ClipInterpolator;
import com.sun.scenario.animation.shared.InterpolationInterval;
import java.util.HashMap;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.beans.value.WritableValue;
import javafx.util.Duration;

class SimpleClipInterpolator
extends ClipInterpolator {
    private static final KeyFrame ZERO_FRAME = new KeyFrame(Duration.ZERO, new KeyValue[0]);
    private KeyFrame startKeyFrame;
    private KeyFrame endKeyFrame;
    private InterpolationInterval[] interval;
    private int undefinedStartValueCount;
    private double millis;
    private boolean invalid = true;

    SimpleClipInterpolator(KeyFrame keyFrame, KeyFrame keyFrame2) {
        this.startKeyFrame = keyFrame;
        this.endKeyFrame = keyFrame2;
    }

    SimpleClipInterpolator(KeyFrame keyFrame) {
        this.startKeyFrame = ZERO_FRAME;
        this.endKeyFrame = keyFrame;
    }

    @Override
    ClipInterpolator setKeyFrames(KeyFrame[] keyFrameArray) {
        if (ClipInterpolator.getRealKeyFrameCount(keyFrameArray) != 2) {
            return ClipInterpolator.create(keyFrameArray);
        }
        if (keyFrameArray.length == 1) {
            this.startKeyFrame = ZERO_FRAME;
            this.endKeyFrame = keyFrameArray[0];
        } else {
            this.startKeyFrame = keyFrameArray[0];
            this.endKeyFrame = keyFrameArray[1];
        }
        this.invalid = true;
        return this;
    }

    @Override
    void validate(boolean bl) {
        if (this.invalid) {
            this.millis = this.endKeyFrame.getTime().toMillis();
            HashMap hashMap = new HashMap();
            for (KeyValue keyValue : this.endKeyFrame.getValues()) {
                hashMap.put(keyValue.getTarget(), keyValue);
            }
            int n = hashMap.size();
            this.interval = new InterpolationInterval[n];
            int n2 = 0;
            for (KeyValue keyValue : this.startKeyFrame.getValues()) {
                WritableValue<?> writableValue = keyValue.getTarget();
                KeyValue keyValue2 = (KeyValue)hashMap.get(writableValue);
                if (keyValue2 == null) continue;
                this.interval[n2++] = InterpolationInterval.create(keyValue2, this.millis, keyValue, this.millis);
                hashMap.remove(writableValue);
            }
            this.undefinedStartValueCount = hashMap.values().size();
            for (KeyValue keyValue : hashMap.values()) {
                this.interval[n2++] = InterpolationInterval.create(keyValue, this.millis);
            }
            this.invalid = false;
        } else if (bl) {
            int n = this.interval.length;
            for (int i = n - this.undefinedStartValueCount; i < n; ++i) {
                this.interval[i].recalculateStartValue();
            }
        }
    }

    @Override
    void interpolate(double d) {
        double d2 = d / this.millis;
        int n = this.interval.length;
        for (int i = 0; i < n; ++i) {
            this.interval[i].interpolate(d2);
        }
    }
}

