/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.pscan.scanner;

import net.htmlparser.jericho.Source;
import org.apache.commons.httpclient.URIException;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.pscan.PassiveScanThread;
import org.zaproxy.zap.extension.pscan.PluginPassiveScanner;
import org.zaproxy.zap.model.SessionStructure;
import org.zaproxy.zap.utils.Stats;

public class StatsPassiveScanner
extends PluginPassiveScanner {
    public static final String CODE_STATS_PREFIX = "stats.code.";
    public static final String CONTENT_TYPE_STATS_PREFIX = "stats.contentType.";
    public static final String RESPONSE_TIME_STATS_PREFIX = "stats.responseTime.";

    @Override
    public String getName() {
        return Constant.messages.getString("pscan.stats.passivescanner.title");
    }

    @Override
    public int getPluginId() {
        return 50003;
    }

    @Override
    public void scanHttpRequestSend(HttpMessage httpMessage, int n) {
    }

    @Override
    public void scanHttpResponseReceive(HttpMessage httpMessage, int n, Source source) {
        try {
            String string = SessionStructure.getHostName(httpMessage);
            Stats.incCounter(string, CODE_STATS_PREFIX + httpMessage.getResponseHeader().getStatusCode());
            String string2 = httpMessage.getResponseHeader().getHeader("Content-Type");
            if (string2 != null) {
                Stats.incCounter(string, CONTENT_TYPE_STATS_PREFIX + string2);
            }
            Stats.incCounter(string, RESPONSE_TIME_STATS_PREFIX + Integer.highestOneBit(httpMessage.getTimeElapsedMillis()) * 2);
        }
        catch (URIException uRIException) {
            // empty catch block
        }
    }

    @Override
    public boolean appliesToHistoryType(int n) {
        return true;
    }

    @Override
    public void setParent(PassiveScanThread passiveScanThread) {
    }
}

