/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import jcifs.smb.FileEntry;
import jcifs.smb.SmbComTransactionResponse;
import jcifs.util.Hexdump;
import jcifs.util.LogStream;

class NetServerEnum2Response
extends SmbComTransactionResponse {
    private int converter;
    private int totalAvailableEntries;
    String lastName;

    NetServerEnum2Response() {
    }

    int writeSetupWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    int writeParametersWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    int writeDataWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    int readSetupWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    int readParametersWireFormat(byte[] buffer, int bufferIndex, int len) {
        int start = bufferIndex;
        this.status = NetServerEnum2Response.readInt2(buffer, bufferIndex);
        this.converter = NetServerEnum2Response.readInt2(buffer, bufferIndex += 2);
        this.numEntries = NetServerEnum2Response.readInt2(buffer, bufferIndex += 2);
        this.totalAvailableEntries = NetServerEnum2Response.readInt2(buffer, bufferIndex += 2);
        return (bufferIndex += 2) - start;
    }

    int readDataWireFormat(byte[] buffer, int bufferIndex, int len) {
        int start = bufferIndex;
        ServerInfo1 e = null;
        this.results = new ServerInfo1[this.numEntries];
        for (int i = 0; i < this.numEntries; ++i) {
            e = new ServerInfo1();
            this.results[i] = e;
            e.name = this.readString(buffer, bufferIndex, 16, false);
            bufferIndex += 16;
            e.versionMajor = buffer[bufferIndex++] & 0xFF;
            e.versionMinor = buffer[bufferIndex++] & 0xFF;
            e.type = NetServerEnum2Response.readInt4(buffer, bufferIndex);
            int off = NetServerEnum2Response.readInt4(buffer, bufferIndex += 4);
            bufferIndex += 4;
            off = (off & 0xFFFF) - this.converter;
            off = start + off;
            e.commentOrMasterBrowser = this.readString(buffer, off, 48, false);
            if (LogStream.level < 4) continue;
            log.println(e);
        }
        this.lastName = this.numEntries == 0 ? null : e.name;
        return bufferIndex - start;
    }

    public String toString() {
        return new String("NetServerEnum2Response[" + super.toString() + ",status=" + this.status + ",converter=" + this.converter + ",entriesReturned=" + this.numEntries + ",totalAvailableEntries=" + this.totalAvailableEntries + ",lastName=" + this.lastName + "]");
    }

    class ServerInfo1
    implements FileEntry {
        String name;
        int versionMajor;
        int versionMinor;
        int type;
        String commentOrMasterBrowser;

        ServerInfo1() {
        }

        public String getName() {
            return this.name;
        }

        public int getType() {
            return (this.type & Integer.MIN_VALUE) != 0 ? 2 : 4;
        }

        public int getAttributes() {
            return 17;
        }

        public long createTime() {
            return 0L;
        }

        public long lastModified() {
            return 0L;
        }

        public long length() {
            return 0L;
        }

        public String toString() {
            return new String("ServerInfo1[name=" + this.name + ",versionMajor=" + this.versionMajor + ",versionMinor=" + this.versionMinor + ",type=0x" + Hexdump.toHexString(this.type, 8) + ",commentOrMasterBrowser=" + this.commentOrMasterBrowser + "]");
        }
    }
}

