/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.compile;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.gradle.api.Incubating;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.compile.AbstractOptions;
import org.gradle.api.tasks.compile.DebugOptions;
import org.gradle.api.tasks.compile.DependOptions;
import org.gradle.api.tasks.compile.ForkOptions;
import org.gradle.util.SingleMessageLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompileOptions
extends AbstractOptions {
    private static final long serialVersionUID = 0L;
    private static final ImmutableSet<String> EXCLUDE_FROM_ANT_PROPERTIES = ImmutableSet.of((Object)"debugOptions", (Object)"forkOptions", (Object)"compilerArgs", (Object)"dependOptions", (Object)"useDepend", (Object)"incremental", (Object[])new String[0]);
    private boolean failOnError = true;
    private boolean verbose;
    private boolean listFiles;
    private boolean deprecation;
    private boolean warnings = true;
    private String encoding;
    private boolean debug = true;
    private DebugOptions debugOptions = new DebugOptions();
    private boolean fork;
    private ForkOptions forkOptions = new ForkOptions();
    private boolean useDepend;
    private DependOptions dependOptions = new DependOptions();
    private String bootClasspath;
    private String extensionDirs;
    private List<String> compilerArgs = Lists.newArrayList();
    private boolean incremental;
    private FileCollection sourcepath;

    @Input
    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isListFiles() {
        return this.listFiles;
    }

    public void setListFiles(boolean listFiles) {
        this.listFiles = listFiles;
    }

    public boolean isDeprecation() {
        return this.deprecation;
    }

    public void setDeprecation(boolean deprecation) {
        this.deprecation = deprecation;
    }

    public boolean isWarnings() {
        return this.warnings;
    }

    public void setWarnings(boolean warnings) {
        this.warnings = warnings;
    }

    @Input
    @Optional
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Input
    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Nested
    public DebugOptions getDebugOptions() {
        return this.debugOptions;
    }

    public void setDebugOptions(DebugOptions debugOptions) {
        this.debugOptions = debugOptions;
    }

    public boolean isFork() {
        return this.fork;
    }

    public void setFork(boolean fork) {
        this.fork = fork;
    }

    @Nested
    public ForkOptions getForkOptions() {
        return this.forkOptions;
    }

    public void setForkOptions(ForkOptions forkOptions) {
        this.forkOptions = forkOptions;
    }

    public boolean isUseDepend() {
        return this.useDepend;
    }

    public void setUseDepend(boolean useDepend) {
        this.useDepend = useDepend;
    }

    public DependOptions getDependOptions() {
        return this.dependOptions;
    }

    public void setDependOptions(DependOptions dependOptions) {
        this.dependOptions = dependOptions;
    }

    @Input
    @Optional
    public String getBootClasspath() {
        return this.bootClasspath;
    }

    public void setBootClasspath(String bootClasspath) {
        this.bootClasspath = bootClasspath;
    }

    @Input
    @Optional
    public String getExtensionDirs() {
        return this.extensionDirs;
    }

    public void setExtensionDirs(String extensionDirs) {
        this.extensionDirs = extensionDirs;
    }

    @Input
    public List<String> getCompilerArgs() {
        return this.compilerArgs;
    }

    public void setCompilerArgs(List<String> compilerArgs) {
        this.compilerArgs = compilerArgs;
    }

    public CompileOptions fork(Map<String, Object> forkArgs) {
        this.fork = true;
        this.forkOptions.define(forkArgs);
        return this;
    }

    public CompileOptions debug(Map<String, Object> debugArgs) {
        this.debug = true;
        this.debugOptions.define(debugArgs);
        return this;
    }

    public CompileOptions depend(Map<String, Object> dependArgs) {
        this.useDepend = true;
        this.dependOptions.define(dependArgs);
        return this;
    }

    @Incubating
    public CompileOptions setIncremental(boolean incremental) {
        SingleMessageLogger.incubatingFeatureUsed((String)"Incremental java compilation");
        this.incremental = incremental;
        return this;
    }

    public Map<String, Object> optionMap() {
        Map map = super.optionMap();
        map.putAll(this.debugOptions.optionMap());
        map.putAll(this.forkOptions.optionMap());
        return map;
    }

    protected boolean excludeFromAntProperties(String fieldName) {
        return EXCLUDE_FROM_ANT_PROPERTIES.contains((Object)fieldName);
    }

    protected String getAntPropertyName(String fieldName) {
        if (fieldName.equals("warnings")) {
            return "nowarn";
        }
        if (fieldName.equals("extensionDirs")) {
            return "extdirs";
        }
        return fieldName;
    }

    protected Object getAntPropertyValue(String fieldName, Object value) {
        if (fieldName.equals("warnings")) {
            return !this.warnings;
        }
        return value;
    }

    @Incubating
    public boolean isIncremental() {
        return this.incremental;
    }

    @Input
    @Optional
    @Incubating
    public FileCollection getSourcepath() {
        return this.sourcepath;
    }

    @Incubating
    public void setSourcepath(FileCollection sourcepath) {
        this.sourcepath = sourcepath;
    }
}

