/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.antlr.internal.antlr2;

import antlr.collections.impl.IndexedVector;
import antlr.preprocessor.GrammarFile;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.gradle.api.plugins.antlr.internal.antlr2.GrammarMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrammarDelegate {
    private final String className;
    private final String importVocab;
    private final String exportVocab;
    private final GrammarDelegate superGrammarDelegate;
    private GrammarMetadata associatedGrammarMetadata;
    private static final Class ANTLR_GRAMMAR_CLASS = GrammarDelegate.loadAntlrClass("antlr.preprocessor.Grammar");
    private static final Class ANTLR_OPTION_CLASS = GrammarDelegate.loadAntlrClass("antlr.preprocessor.Option");
    public static final Class[] NO_ARG_SIGNATURE = new Class[0];
    public static final Object[] NO_ARGS = new Object[0];

    public static List<GrammarDelegate> extractGrammarDelegates(GrammarFile antlrGrammarFile) {
        ArrayList<GrammarDelegate> grammarDelegates = new ArrayList<GrammarDelegate>();
        Enumeration grammarFileGramars = antlrGrammarFile.getGrammars().elements();
        while (grammarFileGramars.hasMoreElements()) {
            grammarDelegates.add(new GrammarDelegate(grammarFileGramars.nextElement()));
        }
        return grammarDelegates;
    }

    public GrammarDelegate(Object antlrGrammarMetadata) {
        try {
            Method getNameMethod = ANTLR_GRAMMAR_CLASS.getDeclaredMethod("getName", NO_ARG_SIGNATURE);
            getNameMethod.setAccessible(true);
            this.className = (String)getNameMethod.invoke(antlrGrammarMetadata, NO_ARGS);
            Method getSuperGrammarMethod = ANTLR_GRAMMAR_CLASS.getMethod("getSuperGrammar", NO_ARG_SIGNATURE);
            getSuperGrammarMethod.setAccessible(true);
            Object antlrSuperGrammarGrammarMetadata = getSuperGrammarMethod.invoke(antlrGrammarMetadata, NO_ARGS);
            this.superGrammarDelegate = antlrSuperGrammarGrammarMetadata == null ? null : new GrammarDelegate(antlrSuperGrammarGrammarMetadata);
            Method getOptionsMethod = ANTLR_GRAMMAR_CLASS.getMethod("getOptions", NO_ARG_SIGNATURE);
            getOptionsMethod.setAccessible(true);
            IndexedVector options = (IndexedVector)getOptionsMethod.invoke(antlrGrammarMetadata, NO_ARGS);
            Method getRHSMethod = ANTLR_OPTION_CLASS.getMethod("getRHS", NO_ARG_SIGNATURE);
            getRHSMethod.setAccessible(true);
            Object importVocabOption = options == null ? null : options.getElement((Object)"importVocab");
            this.importVocab = importVocabOption == null ? null : this.vocabName((String)getRHSMethod.invoke(importVocabOption, NO_ARGS));
            Object exportVocabOption = options == null ? null : options.getElement((Object)"exportVocab");
            this.exportVocab = exportVocabOption == null ? null : this.vocabName((String)getRHSMethod.invoke(exportVocabOption, NO_ARGS));
        }
        catch (Throwable t) {
            throw new IllegalStateException("Error accessing  Antlr grammar metadata", t);
        }
    }

    public String getClassName() {
        return this.className;
    }

    public String getImportVocab() {
        return this.importVocab;
    }

    public String getExportVocab() {
        return this.exportVocab;
    }

    public GrammarDelegate getSuperGrammarDelegate() {
        return this.superGrammarDelegate;
    }

    public void associateWith(GrammarMetadata associatedGrammarMetadata) {
        this.associatedGrammarMetadata = associatedGrammarMetadata;
    }

    public GrammarMetadata getAssociatedGrammarMetadata() {
        return this.associatedGrammarMetadata;
    }

    private String vocabName(String vocabName) {
        if (vocabName == null) {
            return null;
        }
        if ((vocabName = vocabName.trim()).endsWith(";")) {
            vocabName = vocabName.substring(0, vocabName.length() - 1);
        }
        return vocabName;
    }

    private static Class loadAntlrClass(String className) {
        try {
            return Class.forName(className, true, GrammarDelegate.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to locate Antlr class [" + className + "]", e);
        }
    }
}

