/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.idea.model;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import groovy.lang.GroovyObjectSupport;
import groovy.util.Node;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gradle.plugins.ide.idea.model.Dependency;
import org.gradle.plugins.ide.idea.model.JarDirectory;
import org.gradle.plugins.ide.idea.model.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleLibrary
extends GroovyObjectSupport
implements Dependency {
    private Set<Path> classes = Sets.newLinkedHashSet();
    private Set<JarDirectory> jarDirectories = Sets.newLinkedHashSet();
    private Set<Path> javadoc = Sets.newLinkedHashSet();
    private Set<Path> sources = Sets.newLinkedHashSet();
    private String scope;
    private boolean exported;

    public ModuleLibrary(Collection<? extends Path> classes, Collection<? extends Path> javadoc, Collection<? extends Path> sources, Collection<JarDirectory> jarDirectories, String scope) {
        this.classes = Sets.newLinkedHashSet(classes);
        this.jarDirectories = Sets.newLinkedHashSet(jarDirectories);
        this.javadoc = Sets.newLinkedHashSet(javadoc);
        this.sources = Sets.newLinkedHashSet(sources);
        this.scope = scope;
        this.exported = false;
    }

    public Set<Path> getClasses() {
        return this.classes;
    }

    public void setClasses(Set<Path> classes) {
        this.classes = classes;
    }

    public Set<JarDirectory> getJarDirectories() {
        return this.jarDirectories;
    }

    public void setJarDirectories(Set<JarDirectory> jarDirectories) {
        this.jarDirectories = jarDirectories;
    }

    public Set<Path> getJavadoc() {
        return this.javadoc;
    }

    public void setJavadoc(Set<Path> javadoc) {
        this.javadoc = javadoc;
    }

    public Set<Path> getSources() {
        return this.sources;
    }

    public void setSources(Set<Path> sources) {
        this.sources = sources;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public boolean isExported() {
        return this.exported;
    }

    public boolean getExported() {
        return this.exported;
    }

    public void setExported(boolean exported) {
        this.exported = exported;
    }

    @Override
    public void addToNode(Node parentNode) {
        HashMap attributes;
        HashMap orderEntryAttributes = Maps.newHashMap((Map)ImmutableMap.builder().put((Object)"type", (Object)"module-library").putAll(this.getAttributeMapForScopeAndExported()).build());
        Node libraryNode = parentNode.appendNode((Object)"orderEntry", (Map)orderEntryAttributes).appendNode((Object)"library");
        Node classesNode = libraryNode.appendNode((Object)"CLASSES");
        Node javadocNode = libraryNode.appendNode((Object)"JAVADOC");
        Node sourcesNode = libraryNode.appendNode((Object)"SOURCES");
        for (Path path : this.classes) {
            attributes = Maps.newHashMapWithExpectedSize((int)1);
            attributes.put("url", path.getUrl());
            classesNode.appendNode((Object)"root", (Map)attributes);
        }
        for (Path path : this.javadoc) {
            attributes = Maps.newHashMapWithExpectedSize((int)1);
            attributes.put("url", path.getUrl());
            javadocNode.appendNode((Object)"root", (Map)attributes);
        }
        for (Path path : this.sources) {
            attributes = Maps.newHashMapWithExpectedSize((int)1);
            attributes.put("url", path.getUrl());
            sourcesNode.appendNode((Object)"root", (Map)attributes);
        }
        for (JarDirectory jarDirectory : this.jarDirectories) {
            attributes = Maps.newHashMapWithExpectedSize((int)2);
            attributes.put("url", jarDirectory.getPath().getUrl());
            attributes.put("recursive", String.valueOf(jarDirectory.isRecursive()));
            libraryNode.appendNode((Object)"jarDirectory", (Map)attributes);
        }
    }

    private Map<String, Object> getAttributeMapForScopeAndExported() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (this.exported) {
            builder.put((Object)"exported", (Object)"");
        }
        if (this.scope != null && !"COMPILE".equals(this.scope)) {
            builder.put((Object)"scope", (Object)this.scope);
        }
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        ModuleLibrary that = (ModuleLibrary)o;
        return Objects.equal(this.classes, that.classes) && Objects.equal(this.jarDirectories, that.jarDirectories) && Objects.equal(this.javadoc, that.javadoc) && this.scopeEquals(this.scope, that.scope) && Objects.equal(this.sources, that.sources);
    }

    private boolean scopeEquals(String lhs, String rhs) {
        if ("COMPILE".equals(lhs)) {
            return Strings.isNullOrEmpty((String)rhs) || "COMPILE".equals(rhs);
        }
        if ("COMPILE".equals(rhs)) {
            return Strings.isNullOrEmpty((String)lhs) || "COMPILE".equals(lhs);
        }
        return Objects.equal((Object)lhs, (Object)rhs);
    }

    public int hashCode() {
        int result = this.classes.hashCode();
        result = 31 * result + this.jarDirectories.hashCode();
        result = 31 * result + this.javadoc.hashCode();
        result = 31 * result + this.sources.hashCode();
        result = 31 * result + this.getScopeHash();
        return result;
    }

    private int getScopeHash() {
        return !Strings.isNullOrEmpty((String)this.scope) && !this.scope.equals("COMPILE") ? this.scope.hashCode() : 0;
    }

    public String toString() {
        return "ModuleLibrary{classes=" + this.classes + ", jarDirectories=" + this.jarDirectories + ", javadoc=" + this.javadoc + ", sources=" + this.sources + ", scope='" + this.scope + "'" + "}";
    }
}

