/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.thread;

import org.jmol.thread.JmolThread;
import org.jmol.viewer.ActionManager;
import org.jmol.viewer.MouseState;
import org.jmol.viewer.Viewer;

public class HoverWatcherThread
extends JmolThread {
    private ActionManager actionManager;
    private final MouseState current;
    private final MouseState moved;
    private int hoverDelay;

    public HoverWatcherThread(ActionManager actionManager, MouseState current, MouseState moved, Viewer vwr) {
        this.setViewer(vwr, "HoverWatcher");
        this.actionManager = actionManager;
        this.current = current;
        this.moved = moved;
        this.start();
    }

    @Override
    protected void run1(int mode) throws InterruptedException {
        while (true) {
            switch (mode) {
                case -1: {
                    if (!this.isJS) {
                        Thread.currentThread().setPriority(1);
                    }
                    mode = 0;
                    break;
                }
                case 0: {
                    this.hoverDelay = this.vwr.getHoverDelay();
                    if (this.stopped || this.hoverDelay <= 0 || !this.runSleep(this.hoverDelay, 1)) {
                        return;
                    }
                    mode = 1;
                    break;
                }
                case 1: {
                    if (this.moved.is(this.current)) {
                        this.currentTime = System.currentTimeMillis();
                        int howLong = (int)(this.currentTime - this.moved.time);
                        if (howLong > this.hoverDelay && !this.stopped) {
                            this.actionManager.checkHover();
                        }
                    }
                    mode = 0;
                }
            }
        }
    }
}

