/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentParser;

public class SourceToParse {
    private final Origin origin;
    private final BytesReference source;
    private final XContentParser parser;
    private boolean flyweight = false;
    private String index;
    private String type;
    private String id;
    private String routing;
    private String parentId;
    private long timestamp;
    private long ttl;

    public static SourceToParse source(XContentParser parser) {
        return new SourceToParse(Origin.PRIMARY, parser);
    }

    public static SourceToParse source(BytesReference source) {
        return new SourceToParse(Origin.PRIMARY, source);
    }

    public static SourceToParse source(Origin origin, BytesReference source) {
        return new SourceToParse(origin, source);
    }

    private SourceToParse(Origin origin, XContentParser parser) {
        this.origin = origin;
        this.parser = parser;
        this.source = null;
    }

    private SourceToParse(Origin origin, BytesReference source) {
        this.origin = origin;
        this.source = source.toBytesArray();
        this.parser = null;
    }

    public Origin origin() {
        return this.origin;
    }

    public XContentParser parser() {
        return this.parser;
    }

    public BytesReference source() {
        return this.source;
    }

    public String index() {
        return this.index;
    }

    public SourceToParse index(String index) {
        this.index = index;
        return this;
    }

    public String type() {
        return this.type;
    }

    public SourceToParse type(String type) {
        this.type = type;
        return this;
    }

    public SourceToParse flyweight(boolean flyweight) {
        this.flyweight = flyweight;
        return this;
    }

    public boolean flyweight() {
        return this.flyweight;
    }

    public String id() {
        return this.id;
    }

    public SourceToParse id(String id) {
        this.id = id;
        return this;
    }

    public String parent() {
        return this.parentId;
    }

    public SourceToParse parent(String parentId) {
        this.parentId = parentId;
        return this;
    }

    public String routing() {
        return this.routing;
    }

    public SourceToParse routing(String routing) {
        this.routing = routing;
        return this;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public SourceToParse timestamp(String timestamp) {
        this.timestamp = Long.parseLong(timestamp);
        return this;
    }

    public SourceToParse timestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public long ttl() {
        return this.ttl;
    }

    public SourceToParse ttl(TimeValue ttl) {
        if (ttl == null) {
            this.ttl = -1L;
            return this;
        }
        this.ttl = ttl.millis();
        return this;
    }

    public SourceToParse ttl(long ttl) {
        this.ttl = ttl;
        return this;
    }

    public static enum Origin {
        PRIMARY,
        REPLICA;

    }
}

