/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.warmer;

import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.warmer.WarmerStats;

public class ShardIndexWarmerService
extends AbstractIndexShardComponent {
    private final CounterMetric current = new CounterMetric();
    private final MeanMetric warmerMetric = new MeanMetric();

    public ShardIndexWarmerService(ShardId shardId, Settings indexSettings) {
        super(shardId, indexSettings);
    }

    public ESLogger logger() {
        return this.logger;
    }

    public void onPreWarm() {
        this.current.inc();
    }

    public void onPostWarm(long tookInNanos) {
        this.current.dec();
        this.warmerMetric.inc(tookInNanos);
    }

    public WarmerStats stats() {
        return new WarmerStats(this.current.count(), this.warmerMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.warmerMetric.sum()));
    }
}

