/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.delete;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionWriteResponse;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestBuilderListener;

public class RestDeleteAction
extends BaseRestHandler {
    @Inject
    public RestDeleteAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.DELETE, "/{index}/{type}/{id}", this);
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel, Client client) {
        DeleteRequest deleteRequest = new DeleteRequest(request.param("index"), request.param("type"), request.param("id"));
        deleteRequest.routing(request.param("routing"));
        deleteRequest.parent(request.param("parent"));
        deleteRequest.timeout(request.paramAsTime("timeout", DeleteRequest.DEFAULT_TIMEOUT));
        deleteRequest.refresh(request.paramAsBoolean("refresh", deleteRequest.refresh()));
        deleteRequest.version(RestActions.parseVersion(request));
        deleteRequest.versionType(VersionType.fromString(request.param("version_type"), deleteRequest.versionType()));
        String consistencyLevel = request.param("consistency");
        if (consistencyLevel != null) {
            deleteRequest.consistencyLevel(WriteConsistencyLevel.fromString(consistencyLevel));
        }
        client.delete(deleteRequest, (ActionListener<DeleteResponse>)new RestBuilderListener<DeleteResponse>(channel){

            @Override
            public RestResponse buildResponse(DeleteResponse result, XContentBuilder builder) throws Exception {
                ActionWriteResponse.ShardInfo shardInfo = result.getShardInfo();
                builder.startObject().field(Fields.FOUND, result.isFound()).field(Fields._INDEX, result.getIndex()).field(Fields._TYPE, result.getType()).field(Fields._ID, result.getId()).field(Fields._VERSION, result.getVersion()).value(shardInfo).endObject();
                RestStatus status = shardInfo.status();
                if (!result.isFound()) {
                    status = RestStatus.NOT_FOUND;
                }
                return new BytesRestResponse(status, builder);
            }
        });
    }

    static final class Fields {
        static final XContentBuilderString FOUND = new XContentBuilderString("found");
        static final XContentBuilderString _INDEX = new XContentBuilderString("_index");
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString _ID = new XContentBuilderString("_id");
        static final XContentBuilderString _VERSION = new XContentBuilderString("_version");

        Fields() {
        }
    }
}

