/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangException;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpOutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class OtpErlangMap
extends OtpErlangObject {
    private static final long serialVersionUID = -6410770117696198497L;
    private OtpMap map;

    public OtpErlangMap() {
        this.map = new OtpMap();
    }

    public OtpErlangMap(OtpErlangObject[] otpErlangObjectArray, OtpErlangObject[] otpErlangObjectArray2) {
        this(otpErlangObjectArray, 0, otpErlangObjectArray.length, otpErlangObjectArray2, 0, otpErlangObjectArray2.length);
    }

    public OtpErlangMap(OtpErlangObject[] otpErlangObjectArray, int n, int n2, OtpErlangObject[] otpErlangObjectArray2, int n3, int n4) {
        if (otpErlangObjectArray == null || otpErlangObjectArray2 == null) {
            throw new IllegalArgumentException("Map content can't be null");
        }
        if (n2 != n4) {
            throw new IllegalArgumentException("Map keys and values must have same arity");
        }
        this.map = new OtpMap();
        for (int i = 0; i < n4; ++i) {
            OtpErlangObject otpErlangObject = otpErlangObjectArray[n + i];
            if (otpErlangObject == null) {
                throw new IllegalArgumentException("Map key cannot be null (element" + (n + i) + ")");
            }
            OtpErlangObject otpErlangObject2 = otpErlangObjectArray2[n3 + i];
            if (otpErlangObject2 == null) {
                throw new IllegalArgumentException("Map value cannot be null (element" + (n3 + i) + ")");
            }
            this.put(otpErlangObject, otpErlangObject2);
        }
    }

    public OtpErlangMap(OtpInputStream otpInputStream) throws OtpErlangDecodeException {
        int n = otpInputStream.read_map_head();
        if (n > 0) {
            this.map = new OtpMap();
            for (int i = 0; i < n; ++i) {
                OtpErlangObject otpErlangObject = otpInputStream.read_any();
                OtpErlangObject otpErlangObject2 = otpInputStream.read_any();
                this.put(otpErlangObject, otpErlangObject2);
            }
        } else {
            this.map = new OtpMap();
        }
    }

    public int arity() {
        return this.map.size();
    }

    public OtpErlangObject put(OtpErlangObject otpErlangObject, OtpErlangObject otpErlangObject2) {
        return this.map.put(otpErlangObject, otpErlangObject2);
    }

    public OtpErlangObject remove(OtpErlangObject otpErlangObject) {
        return (OtpErlangObject)this.map.remove(otpErlangObject);
    }

    public OtpErlangObject get(OtpErlangObject otpErlangObject) {
        return (OtpErlangObject)this.map.get(otpErlangObject);
    }

    public OtpErlangObject[] keys() {
        return this.map.keySet().toArray(new OtpErlangObject[this.arity()]);
    }

    public OtpErlangObject[] values() {
        return this.map.values().toArray(new OtpErlangObject[this.arity()]);
    }

    public Set<Map.Entry<OtpErlangObject, OtpErlangObject>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#{");
        boolean bl = true;
        for (Map.Entry<OtpErlangObject, OtpErlangObject> entry : this.entrySet()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",");
            }
            stringBuffer.append(entry.getKey().toString());
            stringBuffer.append(" => ");
            stringBuffer.append(entry.getValue().toString());
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    @Override
    public void encode(OtpOutputStream otpOutputStream) {
        int n = this.arity();
        otpOutputStream.write_map_head(n);
        for (Map.Entry<OtpErlangObject, OtpErlangObject> entry : this.entrySet()) {
            otpOutputStream.write_any(entry.getKey());
            otpOutputStream.write_any(entry.getValue());
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof OtpErlangMap)) {
            return false;
        }
        OtpErlangMap otpErlangMap = (OtpErlangMap)object;
        int n = this.arity();
        if (n != otpErlangMap.arity()) {
            return false;
        }
        if (n == 0) {
            return true;
        }
        for (Map.Entry<OtpErlangObject, OtpErlangObject> entry : this.entrySet()) {
            OtpErlangObject otpErlangObject = entry.getKey();
            OtpErlangObject otpErlangObject2 = entry.getValue();
            OtpErlangObject otpErlangObject3 = otpErlangMap.get(otpErlangObject);
            if (otpErlangObject3 != null && otpErlangObject2.equals(otpErlangObject3)) continue;
            return false;
        }
        return true;
    }

    @Override
    public <T> boolean match(OtpErlangObject otpErlangObject, T t) {
        if (!(otpErlangObject instanceof OtpErlangMap)) {
            return false;
        }
        OtpErlangMap otpErlangMap = (OtpErlangMap)otpErlangObject;
        int n = this.arity();
        if (n > otpErlangMap.arity()) {
            return false;
        }
        if (n == 0) {
            return true;
        }
        for (Map.Entry<OtpErlangObject, OtpErlangObject> entry : this.entrySet()) {
            OtpErlangObject otpErlangObject2 = entry.getKey();
            OtpErlangObject otpErlangObject3 = entry.getValue();
            OtpErlangObject otpErlangObject4 = otpErlangMap.get(otpErlangObject2);
            if (otpErlangObject4 != null && otpErlangObject3.match(otpErlangObject4, t)) continue;
            return false;
        }
        return true;
    }

    @Override
    public <T> OtpErlangObject bind(T t) throws OtpErlangException {
        OtpErlangMap otpErlangMap = new OtpErlangMap();
        for (Map.Entry<OtpErlangObject, OtpErlangObject> entry : this.entrySet()) {
            OtpErlangObject otpErlangObject = entry.getKey();
            OtpErlangObject otpErlangObject2 = entry.getValue();
            otpErlangMap.put(otpErlangObject, otpErlangObject2.bind(t));
        }
        return otpErlangMap;
    }

    @Override
    protected int doHashCode() {
        OtpErlangObject.Hash hash = new OtpErlangObject.Hash(9);
        hash.combine(this.map.hashCode());
        return hash.valueOf();
    }

    @Override
    public Object clone() {
        OtpErlangMap otpErlangMap = (OtpErlangMap)super.clone();
        otpErlangMap.map = (OtpMap)this.map.clone();
        return otpErlangMap;
    }

    private static class OtpMap
    extends LinkedHashMap<OtpErlangObject, OtpErlangObject> {
        private static final long serialVersionUID = -2666505810905455082L;
    }
}

