/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.util;

import groovy.lang.Closure;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.AntBuilderAware;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.internal.PatternSetAntBuilderDelegate;
import org.gradle.api.tasks.util.internal.PatternSpecFactory;
import org.gradle.impldep.com.google.common.collect.Sets;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternSet
implements AntBuilderAware,
PatternFilterable {
    private static final NotationParser<Object, String> PARSER = NotationParserBuilder.toType(String.class).fromCharSequence().toComposite();
    private final PatternSpecFactory patternSpecFactory;
    private final Set<String> includes = Sets.newLinkedHashSet();
    private final Set<String> excludes = Sets.newLinkedHashSet();
    private final Set<Spec<FileTreeElement>> includeSpecs = Sets.newLinkedHashSet();
    private final Set<Spec<FileTreeElement>> excludeSpecs = Sets.newLinkedHashSet();
    private boolean caseSensitive = true;

    public PatternSet() {
        this(PatternSpecFactory.INSTANCE);
    }

    @Incubating
    protected PatternSet(PatternSet patternSet) {
        this(patternSet.patternSpecFactory);
    }

    @Incubating
    protected PatternSet(PatternSpecFactory patternSpecFactory) {
        this.patternSpecFactory = patternSpecFactory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatternSet that = (PatternSet)o;
        if (this.caseSensitive != that.caseSensitive) {
            return false;
        }
        if (this.excludeSpecs != null ? !this.excludeSpecs.equals(that.excludeSpecs) : that.excludeSpecs != null) {
            return false;
        }
        if (this.excludes != null ? !this.excludes.equals(that.excludes) : that.excludes != null) {
            return false;
        }
        if (this.includeSpecs != null ? !this.includeSpecs.equals(that.includeSpecs) : that.includeSpecs != null) {
            return false;
        }
        return !(this.includes != null ? !this.includes.equals(that.includes) : that.includes != null);
    }

    public int hashCode() {
        int result = this.includes != null ? this.includes.hashCode() : 0;
        result = 31 * result + (this.excludes != null ? this.excludes.hashCode() : 0);
        result = 31 * result + (this.includeSpecs != null ? this.includeSpecs.hashCode() : 0);
        result = 31 * result + (this.excludeSpecs != null ? this.excludeSpecs.hashCode() : 0);
        result = 31 * result + (this.caseSensitive ? 1 : 0);
        return result;
    }

    public PatternSet copyFrom(PatternFilterable sourcePattern) {
        return this.doCopyFrom((PatternSet)sourcePattern);
    }

    protected PatternSet doCopyFrom(PatternSet from) {
        this.includes.clear();
        this.excludes.clear();
        this.includeSpecs.clear();
        this.excludeSpecs.clear();
        this.caseSensitive = from.caseSensitive;
        if (from instanceof IntersectionPatternSet) {
            PatternSet other = ((IntersectionPatternSet)from).other;
            PatternSet otherCopy = new PatternSet(other).copyFrom(other);
            IntersectionPatternSet intersectCopy = new IntersectionPatternSet(otherCopy);
            intersectCopy.includes.addAll(from.includes);
            intersectCopy.excludes.addAll(from.excludes);
            intersectCopy.includeSpecs.addAll(from.includeSpecs);
            intersectCopy.excludeSpecs.addAll(from.excludeSpecs);
            this.includeSpecs.add(((PatternSet)intersectCopy).getAsSpec());
        } else {
            this.includes.addAll(from.includes);
            this.excludes.addAll(from.excludes);
            this.includeSpecs.addAll(from.includeSpecs);
            this.excludeSpecs.addAll(from.excludeSpecs);
        }
        return this;
    }

    public PatternSet intersect() {
        if (this.isEmpty()) {
            return new PatternSet();
        }
        return new IntersectionPatternSet(this);
    }

    public boolean isEmpty() {
        return this.getExcludes().isEmpty() && this.getIncludes().isEmpty() && this.getExcludeSpecs().isEmpty() && this.getIncludeSpecs().isEmpty();
    }

    public Spec<FileTreeElement> getAsSpec() {
        return this.patternSpecFactory.createSpec(this);
    }

    public Spec<FileTreeElement> getAsIncludeSpec() {
        return this.patternSpecFactory.createIncludeSpec(this);
    }

    public Spec<FileTreeElement> getAsExcludeSpec() {
        return this.patternSpecFactory.createExcludeSpec(this);
    }

    @Override
    public Set<String> getIncludes() {
        return this.includes;
    }

    public Set<Spec<FileTreeElement>> getIncludeSpecs() {
        return this.includeSpecs;
    }

    @Override
    public PatternSet setIncludes(Iterable<String> includes) {
        this.includes.clear();
        return this.include((Iterable)includes);
    }

    @Override
    public PatternSet include(String ... includes) {
        Collections.addAll(this.includes, includes);
        return this;
    }

    public PatternSet include(Iterable includes) {
        for (Object include : includes) {
            this.includes.add(PARSER.parseNotation(include));
        }
        return this;
    }

    @Override
    public PatternSet include(Spec<FileTreeElement> spec) {
        this.includeSpecs.add(spec);
        return this;
    }

    @Override
    public Set<String> getExcludes() {
        return this.excludes;
    }

    public Set<Spec<FileTreeElement>> getExcludeSpecs() {
        return this.excludeSpecs;
    }

    @Override
    public PatternSet setExcludes(Iterable<String> excludes) {
        this.excludes.clear();
        return this.exclude((Iterable)excludes);
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public PatternSet includeSpecs(Iterable<Spec<FileTreeElement>> includeSpecs) {
        CollectionUtils.addAll(this.includeSpecs, includeSpecs);
        return this;
    }

    @Override
    public PatternSet include(Closure closure) {
        this.include(Specs.convertClosureToSpec(closure));
        return this;
    }

    @Override
    public PatternSet exclude(String ... excludes) {
        Collections.addAll(this.excludes, excludes);
        return this;
    }

    public PatternSet exclude(Iterable excludes) {
        for (Object exclude : excludes) {
            this.excludes.add(PARSER.parseNotation(exclude));
        }
        return this;
    }

    @Override
    public PatternSet exclude(Spec<FileTreeElement> spec) {
        this.excludeSpecs.add(spec);
        return this;
    }

    public PatternSet excludeSpecs(Iterable<Spec<FileTreeElement>> excludes) {
        CollectionUtils.addAll(this.excludeSpecs, excludes);
        return this;
    }

    @Override
    public PatternSet exclude(Closure closure) {
        this.exclude(Specs.convertClosureToSpec(closure));
        return this;
    }

    @Override
    public Object addToAntBuilder(Object node, String childNodeName) {
        if (!this.includeSpecs.isEmpty() || !this.excludeSpecs.isEmpty()) {
            throw new UnsupportedOperationException("Cannot add include/exclude specs to Ant node. Only include/exclude patterns are currently supported.");
        }
        return new PatternSetAntBuilderDelegate(this.includes, this.excludes, this.caseSensitive).addToAntBuilder(node, childNodeName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntersectionPatternSet
    extends PatternSet {
        private final PatternSet other;

        public IntersectionPatternSet(PatternSet other) {
            super(other);
            this.other = other;
        }

        @Override
        public Spec<FileTreeElement> getAsSpec() {
            return Specs.intersect(super.getAsSpec(), this.other.getAsSpec());
        }

        @Override
        public Object addToAntBuilder(Object node, String childNodeName) {
            return PatternSetAntBuilderDelegate.and(node, new Action<Object>(){

                @Override
                public void execute(Object andNode) {
                    IntersectionPatternSet.super.addToAntBuilder(andNode, null);
                    IntersectionPatternSet.this.other.addToAntBuilder(andNode, null);
                }
            });
        }

        @Override
        public boolean isEmpty() {
            return this.other.isEmpty() && super.isEmpty();
        }
    }
}

