/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.util.Hashtable;
import java.util.Map;
import javajs.awt.Font;
import javajs.util.A4;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.T3;
import org.jmol.export.UseTable;
import org.jmol.export.__CartesianExporter;
import org.jmol.java.BS;
import org.jmol.viewer.Viewer;

public class _VrmlExporter
extends __CartesianExporter {
    protected UseTable useTable;
    private P3 tempQ1 = new P3();
    private P3 tempQ2 = new P3();
    private Map<String, Boolean> htSpheresRendered = new Hashtable<String, Boolean>();
    protected float fontSize;
    protected String fontFace;
    protected String fontStyle;
    protected String fontChild;

    public _VrmlExporter() {
        this.useTable = new UseTable("USE ");
        this.commentChar = "# ";
    }

    @Override
    protected void output(T3 pt) {
        this.output(_VrmlExporter.round(this.scalePt(pt)));
    }

    @Override
    protected void outputHeader() {
        this.output("#VRML V2.0 utf8 Generated by Jmol " + Viewer.getJmolVersion() + "\n");
        this.output("WorldInfo { \n");
        this.output(" title " + PT.esc(this.vwr.ms.modelSetName) + "\n");
        this.output(" info [ \"Generated by Jmol " + Viewer.getJmolVersion() + " \", \n");
        this.output("  \"http://www.jmol.org \", \n");
        this.output("  \"Creation date: " + this.getExportDate() + " \" ]\n");
        this.output("} \n");
        this.output("NavigationInfo { type \"EXAMINE\" } \n");
        this.output("Background { skyColor [" + this.rgbFractionalFromColix(this.backgroundColix) + "] } \n");
        float angle = this.getViewpoint();
        this.output("Viewpoint{fieldOfView " + angle);
        this.output(" position ");
        this.output(this.cameraPosition);
        this.output(" orientation ");
        this.output(this.tempP1);
        this.output(" " + -this.viewpoint.angle);
        this.output("\n jump TRUE description \"v1\"\n}\n\n");
        this.output(this.getJmolPerspective());
        this.output("\nTransform{children Transform{translation ");
        this.tempP1.setT(this.center);
        this.tempP1.scale(-1.0f);
        this.output(this.tempP1);
        this.output("\nchildren [\n");
    }

    protected float getViewpoint() {
        this.viewpoint.setM(this.vwr.tm.matrixRotate);
        this.tempP1.set(this.viewpoint.x, this.viewpoint.y, this.viewpoint.angle == 0.0f ? 1.0f : this.viewpoint.z);
        return (float)((double)this.aperatureAngle * Math.PI / 180.0);
    }

    @Override
    protected void outputFooter() {
        this.useTable = null;
        this.output("\n]\n");
        this.output("}}\n");
    }

    protected void outputAppearance(short colix, boolean isText) {
        String def = this.useTable.getDef((isText ? "T" : "") + colix);
        this.output(" appearance ");
        if (def.charAt(0) == '_') {
            String color = this.rgbFractionalFromColix(colix);
            this.output(" DEF " + def + " Appearance{material Material{diffuseColor ");
            if (isText) {
                this.output(" 0 0 0 specularColor 0 0 0 ambientIntensity 0.0 shininess 0.0 emissiveColor " + color + " }}");
            } else {
                this.output(color + " transparency " + _VrmlExporter.translucencyFractionalFromColix(colix) + "}}");
            }
            return;
        }
        this.output(def);
    }

    @Override
    protected void outputCircle(P3 pt1, P3 pt2, float radius, short colix, boolean doFill) {
        if (doFill) {
            this.output("Transform{translation ");
            this.tempV1.ave(pt1, pt2);
            this.output(this.tempV1);
            this.output(" children Billboard{axisOfRotation 0 0 0 children Transform{rotation 1 0 0 1.5708");
            this.outputCylinderChildScaled(pt1, pt2, colix, (byte)2, radius * 2000.0f);
            this.output("}}}\n");
            return;
        }
        String child = this.useTable.getDef("C" + colix + "_" + radius);
        this.outputTransRot(pt1, pt2, 0, 0, 1);
        this.tempP3.set(1.0f, 1.0f, 1.0f);
        this.tempP3.scale(radius);
        this.output(" scale ");
        this.output(this.tempP3);
        this.output(" children ");
        if (child.charAt(0) == '_') {
            int i;
            this.output("DEF " + child);
            this.output(" Billboard{axisOfRotation 0 0 0 children Transform{children");
            this.output(" Shape{geometry Extrusion{beginCap FALSE convex FALSE endCap FALSE creaseAngle 1.57");
            this.output(" crossSection [");
            float rpd = (float)Math.PI / 180;
            float scale = 0.02f / radius;
            for (i = 0; i <= 360; i += 10) {
                this.output(_VrmlExporter.round(Math.cos((float)i * rpd) * (double)scale) + " ");
                this.output(_VrmlExporter.round(Math.sin((float)i * rpd) * (double)scale) + " ");
            }
            this.output("] spine [");
            for (i = 0; i <= 360; i += 10) {
                this.output(_VrmlExporter.round(Math.cos((float)i * rpd)) + " ");
                this.output(_VrmlExporter.round(Math.sin((float)i * rpd)) + " 0 ");
            }
            this.output("]}");
            this.outputAppearance(colix, false);
            this.output("}}}");
        } else {
            this.output(child);
        }
        this.output("}\n");
    }

    @Override
    protected void outputCone(P3 ptBase, P3 ptTip, float radius, short colix) {
        radius = this.scale(radius);
        float height = this.scale(ptBase.distance(ptTip));
        this.outputTransRot(ptBase, ptTip, 0, 1, 0);
        this.output(" children ");
        String cone = "o" + (int)(height * 100.0f) + "_" + (int)(radius * 100.0f);
        String child = this.useTable.getDef("c" + cone + "_" + colix);
        if (child.charAt(0) == '_') {
            this.output("DEF " + child + " Shape{geometry ");
            cone = this.useTable.getDef(cone);
            if (cone.charAt(0) == '_') {
                this.output("DEF " + cone + " Cone{height " + _VrmlExporter.round(height) + " bottomRadius " + _VrmlExporter.round(radius) + "}");
            } else {
                this.output(cone);
            }
            this.outputAppearance(colix, false);
            this.output("}");
        } else {
            this.output(child);
        }
        this.output("}\n");
    }

    @Override
    protected boolean outputCylinder(P3 ptCenter, P3 pt1, P3 pt2, short colix, byte endcaps, float radius, P3 ptX, P3 ptY, boolean checkRadius) {
        if (ptX == null) {
            this.outputTransRot(pt1, pt2, 0, 1, 0);
        } else {
            this.output("Transform{translation ");
            this.output(ptCenter);
            this.outputQuaternionFrame(ptCenter, ptY, pt1, ptX, 2.0f, " ", "");
            pt1.set(0.0f, 0.0f, -1.0f);
            pt2.set(0.0f, 0.0f, 1.0f);
        }
        this.outputCylinderChildScaled(pt1, pt2, colix, endcaps, radius);
        this.output("}\n");
        if (endcaps == 3) {
            this.outputSphere(pt1, radius * 1.01f, colix, checkRadius);
            this.outputSphere(pt2, radius * 1.01f, colix, checkRadius);
        }
        return true;
    }

    protected void outputCylinderChildScaled(P3 pt1, P3 pt2, short colix, byte endcaps, float radius) {
        this.output(" children ");
        float length = this.scale(pt1.distance(pt2));
        radius = this.scale(radius);
        String child = this.useTable.getDef("C" + colix + "_" + (int)(length * 100.0f) + "_" + radius + "_" + endcaps);
        if (child.charAt(0) == '_') {
            this.output("DEF " + child);
            this.output(" Shape{geometry ");
            String cyl = this.useTable.getDef("c" + _VrmlExporter.round(length) + "_" + endcaps + "_" + radius);
            if (cyl.charAt(0) == '_') {
                this.output("DEF " + cyl + " Cylinder{height " + _VrmlExporter.round(length) + " radius " + radius + (endcaps == 2 ? "" : " top FALSE bottom FALSE") + "}");
            } else {
                this.output(cyl);
            }
            this.outputAppearance(colix, false);
            this.output("}");
        } else {
            this.output(child);
        }
    }

    @Override
    protected void outputEllipsoid(P3 ptCenter, P3[] points, short colix) {
        this.output("Transform{translation ");
        this.output(ptCenter);
        this.outputQuaternionFrame(ptCenter, points[1], points[3], points[5], 1.0f, " ", "");
        this.output(" children ");
        this.tempP3.set(0.0f, 0.0f, 0.0f);
        this.outputSphereChildUnscaled(this.tempP3, 1.0f, colix);
        this.output("}\n");
    }

    protected void outputQuaternionFrame(P3 ptCenter, P3 ptX, P3 ptY, P3 ptZ, float yScale, String pre, String post) {
        this.tempQ1.setT(ptX);
        this.tempQ2.setT(ptY);
        A4 a = Quat.getQuaternionFrame(ptCenter, this.tempQ1, this.tempQ2).toAxisAngle4f();
        if (!Float.isNaN(a.x)) {
            this.output(" rotation");
            this.output(pre);
            this.output(a.x + " " + a.y + " " + a.z + " " + a.angle);
            this.output(post);
        }
        float sx = this.scale(ptX.distance(ptCenter));
        float sy = this.scale(ptY.distance(ptCenter) * yScale);
        float sz = this.scale(ptZ.distance(ptCenter));
        this.output(" scale");
        this.output(pre);
        this.output(sx + " " + sy + " " + sz);
        this.output(post);
    }

    @Override
    protected void outputSurface(T3[] vertices, T3[] normals, short[] colixes, int[][] indices, short[] polygonColixes, int nVertices, int nPolygons, int nFaces, BS bsPolygons, int faceVertexMax, short colix, Lst<Short> colorList, Map<Short, Integer> htColixes, P3 offset) {
        this.output("Shape {\n");
        this.outputAppearance(colix, false);
        this.output(" geometry IndexedFaceSet {\n");
        if (polygonColixes != null) {
            this.output(" colorPerVertex FALSE\n");
        }
        this.output("coord Coordinate {\n   point [\n");
        this.outputVertices(vertices, nVertices, offset);
        this.output("   ]\n");
        this.output("  }\n");
        this.output("  coordIndex [\n");
        int[] map = new int[nVertices];
        this.getCoordinateMap(vertices, map, null);
        this.outputIndices(indices, map, nPolygons, bsPolygons, faceVertexMax);
        this.output("  ]\n");
        if (normals != null) {
            Lst<String> vNormals = new Lst<String>();
            map = this.getNormalMap(normals, nVertices, null, vNormals);
            this.output("  solid FALSE\n  normalPerVertex TRUE\n   normal Normal {\n  vector [\n");
            this.outputNormals(vNormals);
            this.output("   ]\n");
            this.output("  }\n");
            this.output("  normalIndex [\n");
            this.outputIndices(indices, map, nPolygons, bsPolygons, faceVertexMax);
            this.output("  ]\n");
        }
        map = null;
        if (colorList != null) {
            this.output("  color Color { color [\n");
            this.outputColors(colorList);
            this.output("  ] } \n");
            this.output("  colorIndex [\n");
            this.outputColorIndices(indices, nPolygons, bsPolygons, faceVertexMax, htColixes, colixes, polygonColixes);
            this.output("  ]\n");
        }
        this.output(" }\n");
        this.output("}\n");
    }

    @Override
    protected void outputFace(int[] face, int[] map, int faceVertexMax) {
        this.output(map[face[0]] + " " + map[face[1]] + " " + map[face[2]] + " -1\n");
        if (faceVertexMax == 4 && face.length == 4) {
            this.output(map[face[0]] + " " + map[face[2]] + " " + map[face[3]] + " -1\n");
        }
    }

    protected void outputNormals(Lst<String> vNormals) {
        int n = vNormals.size();
        for (int i = 0; i < n; ++i) {
            this.output((String)vNormals.get(i));
        }
    }

    protected void outputColors(Lst<Short> colorList) {
        int nColors = colorList.size();
        for (int i = 0; i < nColors; ++i) {
            String color = this.rgbFractionalFromColix((Short)colorList.get(i));
            this.output(" ");
            this.output(color);
            this.output("\n");
        }
    }

    protected void outputColorIndices(int[][] indices, int nPolygons, BS bsPolygons, int faceVertexMax, Map<Short, Integer> htColixes, short[] colixes, short[] polygonColixes) {
        int i0;
        boolean isAll = bsPolygons == null;
        int i = i0 = isAll ? nPolygons - 1 : bsPolygons.nextSetBit(0);
        while (i >= 0) {
            if (polygonColixes == null) {
                this.output(htColixes.get(colixes[indices[i][0]]) + " " + htColixes.get(colixes[indices[i][1]]) + " " + htColixes.get(colixes[indices[i][2]]) + " -1\n");
                if (faceVertexMax == 4 && indices[i].length == 4) {
                    this.output(htColixes.get(colixes[indices[i][0]]) + " " + htColixes.get(colixes[indices[i][2]]) + " " + htColixes.get(colixes[indices[i][3]]) + " -1\n");
                }
            } else {
                this.output(htColixes.get(polygonColixes[i]) + "\n");
            }
            i = isAll ? i - 1 : bsPolygons.nextSetBit(i + 1);
        }
    }

    @Override
    protected void outputSphere(T3 ptCenter, float radius, short colix, boolean checkRadius) {
        radius = this.scale(radius);
        String check = _VrmlExporter.round(this.scalePt(ptCenter)) + (checkRadius ? " " + (int)(radius * 100.0f) : "");
        if (this.htSpheresRendered.get(check) != null) {
            return;
        }
        this.htSpheresRendered.put(check, Boolean.TRUE);
        this.outputSphereChildUnscaled(ptCenter, radius, colix);
    }

    protected void outputSphereChildUnscaled(T3 ptCenter, float radius, short colix) {
        int iRad = (int)(radius * 100.0f);
        String child = this.useTable.getDef("S" + colix + "_" + iRad);
        this.output("Transform{translation ");
        this.output(ptCenter);
        this.output(" children ");
        if (child.charAt(0) == '_') {
            this.output("DEF " + child);
            this.output(" Shape{geometry Sphere{radius " + radius + "}");
            this.outputAppearance(colix, false);
            this.output("}");
        } else {
            this.output(child);
        }
        this.output("}\n");
    }

    @Override
    protected void outputTextPixel(P3 pt, int argb) {
    }

    protected void outputTransRot(P3 pt1, P3 pt2, int x, int y, int z) {
        this.output("Transform{");
        this.outputTransRot(pt1, pt2, x, y, z, " ", "");
    }

    protected void outputTransRot(P3 pt1, P3 pt2, int x, int y, int z, String pre, String post) {
        this.tempV1.ave(pt2, pt1);
        this.output("translation");
        this.output(pre);
        this.output(this.tempV1);
        this.output(post);
        this.tempV1.sub(pt1);
        this.tempV1.normalize();
        this.tempV2.set(x, y, z);
        this.tempV2.add(this.tempV1);
        this.output(" rotation");
        this.output(pre);
        this.output(this.tempV2);
        this.output(" ");
        this.output(_VrmlExporter.round(3.1415927410125732));
        this.output(post);
    }

    @Override
    protected void outputTriangle(T3 pt1, T3 pt2, T3 pt3, short colix) {
        this.output("Shape{geometry IndexedFaceSet{solid FALSE coord Coordinate{point[");
        this.output(pt1);
        this.output(" ");
        this.output(pt2);
        this.output(" ");
        this.output(pt3);
        this.output("]}coordIndex[ 0 1 2 -1 ]}");
        this.outputAppearance(colix, false);
        this.output("}\n");
    }

    @Override
    void plotText(int x, int y, int z, short colix, String text, Font font3d) {
        this.output("Transform{translation ");
        this.output(this.setFont(x, y, z, colix, text, font3d));
        this.output(" children ");
        if (this.fontChild.charAt(0) == '_') {
            this.output("DEF " + this.fontChild + " Billboard{axisOfRotation 0 0 0 children Transform{children Shape{");
            this.outputAppearance(colix, true);
            this.output(" geometry Text{fontStyle ");
            String fontstyle = this.useTable.getDef("F" + this.fontFace + this.fontStyle);
            if (fontstyle.charAt(0) == '_') {
                this.output("DEF " + fontstyle + " FontStyle{size " + this.fontSize + " family \"" + this.fontFace + "\" style \"" + this.fontStyle + "\"}");
            } else {
                this.output(fontstyle);
            }
            this.output(" string " + PT.esc(text) + "}}}}");
        } else {
            this.output(this.fontChild);
        }
        this.output("}\n");
    }

    protected T3 setFont(int x, int y, int z, short colix, String text, Font font3d) {
        this.tempP3.set(x, y, this.fixScreenZ(z));
        this.tm.unTransformPoint(this.tempP3, this.tempP1);
        this.fontStyle = font3d.fontStyle.toUpperCase();
        this.fontFace = font3d.fontFace.toUpperCase();
        this.fontFace = this.fontFace.equals("MONOSPACED") ? "TYPEWRITER" : (this.fontFace.equals("SERIF") ? "SERIF" : "Arial");
        this.fontSize = font3d.fontSize * 0.015f;
        this.fontChild = this.useTable.getDef("T" + colix + this.fontFace + this.fontStyle + this.fontSize + "_" + text);
        return this.tempP1;
    }
}

