/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.j3d;

import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.tools.URLContent;
import com.sun.j3d.utils.image.TextureLoader;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Texture;

public class TextureManager {
    private static TextureManager instance;
    private final Texture errorTexture = this.getColoredImageTexture(Color.RED);
    private final Texture waitTexture = this.getColoredImageTexture(Color.WHITE);
    private final Map<Content, List<ComparableTextureAngleTuple>> contentTextures = new WeakHashMap<Content, List<ComparableTextureAngleTuple>>();
    private final Map<Texture, ComparableTexture> textures = new WeakHashMap<Texture, ComparableTexture>();
    private Map<RotatedContentKey, List<TextureObserver>> loadingTextureObservers = new HashMap<RotatedContentKey, List<TextureObserver>>();
    private ExecutorService texturesLoader;

    private TextureManager() {
    }

    public static TextureManager getInstance() {
        if (instance == null) {
            instance = new TextureManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.texturesLoader != null) {
            this.texturesLoader.shutdownNow();
            this.texturesLoader = null;
        }
        Map<Texture, ComparableTexture> map = this.textures;
        synchronized (map) {
            this.contentTextures.clear();
            this.textures.clear();
        }
    }

    private Texture getColoredImageTexture(Color color) {
        BufferedImage bufferedImage = new BufferedImage(1, 1, 1);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setColor(color);
        graphics.drawLine(0, 0, 0, 0);
        graphics.dispose();
        Texture texture = new TextureLoader(bufferedImage).getTexture();
        texture.setCapability(4);
        texture.setCapability(9);
        texture.getImage(0).setCapability(2);
        texture.getImage(0).setCapability(1);
        return texture;
    }

    public void loadTexture(Content content, TextureObserver textureObserver) {
        this.loadTexture(content, false, textureObserver);
    }

    public void loadTexture(Content content, boolean bl, TextureObserver textureObserver) {
        this.loadTexture(content, 0.0f, bl, textureObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTexture(final Content content, final float f, boolean bl, TextureObserver textureObserver) {
        List<Object> list;
        Texture texture = null;
        Object object = this.textures;
        synchronized (object) {
            list = this.contentTextures.get(content);
            if (list != null) {
                for (ComparableTextureAngleTuple comparableTextureAngleTuple : list) {
                    if (comparableTextureAngleTuple.getAngle() != f) continue;
                    texture = comparableTextureAngleTuple.getTexture();
                }
            }
        }
        if (texture == null) {
            if (bl) {
                texture = this.shareTexture(this.loadTexture(content, f), f, content);
                textureObserver.textureUpdated(texture);
            } else {
                if (!EventQueue.isDispatchThread()) {
                    throw new IllegalStateException("Asynchronous call out of Event Dispatch Thread");
                }
                textureObserver.textureUpdated(this.waitTexture);
                if (this.texturesLoader == null) {
                    this.texturesLoader = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
                }
                if ((list = this.loadingTextureObservers.get(object = new RotatedContentKey(content, f))) != null) {
                    list.add((ComparableTextureAngleTuple)((Object)textureObserver));
                } else {
                    list = new ArrayList();
                    list.add(textureObserver);
                    this.loadingTextureObservers.put((RotatedContentKey)object, list);
                    this.texturesLoader.execute(new Runnable((RotatedContentKey)object){
                        final /* synthetic */ RotatedContentKey val$contentKey;
                        {
                            this.val$contentKey = rotatedContentKey;
                        }

                        public void run() {
                            final Texture texture = TextureManager.this.shareTexture(TextureManager.this.loadTexture(content, f), f, content);
                            EventQueue.invokeLater(new Runnable(){

                                public void run() {
                                    for (TextureObserver textureObserver : (List)TextureManager.this.loadingTextureObservers.remove(val$contentKey)) {
                                        textureObserver.textureUpdated(texture);
                                    }
                                }
                            });
                        }
                    });
                }
            }
        } else {
            textureObserver.textureUpdated(texture);
        }
    }

    public Texture loadTexture(Content content) {
        return this.loadTexture(content, 0.0f);
    }

    private Texture loadTexture(Content content, float f) {
        try {
            BufferedImage bufferedImage;
            InputStream inputStream = content.openStream();
            try {
                bufferedImage = ImageIO.read(inputStream);
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                inputStream.close();
                inputStream = content.openStream();
                bufferedImage = ImageIO.read(inputStream);
            }
            if (f != 0.0f) {
                double d = Math.cos(f);
                double d2 = Math.sin(f);
                BufferedImage bufferedImage2 = new BufferedImage((int)Math.round(Math.abs((double)bufferedImage.getWidth() * d) + Math.abs((double)bufferedImage.getHeight() * d2)), (int)Math.round(Math.abs((double)bufferedImage.getWidth() * d2) + Math.abs((double)bufferedImage.getHeight() * d)), 2);
                Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
                graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                graphics2D.setPaint(new TexturePaint(bufferedImage, new Rectangle2D.Float(0.0f, 0.0f, bufferedImage.getWidth(), bufferedImage.getHeight())));
                graphics2D.rotate(f);
                float f2 = Math.max(bufferedImage2.getWidth(), bufferedImage2.getHeight());
                graphics2D.fill(new Rectangle2D.Float(-f2, -f2, 3.0f * f2, 3.0f * f2));
                graphics2D.dispose();
                bufferedImage = bufferedImage2;
            }
            inputStream.close();
            if (bufferedImage != null) {
                Texture texture = new TextureLoader(bufferedImage).getTexture();
                if (content instanceof URLContent && f == 0.0f) {
                    texture.setUserData((Object)((URLContent)content).getURL());
                }
                return texture;
            }
            return this.errorTexture;
        }
        catch (IOException iOException) {
            return this.errorTexture;
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException.getClass().getName().equals("com.sun.j3d.utils.image.ImageException")) {
                return this.errorTexture;
            }
            throw runtimeException;
        }
    }

    public Texture shareTexture(Texture texture) {
        return this.shareTexture(texture, 0.0f, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Texture shareTexture(Texture texture, float f, Content content) {
        ComparableTexture comparableTexture = new ComparableTexture(texture);
        Texture texture2 = null;
        Map<Texture, ComparableTexture> map = this.textures;
        synchronized (map) {
            for (Map.Entry<Texture, ComparableTexture> entry : this.textures.entrySet()) {
                if (!comparableTexture.equalsImage(entry.getValue())) continue;
                texture2 = entry.getKey();
                comparableTexture = entry.getValue();
                break;
            }
            if (texture2 == null) {
                texture2 = texture;
                this.setSharedTextureAttributesAndCapabilities(texture2);
                this.textures.put(texture2, comparableTexture);
            }
            if (content != null) {
                List<ComparableTextureAngleTuple> list = this.contentTextures.get(content);
                if (list == null) {
                    list = new ArrayList<ComparableTextureAngleTuple>(1);
                    this.contentTextures.put(content, list);
                }
                list.add(new ComparableTextureAngleTuple(comparableTexture, f));
            }
        }
        return texture2;
    }

    private void setSharedTextureAttributesAndCapabilities(Texture texture) {
        if (!texture.isLive()) {
            texture.setMinFilter(1);
            texture.setMagFilter(1);
            texture.setCapability(9);
            texture.setCapability(4);
            for (ImageComponent imageComponent : texture.getImages()) {
                if (imageComponent.isLive()) continue;
                imageComponent.setCapability(1);
                imageComponent.setCapability(2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTextureTransparent(Texture texture) {
        Map<Texture, ComparableTexture> map = this.textures;
        synchronized (map) {
            ComparableTexture comparableTexture = this.textures.get(texture);
            if (comparableTexture != null) {
                return comparableTexture.isTransparent();
            }
            return texture.getFormat() == 6;
        }
    }

    public float getRotatedTextureWidth(HomeTexture homeTexture) {
        float f = homeTexture.getAngle();
        if (f != 0.0f) {
            return (float)Math.rint(Math.abs((double)homeTexture.getWidth() * Math.cos(f)) + Math.abs((double)homeTexture.getHeight() * Math.sin(f)));
        }
        return homeTexture.getWidth();
    }

    public float getRotatedTextureHeight(HomeTexture homeTexture) {
        float f = homeTexture.getAngle();
        if (f != 0.0f) {
            return (float)Math.rint(Math.abs((double)homeTexture.getWidth() * Math.sin(f)) + Math.abs((double)homeTexture.getHeight() * Math.cos(f)));
        }
        return homeTexture.getHeight();
    }

    private static class ComparableTextureAngleTuple {
        private ComparableTexture texture;
        private float angle;

        public ComparableTextureAngleTuple(ComparableTexture comparableTexture, float f) {
            this.texture = comparableTexture;
            this.angle = f;
        }

        public Texture getTexture() {
            return this.texture.getTexture();
        }

        public float getAngle() {
            return this.angle;
        }
    }

    private static class ComparableTexture {
        private Texture texture;
        private WeakReference<int[]> imageBits;
        private Integer imageBitsHashCode;
        private Boolean transparent;

        public ComparableTexture(Texture texture) {
            this.texture = texture;
        }

        public Texture getTexture() {
            return this.texture;
        }

        private int[] getImageBits() {
            int[] nArray = null;
            if (this.imageBits != null) {
                nArray = (int[])this.imageBits.get();
            }
            if (nArray == null) {
                BufferedImage bufferedImage = ((ImageComponent2D)this.texture.getImage(0)).getImage();
                if (bufferedImage.getType() != 1 && bufferedImage.getType() != 2) {
                    BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), this.texture.getFormat() == 6 ? 2 : 1);
                    Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
                    graphics2D.drawImage(bufferedImage, null, 0, 0);
                    graphics2D.dispose();
                    bufferedImage = bufferedImage2;
                }
                nArray = (int[])bufferedImage.getRaster().getDataElements(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
                this.transparent = bufferedImage.getTransparency() != 1;
                if (this.transparent.booleanValue()) {
                    this.transparent = this.containsTransparentPixels(nArray);
                }
                this.imageBits = new WeakReference<int[]>(nArray);
            }
            return nArray;
        }

        private int getImageBitsHashCode() {
            if (this.imageBitsHashCode == null) {
                this.imageBitsHashCode = Arrays.hashCode(this.getImageBits());
            }
            return this.imageBitsHashCode;
        }

        private boolean containsTransparentPixels(int[] nArray) {
            boolean bl = false;
            for (int n : nArray) {
                if ((n & 0xFF000000) == -16777216) continue;
                bl = true;
                break;
            }
            return bl;
        }

        public boolean isTransparent() {
            if (this.transparent == null) {
                this.getImageBits();
            }
            return this.transparent;
        }

        public boolean equalsImage(ComparableTexture comparableTexture) {
            if (this == comparableTexture) {
                return true;
            }
            if (this.texture == comparableTexture.texture) {
                return true;
            }
            if (this.getImageBitsHashCode() == comparableTexture.getImageBitsHashCode()) {
                return Arrays.equals(this.getImageBits(), comparableTexture.getImageBits());
            }
            return false;
        }
    }

    private static class RotatedContentKey {
        private Content content;
        private float angle;

        public RotatedContentKey(Content content, float f) {
            this.content = content;
            this.angle = f;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof RotatedContentKey) {
                RotatedContentKey rotatedContentKey = (RotatedContentKey)object;
                return this.content.equals(rotatedContentKey.content) && this.angle == rotatedContentKey.angle;
            }
            return false;
        }

        public int hashCode() {
            return this.content.hashCode() + Float.floatToIntBits(this.angle);
        }
    }

    public static interface TextureObserver {
        public void textureUpdated(Texture var1);
    }
}

