/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.jcodings.Encoding;
import org.jcodings.specific.EUCJPEncoding;
import org.jcodings.specific.SJISEncoding;
import org.jruby.RubyBignum;
import org.jruby.RubyRegexp;
import org.jruby.ast.AliasNode;
import org.jruby.ast.AndNode;
import org.jruby.ast.ArgsCatNode;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgsPushNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.BeginNode;
import org.jruby.ast.BignumNode;
import org.jruby.ast.BinaryOperatorNode;
import org.jruby.ast.BlockArgNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.CaseNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon2ConstNode;
import org.jruby.ast.Colon2ImplicitNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.ComplexNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DRegexpNode;
import org.jruby.ast.DStrNode;
import org.jruby.ast.DSymbolNode;
import org.jruby.ast.DefinedNode;
import org.jruby.ast.DotNode;
import org.jruby.ast.EvStrNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.FalseNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.FlipNode;
import org.jruby.ast.FloatNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.HashNode;
import org.jruby.ast.IArgumentNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.KeywordArgNode;
import org.jruby.ast.KeywordRestArgNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.Match2CaptureNode;
import org.jruby.ast.Match2Node;
import org.jruby.ast.Match3Node;
import org.jruby.ast.MatchNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NilImplicitNode;
import org.jruby.ast.NilNode;
import org.jruby.ast.Node;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.NumericNode;
import org.jruby.ast.OpAsgnConstDeclNode;
import org.jruby.ast.OpAsgnNode;
import org.jruby.ast.OpElementAsgnNode;
import org.jruby.ast.OrNode;
import org.jruby.ast.RationalNode;
import org.jruby.ast.RegexpNode;
import org.jruby.ast.RescueBodyNode;
import org.jruby.ast.RescueModNode;
import org.jruby.ast.RestArgNode;
import org.jruby.ast.RootNode;
import org.jruby.ast.SValueNode;
import org.jruby.ast.SplatNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.SuperNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.TrueNode;
import org.jruby.ast.UndefNode;
import org.jruby.ast.WhenNode;
import org.jruby.ast.WhenOneArgNode;
import org.jruby.ast.YieldNode;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.types.INameNode;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.coverage.CoverageData;
import org.jruby.lexer.LexingCommon;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.ISourcePositionHolder;
import org.jruby.lexer.yacc.RubyLexer;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.parser.ArgsTailHolder;
import org.jruby.parser.ParserConfiguration;
import org.jruby.parser.RubyParserResult;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Signature;
import org.jruby.util.ByteList;
import org.jruby.util.KeyValuePair;
import org.jruby.util.RegexpOptions;
import org.jruby.util.StringSupport;
import org.jruby.util.cli.Options;

public class ParserSupport {
    protected StaticScope currentScope;
    protected RubyLexer lexer;
    private int inSingleton;
    private boolean inDefinition;
    protected IRubyWarnings warnings;
    protected ParserConfiguration configuration;
    private RubyParserResult result;

    public void reset() {
        this.inSingleton = 0;
        this.inDefinition = false;
    }

    public StaticScope getCurrentScope() {
        return this.currentScope;
    }

    public ParserConfiguration getConfiguration() {
        return this.configuration;
    }

    public void popCurrentScope() {
        if (!this.currentScope.isBlockScope()) {
            this.lexer.getCmdArgumentState().reset(this.currentScope.getCommandArgumentStack());
        }
        this.currentScope = this.currentScope.getEnclosingScope();
    }

    public void pushBlockScope() {
        this.currentScope = this.configuration.getRuntime().getStaticScopeFactory().newBlockScope(this.currentScope, this.lexer.getFile());
    }

    public void pushLocalScope() {
        this.currentScope = this.configuration.getRuntime().getStaticScopeFactory().newLocalScope(this.currentScope, this.lexer.getFile());
        this.currentScope.setCommandArgumentStack(this.lexer.getCmdArgumentState().getStack());
        this.lexer.getCmdArgumentState().reset(0L);
    }

    public Node arg_concat(ISourcePosition position, Node node1, Node node2) {
        return node2 == null ? node1 : new ArgsCatNode(position, node1, node2);
    }

    public Node arg_blk_pass(Node firstNode, BlockPassNode secondNode) {
        if (secondNode != null) {
            secondNode.setArgsNode(firstNode);
            return secondNode;
        }
        return firstNode;
    }

    public Node gettable2(Node node) {
        switch (node.getNodeType()) {
            case DASGNNODE: 
            case LOCALASGNNODE: {
                String name2 = ((INameNode)((Object)node)).getName();
                if (name2.equals(this.lexer.getCurrentArg())) {
                    this.warn(IRubyWarnings.ID.AMBIGUOUS_ARGUMENT, node.getPosition(), "circular argument reference - " + name2, new Object[0]);
                }
                return this.currentScope.declare(node.getPosition(), name2);
            }
            case CONSTDECLNODE: {
                return new ConstNode(node.getPosition(), ((INameNode)((Object)node)).getName());
            }
            case INSTASGNNODE: {
                return new InstVarNode(node.getPosition(), ((INameNode)((Object)node)).getName());
            }
            case CLASSVARDECLNODE: 
            case CLASSVARASGNNODE: {
                return new ClassVarNode(node.getPosition(), ((INameNode)((Object)node)).getName());
            }
            case GLOBALASGNNODE: {
                return new GlobalVarNode(node.getPosition(), ((INameNode)((Object)node)).getName());
            }
        }
        this.getterIdentifierError(node.getPosition(), ((INameNode)((Object)node)).getName());
        return null;
    }

    public Node declareIdentifier(String name2) {
        if (name2.equals(this.lexer.getCurrentArg())) {
            this.warn(IRubyWarnings.ID.AMBIGUOUS_ARGUMENT, this.lexer.getPosition(), "circular argument reference - " + name2, new Object[0]);
        }
        return this.currentScope.declare(this.lexer.tokline, name2);
    }

    public AssignableNode assignableLabelOrIdentifier(String name2, Node value2) {
        return this.currentScope.assign(this.lexer.getPosition(), name2.intern(), this.makeNullNil(value2));
    }

    public AssignableNode assignableLabel(String name2, Node value2) {
        return this.currentScope.assign(this.lexer.getPosition(), name2, this.makeNullNil(value2));
    }

    protected void getterIdentifierError(ISourcePosition position, String identifier) {
        this.lexer.compile_error(SyntaxException.PID.BAD_IDENTIFIER, "identifier " + identifier + " is not valid to get");
    }

    public Node newline_node(Node node, ISourcePosition position) {
        if (node == null) {
            return null;
        }
        this.configuration.coverLine(position.getLine());
        node.setNewline();
        return node;
    }

    public Node addRootNode(Node topOfAST) {
        ISourcePosition position;
        int endPosition = this.lexer.isEndSeen() ? this.lexer.getLineOffset() : -1;
        CoverageData coverageData = this.configuration.finishCoverage(this.lexer.getFile(), this.lexer.lineno());
        if (this.result.getBeginNodes().isEmpty()) {
            if (topOfAST == null) {
                topOfAST = NilImplicitNode.NIL;
                position = this.lexer.getPosition();
            } else {
                position = topOfAST.getPosition();
            }
        } else {
            position = topOfAST != null ? topOfAST.getPosition() : this.result.getBeginNodes().get(0).getPosition();
            BlockNode newTopOfAST = new BlockNode(position);
            for (Node beginNode : this.result.getBeginNodes()) {
                this.appendToBlock(newTopOfAST, beginNode);
            }
            if (topOfAST != null) {
                newTopOfAST.add(topOfAST);
            }
            topOfAST = newTopOfAST;
        }
        return new RootNode(position, this.result.getScope(), topOfAST, this.lexer.getFile(), endPosition, coverageData != null);
    }

    public Node appendToBlock(Node head, Node tail) {
        if (tail == null) {
            return head;
        }
        if (head == null) {
            return tail;
        }
        if (!(head instanceof BlockNode)) {
            head = new BlockNode(head.getPosition()).add(head);
        }
        if (this.warnings.isVerbose() && this.isBreakStatement(((ListNode)head).getLast()) && Options.PARSER_WARN_NOT_REACHED.load().booleanValue()) {
            this.warnings.warning(IRubyWarnings.ID.STATEMENT_NOT_REACHED, tail.getPosition(), "statement not reached");
        }
        ((ListNode)head).addAll(tail);
        return head;
    }

    public AssignableNode assignableInCurr(String name2, Node value2) {
        this.currentScope.addVariableThisScope(name2);
        return this.currentScope.assign(this.lexer.getPosition(), name2, this.makeNullNil(value2));
    }

    public Node getOperatorCallNode(Node firstNode, String operator) {
        this.checkExpression(firstNode);
        return new CallNode(firstNode.getPosition(), firstNode, operator, null, null);
    }

    public Node getOperatorCallNode(Node firstNode, String operator, Node secondNode) {
        return this.getOperatorCallNode(firstNode, operator, secondNode, null);
    }

    public Node getOperatorCallNode(Node firstNode, String operator, Node secondNode, ISourcePosition defaultPosition) {
        if (defaultPosition != null) {
            firstNode = this.checkForNilNode(firstNode, defaultPosition);
            secondNode = this.checkForNilNode(secondNode, defaultPosition);
        }
        this.checkExpression(firstNode);
        this.checkExpression(secondNode);
        return new CallNode(firstNode.getPosition(), firstNode, operator, new ArrayNode(secondNode.getPosition(), secondNode), null);
    }

    public Node getMatchNode(Node firstNode, Node secondNode) {
        if (firstNode instanceof DRegexpNode) {
            return new Match2Node(firstNode.getPosition(), firstNode, secondNode);
        }
        if (firstNode instanceof RegexpNode) {
            List<Integer> locals = this.allocateNamedLocals((RegexpNode)firstNode);
            if (locals.size() > 0) {
                int[] primitiveLocals = new int[locals.size()];
                for (int i2 = 0; i2 < primitiveLocals.length; ++i2) {
                    primitiveLocals[i2] = locals.get(i2);
                }
                return new Match2CaptureNode(firstNode.getPosition(), firstNode, secondNode, primitiveLocals);
            }
            return new Match2Node(firstNode.getPosition(), firstNode, secondNode);
        }
        if (secondNode instanceof DRegexpNode || secondNode instanceof RegexpNode) {
            return new Match3Node(firstNode.getPosition(), firstNode, secondNode);
        }
        return this.getOperatorCallNode(firstNode, "=~", secondNode);
    }

    public Node aryset(Node receiver2, Node index2) {
        this.checkExpression(receiver2);
        return this.new_attrassign(receiver2.getPosition(), receiver2, "[]=", index2, false);
    }

    public Node attrset(Node receiver2, String name2) {
        return this.attrset(receiver2, ".", name2);
    }

    public Node attrset(Node receiver2, String callType, String name2) {
        this.checkExpression(receiver2);
        return this.new_attrassign(receiver2.getPosition(), receiver2, name2 + "=", null, this.isLazy(callType));
    }

    public void backrefAssignError(Node node) {
        if (node instanceof NthRefNode) {
            String varName = "$" + ((NthRefNode)node).getMatchNumber();
            this.lexer.compile_error(SyntaxException.PID.INVALID_ASSIGNMENT, "Can't set variable " + varName + '.');
        } else if (node instanceof BackRefNode) {
            String varName = "$" + ((BackRefNode)node).getType();
            this.lexer.compile_error(SyntaxException.PID.INVALID_ASSIGNMENT, "Can't set variable " + varName + '.');
        }
    }

    public Node arg_add(ISourcePosition position, Node node1, Node node2) {
        if (node1 == null) {
            if (node2 == null) {
                return new ArrayNode(position, NilImplicitNode.NIL);
            }
            return new ArrayNode(node2.getPosition(), node2);
        }
        if (node1 instanceof ArrayNode) {
            return ((ArrayNode)node1).add(node2);
        }
        return new ArgsPushNode(position, node1, node2);
    }

    public Node node_assign(Node lhs, Node rhs) {
        if (lhs == null) {
            return null;
        }
        Node newNode = lhs;
        this.checkExpression(rhs);
        if (lhs instanceof AssignableNode) {
            ((AssignableNode)lhs).setValueNode(rhs);
        } else if (lhs instanceof IArgumentNode) {
            IArgumentNode invokableNode = (IArgumentNode)((Object)lhs);
            return invokableNode.setArgsNode(this.arg_add(lhs.getPosition(), invokableNode.getArgsNode(), rhs));
        }
        return newNode;
    }

    public Node ret_args(Node node, ISourcePosition position) {
        if (node != null) {
            if (node instanceof BlockPassNode) {
                this.lexer.compile_error(SyntaxException.PID.BLOCK_ARG_UNEXPECTED, "block argument should not be given");
            } else if (node instanceof ArrayNode && ((ArrayNode)node).size() == 1) {
                node = ((ArrayNode)node).get(0);
            } else if (node instanceof SplatNode) {
                node = this.newSValueNode(position, node);
            }
        }
        if (node == null) {
            node = NilImplicitNode.NIL;
        }
        return node;
    }

    public boolean isBreakStatement(Node node) {
        if (node == null) {
            return false;
        }
        switch (node.getNodeType()) {
            case BREAKNODE: 
            case NEXTNODE: 
            case REDONODE: 
            case RETRYNODE: 
            case RETURNNODE: {
                return true;
            }
        }
        return false;
    }

    public void warnUnlessEOption(IRubyWarnings.ID id2, Node node, String message2) {
        if (!this.configuration.isInlineSource()) {
            this.warnings.warn(id2, node.getPosition(), message2);
        }
    }

    public void warningUnlessEOption(IRubyWarnings.ID id2, Node node, String message2) {
        if (this.warnings.isVerbose() && !this.configuration.isInlineSource()) {
            this.warnings.warning(id2, node.getPosition(), message2);
        }
    }

    public boolean checkExpression(Node node) {
        boolean conditional = false;
        block7: while (node != null) {
            switch (node.getNodeType()) {
                case BREAKNODE: 
                case NEXTNODE: 
                case REDONODE: 
                case RETRYNODE: 
                case RETURNNODE: {
                    if (!conditional) {
                        this.lexer.compile_error(SyntaxException.PID.VOID_VALUE_EXPRESSION, "void value expression");
                    }
                    return false;
                }
                case BLOCKNODE: {
                    node = ((BlockNode)node).getLast();
                    continue block7;
                }
                case BEGINNODE: {
                    node = ((BeginNode)node).getBodyNode();
                    continue block7;
                }
                case IFNODE: {
                    if (!this.checkExpression(((IfNode)node).getThenBody())) {
                        return false;
                    }
                    node = ((IfNode)node).getElseBody();
                    continue block7;
                }
                case ANDNODE: 
                case ORNODE: {
                    conditional = true;
                    node = ((BinaryOperatorNode)((Object)node)).getSecondNode();
                    continue block7;
                }
            }
            return true;
        }
        return true;
    }

    public boolean isLiteral(Node node) {
        return node != null && (node instanceof FixnumNode || node instanceof BignumNode || node instanceof FloatNode || node instanceof SymbolNode || node instanceof RegexpNode && ((RegexpNode)node).getOptions().toJoniOptions() == 0);
    }

    private void handleUselessWarn(Node node, String useless) {
        if (Options.PARSER_WARN_USELESSS_USE_OF.load().booleanValue()) {
            this.warnings.warn(IRubyWarnings.ID.USELESS_EXPRESSION, node.getPosition(), "Useless use of " + useless + " in void context.");
        }
    }

    public void checkUselessStatement(Node node) {
        if (!this.warnings.isVerbose() || !this.configuration.isInlineSource() && this.configuration.isEvalParse()) {
            return;
        }
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case CALLNODE: {
                String name2 = ((CallNode)node).getName();
                if (name2 == "+" || name2 == "-" || name2 == "*" || name2 == "/" || name2 == "%" || name2 == "**" || name2 == "+@" || name2 == "-@" || name2 == "|" || name2 == "^" || name2 == "&" || name2 == "<=>" || name2 == ">" || name2 == ">=" || name2 == "<" || name2 == "<=" || name2 == "==" || name2 == "!=") {
                    this.handleUselessWarn(node, name2);
                }
                return;
            }
            case BACKREFNODE: 
            case DVARNODE: 
            case GLOBALVARNODE: 
            case LOCALVARNODE: 
            case NTHREFNODE: 
            case CLASSVARNODE: 
            case INSTVARNODE: {
                this.handleUselessWarn(node, "a variable");
                return;
            }
            case BIGNUMNODE: 
            case DREGEXPNODE: 
            case DSTRNODE: 
            case DSYMBOLNODE: 
            case FIXNUMNODE: 
            case FLOATNODE: 
            case REGEXPNODE: 
            case STRNODE: 
            case SYMBOLNODE: {
                this.handleUselessWarn(node, "a literal");
                return;
            }
            case DOTNODE: {
                this.handleUselessWarn(node, ((DotNode)node).isExclusive() ? "..." : "..");
                return;
            }
            case DEFINEDNODE: {
                this.handleUselessWarn(node, "defined?");
                return;
            }
            case FALSENODE: {
                this.handleUselessWarn(node, "false");
                return;
            }
            case NILNODE: {
                this.handleUselessWarn(node, "nil");
                return;
            }
            case TRUENODE: {
                this.handleUselessWarn(node, "true");
                return;
            }
        }
    }

    public void checkUselessStatements(BlockNode blockNode) {
        if (this.warnings.isVerbose()) {
            Node lastNode = blockNode.getLast();
            for (int i2 = 0; i2 < blockNode.size(); ++i2) {
                Node currentNode = blockNode.get(i2);
                if (lastNode == currentNode) continue;
                this.checkUselessStatement(currentNode);
            }
        }
    }

    private boolean checkAssignmentInCondition(Node node) {
        if (node instanceof MultipleAsgnNode) {
            this.lexer.compile_error(SyntaxException.PID.MULTIPLE_ASSIGNMENT_IN_CONDITIONAL, "multiple assignment in conditional");
        } else if (node instanceof LocalAsgnNode || node instanceof DAsgnNode || node instanceof GlobalAsgnNode || node instanceof InstAsgnNode) {
            Node valueNode = ((AssignableNode)node).getValueNode();
            if (this.isStaticContent(valueNode)) {
                this.warnings.warn(IRubyWarnings.ID.ASSIGNMENT_IN_CONDITIONAL, node.getPosition(), "found = in conditional, should be ==");
            }
            return true;
        }
        return false;
    }

    private boolean isStaticContent(Node node) {
        if (node instanceof HashNode) {
            HashNode hash2 = (HashNode)node;
            for (KeyValuePair<Node, Node> pair : hash2.getPairs()) {
                if (this.isStaticContent(pair.getKey()) && this.isStaticContent(pair.getValue())) continue;
                return false;
            }
            return true;
        }
        if (node instanceof ArrayNode) {
            ArrayNode array = (ArrayNode)node;
            int size2 = array.size();
            for (int i2 = 0; i2 < size2; ++i2) {
                if (this.isStaticContent(array.get(i2))) continue;
                return false;
            }
            return true;
        }
        return node instanceof ILiteralNode || node instanceof NilNode || node instanceof TrueNode || node instanceof FalseNode;
    }

    protected Node makeNullNil(Node node) {
        return node == null ? NilImplicitNode.NIL : node;
    }

    private Node cond0(Node node) {
        this.checkAssignmentInCondition(node);
        if (node == null) {
            return new NilNode(this.lexer.getPosition());
        }
        switch (node.getNodeType()) {
            case DREGEXPNODE: {
                ISourcePosition position = node.getPosition();
                return new Match2Node(position, node, new GlobalVarNode(position, "$_"));
            }
            case ANDNODE: {
                Node leftNode = this.cond0(((AndNode)node).getFirstNode());
                Node rightNode = this.cond0(((AndNode)node).getSecondNode());
                return new AndNode(node.getPosition(), this.makeNullNil(leftNode), this.makeNullNil(rightNode));
            }
            case ORNODE: {
                Node leftNode = this.cond0(((OrNode)node).getFirstNode());
                Node rightNode = this.cond0(((OrNode)node).getSecondNode());
                return new OrNode(node.getPosition(), this.makeNullNil(leftNode), this.makeNullNil(rightNode));
            }
            case DOTNODE: {
                DotNode dotNode = (DotNode)node;
                if (dotNode.isLiteral()) {
                    return node;
                }
                String label2 = String.valueOf("FLIP" + node.hashCode());
                this.currentScope.getLocalScope().addVariable(label2);
                int slot = this.currentScope.isDefined(label2);
                return new FlipNode(node.getPosition(), this.getFlipConditionNode(((DotNode)node).getBeginNode()), this.getFlipConditionNode(((DotNode)node).getEndNode()), dotNode.isExclusive(), slot);
            }
            case REGEXPNODE: {
                if (Options.PARSER_WARN_REGEX_CONDITION.load().booleanValue()) {
                    this.warningUnlessEOption(IRubyWarnings.ID.REGEXP_LITERAL_IN_CONDITION, node, "regex literal in condition");
                }
                return new MatchNode(node.getPosition(), node);
            }
        }
        return node;
    }

    public Node getConditionNode(Node node) {
        Node cond = this.cond0(node);
        cond.setNewline();
        return cond;
    }

    private Node getFlipConditionNode(Node node) {
        if (!this.configuration.isInlineSource()) {
            return node;
        }
        if ((node = this.getConditionNode(node)) instanceof FixnumNode) {
            this.warnUnlessEOption(IRubyWarnings.ID.LITERAL_IN_CONDITIONAL_RANGE, node, "integer literal in conditional range");
            return this.getOperatorCallNode(node, "==", new GlobalVarNode(node.getPosition(), "$."));
        }
        return node;
    }

    public SValueNode newSValueNode(ISourcePosition position, Node node) {
        return new SValueNode(position, node);
    }

    public SplatNode newSplatNode(ISourcePosition position, Node node) {
        return new SplatNode(position, this.makeNullNil(node));
    }

    public ArrayNode newArrayNode(ISourcePosition position, Node firstNode) {
        return new ArrayNode(position, this.makeNullNil(firstNode));
    }

    public ISourcePosition position(ISourcePositionHolder one, ISourcePositionHolder two) {
        return one == null ? two.getPosition() : one.getPosition();
    }

    public AndNode newAndNode(ISourcePosition position, Node left2, Node right) {
        this.checkExpression(left2);
        if (left2 == null && right == null) {
            return new AndNode(position, this.makeNullNil(left2), this.makeNullNil(right));
        }
        return new AndNode(this.position(left2, right), this.makeNullNil(left2), this.makeNullNil(right));
    }

    public OrNode newOrNode(ISourcePosition position, Node left2, Node right) {
        this.checkExpression(left2);
        if (left2 == null && right == null) {
            return new OrNode(position, this.makeNullNil(left2), this.makeNullNil(right));
        }
        return new OrNode(this.position(left2, right), this.makeNullNil(left2), this.makeNullNil(right));
    }

    public CaseNode newCaseNode(ISourcePosition position, Node expression, Node firstWhenNode) {
        ArrayNode cases = new ArrayNode(firstWhenNode != null ? firstWhenNode.getPosition() : position);
        CaseNode caseNode = new CaseNode(position, expression, cases);
        Node current2 = firstWhenNode;
        while (current2 != null) {
            if (current2 instanceof WhenOneArgNode) {
                cases.add(current2);
            } else if (current2 instanceof WhenNode) {
                this.simplifyMultipleArgumentWhenNodes((WhenNode)current2, cases);
            } else {
                caseNode.setElseNode(current2);
                break;
            }
            current2 = ((WhenNode)current2).getNextCase();
        }
        return caseNode;
    }

    private void simplifyMultipleArgumentWhenNodes(WhenNode sourceWhen, ArrayNode cases) {
        Node expressionNodes = sourceWhen.getExpressionNodes();
        if (expressionNodes instanceof SplatNode || expressionNodes instanceof ArgsCatNode) {
            cases.add(sourceWhen);
            return;
        }
        if (expressionNodes instanceof ListNode) {
            ListNode list2 = (ListNode)expressionNodes;
            ISourcePosition position = sourceWhen.getPosition();
            Node bodyNode = sourceWhen.getBodyNode();
            for (int i2 = 0; i2 < list2.size(); ++i2) {
                Node expression = list2.get(i2);
                if (expression instanceof SplatNode || expression instanceof ArgsCatNode) {
                    cases.add(new WhenNode(position, expression, bodyNode, null));
                    continue;
                }
                cases.add(new WhenOneArgNode(position, expression, bodyNode, null));
            }
        } else {
            cases.add(sourceWhen);
        }
    }

    public WhenNode newWhenNode(ISourcePosition position, Node expressionNodes, Node bodyNode, Node nextCase) {
        Node element;
        if (bodyNode == null) {
            bodyNode = NilImplicitNode.NIL;
        }
        if (expressionNodes instanceof SplatNode || expressionNodes instanceof ArgsCatNode || expressionNodes instanceof ArgsPushNode) {
            return new WhenNode(position, expressionNodes, bodyNode, nextCase);
        }
        ListNode list2 = (ListNode)expressionNodes;
        if (list2.size() == 1 && !((element = list2.get(0)) instanceof SplatNode)) {
            return new WhenOneArgNode(position, element, bodyNode, nextCase);
        }
        return new WhenNode(position, expressionNodes, bodyNode, nextCase);
    }

    public Node new_opElementAsgnNode(Node receiverNode, String operatorName, Node argsNode, Node valueNode) {
        ISourcePosition position = this.lexer.tokline;
        OpElementAsgnNode newNode = new OpElementAsgnNode(position, receiverNode, operatorName, argsNode, valueNode);
        this.fixpos(newNode, receiverNode);
        return newNode;
    }

    public Node newOpAsgn(ISourcePosition position, Node receiverNode, String callType, Node valueNode, String variableName, String operatorName) {
        return new OpAsgnNode(position, receiverNode, valueNode, variableName, operatorName, this.isLazy(callType));
    }

    public Node newOpConstAsgn(ISourcePosition position, Node lhs, String operatorName, Node rhs) {
        if (lhs != null) {
            return new OpAsgnConstDeclNode(position, lhs, operatorName, rhs);
        }
        return new BeginNode(position, NilImplicitNode.NIL);
    }

    public boolean isLazy(String callType) {
        return "&.".equals(callType);
    }

    public Node new_attrassign(ISourcePosition position, Node receiver2, String name2, Node args2, boolean isLazy) {
        return new AttrAssignNode(position, receiver2, name2, args2, isLazy);
    }

    private boolean isNumericOperator(String name2) {
        if (name2.length() == 1) {
            switch (name2.charAt(0)) {
                case '*': 
                case '+': 
                case '-': 
                case '/': 
                case '<': 
                case '>': {
                    return true;
                }
            }
        } else if (name2.length() == 2) {
            switch (name2.charAt(0)) {
                case '<': 
                case '=': 
                case '>': {
                    switch (name2.charAt(1)) {
                        case '<': 
                        case '=': {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    public Node new_call(Node receiver2, String callType, String name2, Node argsNode, Node iter) {
        if (argsNode instanceof BlockPassNode) {
            if (iter != null) {
                this.lexer.compile_error(SyntaxException.PID.BLOCK_ARG_AND_BLOCK_GIVEN, "Both block arg and actual block given.");
            }
            BlockPassNode blockPass = (BlockPassNode)argsNode;
            return new CallNode(this.position(receiver2, argsNode), receiver2, name2, blockPass.getArgsNode(), blockPass, this.isLazy(callType));
        }
        return new CallNode(this.position(receiver2, argsNode), receiver2, name2, argsNode, iter, this.isLazy(callType));
    }

    public Node new_call(Node receiver2, String name2, Node argsNode, Node iter) {
        return this.new_call(receiver2, ".", name2, argsNode, iter);
    }

    public Colon2Node new_colon2(ISourcePosition position, Node leftNode, String name2) {
        if (leftNode == null) {
            return new Colon2ImplicitNode(position, name2);
        }
        return new Colon2ConstNode(position, leftNode, name2);
    }

    public Colon3Node new_colon3(ISourcePosition position, String name2) {
        return new Colon3Node(position, name2);
    }

    public void frobnicate_fcall_args(FCallNode fcall, Node args2, Node iter) {
        if (args2 instanceof BlockPassNode) {
            if (iter != null) {
                this.lexer.compile_error(SyntaxException.PID.BLOCK_ARG_AND_BLOCK_GIVEN, "Both block arg and actual block given.");
            }
            BlockPassNode blockPass = (BlockPassNode)args2;
            args2 = blockPass.getArgsNode();
            iter = blockPass;
        }
        fcall.setArgsNode(args2);
        fcall.setIterNode(iter);
    }

    public void fixpos(Node node, Node orig) {
        if (node == null || orig == null) {
            return;
        }
        node.setPosition(orig.getPosition());
    }

    public Node new_fcall(String operation) {
        return new FCallNode(this.lexer.tokline, operation);
    }

    public Node new_super(ISourcePosition position, Node args2) {
        if (args2 != null && args2 instanceof BlockPassNode) {
            return new SuperNode(position, ((BlockPassNode)args2).getArgsNode(), args2);
        }
        return new SuperNode(position, args2);
    }

    public void initTopLocalVariables() {
        DynamicScope scope = this.configuration.getScope(this.lexer.getFile());
        this.currentScope = scope.getStaticScope();
        this.result.setScope(scope);
    }

    public boolean isInSingle() {
        return this.inSingleton != 0;
    }

    public void setInSingle(int inSingle) {
        this.inSingleton = inSingle;
    }

    public boolean isInDef() {
        return this.inDefinition;
    }

    public void setInDef(boolean inDef) {
        this.inDefinition = inDef;
    }

    public int getInSingle() {
        return this.inSingleton;
    }

    public RubyParserResult getResult() {
        return this.result;
    }

    public void setResult(RubyParserResult result2) {
        this.result = result2;
    }

    public void setConfiguration(ParserConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setWarnings(IRubyWarnings warnings) {
        this.warnings = warnings;
    }

    public void setLexer(RubyLexer lexer) {
        this.lexer = lexer;
    }

    public DStrNode createDStrNode(ISourcePosition position) {
        DStrNode dstr = new DStrNode(position, this.lexer.getEncoding());
        if (this.getConfiguration().isFrozenStringLiteral()) {
            dstr.setFrozen(true);
        }
        return dstr;
    }

    public KeyValuePair<Node, Node> createKeyValue(Node key2, Node value2) {
        if (key2 != null && key2 instanceof StrNode) {
            ((StrNode)key2).setFrozen(true);
        }
        return new KeyValuePair<Node, Node>(key2, value2);
    }

    public Node asSymbol(ISourcePosition position, String value2) {
        return new SymbolNode(position, value2, this.lexer.getEncoding(), this.lexer.getTokenCR());
    }

    public Node asSymbol(ISourcePosition position, Node value2) {
        return value2 instanceof StrNode ? new SymbolNode(position, ((StrNode)value2).getValue()) : new DSymbolNode(position, (DStrNode)value2);
    }

    public Node literal_concat(ISourcePosition position, Node head, Node tail) {
        if (head == null) {
            return tail;
        }
        if (tail == null) {
            return head;
        }
        if (head instanceof EvStrNode) {
            head = this.createDStrNode(head.getPosition()).add(head);
        }
        if (this.lexer.getHeredocIndent() > 0) {
            if (head instanceof StrNode) {
                head = this.createDStrNode(head.getPosition()).add(head);
                return this.list_append(head, tail);
            }
            if (head instanceof DStrNode) {
                return this.list_append(head, tail);
            }
        }
        if (tail instanceof StrNode) {
            if (head instanceof StrNode) {
                StrNode front = (StrNode)head;
                if (front.getValue().getRealSize() > 0) {
                    return new StrNode(head.getPosition(), front, (StrNode)tail);
                }
                return tail;
            }
            head.setPosition(head.getPosition());
            return ((ListNode)head).add(tail);
        }
        if (tail instanceof DStrNode) {
            if (head instanceof StrNode) {
                DStrNode newDStr = new DStrNode(head.getPosition(), ((DStrNode)tail).getEncoding());
                newDStr.add(head);
                newDStr.addAll(tail);
                if (this.getConfiguration().isFrozenStringLiteral()) {
                    newDStr.setFrozen(true);
                }
                return newDStr;
            }
            return ((ListNode)head).addAll(tail);
        }
        if (head instanceof StrNode) {
            head = ((StrNode)head).getValue().length() == 0 ? this.createDStrNode(head.getPosition()) : this.createDStrNode(head.getPosition()).add(head);
        }
        return ((DStrNode)head).add(tail);
    }

    public Node newRescueModNode(Node body, Node rescueBody) {
        if (rescueBody == null) {
            rescueBody = NilImplicitNode.NIL;
        }
        ISourcePosition pos2 = this.getPosition(body);
        return new RescueModNode(pos2, body, new RescueBodyNode(pos2, null, rescueBody, null));
    }

    public Node newEvStrNode(ISourcePosition position, Node node) {
        if (node instanceof StrNode || node instanceof DStrNode || node instanceof EvStrNode) {
            return node;
        }
        return new EvStrNode(position, node);
    }

    public Node new_yield(ISourcePosition position, Node node) {
        if (node != null && node instanceof BlockPassNode) {
            this.lexer.compile_error(SyntaxException.PID.BLOCK_ARG_UNEXPECTED, "Block argument should not be given.");
        }
        return new YieldNode(position, node);
    }

    public NumericNode negateInteger(NumericNode integerNode) {
        if (integerNode instanceof FixnumNode) {
            FixnumNode fixnumNode = (FixnumNode)integerNode;
            fixnumNode.setValue(-fixnumNode.getValue());
            return fixnumNode;
        }
        if (integerNode instanceof BignumNode) {
            BignumNode bignumNode = (BignumNode)integerNode;
            BigInteger value2 = bignumNode.getValue().negate();
            if (value2.compareTo(RubyBignum.LONG_MIN) >= 0) {
                return new FixnumNode(bignumNode.getPosition(), value2.longValue());
            }
            bignumNode.setValue(value2);
        }
        return integerNode;
    }

    public FloatNode negateFloat(FloatNode floatNode) {
        floatNode.setValue(-floatNode.getValue());
        return floatNode;
    }

    public ComplexNode negateComplexNode(ComplexNode complexNode) {
        complexNode.setNumber(this.negateNumeric(complexNode.getNumber()));
        return complexNode;
    }

    public RationalNode negateRational(RationalNode rationalNode) {
        return new RationalNode(rationalNode.getPosition(), -rationalNode.getNumerator(), rationalNode.getDenominator());
    }

    private Node checkForNilNode(Node node, ISourcePosition defaultPosition) {
        return node == null ? new NilNode(defaultPosition) : node;
    }

    public Node new_args(ISourcePosition position, ListNode pre, ListNode optional, RestArgNode rest2, ListNode post, ArgsTailHolder tail) {
        ArgsNode argsNode = tail == null ? new ArgsNode(position, pre, optional, rest2, post, null) : new ArgsNode(position, pre, optional, rest2, post, tail.getKeywordArgs(), tail.getKeywordRestArgNode(), tail.getBlockArg());
        this.getCurrentScope().setSignature(Signature.from(argsNode));
        return argsNode;
    }

    public ArgsTailHolder new_args_tail(ISourcePosition position, ListNode keywordArg, String keywordRestArgName, BlockArgNode blockArg) {
        if (keywordRestArgName == null) {
            return new ArgsTailHolder(position, keywordArg, null, blockArg);
        }
        String restKwargsName = keywordRestArgName;
        int slot = this.currentScope.exists(restKwargsName);
        if (slot == -1) {
            slot = this.currentScope.addVariable(restKwargsName);
        }
        KeywordRestArgNode keywordRestArg = new KeywordRestArgNode(position, restKwargsName, slot);
        return new ArgsTailHolder(position, keywordArg, keywordRestArg, blockArg);
    }

    public Node remove_duplicate_keys(HashNode hash2) {
        ArrayList<Node> encounteredKeys = new ArrayList<Node>();
        for (KeyValuePair<Node, Node> pair : hash2.getPairs()) {
            Node key2 = pair.getKey();
            if (key2 == null) continue;
            int index2 = encounteredKeys.indexOf(key2);
            if (index2 >= 0) {
                this.warn(IRubyWarnings.ID.AMBIGUOUS_ARGUMENT, hash2.getPosition(), "key " + key2 + " is duplicated and overwritten on line " + (((Node)encounteredKeys.get(index2)).getLine() + 1), new Object[0]);
                continue;
            }
            encounteredKeys.add(key2);
        }
        return hash2;
    }

    public Node newAlias(ISourcePosition position, Node newNode, Node oldNode) {
        return new AliasNode(position, newNode, oldNode);
    }

    public Node newUndef(ISourcePosition position, Node nameNode) {
        return new UndefNode(position, nameNode);
    }

    public void yyerror(String message2) {
        this.lexer.compile_error(SyntaxException.PID.GRAMMAR_ERROR, message2);
    }

    public void yyerror(String message2, String[] expected, String found) {
        this.lexer.compile_error(SyntaxException.PID.GRAMMAR_ERROR, message2 + ", unexpected " + found + "\n");
    }

    public ISourcePosition getPosition(ISourcePositionHolder start2) {
        return start2 != null ? this.lexer.getPosition(start2.getPosition()) : this.lexer.getPosition();
    }

    public void warn(IRubyWarnings.ID id2, ISourcePosition position, String message2, Object ... data2) {
        this.warnings.warn(id2, position, message2);
    }

    public void warning(IRubyWarnings.ID id2, ISourcePosition position, String message2, Object ... data2) {
        if (this.warnings.isVerbose()) {
            this.warnings.warning(id2, position, message2);
        }
    }

    public boolean is_local_id(String name2) {
        return this.lexer.isIdentifierChar(name2.charAt(0));
    }

    public ListNode list_append(Node list2, Node item) {
        if (list2 == null) {
            return new ArrayNode(item.getPosition(), item);
        }
        if (!(list2 instanceof ListNode)) {
            return new ArrayNode(list2.getPosition(), list2).add(item);
        }
        return ((ListNode)list2).add(item);
    }

    public Node new_bv(String identifier) {
        if (!this.is_local_id(identifier)) {
            this.getterIdentifierError(this.lexer.getPosition(), identifier);
        }
        this.shadowing_lvar(identifier);
        return this.arg_var(identifier);
    }

    public ArgumentNode arg_var(String name2) {
        StaticScope current2 = this.getCurrentScope();
        if (name2 == "_") {
            int count2 = 0;
            while (current2.exists(name2) >= 0) {
                name2 = ("_$" + count2++).intern();
            }
        }
        return new ArgumentNode(this.lexer.getPosition(), name2, current2.addVariableThisScope(name2));
    }

    public String formal_argument(String identifier) {
        this.lexer.validateFormalIdentifier(identifier);
        return this.shadowing_lvar(identifier);
    }

    public String shadowing_lvar(String name2) {
        if (name2 == "_") {
            return name2;
        }
        StaticScope current2 = this.getCurrentScope();
        if (current2.isBlockScope()) {
            if (current2.exists(name2) >= 0) {
                this.yyerror("duplicated argument name");
            }
            if (this.warnings.isVerbose() && current2.isDefined(name2) >= 0 && Options.PARSER_WARN_LOCAL_SHADOWING.load().booleanValue() && !ParserSupport.skipTruffleRubiniusWarnings(this.lexer)) {
                this.warnings.warning(IRubyWarnings.ID.STATEMENT_NOT_REACHED, this.lexer.getPosition(), "shadowing outer local variable - " + name2);
            }
        } else if (current2.exists(name2) >= 0) {
            this.yyerror("duplicated argument name");
        }
        return name2;
    }

    public ListNode list_concat(Node first2, Node second) {
        if (first2 instanceof ListNode) {
            if (second instanceof ListNode) {
                return ((ListNode)first2).addAll((ListNode)second);
            }
            return ((ListNode)first2).addAll(second);
        }
        return new ArrayNode(first2.getPosition(), first2).add(second);
    }

    public Node splat_array(Node node) {
        if (node instanceof SplatNode) {
            node = ((SplatNode)node).getValue();
        }
        if (node instanceof ArrayNode) {
            return node;
        }
        return null;
    }

    public Node arg_append(Node node1, Node node2) {
        if (node1 == null) {
            return new ArrayNode(node2.getPosition(), node2);
        }
        if (node1 instanceof ListNode) {
            return ((ListNode)node1).add(node2);
        }
        if (node1 instanceof BlockPassNode) {
            return this.arg_append(((BlockPassNode)node1).getBodyNode(), node2);
        }
        if (node1 instanceof ArgsPushNode) {
            ArgsPushNode pushNode = (ArgsPushNode)node1;
            Node body = pushNode.getSecondNode();
            return new ArgsCatNode(pushNode.getPosition(), pushNode.getFirstNode(), new ArrayNode(body.getPosition(), body).add(node2));
        }
        return new ArgsPushNode(this.position(node1, node2), node1, node2);
    }

    public void regexpFragmentCheck(RegexpNode end2, ByteList value2) {
        this.setRegexpEncoding(end2, value2);
        try {
            RubyRegexp.preprocessCheck(this.configuration.getRuntime(), value2);
        }
        catch (RaiseException re) {
            this.compile_error(re.getMessage());
        }
    }

    private List<Integer> allocateNamedLocals(RegexpNode regexpNode) {
        RubyRegexp pattern = RubyRegexp.newRegexp(this.configuration.getRuntime(), regexpNode.getValue(), regexpNode.getOptions());
        pattern.setLiteral();
        String[] names2 = pattern.getNames();
        int length2 = names2.length;
        ArrayList<Integer> locals = new ArrayList<Integer>();
        StaticScope scope = this.getCurrentScope();
        for (int i2 = 0; i2 < length2; ++i2) {
            if (RubyLexer.getKeyword(names2[i2]) != null || Character.isUpperCase(names2[i2].charAt(0))) continue;
            int slot = scope.isDefined(names2[i2]);
            if (slot >= 0) {
                if (this.warnings.isVerbose() && !scope.isNamedCapture(slot)) {
                    this.warn(IRubyWarnings.ID.AMBIGUOUS_ARGUMENT, this.getPosition(regexpNode), "named capture conflicts a local variable - " + names2[i2], new Object[0]);
                }
                locals.add(slot);
                continue;
            }
            locals.add(this.getCurrentScope().addNamedCaptureVariable(names2[i2]));
        }
        return locals;
    }

    private boolean is7BitASCII(ByteList value2) {
        return StringSupport.codeRangeScan(value2.getEncoding(), value2) == 16;
    }

    private char optionsEncodingChar(Encoding optionEncoding) {
        if (optionEncoding == LexingCommon.USASCII_ENCODING) {
            return 'n';
        }
        if (optionEncoding == EUCJPEncoding.INSTANCE) {
            return 'e';
        }
        if (optionEncoding == SJISEncoding.INSTANCE) {
            return 's';
        }
        if (optionEncoding == LexingCommon.UTF8_ENCODING) {
            return 'u';
        }
        return ' ';
    }

    public void compile_error(String message2) {
        String line = this.lexer.getCurrentLine();
        ISourcePosition position = this.lexer.getPosition();
        String errorMessage = this.lexer.getFile() + ":" + (position.getLine() + 1) + ": ";
        if (line != null && line.length() > 5) {
            boolean addNewline = message2 != null && !message2.endsWith("\n");
            message2 = message2 + (addNewline ? "\n" : "") + line;
        }
        throw this.getConfiguration().getRuntime().newSyntaxError(errorMessage + message2);
    }

    protected void compileError(Encoding optionEncoding, Encoding encoding2) {
        this.lexer.compile_error(SyntaxException.PID.REGEXP_ENCODING_MISMATCH, "regexp encoding option '" + this.optionsEncodingChar(optionEncoding) + "' differs from source encoding '" + encoding2 + "'");
    }

    public void setRegexpEncoding(RegexpNode end2, ByteList value2) {
        RegexpOptions options2 = end2.getOptions();
        Encoding optionsEncoding = options2.setup(this.configuration.getRuntime());
        if (optionsEncoding != null) {
            if (optionsEncoding != value2.getEncoding() && !this.is7BitASCII(value2)) {
                this.compileError(optionsEncoding, value2.getEncoding());
            }
            value2.setEncoding(optionsEncoding);
        } else if (options2.isEncodingNone()) {
            if (value2.getEncoding() == LexingCommon.ASCII8BIT_ENCODING && !this.is7BitASCII(value2)) {
                this.compileError(optionsEncoding, value2.getEncoding());
            }
            value2.setEncoding(LexingCommon.ASCII8BIT_ENCODING);
        } else if (this.lexer.getEncoding() == LexingCommon.USASCII_ENCODING) {
            if (!this.is7BitASCII(value2)) {
                value2.setEncoding(LexingCommon.USASCII_ENCODING);
            } else {
                value2.setEncoding(LexingCommon.ASCII8BIT_ENCODING);
            }
        }
    }

    protected void checkRegexpSyntax(ByteList value2, RegexpOptions options2) {
        String stringValue = value2.toString();
        if (stringValue.startsWith("(?u)") || stringValue.startsWith("(?a)") || stringValue.startsWith("(?d)")) {
            return;
        }
        try {
            RubyRegexp.newRegexpParser(this.getConfiguration().getRuntime(), value2, (RegexpOptions)options2.clone());
        }
        catch (RaiseException re) {
            this.compile_error(re.getMessage());
        }
    }

    public Node newRegexpNode(ISourcePosition position, Node contents, RegexpNode end2) {
        RegexpOptions options2 = end2.getOptions();
        Encoding encoding2 = this.lexer.getEncoding();
        if (contents == null) {
            ByteList newValue = ByteList.create("");
            if (encoding2 != null) {
                newValue.setEncoding(encoding2);
            }
            this.regexpFragmentCheck(end2, newValue);
            return new RegexpNode(position, newValue, options2.withoutOnce());
        }
        if (contents instanceof StrNode) {
            ByteList meat = (ByteList)((StrNode)contents).getValue().clone();
            this.regexpFragmentCheck(end2, meat);
            this.checkRegexpSyntax(meat, options2.withoutOnce());
            return new RegexpNode(contents.getPosition(), meat, options2.withoutOnce());
        }
        if (contents instanceof DStrNode) {
            DStrNode dStrNode = (DStrNode)contents;
            for (int i2 = 0; i2 < dStrNode.size(); ++i2) {
                Node fragment = dStrNode.get(i2);
                if (!(fragment instanceof StrNode)) continue;
                ByteList frag = ((StrNode)fragment).getValue();
                this.regexpFragmentCheck(end2, frag);
            }
            DRegexpNode dRegexpNode = new DRegexpNode(position, options2, encoding2);
            dRegexpNode.add(new StrNode(contents.getPosition(), this.createMaster(options2)));
            dRegexpNode.addAll(dStrNode);
            return dRegexpNode;
        }
        ByteList master = this.createMaster(options2);
        this.regexpFragmentCheck(end2, master);
        encoding2 = master.getEncoding();
        DRegexpNode node = new DRegexpNode(position, options2, encoding2);
        node.add(new StrNode(contents.getPosition(), master));
        node.add(contents);
        return node;
    }

    private ByteList createMaster(RegexpOptions options2) {
        Encoding encoding2 = options2.setup(this.configuration.getRuntime());
        return new ByteList(ByteList.NULL_ARRAY, encoding2);
    }

    public static int associateEncoding(ByteList buffer, Encoding newEncoding, int codeRange) {
        Encoding bufferEncoding = buffer.getEncoding();
        if (newEncoding == bufferEncoding) {
            return codeRange;
        }
        buffer.setEncoding(newEncoding);
        if (codeRange != 16 || !newEncoding.isAsciiCompatible()) {
            return 0;
        }
        return codeRange;
    }

    public KeywordArgNode keyword_arg(ISourcePosition position, AssignableNode assignable) {
        return new KeywordArgNode(position, assignable);
    }

    public NumericNode negateNumeric(NumericNode node) {
        switch (node.getNodeType()) {
            case BIGNUMNODE: 
            case FIXNUMNODE: {
                return this.negateInteger(node);
            }
            case COMPLEXNODE: {
                return this.negateComplexNode((ComplexNode)node);
            }
            case FLOATNODE: {
                return this.negateFloat((FloatNode)node);
            }
            case RATIONALNODE: {
                return this.negateRational((RationalNode)node);
            }
        }
        this.yyerror("Invalid or unimplemented numeric to negate: " + node.toString());
        return null;
    }

    public Node new_defined(ISourcePosition position, Node something) {
        return new DefinedNode(position, something);
    }

    public String internalId() {
        return "";
    }

    public static boolean skipTruffleRubiniusWarnings(RubyLexer lexer) {
        return lexer.getFile().startsWith(Options.TRUFFLE_CORE_LOAD_PATH.load());
    }
}

