/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.ext.openssl.CipherStrings;
import org.jruby.ext.openssl.OpenSSL;
import org.jruby.ext.openssl.PKey;
import org.jruby.ext.openssl.SSL;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.ext.openssl.StringHelper;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.X509;
import org.jruby.ext.openssl.X509Cert;
import org.jruby.ext.openssl.X509Store;
import org.jruby.ext.openssl.x509store.Certificate;
import org.jruby.ext.openssl.x509store.Name;
import org.jruby.ext.openssl.x509store.Store;
import org.jruby.ext.openssl.x509store.StoreContext;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;
import org.jruby.ext.openssl.x509store.X509Object;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class SSLContext
extends RubyObject {
    private static final long serialVersionUID = -6955774230685920773L;
    private static final HashMap<String, String> SSL_VERSION_OSSL2JSSE = new LinkedHashMap<String, String>(20, 1.0f);
    private static final Map<String, String[]> ENABLED_PROTOCOLS = new HashMap<String, String[]>(8, 1.0f);
    private static ObjectAllocator SSLCONTEXT_ALLOCATOR;
    static final int SESSION_CACHE_OFF = 0;
    static final int SESSION_CACHE_CLIENT = 1;
    static final int SESSION_CACHE_SERVER = 2;
    static final int SESSION_CACHE_BOTH = 3;
    static final int SESSION_CACHE_NO_AUTO_CLEAR = 128;
    static final int SESSION_CACHE_NO_INTERNAL_LOOKUP = 256;
    static final int SESSION_CACHE_NO_INTERNAL_STORE = 512;
    static final int SESSION_CACHE_NO_INTERNAL = 768;
    private String ciphers = "AES:ALL:!aNULL:!eNULL:+RC4:@STRENGTH";
    private String protocol = "SSL";
    private boolean protocolForServer = true;
    private boolean protocolForClient = true;
    private PKey t_key;
    private X509Cert t_cert;
    private int verifyResult = 1;
    private int sessionCacheSize;
    private InternalContext internalContext;
    private static String cachedProtocol;
    private static String[] cachedSupportedCipherSuites;
    private static final byte[] TLSv1;
    private static final byte[] SSLv2;
    private static final byte[] SSLv3;

    public static void createSSLContext(Ruby runtime, RubyModule SSL2) {
        RubyClass SSLContext2 = SSL2.defineClassUnder("SSLContext", runtime.getObject(), SSLCONTEXT_ALLOCATOR);
        ThreadContext context2 = runtime.getCurrentContext();
        SSLContext2.addReadWriteAttribute(context2, "cert");
        SSLContext2.addReadWriteAttribute(context2, "key");
        SSLContext2.addReadWriteAttribute(context2, "client_ca");
        SSLContext2.addReadWriteAttribute(context2, "ca_file");
        SSLContext2.addReadWriteAttribute(context2, "ca_path");
        SSLContext2.addReadWriteAttribute(context2, "timeout");
        SSLContext2.addReadWriteAttribute(context2, "verify_mode");
        SSLContext2.addReadWriteAttribute(context2, "verify_depth");
        SSLContext2.addReadWriteAttribute(context2, "verify_callback");
        SSLContext2.addReadWriteAttribute(context2, "options");
        SSLContext2.addReadWriteAttribute(context2, "cert_store");
        SSLContext2.addReadWriteAttribute(context2, "extra_chain_cert");
        SSLContext2.addReadWriteAttribute(context2, "client_cert_cb");
        SSLContext2.addReadWriteAttribute(context2, "session_id_context");
        SSLContext2.addReadWriteAttribute(context2, "tmp_dh_callback");
        SSLContext2.addReadWriteAttribute(context2, "servername_cb");
        SSLContext2.defineAlias("ssl_timeout", "timeout");
        SSLContext2.defineAlias("ssl_timeout=", "timeout=");
        SSLContext2.defineAnnotatedMethods(SSLContext.class);
        Set<String> methodKeys = SSL_VERSION_OSSL2JSSE.keySet();
        RubyArray methods = runtime.newArray(methodKeys.size());
        for (String method : methodKeys) {
            if (method.equals("SSLv2") || method.startsWith("SSLv2_") || method.indexOf(46) != -1) continue;
            methods.append((IRubyObject)runtime.newSymbol(method));
        }
        SSLContext2.defineConstant("METHODS", (IRubyObject)methods);
        SSLContext2.setConstant("SESSION_CACHE_OFF", (IRubyObject)runtime.newFixnum(0));
        SSLContext2.setConstant("SESSION_CACHE_CLIENT", (IRubyObject)runtime.newFixnum(1));
        SSLContext2.setConstant("SESSION_CACHE_SERVER", (IRubyObject)runtime.newFixnum(2));
        SSLContext2.setConstant("SESSION_CACHE_BOTH", (IRubyObject)runtime.newFixnum(3));
        SSLContext2.setConstant("SESSION_CACHE_NO_AUTO_CLEAR", (IRubyObject)runtime.newFixnum(128));
        SSLContext2.setConstant("SESSION_CACHE_NO_INTERNAL_LOOKUP", (IRubyObject)runtime.newFixnum(256));
        SSLContext2.setConstant("SESSION_CACHE_NO_INTERNAL_STORE", (IRubyObject)runtime.newFixnum(512));
        SSLContext2.setConstant("SESSION_CACHE_NO_INTERNAL", (IRubyObject)runtime.newFixnum(768));
        X509Store DEFAULT_CERT_STORE = X509Store.newStore(runtime);
        DEFAULT_CERT_STORE.set_default_paths(context2);
        IRubyObject V_FLAG_CRL_CHECK_ALL = X509._X509(runtime).getConstantAt("V_FLAG_CRL_CHECK_ALL");
        if (V_FLAG_CRL_CHECK_ALL != null) {
            DEFAULT_CERT_STORE.set_flags(V_FLAG_CRL_CHECK_ALL);
        }
        SSLContext2.setConstant("DEFAULT_CERT_STORE", (IRubyObject)DEFAULT_CERT_STORE);
        RubyHash DEFAULT_PARAMS = new RubyHash(runtime);
        RubyString ssl_version2 = StringHelper.newString(runtime, new byte[]{83, 83, 76, 118, 50, 51});
        DEFAULT_PARAMS.op_aset(context2, (IRubyObject)runtime.newSymbol("ssl_version"), (IRubyObject)ssl_version2);
        RubyFixnum verify_mode = runtime.newFixnum(1);
        DEFAULT_PARAMS.op_aset(context2, (IRubyObject)runtime.newSymbol("verify_mode"), (IRubyObject)verify_mode);
        RubyString ciphers2 = StringHelper.newString(runtime, new byte[]{65, 76, 76, 58, 33, 65, 68, 72, 58, 33, 69, 88, 80, 79, 82, 84, 58, 33, 83, 83, 76, 118, 50, 58, 82, 67, 52, 43, 82, 83, 65, 58, 43, 72, 73, 71, 72, 58, 43, 77, 69, 68, 73, 85, 77, 58, 43, 76, 79, 87});
        DEFAULT_PARAMS.op_aset(context2, (IRubyObject)runtime.newSymbol("ciphers"), (IRubyObject)ciphers2);
        RubyFixnum options = runtime.newFixnum(4095L);
        DEFAULT_PARAMS.op_aset(context2, (IRubyObject)runtime.newSymbol("options"), (IRubyObject)options);
        SSLContext2.setConstant("DEFAULT_PARAMS", (IRubyObject)DEFAULT_PARAMS);
    }

    public SSLContext(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    SSLContext(Ruby runtime) {
        super(runtime, SSLContext._SSLContext(runtime));
    }

    @JRubyMethod(required=0, optional=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args) {
        if (args.length > 0) {
            this.set_ssl_version(args[0]);
        }
        return this.initializeImpl();
    }

    final SSLContext initializeImpl() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public IRubyObject setup(ThreadContext context2) {
        ArrayList<X509AuxCertificate> extraChainCert;
        List<Object> clientCert;
        X509Cert cert2;
        PKey key;
        Ruby runtime = context2.runtime;
        if (this.isFrozen()) {
            return runtime.getNil();
        }
        SSLContext sSLContext = this;
        synchronized (sSLContext) {
            if (this.isFrozen()) {
                return runtime.getNil();
            }
            this.freeze(context2);
        }
        X509Store certStore = this.getCertStore();
        IRubyObject value2 = this.getInstanceVariable("@key");
        if (value2 != null && !value2.isNil()) {
            if (!(value2 instanceof PKey)) {
                throw runtime.newTypeError("OpenSSL::PKey::PKey expected but got @key = " + value2.inspect());
            }
            key = (PKey)value2;
        } else {
            key = this.getCallbackKey(context2);
        }
        value2 = this.getInstanceVariable("@cert");
        if (value2 != null && !value2.isNil()) {
            if (!(value2 instanceof X509Cert)) {
                throw runtime.newTypeError("OpenSSL::X509::Certificate expected but got @cert = " + value2.inspect());
            }
            cert2 = (X509Cert)value2;
        } else {
            cert2 = this.getCallbackCert(context2);
        }
        value2 = this.getInstanceVariable("@client_ca");
        if (value2 != null && !value2.isNil()) {
            if (value2.respondsTo("each")) {
                List<X509Cert> cCerts = this.convertToX509Certs(context2, value2);
                clientCert = new ArrayList(cCerts.size());
                for (X509Cert x : cCerts) {
                    clientCert.add(x.getAuxCert());
                }
            } else {
                if (!(value2 instanceof X509Cert)) {
                    throw runtime.newTypeError("OpenSSL::X509::Certificate expected but got @client_ca = " + value2.inspect());
                }
                clientCert = Collections.singletonList(((X509Cert)value2).getAuxCert());
            }
        } else {
            clientCert = Collections.emptyList();
        }
        value2 = this.getInstanceVariable("@extra_chain_cert");
        if (value2 != null && !value2.isNil()) {
            List<X509Cert> eCerts = this.convertToX509Certs(context2, value2);
            extraChainCert = new ArrayList<X509AuxCertificate>(eCerts.size());
            for (X509Cert x : eCerts) {
                extraChainCert.add(x.getAuxCert());
            }
        } else {
            extraChainCert = null;
        }
        int verifyMode = (value2 = this.getInstanceVariable("@verify_mode")) != null && !value2.isNil() ? RubyNumeric.fix2int((IRubyObject)value2) : 0;
        value2 = this.getInstanceVariable("@timeout");
        int timeout2 = value2 != null && !value2.isNil() ? RubyNumeric.fix2int((IRubyObject)value2) : 0;
        Store store = certStore != null ? certStore.getStore() : new Store();
        String caFile = this.getCaFile();
        String caPath = this.getCaPath();
        if (caFile != null || caPath != null) {
            try {
                if (store.loadLocations(runtime, caFile, caPath) == 0) {
                    runtime.getWarnings().warn(IRubyWarnings.ID.MISCELLANEOUS, "can't set verify locations");
                }
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    OpenSSL.debugStackTrace(runtime, e);
                }
                throw SSL.newSSLError(runtime, e);
            }
        }
        if ((value2 = this.getInstanceVariable("@verify_callback")) != null && !value2.isNil()) {
            store.setExtraData(1, value2);
        } else {
            store.setExtraData(1, null);
        }
        value2 = this.getInstanceVariable("@verify_depth");
        if (value2 != null && !value2.isNil()) {
            store.setDepth(RubyNumeric.fix2int((IRubyObject)value2));
        } else {
            store.setDepth(-1);
        }
        value2 = this.getInstanceVariable("@servername_cb");
        if (value2 == null || !value2.isNil()) {
            // empty if block
        }
        try {
            this.internalContext = new InternalContext(cert2, key, store, clientCert, extraChainCert, verifyMode, timeout2);
        }
        catch (GeneralSecurityException e) {
            throw SSL.newSSLError(runtime, e);
        }
        return runtime.getTrue();
    }

    @JRubyMethod
    public RubyArray ciphers(ThreadContext context2) {
        return this.matchedCiphers(context2);
    }

    private RubyArray matchedCiphers(ThreadContext context2) {
        Ruby runtime = context2.runtime;
        try {
            String[] supported = SSLContext.getSupportedCipherSuites(this.protocol);
            Collection<CipherStrings.Def> cipherDefs = CipherStrings.matchingCiphers(this.ciphers, supported, false);
            RubyArray cipherList = runtime.newArray(cipherDefs.size());
            for (CipherStrings.Def def : cipherDefs) {
                RubyArray cipher2 = runtime.newArray(4);
                cipher2.store(0L, (IRubyObject)StringHelper.newUTF8String(runtime, def.name));
                cipher2.store(1L, (IRubyObject)StringHelper.newUTF8String(runtime, this.sslVersionString(def.algorithms)));
                cipher2.store(2L, (IRubyObject)runtime.newFixnum(def.algStrengthBits));
                cipher2.store(3L, (IRubyObject)runtime.newFixnum(def.algBits));
                cipherList.append((IRubyObject)cipher2);
            }
            return cipherList;
        }
        catch (GeneralSecurityException gse) {
            throw SSL.newSSLError(runtime, gse.getMessage());
        }
    }

    @JRubyMethod(name={"ciphers="})
    public IRubyObject set_ciphers(ThreadContext context2, IRubyObject ciphers2) {
        if (ciphers2.isNil()) {
            this.ciphers = "AES:ALL:!aNULL:!eNULL:+RC4:@STRENGTH";
        } else if (ciphers2 instanceof RubyArray) {
            RubyArray ciphs = (RubyArray)ciphers2;
            StringBuilder cipherStr = new StringBuilder();
            String sep = "";
            for (int i2 = 0; i2 < ciphs.size(); ++i2) {
                cipherStr.append(sep).append(ciphs.eltInternal(i2).toString());
                sep = ":";
            }
            this.ciphers = cipherStr.toString();
        } else {
            this.ciphers = ciphers2.asString().toString();
            if ("DEFAULT".equals(this.ciphers)) {
                this.ciphers = "AES:ALL:!aNULL:!eNULL:+RC4:@STRENGTH";
            }
        }
        if (this.matchedCiphers(context2).isEmpty()) {
            throw SSL.newSSLError(context2.runtime, "no cipher match");
        }
        return ciphers2;
    }

    @JRubyMethod(name={"ssl_version="})
    public IRubyObject set_ssl_version(IRubyObject version2) {
        String versionStr = version2 instanceof RubySymbol ? version2.toString() : version2.convertToString().toString();
        String protocol = SSL_VERSION_OSSL2JSSE.get(versionStr);
        if (protocol == null) {
            throw this.getRuntime().newArgumentError("unknown SSL method `" + versionStr + "'");
        }
        this.protocol = protocol;
        this.protocolForServer = !versionStr.endsWith("_client");
        this.protocolForClient = !versionStr.endsWith("_server");
        return version2;
    }

    final String getProtocol() {
        return this.protocol;
    }

    @JRubyMethod(optional=1)
    public IRubyObject set_params(final ThreadContext context2, IRubyObject[] args) {
        RubyClass SSLContext2 = SSLContext._SSLContext(context2.runtime);
        RubyHash DEFAULT_PARAMS = (RubyHash)SSLContext2.getConstantAt("DEFAULT_PARAMS");
        RubyHash params2 = args.length == 0 ? DEFAULT_PARAMS : (RubyHash)DEFAULT_PARAMS.callMethod(context2, "merge", args[0]);
        final SSLContext self = this;
        params2.visitAll(new RubyHash.Visitor(){

            public void visit(IRubyObject name2, IRubyObject value2) {
                self.callMethod(context2, name2.toString() + '=', value2);
            }
        });
        IRubyObject verify_mode = self.getInstanceVariable("@verify_mode");
        if (!(verify_mode == null || verify_mode.isNil() || RubyNumeric.fix2int((IRubyObject)verify_mode) == 0 || Utils.hasNonNilInstanceVariable((IRubyObject)self, "@ca_file") || Utils.hasNonNilInstanceVariable((IRubyObject)self, "@ca_path") || Utils.hasNonNilInstanceVariable((IRubyObject)self, "@cert_store"))) {
            IRubyObject DEFAULT_CERT_STORE = SSLContext2.getConstantAt("DEFAULT_CERT_STORE");
            self.setInstanceVariable("@cert_store", DEFAULT_CERT_STORE);
        }
        return params2;
    }

    @JRubyMethod(name={"session_cache_mode"})
    public IRubyObject session_cache_mode() {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"session_cache_mode="})
    public IRubyObject set_session_cache_mode(IRubyObject mode) {
        OpenSSL.warn(this.getRuntime().getCurrentContext(), "SSLContext#session_cache_mode= has no effect under JRuby");
        return this.session_cache_mode();
    }

    @JRubyMethod(name={"session_cache_size"})
    public IRubyObject session_cache_size() {
        return this.getRuntime().newFixnum(this.sessionCacheSize);
    }

    @JRubyMethod(name={"session_cache_size="})
    public IRubyObject set_session_cache_size(IRubyObject size2) {
        this.sessionCacheSize = RubyInteger.fix2int((IRubyObject)size2);
        return size2;
    }

    @JRubyMethod(name={"session_cache_stats"})
    public RubyHash session_cache_stats(ThreadContext context2) {
        return RubyHash.newHash((Ruby)context2.runtime);
    }

    boolean isProtocolForServer() {
        return this.protocolForServer;
    }

    boolean isProtocolForClient() {
        return this.protocolForClient;
    }

    int getLastVerifyResult() {
        return this.verifyResult;
    }

    void setLastVerifyResult(int verifyResult) {
        this.verifyResult = verifyResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static String[] getSupportedCipherSuites(String protocol) throws GeneralSecurityException {
        if (cachedProtocol == null) {
            Class<SSLContext> clazz = SSLContext.class;
            // MONITORENTER : org.jruby.ext.openssl.SSLContext.class
            if (cachedProtocol == null) {
                cachedSupportedCipherSuites = SSLContext.dummySSLEngine(protocol).getSupportedCipherSuites();
                cachedProtocol = protocol;
                // MONITOREXIT : clazz
                return cachedSupportedCipherSuites;
            }
            // MONITOREXIT : clazz
        }
        if (!protocol.equals(cachedProtocol)) return SSLContext.dummySSLEngine(protocol).getSupportedCipherSuites();
        return cachedSupportedCipherSuites;
    }

    private static SSLEngine dummySSLEngine(String protocol) throws GeneralSecurityException {
        javax.net.ssl.SSLContext sslContext = SecurityHelper.getSSLContext(protocol);
        sslContext.init(null, null, null);
        return sslContext.createSSLEngine();
    }

    final SSLEngine createSSLEngine(String peerHost, int peerPort) throws NoSuchAlgorithmException, KeyManagementException {
        SSLEngine engine = peerHost == null || peerHost.length() == 0 ? this.internalContext.getSSLContext().createSSLEngine() : this.internalContext.getSSLContext().createSSLEngine(peerHost, peerPort);
        engine.setEnabledCipherSuites(this.getCipherSuites(engine.getSupportedCipherSuites()));
        engine.setEnabledProtocols(this.getEnabledProtocols(engine));
        return engine;
    }

    private String[] getCipherSuites(String[] supported) {
        Collection<CipherStrings.Def> cipherDefs = CipherStrings.matchingCiphers(this.ciphers, supported, true);
        String[] result = new String[cipherDefs.size()];
        int i2 = 0;
        for (CipherStrings.Def def : cipherDefs) {
            result[i2++] = def.getCipherSuite();
        }
        return result;
    }

    private String[] getEnabledProtocols(SSLEngine engine) {
        String[] enabledProtocols = ENABLED_PROTOCOLS.get(this.protocol);
        if (enabledProtocols != null) {
            long options = this.getOptions();
            String[] engineProtocols = engine.getEnabledProtocols();
            ArrayList<String> protocols = new ArrayList<String>(enabledProtocols.length);
            for (String enabled : enabledProtocols) {
                if ((options & 0x1000000L) != 0L && enabled.equals("SSLv2") || (options & 0x2000000L) != 0L && enabled.equals("SSLv3") || (options & 0x4000000L) != 0L && enabled.equals("TLSv1")) continue;
                for (String allowed : engineProtocols) {
                    if (!allowed.equals(enabled)) continue;
                    protocols.add(allowed);
                }
            }
            return protocols.toArray(new String[protocols.size()]);
        }
        return new String[0];
    }

    private ByteList sslVersionString(long bits) {
        ByteList str = new ByteList(18);
        boolean first = true;
        if ((bits & 0x2000000L) != 0L) {
            if (!first) {
                str.append(47);
            }
            first = false;
            str.append(TLSv1);
            str.append(47);
            str.append(SSLv3);
        }
        if ((bits & 0x1000000L) != 0L) {
            if (!first) {
                str.append(47);
            }
            str.append(SSLv2);
        }
        return str;
    }

    private PKey getCallbackKey(ThreadContext context2) {
        if (this.t_key != null) {
            return this.t_key;
        }
        this.initFromCallback(context2);
        return this.t_key;
    }

    private X509Cert getCallbackCert(ThreadContext context2) {
        if (this.t_cert != null) {
            return this.t_cert;
        }
        this.initFromCallback(context2);
        return this.t_cert;
    }

    private void initFromCallback(ThreadContext context2) {
        IRubyObject callback = this.getInstanceVariable("@client_cert_cb");
        if (callback != null && !callback.isNil()) {
            IRubyObject arr = callback.callMethod(context2, "call", (IRubyObject)this);
            if (!(arr instanceof RubyArray)) {
                throw context2.runtime.newTypeError("expected @client_cert_cb.call to return an Array but got: " + arr.getMetaClass().getName());
            }
            IRubyObject cert2 = ((RubyArray)arr).entry(0);
            IRubyObject key = ((RubyArray)arr).entry(1);
            if (!(cert2 instanceof X509Cert)) {
                throw context2.runtime.newTypeError(cert2.inspect() + " is not an instance of OpenSSL::X509::Certificate");
            }
            if (!(key instanceof PKey)) {
                throw context2.runtime.newTypeError(key.inspect() + " is not an instance of OpenSSL::PKey::PKey");
            }
            this.t_cert = (X509Cert)cert2;
            this.t_key = (PKey)key;
        }
    }

    private X509Store getCertStore() {
        IRubyObject cert_store = this.getInstanceVariable("@cert_store");
        if (cert_store instanceof X509Store) {
            return (X509Store)cert_store;
        }
        return null;
    }

    private String getCaFile() {
        IRubyObject ca_file = this.getInstanceVariable("@ca_file");
        if (ca_file != null && !ca_file.isNil()) {
            return ca_file.asString().toString();
        }
        return null;
    }

    private String getCaPath() {
        IRubyObject ca_path = this.getInstanceVariable("@ca_path");
        if (ca_path != null && !ca_path.isNil()) {
            return ca_path.asString().toString();
        }
        return null;
    }

    private long getOptions() {
        IRubyObject options = this.getInstanceVariable("@options");
        if (options != null && !options.isNil()) {
            return RubyNumeric.fix2long((IRubyObject)options);
        }
        return 0L;
    }

    private List<X509Cert> convertToX509Certs(ThreadContext context2, IRubyObject value2) {
        ArrayList<X509Cert> result = new ArrayList<X509Cert>();
        RubyClass SSLContext2 = SSLContext._SSLContext(context2.runtime);
        RubyClass Certificate2 = X509Cert._Certificate(context2.runtime);
        Utils.invoke(context2, value2, "each", CallBlock.newCallClosure((IRubyObject)value2, (RubyModule)SSLContext2, (Arity)Arity.NO_ARGUMENTS, (BlockCallback)new BlockCallback((RubyModule)Certificate2, result){
            final /* synthetic */ RubyModule val$Certificate;
            final /* synthetic */ ArrayList val$result;
            {
                this.val$Certificate = rubyModule;
                this.val$result = arrayList;
            }

            public IRubyObject call(ThreadContext context2, IRubyObject[] args, Block block) {
                IRubyObject cert2 = args[0];
                if (!this.val$Certificate.isInstance(cert2)) {
                    throw context2.runtime.newTypeError("wrong argument : " + cert2.inspect() + " is not a " + this.val$Certificate.getName());
                }
                this.val$result.add((X509Cert)cert2);
                return context2.nil;
            }
        }, (ThreadContext)context2));
        return result;
    }

    static RubyClass _SSLContext(Ruby runtime) {
        return (RubyClass)SSL._SSL(runtime).getConstantAt("SSLContext");
    }

    static {
        SSL_VERSION_OSSL2JSSE.put("TLSv1", "TLSv1");
        SSL_VERSION_OSSL2JSSE.put("TLSv1_server", "TLSv1");
        SSL_VERSION_OSSL2JSSE.put("TLSv1_client", "TLSv1");
        ENABLED_PROTOCOLS.put("TLSv1", new String[]{"TLSv1"});
        SSL_VERSION_OSSL2JSSE.put("SSLv2", "SSLv2");
        SSL_VERSION_OSSL2JSSE.put("SSLv2_server", "SSLv2");
        SSL_VERSION_OSSL2JSSE.put("SSLv2_client", "SSLv2");
        ENABLED_PROTOCOLS.put("SSLv2", new String[]{"SSLv2"});
        SSL_VERSION_OSSL2JSSE.put("SSLv3", "SSLv3");
        SSL_VERSION_OSSL2JSSE.put("SSLv3_server", "SSLv3");
        SSL_VERSION_OSSL2JSSE.put("SSLv3_client", "SSLv3");
        ENABLED_PROTOCOLS.put("SSLv3", new String[]{"SSLv3"});
        SSL_VERSION_OSSL2JSSE.put("SSLv23", "SSL");
        SSL_VERSION_OSSL2JSSE.put("SSLv23_server", "SSL");
        SSL_VERSION_OSSL2JSSE.put("SSLv23_client", "SSL");
        if (OpenSSL.javaVersion7(true)) {
            ENABLED_PROTOCOLS.put("SSL", new String[]{"SSLv2", "SSLv3", "TLSv1", "TLSv1.1", "TLSv1.2"});
        } else {
            ENABLED_PROTOCOLS.put("SSL", new String[]{"SSLv2", "SSLv3", "TLSv1"});
        }
        SSL_VERSION_OSSL2JSSE.put("TLS", "TLS");
        ENABLED_PROTOCOLS.put("TLS", new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"});
        SSL_VERSION_OSSL2JSSE.put("TLSv1.1", "TLSv1.1");
        SSL_VERSION_OSSL2JSSE.put("TLSv1_1_server", "TLSv1.1");
        SSL_VERSION_OSSL2JSSE.put("TLSv1_1_client", "TLSv1.1");
        ENABLED_PROTOCOLS.put("TLSv1.1", new String[]{"TLSv1.1"});
        SSL_VERSION_OSSL2JSSE.put("TLSv1_1", "TLSv1.1");
        SSL_VERSION_OSSL2JSSE.put("TLSv1_2", "TLSv1.2");
        ENABLED_PROTOCOLS.put("TLSv1.2", new String[]{"TLSv1.2"});
        SSL_VERSION_OSSL2JSSE.put("TLSv1.2", "TLSv1.2");
        SSL_VERSION_OSSL2JSSE.put("TLSv1_2_server", "TLSv1.2");
        SSL_VERSION_OSSL2JSSE.put("TLSv1_2_client", "TLSv1.2");
        SSLCONTEXT_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new SSLContext(runtime, klass);
            }
        };
        cachedProtocol = null;
        TLSv1 = new byte[]{84, 76, 83, 118, 49};
        SSLv2 = new byte[]{83, 83, 76, 118, 50};
        SSLv3 = new byte[]{83, 83, 76, 118, 51};
    }

    private static class TrustManagerImpl
    implements X509TrustManager {
        final InternalContext internalContext;

        TrustManagerImpl(InternalContext internalContext) {
            this.internalContext = internalContext;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain2, String authType) throws CertificateException {
            this.checkTrusted("ssl_client", chain2);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain2, String authType) throws CertificateException {
            this.checkTrusted("ssl_server", chain2);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            if (this.internalContext == null) {
                return null;
            }
            int size2 = this.internalContext.clientCert.size();
            return this.internalContext.clientCert.toArray(new X509Certificate[size2]);
        }

        private void checkTrusted(String purpose, X509Certificate[] chain2) throws CertificateException {
            if (this.internalContext == null) {
                throw new CertificateException("uninitialized trust manager");
            }
            if (chain2 != null && chain2.length > 0) {
                if ((this.internalContext.verifyMode & 1) != 0) {
                    StoreContext storeContext = this.internalContext.createStoreContext(purpose);
                    if (storeContext == null) {
                        throw new CertificateException("couldn't initialize store");
                    }
                    storeContext.setCertificate(chain2[0]);
                    storeContext.setChain(chain2);
                    this.verifyChain(storeContext);
                }
            } else if ((this.internalContext.verifyMode & 2) != 0) {
                throw new CertificateException("no peer certificate");
            }
        }

        private void verifyChain(StoreContext storeContext) throws CertificateException {
            int ok;
            try {
                ok = storeContext.verifyCertificate();
            }
            catch (Exception e) {
                this.internalContext.setLastVerifyResult(storeContext.error);
                if (storeContext.error == 0) {
                    this.internalContext.setLastVerifyResult(28);
                }
                throw new CertificateException("certificate verify failed", e);
            }
            this.internalContext.setLastVerifyResult(storeContext.error);
            if (ok == 0) {
                throw new CertificateException("certificate verify failed");
            }
        }
    }

    private static class KeyManagerImpl
    extends X509ExtendedKeyManager {
        final InternalContext internalContext;

        KeyManagerImpl(InternalContext internalContext) {
            this.internalContext = internalContext;
        }

        @Override
        public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
            if (this.internalContext == null) {
                return null;
            }
            if (this.internalContext.privateKey == null) {
                return null;
            }
            for (int i2 = 0; i2 < keyType.length; ++i2) {
                if (!keyType[i2].equalsIgnoreCase(this.internalContext.keyAlgorithm)) continue;
                return keyType[i2];
            }
            return null;
        }

        @Override
        public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
            if (this.internalContext == null || this.internalContext.privateKey == null) {
                return null;
            }
            if (keyType.equalsIgnoreCase(this.internalContext.keyAlgorithm)) {
                return keyType;
            }
            return null;
        }

        @Override
        public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
            return null;
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            return null;
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            if (this.internalContext == null) {
                return null;
            }
            ArrayList<X509AuxCertificate> chain2 = new ArrayList<X509AuxCertificate>();
            if (this.internalContext.extraChainCert != null) {
                chain2.addAll(this.internalContext.extraChainCert);
            } else if (this.internalContext.cert != null) {
                StoreContext storeCtx = this.internalContext.createStoreContext(null);
                X509AuxCertificate x = this.internalContext.cert;
                while (true) {
                    chain2.add(x);
                    if (x.getIssuerDN().equals(x.getSubjectDN())) break;
                    try {
                        Name name2 = new Name(x.getIssuerX500Principal());
                        X509Object[] s_obj = new X509Object[1];
                        if (storeCtx.getBySubject(1, name2, s_obj) <= 0) break;
                        x = ((Certificate)s_obj[0]).x509;
                    }
                    catch (RuntimeException e) {
                        OpenSSL.debugStackTrace(e);
                        break;
                    }
                    catch (Exception e) {
                        OpenSSL.debug("KeyManagerImpl bySubject failed", e);
                        break;
                    }
                }
            }
            return chain2.toArray(new X509Certificate[chain2.size()]);
        }

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            return null;
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            if (this.internalContext == null || this.internalContext.privateKey == null) {
                return null;
            }
            return this.internalContext.privateKey;
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            return null;
        }
    }

    private class InternalContext {
        final Store store;
        final X509AuxCertificate cert;
        final String keyAlgorithm;
        final PrivateKey privateKey;
        final int verifyMode;
        final List<X509AuxCertificate> clientCert;
        final List<X509AuxCertificate> extraChainCert;
        private final javax.net.ssl.SSLContext sslContext;

        InternalContext(X509Cert xCert, PKey pKey, Store store, List<X509AuxCertificate> clientCert, List<X509AuxCertificate> extraChainCert, int verifyMode, int timeout2) throws NoSuchAlgorithmException, KeyManagementException {
            if (pKey != null && xCert != null) {
                this.privateKey = pKey.getPrivateKey();
                this.keyAlgorithm = pKey.getAlgorithm();
                this.cert = xCert.getAuxCert();
            } else {
                this.privateKey = null;
                this.keyAlgorithm = null;
                this.cert = null;
            }
            this.store = store;
            this.clientCert = clientCert;
            this.extraChainCert = extraChainCert;
            this.verifyMode = verifyMode;
            javax.net.ssl.SSLContext sslContext = SecurityHelper.getSSLContext(SSLContext.this.protocol);
            if (SSLContext.this.protocolForClient) {
                SSLSessionContext clientContext = sslContext.getClientSessionContext();
                clientContext.setSessionTimeout(timeout2);
                if (SSLContext.this.sessionCacheSize >= 0) {
                    clientContext.setSessionCacheSize(SSLContext.this.sessionCacheSize);
                }
            }
            if (SSLContext.this.protocolForServer) {
                SSLSessionContext serverContext = sslContext.getClientSessionContext();
                serverContext.setSessionTimeout(timeout2);
                if (SSLContext.this.sessionCacheSize >= 0) {
                    serverContext.setSessionCacheSize(SSLContext.this.sessionCacheSize);
                }
            }
            KeyManager[] keyManager = new KeyManager[]{new KeyManagerImpl(this)};
            TrustManager[] trustManager = new TrustManager[]{new TrustManagerImpl(this)};
            sslContext.init(keyManager, trustManager, null);
            this.sslContext = sslContext;
        }

        StoreContext createStoreContext(String purpose) {
            if (this.store == null) {
                return null;
            }
            StoreContext storeContext = new StoreContext(this.store);
            if (storeContext.init(null, null) == 0) {
                return null;
            }
            storeContext.setExtraData(1, this.store.getExtraData(1));
            if (purpose != null) {
                storeContext.setDefault(purpose);
            }
            storeContext.verifyParameter.inherit(this.store.verifyParameter);
            return storeContext;
        }

        final javax.net.ssl.SSLContext getSSLContext() {
            return this.sslContext;
        }

        void setLastVerifyResult(int lastVerifyResult) {
            SSLContext.this.setLastVerifyResult(lastVerifyResult);
        }
    }
}

