/*
 * Decompiled with CFR 0.152.
 */
package org.perl.inline.java;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.HashMap;
import org.perl.inline.java.InlineJavaException;
import org.perl.inline.java.InlineJavaPerlCaller;
import org.perl.inline.java.InlineJavaProtocol;
import org.perl.inline.java.InlineJavaServerThread;
import org.perl.inline.java.InlineJavaUserClassLoader;
import org.perl.inline.java.InlineJavaUtils;

public class InlineJavaServer {
    private static InlineJavaServer instance = null;
    private String host = null;
    private int port = 0;
    private boolean shared_jvm = false;
    private boolean priv = false;
    private boolean native_doubles = false;
    private boolean finished = false;
    private ServerSocket server_socket = null;
    private InlineJavaUserClassLoader ijucl = null;
    private HashMap thread_objects = new HashMap();
    private int objid = 1;
    private boolean jni = false;
    private Thread creator = null;
    private int thread_count = 0;

    private InlineJavaServer(int debug, boolean _native_doubles) {
        this.init(debug, _native_doubles);
        this.jni = true;
        this.AddThread(this.creator);
    }

    public InlineJavaServer(int debug, String _host, int _port, boolean _shared_jvm, boolean _priv, boolean _native_doubles) {
        this.init(debug, _native_doubles);
        this.jni = false;
        this.host = _host;
        this.port = _port;
        this.shared_jvm = _shared_jvm;
        this.priv = _priv;
        try {
            this.server_socket = this.host == null || this.host.equals("") || this.host.equals("ANY") ? new ServerSocket(this.port) : new ServerSocket(this.port, 0, InetAddress.getByName(this.host));
        }
        catch (IOException e) {
            InlineJavaUtils.Fatal("Can't open server socket on port " + String.valueOf(this.port) + ": " + e.getMessage());
        }
    }

    public void RunMainLoop() {
        while (!this.finished) {
            try {
                String name = "IJST-#" + this.thread_count++;
                InlineJavaServerThread ijt = new InlineJavaServerThread(name, this, this.server_socket.accept(), this.priv ? new InlineJavaUserClassLoader() : this.ijucl);
                ijt.start();
                if (this.shared_jvm) continue;
                try {
                    ijt.join();
                }
                catch (InterruptedException interruptedException) {}
                break;
            }
            catch (IOException e) {
                if (this.finished) continue;
                System.err.println("Main Loop IO Error: " + e.getMessage());
                System.err.flush();
            }
        }
    }

    private synchronized void init(int debug, boolean _native_doubles) {
        instance = this;
        this.creator = Thread.currentThread();
        InlineJavaUtils.set_debug(debug);
        this.native_doubles = _native_doubles;
        this.ijucl = new InlineJavaUserClassLoader();
    }

    static InlineJavaServer GetInstance() {
        if (instance == null) {
            InlineJavaUtils.Fatal("No instance of InlineJavaServer has been created!");
        }
        return instance;
    }

    InlineJavaUserClassLoader GetUserClassLoader() {
        Thread t = Thread.currentThread();
        if (t instanceof InlineJavaServerThread) {
            return ((InlineJavaServerThread)t).GetUserClassLoader();
        }
        return this.ijucl;
    }

    String GetType() {
        return this.shared_jvm ? "shared" : "private";
    }

    boolean GetNativeDoubles() {
        return this.native_doubles;
    }

    boolean IsJNI() {
        return this.jni;
    }

    String ProcessCommand(String cmd) {
        return this.ProcessCommand(cmd, true);
    }

    String ProcessCommand(String cmd, boolean addlf) {
        InlineJavaUtils.debug(3, "packet recv is " + cmd);
        String resp = null;
        if (cmd != null) {
            InlineJavaProtocol ijp = new InlineJavaProtocol(this, cmd);
            try {
                ijp.Do();
                InlineJavaUtils.debug(3, "packet sent is " + ijp.GetResponse());
                resp = ijp.GetResponse();
            }
            catch (InlineJavaException e) {
                String err = "error scalar:" + ijp.EncodeFromByteArray(e.getMessage().getBytes());
                InlineJavaUtils.debug(3, "packet sent is " + err);
                resp = err;
            }
        } else if (!this.shared_jvm) {
            InlineJavaUtils.debug(1, "lost connection with client in single client mode. Exiting.");
            System.exit(1);
        } else {
            InlineJavaUtils.debug(1, "lost connection with client in shared JVM mode.");
            return null;
        }
        if (addlf) {
            resp = resp + "\n";
        }
        return resp;
    }

    native String jni_callback(String var1);

    boolean IsThreadPerlContact(Thread t) {
        return this.jni && t == this.creator || !this.jni && t instanceof InlineJavaServerThread;
    }

    synchronized Object GetObject(int id) throws InlineJavaException {
        Object o = null;
        HashMap h = (HashMap)this.thread_objects.get(Thread.currentThread());
        if (h == null) {
            throw new InlineJavaException("Can't find thread " + Thread.currentThread().getName() + "!");
        }
        o = h.get(new Integer(id));
        if (o == null) {
            throw new InlineJavaException("Can't find object " + id + " for thread " + Thread.currentThread().getName());
        }
        return o;
    }

    synchronized int PutObject(Object o) throws InlineJavaException {
        HashMap h = (HashMap)this.thread_objects.get(Thread.currentThread());
        int id = this.objid;
        if (h == null) {
            throw new InlineJavaException("Can't find thread " + Thread.currentThread().getName() + "!");
        }
        h.put(new Integer(this.objid), o);
        ++this.objid;
        return id;
    }

    synchronized Object DeleteObject(int id) throws InlineJavaException {
        Object o = null;
        HashMap h = (HashMap)this.thread_objects.get(Thread.currentThread());
        if (h == null) {
            throw new InlineJavaException("Can't find thread " + Thread.currentThread().getName() + "!");
        }
        o = h.remove(new Integer(id));
        if (o == null) {
            throw new InlineJavaException("Can't find object " + id + " for thread " + Thread.currentThread().getName());
        }
        return o;
    }

    synchronized int ObjectCount() throws InlineJavaException {
        int i = -1;
        HashMap h = (HashMap)this.thread_objects.get(Thread.currentThread());
        if (h == null) {
            throw new InlineJavaException("Can't find thread " + Thread.currentThread().getName() + "!");
        }
        i = h.values().size();
        return i;
    }

    public synchronized void StopMainLoop() {
        if (!this.jni) {
            try {
                this.finished = true;
                this.server_socket.close();
            }
            catch (IOException e) {
                System.err.println("Shutdown IO Error: " + e.getMessage());
                System.err.flush();
            }
        }
    }

    synchronized void Shutdown() {
        this.StopMainLoop();
        System.exit(0);
    }

    synchronized void AddThread(Thread t) {
        this.thread_objects.put(t, new HashMap());
        InlineJavaPerlCaller.AddThread(t);
    }

    synchronized void RemoveThread(InlineJavaServerThread t) {
        this.thread_objects.remove(t);
        InlineJavaPerlCaller.RemoveThread(t);
    }

    public static void main(String[] argv) {
        int debug = Integer.parseInt(argv[0]);
        String host = argv[1];
        int port = Integer.parseInt(argv[2]);
        boolean shared_jvm = new Boolean(argv[3]);
        boolean priv = new Boolean(argv[4]);
        boolean native_doubles = new Boolean(argv[5]);
        InlineJavaServer ijs = new InlineJavaServer(debug, host, port, shared_jvm, priv, native_doubles);
        ijs.RunMainLoop();
        System.exit(0);
    }

    public static InlineJavaServer jni_main(int debug, boolean native_doubles) {
        if (instance != null) {
            InlineJavaUtils.set_debug(debug);
            InlineJavaUtils.debug(1, "recycling InlineJavaServer created by PerlInterpreter");
            return instance;
        }
        return new InlineJavaServer(debug, native_doubles);
    }
}

